/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.MatrixFrameUtils;

import hex.DataInfo;
import hex.gam.GAMModel;
import hex.gam.GamSplines.CubicRegressionSplines;
import hex.gam.MatrixFrameUtils.GamUtils;
import hex.glm.GLMModel;
import hex.util.LinearAlgebraUtils;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class GenerateGamMatrixOneColumn
extends MRTask<GenerateGamMatrixOneColumn> {
    int _splineType;
    public int _numKnots;
    public double[][] _bInvD;
    Frame _gamX;
    double[] _u;
    public double[][] _ZTransp;
    public double[][] _penaltyMat;
    public double[] _knots;
    double[] _maxAbsRowSum;
    double _s_scale;

    public GenerateGamMatrixOneColumn(int splineType, int numKnots, double[] knots, Frame gamx, boolean standardize) {
        this._splineType = splineType;
        this._numKnots = numKnots;
        CubicRegressionSplines crSplines = new CubicRegressionSplines(numKnots, knots);
        this._bInvD = crSplines.gen_BIndvD(crSplines._hj);
        this._penaltyMat = crSplines.gen_penalty_matrix(crSplines._hj, this._bInvD);
        this._gamX = gamx;
        this._knots = knots;
    }

    public void map(Chunk[] chk, NewChunk[] newGamCols) {
        this._maxAbsRowSum = new double[this._gamX.vec(0).nChunks()];
        int cIndex = chk[0].cidx();
        this._maxAbsRowSum[cIndex] = Double.NEGATIVE_INFINITY;
        int chunkRows = chk[0].len();
        CubicRegressionSplines crSplines = new CubicRegressionSplines(this._numKnots, this._knots);
        double[] basisVals = new double[this._numKnots];
        for (int rowIndex = 0; rowIndex < chunkRows; ++rowIndex) {
            double gamRowSum = 0.0;
            double xval = chk[0].atd(rowIndex);
            int binIndex = GamUtils.locateBin(xval, this._knots);
            GenerateGamMatrixOneColumn.updateFMatrixCFunc(basisVals, xval, binIndex, crSplines, this._bInvD);
            GenerateGamMatrixOneColumn.updateAFunc(basisVals, xval, binIndex, crSplines);
            for (int colIndex = 0; colIndex < this._numKnots; ++colIndex) {
                newGamCols[colIndex].addNum(basisVals[colIndex]);
                gamRowSum += Math.abs(basisVals[colIndex]);
            }
            if (!(gamRowSum > this._maxAbsRowSum[cIndex])) continue;
            this._maxAbsRowSum[cIndex] = gamRowSum;
        }
    }

    public void reduce(GenerateGamMatrixOneColumn other) {
        ArrayUtils.add((double[])this._maxAbsRowSum, (double[])other._maxAbsRowSum);
    }

    public void postGlobal() {
        double tempMaxValue = ArrayUtils.maxValue((double[])this._maxAbsRowSum);
        this._s_scale = tempMaxValue * tempMaxValue / ArrayUtils.rNorm((double[][])this._penaltyMat, (char)'i');
        ArrayUtils.mult((double[][])this._penaltyMat, (double)this._s_scale);
        this._s_scale = 1.0 / this._s_scale;
    }

    public void generateZtransp(Frame gamX) {
        this._u = new double[this._numKnots];
        for (int cind = 0; cind < this._numKnots; ++cind) {
            this._u[cind] = gamX.vec(cind).mean();
        }
        this._ZTransp = new double[this._numKnots - 1][this._numKnots];
        double mag = ArrayUtils.innerProduct((double[])this._u, (double[])this._u);
        this._u[0] = this._u[0] - (double)(this._u[0] > 0.0 ? -1 : 1) * Math.sqrt(mag);
        double twoOmagSq = 2.0 / ArrayUtils.innerProduct((double[])this._u, (double[])this._u);
        for (int rowIndex = 0; rowIndex < this._numKnots; ++rowIndex) {
            for (int colIndex = 0; colIndex < this._numKnots; ++colIndex) {
                if (colIndex <= 0) continue;
                this._ZTransp[colIndex - 1][rowIndex] = (double)(colIndex == rowIndex ? 1 : 0) - this._u[rowIndex] * this._u[colIndex] * twoOmagSq;
            }
        }
    }

    public static void updateAFunc(double[] basisVals, double xval, int binIndex, CubicRegressionSplines splines) {
        int jp1 = binIndex + 1;
        int n = binIndex;
        basisVals[n] = basisVals[n] + CubicRegressionSplines.gen_a_m_j(splines._knots[jp1], xval, splines._hj[binIndex]);
        int n2 = jp1;
        basisVals[n2] = basisVals[n2] + CubicRegressionSplines.gen_a_p_j(splines._knots[binIndex], xval, splines._hj[binIndex]);
    }

    public static void updateFMatrixCFunc(double[] basisVals, double xval, int binIndex, CubicRegressionSplines splines, double[][] binvD) {
        int numKnots = basisVals.length;
        int matSize = binvD.length;
        int jp1 = binIndex + 1;
        double cmj = CubicRegressionSplines.gen_c_m_j(splines._knots[jp1], xval, splines._hj[binIndex]);
        double cpj = CubicRegressionSplines.gen_c_p_j(splines._knots[binIndex], xval, splines._hj[binIndex]);
        int binIndexM1 = binIndex - 1;
        for (int index = 0; index < numKnots; ++index) {
            basisVals[index] = binIndex == 0 ? binvD[binIndex][index] * cpj : (binIndex >= matSize ? binvD[binIndexM1][index] * cmj : binvD[binIndexM1][index] * cmj + binvD[binIndex][index] * cpj);
        }
    }

    public Frame centralizeFrame(Frame fr, String colNameStart, GAMModel.GAMParameters parms) {
        int index;
        this.generateZtransp(fr);
        int numCols = fr.numCols();
        int ncolExp = numCols - 1;
        DataInfo frInfo = new DataInfo(fr, null, 0, false, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, GLMModel.GLMParameters.MissingValuesHandling.Skip == parms._missing_values_handling, parms._missing_values_handling == GLMModel.GLMParameters.MissingValuesHandling.MeanImputation || parms._missing_values_handling == GLMModel.GLMParameters.MissingValuesHandling.PlugValues, parms.makeImputer(), false, false, false, false, null);
        for (index = 0; index < ncolExp; ++index) {
            fr.add(colNameStart + "_" + index, fr.anyVec().makeZero());
        }
        new LinearAlgebraUtils.BMulInPlaceTask(frInfo, this._ZTransp, numCols, false).doAll(fr);
        for (index = 0; index < numCols; ++index) {
            Vec temp = fr.remove(0);
            temp.remove();
        }
        return fr;
    }
}

