/*
 * Decompiled with CFR 0.152.
 */
package hex.generic;

import hex.AUC2;
import hex.CustomMetric;
import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsBinomialGLMGeneric;
import hex.ModelMetricsBinomialGeneric;
import hex.ModelMetricsMultinomialGLMGeneric;
import hex.ModelMetricsMultinomialGeneric;
import hex.ModelMetricsOrdinalGLMGeneric;
import hex.ModelMetricsOrdinalGeneric;
import hex.ModelMetricsRegressionGLMGeneric;
import hex.ModelMetricsRegressionGeneric;
import hex.genmodel.attributes.DeepLearningModelAttributes;
import hex.genmodel.attributes.ModelAttributes;
import hex.genmodel.attributes.ModelAttributesGLM;
import hex.genmodel.attributes.SharedTreeModelAttributes;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.VariableImportances;
import hex.genmodel.attributes.metrics.MojoModelMetrics;
import hex.genmodel.attributes.metrics.MojoModelMetricsAnomaly;
import hex.genmodel.attributes.metrics.MojoModelMetricsBinomial;
import hex.genmodel.attributes.metrics.MojoModelMetricsBinomialGLM;
import hex.genmodel.attributes.metrics.MojoModelMetricsMultinomial;
import hex.genmodel.attributes.metrics.MojoModelMetricsMultinomialGLM;
import hex.genmodel.attributes.metrics.MojoModelMetricsOrdinal;
import hex.genmodel.attributes.metrics.MojoModelMetricsOrdinalGLM;
import hex.genmodel.attributes.metrics.MojoModelMetricsRegression;
import hex.genmodel.attributes.metrics.MojoModelMetricsRegressionGLM;
import hex.genmodel.descriptor.ModelDescriptor;
import hex.tree.isofor.ModelMetricsAnomaly;
import java.lang.reflect.Field;
import java.util.HashMap;
import water.util.Log;
import water.util.TwoDimTable;

public class GenericModelOutput
extends Model.Output {
    final String _original_model_identifier;
    final String _original_model_full_name;
    final ModelCategory _modelCategory;
    final int _nfeatures;
    final double _defaultThreshold;
    TwoDimTable _variable_importances;

    public GenericModelOutput(ModelDescriptor modelDescriptor, ModelAttributes modelAttributes) {
        this._isSupervised = modelDescriptor.isSupervised();
        this._domains = modelDescriptor.scoringDomains();
        this._origDomains = modelDescriptor.scoringDomains();
        this._hasOffset = modelDescriptor.offsetColumn() != null;
        this._hasWeights = modelDescriptor.weightsColumn() != null;
        this._hasFold = modelDescriptor.foldColumn() != null;
        this._distribution = modelDescriptor.modelClassDist();
        this._priorClassDist = modelDescriptor.priorClassDist();
        this._names = modelDescriptor.columnNames();
        this._modelCategory = modelDescriptor.getModelCategory();
        this._nfeatures = modelDescriptor.nfeatures();
        this._defaultThreshold = modelDescriptor.defaultThreshold();
        this._original_model_identifier = modelDescriptor.algoName();
        this._original_model_full_name = modelDescriptor.algoFullName();
        if (modelAttributes != null) {
            this._model_summary = GenericModelOutput.convertTable(modelAttributes.getModelSummary());
            this._cross_validation_metrics_summary = GenericModelOutput.convertTable(modelAttributes.getCrossValidationMetricsSummary());
            this._variable_importances = modelAttributes instanceof SharedTreeModelAttributes ? GenericModelOutput.convertVariableImportances(((SharedTreeModelAttributes)modelAttributes).getVariableImportances()) : (modelAttributes instanceof DeepLearningModelAttributes ? GenericModelOutput.convertVariableImportances(((DeepLearningModelAttributes)modelAttributes).getVariableImportances()) : null);
            this.convertMetrics(modelAttributes, modelDescriptor);
            this._scoring_history = GenericModelOutput.convertTable(modelAttributes.getScoringHistory());
        }
    }

    private void convertMetrics(ModelAttributes modelAttributes, ModelDescriptor modelDescriptor) {
        if (modelAttributes.getTrainingMetrics() != null) {
            this._training_metrics = this.convertModelMetrics(modelAttributes.getTrainingMetrics(), modelDescriptor, modelAttributes);
        }
        if (modelAttributes.getValidationMetrics() != null) {
            this._validation_metrics = (ModelMetrics)GenericModelOutput.convertObjects(modelAttributes.getValidationMetrics(), this.convertModelMetrics(modelAttributes.getValidationMetrics(), modelDescriptor, modelAttributes));
        }
        if (modelAttributes.getCrossValidationMetrics() != null) {
            this._cross_validation_metrics = (ModelMetrics)GenericModelOutput.convertObjects(modelAttributes.getCrossValidationMetrics(), this.convertModelMetrics(modelAttributes.getCrossValidationMetrics(), modelDescriptor, modelAttributes));
        }
    }

    private ModelMetrics convertModelMetrics(MojoModelMetrics mojoMetrics, ModelDescriptor modelDescriptor, ModelAttributes modelAttributes) {
        ModelCategory modelCategory = modelDescriptor.getModelCategory();
        switch (modelCategory) {
            case Binomial: {
                assert (mojoMetrics instanceof MojoModelMetricsBinomial);
                MojoModelMetricsBinomial binomial = (MojoModelMetricsBinomial)mojoMetrics;
                AUC2 auc = AUC2.emptyAUC();
                auc._auc = binomial._auc;
                auc._pr_auc = binomial._pr_auc;
                auc._gini = binomial._gini;
                if (mojoMetrics instanceof MojoModelMetricsBinomialGLM) {
                    assert (modelAttributes instanceof ModelAttributesGLM);
                    ModelAttributesGLM modelAttributesGLM = (ModelAttributesGLM)modelAttributes;
                    MojoModelMetricsBinomialGLM glmBinomial = (MojoModelMetricsBinomialGLM)binomial;
                    return new ModelMetricsBinomialGLMGeneric(null, null, mojoMetrics._nobs, mojoMetrics._MSE, this._domains[this._domains.length - 1], glmBinomial._sigma, auc, binomial._logloss, GenericModelOutput.convertTable(binomial._gains_lift_table), new CustomMetric(mojoMetrics._custom_metric_name, mojoMetrics._custom_metric_value), binomial._mean_per_class_error, GenericModelOutput.convertTable(binomial._thresholds_and_metric_scores), GenericModelOutput.convertTable(binomial._max_criteria_and_metric_scores), GenericModelOutput.convertTable(binomial._confusion_matrix), glmBinomial._nullDegressOfFreedom, glmBinomial._residualDegressOfFreedom, glmBinomial._resDev, glmBinomial._nullDev, glmBinomial._AIC, GenericModelOutput.convertTable(modelAttributesGLM._coefficients_table), glmBinomial._r2, glmBinomial._description);
                }
                return new ModelMetricsBinomialGeneric(null, null, mojoMetrics._nobs, mojoMetrics._MSE, this._domains[this._domains.length - 1], binomial._sigma, auc, binomial._logloss, GenericModelOutput.convertTable(binomial._gains_lift_table), new CustomMetric(mojoMetrics._custom_metric_name, mojoMetrics._custom_metric_value), binomial._mean_per_class_error, GenericModelOutput.convertTable(binomial._thresholds_and_metric_scores), GenericModelOutput.convertTable(binomial._max_criteria_and_metric_scores), GenericModelOutput.convertTable(binomial._confusion_matrix), binomial._r2, binomial._description);
            }
            case Multinomial: {
                assert (mojoMetrics instanceof MojoModelMetricsMultinomial);
                if (mojoMetrics instanceof MojoModelMetricsMultinomialGLM) {
                    assert (modelAttributes instanceof ModelAttributesGLM);
                    ModelAttributesGLM modelAttributesGLM = (ModelAttributesGLM)modelAttributes;
                    MojoModelMetricsMultinomialGLM glmMultinomial = (MojoModelMetricsMultinomialGLM)mojoMetrics;
                    return new ModelMetricsMultinomialGLMGeneric(null, null, mojoMetrics._nobs, mojoMetrics._MSE, this._domains[this._domains.length - 1], glmMultinomial._sigma, GenericModelOutput.convertTable(glmMultinomial._confusion_matrix), GenericModelOutput.convertTable(glmMultinomial._hit_ratios), glmMultinomial._logloss, new CustomMetric(mojoMetrics._custom_metric_name, mojoMetrics._custom_metric_value), glmMultinomial._mean_per_class_error, glmMultinomial._nullDegressOfFreedom, glmMultinomial._residualDegressOfFreedom, glmMultinomial._resDev, glmMultinomial._nullDev, glmMultinomial._AIC, GenericModelOutput.convertTable(modelAttributesGLM._coefficients_table), glmMultinomial._r2, glmMultinomial._description);
                }
                MojoModelMetricsMultinomial multinomial = (MojoModelMetricsMultinomial)mojoMetrics;
                return new ModelMetricsMultinomialGeneric(null, null, mojoMetrics._nobs, mojoMetrics._MSE, this._domains[this._domains.length - 1], multinomial._sigma, GenericModelOutput.convertTable(multinomial._confusion_matrix), GenericModelOutput.convertTable(multinomial._hit_ratios), multinomial._logloss, new CustomMetric(mojoMetrics._custom_metric_name, mojoMetrics._custom_metric_value), multinomial._mean_per_class_error, multinomial._r2, multinomial._description);
            }
            case Regression: {
                assert (mojoMetrics instanceof MojoModelMetricsRegression);
                if (mojoMetrics instanceof MojoModelMetricsRegressionGLM) {
                    assert (modelAttributes instanceof ModelAttributesGLM);
                    ModelAttributesGLM modelAttributesGLM = (ModelAttributesGLM)modelAttributes;
                    MojoModelMetricsRegressionGLM regressionGLM = (MojoModelMetricsRegressionGLM)mojoMetrics;
                    return new ModelMetricsRegressionGLMGeneric(null, null, regressionGLM._nobs, regressionGLM._MSE, regressionGLM._sigma, regressionGLM._mae, regressionGLM._root_mean_squared_log_error, regressionGLM._mean_residual_deviance, new CustomMetric(regressionGLM._custom_metric_name, regressionGLM._custom_metric_value), regressionGLM._r2, regressionGLM._nullDegressOfFreedom, regressionGLM._residualDegressOfFreedom, regressionGLM._resDev, regressionGLM._nullDev, regressionGLM._AIC, GenericModelOutput.convertTable(modelAttributesGLM._coefficients_table));
                }
                MojoModelMetricsRegression metricsRegression = (MojoModelMetricsRegression)mojoMetrics;
                return new ModelMetricsRegressionGeneric(null, null, metricsRegression._nobs, metricsRegression._MSE, metricsRegression._sigma, metricsRegression._mae, metricsRegression._root_mean_squared_log_error, metricsRegression._mean_residual_deviance, new CustomMetric(mojoMetrics._custom_metric_name, mojoMetrics._custom_metric_value), mojoMetrics._description);
            }
            case AnomalyDetection: {
                assert (mojoMetrics instanceof MojoModelMetricsAnomaly);
                MojoModelMetricsAnomaly metricsAnomaly = (MojoModelMetricsAnomaly)mojoMetrics;
                return new ModelMetricsAnomaly(null, null, new CustomMetric(mojoMetrics._custom_metric_name, mojoMetrics._custom_metric_value), mojoMetrics._nobs, metricsAnomaly._mean_score * (double)metricsAnomaly._nobs, metricsAnomaly._mean_normalized_score * (double)metricsAnomaly._nobs, metricsAnomaly._description);
            }
            case Ordinal: {
                assert (mojoMetrics instanceof MojoModelMetricsOrdinal);
                if (mojoMetrics instanceof MojoModelMetricsOrdinalGLM) {
                    assert (modelAttributes instanceof ModelAttributesGLM);
                    ModelAttributesGLM modelAttributesGLM = (ModelAttributesGLM)modelAttributes;
                    MojoModelMetricsOrdinalGLM ordinalMetrics = (MojoModelMetricsOrdinalGLM)mojoMetrics;
                    return new ModelMetricsOrdinalGLMGeneric(null, null, ordinalMetrics._nobs, ordinalMetrics._MSE, ordinalMetrics._domain, ordinalMetrics._sigma, GenericModelOutput.convertTable(ordinalMetrics._cm), ordinalMetrics._hit_ratios, ordinalMetrics._logloss, new CustomMetric(ordinalMetrics._custom_metric_name, ordinalMetrics._custom_metric_value), ordinalMetrics._r2, ordinalMetrics._nullDegressOfFreedom, ordinalMetrics._residualDegressOfFreedom, ordinalMetrics._resDev, ordinalMetrics._nullDev, ordinalMetrics._AIC, GenericModelOutput.convertTable(modelAttributesGLM._coefficients_table), GenericModelOutput.convertTable(ordinalMetrics._hit_ratio_table), ordinalMetrics._mean_per_class_error, ordinalMetrics._description);
                }
                MojoModelMetricsOrdinal ordinalMetrics = (MojoModelMetricsOrdinal)mojoMetrics;
                return new ModelMetricsOrdinalGeneric(null, null, ordinalMetrics._nobs, ordinalMetrics._MSE, ordinalMetrics._domain, ordinalMetrics._sigma, GenericModelOutput.convertTable(ordinalMetrics._cm), ordinalMetrics._hit_ratios, ordinalMetrics._logloss, new CustomMetric(ordinalMetrics._custom_metric_name, ordinalMetrics._custom_metric_value), GenericModelOutput.convertTable(ordinalMetrics._hit_ratio_table), ordinalMetrics._mean_per_class_error, ordinalMetrics._description);
            }
        }
        return new ModelMetrics(null, null, mojoMetrics._nobs, mojoMetrics._MSE, mojoMetrics._description, new CustomMetric(mojoMetrics._custom_metric_name, mojoMetrics._custom_metric_value));
    }

    public double defaultThreshold() {
        return this._defaultThreshold;
    }

    public ModelCategory getModelCategory() {
        return this._modelCategory;
    }

    public int nfeatures() {
        return this._nfeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object convertObjects(Object source, Object target) {
        Class<?> targetClass = target.getClass();
        Field[] targetDeclaredFields = targetClass.getFields();
        Class<?> sourceClass = source.getClass();
        Field[] sourceDeclaredFields = sourceClass.getFields();
        HashMap<String, Field> sourceFieldMap = new HashMap<String, Field>(sourceDeclaredFields.length);
        for (Field sourceField : sourceDeclaredFields) {
            sourceFieldMap.put(sourceField.getName(), sourceField);
        }
        for (int i = 0; i < targetDeclaredFields.length; ++i) {
            Field sourceField;
            Field targetField = targetDeclaredFields[i];
            String targetFieldName = targetField.getName();
            sourceField = (Field)sourceFieldMap.get(targetFieldName);
            if (sourceField == null) {
                Log.debug((Object[])new Object[]{String.format("Field '%s' not found in the source object. Ignoring.", targetFieldName)});
                continue;
            }
            boolean targetAccessible = targetField.isAccessible();
            boolean sourceAccessible = sourceField.isAccessible();
            try {
                targetField.setAccessible(true);
                sourceField.setAccessible(true);
                if (!targetField.getType().isAssignableFrom(sourceField.getType())) continue;
                targetField.set(target, sourceField.get(source));
                continue;
            }
            catch (IllegalAccessException e) {
                Log.err((Throwable)e);
                continue;
            }
            finally {
                targetField.setAccessible(targetAccessible);
                sourceField.setAccessible(sourceAccessible);
            }
        }
        return target;
    }

    private static TwoDimTable convertVariableImportances(VariableImportances variableImportances) {
        if (variableImportances == null) {
            return null;
        }
        TwoDimTable varImps = ModelMetrics.calcVarImp((double[])variableImportances._importances, (String[])variableImportances._variables);
        return varImps;
    }

    private static TwoDimTable convertTable(Table convertedTable) {
        if (convertedTable == null) {
            return null;
        }
        TwoDimTable table = new TwoDimTable(convertedTable.getTableHeader(), convertedTable.getTableDescription(), convertedTable.getRowHeaders(), convertedTable.getColHeaders(), convertedTable.getColTypesString(), convertedTable.getColumnFormats(), convertedTable.getColHeaderForRowHeaders());
        for (int i = 0; i < convertedTable.columns(); ++i) {
            for (int j = 0; j < convertedTable.rows(); ++j) {
                table.set(j, i, convertedTable.getCell(i, j));
            }
        }
        return table;
    }
}

