/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DMatrix;
import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsHGLM;
import hex.ModelMetricsRegressionGLM;
import hex.glm.ComputationState;
import hex.glm.GLMMetricBuilder;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import hex.glm.GLMUtils;
import hex.gram.Gram;
import hex.optimization.ADMM;
import hex.optimization.L_BFGS;
import hex.optimization.OptimizationUtils;
import hex.svd.SVD;
import hex.svd.SVDModel;
import hex.util.LinearAlgebraUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import jsr166y.CountedCompleter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.Scope;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.InteractionWrappedVec;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Rapids;
import water.rapids.Val;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.TwoDimTable;

public class GLM
extends ModelBuilder<GLMModel, GLMModel.GLMParameters, GLMModel.GLMOutput> {
    static NumberFormat lambdaFormatter = new DecimalFormat(".##E0");
    static NumberFormat devFormatter = new DecimalFormat(".##");
    public static final int SCORING_INTERVAL_MSEC = 15000;
    public int[] _randC;
    public String _generatedWeights = null;
    public String[] _randCoeffNames = null;
    public String[] _randomColNames = null;
    public double[][][] _penaltyMatrix = null;
    public String[][] _gamColnames = null;
    public int[][] _gamColIndices = null;
    public static int _totalBetaLen;
    private transient GLMDriver _driver;
    private double _lambdaCVEstimate = Double.NaN;
    private boolean _doInit = true;
    private double[] _xval_test_deviances;
    private double[] _xval_test_sd;
    DataInfo _dinfo;
    private transient DataInfo _validDinfo;
    private transient ScoringHistory _sc;
    private transient LambdaSearchScoringHistory _lsc;
    long _t0 = System.currentTimeMillis();
    private transient double _iceptAdjust = 0.0;
    private double _lmax;
    private transient long _nobs;
    private transient GLMModel _model;
    private transient double[] _nullBeta;
    protected static final long WORK_TOTAL = 1000000L;
    transient Key[] _toRemove;
    private transient ComputationState _state;

    public GLM(boolean startup_once) {
        super((Model.Parameters)new GLMModel.GLMParameters(), startup_once);
    }

    public GLM(GLMModel.GLMParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public GLM(GLMModel.GLMParameters parms, double[][][] penaltyMatrix, String[][] gamColnames) {
        super((Model.Parameters)parms);
        this.init(false);
        this._penaltyMatrix = penaltyMatrix;
        this._gamColnames = gamColnames;
    }

    public GLM(GLMModel.GLMParameters parms, Key dest) {
        super((Model.Parameters)parms, dest);
        this.init(false);
    }

    public boolean isSupervised() {
        return true;
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial};
    }

    public boolean havePojo() {
        return true;
    }

    public boolean haveMojo() {
        return true;
    }

    public void computeCrossValidation() {
        this.init(true);
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
        }
        super.computeCrossValidation();
    }

    public void cv_computeAndSetOptimalParameters(ModelBuilder[] cvModelBuilders) {
        if (((GLMModel.GLMParameters)this._parms)._max_runtime_secs != 0.0) {
            ((GLMModel.GLMParameters)this._parms)._max_runtime_secs = 0.0;
        }
        if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
            int bestId1se;
            GLM g;
            int i;
            this._xval_test_deviances = new double[((GLMModel.GLMParameters)this._parms)._lambda.length];
            this._xval_test_sd = new double[((GLMModel.GLMParameters)this._parms)._lambda.length];
            double bestTestDev = Double.POSITIVE_INFINITY;
            int lmin_max = 0;
            for (int i2 = 0; i2 < cvModelBuilders.length; ++i2) {
                GLM g2 = (GLM)cvModelBuilders[i2];
                lmin_max = Math.max(lmin_max, ((GLMModel.GLMOutput)g2._model._output)._best_lambda_idx);
            }
            int bestId = 0;
            int cnt = 0;
            for (int lidx = 0; lidx < lmin_max; ++lidx) {
                double testDev = 0.0;
                for (int i3 = 0; i3 < cvModelBuilders.length; ++i3) {
                    GLM g3 = (GLM)cvModelBuilders[i3];
                    double x = ((GLMModel.GLMParameters)this._parms)._lambda[lidx];
                    if (((GLMModel.GLMOutput)g3._model._output).getSubmodel(x) == null) {
                        g3._driver.computeSubmodel(lidx, x);
                    }
                    testDev += ((GLMModel.GLMOutput)g3._model._output).getSubmodel((double)x).devianceTest;
                }
                double testDevAvg = testDev / (double)cvModelBuilders.length;
                double testDevSE = 0.0;
                for (int i4 = 0; i4 < cvModelBuilders.length; ++i4) {
                    GLM g4 = (GLM)cvModelBuilders[i4];
                    double x = ((GLMModel.GLMParameters)this._parms)._lambda[lidx];
                    if (((GLMModel.GLMOutput)g4._model._output).getSubmodel(x) == null) {
                        g4._driver.computeSubmodel(lidx, x);
                    }
                    double diff = testDevAvg - ((GLMModel.GLMOutput)g4._model._output).getSubmodel((double)x).devianceTest;
                    testDevSE += diff * diff;
                }
                this._xval_test_sd[lidx] = Math.sqrt(testDevSE / (double)((cvModelBuilders.length - 1) * cvModelBuilders.length));
                this._xval_test_deviances[lidx] = testDevAvg;
                if (testDevAvg < bestTestDev) {
                    bestTestDev = testDevAvg;
                    bestId = lidx;
                }
                if (!(testDevAvg > bestTestDev) || ++cnt != 3) continue;
                lmin_max = lidx;
                break;
            }
            for (i = 0; i < cvModelBuilders.length; ++i) {
                g = (GLM)cvModelBuilders[i];
                if (g._toRemove == null) continue;
                for (Key k : g._toRemove) {
                    Keyed.remove((Key)k);
                }
            }
            ((GLMModel.GLMParameters)this._parms)._lambda = Arrays.copyOf(((GLMModel.GLMParameters)this._parms)._lambda, lmin_max + 1);
            this._xval_test_deviances = Arrays.copyOf(this._xval_test_deviances, lmin_max + 1);
            this._xval_test_sd = Arrays.copyOf(this._xval_test_sd, lmin_max + 1);
            for (i = 0; i < cvModelBuilders.length; ++i) {
                g = (GLM)cvModelBuilders[i];
                ((GLMModel.GLMOutput)g._model._output).setSubmodelIdx(bestId);
            }
            double bestDev = this._xval_test_deviances[bestId];
            double bestDev1se = bestDev + this._xval_test_sd[bestId];
            for (bestId1se = bestId; bestId1se > 0 && this._xval_test_deviances[bestId1se - 1] <= bestDev1se; --bestId1se) {
            }
            this._lambdaCVEstimate = ((GLMModel.GLMParameters)this._parms)._lambda[bestId];
            ((GLMModel.GLMOutput)this._model._output)._lambda_1se = bestId1se;
            ((GLMModel.GLMOutput)this._model._output)._best_lambda_idx = bestId;
        }
        for (int i = 0; i < cvModelBuilders.length; ++i) {
            GLM g = (GLM)cvModelBuilders[i];
            GLMModel gm = g._model;
            gm.write_lock(this._job);
            gm.update(this._job);
            gm.unlock(this._job);
        }
        this._doInit = false;
    }

    protected void checkMemoryFootPrint(DataInfo activeData) {
        if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.IRLSM || ((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT) {
            int p = activeData.fullN();
            HeartBeat hb = H2O.SELF._heartbeat;
            long mem_usage = (long)((double)(hb._cpus_allowed * (p * p + activeData.largestCat()) * 8) * (1.0 + 0.5 * Math.log(this._train.lastVec().nChunks()) / Math.log(2.0)));
            long max_mem = hb.get_free_mem();
            if (((GLMModel.GLMParameters)this._parms)._HGLM) {
                int expandedRandColValues = ArrayUtils.sum((int[])this._randC);
                mem_usage = (long)(expandedRandColValues * expandedRandColValues * 5) + (this._nobs + (long)expandedRandColValues) * 5L;
            }
            if (mem_usage > max_mem) {
                String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes((long)mem_usage) + " > " + PrettyPrint.bytes((long)max_mem) + ") - try reducing the number of columns and/or the number of categorical factors (or switch to the L-BFGS solver).";
                this.error("_train", msg);
            }
        }
    }

    public int nclasses() {
        if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
            return this._nclass;
        }
        if (GLMModel.GLMParameters.Family.binomial == ((GLMModel.GLMParameters)this._parms)._family || GLMModel.GLMParameters.Family.quasibinomial == ((GLMModel.GLMParameters)this._parms)._family || GLMModel.GLMParameters.Family.fractionalbinomial == ((GLMModel.GLMParameters)this._parms)._family) {
            return 2;
        }
        return 1;
    }

    private double[] getNullBeta() {
        if (this._nullBeta == null) {
            if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                this._nullBeta = MemoryManager.malloc8d((int)((this._dinfo.fullN() + 1) * this.nclasses()));
                int N = this._dinfo.fullN() + 1;
                if (((GLMModel.GLMParameters)this._parms)._intercept) {
                    if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                        int i;
                        Random rng = RandomUtils.getRNG((long[])new long[]{((GLMModel.GLMParameters)this._parms)._seed});
                        int lastClass = this.nclasses() - 1;
                        double[] tempIcpt = new double[lastClass];
                        for (i = 0; i < lastClass; ++i) {
                            tempIcpt[i] = (-1.0 + 2.0 * rng.nextDouble()) * (double)this.nclasses();
                        }
                        Arrays.sort(tempIcpt);
                        for (i = 0; i < lastClass; ++i) {
                            this._nullBeta[this._dinfo.fullN() + i * N] = tempIcpt[i];
                        }
                    } else {
                        for (int i = 0; i < this.nclasses(); ++i) {
                            this._nullBeta[this._dinfo.fullN() + i * N] = Math.log(this._state._ymu[i]);
                        }
                    }
                }
            } else {
                this._nullBeta = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
                this._nullBeta[this._dinfo.fullN()] = ((GLMModel.GLMParameters)this._parms)._intercept && ((GLMModel.GLMParameters)this._parms)._family != GLMModel.GLMParameters.Family.quasibinomial ? new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)this._parms).link(this._state._ymu[0]) : 0.0;
            }
        }
        return this._nullBeta;
    }

    protected boolean computePriorClassDistribution() {
        return ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal;
    }

    public void init(boolean expensive) {
        super.init(expensive);
        this.hide("_balance_classes", "Not applicable since class balancing is not required for GLM.");
        this.hide("_max_after_balance_size", "Not applicable since class balancing is not required for GLM.");
        this.hide("_class_sampling_factors", "Not applicable since class balancing is not required for GLM.");
        ((GLMModel.GLMParameters)this._parms).validate(this);
        if (this._response != null) {
            if (!this.isClassifier() && this._response.isCategorical()) {
                this.error("_response", H2O.technote((int)2, (String)"Regression requires numeric response, got categorical."));
            }
            if ((((GLMModel.GLMParameters)this._parms)._solver.equals((Object)GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_LH) || ((GLMModel.GLMParameters)this._parms)._solver.equals((Object)GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_SQERR)) && !((GLMModel.GLMParameters)this._parms)._family.equals((Object)GLMModel.GLMParameters.Family.ordinal)) {
                this.error("_solver", "Solvers GRADIENT_DESCENT_LH and GRADIENT_DESCENT_SQERR are only supported for ordinal regression.  Do not choose them unless you specify your family to be ordinal");
            }
            switch (((GLMModel.GLMParameters)this._parms)._family) {
                case binomial: {
                    if (this._response.isBinary() || this._nclass == 2) break;
                    this.error("_family", H2O.technote((int)2, (String)"Binomial requires the response to be a 2-class categorical or a binary column (0/1)"));
                    break;
                }
                case multinomial: {
                    if (this._nclass > 2) break;
                    this.error("_family", H2O.technote((int)2, (String)"Multinomial requires a categorical response with at least 3 levels (for 2 class problem use family=binomial."));
                    break;
                }
                case poisson: 
                case negativebinomial: {
                    if (this._nclass != 1) {
                        this.error("_family", "Poisson and Negative Binomial require the response to be numeric.");
                    }
                    if (this._response.min() < 0.0) {
                        this.error("_family", "Poisson and Negative Binomial require response >= 0");
                    }
                    if (!this._response.isInt()) {
                        this.warn("_family", "Poisson and Negative Binomial expect non-negative integer response, got floats.");
                    }
                    if (!((GLMModel.GLMParameters)this._parms)._family.equals((Object)GLMModel.GLMParameters.Family.negativebinomial)) break;
                    if (((GLMModel.GLMParameters)this._parms)._theta <= 0.0 || ((GLMModel.GLMParameters)this._parms)._theta > 1.0) {
                        this.error("_family", "Illegal Negative Binomial theta value.  Valid theta values be > 0 and <= 1.");
                        break;
                    }
                    ((GLMModel.GLMParameters)this._parms)._invTheta = 1.0 / ((GLMModel.GLMParameters)this._parms)._theta;
                    break;
                }
                case gamma: {
                    if (this._nclass != 1) {
                        this.error("_distribution", H2O.technote((int)2, (String)"Gamma requires the response to be numeric."));
                    }
                    if (!(this._response.min() <= 0.0)) break;
                    this.error("_family", "Response value for gamma distribution must be greater than 0.");
                    break;
                }
                case tweedie: {
                    if (this._nclass == 1) break;
                    this.error("_family", H2O.technote((int)2, (String)"Tweedie requires the response to be numeric."));
                    break;
                }
                case quasibinomial: {
                    if (this._nclass == 1) break;
                    this.error("_family", H2O.technote((int)2, (String)"Quasi_binomial requires the response to be numeric."));
                    break;
                }
                case ordinal: {
                    if (this._nclass <= 2) {
                        this.error("_family", H2O.technote((int)2, (String)"Ordinal requires a categorical response with at least 3 levels (for 2 class problem use family=binomial."));
                    }
                    if (((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.oprobit && ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.ologlog) break;
                    this.error("_link", "Ordinal regression only supports ologit as link.");
                    break;
                }
                case gaussian: {
                    break;
                }
                case fractionalbinomial: {
                    Vec vec = this.train().vec(((GLMModel.GLMParameters)this._parms)._response_column);
                    if (!(vec.min() < 0.0) && !(vec.max() > 1.0)) break;
                    this.error("response", String.format("Response '%s' must be between 0 and 1 for fractional_binomial family. Min: %f, Max: %f", ((GLMModel.GLMParameters)this._parms)._response_column, vec.min(), vec.max()));
                    break;
                }
                default: {
                    this.error("_family", "Invalid distribution: " + ((GLMModel.GLMParameters)this._parms)._distribution);
                }
            }
        }
        if (((GLMModel.GLMParameters)this._parms)._plug_values != null && ((GLMModel.GLMParameters)this._parms).missingValuesHandling() != GLMModel.GLMParameters.MissingValuesHandling.PlugValues) {
            this.error("_missing_values_handling", "When plug values are provided - Missing Values Handling needs to be explicitly set to PlugValues.");
        }
        if (((GLMModel.GLMParameters)this._parms)._plug_values == null && ((GLMModel.GLMParameters)this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.PlugValues) {
            this.error("_missing_values_handling", "No plug values frame provided for Missing Values Handling = PlugValues.");
        }
        if (((GLMModel.GLMParameters)this._parms)._HGLM) {
            for (int randInx : ((GLMModel.GLMParameters)this._parms)._random_columns) {
                if (((GLMModel.GLMParameters)this._parms).train().vec(randInx).isCategorical()) continue;
                this.error("HGLM random_columns", "Must contain categorical columns.");
            }
        }
        if (expensive) {
            BetaConstraint bc;
            boolean skippingRows;
            if (this.error_count() > 0) {
                return;
            }
            if (((GLMModel.GLMParameters)this._parms)._alpha == null) {
                ((GLMModel.GLMParameters)this._parms)._alpha = new double[]{((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS ? 0.0 : 0.5};
            }
            if (((GLMModel.GLMParameters)this._parms)._lambda_search && ((GLMModel.GLMParameters)this._parms)._nlambdas == -1) {
                ((GLMModel.GLMParameters)this._parms)._nlambdas = ((GLMModel.GLMParameters)this._parms)._alpha[0] == 0.0 ? 30 : 100;
            }
            this._lsc = new LambdaSearchScoringHistory(((GLMModel.GLMParameters)this._parms)._valid != null, ((GLMModel.GLMParameters)this._parms)._nfolds > 1);
            this._sc = new ScoringHistory();
            this._train.bulkRollups();
            this._sc = new ScoringHistory();
            this._t0 = System.currentTimeMillis();
            if ((((GLMModel.GLMParameters)this._parms)._lambda_search || !((GLMModel.GLMParameters)this._parms)._intercept || ((GLMModel.GLMParameters)this._parms)._lambda == null || ((GLMModel.GLMParameters)this._parms)._lambda[0] > 0.0) && !((GLMModel.GLMParameters)this._parms)._HGLM) {
                ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels = true;
            }
            if (((GLMModel.GLMParameters)this._parms)._link == GLMModel.GLMParameters.Link.family_default) {
                ((GLMModel.GLMParameters)this._parms)._link = ((GLMModel.GLMParameters)this._parms)._family.defaultLink;
            }
            if (((GLMModel.GLMParameters)this._parms)._plug_values != null) {
                Frame frame = (Frame)((GLMModel.GLMParameters)this._parms)._plug_values.get();
                if (frame == null) {
                    this.error("_plug_values", "Supplied plug values frame with key=`" + ((GLMModel.GLMParameters)this._parms)._plug_values + "` doesn't exist.");
                } else if (frame.numRows() != 1L) {
                    this.error("_plug_values", "Plug values frame needs to have exactly 1 row.");
                }
            }
            boolean bl = ((GLMModel.GLMParameters)this._parms)._HGLM ? false : ((GLMModel.GLMParameters)this._parms)._standardize;
            this._dinfo = new DataInfo((Frame)this._train.clone(), this._valid, 1, ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels || ((GLMModel.GLMParameters)this._parms)._lambda_search, bl ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, ((GLMModel.GLMParameters)this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.Skip, ((GLMModel.GLMParameters)this._parms).imputeMissing(), ((GLMModel.GLMParameters)this._parms).makeImputer(), false, this.hasWeightCol(), this.hasOffsetCol(), this.hasFoldCol(), ((GLMModel.GLMParameters)this._parms).interactionSpec());
            int n = _totalBetaLen = ((GLMModel.GLMParameters)this._parms)._family.equals((Object)GLMModel.GLMParameters.Family.multinomial) || ((GLMModel.GLMParameters)this._parms)._family.equals((Object)GLMModel.GLMParameters.Family.ordinal) ? this._dinfo.fullN() * this.nclasses() + 1 : this._dinfo.fullN() + 1;
            if (((GLMModel.GLMParameters)this._parms)._glmType.equals((Object)GLMModel.GLMParameters.GLMType.gam)) {
                this._gamColIndices = GLMUtils.extractAdaptedFrameIndices(this._dinfo._adaptedFrame, this._gamColnames, this._dinfo._numOffsets[0] - this._dinfo._cats);
            }
            if (((GLMModel.GLMParameters)this._parms)._max_iterations == -1) {
                int numclasses;
                int n2 = numclasses = ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal ? this.nclasses() : 1;
                if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS) {
                    int n3 = ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._lambda_search ? ((GLMModel.GLMParameters)this._parms)._nlambdas * 100 * numclasses : numclasses * Math.max(20, this._dinfo.fullN() >> 2);
                    if (((GLMModel.GLMParameters)this._parms)._alpha[0] > 0.0) {
                        ((GLMModel.GLMParameters)this._parms)._max_iterations *= 10;
                    }
                } else {
                    int n4 = ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._lambda_search ? 10 * ((GLMModel.GLMParameters)this._parms)._nlambdas : 50;
                }
            }
            if (this._valid != null) {
                this._validDinfo = this._dinfo.validDinfo(this._valid);
            }
            this._state = new ComputationState(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo, null, this.nclasses(), this._penaltyMatrix, this._gamColIndices);
            boolean bl2 = skippingRows = ((GLMModel.GLMParameters)this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.Skip && this._train.hasNAs();
            if (this.hasWeightCol() || skippingRows) {
                GLMTask.YMUTask ymt;
                boolean setWeights = skippingRows;
                if (setWeights) {
                    Vec wc = this._weights == null ? this._dinfo._adaptedFrame.anyVec().makeCon(1.0) : this._weights.makeCopy();
                    this._generatedWeights = "__glm_gen_weights";
                    this._dinfo.setWeights("__glm_gen_weights", wc);
                }
                if ((ymt = (GLMTask.YMUTask)new GLMTask.YMUTask(this._dinfo, ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal ? this.nclasses() : 1, setWeights, skippingRows, true, false).doAll(this._dinfo._adaptedFrame)).wsum() == 0.0) {
                    throw new IllegalArgumentException("No rows left in the dataset after filtering out rows with missing values. Ignore columns with many NAs or impute your missing values prior to calling glm.");
                }
                Log.info((Object[])new Object[]{this.LogMsg("using " + ymt.nobs() + " nobs out of " + this._dinfo._adaptedFrame.numRows() + " total")});
                this._nobs = ymt.nobs();
                if (((GLMModel.GLMParameters)this._parms)._obj_reg == -1.0) {
                    ((GLMModel.GLMParameters)this._parms)._obj_reg = 1.0 / ymt.wsum();
                }
                if (!((GLMModel.GLMParameters)this._parms)._stdOverride) {
                    this._dinfo.updateWeightedSigmaAndMean(ymt.predictorSDs(), ymt.predictorMeans());
                }
                if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                    this._state._ymu = MemoryManager.malloc8d((int)this._nclass);
                    for (int i = 0; i < this._state._ymu.length; ++i) {
                        this._state._ymu[i] = this._priorClassDist[i];
                    }
                } else {
                    double[] dArray;
                    if (((GLMModel.GLMParameters)this._parms)._intercept) {
                        dArray = ymt._yMu;
                    } else {
                        double[] dArray2 = new double[1];
                        dArray = dArray2;
                        dArray2[0] = ((GLMModel.GLMParameters)this._parms).linkInv(0.0);
                    }
                    this._state._ymu = dArray;
                }
            } else {
                this._nobs = this._train.numRows();
                if (((GLMModel.GLMParameters)this._parms)._obj_reg == -1.0) {
                    ((GLMModel.GLMParameters)this._parms)._obj_reg = 1.0 / (double)this._nobs;
                }
                if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                    this._state._ymu = MemoryManager.malloc8d((int)this._nclass);
                    for (int i = 0; i < this._state._ymu.length; ++i) {
                        this._state._ymu[i] = this._priorClassDist[i];
                    }
                } else {
                    this._state._ymu = new double[]{((GLMModel.GLMParameters)this._parms)._intercept ? this._train.lastVec().mean() : ((GLMModel.GLMParameters)this._parms).linkInv(0.0)};
                }
            }
            BetaConstraint betaConstraint = bc = ((GLMModel.GLMParameters)this._parms)._beta_constraints != null ? new BetaConstraint((Frame)((GLMModel.GLMParameters)this._parms)._beta_constraints.get()) : new BetaConstraint();
            if ((bc.hasBounds() || bc.hasProximalPenalty()) && ((GLMModel.GLMParameters)this._parms)._compute_p_values) {
                this.error("_compute_p_values", "P-values can not be computed for constrained problems");
            }
            if (bc.hasBounds()) {
                ((GLMModel.GLMParameters)this._parms)._early_stopping = false;
            }
            this._state.setBC(bc);
            if (this.hasOffsetCol() && ((GLMModel.GLMParameters)this._parms)._intercept) {
                GLMGradientSolver gslvr = new GLMGradientSolver(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo.filterExpandedColumns(new int[0]), 0.0, this._state.activeBC(), this._penaltyMatrix, this._gamColIndices);
                double[] x = new L_BFGS().solve((OptimizationUtils.GradientSolver)gslvr, (double[])new double[]{-this._offset.mean()}).coefs;
                Log.info((Object[])new Object[]{this.LogMsg("fitted intercept = " + x[0])});
                x[0] = ((GLMModel.GLMParameters)this._parms).linkInv(x[0]);
                this._state._ymu = x;
            }
            if (((GLMModel.GLMParameters)this._parms)._prior > 0.0) {
                this._iceptAdjust = -Math.log(this._state._ymu[0] * (1.0 - ((GLMModel.GLMParameters)this._parms)._prior) / (((GLMModel.GLMParameters)this._parms)._prior * (1.0 - this._state._ymu[0])));
            }
            ArrayList<Vec> vecs = new ArrayList<Vec>();
            if (this._weights != null) {
                vecs.add(this._weights);
            }
            if (this._offset != null) {
                vecs.add(this._offset);
            }
            vecs.add(this._response);
            double[] beta = this.getNullBeta();
            if (((GLMModel.GLMParameters)this._parms)._HGLM) {
                this.setHGLMInitValues(beta);
                ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{0.0};
            } else {
                GLMGradientInfo ginfo = new GLMGradientSolver(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo, 0.0, this._state.activeBC(), this._penaltyMatrix, this._gamColIndices).getGradient(beta);
                this._lmax = this.lmax(ginfo._gradient);
                this._state.setLambdaMax(this._lmax);
                if (((GLMModel.GLMParameters)this._parms)._lambda_min_ratio == -1.0) {
                    double d = ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio = this._nobs >> 4 > (long)this._dinfo.fullN() ? 1.0E-4 : 0.01;
                    if (((GLMModel.GLMParameters)this._parms)._alpha[0] == 0.0) {
                        ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio *= 0.01;
                    }
                }
                this._state.updateState(beta, ginfo);
                if (((GLMModel.GLMParameters)this._parms)._lambda == null) {
                    if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                        ((GLMModel.GLMParameters)this._parms)._lambda = new double[((GLMModel.GLMParameters)this._parms)._nlambdas];
                        double dec = Math.pow(((GLMModel.GLMParameters)this._parms)._lambda_min_ratio, 1.0 / (double)(((GLMModel.GLMParameters)this._parms)._nlambdas - 1));
                        ((GLMModel.GLMParameters)this._parms)._lambda[0] = this._lmax;
                        double l = this._lmax;
                        for (int i = 1; i < ((GLMModel.GLMParameters)this._parms)._nlambdas; ++i) {
                            ((GLMModel.GLMParameters)this._parms)._lambda[i] = l *= dec;
                        }
                    } else {
                        ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{10.0 * ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio * this._lmax};
                    }
                }
                if (!Double.isNaN(this._lambdaCVEstimate)) {
                    for (int i = 0; i < ((GLMModel.GLMParameters)this._parms)._lambda.length; ++i) {
                        if (!(((GLMModel.GLMParameters)this._parms)._lambda[i] < this._lambdaCVEstimate)) continue;
                        ((GLMModel.GLMParameters)this._parms)._lambda = Arrays.copyOf(((GLMModel.GLMParameters)this._parms)._lambda, i + 1);
                        break;
                    }
                    ((GLMModel.GLMParameters)this._parms)._lambda[((GLMModel.GLMParameters)this._parms)._lambda.length - 1] = this._lambdaCVEstimate;
                    ((GLMModel.GLMParameters)this._parms)._lambda[((GLMModel.GLMParameters)this._parms)._lambda.length - 1] = this._lambdaCVEstimate;
                }
            }
            if (((GLMModel.GLMParameters)this._parms)._objective_epsilon == -1.0) {
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    ((GLMModel.GLMParameters)this._parms)._objective_epsilon = 1.0E-4;
                } else {
                    double d = ((GLMModel.GLMParameters)this._parms)._objective_epsilon = ((GLMModel.GLMParameters)this._parms)._lambda[0] == 0.0 ? 1.0E-6 : 1.0E-4;
                }
            }
            if (((GLMModel.GLMParameters)this._parms)._gradient_epsilon == -1.0) {
                double d = ((GLMModel.GLMParameters)this._parms)._gradient_epsilon = ((GLMModel.GLMParameters)this._parms)._lambda[0] == 0.0 ? 1.0E-6 : 1.0E-4;
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    ((GLMModel.GLMParameters)this._parms)._gradient_epsilon *= 0.01;
                }
            }
            this.buildModel();
        }
    }

    public void setHGLMInitValues(double[] beta) {
        this._randC = new int[((GLMModel.GLMParameters)this._parms)._random_columns.length];
        this._randomColNames = new String[((GLMModel.GLMParameters)this._parms)._random_columns.length];
        for (int rcInd = 0; rcInd < ((GLMModel.GLMParameters)this._parms)._random_columns.length; ++rcInd) {
            this._randC[rcInd] = ((GLMModel.GLMParameters)this._parms).train().vec(((GLMModel.GLMParameters)this._parms)._random_columns[rcInd]).cardinality();
            this._randomColNames[rcInd] = ((GLMModel.GLMParameters)this._parms).train().name(((GLMModel.GLMParameters)this._parms)._random_columns[rcInd]);
        }
        int fixedEffectSize = beta.length;
        int randomEffectSize = ArrayUtils.sum((int[])this._randC);
        this._randCoeffNames = this.findExpandedRandColNames();
        double tau = 0.0;
        double[] phi = new double[randomEffectSize];
        double[] psi = new double[randomEffectSize];
        double[] ubeta = new double[randomEffectSize];
        double hlcorrection = 0.0;
        Vec tempVec = Vec.makeOne((long)randomEffectSize);
        Frame randWeights = new Frame(tempVec.makeOnes(3));
        randWeights.setNames(new String[]{"prior_weghts", "wpsi", "zmi"});
        if (((GLMModel.GLMParameters)this._parms)._startval == null) {
            GLMModel tempModel = this.runGLMModel(((GLMModel.GLMParameters)this._parms)._standardize, GLMModel.GLMParameters.Family.gaussian, GLMModel.GLMParameters.Link.family_default, (Key<Frame>)((GLMModel.GLMParameters)this._parms)._train, ((GLMModel.GLMParameters)this._parms)._response_column, null, ((GLMModel.GLMParameters)this._parms)._ignored_columns, false);
            System.arraycopy(tempModel.beta(), 0, beta, 0, beta.length);
            ModelMetricsRegressionGLM tMetric = (ModelMetricsRegressionGLM)((GLMModel.GLMOutput)tempModel._output)._training_metrics;
            double init_sig_e = 0.6 * tMetric.residual_deviance() / (double)tMetric.residual_degrees_of_freedom();
            double init_sig_u = init_sig_e * 0.66;
            init_sig_e = this.restrictMag(init_sig_e);
            init_sig_u = this.restrictMag(init_sig_u);
            Arrays.fill(phi, init_sig_u / (double)this._randC.length);
            tau = init_sig_e;
            this._state.setHGLMComputationState(beta, ubeta, psi, phi, hlcorrection, tau, randWeights, this._randCoeffNames);
            tempModel.remove();
            tMetric.remove();
        } else {
            this.copyUserInitialValues(fixedEffectSize, randomEffectSize, beta, ubeta, phi, hlcorrection, psi, randWeights, this._randCoeffNames);
        }
    }

    private String[] findExpandedRandColNames() {
        String[] randExpandedColNames = new String[ArrayUtils.sum((int[])this._randC)];
        int numRandCols = this._randC.length;
        String[] randColNames = new String[numRandCols];
        int offset = 0;
        for (int index = 0; index < numRandCols; ++index) {
            int randomColIndex = ((GLMModel.GLMParameters)this._parms)._random_columns[index];
            String[] domains = ((GLMModel.GLMParameters)this._parms).train().vec(randomColIndex).domain();
            int domainLen = domains.length;
            randColNames[index] = ((GLMModel.GLMParameters)this._parms).train().name(randomColIndex);
            for (int insideInd = 0; insideInd < domainLen; ++insideInd) {
                randExpandedColNames[offset + insideInd] = randColNames[index] + "_" + insideInd;
            }
            offset += domainLen;
        }
        return randExpandedColNames;
    }

    public double restrictMag(double val) {
        if (val < 1.0E-4) {
            return 0.1;
        }
        return val;
    }

    public void copyUserInitialValues(int fixedEffectSize, int randomEffectSize, double[] beta, double[] ubeta, double[] phi, double hlcorrection, double[] psi, Frame randWeights, String[] randCoeffNames) {
        int off = 0;
        int lengthLimit = fixedEffectSize;
        int totalstartvallen = fixedEffectSize + randomEffectSize + this._randC.length + 1;
        assert (((GLMModel.GLMParameters)this._parms)._startval.length == totalstartvallen) : "Expected startval length: " + totalstartvallen + ", Actual startval length: " + ((GLMModel.GLMParameters)this._parms)._startval.length;
        for (int fixedInd = off; fixedInd < lengthLimit; ++fixedInd) {
            beta[fixedInd] = ((GLMModel.GLMParameters)this._parms)._startval[fixedInd];
        }
        lengthLimit += randomEffectSize;
        for (int randomInd = off += fixedEffectSize; randomInd < lengthLimit; ++randomInd) {
            ubeta[randomInd - off] = ((GLMModel.GLMParameters)this._parms)._startval[randomInd];
        }
        lengthLimit += this._randC.length;
        int sig_u_off = 0;
        for (int siguInd = off += randomEffectSize; siguInd < lengthLimit; ++siguInd) {
            double init_sig_u = ((GLMModel.GLMParameters)this._parms)._startval[siguInd];
            for (int index = 0; index < this._randC[siguInd - off]; ++index) {
                phi[index + sig_u_off] = init_sig_u;
            }
            sig_u_off += this._randC[siguInd - off];
        }
        double tau = ((GLMModel.GLMParameters)this._parms)._startval[lengthLimit];
        if (tau < 1.0E-4 || ArrayUtils.minValue((double[])phi) < 1.0E-4) {
            this.error("init_sig_u, init_sig_e", "unacceptable initial values supplied for variance parameter or dispersion parameter of the random effects.  They need to exceed 0.0001.");
        }
        this._state.setHGLMComputationState(beta, ubeta, psi, phi, hlcorrection, tau, randWeights, randCoeffNames);
    }

    private GLMModel runGLMModel(boolean standardize, GLMModel.GLMParameters.Family family, GLMModel.GLMParameters.Link link, Key<Frame> trainKey, String responseColName, String weightColumns, String[] ignored_columns, boolean computePValue) {
        GLMModel.GLMParameters tempParams = new GLMModel.GLMParameters();
        tempParams._train = trainKey;
        tempParams._family = family;
        tempParams._link = link;
        tempParams._lambda = new double[]{0.0};
        tempParams._standardize = standardize;
        tempParams._response_column = responseColName;
        tempParams._ignored_columns = ignored_columns;
        tempParams._weights_column = weightColumns;
        tempParams._compute_p_values = computePValue;
        tempParams._useDispersion1 = computePValue;
        GLMModel model = (GLMModel)new GLM(tempParams).trainModel().get();
        return model;
    }

    private void buildModel() {
        this._model = new GLMModel(this._result, (GLMModel.GLMParameters)this._parms, this, this._state._ymu, this._dinfo._adaptedFrame.lastVec().sigma(), this._lmax, this._nobs);
        this._model.clone2().delete_and_lock(this._job._key);
    }

    private Key[] removeLater(Key ... k) {
        this._toRemove = this._toRemove == null ? k : (Key[])ArrayUtils.append((Object[])this._toRemove, (Object[])k);
        return k;
    }

    protected GLMDriver trainModelImpl() {
        this._driver = new GLMDriver();
        return this._driver;
    }

    private final double lmax(double[] grad) {
        if (((GLMModel.GLMParameters)this._parms)._glmType == GLMModel.GLMParameters.GLMType.gam) {
            int totGamCols = 0;
            for (int numG = 0; numG < this._penaltyMatrix.length; ++numG) {
                totGamCols += this._penaltyMatrix[numG].length;
            }
            int endIndex = grad.length - totGamCols;
            return Math.max(ArrayUtils.maxValue((double[])grad, (int)0, (int)endIndex), -ArrayUtils.minValue((double[])grad, (int)0, (int)endIndex)) / Math.max(0.01, ((GLMModel.GLMParameters)this._parms)._alpha[0]);
        }
        return Math.max(ArrayUtils.maxValue((double[])grad), -ArrayUtils.minValue((double[])grad)) / Math.max(0.01, ((GLMModel.GLMParameters)this._parms)._alpha[0]);
    }

    private GLMModel.GLMParameters.Solver defaultSolver() {
        GLMModel.GLMParameters.Solver s = GLMModel.GLMParameters.Solver.IRLSM;
        int max_active = 0;
        if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
            for (int c = 0; c < this._nclass; ++c) {
                max_active += this._state.activeDataMultinomial(c).fullN();
            }
        } else {
            max_active = this._state.activeData().fullN();
        }
        if (max_active >= 5000) {
            s = GLMModel.GLMParameters.Solver.L_BFGS;
        } else if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
            s = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
        } else if (this._state.activeBC().hasBounds() && !this._state.activeBC().hasProximalPenalty()) {
            s = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
        } else if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial && ((GLMModel.GLMParameters)this._parms)._alpha[0] == 0.0) {
            s = GLMModel.GLMParameters.Solver.L_BFGS;
        } else {
            Log.info((Object[])new Object[]{this.LogMsg("picked solver " + (Object)((Object)s))});
        }
        if (s != GLMModel.GLMParameters.Solver.L_BFGS && ((GLMModel.GLMParameters)this._parms)._max_active_predictors == -1) {
            ((GLMModel.GLMParameters)this._parms)._max_active_predictors = 5000;
        }
        ((GLMModel.GLMParameters)this._parms)._solver = s;
        return s;
    }

    double objVal(double likelihood, double[] beta, double lambda) {
        double alpha = ((GLMModel.GLMParameters)this._parms)._alpha[0];
        double proximalPen = 0.0;
        BetaConstraint bc = this._state.activeBC();
        if (this._state.activeBC()._betaGiven != null && bc._rho != null) {
            for (int i = 0; i < bc._betaGiven.length; ++i) {
                double diff = beta[i] - bc._betaGiven[i];
                proximalPen += diff * diff * bc._rho[i];
            }
        }
        return likelihood * ((GLMModel.GLMParameters)this._parms)._obj_reg + 0.5 * proximalPen + lambda * (alpha * ArrayUtils.l1norm((double[])beta, (boolean)((GLMModel.GLMParameters)this._parms)._intercept) + (1.0 - alpha) * 0.5 * ArrayUtils.l2norm2((double[])beta, (boolean)((GLMModel.GLMParameters)this._parms)._intercept));
    }

    private String LogMsg(String msg) {
        return "GLM[dest=" + this.dest() + ", " + this._state + "] " + msg;
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN) {
        return GLM.expandVec(beta, activeCols, fullN, 0.0);
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN, double filler) {
        assert (beta != null);
        if (activeCols == null) {
            return beta;
        }
        double[] res = MemoryManager.malloc8d((int)fullN);
        Arrays.fill(res, filler);
        int i = 0;
        for (int c : activeCols) {
            res[c] = beta[i++];
        }
        res[res.length - 1] = beta[beta.length - 1];
        return res;
    }

    private static double[] doUpdateCD(double[] grads, double[] ary, double diff, int variable_min, int variable_max) {
        int i;
        for (i = 0; i < variable_min; ++i) {
            int n = i;
            grads[n] = grads[n] + diff * ary[i];
        }
        for (i = variable_max; i < grads.length; ++i) {
            int n = i;
            grads[n] = grads[n] + diff * ary[i];
        }
        return grads;
    }

    public double[] COD_solve(ComputationState.GramXY gram, double alpha, double lambda) {
        double[] res = this.COD_solve(gram.gram.getXX(), gram.xy, gram.getCODGradients(), gram.newCols, alpha, lambda);
        gram.newCols = new int[0];
        return res;
    }

    private double[] COD_solve(double[][] xx, double[] xy, double[] grads, int[] newCols, double alpha, double lambda) {
        double wsumInv = 1.0 / xx[xx.length - 1][xx.length - 1];
        double betaEpsilon = ((GLMModel.GLMParameters)this._parms)._beta_epsilon * ((GLMModel.GLMParameters)this._parms)._beta_epsilon;
        double updateEpsilon = 0.01 * betaEpsilon;
        double l1pen = lambda * alpha;
        double l2pen = lambda * (1.0 - alpha);
        double[] diagInv = MemoryManager.malloc8d((int)xx.length);
        for (int i = 0; i < diagInv.length; ++i) {
            diagInv[i] = 1.0 / (xx[i][i] + l2pen);
        }
        DataInfo activeData = this._state.activeData();
        int[][] nzs = new int[activeData.numStart()][];
        int sparseCnt = 0;
        if (nzs.length > 1000) {
            int[] nzs_ary = new int[xx.length];
            for (int i = 0; i < activeData._cats; ++i) {
                int var_min = activeData._catOffsets[i];
                int var_max = activeData._catOffsets[i + 1];
                for (int l = var_min; l < var_max; ++l) {
                    int j;
                    int k = 0;
                    double[] x = xx[l];
                    for (j = 0; j < var_min; ++j) {
                        if (x[j] == 0.0) continue;
                        nzs_ary[k++] = j;
                    }
                    for (j = var_max; j < activeData.numStart(); ++j) {
                        if (x[j] == 0.0) continue;
                        nzs_ary[k++] = j;
                    }
                    if (k >= nzs_ary.length - var_max + var_min >> 3) continue;
                    ++sparseCnt;
                    nzs[l] = Arrays.copyOf(nzs_ary, k);
                }
            }
        }
        BetaConstraint bc = this._state.activeBC();
        double[] beta = (double[])this._state.beta().clone();
        int numStart = activeData.numStart();
        if (newCols != null) {
            for (int id : newCols) {
                double b = bc.applyBounds(ADMM.shrinkage(grads[id], l1pen) * diagInv[id], id);
                if (b == 0.0) continue;
                GLM.doUpdateCD(grads, xx[id], -b, id, id + 1);
                beta[id] = b;
            }
        }
        int iter1 = 0;
        int P = xy.length - 1;
        double maxDiff = 0.0;
        while (iter1++ < Math.max(P, 500)) {
            int i;
            maxDiff = 0.0;
            for (i = 0; i < activeData._cats; ++i) {
                for (int j = activeData._catOffsets[i]; j < activeData._catOffsets[i + 1]; ++j) {
                    double b = bc.applyBounds(ADMM.shrinkage(grads[j], l1pen) * diagInv[j], j);
                    double bd = beta[j] - b;
                    if (bd == 0.0) continue;
                    double diff = bd * bd * xx[j][j];
                    if (diff > maxDiff) {
                        maxDiff = diff;
                    }
                    if (nzs[j] == null) {
                        GLM.doUpdateCD(grads, xx[j], bd, activeData._catOffsets[i], activeData._catOffsets[i + 1]);
                    } else {
                        int[] ids;
                        double[] x = xx[j];
                        int[] nArray = ids = nzs[j];
                        int n = nArray.length;
                        for (int k = 0; k < n; ++k) {
                            int id;
                            int n2 = id = nArray[k];
                            grads[n2] = grads[n2] + bd * x[id];
                        }
                        GLM.doUpdateCD(grads, x, bd, 0, activeData.numStart());
                    }
                    beta[j] = b;
                }
            }
            for (i = numStart; i < P; ++i) {
                double b = bc.applyBounds(ADMM.shrinkage(grads[i], l1pen) * diagInv[i], i);
                double bd = beta[i] - b;
                double diff = bd * bd * xx[i][i];
                if (diff > maxDiff) {
                    maxDiff = diff;
                }
                if (!(diff > updateEpsilon)) continue;
                GLM.doUpdateCD(grads, xx[i], bd, i, i + 1);
                beta[i] = b;
            }
            if (((GLMModel.GLMParameters)this._parms)._intercept) {
                double b = bc.applyBounds(grads[P] * wsumInv, P);
                double bd = beta[P] - b;
                double diff = bd * bd * xx[P][P];
                if (diff > maxDiff) {
                    maxDiff = diff;
                }
                GLM.doUpdateCD(grads, xx[P], bd, P, P + 1);
                beta[P] = b;
            }
            if (!(maxDiff < betaEpsilon)) continue;
        }
        long tend = System.currentTimeMillis();
        return beta;
    }

    protected static double sparseOffset(double[] beta, DataInfo dinfo) {
        double etaOffset = 0.0;
        if (dinfo._normMul != null && dinfo._normSub != null && beta != null) {
            int ns = dinfo.numStart();
            for (int i = 0; i < dinfo._nums; ++i) {
                etaOffset -= beta[i + ns] * dinfo._normSub[i] * dinfo._normMul[i];
            }
        }
        return etaOffset;
    }

    public static class PlugValuesImputer
    implements DataInfo.Imputer {
        private final Frame _plug_vals;

        public PlugValuesImputer(Frame plugValues) {
            this._plug_vals = plugValues;
        }

        @Override
        public int imputeCat(String name, Vec v, boolean useAllFactorLevels) {
            String value;
            Object[] domain = v.domain();
            Vec pvec = this.pvec(name);
            if (pvec.isCategorical()) {
                value = pvec.domain()[(int)pvec.at(0L)];
            } else if (pvec.isString()) {
                value = pvec.stringAt(0L);
            } else {
                throw new IllegalStateException("Plug value for a categorical column `" + name + "` cannot by of type " + pvec.get_type_str() + "!");
            }
            int valueIndex = ArrayUtils.find((Object[])domain, (Object)value);
            if (valueIndex < 0) {
                throw new IllegalStateException("Plug value `" + value + "` of column `" + name + "` is not a member of the column's domain!");
            }
            return valueIndex;
        }

        @Override
        public double imputeNum(String name, Vec v) {
            Vec pvec = this.pvec(name);
            if (v.isNumeric() || v.isTime()) {
                return pvec.at(0L);
            }
            throw new IllegalStateException("Plug value for a column `" + name + "` of type " + v.get_type_str() + " cannot by of type " + pvec.get_type_str() + "!");
        }

        @Override
        public double[] imputeInteraction(String name, InteractionWrappedVec iv, double[] means) {
            if (iv.isNumericInteraction()) {
                return new double[]{this.imputeNum(name, (Vec)iv)};
            }
            assert (iv.v1Domain() == null || iv.v2Domain() == null);
            String[] domain = iv.v1Domain() != null ? iv.v1Domain() : iv.v2Domain();
            double[] vals = new double[domain.length];
            for (int i = 0; i < domain.length; ++i) {
                vals[i] = this.pvec(name + "." + domain[i]).at(0L);
            }
            return vals;
        }

        private Vec pvec(String name) {
            Vec pvec = this._plug_vals.vec(name);
            if (pvec == null) {
                throw new IllegalStateException("Plug value for column `" + name + "` is not defined!");
            }
            return pvec;
        }
    }

    public final class BetaConstraint
    extends Iced {
        double[] _betaStart;
        double[] _betaGiven;
        double[] _rho;
        double[] _betaLB;
        double[] _betaUB;

        public BetaConstraint() {
            if (((GLMModel.GLMParameters)GLM.this._parms)._non_negative) {
                this.setNonNegative();
            }
        }

        public void setNonNegative() {
            if (this._betaLB == null) {
                this._betaLB = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + 1));
                this._betaLB[GLM.this._dinfo.fullN()] = Double.NEGATIVE_INFINITY;
            } else {
                for (int i = 0; i < this._betaLB.length - 1; ++i) {
                    this._betaLB[i] = Math.max(0.0, this._betaLB[i]);
                }
            }
            if (this._betaUB == null) {
                this._betaUB = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + 1));
                Arrays.fill(this._betaUB, Double.POSITIVE_INFINITY);
            }
        }

        public double applyBounds(double d, int i) {
            if (this._betaLB != null && d < this._betaLB[i]) {
                return this._betaLB[i];
            }
            if (this._betaUB != null && d > this._betaUB[i]) {
                return this._betaUB[i];
            }
            return d;
        }

        public BetaConstraint(Frame beta_constraints) {
            int idx;
            Object[] names;
            int i;
            int[] map;
            Object[] dom;
            Vec v = beta_constraints.vec("names");
            if (v.isString()) {
                dom = new String[(int)v.length()];
                map = new int[dom.length];
                BufferedString tmpStr = new BufferedString();
                for (int i2 = 0; i2 < dom.length; ++i2) {
                    dom[i2] = v.atStr(tmpStr, (long)i2).toString();
                    map[i2] = i2;
                }
                Object[] sortedDom = (String[])dom.clone();
                Arrays.sort(sortedDom);
                for (i = 1; i < sortedDom.length; ++i) {
                    if (!((String)sortedDom[i - 1]).equals(sortedDom[i])) continue;
                    throw new IllegalArgumentException("Illegal beta constraints file, got duplicate constraint for predictor '" + (String)sortedDom[i - 1] + "'!");
                }
            } else if (v.isCategorical()) {
                dom = v.domain();
                map = FrameUtils.asInts((Vec)v);
                int[] sortedMap = MemoryManager.arrayCopyOf((int[])map, (int)map.length);
                Arrays.sort(sortedMap);
                for (int i3 = 1; i3 < sortedMap.length; ++i3) {
                    if (sortedMap[i3 - 1] != sortedMap[i3]) continue;
                    throw new IllegalArgumentException("Illegal beta constraints file, got duplicate constraint for predictor '" + (String)dom[sortedMap[i3 - 1]] + "'!");
                }
            } else {
                throw new IllegalArgumentException("Illegal beta constraints file, names column expected to contain column names (strings)");
            }
            if (!Arrays.deepEquals(dom, names = (String[])ArrayUtils.append((Object[])GLM.this._dinfo.coefNames(), (Object[])new String[]{"Intercept"}))) {
                HashMap<Object, Integer> m = new HashMap<Object, Integer>();
                for (i = 0; i < names.length; ++i) {
                    m.put(names[i], i);
                }
                int[] newMap = MemoryManager.malloc4((int)dom.length);
                for (int i4 = 0; i4 < map.length; ++i4) {
                    if (GLM.this._removedCols.contains(dom[map[i4]])) {
                        newMap[i4] = -1;
                        continue;
                    }
                    Integer I = (Integer)m.get(dom[map[i4]]);
                    if (I == null) {
                        throw new IllegalArgumentException("Unrecognized coefficient name in beta-constraint file, unknown name '" + (String)dom[map[i4]] + "'");
                    }
                    newMap[i4] = I;
                }
                map = newMap;
            }
            int numoff = GLM.this._dinfo.numStart();
            Object[] valid_col_names = new String[]{"names", "beta_given", "beta_start", "lower_bounds", "upper_bounds", "rho", "mean", "std_dev"};
            Arrays.sort(valid_col_names);
            for (String s : beta_constraints.names()) {
                if (Arrays.binarySearch(valid_col_names, s) >= 0) continue;
                GLM.this.error("beta_constraints", "Unknown column name '" + s + "'");
            }
            v = beta_constraints.vec("beta_start");
            if (v != null) {
                this._betaStart = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                for (int i5 = 0; i5 < (int)v.length(); ++i5) {
                    if (map[i5] == -1) continue;
                    this._betaStart[map[i5]] = v.at((long)i5);
                }
            }
            if ((v = beta_constraints.vec("beta_given")) != null) {
                this._betaGiven = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                for (int i6 = 0; i6 < (int)v.length(); ++i6) {
                    if (map[i6] == -1) continue;
                    this._betaGiven[map[i6]] = v.at((long)i6);
                }
            }
            if ((v = beta_constraints.vec("upper_bounds")) != null) {
                this._betaUB = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                Arrays.fill(this._betaUB, Double.POSITIVE_INFINITY);
                for (int i7 = 0; i7 < (int)v.length(); ++i7) {
                    if (map[i7] == -1) continue;
                    this._betaUB[map[i7]] = v.at((long)i7);
                }
            }
            if ((v = beta_constraints.vec("lower_bounds")) != null) {
                this._betaLB = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                Arrays.fill(this._betaLB, Double.NEGATIVE_INFINITY);
                for (int i8 = 0; i8 < (int)v.length(); ++i8) {
                    if (map[i8] == -1) continue;
                    this._betaLB[map[i8]] = v.at((long)i8);
                }
            }
            if ((v = beta_constraints.vec("rho")) != null) {
                this._rho = MemoryManager.malloc8d((int)(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0)));
                for (int i9 = 0; i9 < (int)v.length(); ++i9) {
                    if (map[i9] == -1) continue;
                    this._rho[map[i9]] = v.at((long)i9);
                }
            }
            if ((v = beta_constraints.vec("mean")) != null) {
                ((GLMModel.GLMParameters)GLM.this._parms)._stdOverride = true;
                int i10 = 0;
                while ((long)i10 < v.length()) {
                    if (!v.isNA((long)i10) && map[i10] != -1) {
                        int n = idx = map == null ? i10 : map[i10];
                        if (idx >= GLM.this._dinfo.numStart() && idx < GLM.this._dinfo.fullN()) {
                            GLM.this._dinfo._normSub[idx - GLM.this._dinfo.numStart()] = v.at((long)i10);
                        }
                    }
                    ++i10;
                }
            }
            if ((v = beta_constraints.vec("std_dev")) != null) {
                ((GLMModel.GLMParameters)GLM.this._parms)._stdOverride = true;
                int i11 = 0;
                while ((long)i11 < v.length()) {
                    if (!v.isNA((long)i11) && map[i11] != -1) {
                        int n = idx = map == null ? i11 : map[i11];
                        if (idx >= GLM.this._dinfo.numStart() && idx < GLM.this._dinfo.fullN()) {
                            GLM.this._dinfo._normMul[idx - GLM.this._dinfo.numStart()] = 1.0 / v.at((long)i11);
                        }
                    }
                    ++i11;
                }
            }
            if (GLM.this._dinfo._normMul != null) {
                double normG = 0.0;
                double normS = 0.0;
                double normLB = 0.0;
                double normUB = 0.0;
                for (int i12 = numoff; i12 < GLM.this._dinfo.fullN(); ++i12) {
                    double s = GLM.this._dinfo._normSub[i12 - numoff];
                    double d = 1.0 / GLM.this._dinfo._normMul[i12 - numoff];
                    if (this._betaUB != null && !Double.isInfinite(this._betaUB[i12])) {
                        normUB *= s;
                        int n = i12;
                        this._betaUB[n] = this._betaUB[n] * d;
                    }
                    if (this._betaLB != null && !Double.isInfinite(this._betaUB[i12])) {
                        normLB *= s;
                        int n = i12;
                        this._betaLB[n] = this._betaLB[n] * d;
                    }
                    if (this._betaGiven != null) {
                        normG += this._betaGiven[i12] * s;
                        int n = i12;
                        this._betaGiven[n] = this._betaGiven[n] * d;
                    }
                    if (this._betaStart == null) continue;
                    normS += this._betaStart[i12] * s;
                    int n = i12;
                    this._betaStart[n] = this._betaStart[n] * d;
                }
                if (GLM.this._dinfo._intercept) {
                    int n = GLM.this._dinfo.fullN();
                    if (this._betaGiven != null) {
                        int n2 = n;
                        this._betaGiven[n2] = this._betaGiven[n2] + normG;
                    }
                    if (this._betaStart != null) {
                        int n3 = n;
                        this._betaStart[n3] = this._betaStart[n3] + normS;
                    }
                    if (this._betaLB != null) {
                        int n4 = n;
                        this._betaLB[n4] = this._betaLB[n4] + normLB;
                    }
                    if (this._betaUB != null) {
                        int n5 = n;
                        this._betaUB[n5] = this._betaUB[n5] + normUB;
                    }
                }
            }
            if (this._betaStart == null && this._betaGiven != null) {
                this._betaStart = (double[])this._betaGiven.clone();
            }
            if (this._betaStart != null && (this._betaLB != null || this._betaUB != null)) {
                for (int i13 = 0; i13 < this._betaStart.length; ++i13) {
                    if (this._betaLB != null && this._betaLB[i13] > this._betaStart[i13]) {
                        this._betaStart[i13] = this._betaLB[i13];
                    }
                    if (this._betaUB == null || !(this._betaUB[i13] < this._betaStart[i13])) continue;
                    this._betaStart[i13] = this._betaUB[i13];
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._non_negative) {
                this.setNonNegative();
            }
            this.check();
        }

        public String toString() {
            double[][] ary = new double[this._betaGiven.length][3];
            for (int i = 0; i < this._betaGiven.length; ++i) {
                ary[i][0] = this._betaGiven[i];
                ary[i][1] = this._betaLB[i];
                ary[i][2] = this._betaUB[i];
            }
            return ArrayUtils.pprint((double[][])ary);
        }

        public boolean hasBounds() {
            if (this._betaLB != null) {
                for (double d : this._betaLB) {
                    if (Double.isInfinite(d)) continue;
                    return true;
                }
            }
            if (this._betaUB != null) {
                for (double d : this._betaUB) {
                    if (Double.isInfinite(d)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean hasProximalPenalty() {
            return this._betaGiven != null && this._rho != null && ArrayUtils.countNonzeros((double[])this._rho) > 0;
        }

        public void adjustGradient(double[] beta, double[] grad) {
            if (this._betaGiven != null && this._rho != null) {
                for (int i = 0; i < this._betaGiven.length; ++i) {
                    double diff = beta[i] - this._betaGiven[i];
                    int n = i;
                    grad[n] = grad[n] + this._rho[i] * diff;
                }
            }
        }

        double proxPen(double[] beta) {
            double res = 0.0;
            if (this._betaGiven != null && this._rho != null) {
                for (int i = 0; i < this._betaGiven.length; ++i) {
                    double diff = beta[i] - this._betaGiven[i];
                    res += this._rho[i] * diff * diff;
                }
                res *= 0.5;
            }
            return res;
        }

        public void check() {
            if (this._betaLB != null && this._betaUB != null) {
                for (int i = 0; i < this._betaLB.length; ++i) {
                    if (this._betaLB[i] <= this._betaUB[i]) continue;
                    throw new IllegalArgumentException("lower bounds must be <= upper bounds, " + this._betaLB[i] + " !<= " + this._betaUB[i]);
                }
            }
        }

        public BetaConstraint filterExpandedColumns(int[] activeCols) {
            BetaConstraint res = new BetaConstraint();
            if (this._betaLB != null) {
                res._betaLB = ArrayUtils.select((double[])this._betaLB, (int[])activeCols);
            }
            if (this._betaUB != null) {
                res._betaUB = ArrayUtils.select((double[])this._betaUB, (int[])activeCols);
            }
            if (this._betaGiven != null) {
                res._betaGiven = ArrayUtils.select((double[])this._betaGiven, (int[])activeCols);
            }
            if (this._rho != null) {
                res._rho = ArrayUtils.select((double[])this._rho, (int[])activeCols);
            }
            if (this._betaStart != null) {
                res._betaStart = ArrayUtils.select((double[])this._betaStart, (int[])activeCols);
            }
            return res;
        }
    }

    public static final class GLMGradientSolver
    implements OptimizationUtils.GradientSolver {
        final GLMModel.GLMParameters _parms;
        final DataInfo _dinfo;
        final BetaConstraint _bc;
        final double _l2pen;
        double[][] _betaMultinomial;
        final Job _job;
        double[][][] _penaltyMatrix;
        int[][] _gamColIndices;

        public GLMGradientSolver(Job job, GLMModel.GLMParameters glmp, DataInfo dinfo, double l2pen, BetaConstraint bc) {
            this._job = job;
            this._bc = bc;
            this._parms = glmp;
            this._dinfo = dinfo;
            this._l2pen = l2pen;
        }

        public GLMGradientSolver(Job job, GLMModel.GLMParameters glmp, DataInfo dinfo, double l2pen, BetaConstraint bc, double[][][] penaltyMat, int[][] gamColInd) {
            this(job, glmp, dinfo, l2pen, bc);
            this._penaltyMatrix = penaltyMat;
            this._gamColIndices = gamColInd;
        }

        public GLMGradientInfo getMultinomialLikelihood(double[] beta) {
            assert (this._parms._family.equals((Object)GLMModel.GLMParameters.Family.multinomial)) : "GLMGradientInfo.getMultinomialLikelihood is only used by multinomial GLM";
            assert (this._betaMultinomial != null) : "Multinomial coefficents cannot be null.";
            int off = 0;
            for (int i = 0; i < this._betaMultinomial.length; ++i) {
                System.arraycopy(beta, off, this._betaMultinomial[i], 0, this._betaMultinomial[i].length);
                off += this._betaMultinomial[i].length;
            }
            GLMTask.GLMMultinomialGradientBaseTask gt = (GLMTask.GLMMultinomialGradientBaseTask)new GLMTask.GLMMultinomialLikelihoodTask(this._job, this._dinfo, this._l2pen, this._betaMultinomial, this._parms).doAll(this._dinfo._adaptedFrame);
            double l2pen = 0.0;
            for (double[] b : this._betaMultinomial) {
                l2pen += ArrayUtils.l2norm2((double[])b, (boolean)this._dinfo._intercept);
            }
            double smoothval = this._parms._glmType.equals((Object)GLMModel.GLMParameters.GLMType.gam) ? GLMUtils.calSmoothNess(this._betaMultinomial, this._penaltyMatrix, this._gamColIndices) : 0.0;
            return new GLMGradientInfo(gt._likelihood, gt._likelihood * this._parms._obj_reg + 0.5 * this._l2pen * l2pen + smoothval, null);
        }

        @Override
        public GLMGradientInfo getGradient(double[] beta) {
            if (this._parms._family == GLMModel.GLMParameters.Family.multinomial || this._parms._family == GLMModel.GLMParameters.Family.ordinal) {
                int i;
                if (this._betaMultinomial == null) {
                    int nclasses = beta.length / (this._dinfo.fullN() + 1);
                    assert (beta.length % (this._dinfo.fullN() + 1) == 0) : "beta len = " + beta.length + ", fullN +1  == " + (this._dinfo.fullN() + 1);
                    this._betaMultinomial = new double[nclasses][];
                    for (i = 0; i < nclasses; ++i) {
                        this._betaMultinomial[i] = MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1));
                    }
                }
                int off = 0;
                for (i = 0; i < this._betaMultinomial.length; ++i) {
                    System.arraycopy(beta, off, this._betaMultinomial[i], 0, this._betaMultinomial[i].length);
                    off += this._betaMultinomial[i].length;
                }
                GLMTask.GLMMultinomialGradientBaseTask gt = (GLMTask.GLMMultinomialGradientBaseTask)new GLMTask.GLMMultinomialGradientTask(this._job, this._dinfo, this._l2pen, this._betaMultinomial, this._parms, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame);
                double l2pen = 0.0;
                for (double[] b : this._betaMultinomial) {
                    l2pen += ArrayUtils.l2norm2((double[])b, (boolean)this._dinfo._intercept);
                    if (this._parms._family == GLMModel.GLMParameters.Family.ordinal) break;
                }
                double[] grad = gt.gradient();
                if (!this._parms._intercept) {
                    for (int i2 = this._dinfo.fullN(); i2 < beta.length; i2 += this._dinfo.fullN() + 1) {
                        grad[i2] = 0.0;
                    }
                }
                double smoothVal = this._parms._glmType.equals((Object)GLMModel.GLMParameters.GLMType.gam) ? GLMUtils.calSmoothNess(this._betaMultinomial, this._penaltyMatrix, this._gamColIndices) : 0.0;
                return new GLMGradientInfo(gt._likelihood, gt._likelihood * this._parms._obj_reg + 0.5 * this._l2pen * l2pen + smoothVal, grad);
            }
            assert (beta.length == this._dinfo.fullN() + 1);
            assert (this._parms._intercept || beta[beta.length - 1] == 0.0);
            GLMTask.GLMGradientTask gt = this._parms._family == GLMModel.GLMParameters.Family.binomial && this._parms._link == GLMModel.GLMParameters.Link.logit || this._parms._family == GLMModel.GLMParameters.Family.fractionalbinomial && this._parms._link == GLMModel.GLMParameters.Link.logit ? (GLMTask.GLMGradientTask)new GLMTask.GLMBinomialGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.gaussian && this._parms._link == GLMModel.GLMParameters.Link.identity ? (GLMTask.GLMGradientTask)new GLMTask.GLMGaussianGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (this._parms._family.equals((Object)GLMModel.GLMParameters.Family.negativebinomial) ? (GLMTask.GLMGradientTask)new GLMTask.GLMNegativeBinomialGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.poisson && this._parms._link == GLMModel.GLMParameters.Link.log ? (GLMTask.GLMGradientTask)new GLMTask.GLMPoissonGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.quasibinomial ? (GLMTask.GLMGradientTask)new GLMTask.GLMQuasiBinomialGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (GLMTask.GLMGradientTask)new GLMTask.GLMGenericGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame)))));
            double[] gradient = gt._gradient;
            double likelihood = gt._likelihood;
            if (!this._parms._intercept) {
                gradient[gradient.length - 1] = 0.0;
            }
            double gamSmooth = this._parms._glmType.equals((Object)GLMModel.GLMParameters.GLMType.gam) ? GLMUtils.calSmoothNess(GLM.expandVec(beta, this._dinfo._activeCols, _totalBetaLen), this._penaltyMatrix, this._gamColIndices) : 0.0;
            double obj = likelihood * this._parms._obj_reg + 0.5 * this._l2pen * ArrayUtils.l2norm2((double[])beta, (boolean)true) + gamSmooth;
            if (this._bc != null && this._bc._betaGiven != null && this._bc._rho != null) {
                obj = ProximalGradientSolver.proximal_gradient(gradient, obj, beta, this._bc._betaGiven, this._bc._rho);
            }
            return new GLMGradientInfo(likelihood, obj, gradient);
        }

        @Override
        public OptimizationUtils.GradientInfo getObjective(double[] beta) {
            double l = ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask((Key)this._job._key, (DataInfo)this._dinfo, (GLMModel.GLMParameters)this._parms, (double[])beta).doAll((Frame)this._dinfo._adaptedFrame))._likelihood;
            double smoothness = this._parms._glmType.equals((Object)GLMModel.GLMParameters.GLMType.gam) ? GLMUtils.calSmoothNess(GLM.expandVec(beta, this._dinfo._activeCols, _totalBetaLen), this._penaltyMatrix, this._gamColIndices) : 0.0;
            return new GLMGradientInfo(l, l * this._parms._obj_reg + 0.5 * this._l2pen * ArrayUtils.l2norm2((double[])beta, (boolean)true) + smoothness, null);
        }
    }

    public static class GLMGradientInfo
    extends OptimizationUtils.GradientInfo {
        final double _likelihood;

        public GLMGradientInfo(double likelihood, double objVal, double[] grad) {
            super(objVal, grad);
            this._likelihood = likelihood;
        }

        @Override
        public String toString() {
            return "GLM grad info: likelihood = " + this._likelihood + super.toString();
        }
    }

    public static class ProximalGradientSolver
    implements OptimizationUtils.GradientSolver,
    ADMM.ProximalSolver {
        final OptimizationUtils.GradientSolver _solver;
        double[] _betaGiven;
        double[] _beta;
        private ProximalGradientInfo _ginfo;
        private final L_BFGS.ProgressMonitor _pm;
        final double[] _rho;
        private final double _objEps;
        private final double _gradEps;
        private int _iter;

        public ProximalGradientSolver(OptimizationUtils.GradientSolver s, double[] betaStart, double[] rho, double objEps, double gradEps, OptimizationUtils.GradientInfo ginfo, L_BFGS.ProgressMonitor pm) {
            this._solver = s;
            this._rho = rho;
            this._objEps = objEps;
            this._gradEps = gradEps;
            this._pm = pm;
            this._beta = betaStart;
            this._betaGiven = MemoryManager.malloc8d((int)betaStart.length);
        }

        public static double proximal_gradient(double[] grad, double obj, double[] beta, double[] beta_given, double[] rho) {
            for (int i = 0; i < beta.length; ++i) {
                double diff = beta[i] - beta_given[i];
                double pen = rho[i] * diff;
                if (grad != null) {
                    int n = i;
                    grad[n] = grad[n] + pen;
                }
                obj += 0.5 * pen * diff;
            }
            return obj;
        }

        private ProximalGradientInfo computeProxGrad(OptimizationUtils.GradientInfo ginfo, double[] beta) {
            assert (!(ginfo instanceof ProximalGradientInfo));
            double[] gradient = (double[])ginfo._gradient.clone();
            double obj = ProximalGradientSolver.proximal_gradient(gradient, ginfo._objVal, beta, this._betaGiven, this._rho);
            return new ProximalGradientInfo(ginfo, obj, gradient);
        }

        @Override
        public ProximalGradientInfo getGradient(double[] beta) {
            return this.computeProxGrad(this._solver.getGradient(beta), beta);
        }

        @Override
        public OptimizationUtils.GradientInfo getObjective(double[] beta) {
            OptimizationUtils.GradientInfo ginfo = this._solver.getObjective(beta);
            double obj = ProximalGradientSolver.proximal_gradient(null, ginfo._objVal, beta, this._betaGiven, this._rho);
            return new ProximalGradientInfo(ginfo, obj, null);
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public boolean solve(double[] beta_given, double[] beta) {
            OptimizationUtils.GradientInfo origGinfo = this._ginfo == null || !Arrays.equals(this._beta, beta) ? this._solver.getGradient(beta) : this._ginfo._origGinfo;
            System.arraycopy(beta_given, 0, this._betaGiven, 0, beta_given.length);
            this._ginfo = this.computeProxGrad(origGinfo, beta);
            L_BFGS.Result r = new L_BFGS().setObjEps(this._objEps).setGradEps(this._gradEps).solve(this, beta, this._ginfo, this._pm);
            System.arraycopy(r.coefs, 0, beta, 0, r.coefs.length);
            this._beta = r.coefs;
            this._iter += r.iter;
            this._ginfo = (ProximalGradientInfo)r.ginfo;
            return r.converged;
        }

        @Override
        public boolean hasGradient() {
            return true;
        }

        @Override
        public OptimizationUtils.GradientInfo gradient(double[] beta) {
            return this.getGradient((double[])beta)._origGinfo;
        }

        @Override
        public int iter() {
            return this._iter;
        }
    }

    public static class ProximalGradientInfo
    extends OptimizationUtils.GradientInfo {
        final OptimizationUtils.GradientInfo _origGinfo;

        public ProximalGradientInfo(OptimizationUtils.GradientInfo origGinfo, double objVal, double[] gradient) {
            super(objVal, gradient);
            this._origGinfo = origGinfo;
        }
    }

    public static final class GramSolver
    implements ADMM.ProximalSolver {
        private final Gram _gram;
        private Gram.Cholesky _chol;
        private final double[] _xy;
        final double _lambda;
        double[] _rho;
        boolean _addedL2;
        double _betaEps;

        private static double boundedX(double x, double lb, double ub) {
            if (x < lb) {
                x = lb;
            }
            if (x > ub) {
                x = ub;
            }
            return x;
        }

        public GramSolver(Gram gram, double[] xy, double lmax, double betaEps, boolean intercept) {
            this._gram = gram;
            this._lambda = 0.0;
            this._betaEps = betaEps;
            this._xy = xy;
            double[] rhos = MemoryManager.malloc8d((int)xy.length);
            this.computeCholesky(gram, rhos, lmax * 1.0E-8, intercept);
            this._addedL2 = rhos[0] != 0.0;
            this._rho = (double[])(this._addedL2 ? rhos : null);
        }

        public void solve(double[] result) {
            System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            this._chol.solve(result);
            double gerr = Double.POSITIVE_INFINITY;
            if (this._addedL2) {
                double[] oldRes = MemoryManager.arrayCopyOf((double[])result, (int)result.length);
                for (int i = 0; i < 1000; ++i) {
                    this.solve(oldRes, result);
                    double[] g = this.gradient((double[])result)._gradient;
                    gerr = Math.max(-ArrayUtils.minValue((double[])g), ArrayUtils.maxValue((double[])g));
                    if (gerr < 1.0E-4) {
                        return;
                    }
                    System.arraycopy(result, 0, oldRes, 0, result.length);
                }
                Log.warn((Object[])new Object[]{"Gram solver did not converge, gerr = " + gerr});
            }
        }

        public GramSolver(Gram gram, double[] xy, boolean intercept, double l2pen, double l1pen, double[] beta_given, double[] proxPen, double[] lb, double[] ub) {
            int i;
            if (ub != null && lb != null) {
                for (int i2 = 0; i2 < ub.length; ++i2) {
                    assert (ub[i2] >= lb[i2]) : i2 + ": ub < lb, ub = " + Arrays.toString(ub) + ", lb = " + Arrays.toString(lb);
                }
            }
            this._lambda = l2pen;
            this._gram = gram;
            int ii = intercept ? 1 : 0;
            int icptCol = gram.fullN() - 1;
            double[] rhos = MemoryManager.malloc8d((int)xy.length);
            double min = Double.POSITIVE_INFINITY;
            for (int i3 = 0; i3 < xy.length - ii; ++i3) {
                double d = xy[i3];
                double d2 = d = d >= 0.0 ? d : -d;
                if (!(d < min) || d == 0.0) continue;
                min = d;
            }
            double ybar = xy[icptCol];
            for (i = 0; i < rhos.length - ii; ++i) {
                double y = xy[i];
                if (y == 0.0) {
                    y = min;
                }
                double xbar = gram.get(icptCol, i);
                double x = (y - ybar * xbar) / (gram.get(i, i) - xbar * xbar + l2pen);
                rhos[i] = ADMM.L1Solver.estimateRho(x, l1pen, lb == null ? Double.NEGATIVE_INFINITY : lb[i], ub == null ? Double.POSITIVE_INFINITY : ub[i]);
            }
            if (intercept && (lb != null && !Double.isInfinite(lb[icptCol]) || ub != null && !Double.isInfinite(ub[icptCol]))) {
                int icpt = xy.length - 1;
                rhos[icpt] = 1.0;
            }
            if (l2pen > 0.0) {
                gram.addDiag(l2pen);
            }
            if (proxPen != null && beta_given != null) {
                gram.addDiag(proxPen);
                xy = (double[])xy.clone();
                for (i = 0; i < xy.length; ++i) {
                    int n = i;
                    xy[n] = xy[n] + proxPen[i] * beta_given[i];
                }
            }
            this._xy = xy;
            this._rho = rhos;
            this.computeCholesky(gram, rhos, 1.0E-5, intercept);
        }

        private void computeCholesky(Gram gram, double[] rhos, double rhoAdd, boolean intercept) {
            gram.addDiag(rhos);
            if (!intercept) {
                gram.dropIntercept();
                rhos = Arrays.copyOf(rhos, rhos.length - 1);
                this._xy[this._xy.length - 1] = 0.0;
            }
            this._chol = gram.cholesky(null, true, null);
            if (!this._chol.isSPD()) {
                gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
                gram.addDiag(rhoAdd, !intercept);
                Log.info((Object[])new Object[]{"Got NonSPD matrix with original rho, re-computing with rho = " + (this._rho[0] + rhoAdd)});
                this._chol = gram.cholesky(null, true, null);
                int cnt = 0;
                double rhoAddSum = rhoAdd;
                while (!this._chol.isSPD() && cnt++ < 5) {
                    gram.addDiag(rhoAdd, !intercept);
                    Log.warn((Object[])new Object[]{"Still NonSPD matrix, re-computing with rho = " + (rhos[0] + (rhoAddSum += rhoAdd))});
                    this._chol = gram.cholesky(null, true, null);
                }
                if (!this._chol.isSPD()) {
                    throw new Gram.NonSPDMatrixException();
                }
            }
            gram.addDiag(ArrayUtils.mult((double[])rhos, (double)-1.0));
            ArrayUtils.mult((double[])rhos, (double)-1.0);
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public boolean solve(double[] beta_given, double[] result) {
            if (beta_given != null) {
                for (int i = 0; i < this._xy.length; ++i) {
                    result[i] = this._xy[i] + this._rho[i] * beta_given[i];
                }
            } else {
                System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            }
            this._chol.solve(result);
            return true;
        }

        @Override
        public boolean hasGradient() {
            return false;
        }

        @Override
        public OptimizationUtils.GradientInfo gradient(double[] beta) {
            double[] grad = this._gram.mul(beta);
            for (int i = 0; i < this._xy.length; ++i) {
                int n = i;
                grad[n] = grad[n] - this._xy[i];
            }
            return new OptimizationUtils.GradientInfo(Double.NaN, grad);
        }

        @Override
        public int iter() {
            return 0;
        }
    }

    public final class GLMDriver
    extends ModelBuilder.Driver
    implements L_BFGS.ProgressMonitor {
        private long _workPerIteration;
        private transient double[][] _vcov;
        private transient Gram.Cholesky _chol;
        private transient ADMM.L1Solver _lslvr;
        private long _lastScore;
        private transient double _nullDevTrain;
        private transient double _nullDevTest;
        private transient long _scoringInterval;

        public GLMDriver() {
            super((ModelBuilder)GLM.this);
            this._lastScore = System.currentTimeMillis();
            this._nullDevTrain = Double.NaN;
            this._nullDevTest = Double.NaN;
            this._scoringInterval = 15000L;
        }

        private void doCleanup() {
            try {
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLMModel.GLMParameters)GLM.this._parms)._is_cv_model) {
                    Scope.untrack((Key[])GLM.this.removeLater(new Key[]{GLM.this._dinfo.getWeightsVec()._key}));
                }
                if (((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                    Key[] vecKeys = GLM.this._toRemove;
                    for (int index = 0; index < vecKeys.length; ++index) {
                        Vec tempVec = (Vec)DKV.getGet((Key)vecKeys[index]);
                        tempVec.remove();
                    }
                }
                if (GLM.this._model != null) {
                    GLM.this._model.unlock(GLM.this._job);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        int[] findZeros(double[] vals) {
            int[] res = new int[4];
            int cnt = 0;
            for (int i = 0; i < vals.length; ++i) {
                if (vals[i] != 0.0) continue;
                if (res.length == cnt) {
                    res = Arrays.copyOf(res, res.length * 2);
                }
                res[cnt++] = i;
            }
            return Arrays.copyOf(res, cnt);
        }

        private double[] ADMM_solve(Gram gram, double[] xy) {
            if (((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns || ((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values) {
                Gram.Cholesky chol;
                if (!((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    throw H2O.unimpl();
                }
                ArrayList<Integer> ignoredCols = new ArrayList<Integer>();
                Gram.Cholesky cholesky = chol = ((GLM)GLM.this)._state._iter == 0 ? gram.qrCholesky(ignoredCols, ((GLMModel.GLMParameters)GLM.this._parms)._standardize) : gram.cholesky(null);
                if (!ignoredCols.isEmpty() && !((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns) {
                    int[] collinear_cols = new int[ignoredCols.size()];
                    for (int i = 0; i < collinear_cols.length; ++i) {
                        collinear_cols[i] = ignoredCols.get(i);
                    }
                    throw new Gram.CollinearColumnsException("Found collinear columns in the dataset. P-values can not be computed with collinear columns in the dataset. Set remove_collinear_columns flag to true to remove collinear columns automatically. Found collinear columns " + Arrays.toString(ArrayUtils.select((String[])GLM.this._dinfo.coefNames(), (int[])collinear_cols)));
                }
                if (!chol.isSPD()) {
                    throw new Gram.NonSPDMatrixException();
                }
                this._chol = chol;
                if (!ignoredCols.isEmpty()) {
                    int[] collinear_cols = new int[ignoredCols.size()];
                    for (int i = 0; i < collinear_cols.length; ++i) {
                        collinear_cols[i] = ignoredCols.get(i);
                    }
                    Object[] collinear_col_names = ArrayUtils.select((String[])GLM.this._state.activeData().coefNames(), (int[])collinear_cols);
                    GLM.this._model.addWarning("Removed collinear columns " + Arrays.toString(collinear_col_names));
                    Log.warn((Object[])new Object[]{"Removed collinear columns " + Arrays.toString(collinear_col_names)});
                    GLM.this._state.removeCols(collinear_cols);
                    gram.dropCols(collinear_cols);
                    xy = ArrayUtils.removeIds((double[])xy, (int[])collinear_cols);
                }
                xy = (double[])xy.clone();
                chol.solve(xy);
            } else {
                gram = gram.deep_clone();
                xy = (double[])xy.clone();
                GramSolver slvr = new GramSolver((Gram)gram.clone(), (double[])xy.clone(), ((GLMModel.GLMParameters)GLM.this._parms)._intercept, GLM.this._state.l2pen(), GLM.this._state.l1pen(), ((GLM)GLM.this)._state.activeBC()._betaGiven, ((GLM)GLM.this)._state.activeBC()._rho, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                this._chol = slvr._chol;
                if (GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds()) {
                    slvr.solve(xy);
                } else {
                    xy = MemoryManager.malloc8d((int)xy.length);
                    if (((GLM)GLM.this)._state._u == null && ((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.multinomial) {
                        ((GLM)GLM.this)._state._u = MemoryManager.malloc8d((int)(GLM.this._state.activeData().fullN() + 1));
                    }
                    this._lslvr = new ADMM.L1Solver(1.0E-4, 10000, ((GLM)GLM.this)._state._u);
                    this._lslvr.solve(slvr, xy, GLM.this._state.l1pen(), ((GLMModel.GLMParameters)GLM.this._parms)._intercept, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                }
            }
            return xy;
        }

        private void fitCOD_multinomial(GLMModel.GLMParameters.Solver s) {
            double[] beta = GLM.this._state.betaMultinomial();
            do {
                beta = (double[])beta.clone();
                for (int c = 0; c < GLM.this._nclass; ++c) {
                    OptimizationUtils.LineSearchSolver ls;
                    boolean onlyIcpt;
                    GLM.this._state.setActiveClass(c);
                    boolean bl = onlyIcpt = GLM.this._state.activeDataMultinomial(c).fullN() == 0;
                    if (GLM.this._state.l1pen() == 0.0) {
                        if (GLM.this._state.ginfoNull()) {
                            GLM.this._state.updateState(beta, GLM.this._state.gslvr().getGradient(beta));
                        }
                        ls = new OptimizationUtils.MoreThuente(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c, beta), GLM.this._state.ginfoMultinomial(c));
                    } else {
                        ls = new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c, beta), GLM.this._state.l1pen());
                    }
                    new GLMTask.GLMMultinomialUpdate(GLM.this._state.activeDataMultinomial(), GLM.this._job._key, beta, c).doAll(((GLM)GLM.this)._state.activeDataMultinomial()._adaptedFrame);
                    ComputationState.GramXY gram = GLM.this._state.computeGram(GLM.this._state.betaMultinomial(c, beta), s);
                    double[] betaCnd = GLM.this.COD_solve(gram, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda());
                    if (!onlyIcpt && !ls.evaluate(ArrayUtils.subtract((double[])betaCnd, (double[])ls.getX(), (double[])betaCnd))) {
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("Ls failed " + ls)});
                        continue;
                    }
                    GLM.this._state.setBetaMultinomial(c, beta, ls.getX());
                }
                GLM.this._state.setActiveClass(-1);
            } while (this.progress(beta, GLM.this._state.gslvr().getMultinomialLikelihood(beta)));
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                GLM.this._state.updateState(beta, GLM.this._state.gslvr().getGradient(beta));
            }
        }

        public Frame makeZeroOrOneFrame(long rowNumber, int colNumber, int val, String[] columnNames) {
            Frame madeFrame;
            Vec tempVec = val == 0 ? Vec.makeZero((long)rowNumber) : Vec.makeOne((long)rowNumber);
            Frame frame = madeFrame = val == 0 ? new Frame(tempVec.makeZeros(colNumber)) : new Frame(tempVec.makeOnes(colNumber));
            if (columnNames != null) {
                if (columnNames.length == colNumber) {
                    madeFrame.setNames(columnNames);
                } else {
                    throw new IllegalArgumentException("Column names length and number of columns in Frame differ.");
                }
            }
            this.cleanupHGLMMemory(null, null, new Vec[]{tempVec}, null);
            return madeFrame;
        }

        private double[] fitCoeffs(int[] randCatLevels, int totRandCatLevels, Frame returnFrame, int[] dinfoWCol, int[] wCol, int etaOColIndexReturnFrame, int dinfoResponseColID, double[] sumEtaInfo, Frame augXZ, double[][] cholR) {
            GLMTask.CalculateW4Data calculateW4Data;
            Frame qMatrix = this.makeZeroOrOneFrame(GLM.this._dinfo._adaptedFrame.numRows() + (long)ArrayUtils.sum((int[])GLM.this._randC), GLM.this._state.beta().length + GLM.this._state.ubeta().length, 0, null);
            Frame augZW = this.makeZeroOrOneFrame(augXZ.numRows(), 1, 0, new String[]{"AugZ*W"});
            int betaLength = GLM.this._state.beta().length;
            int ubetaLength = GLM.this._state.ubeta().length;
            double[] start_delta = MemoryManager.malloc8d((int)(betaLength + ubetaLength));
            int iteration = 0;
            new GLMTask.CopyPartsOfFrame(GLM.this._dinfo._adaptedFrame, new int[]{etaOColIndexReturnFrame}, new int[]{GLM.this._dinfo.responseChunkId(dinfoResponseColID)}, GLM.this._dinfo._adaptedFrame.numRows()).doAll(returnFrame);
            new GLMTask.CalculateW4Rand(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, randCatLevels, GLM.this._state.get_psi(), GLM.this._state.get_phi(), GLM.this._state.ubeta()).doAll(GLM.this._state.get_priorw_wpsi());
            new GLMTask.RandColAddW2AugXZ(GLM.this._job, GLM.this._randC, GLM.this._state.get_priorw_wpsi(), 1, GLM.this._dinfo._adaptedFrame.numRows(), augXZ.numCols() - ArrayUtils.sum((int[])GLM.this._randC), augXZ.numCols()).doAll(augXZ);
            do {
                start_delta = this.calculate_all_beta(start_delta, augXZ, augZW, totRandCatLevels, cholR);
                new GLMTask.CopyPartsOfFrame(augXZ, null, null, qMatrix.numRows()).doAll(qMatrix);
                GLM.this._state.set_beta_HGLM(start_delta, 0, betaLength, true);
                GLM.this._state.set_ubeta_HGLM(start_delta, betaLength, ubetaLength);
                calculateW4Data = this.calculateNewWAugXZ(augXZ, GLM.this._randC);
            } while (this.progressHGLMGLMMME(calculateW4Data._sumEtaDiffSq, calculateW4Data._sumEtaSq, ++iteration, true, null, null, null, null, null, null, null, null));
            if (iteration > ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                Log.debug((Object[])new Object[]{GLM.this.LogMsg("HGLM GLM.MME did not converge in " + iteration + " iterations.")});
            }
            GLMTask.ReturnGLMMMERunInfoData glmRunInfoData = (GLMTask.ReturnGLMMMERunInfoData)new GLMTask.ReturnGLMMMERunInfoData(GLM.this._job, GLM.this._dinfo, qMatrix, dinfoWCol, (GLMModel.GLMParameters)GLM.this._parms).doAll(returnFrame);
            GLMTask.ReturnGLMMMERunInfoRandCols glmRunInfo = (GLMTask.ReturnGLMMMERunInfoRandCols)new GLMTask.ReturnGLMMMERunInfoRandCols(GLM.this._job, GLM.this._dinfo, GLM.this._state.get_priorw_wpsi(), qMatrix, wCol, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.get_psi(), GLM.this._state.ubeta(), ArrayUtils.cumsum((int[])randCatLevels)).doAll(returnFrame);
            glmRunInfo._sumDev += glmRunInfoData._sumDev;
            new GLMTask.GenerateResid(GLM.this._job, 1.0 / Math.sqrt(glmRunInfo._sumDev / (double)(returnFrame.numRows() - (long)(betaLength + ubetaLength))), 1, 4, GLM.this._dinfo._adaptedFrame.numRows()).doAll(returnFrame);
            sumEtaInfo[0] = glmRunInfoData._sumEtaDiffSq;
            sumEtaInfo[1] = glmRunInfoData._sumEtaSq;
            this.cleanupHGLMMemory(null, new Frame[]{augZW, qMatrix}, null, null);
            return sumEtaInfo;
        }

        public GLMTask.CalculateW4Data calculateNewWAugXZ(Frame augXZ, int[] randCatLevels) {
            GLMTask.CalculateW4Data calculateW4Data = (GLMTask.CalculateW4Data)new GLMTask.CalculateW4Data(GLM.this._job, GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, randCatLevels, GLM.this._state.beta(), GLM.this._state.ubeta(), GLM.this._state.get_psi(), GLM.this._state.get_phi(), GLM.this._state.get_tau(), GLM.this._state.get_correction_HL()).doAll(GLM.this._dinfo._adaptedFrame);
            new GLMTask.CalculateW4Rand(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, randCatLevels, GLM.this._state.get_psi(), GLM.this._state.get_phi(), GLM.this._state.ubeta()).doAll(GLM.this._state.get_priorw_wpsi());
            new GLMTask.DataAddW2AugXZ(GLM.this._job, GLM.this._dinfo, GLM.this._randC).doAll(augXZ);
            new GLMTask.RandColAddW2AugXZ(GLM.this._job, GLM.this._randC, GLM.this._state.get_priorw_wpsi(), 1, GLM.this._dinfo._adaptedFrame.numRows(), augXZ.numCols() - ArrayUtils.sum((int[])GLM.this._randC), augXZ.numCols()).doAll(augXZ);
            return calculateW4Data;
        }

        public void copyOver(double[][] cholR, double[][] cholRcopy) {
            int dim1 = cholR.length;
            int dim2 = cholR[0].length;
            for (int index = 0; index < dim1; ++index) {
                System.arraycopy(cholR[index], 0, cholRcopy[index], 0, dim2);
            }
        }

        public double[] calculate_all_beta(double[] start_delta, Frame augXZ, Frame augZW, int totRandCatLevels, double[][] cholRcopy) {
            DataInfo augXZInfo = new DataInfo(augXZ, null, true, DataInfo.TransformType.NONE, true, false, false);
            DKV.put((Key)augXZInfo._key, (Iced)augXZInfo);
            double[][] cholR = ArrayUtils.transpose((double[][])LinearAlgebraUtils.computeQInPlace((Key<Job>)GLM.this._job._key, augXZInfo));
            this.copyOver(cholR, cholRcopy);
            Frame qTransposed = DMatrix.transpose((Frame)augXZ);
            new GLMTask.CalculateAugZWData(GLM.this._job, GLM.this._dinfo, GLM.this._dinfo.responseChunkId(1)).doAll(augZW);
            new GLMTask.CalculateAugZWRandCols(GLM.this._job, GLM.this._state.get_priorw_wpsi(), 1, GLM.this._dinfo._adaptedFrame.numRows()).doAll(augZW);
            double[][] augZWTransposed = new double[][]{FrameUtils.asDoubles((Vec)augZW.vec(0))};
            DataInfo qTinfo = new DataInfo(qTransposed, null, true, DataInfo.TransformType.NONE, true, false, false);
            DKV.put((Key)qTinfo._key, (Iced)qTinfo);
            Frame qTAugZW = ((LinearAlgebraUtils.BMulTask)new LinearAlgebraUtils.BMulTask((Key<Job>)GLM.this._job._key, qTinfo, augZWTransposed).doAll(augZWTransposed.length, (byte)3, qTinfo._adaptedFrame)).outputFrame(Key.make((String)"Q*Augz*W"), null, null);
            double[] qtaugzw = ((FrameUtils.Vec2ArryTsk)new FrameUtils.Vec2ArryTsk((int)((int)qTAugZW.numRows())).doAll((Vec[])new Vec[]{qTAugZW.vec((int)0)})).res;
            start_delta = LinearAlgebraUtils.backwardSolve(cholR, qtaugzw, start_delta);
            this.cleanupHGLMMemory(new DataInfo[]{qTinfo, augXZInfo}, new Frame[]{qTransposed, qTAugZW}, null, new Key[]{qTinfo._key, augXZInfo._key});
            return start_delta;
        }

        private void cleanupHGLMMemory(DataInfo[] tempdInfo, Frame[] tempFrames, Vec[] tempVectors, Key[] dkvKeys) {
            int index;
            if (tempdInfo != null) {
                for (index = 0; index < tempdInfo.length; ++index) {
                    if (tempdInfo[index] == null) continue;
                    tempdInfo[index].remove();
                }
            }
            if (tempFrames != null) {
                for (index = 0; index < tempFrames.length; ++index) {
                    if (tempFrames[index] == null) continue;
                    tempFrames[index].delete();
                }
            }
            if (tempVectors != null) {
                for (index = 0; index < tempVectors.length; ++index) {
                    if (tempVectors[index] == null) continue;
                    tempVectors[index].remove();
                }
            }
            if (dkvKeys != null) {
                for (index = 0; index < dkvKeys.length; ++index) {
                    if (dkvKeys[index] == null) continue;
                    DKV.remove((Key)dkvKeys[index]);
                }
            }
        }

        private void fitHGLM() {
            GLMModel fixedModel;
            int[] nArray;
            int numRandCols = ((GLMModel.GLMParameters)GLM.this._parms)._random_columns.length;
            int totRandCatLevels = ArrayUtils.sum((int[])GLM.this._randC);
            int[] cumSumRandLevels = ArrayUtils.cumsum((int[])GLM.this._randC);
            Frame glmmmeReturnFrame = this.makeZeroOrOneFrame((long)totRandCatLevels + GLM.this._dinfo._adaptedFrame.numRows(), 6, 0, new String[]{"AugZ", "hv", "dev", "eta.i", "resid", "etao"});
            Frame hvDataOnly = this.makeZeroOrOneFrame(GLM.this._dinfo._adaptedFrame.numRows(), 1, 0, new String[]{"hv_data"});
            if (GLM.this._dinfo._weights) {
                int[] nArray2 = new int[4];
                nArray2[0] = GLM.this._dinfo.responseChunkId(0);
                nArray2[1] = GLM.this._dinfo.responseChunkId(2);
                nArray2[2] = GLM.this._dinfo.responseChunkId(3);
                nArray = nArray2;
                nArray2[3] = GLM.this._dinfo.weightChunkId();
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = GLM.this._dinfo.responseChunkId(0);
                nArray3[1] = GLM.this._dinfo.responseChunkId(2);
                nArray = nArray3;
                nArray3[2] = GLM.this._dinfo.responseChunkId(3);
            }
            int[] dinfoWCol = nArray;
            int[] wCol = new int[]{0, 2};
            int[] devHvColIdx = new int[]{2, 1};
            double[] sumEtaInfo = new double[2];
            long numDataRows = GLM.this._dinfo._adaptedFrame.numRows();
            double[][] VC2 = new double[numRandCols][2];
            double[] VC1 = new double[2];
            int iter = 0;
            Frame augXZ = this.makeZeroOrOneFrame(GLM.this._dinfo._adaptedFrame.numRows() + (long)ArrayUtils.sum((int[])GLM.this._randC), GLM.this._state.beta().length + GLM.this._state.ubeta().length, 0, null);
            GLMTask.CalculateW4Data calculateW4Data = (GLMTask.CalculateW4Data)new GLMTask.CalculateW4Data(GLM.this._job, GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._randC, GLM.this._state.beta(), GLM.this._state.ubeta(), GLM.this._state.get_psi(), GLM.this._state.get_phi(), GLM.this._state.get_tau(), GLM.this._state.get_correction_HL()).doAll(GLM.this._dinfo._adaptedFrame);
            new GLMTask.DataAddW2AugXZ(GLM.this._job, GLM.this._dinfo, GLM.this._randC).doAll(augXZ);
            sumEtaInfo[0] = calculateW4Data._sumEtaDiffSq;
            sumEtaInfo[1] = calculateW4Data._sumEtaSq;
            GLM.this._state.set_sumEtaSquareConvergence(sumEtaInfo);
            GLMModel[] randModels = new GLMModel[numRandCols];
            this.updateProgress(null, null, null, null, null, null, Double.NaN, Double.NaN, false, null, null);
            double[][] cholR = new double[augXZ.numCols()][augXZ.numCols()];
            do {
                if (((GLM)GLM.this)._state._iter > 0) {
                    new GLMTask.CalculateW4Data(GLM.this._job, GLM.this._dinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._randC, GLM.this._state.beta(), GLM.this._state.ubeta(), GLM.this._state.get_psi(), GLM.this._state.get_phi(), GLM.this._state.get_tau(), GLM.this._state.get_correction_HL()).doAll(GLM.this._dinfo._adaptedFrame);
                    new GLMTask.DataAddW2AugXZ(GLM.this._job, GLM.this._dinfo, GLM.this._randC).doAll(augXZ);
                }
                sumEtaInfo = this.fitCoeffs(GLM.this._randC, totRandCatLevels, glmmmeReturnFrame, dinfoWCol, wCol, 5, 3, sumEtaInfo, augXZ, cholR);
                fixedModel = this.fitDataDispersion(glmmmeReturnFrame, devHvColIdx, VC1);
                this.estimateRandomCoeffCh(glmmmeReturnFrame, devHvColIdx, cumSumRandLevels, numRandCols, numDataRows, randModels, VC2);
            } while (this.progressHGLMGLMMME(sumEtaInfo[0], sumEtaInfo[1], iter, false, fixedModel, randModels, glmmmeReturnFrame, hvDataOnly, VC1, VC2, cholR, augXZ));
            this.scoreAndUpdateModelHGLM(fixedModel, randModels, glmmmeReturnFrame, hvDataOnly, VC1, VC2, sumEtaInfo[0], sumEtaInfo[1], cholR, augXZ, true);
            fixedModel.remove();
            this.cleanupHGLMMemory(null, new Frame[]{glmmmeReturnFrame, hvDataOnly, augXZ, GLM.this._state.get_priorw_wpsi()}, null, null);
        }

        private void estimateRandomCoeffCh(Frame returnFrame, int[] devHvColIdx, int[] cumSumRandLevels, int numRandCols, long numDataRows, GLMModel[] gRandModels, double[][] VC2) {
            long dev2UseStart = numDataRows;
            int startIndex = 0;
            double[] phi = GLM.this._state.get_phi();
            for (int colIndex = 0; colIndex < numRandCols; ++colIndex) {
                double sigma2u;
                Frame constXYWeight = new Frame(this.makeZeroOrOneFrame(cumSumRandLevels[colIndex], 3, 1, new String[]{"response", "X", "weights"}));
                DKV.put((Key)constXYWeight._key, (Iced)constXYWeight);
                gRandModels[colIndex] = this.buildGammaGLM(returnFrame, constXYWeight, devHvColIdx, dev2UseStart, cumSumRandLevels[colIndex], true);
                double newPhi = sigma2u = Math.exp(gRandModels[colIndex].coefficients().get("Intercept"));
                for (int index = startIndex; index < cumSumRandLevels[colIndex]; ++index) {
                    phi[index] = newPhi;
                }
                GLM.this._state.set_phi(phi);
                startIndex = cumSumRandLevels[colIndex];
                dev2UseStart += (long)cumSumRandLevels[colIndex];
                this.assignEstStdErr(gRandModels[colIndex], VC2[colIndex]);
                this.cleanupHGLMMemory(null, new Frame[]{constXYWeight}, null, new Key[]{constXYWeight._key});
                gRandModels[colIndex].remove();
            }
        }

        public GLMModel fitDataDispersion(Frame returnFrame, int[] devHvColIdx, double[] VC1) {
            Frame constXYWeight = new Frame(this.makeZeroOrOneFrame(GLM.this._dinfo._adaptedFrame.numRows(), 3, 1, new String[]{"response", "X", "weights"}));
            DKV.put((Key)constXYWeight._key, (Iced)constXYWeight);
            GLMModel gfixed = this.buildGammaGLM(returnFrame, constXYWeight, devHvColIdx, 0L, GLM.this._dinfo._adaptedFrame.numRows(), true);
            double sigma2e = Math.exp(gfixed.coefficients().get("Intercept"));
            GLM.this._state.set_tau(sigma2e);
            this.assignEstStdErr(gfixed, VC1);
            this.cleanupHGLMMemory(null, new Frame[]{constXYWeight}, null, new Key[]{constXYWeight._key});
            gfixed.remove();
            return gfixed;
        }

        private void assignEstStdErr(GLMModel glm, double[] VC) {
            double[] stdErr = ((GLMModel.GLMOutput)glm._output).stdErr();
            VC[0] = glm.coefficients().get("Intercept");
            VC[1] = stdErr[0];
        }

        public GLMModel buildGammaGLM(Frame returnFrame, Frame constXYWeight, int[] devHvColIdx, long startRowIndex, long numRows, boolean computePValues) {
            new GLMTask.ExtractFrameFromSourceWithProcess(returnFrame, devHvColIdx, startRowIndex, numRows).doAll(constXYWeight);
            DKV.put((Key)constXYWeight._key, (Iced)constXYWeight);
            boolean originalPValues = ((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values;
            boolean originalDispersion = ((GLMModel.GLMParameters)GLM.this._parms)._useDispersion1;
            ((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values = computePValues;
            ((GLMModel.GLMParameters)GLM.this._parms)._useDispersion1 = computePValues;
            GLMModel g11 = GLM.this.runGLMModel(((GLMModel.GLMParameters)GLM.this._parms)._standardize, GLMModel.GLMParameters.Family.gamma, GLMModel.GLMParameters.Link.log, (Key<Frame>)constXYWeight._key, "response", "weights", null, computePValues);
            ((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values = originalPValues;
            ((GLMModel.GLMParameters)GLM.this._parms)._useDispersion1 = originalDispersion;
            return g11;
        }

        private void fitIRLSM_multinomial(GLMModel.GLMParameters.Solver s) {
            assert (GLM.this._dinfo._responses == 3) : "IRLSM for multinomial needs extra information encoded in additional reponses, expected 3 response vecs, got " + GLM.this._dinfo._responses;
            if (s.equals((Object)GLMModel.GLMParameters.Solver.COORDINATE_DESCENT)) {
                this.fitCOD_multinomial(s);
            } else {
                double[] beta = GLM.this._state.betaMultinomial();
                do {
                    beta = (double[])beta.clone();
                    for (int c = 0; c < GLM.this._nclass; ++c) {
                        boolean onlyIcpt = GLM.this._state.activeDataMultinomial(c).fullN() == 0;
                        GLM.this._state.setActiveClass(c);
                        OptimizationUtils.LineSearchSolver ls = GLM.this._state.l1pen() == 0.0 ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c, beta), GLM.this._state.ginfoMultinomial(c)) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c, beta), GLM.this._state.l1pen());
                        long t1 = System.currentTimeMillis();
                        new GLMTask.GLMMultinomialUpdate(GLM.this._state.activeDataMultinomial(), GLM.this._job._key, beta, c).doAll(((GLM)GLM.this)._state.activeDataMultinomial()._adaptedFrame);
                        long t2 = System.currentTimeMillis();
                        ComputationState.GramXY gram = GLM.this._state.computeGram(ls.getX(), s);
                        long t3 = System.currentTimeMillis();
                        double[] betaCnd = this.ADMM_solve(gram.gram, gram.xy);
                        long t4 = System.currentTimeMillis();
                        if (!onlyIcpt && !ls.evaluate(ArrayUtils.subtract((double[])betaCnd, (double[])ls.getX(), (double[])betaCnd))) {
                            Log.info((Object[])new Object[]{GLM.this.LogMsg("Ls failed " + ls)});
                            continue;
                        }
                        long t5 = System.currentTimeMillis();
                        GLM.this._state.setBetaMultinomial(c, beta, ls.getX());
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "+" + (t4 - t3) + "+" + (t5 - t4) + "=" + (t5 - t1) + "ms, step = " + ls.step() + (this._lslvr != null ? ", l1solver " + this._lslvr : ""))});
                    }
                    GLM.this._state.setActiveClass(-1);
                } while (this.progress(beta, GLM.this._state.gslvr().getGradient(beta)));
            }
        }

        private void fitIRLSM_ordinal_default(GLMModel.GLMParameters.Solver s) {
            assert (GLM.this._dinfo._responses == 3) : "Solver for ordinal needs extra information encoded in additional reponses, expected 3 response vecs, got " + GLM.this._dinfo._responses;
            double[] beta = GLM.this._state.betaMultinomial();
            int predSize = GLM.this._dinfo.fullN();
            int predSizeP1 = predSize + 1;
            int numClass = ((GLM)GLM.this)._state._nclasses;
            int numIcpt = numClass - 1;
            double[] betaCnd = new double[predSize];
            GLM.this._state.gslvr().getGradient(beta);
            double l1pen = GLM.this._state.lambda() * ((GLM)GLM.this)._state._alpha;
            boolean stopNow = false;
            do {
                int pindex;
                beta = (double[])beta.clone();
                double[] grads = ((GLM)GLM.this)._state.ginfo()._gradient;
                for (pindex = 0; pindex < numIcpt; ++pindex) {
                    int previousIcpt;
                    int icptindex;
                    int n = icptindex = (pindex + 1) * predSizeP1 - 1;
                    beta[n] = beta[n] - grads[icptindex];
                    if (pindex <= 0 || !(beta[icptindex] < beta[previousIcpt = pindex * predSizeP1 - 1])) continue;
                    GLM.this.warn("Ordinal regression training: ", " intercepts of previous class exceed that of current class.  Make sure your training parameters are set properly.  Training will stop now with the last eligible parameters.");
                    stopNow = true;
                    for (int index = 0; index <= pindex; ++index) {
                        int n2 = icptindex = (index + 1) * predSizeP1 - 1;
                        beta[n2] = beta[n2] + grads[icptindex];
                    }
                    break;
                }
                if (stopNow) break;
                for (pindex = 0; pindex < predSize; ++pindex) {
                    betaCnd[pindex] = grads[pindex];
                    if (l1pen > 0.0) {
                        int n = pindex;
                        betaCnd[n] = betaCnd[n] + (beta[pindex] > 0.0 ? l1pen : (beta[pindex] == 0.0 ? 0.0 : -l1pen));
                    }
                    int n = pindex;
                    beta[n] = beta[n] - betaCnd[pindex];
                }
                for (int indC = 1; indC < numIcpt; ++indC) {
                    int indOffset = indC * predSizeP1;
                    for (int index = 0; index < predSize; ++index) {
                        beta[indOffset + index] = beta[index];
                    }
                }
                GLM.this._state.setActiveClass(-1);
            } while (this.progress(beta, GLM.this._state.gslvr().getGradient(beta)));
        }

        private void fitLSM(GLMModel.GLMParameters.Solver s) {
            long t0 = System.currentTimeMillis();
            ComputationState.GramXY gramXY = GLM.this._state.computeGram(GLM.this._state.beta(), s);
            Log.info((Object[])new Object[]{GLM.this.LogMsg("Gram computed in " + (System.currentTimeMillis() - t0) + "ms")});
            double[] beta = ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT ? GLM.this.COD_solve(gramXY, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda()) : this.ADMM_solve(gramXY.gram, gramXY.xy);
            double[] x = ArrayUtils.mmul((double[][])gramXY.gram.getXX(), (double[])beta);
            for (int i = 0; i < x.length; ++i) {
                x[i] = x[i] - 2.0 * gramXY.xy[i];
            }
            double l = 0.5 * (ArrayUtils.innerProduct((double[])x, (double[])beta) / ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg + gramXY.yy);
            ++((GLM)GLM.this)._state._iter;
            GLM.this._state.updateState(beta, l);
        }

        private void fitIRLSM(GLMModel.GLMParameters.Solver s) {
            GLMModel.GLMWeightsFun glmw = new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms);
            double[] betaCnd = GLM.this._state.beta();
            OptimizationUtils.LineSearchSolver ls = null;
            boolean firstIter = true;
            int iterCnt = 0;
            try {
                while (true) {
                    ++iterCnt;
                    long t1 = System.currentTimeMillis();
                    ComputationState.GramXY gram = GLM.this._state.computeGram(betaCnd, s);
                    long t2 = System.currentTimeMillis();
                    if (!((GLM)GLM.this)._state._lsNeeded && (Double.isNaN(gram.likelihood) || GLM.this._state.objective(gram.beta, gram.likelihood) > GLM.this._state.objective() + ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon)) {
                        ((GLM)GLM.this)._state._lsNeeded = true;
                    } else {
                        if (!(firstIter || ((GLM)GLM.this)._state._lsNeeded || this.progress(gram.beta, gram.likelihood))) {
                            System.out.println("DONE after " + (iterCnt - 1) + " iterations (1)");
                            return;
                        }
                        betaCnd = s == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT ? GLM.this.COD_solve(gram, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda()) : this.ADMM_solve(gram.gram, gram.xy);
                    }
                    firstIter = false;
                    long t3 = System.currentTimeMillis();
                    if (((GLM)GLM.this)._state._lsNeeded) {
                        if (ls == null) {
                            OptimizationUtils.LineSearchSolver lineSearchSolver = ls = GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds() ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvr(), GLM.this._state.beta(), GLM.this._state.ginfo()) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvr(), (double[])GLM.this._state.beta().clone(), GLM.this._state.l1pen(), GLM.this._state.ginfo());
                        }
                        if (!ls.evaluate(ArrayUtils.subtract((double[])betaCnd, (double[])ls.getX(), (double[])betaCnd))) {
                            Log.info((Object[])new Object[]{GLM.this.LogMsg("Ls failed " + ls)});
                            return;
                        }
                        betaCnd = ls.getX();
                        if (!this.progress(betaCnd, ls.ginfo())) {
                            return;
                        }
                        long t4 = System.currentTimeMillis();
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "+" + (t4 - t3) + "=" + (t4 - t1) + "ms, step = " + ls.step() + (this._lslvr != null ? ", l1solver " + this._lslvr : ""))});
                        continue;
                    }
                    Log.info((Object[])new Object[]{GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "=" + (t3 - t1) + "ms, step = " + 1 + (this._lslvr != null ? ", l1solver " + this._lslvr : ""))});
                }
            }
            catch (Gram.NonSPDMatrixException e) {
                Log.warn((Object[])new Object[]{GLM.this.LogMsg("Got Non SPD matrix, stopped.")});
                return;
            }
        }

        private void fitLBFGS() {
            double[] beta = GLM.this._state.beta();
            double l1pen = GLM.this._state.l1pen();
            GLMGradientSolver gslvr = GLM.this._state.gslvr();
            GLMModel.GLMWeightsFun glmw = new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms);
            if (beta == null && (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal)) {
                beta = MemoryManager.malloc8d((int)((GLM.this._state.activeData().fullN() + 1) * GLM.this._nclass));
                int P = GLM.this._state.activeData().fullN() + 1;
                if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    for (int i = 0; i < GLM.this._nclass; ++i) {
                        beta[i * P + P - 1] = glmw.link(((GLM)GLM.this)._state._ymu[i]);
                    }
                }
            }
            if (beta == null) {
                beta = MemoryManager.malloc8d((int)(GLM.this._state.activeData().fullN() + 1));
                if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    beta[beta.length - 1] = glmw.link(((GLM)GLM.this)._state._ymu[0]);
                }
            }
            L_BFGS lbfgs = new L_BFGS().setObjEps(((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon).setGradEps(((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon).setMaxIter(((GLMModel.GLMParameters)GLM.this._parms)._max_iterations);
            assert (beta.length == ((GLM)GLM.this)._state.ginfo()._gradient.length);
            int P = GLM.this._dinfo.fullN();
            if (l1pen > 0.0 || GLM.this._state.activeBC().hasBounds()) {
                double[] nullBeta = MemoryManager.malloc8d((int)beta.length);
                if (GLM.this._dinfo._intercept) {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                        for (int c = 0; c < GLM.this._nclass; ++c) {
                            nullBeta[(c + 1) * (P + 1) - 1] = glmw.link(((GLM)GLM.this)._state._ymu[c]);
                        }
                    } else {
                        nullBeta[nullBeta.length - 1] = glmw.link(((GLM)GLM.this)._state._ymu[0]);
                    }
                }
                GLMGradientInfo ginfo = gslvr.getGradient(nullBeta);
                double[] direction = ArrayUtils.mult((double[])((double[])ginfo._gradient.clone()), (double)-1.0);
                double t = 1.0;
                if (l1pen > 0.0) {
                    OptimizationUtils.MoreThuente mt = new OptimizationUtils.MoreThuente(gslvr, nullBeta);
                    mt.evaluate(direction);
                    t = mt.step();
                }
                double[] rho = MemoryManager.malloc8d((int)beta.length);
                double r = GLM.this._state.activeBC().hasBounds() ? 1.0 : 0.1;
                BetaConstraint bc = GLM.this._state.activeBC();
                for (int i = 0; i < rho.length - 1; ++i) {
                    rho[i] = r * ADMM.L1Solver.estimateRho(nullBeta[i] + t * direction[i], l1pen, bc._betaLB == null ? Double.NEGATIVE_INFINITY : bc._betaLB[i], bc._betaUB == null ? Double.POSITIVE_INFINITY : bc._betaUB[i]);
                }
                for (int ii = P; ii < rho.length; ii += P + 1) {
                    rho[ii] = r * ADMM.L1Solver.estimateRho(nullBeta[ii] + t * direction[ii], 0.0, bc._betaLB == null ? Double.NEGATIVE_INFINITY : bc._betaLB[ii], bc._betaUB == null ? Double.POSITIVE_INFINITY : bc._betaUB[ii]);
                }
                double[] objvals = new double[2];
                objvals[1] = Double.POSITIVE_INFINITY;
                double reltol = ADMM.L1Solver.DEFAULT_RELTOL;
                double abstol = ADMM.L1Solver.DEFAULT_ABSTOL;
                double ADMM_gradEps = 0.001;
                ProximalGradientSolver innerSolver = new ProximalGradientSolver(gslvr, beta, rho, ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon * 0.1, ((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon, GLM.this._state.ginfo(), this);
                ADMM.L1Solver l1Solver = new ADMM.L1Solver(ADMM_gradEps, 250, reltol, abstol, ((GLM)GLM.this)._state._u);
                l1Solver._pm = this;
                l1Solver.solve(innerSolver, beta, l1pen, true, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                ((GLM)GLM.this)._state._u = l1Solver._u;
                GLM.this._state.updateState(beta, gslvr.getGradient(beta));
            } else {
                if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLM)GLM.this)._state._iter == 0 && !((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                    this.updateProgress(false);
                }
                L_BFGS.Result r = lbfgs.solve(gslvr, beta, GLM.this._state.ginfo(), new L_BFGS.ProgressMonitor(){

                    @Override
                    public boolean progress(double[] beta, OptimizationUtils.GradientInfo ginfo) {
                        if (((GLM)GLM.this)._state._iter < 4 || (((GLM)GLM.this)._state._iter & 3) == 0) {
                            Log.info((Object[])new Object[]{GLM.this.LogMsg("LBFGS, gradient norm = " + ArrayUtils.linfnorm((double[])ginfo._gradient, (boolean)false))});
                        }
                        return GLMDriver.this.progress(beta, ginfo);
                    }
                });
                Log.info((Object[])new Object[]{GLM.this.LogMsg(r.toString())});
                GLM.this._state.updateState(r.coefs, (GLMGradientInfo)r.ginfo);
            }
        }

        private void fitCOD() {
            double[] beta = GLM.this._state.beta();
            int p = GLM.this._state.activeData().fullN() + 1;
            boolean skipFirstLevel = !((GLM)GLM.this)._state.activeData()._useAllFactorLevels;
            double[] betaold = (double[])beta.clone();
            double objold = GLM.this._state.objective();
            int iter2 = 0;
            Vec[] newVecs = ((GLM)GLM.this)._state.activeData()._adaptedFrame.anyVec().makeZeros(3);
            Vec w = newVecs[0];
            Vec z = newVecs[1];
            Vec zTilda = newVecs[2];
            long startTimeTotalNaive = System.currentTimeMillis();
            while (iter2++ < 30) {
                double percdiff;
                Frame fr = new Frame(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                fr.add("w", w);
                fr.add("z", z);
                fr.add("zTilda", zTilda);
                GLMTask.GLMGenerateWeightsTask gt = (GLMTask.GLMGenerateWeightsTask)new GLMTask.GLMGenerateWeightsTask(GLM.this._job._key, GLM.this._state.activeData(), (GLMModel.GLMParameters)GLM.this._parms, beta).doAll(fr);
                double objVal = GLM.this.objVal(gt._likelihood, gt._betaw, GLM.this._state.lambda());
                double[] denums = gt.denums;
                double wsum = gt.wsum;
                double wsumu = gt.wsumu;
                int iter1 = 0;
                while (iter1++ < 100) {
                    boolean intercept;
                    Frame fr2 = new Frame(new Vec[0]);
                    fr2.add("w", w);
                    fr2.add("z", z);
                    fr2.add("zTilda", zTilda);
                    for (int i = 0; i < ((GLM)GLM.this)._state.activeData()._cats; ++i) {
                        Frame fr3 = new Frame(fr2);
                        int level_num = ((GLM)GLM.this)._state.activeData()._catOffsets[i + 1] - ((GLM)GLM.this)._state.activeData()._catOffsets[i];
                        int prev_level_num = 0;
                        fr3.add("xj", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i));
                        boolean bl = intercept = i == 0;
                        if (!intercept) {
                            prev_level_num = ((GLM)GLM.this)._state.activeData()._catOffsets[i] - ((GLM)GLM.this)._state.activeData()._catOffsets[i - 1];
                            fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i - 1));
                        }
                        int start_old = ((GLM)GLM.this)._state.activeData()._catOffsets[i];
                        GLMTask.GLMCoordinateDescentTaskSeqNaive stupdate = intercept ? (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, 4, Arrays.copyOfRange(betaold, start_old, start_old + level_num), new double[]{beta[p - 1]}, ((GLM)GLM.this)._state.activeData()._catLvls[i], null, null, null, null, null, skipFirstLevel).doAll(fr3) : (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, 1, Arrays.copyOfRange(betaold, start_old, start_old + level_num), Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[i - 1], ((GLM)GLM.this)._state.activeData()._catOffsets[i]), ((GLM)GLM.this)._state.activeData()._catLvls[i], ((GLM)GLM.this)._state.activeData()._catLvls[i - 1], null, null, null, null, skipFirstLevel).doAll(fr3);
                        for (int j = 0; j < level_num; ++j) {
                            beta[((GLM)GLM.this)._state.activeData()._catOffsets[i] + j] = ADMM.shrinkage(stupdate._temp[j] / wsumu, GLM.this._state.lambda() * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[((GLM)GLM.this)._state.activeData()._catOffsets[i] + j] / wsumu + GLM.this._state.lambda() * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                        }
                    }
                    int cat_num = 2;
                    for (int i = 0; i < ((GLM)GLM.this)._state.activeData()._nums; ++i) {
                        GLMTask.GLMCoordinateDescentTaskSeqNaive stupdate;
                        Frame fr3 = new Frame(fr2);
                        fr3.add("xj", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i + ((GLM)GLM.this)._state.activeData()._cats));
                        intercept = i == 0 && GLM.this._state.activeData().numStart() == 0;
                        double[] meannew = null;
                        double[] meanold = null;
                        double[] varnew = null;
                        double[] varold = null;
                        if (i > 0 || intercept) {
                            cat_num = 3;
                            if (!intercept) {
                                fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i - 1 + ((GLM)GLM.this)._state.activeData()._cats));
                            }
                            if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                                varold = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i]};
                                meanold = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i]};
                                if (i != 0) {
                                    varnew = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i - 1]};
                                    meannew = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i - 1]};
                                }
                            }
                            stupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, cat_num, new double[]{betaold[GLM.this._state.activeData().numStart() + i]}, new double[]{beta[(GLM.this._state.activeData().numStart() + i - 1 + p) % p]}, null, null, varold, meanold, varnew, meannew, skipFirstLevel).doAll(fr3);
                            beta[i + ((GLM)GLM.this)._state.activeData().numStart()] = ADMM.shrinkage(stupdate._temp[0] / wsumu, GLM.this._state.lambda() * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[i + GLM.this._state.activeData().numStart()] / wsumu + GLM.this._state.lambda() * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                            continue;
                        }
                        if (i != 0 || intercept) continue;
                        int prev_level_num = GLM.this._state.activeData().numStart() - ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1];
                        fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats - 1));
                        if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                            varold = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i]};
                            meanold = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i]};
                        }
                        stupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, cat_num, new double[]{betaold[GLM.this._state.activeData().numStart()]}, Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1], GLM.this._state.activeData().numStart()), null, ((GLM)GLM.this)._state.activeData()._catLvls[((GLM)GLM.this)._state.activeData()._cats - 1], varold, meanold, null, null, skipFirstLevel).doAll(fr3);
                        beta[((GLM)GLM.this)._state.activeData().numStart()] = ADMM.shrinkage(stupdate._temp[0] / wsumu, GLM.this._state.lambda() * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[GLM.this._state.activeData().numStart()] / wsumu + GLM.this._state.lambda() * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                    }
                    if (((GLM)GLM.this)._state.activeData()._nums + ((GLM)GLM.this)._state.activeData()._cats > 0) {
                        GLMTask.GLMCoordinateDescentTaskSeqNaive iupdate;
                        Frame fr3 = new Frame(fr2);
                        fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats + ((GLM)GLM.this)._state.activeData()._nums - 1));
                        if (((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats + ((GLM)GLM.this)._state.activeData()._nums - 1).isCategorical()) {
                            cat_num = 2;
                            iupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(false, true, cat_num, new double[]{betaold[betaold.length - 1]}, Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1], ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats]), null, ((GLM)GLM.this)._state.activeData()._catLvls[((GLM)GLM.this)._state.activeData()._cats - 1], null, null, null, null, skipFirstLevel).doAll(fr3);
                        } else {
                            cat_num = 3;
                            double[] meannew = null;
                            double[] varnew = null;
                            if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                                varnew = new double[]{((GLM)GLM.this)._state.activeData()._normMul[((GLM)GLM.this)._state.activeData()._normMul.length - 1]};
                                meannew = new double[]{((GLM)GLM.this)._state.activeData()._normSub[((GLM)GLM.this)._state.activeData()._normSub.length - 1]};
                            }
                            iupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(false, true, cat_num, new double[]{betaold[betaold.length - 1]}, new double[]{beta[beta.length - 2]}, null, null, null, null, varnew, meannew, skipFirstLevel).doAll(fr3);
                        }
                        if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                            beta[beta.length - 1] = iupdate._temp[0] / wsum;
                        }
                    }
                    double maxdiff = ArrayUtils.linfnorm((double[])ArrayUtils.subtract((double[])beta, (double[])betaold), (boolean)false);
                    System.arraycopy(beta, 0, betaold, 0, beta.length);
                    if (!(maxdiff < ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon)) continue;
                    break;
                }
                if ((percdiff = Math.abs((objold - objVal) / objold)) < ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon & iter2 > 1) break;
                objold = objVal;
                System.out.println("iter1 = " + iter1);
            }
            System.out.println("iter2 = " + iter2);
            long endTimeTotalNaive = System.currentTimeMillis();
            long durationTotalNaive = (endTimeTotalNaive - startTimeTotalNaive) / 1000L;
            System.out.println("Time to run Naive Coordinate Descent " + durationTotalNaive);
            ((GLM)GLM.this)._state._iter = iter2;
            for (Vec v : newVecs) {
                v.remove();
            }
            GLM.this._state.updateState(beta, objold);
        }

        private void fitModel() {
            GLMModel.GLMParameters.Solver solver;
            GLMModel.GLMParameters.Solver solver2 = solver = ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.AUTO ? GLM.this.defaultSolver() : ((GLMModel.GLMParameters)GLM.this._parms)._solver;
            if (((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                this.fitHGLM();
            } else {
                switch (solver) {
                    case COORDINATE_DESCENT: 
                    case IRLSM: {
                        if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                            this.fitIRLSM_multinomial(solver);
                            break;
                        }
                        if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                            this.fitIRLSM_ordinal_default(solver);
                            break;
                        }
                        if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.gaussian && ((GLMModel.GLMParameters)GLM.this._parms)._link == GLMModel.GLMParameters.Link.identity) {
                            this.fitLSM(solver);
                            break;
                        }
                        this.fitIRLSM(solver);
                        break;
                    }
                    case GRADIENT_DESCENT_LH: 
                    case GRADIENT_DESCENT_SQERR: {
                        if (!((GLMModel.GLMParameters)GLM.this._parms)._family.equals((Object)GLMModel.GLMParameters.Family.ordinal)) break;
                        this.fitIRLSM_ordinal_default(solver);
                        break;
                    }
                    case L_BFGS: {
                        this.fitLBFGS();
                        break;
                    }
                    case COORDINATE_DESCENT_NAIVE: {
                        this.fitCOD();
                        break;
                    }
                    default: {
                        throw H2O.unimpl();
                    }
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values) {
                double se = 1.0;
                boolean seEst = false;
                double[] beta = GLM.this._state.beta();
                if (((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.binomial && ((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.poisson) {
                    seEst = true;
                    GLMTask.ComputeSETsk ct = (GLMTask.ComputeSETsk)new GLMTask.ComputeSETsk(null, GLM.this._state.activeData(), GLM.this._job._key, beta, (GLMModel.GLMParameters)GLM.this._parms).doAll(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                    se = ((GLMModel.GLMParameters)GLM.this._parms)._useDispersion1 ? 1.0 : ct._sumsqe / (double)(GLM.this._nobs - 1L - (long)GLM.this._state.activeData().fullN());
                }
                double[] zvalues = MemoryManager.malloc8d((int)(GLM.this._state.activeData().fullN() + 1));
                Gram.Cholesky chol = this._chol;
                if (((GLMModel.GLMParameters)GLM.this._parms)._standardize) {
                    DataInfo activeData = GLM.this._state.activeData();
                    double[] beta_nostd = activeData.denormalizeBeta(beta);
                    DataInfo.TransformType transform = activeData._predictor_transform;
                    activeData.setPredictorTransform(DataInfo.TransformType.NONE);
                    Gram g = ((GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask((Key)GLM.this._job._key, (DataInfo)activeData, (GLMModel.GLMWeightsFun)new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)((GLMModel.GLMParameters)GLM.this._parms)), (double[])beta_nostd).doAll((Frame)activeData._adaptedFrame))._gram;
                    activeData.setPredictorTransform(transform);
                    g.mul(((GLMModel.GLMParameters)GLM.this._parms)._obj_reg);
                    chol = g.cholesky(null);
                    beta = beta_nostd;
                }
                double[][] inv = chol.getInv();
                ArrayUtils.mult((double[][])inv, (double)(((GLMModel.GLMParameters)GLM.this._parms)._obj_reg * se));
                this._vcov = inv;
                for (int i = 0; i < zvalues.length; ++i) {
                    zvalues[i] = beta[i] / Math.sqrt(inv[i][i]);
                }
                GLM.this._model.setZValues(GLM.expandVec(zvalues, ((GLM)GLM.this)._state.activeData()._activeCols, GLM.this._dinfo.fullN() + 1, Double.NaN), se, seEst);
            }
        }

        private long timeSinceLastScoring() {
            return System.currentTimeMillis() - this._lastScore;
        }

        private void scoreAndUpdateModelHGLM(GLMModel fixedModel, GLMModel[] randModels, Frame glmmmeReturns, Frame hvDataOnly, double[] VC1, double[][] VC2, double sumDiff2, double convergence, double[][] cholR, Frame augXZ, boolean compute_hlik) {
            Log.info((Object[])new Object[]{GLM.this.LogMsg("Scoring after " + this.timeSinceLastScoring() + "ms")});
            long t1 = System.currentTimeMillis();
            Frame train = (Frame)DKV.getGet((Key)((GLMModel.GLMParameters)GLM.this._parms)._train);
            String[] domain = new String[]{"HGLM_" + ((GLMModel.GLMParameters)GLM.this._parms)._family.toString() + "_" + ((GLMModel.GLMParameters)GLM.this._parms)._rand_family.toString()};
            ModelMetrics.MetricBuilder mb = GLM.this._model.makeMetricBuilder(domain);
            ModelMetricsHGLM.MetricBuilderHGLM mmHGLMBd = (ModelMetricsHGLM.MetricBuilderHGLM)((GLMMetricBuilder)mb)._metricBuilder;
            this.updateSimpleHGLMMetrics(fixedModel, randModels, VC1, VC2, mmHGLMBd, sumDiff2, convergence);
            this.calBad(glmmmeReturns, hvDataOnly, mmHGLMBd);
            this.calseFeseRedfReFe(cholR, mmHGLMBd, augXZ);
            if (((GLMModel.GLMParameters)GLM.this._parms)._calc_like && compute_hlik) {
                this.calHlikStuff(mmHGLMBd, glmmmeReturns, augXZ);
                GLM.this._state.set_likelihoodInfo(mmHGLMBd._hlik, mmHGLMBd._pvh, mmHGLMBd._pbvh, mmHGLMBd._caic);
            }
            mb.makeModelMetrics((Model)GLM.this._model, train, GLM.this._dinfo._adaptedFrame, null);
            this.scoreEnd(train, t1);
        }

        private void calHlikStuff(ModelMetricsHGLM.MetricBuilderHGLM mmHGLMBd, Frame glmmmeReturns, Frame augXZ) {
            this.calculateNewWAugXZ(augXZ, GLM.this._randC);
            double cond_hlik = this.calculatecAIC(mmHGLMBd, glmmmeReturns);
            Frame hlikH = this.formHMatrix(augXZ);
            mmHGLMBd._hlik = cond_hlik;
            mmHGLMBd._pvh = cond_hlik - 0.5 * this.calcLogDeterminant(hlikH);
            Frame hlikA = this.formAMatrix(hlikH, augXZ);
            mmHGLMBd._pbvh = cond_hlik - 0.5 * this.calcLogDeterminant(hlikA);
            this.cleanupHGLMMemory(null, new Frame[]{hlikH, hlikA}, null, null);
        }

        private double calcLogDeterminant(Frame frame) {
            SVDModel.SVDParameters parms = new SVDModel.SVDParameters();
            parms._train = frame._key;
            parms._transform = DataInfo.TransformType.NONE;
            parms._svd_method = SVDModel.SVDParameters.Method.GramSVD;
            parms._save_v_frame = false;
            parms._nv = frame.numCols();
            SVDModel model = (SVDModel)new SVD(parms).trainModel().get();
            double[] singular_values = ((SVDModel.SVDOutput)model._output)._d;
            double cond = ArrayUtils.minValue((double[])singular_values) / ArrayUtils.maxValue((double[])singular_values);
            if (cond < 1.0E-8) {
                GLM.this.warn("pbvh", "The Hessian used for computing pbvh is ill-conditioned.");
            }
            double sumLog = 0.0;
            double log2Pi = Math.log(Math.PI * 2);
            for (int index = 0; index < parms._nv; ++index) {
                sumLog += Math.log(singular_values[index]) - log2Pi;
            }
            model.delete();
            return sumLog;
        }

        private Frame formAMatrix(Frame hlikH, Frame augXZ) {
            Frame dataFrame = this.getXW1(augXZ);
            DataInfo hlikAInfo = new DataInfo(dataFrame, null, true, DataInfo.TransformType.NONE, true, false, false);
            Gram.GramTask dgram = (Gram.GramTask)new Gram.GramTask((Key<Job>)GLM.this._job._key, hlikAInfo, false, false).doAll(hlikAInfo._adaptedFrame);
            new ArrayUtils();
            Frame leftUp = ArrayUtils.frame((double[][])dgram._gram.getXX());
            Frame augzW1 = this.getaugZW1(augXZ);
            Frame tX = DMatrix.transpose((Frame)dataFrame);
            int expandedRandColNum = ArrayUtils.sum((int[])GLM.this._randC);
            tX.add(new Frame(this.makeZeroOrOneFrame(tX.numRows(), expandedRandColNum, 0, null)));
            DKV.put((Key)augzW1._key, (Iced)augzW1);
            new LinearAlgebraUtils.BMulTaskMatrices(augzW1).doAll(tX);
            Frame tXW1z = tX.subframe(tX.numCols() - expandedRandColNum, tX.numCols());
            leftUp.add(tXW1z);
            Frame leftDown = DMatrix.transpose((Frame)tXW1z);
            leftDown._key = Key.make();
            leftDown.add(hlikH);
            leftDown.setNames(leftUp.names());
            DKV.put((Key)leftDown._key, (Iced)leftDown);
            DKV.put((Key)leftUp._key, (Iced)leftUp);
            String tree = String.format("(rbind %s %s)", leftUp._key, leftDown._key);
            Val val = Rapids.exec((String)tree);
            Frame amatrix = val.getFrame();
            amatrix._key = Key.make();
            DKV.put((Key)amatrix._key, (Iced)amatrix);
            this.cleanupHGLMMemory(new DataInfo[]{hlikAInfo}, new Frame[]{dataFrame, leftUp, augzW1, tX, tXW1z, leftDown}, null, null);
            return amatrix;
        }

        private Frame getXW1(Frame augXZ) {
            int numDataCols = augXZ.numCols() - ArrayUtils.sum((int[])GLM.this._randC);
            int[] colIndices = new int[numDataCols];
            for (int index = 0; index < numDataCols; ++index) {
                colIndices[index] = index;
            }
            Frame dataFrame = new Frame(this.makeZeroOrOneFrame(GLM.this._nobs, numDataCols, 0, null));
            new GLMTask.CopyPartsOfFrame(augXZ, colIndices, colIndices, GLM.this._nobs).doAll(dataFrame);
            return dataFrame;
        }

        private Frame formHMatrix(Frame augXZ) {
            Frame augZW1 = this.getaugZW1(augXZ);
            DataInfo augZW1Info = new DataInfo(augZW1, null, true, DataInfo.TransformType.NONE, true, false, false);
            Gram.GramTask dgram = (Gram.GramTask)new Gram.GramTask((Key<Job>)GLM.this._job._key, augZW1Info, false, false).doAll(augZW1Info._adaptedFrame);
            Frame wranddata = GLM.this._state.get_priorw_wpsi();
            double[][] W2 = null;
            W2 = ArrayUtils.transpose((double[][])((ArrayUtils.FrameToArray)new ArrayUtils.FrameToArray(1, 1, wranddata.numRows(), W2).doAll(wranddata)).getArray());
            ArrayUtils.mult((double[])W2[0], (double[])W2[0]);
            dgram._gram.addDiag(W2[0]);
            this.cleanupHGLMMemory(new DataInfo[]{augZW1Info}, new Frame[]{augZW1, wranddata}, null, null);
            new ArrayUtils();
            return ArrayUtils.frame((double[][])dgram._gram.getXX());
        }

        private Frame getaugZW1(Frame augXZ) {
            int numRandExpandedCols = ArrayUtils.sum((int[])GLM.this._randC);
            int randIndexStart = augXZ.numCols() - numRandExpandedCols;
            Frame augZW1 = new Frame(this.makeZeroOrOneFrame(GLM.this._nobs, numRandExpandedCols, 0, null));
            int[] colIndices = new int[numRandExpandedCols];
            int colNum = augXZ.numCols();
            for (int index = randIndexStart; index < colNum; ++index) {
                colIndices[index - randIndexStart] = index;
            }
            new GLMTask.CopyPartsOfFrame(augXZ, null, colIndices, GLM.this._nobs).doAll(augZW1);
            return augZW1;
        }

        private double calculatecAIC(ModelMetricsHGLM.MetricBuilderHGLM mmHGLMBd, Frame glmmmeReturns) {
            Frame hv_dev_pw = new Frame(this.makeZeroOrOneFrame(GLM.this._nobs, 2, 0, new String[]{"hv", "dev"}));
            new GLMTask.CopyPartsOfFrame(glmmmeReturns, new int[]{0, 1}, new int[]{1, 2}, GLM.this._nobs).doAll(hv_dev_pw);
            if (GLM.this._dinfo._weights) {
                hv_dev_pw.add("weights", GLM.this._dinfo._adaptedFrame.vec(GLM.this._dinfo.weightChunkId()));
            }
            GLMTask.HelpercAIC calcAIC = (GLMTask.HelpercAIC)new GLMTask.HelpercAIC(GLM.this._dinfo._weights, mmHGLMBd._varfix).doAll(hv_dev_pw);
            double constance = -0.5 * calcAIC._constT;
            double cond_hlik = constance - 0.5 * calcAIC._devOphi;
            mmHGLMBd._caic = -2.0 * cond_hlik + 2.0 * calcAIC._p;
            double[] lfvals = this.lfv_du_dv(((GLMModel.GLMParameters)GLM.this._parms)._rand_family, ((GLMModel.GLMParameters)GLM.this._parms)._rand_link, GLM.this._state.get_phi(), GLM.this._state.ubeta());
            hv_dev_pw.remove();
            return cond_hlik += lfvals[0] + lfvals[1];
        }

        public double[] lfv_du_dv(GLMModel.GLMParameters.Family[] family, GLMModel.GLMParameters.Link[] link, double[] phi, double[] u) {
            double[] vals = new double[2];
            int numRandCols = GLM.this._randC.length;
            for (int k = 0; k < numRandCols; ++k) {
                GLMModel.GLMParameters.Family tfamily = family[k];
                GLMModel.GLMParameters.Link tlink = tfamily.defaultLink;
                if (link != null) {
                    tlink = link[k];
                }
                GLMModel.GLMWeightsFun glmfun = new GLMModel.GLMWeightsFun(tfamily, tlink, 0.0, 0.0, 0.0);
                int colLength = GLM.this._randC[k];
                for (int col = 0; col < colLength; ++col) {
                    int index = k * colLength + col;
                    if (!tfamily.equals((Object)GLMModel.GLMParameters.Family.gaussian) || !tlink.equals((Object)GLMModel.GLMParameters.Link.identity)) continue;
                    vals[1] = vals[1] + Math.log(Math.abs(glmfun.linkInvDeriv(glmfun.link(u[index]))));
                    vals[0] = vals[0] - (Math.log(Math.sqrt(Math.PI * 2)) + Math.log(Math.sqrt(phi[index])) + u[index] * u[index] / (2.0 * phi[index]));
                }
            }
            return vals;
        }

        private void calseFeseRedfReFe(double[][] cholR, ModelMetricsHGLM.MetricBuilderHGLM mmHGLMBd, Frame augXZ) {
            double[][] RTRInv = LinearAlgebraUtils.chol2Inv(cholR);
            double[] seFeRe = LinearAlgebraUtils.sqrtDiag(RTRInv);
            int sefelen = GLM.this._state.beta().length;
            int serelen = GLM.this._state.ubeta().length;
            if (mmHGLMBd._sefe == null) {
                mmHGLMBd._sefe = new double[sefelen];
            }
            System.arraycopy(seFeRe, 0, mmHGLMBd._sefe, 0, sefelen);
            if (mmHGLMBd._sere == null) {
                mmHGLMBd._sere = new double[serelen];
            }
            System.arraycopy(seFeRe, sefelen, mmHGLMBd._sere, 0, serelen);
            Frame augZ = new Frame(this.makeZeroOrOneFrame(GLM.this._nobs, augXZ.numCols(), 0, null));
            new GLMTask.CopyPartsOfFrame(augXZ, null, null, GLM.this._nobs).doAll(augZ);
            DataInfo augzInfo = new DataInfo(augZ, null, true, DataInfo.TransformType.NONE, true, false, false);
            Gram.GramTask dgram = (Gram.GramTask)new Gram.GramTask((Key<Job>)GLM.this._job._key, augzInfo, false, false).doAll(augzInfo._adaptedFrame);
            double[][] gramMatrix = dgram._gram.getXX();
            double pd = ArrayUtils.sum((double[])ArrayUtils.diagArray((double[][])LinearAlgebraUtils.matrixMultiply(RTRInv, gramMatrix)));
            mmHGLMBd._dfrefe = Math.round((double)GLM.this._nobs - pd);
            this.cleanupHGLMMemory(new DataInfo[]{augzInfo}, new Frame[]{augZ}, null, null);
        }

        private void calBad(Frame glmmeReturns, Frame hvFrameOnly, ModelMetricsHGLM.MetricBuilderHGLM mmHGLMBd) {
            new GLMTask.CopyPartsOfFrame(glmmeReturns, new int[]{0}, new int[]{1}, GLM.this._nobs).doAll(hvFrameOnly);
            Vec vec = hvFrameOnly.vec(0);
            double sigma6 = vec.mean() + 6.0 * vec.sigma();
            double maxVec = vec.max();
            mmHGLMBd._bad = maxVec > sigma6 ? ((LinearAlgebraUtils.FindMaxIndex)new LinearAlgebraUtils.FindMaxIndex((int)0, (double)maxVec).doAll((Frame)hvFrameOnly))._maxIndex : -1L;
        }

        private void updateSimpleHGLMMetrics(GLMModel fixedModel, GLMModel[] randModels, double[] VC1, double[][] VC2, ModelMetricsHGLM.MetricBuilderHGLM mmHGLMBd, double sumDiff2, double convergence) {
            int index;
            mmHGLMBd.updateCoeffs(GLM.this._state.beta(), GLM.this._state.ubeta());
            mmHGLMBd.updateSummVC(VC1, VC2, GLM.this._randC);
            mmHGLMBd._varfix = Math.exp(fixedModel.coefficients().get("Intercept"));
            int randColNum = mmHGLMBd._randc.length;
            if (mmHGLMBd._varranef == null) {
                mmHGLMBd._varranef = new double[randColNum];
            }
            boolean converged = true;
            double sumSigma2u = 0.0;
            for (index = 0; index < randColNum; ++index) {
                mmHGLMBd._varranef[index] = Math.exp(randModels[index].coefficients().get("Intercept"));
                sumSigma2u += mmHGLMBd._varranef[index];
            }
            for (index = 0; index < randColNum; ++index) {
                if (!(mmHGLMBd._varranef[index] / (sumSigma2u + mmHGLMBd._varfix) > 0.9999)) continue;
                converged = false;
                break;
            }
            mmHGLMBd._converge = converged && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
            mmHGLMBd._sumetadiffsquare = sumDiff2;
            mmHGLMBd._convergence = convergence;
            mmHGLMBd._iterations = ((GLM)GLM.this)._state._iter;
            mmHGLMBd._nobs = GLM.this._nobs;
        }

        private void scoreAndUpdateModel() {
            Log.info((Object[])new Object[]{GLM.this.LogMsg("Scoring after " + this.timeSinceLastScoring() + "ms")});
            long t1 = System.currentTimeMillis();
            Frame train = (Frame)DKV.getGet((Key)((GLMModel.GLMParameters)GLM.this._parms)._train);
            GLM.this._model.score(train).delete();
            this.scoreEnd(train, t1);
        }

        private void scoreEnd(Frame train, long t1) {
            ModelMetrics mtrain = ModelMetrics.getFromDKV((Model)GLM.this._model, (Frame)train);
            long t2 = System.currentTimeMillis();
            if (mtrain != null) {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_metrics = mtrain;
                Log.info((Object[])new Object[]{GLM.this.LogMsg(mtrain.toString())});
            } else {
                Log.info((Object[])new Object[]{GLM.this.LogMsg("ModelMetrics mtrain is null")});
            }
            Log.info((Object[])new Object[]{GLM.this.LogMsg("Training metrics computed in " + (t2 - t1) + "ms")});
            if (GLM.this._valid != null) {
                Frame valid = (Frame)DKV.getGet((Key)((GLMModel.GLMParameters)GLM.this._parms)._valid);
                GLM.this._model.score(valid).delete();
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics = ModelMetrics.getFromDKV((Model)GLM.this._model, (Frame)valid);
            }
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history = ((GLMModel.GLMParameters)GLM.this._parms)._lambda_search ? GLM.this._lsc.to2dTable() : (((GLMModel.GLMParameters)GLM.this._parms)._HGLM ? GLM.this._sc.to2dTableHGLM() : GLM.this._sc.to2dTable());
            GLM.this._model.update(GLM.this._job._key);
            if (((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                GLM.this._model.generateSummaryHGLM(((GLMModel.GLMParameters)GLM.this._parms)._train, ((GLM)GLM.this)._state._iter);
            } else {
                GLM.this._model.generateSummary(((GLMModel.GLMParameters)GLM.this._parms)._train, ((GLM)GLM.this)._state._iter);
            }
            this._lastScore = System.currentTimeMillis();
            long scoringTime = System.currentTimeMillis() - t1;
            this._scoringInterval = Math.max(this._scoringInterval, 20L * scoringTime);
        }

        protected GLMModel.Submodel computeSubmodel(int i, double lambda) {
            GLMModel.Submodel sm;
            if (lambda >= GLM.this._lmax && GLM.this._state.l1pen() > 0.0) {
                sm = new GLMModel.Submodel(lambda, GLM.this.getNullBeta(), ((GLM)GLM.this)._state._iter, this._nullDevTrain, this._nullDevTest);
                GLM.this._model.addSubmodel(sm);
            } else {
                sm = new GLMModel.Submodel(lambda, GLM.this._state.beta(), ((GLM)GLM.this)._state._iter, -1.0, -1.0);
                if (((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                    sm.ubeta = Arrays.copyOf(GLM.this._state.ubeta(), GLM.this._state.ubeta().length);
                }
                GLM.this._model.addSubmodel(sm);
                if (!((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                    GLM.this._state.setLambda(lambda);
                }
                GLM.this.checkMemoryFootPrint(GLM.this._state.activeData());
                do {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                        for (int c = 0; c < GLM.this._nclass; ++c) {
                            Log.info((Object[])new Object[]{GLM.this.LogMsg("Class " + c + " got " + GLM.this._state.activeDataMultinomial(c).fullN() + " active columns out of " + ((GLM)GLM.this)._state._dinfo.fullN() + " total")});
                        }
                    } else {
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("Got " + GLM.this._state.activeData().fullN() + " active columns out of " + ((GLM)GLM.this)._state._dinfo.fullN() + " total")});
                    }
                    this.fitModel();
                } while (!GLM.this._state.checkKKTs());
                Log.info((Object[])new Object[]{GLM.this.LogMsg("solution has " + ArrayUtils.countNonzeros((double[])GLM.this._state.beta()) + " nonzeros")});
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                    double trainDev = GLM.this._state.deviance() / (double)GLM.this._nobs;
                    double testDev = Double.NaN;
                    if (GLM.this._validDinfo != null) {
                        testDev = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal ? ((GLMTask.GLMResDevTaskOrdinal)new GLMTask.GLMResDevTaskOrdinal(GLM.this._job._key, GLM.this._validDinfo, GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta()), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial(GLM.this._job._key, GLM.this._validDinfo, GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta()), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask(GLM.this._job._key, GLM.this._validDinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta())).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev());
                    }
                    Log.info((Object[])new Object[]{GLM.this.LogMsg("train deviance = " + trainDev + ", test deviance = " + testDev)});
                    double xvalDev = GLM.this._xval_test_deviances == null ? -1.0 : GLM.this._xval_test_deviances[i];
                    double xvalDevSE = GLM.this._xval_test_sd == null ? -1.0 : GLM.this._xval_test_sd[i];
                    GLM.this._lsc.addLambdaScore(((GLM)GLM.this)._state._iter, ArrayUtils.countNonzeros((double[])GLM.this._state.beta()), GLM.this._state.lambda(), trainDev, testDev, xvalDev, xvalDevSE);
                    sm = new GLMModel.Submodel(GLM.this._state.lambda(), GLM.this._state.beta(), ((GLM)GLM.this)._state._iter, trainDev, testDev);
                    GLM.this._model.updateSubmodel(sm);
                } else if (((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                    sm = new GLMModel.Submodel(lambda, GLM.this._state.beta(), ((GLM)GLM.this)._state._iter, -1.0, -1.0);
                    sm.ubeta = Arrays.copyOf(GLM.this._state.ubeta(), GLM.this._state.ubeta().length);
                    GLM.this._model.updateSubmodel(sm);
                } else {
                    sm = new GLMModel.Submodel(lambda, GLM.this._state.beta(), ((GLM)GLM.this)._state._iter, -1.0, -1.0);
                    GLM.this._model.updateSubmodel(sm);
                }
            }
            return sm;
        }

        public void computeImpl() {
            if (GLM.this._doInit) {
                GLM.this.init(true);
            }
            if (GLM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)GLM.this);
            }
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._start_time = System.currentTimeMillis();
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                    this._nullDevTrain = ((GLMTask.GLMResDevTaskOrdinal)new GLMTask.GLMResDevTaskOrdinal(GLM.this._job._key, ((GLM)GLM.this)._state._dinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._state._dinfo._adaptedFrame)).avgDev();
                } else {
                    double d = this._nullDevTrain = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial(GLM.this._job._key, ((GLM)GLM.this)._state._dinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._state._dinfo._adaptedFrame)).avgDev() : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask(GLM.this._job._key, ((GLM)GLM.this)._state._dinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this.getNullBeta()).doAll(((GLM)GLM.this)._state._dinfo._adaptedFrame)).avgDev();
                }
                if (GLM.this._validDinfo != null) {
                    this._nullDevTest = ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal ? ((GLMTask.GLMResDevTaskOrdinal)new GLMTask.GLMResDevTaskOrdinal(GLM.this._job._key, GLM.this._validDinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial(GLM.this._job._key, GLM.this._validDinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask(GLM.this._job._key, GLM.this._validDinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this.getNullBeta()).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev());
                }
                this._workPerIteration = 1000000L / (long)((GLMModel.GLMParameters)GLM.this._parms)._nlambdas;
            } else {
                this._workPerIteration = 1L + 1000000L / (long)((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
            }
            if ((((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal) && ((GLMModel.GLMParameters)GLM.this._parms)._solver != GLMModel.GLMParameters.Solver.L_BFGS) {
                double[] nb = GLM.this.getNullBeta();
                double maxRow = ArrayUtils.maxValue((double[])nb);
                double sumExp = 0.0;
                if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                    int P = GLM.this._dinfo.fullN();
                    int N = GLM.this._dinfo.fullN() + 1;
                    for (int i = 1; i < GLM.this._nclass; ++i) {
                        sumExp += Math.exp(nb[i * N + P] - maxRow);
                    }
                }
                Vec[] vecs = GLM.this._dinfo._adaptedFrame.anyVec().makeDoubles(2, new double[]{sumExp, maxRow});
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLMModel.GLMParameters)GLM.this._parms)._is_cv_model) {
                    Scope.untrack((Key[])new Key[]{vecs[0]._key, vecs[1]._key});
                    GLM.this.removeLater(new Key[]{vecs[0]._key, vecs[1]._key});
                }
                if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                    GLM.this._dinfo.addResponse(new String[]{"__glm_ExpC", "__glm_ExpNPC"}, vecs);
                } else {
                    GLM.this._dinfo.addResponse(new String[]{"__glm_sumExp", "__glm_maxRow"}, vecs);
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                this.addWdataZiEtaOld2Response();
            }
            double oldDevTrain = this._nullDevTrain;
            double oldDevTest = this._nullDevTest;
            double[] devHistoryTrain = new double[5];
            double[] devHistoryTest = new double[5];
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search & !((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                this.updateProgress(false);
            }
            for (int i = 0; !(i >= ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length || GLM.this._job.stop_requested() || GLM.this.timeout() && ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels.length > 0 || ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations != -1 && ((GLM)GLM.this)._state._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations); ++i) {
                GLMModel.Submodel sm = this.computeSubmodel(i, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i]);
                double trainDev = sm.devianceTrain;
                double testDev = sm.devianceTest;
                devHistoryTest[i % devHistoryTest.length] = (oldDevTest - testDev) / oldDevTest;
                oldDevTest = testDev;
                devHistoryTrain[i % devHistoryTrain.length] = (oldDevTrain - trainDev) / oldDevTrain;
                oldDevTrain = trainDev;
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda[i] < GLM.this._lmax && Double.isNaN(GLM.this._lambdaCVEstimate) && ((GLMModel.GLMParameters)GLM.this._parms)._early_stopping && ((GLM)GLM.this)._state._iter >= devHistoryTrain.length) {
                    double s = ArrayUtils.maxValue((double[])devHistoryTrain);
                    if (s < 1.0E-4) {
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("converged at lambda[" + i + "] = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i] + ", improvement on train = " + s)});
                        break;
                    }
                    if (GLM.this._validDinfo != null && ((GLMModel.GLMParameters)GLM.this._parms)._nfolds <= 1 && (s = ArrayUtils.maxValue((double[])devHistoryTest)) < 0.0) {
                        Log.info((Object[])new Object[]{GLM.this.LogMsg("converged at lambda[" + i + "] = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i] + ", improvement on test = " + s)});
                        break;
                    }
                }
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && (((GLMModel.GLMParameters)GLM.this._parms)._score_each_iteration || this.timeSinceLastScoring() > this._scoringInterval)) {
                    ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._best_lambda_idx = i;
                    ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).setSubmodelIdx(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._best_lambda_idx);
                    this.scoreAndUpdateModel();
                }
                GLM.this._job.update(this._workPerIteration, "iter=" + ((GLM)GLM.this)._state._iter + " lmb=" + lambdaFormatter.format(GLM.this._state.lambda()) + "deviance trn/tst= " + devFormatter.format(trainDev) + "/" + devFormatter.format(testDev) + " P=" + ArrayUtils.countNonzeros((double[])GLM.this._state.beta()));
            }
            if (GLM.this.stop_requested()) {
                if (GLM.this.timeout()) {
                    Log.info((Object[])new Object[]{"Stopping GLM training because of timeout"});
                } else {
                    throw new Job.JobCancelledException();
                }
            }
            if (((GLM)GLM.this)._state._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                GLM.this._job.warn("Reached maximum number of iterations " + ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations + "!");
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._nfolds > 1 && !Double.isNaN(GLM.this._lambdaCVEstimate)) {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).setSubmodel(GLM.this._lambdaCVEstimate);
            } else {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).pickBestModel();
            }
            if (this._vcov != null) {
                GLM.this._model.setVcov(this._vcov);
                GLM.this._model.update(GLM.this._job._key);
            }
            if (!((GLMModel.GLMParameters)GLM.this._parms)._HGLM) {
                this.scoreAndUpdateModel();
            }
            GLM.this._model.update(GLM.this._job._key);
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                GLM.this._job.update(this._workPerIteration * (long)(((GLMModel.GLMParameters)GLM.this._parms)._max_iterations - ((GLM)GLM.this)._state._iter));
            }
            if (GLM.this._iceptAdjust != 0.0) {
                assert (((GLMModel.GLMParameters)GLM.this._parms)._intercept);
                double[] b = ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._global_beta;
                int n = b.length - 1;
                b[n] = b[n] + GLM.this._iceptAdjust;
                for (GLMModel.Submodel sm : ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels) {
                    int n2 = sm.beta.length - 1;
                    sm.beta[n2] = sm.beta[n2] + GLM.this._iceptAdjust;
                }
                GLM.this._model.update(GLM.this._job._key);
            }
        }

        public void addWdataZiEtaOld2Response() {
            int index;
            int moreColnum = 3 + ((GLMModel.GLMParameters)GLM.this._parms)._random_columns.length;
            Vec[] vecs = GLM.this._dinfo._adaptedFrame.anyVec().makeZeros(moreColnum);
            String[] colNames = new String[moreColnum];
            colNames[0] = "wData";
            colNames[1] = "zi";
            colNames[2] = "etaOld";
            int[] randColIndices = ((GLMModel.GLMParameters)GLM.this._parms)._random_columns;
            for (index = 3; index < moreColnum; ++index) {
                colNames[index] = ((GLMModel.GLMParameters)GLM.this._parms).train().name(index - 3);
                vecs[index] = ((GLMModel.GLMParameters)GLM.this._parms).train().vec(randColIndices[index - 3]).makeCopy();
            }
            GLM.this._dinfo.addResponse(colNames, vecs);
            for (index = 0; index < moreColnum; ++index) {
                Scope.untrack((Key[])new Key[]{vecs[index]._key});
                GLM.this.removeLater(new Key[]{vecs[index]._key});
            }
        }

        public void onCompletion(CountedCompleter caller) {
            this.doCleanup();
            super.onCompletion(caller);
        }

        public boolean onExceptionalCompletion(Throwable t, CountedCompleter caller) {
            this.doCleanup();
            super.onExceptionalCompletion(t, caller);
            return true;
        }

        @Override
        public boolean progress(double[] beta, OptimizationUtils.GradientInfo ginfo) {
            boolean converged;
            ++((GLM)GLM.this)._state._iter;
            if (ginfo instanceof ProximalGradientInfo) {
                ginfo = ((ProximalGradientInfo)ginfo)._origGinfo;
                GLMGradientInfo gginfo = (GLMGradientInfo)ginfo;
                GLM.this._state.updateState(beta, gginfo);
                if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                    this.updateProgress(false);
                }
                return !GLM.this.stop_requested() && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
            }
            GLMGradientInfo gginfo = (GLMGradientInfo)ginfo;
            if (gginfo._gradient == null) {
                GLM.this._state.updateState(beta, gginfo._likelihood);
            } else {
                GLM.this._state.updateState(beta, gginfo);
            }
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                this.updateProgress(true);
            }
            if (converged = GLM.this._state.converged()) {
                Log.info((Object[])new Object[]{GLM.this.LogMsg(((GLM)GLM.this)._state.convergenceMsg)});
            }
            return !GLM.this.stop_requested() && !converged && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
        }

        public boolean progressHGLMGLMMME(double sumDiff2, double sumeta2, int iteration, boolean atGLMMME, GLMModel fixedModel, GLMModel[] randModels, Frame glmmmeReturns, Frame hvDataOnly, double[] VC1, double[][] VC2, double[][] cholR, Frame augZ) {
            boolean converged;
            boolean bl = converged = sumDiff2 < ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon * sumeta2;
            if (atGLMMME) {
                ++((GLM)GLM.this)._state._iterHGLM_GLMMME;
            } else {
                ++((GLM)GLM.this)._state._iter;
                this.updateProgress(fixedModel, randModels, glmmmeReturns, hvDataOnly, VC1, VC2, sumDiff2, sumDiff2 / sumeta2, true, cholR, augZ);
            }
            return !GLM.this.stop_requested() && !converged && iteration < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
        }

        public boolean progress(double[] beta, double likelihood) {
            boolean converged;
            ++((GLM)GLM.this)._state._iter;
            GLM.this._state.updateState(beta, likelihood);
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                this.updateProgress(true);
            }
            if (converged = GLM.this._state.converged()) {
                Log.info((Object[])new Object[]{GLM.this.LogMsg(((GLM)GLM.this)._state.convergenceMsg)});
            }
            return !GLM.this.stop_requested() && !converged && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
        }

        protected void updateProgress(GLMModel fixedModel, GLMModel[] randModels, Frame glmmmeReturns, Frame hvDataOnly, double[] VC1, double[][] VC2, double sumDiff2, double convergence, boolean canScore, double[][] cholR, Frame augXZ) {
            GLM.this._sc.addIterationScore(((GLM)GLM.this)._state._iter, ((GLM)GLM.this)._state._sumEtaSquareConvergence);
            if (canScore && (((GLMModel.GLMParameters)GLM.this._parms)._score_each_iteration || this.timeSinceLastScoring() > this._scoringInterval)) {
                GLM.this._model.update(GLM.this._state.expandBeta(GLM.this._state.beta()), GLM.this._state.ubeta(), -1.0, -1.0, ((GLM)GLM.this)._state._iter);
                this.scoreAndUpdateModelHGLM(fixedModel, randModels, glmmmeReturns, hvDataOnly, VC1, VC2, sumDiff2, convergence, cholR, augXZ, false);
            }
        }

        protected void updateProgress(boolean canScore) {
            assert (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search);
            GLM.this._sc.addIterationScore(((GLM)GLM.this)._state._iter, GLM.this._state.likelihood(), GLM.this._state.objective());
            GLM.this._job.update(this._workPerIteration, GLM.this._state.toString());
            if (canScore && (((GLMModel.GLMParameters)GLM.this._parms)._score_each_iteration || this.timeSinceLastScoring() > this._scoringInterval)) {
                GLM.this._model.update(GLM.this._state.expandBeta(GLM.this._state.beta()), -1.0, -1.0, ((GLM)GLM.this)._state._iter);
                this.scoreAndUpdateModel();
            }
        }
    }

    private static class LambdaSearchScoringHistory {
        ArrayList<Long> _scoringTimes = new ArrayList();
        private ArrayList<Double> _lambdas = new ArrayList();
        private ArrayList<Integer> _lambdaIters = new ArrayList();
        private ArrayList<Integer> _lambdaPredictors = new ArrayList();
        private ArrayList<Double> _lambdaDevTrain = new ArrayList();
        private ArrayList<Double> _lambdaDevTest;
        private ArrayList<Double> _lambdaDevXval;
        private ArrayList<Double> _lambdaDevXvalSE;

        public LambdaSearchScoringHistory(boolean hasTest, boolean hasXval) {
            if (!hasTest) {
                // empty if block
            }
            this._lambdaDevTest = new ArrayList();
            if (hasXval) {
                this._lambdaDevXval = new ArrayList();
                this._lambdaDevXvalSE = new ArrayList();
            }
        }

        public synchronized void addLambdaScore(int iter, int predictors, double lambda, double devRatioTrain, double devRatioTest, double devRatioXval, double devRatoioXvalSE) {
            this._scoringTimes.add(System.currentTimeMillis());
            this._lambdaIters.add(iter);
            this._lambdas.add(lambda);
            this._lambdaPredictors.add(predictors);
            this._lambdaDevTrain.add(devRatioTrain);
            if (this._lambdaDevTest != null) {
                this._lambdaDevTest.add(devRatioTest);
            }
            if (this._lambdaDevXval != null) {
                this._lambdaDevXval.add(devRatioXval);
            }
            if (this._lambdaDevXvalSE != null) {
                this._lambdaDevXvalSE.add(devRatoioXvalSE);
            }
        }

        public synchronized TwoDimTable to2dTable() {
            Object[] cnames = new String[]{"timestamp", "duration", "iteration", "lambda", "predictors", "deviance_train"};
            if (this._lambdaDevTest != null) {
                cnames = (String[])ArrayUtils.append((Object[])cnames, (Object[])new String[]{"deviance_test"});
            }
            if (this._lambdaDevXval != null) {
                cnames = ArrayUtils.append((String[])cnames, (String[])new String[]{"deviance_xval", "deviance_se"});
            }
            Object[] ctypes = new String[]{"string", "string", "int", "string", "int", "double"};
            if (this._lambdaDevTest != null) {
                ctypes = (String[])ArrayUtils.append((Object[])ctypes, (Object[])new String[]{"double"});
            }
            if (this._lambdaDevXval != null) {
                ctypes = ArrayUtils.append((String[])ctypes, (String[])new String[]{"double", "double"});
            }
            Object[] cformats = new String[]{"%s", "%s", "%d", "%s", "%d", "%.3f"};
            if (this._lambdaDevTest != null) {
                cformats = (String[])ArrayUtils.append((Object[])cformats, (Object[])new String[]{"%.3f"});
            }
            if (this._lambdaDevXval != null) {
                cformats = ArrayUtils.append((String[])cformats, (String[])new String[]{"%.3f", "%.3f"});
            }
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._lambdaIters.size()], (String[])cnames, (String[])ctypes, (String[])cformats, "");
            boolean j = false;
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < this._lambdaIters.size(); ++i) {
                int col = 0;
                res.set(i, col++, (Object)fmt.print(this._scoringTimes.get(i).longValue()));
                res.set(i, col++, (Object)PrettyPrint.msecs((long)(this._scoringTimes.get(i) - this._scoringTimes.get(0)), (boolean)true));
                res.set(i, col++, (Object)this._lambdaIters.get(i));
                res.set(i, col++, (Object)lambdaFormatter.format(this._lambdas.get(i)));
                res.set(i, col++, (Object)this._lambdaPredictors.get(i));
                res.set(i, col++, (Object)this._lambdaDevTrain.get(i));
                if (this._lambdaDevTest != null && this._lambdaDevTest.size() > i) {
                    res.set(i, col++, (Object)this._lambdaDevTest.get(i));
                }
                if (this._lambdaDevXval == null || this._lambdaDevXval.size() <= i) continue;
                res.set(i, col++, (Object)this._lambdaDevXval.get(i));
                res.set(i, col++, (Object)this._lambdaDevXvalSE.get(i));
            }
            return res;
        }
    }

    private static class ScoringHistory {
        private ArrayList<Integer> _scoringIters = new ArrayList();
        private ArrayList<Long> _scoringTimes = new ArrayList();
        private ArrayList<Double> _likelihoods = new ArrayList();
        private ArrayList<Double> _objectives = new ArrayList();
        private ArrayList<Double> _convergence = new ArrayList();
        private ArrayList<Double> _sumEtaiSquare = new ArrayList();

        private ScoringHistory() {
        }

        public synchronized void addIterationScore(int iter, double likelihood, double obj) {
            if (this._scoringIters.size() > 0 && this._scoringIters.get(this._scoringIters.size() - 1) == iter) {
                return;
            }
            this._scoringIters.add(iter);
            this._scoringTimes.add(System.currentTimeMillis());
            this._likelihoods.add(likelihood);
            this._objectives.add(obj);
        }

        public synchronized void addIterationScore(int iter, double[] sumEtaInfo) {
            if (this._scoringIters.size() > 0 && this._scoringIters.get(this._scoringIters.size() - 1) == iter) {
                return;
            }
            this._scoringIters.add(iter);
            this._scoringTimes.add(System.currentTimeMillis());
            this._sumEtaiSquare.add(sumEtaInfo[0]);
            this._convergence.add(sumEtaInfo[0] / sumEtaInfo[1]);
        }

        public synchronized TwoDimTable to2dTable() {
            String[] cnames = new String[]{"timestamp", "duration", "iterations", "negative_log_likelihood", "objective"};
            String[] ctypes = new String[]{"string", "string", "int", "double", "double"};
            String[] cformats = new String[]{"%s", "%s", "%d", "%.5f", "%.5f"};
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._scoringIters.size()], cnames, ctypes, cformats, "");
            boolean j = false;
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < this._scoringIters.size(); ++i) {
                int col = 0;
                res.set(i, col++, (Object)fmt.print(this._scoringTimes.get(i).longValue()));
                res.set(i, col++, (Object)PrettyPrint.msecs((long)(this._scoringTimes.get(i) - this._scoringTimes.get(0)), (boolean)true));
                res.set(i, col++, (Object)this._scoringIters.get(i));
                res.set(i, col++, (Object)this._likelihoods.get(i));
                res.set(i, col++, (Object)this._objectives.get(i));
            }
            return res;
        }

        public synchronized TwoDimTable to2dTableHGLM() {
            String[] cnames = new String[]{"timestamp", "duration", "iterations", "sum(etai-eta0)^2", "convergence"};
            String[] ctypes = new String[]{"string", "string", "int", "double", "double"};
            String[] cformats = new String[]{"%s", "%s", "%d", "%.5f", "%.5f"};
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._scoringIters.size()], cnames, ctypes, cformats, "");
            boolean j = false;
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < this._scoringIters.size(); ++i) {
                int col = 0;
                res.set(i, col++, (Object)fmt.print(this._scoringTimes.get(i).longValue()));
                res.set(i, col++, (Object)PrettyPrint.msecs((long)(this._scoringTimes.get(i) - this._scoringTimes.get(0)), (boolean)true));
                res.set(i, col++, (Object)this._scoringIters.get(i));
                res.set(i, col++, (Object)this._sumEtaiSquare.get(i));
                res.set(i, col++, (Object)this._convergence.get(i));
            }
            return res;
        }
    }

    static class TooManyPredictorsException
    extends RuntimeException {
        TooManyPredictorsException() {
        }
    }
}

