/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import java.util.ArrayList;
import water.MemoryManager;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class GLMUtils {
    public static int[][] extractAdaptedFrameIndices(Frame adaptFrame, String[][] gamColnames, int numOffset) {
        String[] frameNames = adaptFrame.names();
        ArrayList<String> allColNames = new ArrayList<String>();
        for (String name : frameNames) {
            allColNames.add(name);
        }
        int[][] gamColIndices = new int[gamColnames.length][];
        int numFrame = gamColnames.length;
        for (int frameNum = 0; frameNum < numFrame; ++frameNum) {
            int numCols = gamColnames[frameNum].length;
            gamColIndices[frameNum] = MemoryManager.malloc4((int)numCols);
            for (int index = 0; index < numCols; ++index) {
                gamColIndices[frameNum][index] = numOffset + allColNames.indexOf(gamColnames[frameNum][index]);
            }
        }
        return gamColIndices;
    }

    public static void updateGradGam(double[] gradient, double[][][] penalty_mat, int[][] gamBetaIndices, double[] beta, int[] activeCols) {
        int numGamCol = gamBetaIndices.length;
        for (int gamColInd = 0; gamColInd < numGamCol; ++gamColInd) {
            int penaltyMatSize = penalty_mat[gamColInd].length;
            for (int betaInd = 0; betaInd < penaltyMatSize; ++betaInd) {
                int currentBetaIndex = gamBetaIndices[gamColInd][betaInd];
                if (activeCols != null) {
                    currentBetaIndex = ArrayUtils.find((int[])activeCols, (int)currentBetaIndex);
                }
                double tempGrad = 2.0 * beta[currentBetaIndex] * penalty_mat[gamColInd][betaInd][betaInd];
                for (int rowInd = 0; rowInd < penaltyMatSize; ++rowInd) {
                    if (rowInd == betaInd) continue;
                    int currBetaInd = gamBetaIndices[gamColInd][rowInd];
                    if (activeCols != null) {
                        currBetaInd = ArrayUtils.find((int[])activeCols, (int)currBetaInd);
                    }
                    tempGrad += beta[currBetaInd] * penalty_mat[gamColInd][betaInd][rowInd];
                }
                int n = currentBetaIndex;
                gradient[n] = gradient[n] + tempGrad;
            }
        }
    }

    public static void updateGradGamMultinomial(double[][] gradient, double[][][] penaltyMat, int[][] gamBetaIndices, double[][] beta) {
        int numClass = beta[0].length;
        int numGamCol = gamBetaIndices.length;
        for (int classInd = 0; classInd < numClass; ++classInd) {
            for (int gamInd = 0; gamInd < numGamCol; ++gamInd) {
                int numKnots = gamBetaIndices[gamInd].length;
                for (int rowInd = 0; rowInd < numKnots; ++rowInd) {
                    double temp = 0.0;
                    int betaIndR = gamBetaIndices[gamInd][rowInd];
                    for (int colInd = 0; colInd < numKnots; ++colInd) {
                        int betaIndC = gamBetaIndices[gamInd][colInd];
                        temp += betaIndC == betaIndR ? 2.0 * penaltyMat[gamInd][rowInd][colInd] * beta[betaIndC][classInd] : penaltyMat[gamInd][rowInd][colInd] * beta[betaIndC][classInd];
                    }
                    double[] dArray = gradient[betaIndR];
                    int n = classInd;
                    dArray[n] = dArray[n] + temp;
                }
            }
        }
    }

    public static double calSmoothNess(double[] beta, double[][][] penaltyMatrix, int[][] gamColIndices) {
        int numGamCols = gamColIndices.length;
        double smoothval = 0.0;
        for (int gamCol = 0; gamCol < numGamCols; ++gamCol) {
            smoothval += ArrayUtils.innerProductPartial((double[])beta, (int[])gamColIndices[gamCol], (double[])ArrayUtils.multArrVecPartial((double[][])penaltyMatrix[gamCol], (double[])beta, (int[])gamColIndices[gamCol]));
        }
        return smoothval;
    }

    public static double calSmoothNess(double[][] beta, double[][][] penaltyMatrix, int[][] gamColIndices) {
        int numClass = beta.length;
        double smoothval = 0.0;
        for (int classInd = 0; classInd < numClass; ++classInd) {
            smoothval += GLMUtils.calSmoothNess(beta[classInd], penaltyMatrix, gamColIndices);
        }
        return smoothval;
    }
}

