/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.glm.GLMModel;
import hex.schemas.GLMV3;
import java.util.Arrays;
import java.util.Comparator;
import water.MemoryManager;
import water.api.API;
import water.api.schemas3.ModelOutputSchemaV3;
import water.api.schemas3.ModelSchemaV3;
import water.api.schemas3.TwoDimTableV3;
import water.util.ArrayUtils;
import water.util.TwoDimTable;

public class GLMModelV3
extends ModelSchemaV3<GLMModel, GLMModelV3, GLMModel.GLMParameters, GLMV3.GLMParametersV3, GLMModel.GLMOutput, GLMModelOutputV3> {
    public GLMV3.GLMParametersV3 createParametersSchema() {
        return new GLMV3.GLMParametersV3();
    }

    public GLMModelOutputV3 createOutputSchema() {
        return new GLMModelOutputV3();
    }

    public GLMModel createImpl() {
        GLMModel.GLMParameters parms = (GLMModel.GLMParameters)((GLMV3.GLMParametersV3)this.parameters).createImpl();
        return new GLMModel(this.model_id.key(), parms, null, new double[]{0.0}, 0.0, 0.0, 0L);
    }

    public static final class GLMModelOutputV3
    extends ModelOutputSchemaV3<GLMModel.GLMOutput, GLMModelOutputV3> {
        @API(help="Table of Coefficients")
        TwoDimTableV3 coefficients_table;
        @API(help="Table of Random Coefficients for HGLM")
        TwoDimTableV3 random_coefficients_table;
        @API(help="Table of Coefficients with coefficients denoted with class names for GLM multinonimals only.")
        TwoDimTableV3 coefficients_table_multinomials_with_class_names;
        @API(help="Standardized Coefficient Magnitudes")
        TwoDimTableV3 standardized_coefficient_magnitudes;
        @API(help="Lambda minimizing the objective value, only applicable with lambd search")
        double lambda_best;
        @API(help="Lambda best + 1 standard error. Only applicable with lambda search and cross-validation")
        double lambda_1se;
        @API(help="Dispersion parameter, only applicable to Tweedie family (input/output) and fractional Binomial (output only)")
        double dispersion;

        private GLMModelOutputV3 fillMultinomial(GLMModel.GLMOutput impl) {
            if (impl.get_global_beta_multinomial() == null) {
                return this;
            }
            String[] names = (String[])impl.coefficientNames().clone();
            String[] ns = ArrayUtils.append((String[])new String[]{"Intercept"}, (String[])Arrays.copyOf(names, names.length - 1));
            this.coefficients_table = new TwoDimTableV3();
            if (impl.nclasses() > 2) {
                this.coefficients_table_multinomials_with_class_names = new TwoDimTableV3();
            }
            int n = impl.nclasses();
            String[] cols = new String[n * 2];
            String[] cols2 = null;
            if (n > 2) {
                cols2 = new String[n * 2];
                String[] classNames = impl._domains[impl.responseIdx()];
                for (int i = 0; i < n; ++i) {
                    cols2[i] = "coefs_class_" + classNames[i];
                    cols2[n + i] = "std_coefs_class_" + classNames[i];
                }
            }
            for (int i = 0; i < n; ++i) {
                cols[i] = "coefs_class_" + i;
                cols[n + i] = "std_coefs_class_" + i;
            }
            Object[] colTypes = new String[cols.length];
            Arrays.fill(colTypes, "double");
            Object[] colFormats = new String[cols.length];
            Arrays.fill(colFormats, "%5f");
            double[][] betaNorm = impl.getNormBetaMultinomial();
            if (betaNorm != null) {
                int i;
                int i2;
                TwoDimTable tdt = new TwoDimTable("Coefficients", "glm multinomial coefficients", ns, cols, (String[])colTypes, (String[])colFormats, "names");
                for (int c = 0; c < n; ++c) {
                    double[] beta = impl.get_global_beta_multinomial()[c];
                    tdt.set(0, c, (Object)beta[beta.length - 1]);
                    tdt.set(0, n + c, (Object)betaNorm[c][beta.length - 1]);
                    for (i2 = 0; i2 < beta.length - 1; ++i2) {
                        tdt.set(i2 + 1, c, (Object)beta[i2]);
                        tdt.set(i2 + 1, n + c, (Object)betaNorm[c][i2]);
                    }
                }
                this.coefficients_table.fillFromImpl(tdt);
                if (n > 2) {
                    this.coefficients_table_multinomials_with_class_names.fillFromImpl(tdt);
                    this.revertCoeffNames(cols2, n, this.coefficients_table_multinomials_with_class_names);
                }
                final double[] magnitudes = new double[betaNorm[0].length];
                for (int i3 = 0; i3 < betaNorm.length; ++i3) {
                    for (int j = 0; j < betaNorm[i3].length; ++j) {
                        double d = betaNorm[i3][j];
                        int n2 = j;
                        magnitudes[n2] = magnitudes[n2] + (d < 0.0 ? -d : d);
                    }
                }
                Integer[] indices = new Integer[magnitudes.length - 1];
                for (i2 = 0; i2 < indices.length; ++i2) {
                    indices[i2] = i2;
                }
                Arrays.sort(indices, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        if (magnitudes[o1] < magnitudes[o2]) {
                            return 1;
                        }
                        if (magnitudes[o1] > magnitudes[o2]) {
                            return -1;
                        }
                        return 0;
                    }
                });
                int len = names.length - 1;
                String[] names2 = new String[len];
                for (i = 0; i < len; ++i) {
                    names2[i] = names[indices[i]];
                }
                tdt = new TwoDimTable("Standardized Coefficient Magnitudes", "standardized coefficient magnitudes", names2, new String[]{"Coefficients", "Sign"}, new String[]{"double", "string"}, new String[]{"%5f", "%s"}, "names");
                for (i = 0; i < magnitudes.length - 1; ++i) {
                    tdt.set(i, 0, (Object)magnitudes[indices[i]]);
                    tdt.set(i, 1, (Object)"POS");
                }
                this.standardized_coefficient_magnitudes = new TwoDimTableV3();
                this.standardized_coefficient_magnitudes.fillFromImpl(tdt);
            }
            return this;
        }

        public void revertCoeffNames(String[] colNames, int nclass, TwoDimTableV3 coeffs_table) {
            String newName;
            coeffs_table.name = newName = coeffs_table.name + " with class names";
            boolean bothCoeffStd = colNames.length == 2 * nclass;
            for (int tableIndex = 1; tableIndex <= nclass; ++tableIndex) {
                coeffs_table.columns[tableIndex].name = new String(colNames[tableIndex - 1]);
                if (!bothCoeffStd) continue;
                coeffs_table.columns[tableIndex + nclass].name = new String(colNames[tableIndex - 1 + nclass]);
            }
        }

        public TwoDimTable buildRandomCoefficients2DTable(double[] ubeta, String[] randomColNames) {
            String[] colTypes = new String[]{"double"};
            String[] colFormats = new String[]{"%5f"};
            String[] colnames = new String[]{"Random Coefficients"};
            TwoDimTable tdt = new TwoDimTable("HGLM Random Coefficients", "HGLM random coefficients", randomColNames, colnames, colTypes, colFormats, "names");
            for (int i = 0; i < ubeta.length; ++i) {
                tdt.set(i, 0, (Object)ubeta[i]);
            }
            return tdt;
        }

        public GLMModelOutputV3 fillFromImpl(GLMModel.GLMOutput impl) {
            int i;
            int i2;
            double[] beta;
            super.fillFromImpl((Model.Output)impl);
            this.lambda_1se = impl.lambda_1se();
            this.lambda_best = impl.lambda_best();
            this.dispersion = impl.dispersion();
            if (impl._multinomial || impl._ordinal) {
                return this.fillMultinomial(impl);
            }
            String[] names = (String[])impl.coefficientNames().clone();
            String[] ns = ArrayUtils.append((String[])new String[]{"Intercept"}, (String[])Arrays.copyOf(names, names.length - 1));
            this.coefficients_table = new TwoDimTableV3();
            if (impl.ubeta() != null && impl.randomcoefficientNames() != null) {
                this.random_coefficients_table = new TwoDimTableV3();
                this.random_coefficients_table.fillFromImpl(this.buildRandomCoefficients2DTable(impl.ubeta(), impl.randomcoefficientNames()));
            }
            if ((beta = impl.beta()) == null) {
                beta = MemoryManager.malloc8d((int)names.length);
            }
            Object[] colTypes = new String[]{"double"};
            Object[] colFormats = new String[]{"%5f"};
            Object[] colnames = new String[]{"Coefficients"};
            if (impl.hasPValues()) {
                colTypes = new String[]{"double", "double", "double", "double"};
                colFormats = new String[]{"%5f", "%5f", "%5f", "%5f"};
                colnames = new String[]{"Coefficients", "Std. Error", "z value", "p value"};
            }
            int stdOff = colnames.length;
            colTypes = (String[])ArrayUtils.append((Object[])colTypes, (Object[])new String[]{"double"});
            colFormats = (String[])ArrayUtils.append((Object[])colFormats, (Object[])new String[]{"%5f"});
            colnames = (String[])ArrayUtils.append((Object[])colnames, (Object[])new String[]{"Standardized Coefficients"});
            TwoDimTable tdt = new TwoDimTable("Coefficients", "glm coefficients", ns, (String[])colnames, (String[])colTypes, (String[])colFormats, "names");
            tdt.set(0, 0, (Object)beta[beta.length - 1]);
            for (int i3 = 0; i3 < beta.length - 1; ++i3) {
                tdt.set(i3 + 1, 0, (Object)beta[i3]);
            }
            double[] norm_beta = null;
            if (impl.beta() != null) {
                norm_beta = impl.getNormBeta();
                tdt.set(0, stdOff, (Object)norm_beta[norm_beta.length - 1]);
                for (i2 = 0; i2 < norm_beta.length - 1; ++i2) {
                    tdt.set(i2 + 1, stdOff, (Object)norm_beta[i2]);
                }
            }
            if (impl.hasPValues()) {
                double[] stdErr = impl.stdErr();
                double[] zVals = impl.zValues();
                double[] pVals = impl.pValues();
                tdt.set(0, 1, (Object)stdErr[stdErr.length - 1]);
                tdt.set(0, 2, (Object)zVals[zVals.length - 1]);
                tdt.set(0, 3, (Object)pVals[pVals.length - 1]);
                for (i = 0; i < stdErr.length - 1; ++i) {
                    tdt.set(i + 1, 1, (Object)stdErr[i]);
                    tdt.set(i + 1, 2, (Object)zVals[i]);
                    tdt.set(i + 1, 3, (Object)pVals[i]);
                }
            }
            this.coefficients_table.fillFromImpl(tdt);
            if (impl.beta() != null) {
                final double[] magnitudes = (double[])norm_beta.clone();
                for (i2 = 0; i2 < magnitudes.length; ++i2) {
                    if (!(magnitudes[i2] < 0.0)) continue;
                    int n = i2;
                    magnitudes[n] = magnitudes[n] * -1.0;
                }
                Integer[] indices = new Integer[magnitudes.length - 1];
                for (int i4 = 0; i4 < indices.length; ++i4) {
                    indices[i4] = i4;
                }
                Arrays.sort(indices, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        if (magnitudes[o1] < magnitudes[o2]) {
                            return 1;
                        }
                        if (magnitudes[o1] > magnitudes[o2]) {
                            return -1;
                        }
                        return 0;
                    }
                });
                int len = names.length - 1;
                String[] names2 = new String[len];
                for (i = 0; i < len; ++i) {
                    names2[i] = names[indices[i]];
                }
                tdt = new TwoDimTable("Standardized Coefficient Magnitudes", "standardized coefficient magnitudes", names2, new String[]{"Coefficients", "Sign"}, new String[]{"double", "string"}, new String[]{"%5f", "%s"}, "names");
                for (i = 0; i < beta.length - 1; ++i) {
                    tdt.set(i, 0, (Object)magnitudes[indices[i]]);
                    tdt.set(i, 1, (Object)(beta[indices[i]] < 0.0 ? "NEG" : "POS"));
                }
                this.standardized_coefficient_magnitudes = new TwoDimTableV3();
                this.standardized_coefficient_magnitudes.fillFromImpl(tdt);
            }
            return this;
        }
    }
}

