/*
 * Decompiled with CFR 0.152.
 */
package hex.util;

import hex.Model;
import hex.ModelBuilder;
import java.lang.reflect.Field;
import java.util.Arrays;
import water.Value;
import water.exceptions.H2OIllegalArgumentException;
import water.util.ArrayUtils;
import water.util.PojoUtils;

public class CheckpointUtils {
    private static void validateWithCheckpoint(Model.Parameters params, String[] nonModifiableFields, Model.Parameters checkpointParameters) {
        for (Field fAfter : params.getClass().getFields()) {
            if (!ArrayUtils.contains((Object[])nonModifiableFields, (Object)fAfter.getName())) continue;
            for (Field fBefore : checkpointParameters.getClass().getFields()) {
                if (!fBefore.equals(fAfter)) continue;
                try {
                    if (PojoUtils.equals((Object)params, (Field)fAfter, (Object)checkpointParameters, (Field)checkpointParameters.getClass().getField(fAfter.getName()))) continue;
                    throw new H2OIllegalArgumentException(fAfter.getName(), "TreeBuilder", (Object)("Field " + fAfter.getName() + " cannot be modified if checkpoint is specified!"));
                }
                catch (NoSuchFieldException e) {
                    throw new H2OIllegalArgumentException(fAfter.getName(), "TreeBuilder", (Object)("Field " + fAfter.getName() + " is not supported by checkpoint!"));
                }
            }
        }
    }

    private static void validateNTrees(ModelBuilder builder, Model.GetNTrees params, Model.GetNTrees output) {
        if (params.getNTrees() < output.getNTrees() + 1) {
            builder.error("_ntrees", "If checkpoint is specified then requested ntrees must be higher than " + (output.getNTrees() + 1));
        }
    }

    public static <M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output> M getAndValidateCheckpointModel(ModelBuilder<M, P, O> builder, String[] nonModifiableFields, Value cv) {
        Model checkpointModel = (Model)cv.get();
        try {
            CheckpointUtils.validateWithCheckpoint(builder._parms, nonModifiableFields, checkpointModel._parms);
            if (builder.isClassifier() != checkpointModel._output.isClassifier()) {
                throw new IllegalArgumentException("Response type must be the same as for the checkpointed model.");
            }
            if (!Arrays.equals(builder.train().names(), checkpointModel._output._names)) {
                throw new IllegalArgumentException("The columns of the training data must be the same as for the checkpointed model");
            }
            if (!Arrays.deepEquals((Object[])builder.train().domains(), (Object[])checkpointModel._output._domains)) {
                throw new IllegalArgumentException("Categorical factor levels of the training data must be the same as for the checkpointed model");
            }
        }
        catch (H2OIllegalArgumentException e) {
            builder.error(e.values.get((Object)"argument").toString(), e.values.get((Object)"value").toString());
        }
        if (builder._parms instanceof Model.GetNTrees && checkpointModel._output instanceof Model.GetNTrees) {
            CheckpointUtils.validateNTrees(builder, (Model.GetNTrees)builder._parms, (Model.GetNTrees)checkpointModel._output);
        }
        return (M)checkpointModel;
    }
}

