/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import Jama.Matrix;
import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.StringPair;
import hex.coxph.CPHBaseTask;
import hex.coxph.CoxPHModel;
import hex.coxph.EfronMethod;
import java.util.Arrays;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.Scope;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.ast.prims.mungers.AstGroup;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.IcedHashSet;
import water.util.IcedInt;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.Timer;
import water.util.TwoDimTable;
import water.util.VecUtils;

public class CoxPH
extends ModelBuilder<CoxPHModel, CoxPHModel.CoxPHParameters, CoxPHModel.CoxPHOutput> {
    private static final int MAX_TIME_BINS = 100000;

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.CoxPH};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    public boolean isSupervised() {
        return true;
    }

    public CoxPH(boolean startup_once) {
        super((Model.Parameters)new CoxPHModel.CoxPHParameters(), startup_once);
    }

    public CoxPH(CoxPHModel.CoxPHParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    protected CoxPHDriver trainModelImpl() {
        return new CoxPHDriver();
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((CoxPHModel.CoxPHParameters)this._parms)._train != null && ((CoxPHModel.CoxPHParameters)this._parms).train() == null) {
            this.error("train", "Invalid training frame (Frame key = " + ((CoxPHModel.CoxPHParameters)this._parms)._train + " not found)");
        }
        if (((CoxPHModel.CoxPHParameters)this._parms)._train != null && ((CoxPHModel.CoxPHParameters)this._parms).train() != null) {
            String col2;
            int n;
            String[] stopVec;
            if (((CoxPHModel.CoxPHParameters)this._parms)._start_column != null) {
                Vec startVec = ((CoxPHModel.CoxPHParameters)this._parms).startVec();
                if (startVec == null) {
                    this.error("start_column", "start_column " + ((CoxPHModel.CoxPHParameters)this._parms)._start_column + " not found in the training frame");
                } else if (!startVec.isNumeric()) {
                    this.error("start_column", "start time must be undefined or of type numeric");
                }
            }
            if (((CoxPHModel.CoxPHParameters)this._parms)._stop_column != null) {
                stopVec = ((CoxPHModel.CoxPHParameters)this._parms).stopVec();
                if (stopVec == null) {
                    this.error("stop_column", "stop_column " + ((CoxPHModel.CoxPHParameters)this._parms)._stop_column + " not found in the training frame");
                } else if (!stopVec.isNumeric()) {
                    this.error("stop_column", "stop time must be of type numeric");
                } else if (expensive) {
                    try {
                        CollectTimes.collect(((CoxPHModel.CoxPHParameters)this._parms).stopVec(), ((CoxPHModel.CoxPHParameters)this._parms)._single_node_mode);
                    }
                    catch (CollectTimesException e) {
                        this.error("stop_column", e.getMessage());
                    }
                }
            }
            if (((CoxPHModel.CoxPHParameters)this._parms)._response_column != null && !this._response.isInt() && !this._response.isCategorical()) {
                this.error("response_column", "response/event column must be of type integer or factor");
            }
            if (((CoxPHModel.CoxPHParameters)this._parms).startVec() != null && ((CoxPHModel.CoxPHParameters)this._parms).stopVec() != null && ((CoxPHModel.CoxPHParameters)this._parms).startVec().min() >= ((CoxPHModel.CoxPHParameters)this._parms).stopVec().max()) {
                this.error("start_column", "start times must be strictly less than stop times");
            }
            if (((CoxPHModel.CoxPHParameters)this._parms)._interactions != null) {
                stopVec = ((CoxPHModel.CoxPHParameters)this._parms)._interactions;
                int e = stopVec.length;
                for (n = 0; n < e; ++n) {
                    col2 = stopVec[n];
                    if (col2 == null || col2.isEmpty() || this._train.vec(col2) != null) continue;
                    this.error("interactions", col2 + " not found in the training frame");
                }
            }
            if (((CoxPHModel.CoxPHParameters)this._parms)._interactions_only != null) {
                stopVec = ((CoxPHModel.CoxPHParameters)this._parms)._interactions_only;
                int e = stopVec.length;
                for (n = 0; n < e; ++n) {
                    col2 = stopVec[n];
                    if (col2 == null || col2.isEmpty() || this._train.vec(col2) != null) continue;
                    this.error("interactions_only", col2 + " not found in the training frame");
                }
            }
            if (((CoxPHModel.CoxPHParameters)this._parms)._interaction_pairs != null) {
                stopVec = ((CoxPHModel.CoxPHParameters)this._parms)._interaction_pairs;
                int e = stopVec.length;
                for (n = 0; n < e; ++n) {
                    String pair = stopVec[n];
                    if (((StringPair)pair)._a != null && !((StringPair)pair)._a.isEmpty() && this._train.vec(((StringPair)pair)._a) == null) {
                        this.error("interaction_pairs", ((StringPair)pair)._a + " not found in the training frame");
                    }
                    if (((StringPair)pair)._b == null || ((StringPair)pair)._b.isEmpty() || this._train.vec(((StringPair)pair)._b) != null) continue;
                    this.error("interaction_pairs", ((StringPair)pair)._b + " not found in the training frame");
                }
            }
            if (this._train != null) {
                int nonFeatureColCount = (((CoxPHModel.CoxPHParameters)this._parms)._start_column != null ? 1 : 0) + (((CoxPHModel.CoxPHParameters)this._parms)._stop_column != null ? 1 : 0);
                if (this._train.numCols() < 2 + nonFeatureColCount) {
                    this.error("_train", "Training data must have at least 2 features (incl. response).");
                }
                if (null != ((CoxPHModel.CoxPHParameters)this._parms)._stratify_by) {
                    int stratifyColCount = ((CoxPHModel.CoxPHParameters)this._parms)._stratify_by.length;
                    if (this._train.numCols() < 2 + nonFeatureColCount + stratifyColCount) {
                        this.error("_train", "Training data must have at least 1 feature that is not a response and is not used for stratification.");
                    }
                }
            }
            if (((CoxPHModel.CoxPHParameters)this._parms).isStratified()) {
                block5: for (String col2 : ((CoxPHModel.CoxPHParameters)this._parms)._stratify_by) {
                    Vec v = ((CoxPHModel.CoxPHParameters)this._parms).train().vec(col2);
                    if (v == null) {
                        this.error("stratify_by", "column '" + col2 + "' not found");
                    } else if (v.get_type() != 4) {
                        this.error("stratify_by", "non-categorical column '" + col2 + "' cannot be used for stratification");
                    }
                    if (((CoxPHModel.CoxPHParameters)this._parms)._interactions == null) continue;
                    for (String inter : ((CoxPHModel.CoxPHParameters)this._parms)._interactions) {
                        if (!col2.equals(inter)) continue;
                        this.error("stratify_by", "stratification column '" + col2 + "' cannot be used in an implicit interaction. Use explicit (pair-wise) interactions instead");
                        continue block5;
                    }
                }
            }
        }
        if (Double.isNaN(((CoxPHModel.CoxPHParameters)this._parms)._lre_min) || ((CoxPHModel.CoxPHParameters)this._parms)._lre_min <= 0.0) {
            this.error("lre_min", "lre_min must be a positive number");
        }
        if (((CoxPHModel.CoxPHParameters)this._parms)._max_iterations < 1) {
            this.error("max_iterations", "max_iterations must be a positive integer");
        }
    }

    private static class ScoringHistory {
        private long[] _scoringTimes;
        private double[] _logLiks;

        public ScoringHistory(int iterCnt) {
            this._scoringTimes = new long[iterCnt];
            this._logLiks = new double[iterCnt];
        }

        public ScoringHistory addIterationScore(int iter, double logLik) {
            this._scoringTimes[iter] = System.currentTimeMillis();
            this._logLiks[iter] = logLik;
            return this;
        }

        public TwoDimTable to2dTable(int iterCnt) {
            String[] cnames = new String[]{"timestamp", "duration", "iterations", "logLik"};
            String[] ctypes = new String[]{"string", "string", "int", "double"};
            String[] cformats = new String[]{"%s", "%s", "%d", "%.5f"};
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[iterCnt], cnames, ctypes, cformats, "");
            DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < iterCnt; ++i) {
                int col = 0;
                res.set(i, col++, (Object)fmt.print(this._scoringTimes[i]));
                res.set(i, col++, (Object)PrettyPrint.msecs((long)(this._scoringTimes[i] - this._scoringTimes[0]), (boolean)true));
                res.set(i, col++, (Object)i);
                res.set(i, col++, (Object)this._logLiks[i]);
            }
            return res;
        }
    }

    static class ComputationState {
        final int _n_coef;
        double _logLik;
        double[] _gradient;
        double[][] _hessian;

        ComputationState(int n_coef) {
            this._n_coef = n_coef;
            this._logLik = 0.0;
            this._gradient = MemoryManager.malloc8d((int)n_coef);
            this._hessian = MemoryManager.malloc8d((int)n_coef, (int)n_coef);
        }

        void reset() {
            int j;
            this._logLik = 0.0;
            for (j = 0; j < this._n_coef; ++j) {
                this._gradient[j] = 0.0;
            }
            for (j = 0; j < this._n_coef; ++j) {
                for (int k = 0; k < this._n_coef; ++k) {
                    this._hessian[j][k] = 0.0;
                }
            }
        }
    }

    private static class CollectTimesException
    extends RuntimeException {
        private CollectTimesException(String message) {
            super(message);
        }
    }

    private static class CollectTimes
    extends VecUtils.CollectDoubleDomain {
        private CollectTimes() {
            super(new double[0], 100000);
        }

        static double[] collect(Vec timeVec, boolean runLocal) {
            return ((VecUtils.CollectDoubleDomain)new CollectTimes().doAll(timeVec, runLocal)).domain();
        }

        protected void onMaxDomainExceeded(int maxDomainSize, int currentSize) {
            throw new CollectTimesException("number of distinct stop times is at least " + currentSize + "; maximum number allowed is " + maxDomainSize);
        }
    }

    protected static class CoxPHTask
    extends CPHBaseTask<CoxPHTask> {
        final double[] _beta;
        final double[] _time;
        final int _n_offsets;
        final boolean _has_start_column;
        final boolean _has_strata_column;
        final boolean _has_weights_column;
        final long _min_event;
        final int _num_strata;
        final boolean _isBreslow;
        long n;
        double[] sumWeights;
        double[][] sumWeightedCatX;
        double[][] sumWeightedNumX;
        double[] sizeRiskSet;
        double[] sizeCensored;
        double[] sizeEvents;
        long[] countEvents;
        double[] sumXEvents;
        double[] sumRiskEvents;
        double[][] sumXRiskEvents;
        double[] sumLogRiskEvents;
        double[] rcumsumRisk;
        double[][] rcumsumXRisk;
        double[][][] rcumsumXXRisk;

        CoxPHTask(DataInfo dinfo, double[] beta, double[] time, long min_event, int n_offsets, boolean has_start_column, Vec strata_column, boolean has_weights_column, CoxPHModel.CoxPHParameters.CoxPHTies ties) {
            super(dinfo);
            this._beta = beta;
            this._time = time;
            this._min_event = min_event;
            this._n_offsets = n_offsets;
            this._has_start_column = has_start_column;
            this._has_strata_column = strata_column != null;
            this._has_weights_column = has_weights_column;
            this._num_strata = this._has_strata_column ? 1 + (int)strata_column.max() : 1;
            this._isBreslow = CoxPHModel.CoxPHParameters.CoxPHTies.breslow.equals((Object)ties);
        }

        @Override
        protected void chunkInit() {
            int n_time = this._time.length * this._num_strata;
            int n_coef = this._beta.length;
            this.sumWeights = MemoryManager.malloc8d((int)this._num_strata);
            this.sumWeightedCatX = MemoryManager.malloc8d((int)this._num_strata, (int)this._dinfo.numCats());
            this.sumWeightedNumX = MemoryManager.malloc8d((int)this._num_strata, (int)this._dinfo.numNums());
            this.sizeRiskSet = MemoryManager.malloc8d((int)n_time);
            this.sizeCensored = MemoryManager.malloc8d((int)n_time);
            this.sizeEvents = MemoryManager.malloc8d((int)n_time);
            this.countEvents = MemoryManager.malloc8((int)n_time);
            this.sumRiskEvents = MemoryManager.malloc8d((int)n_time);
            this.sumLogRiskEvents = MemoryManager.malloc8d((int)n_time);
            this.rcumsumRisk = MemoryManager.malloc8d((int)n_time);
            this.sumXEvents = MemoryManager.malloc8d((int)n_coef);
            this.sumXRiskEvents = MemoryManager.malloc8d((int)n_time, (int)n_coef);
            this.rcumsumXRisk = MemoryManager.malloc8d((int)n_time, (int)n_coef);
            if (this._isBreslow) {
                this.rcumsumXXRisk = MemoryManager.malloc8d((int)n_time, (int)n_coef, (int)n_coef);
            }
        }

        @Override
        protected void processRow(DataInfo.Row row) {
            int j;
            int j2;
            double strata;
            double weight;
            ++this.n;
            double[] response = row.response;
            int ncats = row.nBins;
            int[] cats = row.binIds;
            double[] nums = row.numVals;
            double d = weight = this._has_weights_column ? row.weight : 1.0;
            if (weight <= 0.0) {
                throw new IllegalArgumentException("weights must be positive values");
            }
            int respIdx = response.length - 1;
            long event = (long)(response[respIdx--] - (double)this._min_event);
            int t2 = (int)response[respIdx--];
            int t1 = this._has_start_column ? (int)response[respIdx--] : -1;
            double d2 = strata = this._has_strata_column ? response[respIdx--] : 0.0;
            assert (respIdx == -1) : "expected to use all response data";
            if (Double.isNaN(strata)) {
                return;
            }
            int strataId = (int)strata;
            int numStart = this._dinfo.numStart();
            int n = strataId;
            this.sumWeights[n] = this.sumWeights[n] + weight;
            for (j2 = 0; j2 < ncats; ++j2) {
                double[] dArray = this.sumWeightedCatX[strataId];
                int n2 = cats[j2];
                dArray[n2] = dArray[n2] + weight;
            }
            for (j2 = 0; j2 < nums.length; ++j2) {
                double[] dArray = this.sumWeightedNumX[strataId];
                int n3 = j2;
                dArray[n3] = dArray[n3] + weight * nums[j2];
            }
            double logRisk = 0.0;
            for (j = 0; j < ncats; ++j) {
                logRisk += this._beta[cats[j]];
            }
            for (j = 0; j < nums.length - this._n_offsets; ++j) {
                logRisk += nums[j] * this._beta[numStart + j];
            }
            for (j = nums.length - this._n_offsets; j < nums.length; ++j) {
                logRisk += nums[j];
            }
            double risk = weight * Math.exp(logRisk);
            logRisk *= weight;
            if (event > 0L) {
                int n4 = t2;
                this.countEvents[n4] = this.countEvents[n4] + 1L;
                int n5 = t2;
                this.sizeEvents[n5] = this.sizeEvents[n5] + weight;
                int n6 = t2;
                this.sumLogRiskEvents[n6] = this.sumLogRiskEvents[n6] + logRisk;
                int n7 = t2;
                this.sumRiskEvents[n7] = this.sumRiskEvents[n7] + risk;
            } else {
                int n8 = t2;
                this.sizeCensored[n8] = this.sizeCensored[n8] + weight;
            }
            if (this._has_start_column) {
                int t = t1;
                while (t <= t2) {
                    int n9 = t++;
                    this.sizeRiskSet[n9] = this.sizeRiskSet[n9] + weight;
                }
                t = t1;
                while (t <= t2) {
                    int n10 = t++;
                    this.rcumsumRisk[n10] = this.rcumsumRisk[n10] + risk;
                }
            } else {
                int n11 = t2;
                this.sizeRiskSet[n11] = this.sizeRiskSet[n11] + weight;
                int n12 = t2;
                this.rcumsumRisk[n12] = this.rcumsumRisk[n12] + risk;
            }
            int ntotal = ncats + (nums.length - this._n_offsets);
            int numStartIter = numStart - ncats;
            for (int jit = 0; jit < ntotal; ++jit) {
                boolean jIsCat = jit < ncats;
                int j3 = jIsCat ? cats[jit] : numStartIter + jit;
                double x1 = jIsCat ? 1.0 : nums[jit - ncats];
                double xRisk = x1 * risk;
                if (event > 0L) {
                    int n13 = j3;
                    this.sumXEvents[n13] = this.sumXEvents[n13] + weight * x1;
                    double[] dArray = this.sumXRiskEvents[t2];
                    int n14 = j3;
                    dArray[n14] = dArray[n14] + xRisk;
                }
                double[] dArray = this.rcumsumXRisk[t2];
                int n15 = j3;
                dArray[n15] = dArray[n15] + xRisk;
                if (this._has_start_column && t1 % this._time.length > 0) {
                    double[] dArray2 = this.rcumsumXRisk[t1 - 1];
                    int n16 = j3;
                    dArray2[n16] = dArray2[n16] - xRisk;
                }
                if (!this._isBreslow) continue;
                for (int kit = 0; kit < ntotal; ++kit) {
                    boolean kIsCat = kit < ncats;
                    int k = kIsCat ? cats[kit] : numStartIter + kit;
                    double x2 = kIsCat ? 1.0 : nums[kit - ncats];
                    double xxRisk = x2 * xRisk;
                    if (this._has_start_column) {
                        for (int t = t1; t <= t2; ++t) {
                            double[] dArray3 = this.rcumsumXXRisk[t][j3];
                            int n17 = k;
                            dArray3[n17] = dArray3[n17] + xxRisk;
                        }
                        continue;
                    }
                    double[] dArray4 = this.rcumsumXXRisk[t2][j3];
                    int n18 = k;
                    dArray4[n18] = dArray4[n18] + xxRisk;
                }
            }
        }

        public void reduce(CoxPHTask that) {
            this.n += that.n;
            ArrayUtils.add((double[])this.sumWeights, (double[])that.sumWeights);
            ArrayUtils.add((double[][])this.sumWeightedCatX, (double[][])that.sumWeightedCatX);
            ArrayUtils.add((double[][])this.sumWeightedNumX, (double[][])that.sumWeightedNumX);
            ArrayUtils.add((double[])this.sizeRiskSet, (double[])that.sizeRiskSet);
            ArrayUtils.add((double[])this.sizeCensored, (double[])that.sizeCensored);
            ArrayUtils.add((double[])this.sizeEvents, (double[])that.sizeEvents);
            ArrayUtils.add((long[])this.countEvents, (long[])that.countEvents);
            ArrayUtils.add((double[])this.sumXEvents, (double[])that.sumXEvents);
            ArrayUtils.add((double[])this.sumRiskEvents, (double[])that.sumRiskEvents);
            ArrayUtils.add((double[][])this.sumXRiskEvents, (double[][])that.sumXRiskEvents);
            ArrayUtils.add((double[])this.sumLogRiskEvents, (double[])that.sumLogRiskEvents);
            ArrayUtils.add((double[])this.rcumsumRisk, (double[])that.rcumsumRisk);
            ArrayUtils.add((double[][])this.rcumsumXRisk, (double[][])that.rcumsumXRisk);
            if (this._isBreslow) {
                ArrayUtils.add((double[][][])this.rcumsumXXRisk, (double[][][])that.rcumsumXXRisk);
            }
        }

        protected void postGlobal() {
            int j;
            int t;
            for (t = this.rcumsumXRisk.length - 2; t >= 0; --t) {
                for (j = 0; j < this.rcumsumXRisk[t].length; ++j) {
                    double[] dArray = this.rcumsumXRisk[t];
                    int n = j;
                    dArray[n] = dArray[n] + ((t + 1) % this._time.length == 0 ? 0.0 : this.rcumsumXRisk[t + 1][j]);
                }
            }
            if (!this._has_start_column) {
                for (t = this.rcumsumRisk.length - 2; t >= 0; --t) {
                    int n = t;
                    this.rcumsumRisk[n] = this.rcumsumRisk[n] + ((t + 1) % this._time.length == 0 ? 0.0 : this.rcumsumRisk[t + 1]);
                }
                if (this._isBreslow) {
                    for (t = this.rcumsumXXRisk.length - 2; t >= 0; --t) {
                        for (j = 0; j < this.rcumsumXXRisk[t].length; ++j) {
                            for (int k = 0; k < this.rcumsumXXRisk[t][j].length; ++k) {
                                double[] dArray = this.rcumsumXXRisk[t][j];
                                int n = k;
                                dArray[n] = dArray[n] + ((t + 1) % this._time.length == 0 ? 0.0 : this.rcumsumXXRisk[t + 1][j][k]);
                            }
                        }
                    }
                }
            }
        }
    }

    public class CoxPHDriver
    extends ModelBuilder.Driver {
        public CoxPHDriver() {
            super((ModelBuilder)CoxPH.this);
        }

        private Frame reorderTrainFrameColumns(IcedHashMap<AstGroup.G, IcedInt> outStrataMap, double[] time) {
            Frame discretizedFr;
            Frame f = new Frame(new Vec[0]);
            Vec weightVec = null;
            Vec startVec = null;
            Vec stopVec = null;
            Vec eventVec = null;
            Vec[] vecs = CoxPH.this.train().vecs();
            String[] names = CoxPH.this.train().names();
            for (int i = 0; i < names.length; ++i) {
                if (names[i].equals(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._weights_column)) {
                    weightVec = vecs[i];
                    continue;
                }
                if (names[i].equals(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._start_column)) {
                    startVec = vecs[i];
                    continue;
                }
                if (names[i].equals(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._stop_column)) {
                    stopVec = vecs[i];
                    continue;
                }
                if (names[i].equals(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._response_column)) {
                    eventVec = vecs[i];
                    continue;
                }
                f.add(names[i], vecs[i]);
            }
            Vec strataVec = null;
            if (((CoxPHModel.CoxPHParameters)CoxPH.this._parms).isStratified()) {
                StrataTask.setupStrataMapping(f, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._stratify_by, outStrataMap);
                discretizedFr = Scope.track((Frame[])new Frame[]{StrataTask.stratifyTime(f, time, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._stratify_by, outStrataMap, startVec, stopVec, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._single_node_mode)});
                strataVec = discretizedFr.remove(0);
                if (((CoxPHModel.CoxPHParameters)CoxPH.this._parms).interactionSpec() == null) {
                    f.remove(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._stratify_by);
                }
            } else {
                discretizedFr = Scope.track((Frame[])new Frame[]{DiscretizeTimeTask.discretizeTime(time, startVec, stopVec, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._single_node_mode)});
            }
            if (startVec != null) {
                startVec = discretizedFr.vec(0);
                stopVec = discretizedFr.vec(1);
            } else {
                stopVec = discretizedFr.vec(0);
            }
            if (weightVec != null) {
                f.add(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._weights_column, weightVec);
            }
            if (strataVec != null) {
                f.add(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._strata_column, strataVec);
            }
            if (startVec != null) {
                f.add(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._start_column, startVec);
            }
            if (stopVec != null) {
                f.add(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._stop_column, stopVec);
            }
            if (eventVec != null) {
                f.add(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._response_column, eventVec);
            }
            return f;
        }

        protected void initStats(CoxPHModel model, DataInfo dinfo, double[] time) {
            CoxPHModel.CoxPHParameters p = (CoxPHModel.CoxPHParameters)model._parms;
            CoxPHModel.CoxPHOutput o = (CoxPHModel.CoxPHOutput)model._output;
            o._n = p.stopVec().length();
            o.data_info = dinfo;
            int n_offsets = CoxPH.this._offset == null ? 0 : 1;
            int n_coef = o.data_info.fullN() - n_offsets;
            String[] coefNames = o.data_info.coefNames();
            o._coef_names = new String[n_coef];
            System.arraycopy(coefNames, 0, o._coef_names, 0, n_coef);
            o._coef = MemoryManager.malloc8d((int)n_coef);
            o._exp_coef = MemoryManager.malloc8d((int)n_coef);
            o._exp_neg_coef = MemoryManager.malloc8d((int)n_coef);
            o._se_coef = MemoryManager.malloc8d((int)n_coef);
            o._z_coef = MemoryManager.malloc8d((int)n_coef);
            o._var_coef = MemoryManager.malloc8d((int)n_coef, (int)n_coef);
            o._mean_offset = MemoryManager.malloc8d((int)n_offsets);
            o._offset_names = new String[n_offsets];
            System.arraycopy(coefNames, n_coef, o._offset_names, 0, n_offsets);
            int n_time = (int)dinfo._adaptedFrame.vec(p._stop_column).max() + 1;
            o._time = time;
            o._n_risk = MemoryManager.malloc8d((int)n_time);
            o._n_event = MemoryManager.malloc8d((int)n_time);
            o._n_censor = MemoryManager.malloc8d((int)n_time);
        }

        protected void calcCounts(CoxPHModel model, CoxPHTask coxMR) {
            int t;
            CoxPHModel.CoxPHParameters p = (CoxPHModel.CoxPHParameters)model._parms;
            CoxPHModel.CoxPHOutput o = (CoxPHModel.CoxPHOutput)model._output;
            o._n_missing = o._n - coxMR.n;
            o._n = coxMR.n;
            o._x_mean_cat = MemoryManager.malloc8d((int)coxMR.sumWeights.length, (int)o.data_info.numCats());
            o._x_mean_num = MemoryManager.malloc8d((int)coxMR.sumWeights.length, (int)(o.data_info.numNums() - o._mean_offset.length));
            for (int s = 0; s < coxMR.sumWeights.length; ++s) {
                System.arraycopy(coxMR.sumWeightedCatX[s], 0, o._x_mean_cat[s], 0, o._x_mean_cat[s].length);
                int j = 0;
                while (j < o._x_mean_cat[s].length) {
                    double[] dArray = o._x_mean_cat[s];
                    int n = j++;
                    dArray[n] = dArray[n] / coxMR.sumWeights[s];
                }
                System.arraycopy(coxMR.sumWeightedNumX[s], 0, o._x_mean_num[s], 0, o._x_mean_num[s].length);
                for (j = 0; j < o._x_mean_num[s].length; ++j) {
                    o._x_mean_num[s][j] = o.data_info._normSub[j] + o._x_mean_num[s][j] / coxMR.sumWeights[s];
                }
            }
            System.arraycopy(o.data_info._normSub, o.data_info.numNums() - o._mean_offset.length, o._mean_offset, 0, o._mean_offset.length);
            for (t = 0; t < coxMR.countEvents.length; ++t) {
                o._total_event += coxMR.countEvents[t];
                if (!(coxMR.sizeEvents[t] > 0.0) && !(coxMR.sizeCensored[t] > 0.0)) continue;
                o._n_risk[t] = coxMR.sizeRiskSet[t];
                o._n_event[t] = coxMR.sizeEvents[t];
                o._n_censor[t] = coxMR.sizeCensored[t];
            }
            if (p._start_column == null) {
                for (t = o._n_risk.length - 2; t >= 0; --t) {
                    int n = t;
                    o._n_risk[n] = o._n_risk[n] + o._n_risk[t + 1];
                }
            }
        }

        protected ComputationState calcLoglik(DataInfo dinfo, ComputationState cs, CoxPHModel.CoxPHParameters p, CoxPHTask coxMR) {
            cs.reset();
            switch (p._ties) {
                case efron: {
                    return EfronMethod.calcLoglik(dinfo, coxMR, cs, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._single_node_mode);
                }
                case breslow: {
                    int n_coef = cs._n_coef;
                    int n_time = coxMR.sizeEvents.length;
                    double newLoglik = 0.0;
                    for (int i = 0; i < n_coef; ++i) {
                        cs._gradient[i] = coxMR.sumXEvents[i];
                    }
                    for (int t = n_time - 1; t >= 0; --t) {
                        double sizeEvents_t = coxMR.sizeEvents[t];
                        if (!(sizeEvents_t > 0.0)) continue;
                        double sumLogRiskEvents_t = coxMR.sumLogRiskEvents[t];
                        double rcumsumRisk_t = coxMR.rcumsumRisk[t];
                        newLoglik += sumLogRiskEvents_t;
                        newLoglik -= sizeEvents_t * Math.log(rcumsumRisk_t);
                        for (int j = 0; j < n_coef; ++j) {
                            double dlogTerm = coxMR.rcumsumXRisk[t][j] / rcumsumRisk_t;
                            int n = j;
                            cs._gradient[n] = cs._gradient[n] - sizeEvents_t * dlogTerm;
                            for (int k = 0; k < n_coef; ++k) {
                                double[] dArray = cs._hessian[j];
                                int n2 = k;
                                dArray[n2] = dArray[n2] - sizeEvents_t * (coxMR.rcumsumXXRisk[t][j][k] / rcumsumRisk_t - dlogTerm * (coxMR.rcumsumXRisk[t][k] / rcumsumRisk_t));
                            }
                        }
                    }
                    cs._logLik = newLoglik;
                    return cs;
                }
            }
            throw new IllegalArgumentException("_ties method must be either efron or breslow");
        }

        protected void calcModelStats(CoxPHModel model, double[] newCoef, ComputationState cs) {
            int k;
            int j;
            CoxPHModel.CoxPHParameters p = (CoxPHModel.CoxPHParameters)model._parms;
            CoxPHModel.CoxPHOutput o = (CoxPHModel.CoxPHOutput)model._output;
            int n_coef = o._coef.length;
            Matrix inv_hessian = new Matrix(cs._hessian).inverse();
            for (j = 0; j < n_coef; ++j) {
                for (int k2 = 0; k2 <= j; ++k2) {
                    double elem;
                    o._var_coef[j][k2] = elem = -inv_hessian.get(j, k2);
                    o._var_coef[k2][j] = elem;
                }
            }
            for (j = 0; j < n_coef; ++j) {
                o._coef[j] = newCoef[j];
                o._exp_coef[j] = Math.exp(o._coef[j]);
                o._exp_neg_coef[j] = Math.exp(-o._coef[j]);
                o._se_coef[j] = Math.sqrt(o._var_coef[j][j]);
                o._z_coef[j] = o._coef[j] / o._se_coef[j];
            }
            if (o._iter == 0) {
                o._null_loglik = cs._logLik;
                o._maxrsq = 1.0 - Math.exp(2.0 * o._null_loglik / (double)o._n);
                o._score_test = 0.0;
                for (j = 0; j < n_coef; ++j) {
                    double sum = 0.0;
                    for (k = 0; k < n_coef; ++k) {
                        sum += o._var_coef[j][k] * cs._gradient[k];
                    }
                    o._score_test += cs._gradient[j] * sum;
                }
            }
            o._loglik = cs._logLik;
            o._loglik_test = -2.0 * (o._null_loglik - o._loglik);
            o._rsq = 1.0 - Math.exp(-o._loglik_test / (double)o._n);
            o._wald_test = 0.0;
            for (j = 0; j < n_coef; ++j) {
                double sum = 0.0;
                for (k = 0; k < n_coef; ++k) {
                    sum -= cs._hessian[j][k] * (o._coef[k] - p._init);
                }
                o._wald_test += (o._coef[j] - p._init) * sum;
            }
        }

        protected void calcCumhaz_0(CoxPHModel model, CoxPHTask coxMR) {
            int t;
            CoxPHModel.CoxPHParameters p = (CoxPHModel.CoxPHParameters)model._parms;
            CoxPHModel.CoxPHOutput o = (CoxPHModel.CoxPHOutput)model._output;
            int n_time = coxMR.sizeEvents.length;
            o._cumhaz_0 = MemoryManager.malloc8d((int)n_time);
            o._var_cumhaz_1 = MemoryManager.malloc8d((int)n_time);
            o._var_cumhaz_2 = Key.make((String)(model._key + "_var_cumhaz_2"));
            o._var_cumhaz_2_matrix = new CoxPHModel.FrameMatrix(o._var_cumhaz_2, n_time, o._coef.length);
            int n_coef = o._coef.length;
            int nz = 0;
            switch (p._ties) {
                case efron: {
                    double sizeCensored_t;
                    double sizeEvents_t;
                    for (t = 0; t < coxMR.sizeEvents.length; ++t) {
                        sizeEvents_t = coxMR.sizeEvents[t];
                        sizeCensored_t = coxMR.sizeCensored[t];
                        if (!(sizeEvents_t > 0.0) && !(sizeCensored_t > 0.0)) continue;
                        long countEvents_t = coxMR.countEvents[t];
                        double sumRiskEvents_t = coxMR.sumRiskEvents[t];
                        double rcumsumRisk_t = coxMR.rcumsumRisk[t];
                        double avgSize = sizeEvents_t / (double)countEvents_t;
                        o._cumhaz_0[nz] = 0.0;
                        o._var_cumhaz_1[nz] = 0.0;
                        for (int j = 0; j < n_coef; ++j) {
                            o._var_cumhaz_2_matrix.set(nz, j, 0.0);
                        }
                        for (long e = 0L; e < countEvents_t; ++e) {
                            double frac = (double)e / (double)countEvents_t;
                            double haz = 1.0 / (rcumsumRisk_t - frac * sumRiskEvents_t);
                            double haz_sq = haz * haz;
                            int n = nz;
                            o._cumhaz_0[n] = o._cumhaz_0[n] + avgSize * haz;
                            int n2 = nz;
                            o._var_cumhaz_1[n2] = o._var_cumhaz_1[n2] + avgSize * haz_sq;
                            for (int j = 0; j < n_coef; ++j) {
                                o._var_cumhaz_2_matrix.add(nz, j, avgSize * ((coxMR.rcumsumXRisk[t][j] - frac * coxMR.sumXRiskEvents[t][j]) * haz_sq));
                            }
                        }
                        ++nz;
                    }
                    break;
                }
                case breslow: {
                    double sizeCensored_t;
                    double sizeEvents_t;
                    for (t = 0; t < coxMR.sizeEvents.length; ++t) {
                        double cumhaz_0_nz;
                        sizeEvents_t = coxMR.sizeEvents[t];
                        sizeCensored_t = coxMR.sizeCensored[t];
                        if (!(sizeEvents_t > 0.0) && !(sizeCensored_t > 0.0)) continue;
                        double rcumsumRisk_t = coxMR.rcumsumRisk[t];
                        o._cumhaz_0[nz] = cumhaz_0_nz = sizeEvents_t / rcumsumRisk_t;
                        o._var_cumhaz_1[nz] = sizeEvents_t / (rcumsumRisk_t * rcumsumRisk_t);
                        for (int j = 0; j < n_coef; ++j) {
                            o._var_cumhaz_2_matrix.set(nz, j, coxMR.rcumsumXRisk[t][j] / rcumsumRisk_t * cumhaz_0_nz);
                        }
                        ++nz;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("_ties method must be either efron or breslow");
                }
            }
            for (t = 1; t < o._cumhaz_0.length; ++t) {
                o._cumhaz_0[t] = o._cumhaz_0[t - 1] + o._cumhaz_0[t];
                o._var_cumhaz_1[t] = o._var_cumhaz_1[t - 1] + o._var_cumhaz_1[t];
                for (int j = 0; j < n_coef; ++j) {
                    o._var_cumhaz_2_matrix.set(t, j, o._var_cumhaz_2_matrix.get(t - 1, j) + o._var_cumhaz_2_matrix.get(t, j));
                }
            }
            o._var_cumhaz_2_matrix.toFrame(o._var_cumhaz_2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeImpl() {
            CoxPHModel model = null;
            try {
                CoxPH.this.init(true);
                double[] time = CollectTimes.collect(((CoxPHModel.CoxPHParameters)CoxPH.this._parms).stopVec(), ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._single_node_mode);
                CoxPH.this._job.update(0L, "Initializing model training");
                IcedHashMap strataMap = new IcedHashMap();
                Frame f = this.reorderTrainFrameColumns((IcedHashMap<AstGroup.G, IcedInt>)strataMap, time);
                int nResponses = (((CoxPHModel.CoxPHParameters)CoxPH.this._parms).startVec() == null ? 2 : 3) + (((CoxPHModel.CoxPHParameters)CoxPH.this._parms).isStratified() ? 1 : 0);
                DataInfo dinfo = new DataInfo(f, null, nResponses, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._use_all_factor_levels, DataInfo.TransformType.DEMEAN, DataInfo.TransformType.NONE, true, false, false, CoxPH.this.hasWeightCol(), false, false, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms).interactionSpec()).disableIntercept();
                Scope.track_generic((Keyed)dinfo);
                DKV.put((Keyed)dinfo);
                CoxPHModel.CoxPHOutput output = new CoxPHModel.CoxPHOutput(CoxPH.this, dinfo._adaptedFrame, CoxPH.this.train(), (IcedHashMap<AstGroup.G, IcedInt>)strataMap);
                model = new CoxPHModel(CoxPH.this._job._result, (CoxPHModel.CoxPHParameters)CoxPH.this._parms, output);
                model.delete_and_lock(CoxPH.this._job);
                this.initStats(model, dinfo, time);
                ScoringHistory sc = new ScoringHistory(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._max_iterations + 1);
                int n_offsets = CoxPH.this._offset == null ? 0 : 1;
                int n_coef = dinfo.fullN() - n_offsets;
                double[] step = MemoryManager.malloc8d((int)n_coef);
                double[] oldCoef = MemoryManager.malloc8d((int)n_coef);
                double[] newCoef = MemoryManager.malloc8d((int)n_coef);
                Arrays.fill(step, Double.NaN);
                Arrays.fill(oldCoef, Double.NaN);
                for (int j = 0; j < n_coef; ++j) {
                    newCoef[j] = ((CoxPHModel.CoxPHParameters)model._parms)._init;
                }
                double logLik = -1.7976931348623157E308;
                boolean has_start_column = ((CoxPHModel.CoxPHParameters)model._parms).startVec() != null;
                boolean has_weights_column = CoxPH.this._weights != null;
                ComputationState cs = new ComputationState(n_coef);
                Timer iterTimer = null;
                CoxPHTask coxMR = null;
                CoxPH.this._job.update(1L, "Running iteration 0");
                for (int i = 0; i <= ((CoxPHModel.CoxPHParameters)model._parms)._max_iterations; ++i) {
                    int j;
                    iterTimer = new Timer();
                    ((CoxPHModel.CoxPHOutput)model._output)._iter = i;
                    Timer aggregTimer = new Timer();
                    coxMR = (CoxPHTask)new CoxPHTask(dinfo, newCoef, time, (long)CoxPH.this.response().min(), n_offsets, has_start_column, dinfo._adaptedFrame.vec(((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._strata_column), has_weights_column, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._ties).doAll(dinfo._adaptedFrame, ((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._single_node_mode);
                    Log.info((Object[])new Object[]{"CoxPHTask: iter=" + i + ", time=" + aggregTimer.toString()});
                    CoxPH.this._job.update(1L);
                    Timer loglikTimer = new Timer();
                    double newLoglik = this.calcLoglik((DataInfo)dinfo, (ComputationState)cs, (CoxPHModel.CoxPHParameters)((CoxPHModel.CoxPHParameters)CoxPH.this._parms), (CoxPHTask)coxMR)._logLik;
                    Log.info((Object[])new Object[]{"LogLik: iter=" + i + ", time=" + loglikTimer.toString() + ", logLig=" + newLoglik});
                    ((CoxPHModel.CoxPHOutput)model._output)._scoring_history = sc.addIterationScore(i, newLoglik).to2dTable(i);
                    if (newLoglik > logLik) {
                        if (i == 0) {
                            this.calcCounts(model, coxMR);
                        }
                        this.calcModelStats(model, newCoef, cs);
                        ((CoxPHModel.CoxPHOutput)model._output)._lre = newLoglik == 0.0 ? -Math.log10(Math.abs(logLik - newLoglik)) : -Math.log10(Math.abs((logLik - newLoglik) / newLoglik));
                        if (((CoxPHModel.CoxPHOutput)model._output)._lre >= ((CoxPHModel.CoxPHParameters)model._parms)._lre_min) break;
                        Arrays.fill(step, 0.0);
                        for (j = 0; j < n_coef; ++j) {
                            for (int k = 0; k < n_coef; ++k) {
                                int n = j;
                                step[n] = step[n] - ((CoxPHModel.CoxPHOutput)model._output)._var_coef[j][k] * cs._gradient[k];
                            }
                        }
                        for (j = 0; j < n_coef && !Double.isNaN(step[j]) && !Double.isInfinite(step[j]); ++j) {
                        }
                        logLik = newLoglik;
                        System.arraycopy(newCoef, 0, oldCoef, 0, oldCoef.length);
                    } else {
                        j = 0;
                        while (j < n_coef) {
                            int n = j++;
                            step[n] = step[n] / 2.0;
                        }
                    }
                    for (j = 0; j < n_coef; ++j) {
                        newCoef[j] = oldCoef[j] - step[j];
                    }
                    model.update(CoxPH.this._job);
                    CoxPH.this._job.update(1L, "Iteration = " + i + "/" + ((CoxPHModel.CoxPHParameters)model._parms)._max_iterations + ", logLik = " + logLik);
                    if (i == ((CoxPHModel.CoxPHParameters)model._parms)._max_iterations) continue;
                    Log.info((Object[])new Object[]{"CoxPH Iteration: iter=" + i + ", " + iterTimer.toString()});
                }
                if (((CoxPHModel.CoxPHParameters)CoxPH.this._parms)._calc_cumhaz && coxMR != null) {
                    this.calcCumhaz_0(model, coxMR);
                }
                if (iterTimer != null) {
                    Log.info((Object[])new Object[]{"CoxPH Last Iteration: " + iterTimer.toString()});
                }
                model.update(CoxPH.this._job);
            }
            finally {
                if (model != null) {
                    model.unlock(CoxPH.this._job);
                }
            }
        }
    }

    static class StrataTask
    extends DiscretizeTimeTask {
        private final IcedHashMap<AstGroup.G, IcedInt> _strataMap;

        private StrataTask(IcedHashMap<AstGroup.G, IcedInt> strata) {
            this(strata, new double[0], false);
        }

        private StrataTask(IcedHashMap<AstGroup.G, IcedInt> strata, double[] time, boolean has_start_column) {
            super(time, has_start_column);
            this._strataMap = strata;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            NewChunk[] tncs;
            Chunk[] tcs;
            Chunk[] scs;
            if (ncs.length > 1) {
                scs = new Chunk[cs.length - ncs.length + 1];
                System.arraycopy(cs, 0, scs, 0, scs.length);
                tcs = new Chunk[ncs.length - 1];
                System.arraycopy(cs, scs.length, tcs, 0, tcs.length);
                tncs = new NewChunk[ncs.length - 1];
                System.arraycopy(ncs, 1, tncs, 0, tncs.length);
            } else {
                scs = cs;
                tcs = null;
                tncs = null;
            }
            AstGroup.G g = new AstGroup.G(scs.length, null);
            for (int i = 0; i < cs[0].len(); ++i) {
                g.fill(i, scs);
                IcedInt strataId = (IcedInt)this._strataMap.get((Object)g);
                if (strataId == null) {
                    for (NewChunk nc : ncs) {
                        nc.addNA();
                    }
                    continue;
                }
                ncs[0].addNum((double)strataId._val);
                if (tcs == null) continue;
                int strataOffset = this._time.length * strataId._val;
                this.discretizeTime(i, tcs, tncs, strataOffset);
            }
        }

        static Vec makeStrataVec(Frame f, String[] stratifyBy, IcedHashMap<AstGroup.G, IcedInt> mapping, boolean runLocal) {
            Frame sf = f.subframe(stratifyBy);
            return ((DiscretizeTimeTask)new StrataTask(mapping).doAll(new byte[]{3}, sf, runLocal)).outputFrame().anyVec();
        }

        static Frame stratifyTime(Frame f, double[] time, String[] stratifyBy, IcedHashMap<AstGroup.G, IcedInt> mapping, Vec startVec, Vec stopVec, boolean runLocal) {
            boolean hasStartColumn;
            Frame sf = f.subframe(stratifyBy);
            boolean bl = hasStartColumn = startVec != null;
            if (hasStartColumn) {
                sf.add("__startVec", startVec);
            }
            sf.add("__stopVec", stopVec);
            return ((DiscretizeTimeTask)new StrataTask(mapping, time, hasStartColumn).doAll(ArrayUtils.constAry((int)(hasStartColumn ? 3 : 2), (byte)3), sf, runLocal)).outputFrame();
        }

        static void setupStrataMapping(Frame f, String[] stratifyBy, IcedHashMap<AstGroup.G, IcedInt> outMapping) {
            Frame sf = f.subframe(stratifyBy);
            int[] idxs = MemoryManager.malloc4((int)stratifyBy.length);
            for (int i = 0; i < idxs.length; ++i) {
                idxs[i] = i;
            }
            IcedHashSet groups = AstGroup.doGroups((Frame)sf, (int[])idxs, (AstGroup.AGG[])AstGroup.aggNRows());
            block1: for (AstGroup.G g : groups) {
                for (double val : g._gs) {
                    if (Double.isNaN(val)) continue block1;
                }
                outMapping.put((Object)g, (Object)new IcedInt(outMapping.size()));
            }
        }
    }

    static class DiscretizeTimeTask
    extends MRTask<DiscretizeTimeTask> {
        final double[] _time;
        final boolean _has_start_column;

        private DiscretizeTimeTask(double[] time, boolean has_start_column) {
            this._time = time;
            this._has_start_column = has_start_column;
        }

        public void map(Chunk[] cs, NewChunk[] ncs) {
            assert (cs.length == (this._has_start_column ? 2 : 1));
            for (int i = 0; i < cs[0].len(); ++i) {
                this.discretizeTime(i, cs, ncs, 0);
            }
        }

        void discretizeTime(int i, Chunk[] cs, NewChunk[] ncs, int offset) {
            double stopTime = cs[cs.length - 1].atd(i);
            int t2 = Arrays.binarySearch(this._time, stopTime);
            if (t2 < 0) {
                throw new IllegalStateException("Encountered unexpected stop time");
            }
            ncs[ncs.length - 1].addNum((double)(t2 + offset));
            if (this._has_start_column) {
                double startTime = cs[0].atd(i);
                if (startTime >= stopTime) {
                    throw new IllegalArgumentException("start times must be strictly less than stop times");
                }
                int t1c = Arrays.binarySearch(this._time, startTime);
                int t1 = t1c >= 0 ? t1c + 1 : -t1c - 1;
                ncs[0].addNum((double)(t1 + offset));
            }
        }

        static Frame discretizeTime(double[] time, Vec startVec, Vec stopVec, boolean runLocal) {
            byte[] byArray;
            boolean hasStartColumn = startVec != null;
            Frame f = new Frame(new Vec[0]);
            if (hasStartColumn) {
                f.add("__startCol", startVec);
            }
            f.add("__stopCol", stopVec);
            if (hasStartColumn) {
                byte[] byArray2 = new byte[2];
                byArray2[0] = 3;
                byArray = byArray2;
                byArray2[1] = 3;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 3;
            }
            byte[] outputTypes = byArray;
            return ((DiscretizeTimeTask)new DiscretizeTimeTask(time, startVec != null).doAll(outputTypes, f, runLocal)).outputFrame();
        }
    }
}

