/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetricsRegressionCoxPH;
import hex.StringPair;
import hex.coxph.CoxPH;
import hex.coxph.Storage;
import hex.schemas.CoxPHModelV3;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.Job;
import water.Key;
import water.MRTask;
import water.api.schemas3.ModelSchemaV3;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.ast.prims.mungers.AstGroup;
import water.udf.CFuncRef;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.IcedInt;

public class CoxPHModel
extends Model<CoxPHModel, CoxPHParameters, CoxPHOutput> {
    public ModelMetricsRegressionCoxPH.MetricBuilderRegressionCoxPH makeMetricBuilder(String[] domain) {
        return new ModelMetricsRegressionCoxPH.MetricBuilderRegressionCoxPH(((CoxPHParameters)this._input_parms)._start_column, ((CoxPHParameters)this._input_parms)._stop_column, ((CoxPHParameters)this._input_parms).isStratified(), ((CoxPHParameters)this._input_parms)._stratify_by);
    }

    public ModelSchemaV3 schema() {
        return new CoxPHModelV3();
    }

    public CoxPHModel(Key destKey, CoxPHParameters parms, CoxPHOutput output) {
        super(destKey, (Model.Parameters)parms, (Model.Output)output);
    }

    protected Frame predictScoreImpl(Frame fr, Frame adaptFrm, String destination_key, Job job, boolean computeMetrics, CFuncRef customMetricFunc) {
        int nResponses = 0;
        for (String col : ((CoxPHParameters)this._parms).responseCols()) {
            if (adaptFrm.find(col) == -1) continue;
            ++nResponses;
        }
        DataInfo scoringInfo = ((CoxPHOutput)this._output).data_info.scoringInfo(((CoxPHOutput)this._output)._names, adaptFrm, nResponses, false);
        CoxPHScore score = new CoxPHScore(scoringInfo, (CoxPHOutput)this._output, ((CoxPHParameters)this._parms).isStratified());
        Frame scored = ((CoxPHScore)score.doAll((byte)3, scoringInfo._adaptedFrame)).outputFrame(Key.make((String)destination_key), new String[]{"lp"}, null);
        if (computeMetrics) {
            ModelMetricsRegressionCoxPH modelMetricsRegressionCoxPH = this.makeMetricBuilder(null).makeModelMetrics((Model)this, fr, adaptFrm, scored);
        }
        return scored;
    }

    public String[] adaptTestForTrain(Frame test, boolean expensive, boolean computeMetrics) {
        boolean createStrataVec;
        boolean bl = createStrataVec = ((CoxPHParameters)this._parms).isStratified() && test.vec(((CoxPHParameters)this._parms)._strata_column) == null;
        if (createStrataVec) {
            Vec strataVec = test.anyVec().makeCon(Double.NaN);
            this._toDelete.put((Object)strataVec._key, (Object)"adapted missing strata vector");
            test.add(((CoxPHParameters)this._parms)._strata_column, strataVec);
        }
        String[] msgs = super.adaptTestForTrain(test, expensive, computeMetrics);
        if (createStrataVec) {
            Vec strataVec = CoxPH.StrataTask.makeStrataVec(test, ((CoxPHParameters)this._parms)._stratify_by, ((CoxPHOutput)this._output)._strataMap, ((CoxPHParameters)this._parms)._single_node_mode);
            this._toDelete.put((Object)strataVec._key, (Object)"adapted missing strata vector");
            test.replace(test.find(((CoxPHParameters)this._parms)._strata_column), strataVec);
            if (((CoxPHOutput)this._output)._strataOnlyCols != null) {
                test.remove(((CoxPHOutput)this._output)._strataOnlyCols);
            }
        }
        return msgs;
    }

    public double[] score0(double[] data, double[] preds) {
        throw new UnsupportedOperationException("CoxPHModel.score0 should never be called");
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        Frame varCumhaz2;
        Frame frame = varCumhaz2 = ((CoxPHOutput)this._output)._var_cumhaz_2 != null ? (Frame)((CoxPHOutput)this._output)._var_cumhaz_2.get() : null;
        if (varCumhaz2 != null) {
            varCumhaz2.remove(fs);
        }
        super.remove_impl(fs, cascade);
        return fs;
    }

    private static class CoxPHScore
    extends MRTask<CoxPHScore> {
        private DataInfo _dinfo;
        private double[] _coef;
        private double[] _lpBase;
        private int _numStart;
        private boolean _hasStrata;

        private CoxPHScore(DataInfo dinfo, CoxPHOutput o, boolean hasStrata) {
            int strataCount = o._x_mean_cat.length;
            this._dinfo = dinfo;
            this._hasStrata = hasStrata;
            this._coef = o._coef;
            this._numStart = o._x_mean_cat[0].length;
            this._lpBase = new double[strataCount];
            for (int s = 0; s < strataCount; ++s) {
                int i;
                for (i = 0; i < o._x_mean_cat[s].length; ++i) {
                    int n = s;
                    this._lpBase[n] = this._lpBase[n] + o._x_mean_cat[s][i] * this._coef[i];
                }
                for (i = 0; i < o._x_mean_num[s].length; ++i) {
                    int n = s;
                    this._lpBase[n] = this._lpBase[n] + o._x_mean_num[s][i] * this._coef[i + this._numStart];
                }
            }
        }

        public void map(Chunk[] chks, NewChunk nc) {
            DataInfo.Row r = this._dinfo.newDenseRow();
            for (int rid = 0; rid < chks[0]._len; ++rid) {
                double s;
                this._dinfo.extractDenseRow(chks, rid, r);
                if (r.predictors_bad) {
                    nc.addNA();
                    continue;
                }
                double d = s = this._hasStrata ? chks[this._dinfo.responseChunkId(0)].atd(rid) : 0.0;
                if (Double.isNaN(s)) {
                    nc.addNA();
                    continue;
                }
                double lp = r.innerProduct(this._coef) - this._lpBase[(int)s];
                nc.addNum(lp);
            }
        }
    }

    public static class FrameMatrix
    extends Storage.DenseRowMatrix {
        Key<Frame> _frame_key;

        FrameMatrix(Key<Frame> frame_key, int rows, int cols) {
            super(rows, cols);
            this._frame_key = frame_key;
        }

        public final AutoBuffer write_impl(AutoBuffer ab) {
            Key.write_impl(this._frame_key, (AutoBuffer)ab);
            return ab;
        }

        public final FrameMatrix read_impl(AutoBuffer ab) {
            this._frame_key = Key.read_impl(null, (AutoBuffer)ab);
            if (DKV.getGet(this._frame_key) == null) {
                this.toFrame(this._frame_key);
            }
            return this;
        }
    }

    public static class CoxPHOutput
    extends Model.Output {
        Model.InteractionSpec _interactionSpec;
        DataInfo data_info;
        IcedHashMap<AstGroup.G, IcedInt> _strataMap;
        String[] _strataOnlyCols;
        public String[] _coef_names;
        public double[] _coef;
        public double[] _exp_coef;
        public double[] _exp_neg_coef;
        public double[] _se_coef;
        public double[] _z_coef;
        double[][] _var_coef;
        double _null_loglik;
        double _loglik;
        double _loglik_test;
        double _wald_test;
        double _score_test;
        double _rsq;
        double _maxrsq;
        double _lre;
        int _iter;
        double[][] _x_mean_cat;
        double[][] _x_mean_num;
        double[] _mean_offset;
        String[] _offset_names;
        long _n;
        long _n_missing;
        long _total_event;
        double[] _time;
        double[] _n_risk;
        double[] _n_event;
        double[] _n_censor;
        double[] _cumhaz_0;
        double[] _var_cumhaz_1;
        FrameMatrix _var_cumhaz_2_matrix;
        Key<Frame> _var_cumhaz_2;
        CoxPHParameters.CoxPHTies _ties;
        String _formula;

        public CoxPHOutput(CoxPH coxPH, Frame adaptFr, Frame train, IcedHashMap<AstGroup.G, IcedInt> strataMap) {
            super((ModelBuilder)coxPH, CoxPHOutput.fullFrame(coxPH, adaptFr, train));
            this._strataOnlyCols = new String[this._names.length - adaptFr._names.length];
            for (int i = 0; i < this._strataOnlyCols.length; ++i) {
                this._strataOnlyCols[i] = this._names[i];
            }
            this._ties = ((CoxPHParameters)coxPH._parms)._ties;
            this._formula = ((CoxPHParameters)coxPH._parms).toFormula(train);
            this._interactionSpec = ((CoxPHParameters)coxPH._parms).interactionSpec();
            this._strataMap = strataMap;
        }

        private static Frame fullFrame(CoxPH coxPH, Frame adaptFr, Frame train) {
            if (!((CoxPHParameters)coxPH._parms).isStratified()) {
                return adaptFr;
            }
            Frame ff = new Frame(new Vec[0]);
            for (String col : ((CoxPHParameters)coxPH._parms)._stratify_by) {
                if (adaptFr.vec(col) != null) continue;
                ff.add(col, train.vec(col));
            }
            ff.add(adaptFr);
            return ff;
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.CoxPH;
        }

        public Model.InteractionBuilder interactionBuilder() {
            return this._interactionSpec != null ? new CoxPHInteractionBuilder() : null;
        }

        private class CoxPHInteractionBuilder
        implements Model.InteractionBuilder {
            private CoxPHInteractionBuilder() {
            }

            public Frame makeInteractions(Frame f) {
                Model.InteractionPair[] interactions = CoxPHOutput.this._interactionSpec.makeInteractionPairs(f);
                f.add(Model.makeInteractions((Frame)f, (boolean)false, (Model.InteractionPair[])interactions, (boolean)CoxPHOutput.this.data_info._useAllFactorLevels, (boolean)CoxPHOutput.this.data_info._skipMissing, (CoxPHOutput.this.data_info._predictor_transform == DataInfo.TransformType.STANDARDIZE ? 1 : 0) != 0));
                return f;
            }
        }
    }

    public static class CoxPHParameters
    extends Model.Parameters {
        public String _start_column;
        public String _stop_column;
        final String _strata_column = "__strata";
        public String[] _stratify_by;
        public CoxPHTies _ties = CoxPHTies.efron;
        public double _init = 0.0;
        public double _lre_min = 9.0;
        public int _max_iterations = 20;
        public boolean _use_all_factor_levels;
        public String[] _interactions_only;
        public String[] _interactions = null;
        public StringPair[] _interaction_pairs = null;
        public boolean _calc_cumhaz = true;
        public boolean _single_node_mode = false;

        public String algoName() {
            return "CoxPH";
        }

        public String fullName() {
            return "Cox Proportional Hazards";
        }

        public String javaName() {
            return CoxPHModel.class.getName();
        }

        public long progressUnits() {
            return (this._max_iterations + 1) * 2 + 1;
        }

        String[] responseCols() {
            Object[] cols;
            Object[] objectArray;
            if (this._start_column != null) {
                String[] stringArray = new String[1];
                objectArray = stringArray;
                stringArray[0] = this._start_column;
            } else {
                objectArray = cols = new String[]{};
            }
            if (this.isStratified()) {
                cols = (String[])ArrayUtils.append((Object[])cols, (Object[])new String[]{this._start_column});
            }
            return (String[])ArrayUtils.append((Object[])cols, (Object[])new String[]{this._stop_column, this._response_column});
        }

        Vec startVec() {
            return this.train().vec(this._start_column);
        }

        Vec stopVec() {
            return this.train().vec(this._stop_column);
        }

        Model.InteractionSpec interactionSpec() {
            String[] interOnly;
            if (this._interactions_only != null && this._stratify_by != null) {
                Object[] io = (String[])this._interactions_only.clone();
                Arrays.sort(io);
                Object[] sb = (String[])this._stratify_by.clone();
                Arrays.sort(sb);
                interOnly = ArrayUtils.union((String[])io, (String[])sb, (boolean)true);
            } else {
                interOnly = this._interactions_only != null ? this._interactions_only : this._stratify_by;
            }
            return Model.InteractionSpec.create((String[])this._interactions, (StringPair[])this._interaction_pairs, (String[])interOnly, (String[])this._stratify_by);
        }

        boolean isStratified() {
            return this._stratify_by != null && this._stratify_by.length > 0;
        }

        String toFormula(Frame f) {
            Model.InteractionSpec interactionSpec;
            StringBuilder sb = new StringBuilder();
            sb.append("Surv(");
            if (this._start_column != null) {
                sb.append(this._start_column).append(", ");
            }
            sb.append(this._stop_column).append(", ").append(this._response_column);
            sb.append(") ~ ");
            HashSet<String> stratifyBy = this._stratify_by != null ? new HashSet<String>(Arrays.asList(this._stratify_by)) : Collections.emptySet();
            HashSet<String> interactionsOnly = this._interactions_only != null ? new HashSet<String>(Arrays.asList(this._interactions_only)) : Collections.emptySet();
            HashSet<String> specialCols = new HashSet<String>(){
                {
                    this.add(_start_column);
                    if (_stop_column != null) {
                        this.add(_stop_column);
                    }
                    this.add(_response_column);
                    this.add("__strata");
                    if (_weights_column != null) {
                        this.add(_weights_column);
                    }
                    if (_ignored_columns != null) {
                        this.addAll(Arrays.asList(_ignored_columns));
                    }
                }
            };
            String sep = "";
            for (String col : f._names) {
                if (this._offset_column != null && this._offset_column.equals(col) || stratifyBy.contains(col) || interactionsOnly.contains(col) || specialCols.contains(col)) continue;
                sb.append(sep).append(col);
                sep = " + ";
            }
            if (this._offset_column != null) {
                sb.append(sep).append("offset(").append(this._offset_column).append(")");
            }
            if ((interactionSpec = this.interactionSpec()) != null) {
                Model.InteractionPair[] interactionPairs;
                Model.InteractionPair[] interactionPairArray = interactionPairs = this.interactionSpec().makeInteractionPairs(f);
                int n = interactionPairArray.length;
                for (int i = 0; i < n; ++i) {
                    Model.InteractionPair ip = interactionPairArray[i];
                    sb.append(sep);
                    String v1 = f._names[ip.getV1()];
                    String v2 = f._names[ip.getV2()];
                    if (stratifyBy.contains(v1)) {
                        sb.append("strata(").append(v1).append(")");
                    } else {
                        sb.append(v1);
                    }
                    sb.append(":");
                    if (stratifyBy.contains(v2)) {
                        sb.append("strata(").append(v2).append(")");
                    } else {
                        sb.append(v2);
                    }
                    sep = " + ";
                }
            }
            if (this._stratify_by != null) {
                String tmp = sb.toString();
                for (String col : this._stratify_by) {
                    String strataCol = "strata(" + col + ")";
                    if (tmp.contains(strataCol)) continue;
                    sb.append(sep).append(strataCol);
                    sep = " + ";
                }
            }
            return sb.toString();
        }

        public static enum CoxPHTies {
            efron,
            breslow;

        }
    }
}

