/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

import hex.DataInfo;
import hex.DistributionFactory;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ToEigenVec;
import hex.deeplearning.DeepLearningModel;
import hex.deeplearning.DeepLearningModelInfo;
import hex.deeplearning.DeepLearningTask;
import hex.deeplearning.DeepLearningTask2;
import hex.genmodel.utils.DistributionFamily;
import hex.glm.GLMTask;
import hex.util.EffectiveParametersUtils;
import hex.util.LinearAlgebraUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import water.DKV;
import water.H2O;
import water.H2ONode;
import water.HeartBeat;
import water.Iced;
import water.IcedUtils;
import water.Job;
import water.Key;
import water.Scope;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.init.Linpack;
import water.init.NetworkTest;
import water.util.Log;
import water.util.MRUtils;
import water.util.PrettyPrint;

public class DeepLearning
extends ModelBuilder<DeepLearningModel, DeepLearningModel.DeepLearningParameters, DeepLearningModel.DeepLearningModelOutput> {
    public DeepLearning(DeepLearningModel.DeepLearningParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public DeepLearning(DeepLearningModel.DeepLearningParameters parms, Key<DeepLearningModel> key) {
        super((Model.Parameters)parms, key);
        this.init(false);
    }

    public DeepLearning(boolean startup_once) {
        super((Model.Parameters)new DeepLearningModel.DeepLearningParameters(), startup_once);
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial, ModelCategory.Multinomial, ModelCategory.AutoEncoder};
    }

    public boolean havePojo() {
        return true;
    }

    public boolean haveMojo() {
        return true;
    }

    public ToEigenVec getToEigenVec() {
        return LinearAlgebraUtils.toEigen;
    }

    public boolean isSupervised() {
        return !((DeepLearningModel.DeepLearningParameters)this._parms)._autoencoder;
    }

    protected DeepLearningDriver trainModelImpl() {
        return new DeepLearningDriver();
    }

    public void init(boolean expensive) {
        super.init(expensive);
        ((DeepLearningModel.DeepLearningParameters)this._parms).validate(this, expensive);
        this._orig_projection_array = LinearAlgebraUtils.toEigenProjectionArray(this._origTrain, this._train, expensive);
        if (expensive && this.error_count() == 0) {
            this.checkMemoryFootPrint();
        }
    }

    static DataInfo makeDataInfo(Frame train, Frame valid, DeepLearningModel.DeepLearningParameters parms, int nClasses) {
        double x = 0.782347234;
        boolean identityLink = DistributionFactory.getDistribution((Model.Parameters)parms).link(x) == x;
        DataInfo dinfo = new DataInfo(train, valid, parms._autoencoder ? 0 : 1, parms._autoencoder || parms._use_all_factor_levels, parms._standardize ? (parms._autoencoder ? DataInfo.TransformType.NORMALIZE : (parms._sparse ? DataInfo.TransformType.DESCALE : DataInfo.TransformType.STANDARDIZE)) : DataInfo.TransformType.NONE, !parms._standardize || train.lastVec().isCategorical() ? DataInfo.TransformType.NONE : (identityLink ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE), parms._missing_values_handling == DeepLearningModel.DeepLearningParameters.MissingValuesHandling.Skip, false, true, parms._weights_column != null, parms._offset_column != null, parms._fold_column != null);
        GLMTask.YMUTask ymt = (GLMTask.YMUTask)new GLMTask.YMUTask(dinfo, nClasses, !parms._autoencoder && nClasses == 1, parms._missing_values_handling == DeepLearningModel.DeepLearningParameters.MissingValuesHandling.Skip, !parms._autoencoder, true).doAll(dinfo._adaptedFrame);
        if (ymt.wsum() == 0.0 && parms._missing_values_handling == DeepLearningModel.DeepLearningParameters.MissingValuesHandling.Skip) {
            throw new H2OIllegalArgumentException("No rows left in the dataset after filtering out rows with missing values. Ignore columns with many NAs or set missing_values_handling to 'MeanImputation'.");
        }
        if (parms._weights_column != null && parms._offset_column != null) {
            Log.warn((Object[])new Object[]{"Combination of offset and weights can lead to slight differences because Rollupstats aren't weighted - need to re-calculate weighted mean/sigma of the response including offset terms."});
        }
        if (parms._weights_column != null && parms._offset_column == null) {
            dinfo.updateWeightedSigmaAndMean(ymt.predictorSDs(), ymt.predictorMeans());
            if (nClasses == 1) {
                dinfo.updateWeightedSigmaAndMeanForResponse(ymt.responseSDs(), ymt.responseMeans());
            }
        }
        return dinfo;
    }

    protected void checkMemoryFootPrint_impl() {
        if (((DeepLearningModel.DeepLearningParameters)this._parms)._checkpoint != null) {
            return;
        }
        long p = LinearAlgebraUtils.numColsExp(this._train, true) - (((DeepLearningModel.DeepLearningParameters)this._parms)._autoencoder ? 0 : this._train.lastVec().cardinality());
        String[][] dom = this._train.domains();
        for (int i = 0; i < this._train.numCols() - (((DeepLearningModel.DeepLearningParameters)this._parms)._autoencoder ? 0 : 1); ++i) {
            if (dom[i] == null) continue;
            ++p;
        }
        long output = ((DeepLearningModel.DeepLearningParameters)this._parms)._autoencoder ? p : (long)Math.abs(this._train.lastVec().cardinality());
        long model_size = 0L;
        if (((DeepLearningModel.DeepLearningParameters)this._parms)._hidden.length == 0) {
            model_size += p * output;
        } else {
            int layer;
            model_size += p * (long)((DeepLearningModel.DeepLearningParameters)this._parms)._hidden[0];
            for (layer = 1; layer < ((DeepLearningModel.DeepLearningParameters)this._parms)._hidden.length; ++layer) {
                model_size += (long)(((DeepLearningModel.DeepLearningParameters)this._parms)._hidden[layer - 1] * ((DeepLearningModel.DeepLearningParameters)this._parms)._hidden[layer]);
            }
            model_size += (long)((DeepLearningModel.DeepLearningParameters)this._parms)._hidden[layer - 1] * output;
            for (layer = 0; layer < ((DeepLearningModel.DeepLearningParameters)this._parms)._hidden.length; ++layer) {
                model_size += (long)((DeepLearningModel.DeepLearningParameters)this._parms)._hidden[layer];
            }
            model_size += output;
        }
        if ((double)model_size > 1.0E8) {
            String msg = "Model is too large: " + model_size + " parameters. Try reducing the number of neurons in the hidden layers (or reduce the number of categorical factors).";
            this.error("_hidden", msg);
        }
    }

    public void cv_computeAndSetOptimalParameters(ModelBuilder[] cvModelBuilders) {
        ((DeepLearningModel.DeepLearningParameters)this._parms)._overwrite_with_best_model = false;
        if (((DeepLearningModel.DeepLearningParameters)this._parms)._stopping_rounds == 0 && ((DeepLearningModel.DeepLearningParameters)this._parms)._max_runtime_secs == 0.0) {
            return;
        }
        ((DeepLearningModel.DeepLearningParameters)this._parms)._stopping_rounds = 0;
        ((DeepLearningModel.DeepLearningParameters)this._parms)._max_runtime_secs = 0.0;
        double sum = 0.0;
        for (ModelBuilder cvmb : cvModelBuilders) {
            sum += ((DeepLearningModel)DKV.getGet((Key)cvmb.dest())).last_scored().epoch_counter;
        }
        ((DeepLearningModel.DeepLearningParameters)this._parms)._epochs = sum / (double)cvModelBuilders.length;
        if (!((DeepLearningModel.DeepLearningParameters)this._parms)._quiet_mode) {
            this.warn("_epochs", "Setting optimal _epochs to " + ((DeepLearningModel.DeepLearningParameters)this._parms)._epochs + " for cross-validation main model based on early stopping of cross-validation models.");
            this.warn("_stopping_rounds", "Disabling convergence-based early stopping for cross-validation main model.");
            this.warn("_max_runtime_secs", "Disabling maximum allowed runtime for cross-validation main model.");
        }
    }

    protected Frame rebalance(Frame original_fr, boolean local, String name) {
        if (original_fr == null) {
            return null;
        }
        if (((DeepLearningModel.DeepLearningParameters)this._parms)._force_load_balance || ((DeepLearningModel.DeepLearningParameters)this._parms)._reproducible) {
            int original_chunks = original_fr.anyVec().nChunks();
            this._job.update(0L, "Load balancing " + name.substring(name.length() - 5) + " data...");
            int chunks = this.desiredChunks(original_fr, local);
            if (!((DeepLearningModel.DeepLearningParameters)this._parms)._reproducible) {
                if (original_chunks >= chunks) {
                    if (!((DeepLearningModel.DeepLearningParameters)this._parms)._quiet_mode) {
                        Log.info((Object[])new Object[]{"Dataset already contains " + original_chunks + " chunks. No need to rebalance."});
                    }
                    return original_fr;
                }
            } else {
                assert (chunks == 1);
                if (!((DeepLearningModel.DeepLearningParameters)this._parms)._quiet_mode) {
                    Log.warn((Object[])new Object[]{"Reproducibility enforced - using only 1 thread - can be slow."});
                }
                if (original_chunks == 1) {
                    return original_fr;
                }
            }
            if (!((DeepLearningModel.DeepLearningParameters)this._parms)._quiet_mode) {
                Log.info((Object[])new Object[]{"Rebalancing " + name.substring(name.length() - 5) + " dataset into " + chunks + " chunks."});
            }
            Key newKey = Key.make((String)(name + ".chks" + chunks));
            RebalanceDataSet rb = new RebalanceDataSet(original_fr, newKey, chunks);
            ((RebalanceDataSet)H2O.submitTask((H2O.H2OCountedCompleter)rb)).join();
            Frame rebalanced_fr = (Frame)DKV.get((Key)newKey).get();
            Scope.track((Frame[])new Frame[]{rebalanced_fr});
            return rebalanced_fr;
        }
        return original_fr;
    }

    protected int desiredChunks(Frame original_fr, boolean local) {
        return ((DeepLearningModel.DeepLearningParameters)this._parms)._reproducible ? 1 : (int)Math.min((long)(4 * H2O.NUMCPUS * (local ? 1 : H2O.CLOUD.size())), original_fr.numRows());
    }

    static long computeTrainSamplesPerIteration(DeepLearningModel.DeepLearningParameters mp, long numRows, DeepLearningModel model) {
        long tspi = mp._train_samples_per_iteration;
        assert (tspi == 0L || tspi == -1L || tspi == -2L || tspi >= 1L);
        if (tspi == 0L || !mp._replicate_training_data && tspi == -1L) {
            tspi = numRows;
            if (!mp._quiet_mode) {
                Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp._train_samples_per_iteration + ") to one epoch: #rows (" + tspi + ")."});
            }
        } else if (tspi == -1L) {
            tspi = (long)(mp._single_node_mode ? 1 : H2O.CLOUD.size()) * numRows;
            if (!mp._quiet_mode) {
                Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp._train_samples_per_iteration + ") to #nodes x #rows (" + tspi + ")."});
            }
        } else if (tspi == -2L) {
            double total_gflops = 0.0;
            for (H2ONode h2o : H2O.CLOUD._memary) {
                HeartBeat hb = h2o._heartbeat;
                total_gflops += (double)hb._gflops;
            }
            if (mp._single_node_mode) {
                total_gflops /= (double)H2O.CLOUD.size();
            }
            if (Double.isNaN(total_gflops)) {
                total_gflops = Linpack.run((int)H2O.SELF._heartbeat._cpus_allowed) * (double)(mp._single_node_mode ? 1 : H2O.CLOUD.size());
            }
            assert (!Double.isNaN(total_gflops));
            long model_size = model.model_info().size();
            int[] msg_sizes = new int[]{1, (long)((int)(model_size * 4L)) == model_size * 4L ? (int)(model_size * 4L) : Integer.MAX_VALUE};
            double[] microseconds_collective = new double[msg_sizes.length];
            NetworkTest.NetworkTester nt = new NetworkTest.NetworkTester(msg_sizes, (double[][])null, microseconds_collective, (double)model_size > 1000000.0 ? 1 : 5, false, true);
            nt.compute2();
            int network_queue_length = mp._single_node_mode || H2O.CLOUD.size() == 1 ? 1 : 2 * (int)Math.floor(Math.log(H2O.CLOUD.size()) / Math.log(2.0));
            double flops_overhead_per_row = 50.0;
            if (mp._activation == DeepLearningModel.DeepLearningParameters.Activation.Maxout || mp._activation == DeepLearningModel.DeepLearningParameters.Activation.MaxoutWithDropout) {
                flops_overhead_per_row *= 8.0;
            } else if (mp._activation == DeepLearningModel.DeepLearningParameters.Activation.Tanh || mp._activation == DeepLearningModel.DeepLearningParameters.Activation.TanhWithDropout) {
                flops_overhead_per_row *= 5.0;
            }
            double fraction = mp._single_node_mode || H2O.CLOUD.size() == 1 ? 0.001 : mp._target_ratio_comm_to_comp;
            model.time_for_communication_us = (H2O.CLOUD.size() == 1 ? 10000.0 : 100000.0) + (double)network_queue_length * microseconds_collective[1];
            double time_per_row_us = (flops_overhead_per_row * (double)model_size + (double)(10000 * model.model_info().units[0])) / (total_gflops * 1.0E9) / (double)H2O.SELF._heartbeat._cpus_allowed * 1000000.0;
            assert (!Double.isNaN(time_per_row_us));
            tspi = (long)((model.time_for_communication_us / fraction - model.time_for_communication_us) / time_per_row_us);
            if ((tspi = Math.min(tspi, (long)(mp._single_node_mode ? 1 : H2O.CLOUD.size()) * numRows * 10L)) > numRows && (double)Math.abs(tspi % numRows) / (double)numRows < 0.2) {
                tspi -= tspi % numRows;
            }
            tspi = Math.min(tspi, (long)(mp._epochs * (double)numRows / 10.0));
            if (H2O.CLOUD.size() == 1 || mp._single_node_mode) {
                tspi = Math.min(tspi, (long)(10 * (int)(1000000.0 / time_per_row_us)));
            }
            tspi = Math.max(1L, tspi);
            tspi = Math.min((long)(100000 * H2O.CLOUD.size()), tspi);
            if (!mp._quiet_mode) {
                Log.info((Object[])new Object[]{"Auto-tuning parameter 'train_samples_per_iteration':"});
                Log.info((Object[])new Object[]{"Estimated compute power : " + Math.round(total_gflops * 100.0) / 100L + " GFlops"});
                Log.info((Object[])new Object[]{"Estimated time for comm : " + PrettyPrint.usecs((long)((long)model.time_for_communication_us))});
                Log.info((Object[])new Object[]{"Estimated time per row  : " + ((long)time_per_row_us > 0L ? PrettyPrint.usecs((long)((long)time_per_row_us)) : time_per_row_us + " usecs")});
                Log.info((Object[])new Object[]{"Estimated training speed: " + (int)(1000000.0 / time_per_row_us) + " rows/sec"});
                Log.info((Object[])new Object[]{"Setting train_samples_per_iteration (" + mp._train_samples_per_iteration + ") to auto-tuned value: " + tspi});
            }
        } else {
            tspi = Math.max(1L, Math.min(tspi, (long)(mp._epochs * (double)numRows)));
        }
        assert (tspi != 0L && tspi != -1L && tspi != -2L && tspi >= 1L);
        return tspi;
    }

    public class DeepLearningDriver
    extends ModelBuilder.Driver {
        public DeepLearningDriver() {
            super((ModelBuilder)DeepLearning.this);
        }

        public void computeImpl() {
            DeepLearning.this.init(true);
            if (Model.evaluateAutoModelParameters()) {
                this.initActualParamValues();
            }
            Model.Parameters parmsToCheck = (Model.Parameters)((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms).clone();
            if (DeepLearning.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)DeepLearning.this);
            }
            this.buildModel();
            this.checkNonAutoParmsNotChanged(parmsToCheck, DeepLearning.this._parms);
        }

        public void checkNonAutoParmsNotChanged(Model.Parameters params1, Model.Parameters params2) {
            try {
                for (Field field : params1.getClass().getFields()) {
                    Class<?> type = field.getType();
                    Object value1 = field.get(params1);
                    if (value1 == null || "AUTO".equalsIgnoreCase(value1.toString())) continue;
                    Object value2 = field.get(params2);
                    assert (value1.toString().equalsIgnoreCase(value2.toString())) : "Found non-AUTO value in _parms which has changed during DL model training";
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error while checking param changes during DL model training", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void buildModel() {
            DeepLearningModel cp = null;
            ArrayList<Key> removeMe = new ArrayList<Key>();
            if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._checkpoint == null) {
                cp = new DeepLearningModel(DeepLearning.this.dest(), (DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms, new DeepLearningModel.DeepLearningModelOutput(DeepLearning.this), DeepLearning.this._train, DeepLearning.this._valid, DeepLearning.this.nclasses());
                if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._pretrained_autoencoder != null) {
                    DeepLearningModel pretrained = (DeepLearningModel)DKV.getGet((Key)((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._pretrained_autoencoder);
                    if (pretrained == null) {
                        throw new H2OIllegalArgumentException("The pretrained model '" + ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._pretrained_autoencoder + "' cannot be found.");
                    }
                    if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder || !((DeepLearningModel.DeepLearningParameters)pretrained._parms)._autoencoder) {
                        throw new H2OIllegalArgumentException("The pretrained model must be unsupervised (an autoencoder), and the model to be trained must be supervised.");
                    }
                    Log.info((Object[])new Object[]{"Loading model parameters of input and hidden layers from the pretrained autoencoder model."});
                    cp.model_info().initializeFromPretrainedModel(pretrained.model_info());
                } else {
                    cp.model_info().initializeMembers(((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._initial_weights, ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._initial_biases);
                }
            } else {
                DeepLearningModel previous = (DeepLearningModel)DKV.getGet((Key)((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._checkpoint);
                if (previous == null) {
                    throw new IllegalArgumentException("Checkpoint not found.");
                }
                Log.info((Object[])new Object[]{"Resuming from checkpoint."});
                DeepLearning.this._job.update(0L, "Resuming from checkpoint");
                if (DeepLearning.this.isClassifier() != ((DeepLearningModel.DeepLearningModelOutput)previous._output).isClassifier()) {
                    throw new H2OIllegalArgumentException("Response type must be the same as for the checkpointed model.");
                }
                if (DeepLearning.this.isSupervised() != ((DeepLearningModel.DeepLearningModelOutput)previous._output).isSupervised()) {
                    throw new H2OIllegalArgumentException("Model type must be the same as for the checkpointed model.");
                }
                DeepLearningModel.DeepLearningParameters.Sanity.checkIfParameterChangeAllowed((DeepLearningModel.DeepLearningParameters)previous._input_parms, (DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms);
                try {
                    for (String st : previous.adaptTestForTrain(DeepLearning.this._train, true, false)) {
                        Log.warn((Object[])new Object[]{st});
                    }
                    for (String st : previous.adaptTestForTrain(DeepLearning.this._valid, true, false)) {
                        Log.warn((Object[])new Object[]{st});
                    }
                    DataInfo dinfo = DeepLearning.makeDataInfo(DeepLearning.this._train, DeepLearning.this._valid, (DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms, DeepLearning.this.nclasses());
                    DKV.put(dinfo);
                    removeMe.add(dinfo._key);
                    cp = new DeepLearningModel(DeepLearning.this.dest(), (DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms, previous, false, dinfo);
                    cp.write_lock(DeepLearning.this._job);
                    if (!Arrays.equals(((DeepLearningModel.DeepLearningModelOutput)cp._output)._names, ((DeepLearningModel.DeepLearningModelOutput)previous._output)._names)) {
                        throw new H2OIllegalArgumentException("The columns of the training data must be the same as for the checkpointed model. Check ignored columns (or disable ignore_const_cols).");
                    }
                    if (!Arrays.deepEquals((Object[])((DeepLearningModel.DeepLearningModelOutput)cp._output)._domains, (Object[])((DeepLearningModel.DeepLearningModelOutput)previous._output)._domains)) {
                        throw new H2OIllegalArgumentException("Categorical factor levels of the training data must be the same as for the checkpointed model.");
                    }
                    if (dinfo.fullN() != previous.model_info().data_info().fullN()) {
                        throw new H2OIllegalArgumentException("Total number of predictors is different than for the checkpointed model.");
                    }
                    if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._epochs <= previous.epoch_counter) {
                        throw new H2OIllegalArgumentException("Total number of epochs must be larger than the number of epochs already trained for the checkpointed model (" + previous.epoch_counter + ").");
                    }
                    DeepLearningModel.DeepLearningParameters actualParms = cp.model_info().get_params();
                    assert (actualParms != previous.model_info().get_params());
                    assert (actualParms != DeepLearning.this._parms);
                    assert (actualParms != previous._parms);
                    DeepLearningModel.DeepLearningParameters.Sanity.updateParametersDuringCheckpointRestart((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms, (DeepLearningModel.DeepLearningParameters)previous._parms, false, false);
                    DeepLearningModel.DeepLearningParameters.Sanity.updateParametersDuringCheckpointRestart((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms, cp.model_info().get_params(), true, true);
                    DeepLearningModel.DeepLearningParameters.Sanity.modifyParms((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms, cp.model_info().get_params(), DeepLearning.this.nclasses());
                    Log.info((Object[])new Object[]{"Continuing training after " + String.format("%.3f", previous.epoch_counter) + " epochs from the checkpointed model."});
                    cp.update(DeepLearning.this._job);
                }
                catch (H2OIllegalArgumentException ex) {
                    if (cp != null) {
                        cp.unlock(DeepLearning.this._job);
                        cp.delete();
                        cp = null;
                    }
                    throw ex;
                }
                finally {
                    if (cp != null) {
                        cp.unlock(DeepLearning.this._job);
                    }
                }
            }
            DistributionFamily actualDistribution = cp.model_info().get_params()._distribution;
            if (Model.evaluateAutoModelParameters() && ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._distribution == DistributionFamily.AUTO) {
                ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._distribution = actualDistribution;
                ((DeepLearningModel.DeepLearningParameters)cp._parms)._distribution = actualDistribution;
            }
            this.trainModel(cp);
            for (Key k : removeMe) {
                DKV.remove((Key)k);
            }
            ArrayList<Key> keep = new ArrayList<Key>();
            try {
                if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._export_weights_and_biases && ((DeepLearningModel.DeepLearningModelOutput)cp._output).weights != null && ((DeepLearningModel.DeepLearningModelOutput)cp._output).biases != null) {
                    for (Key k : Arrays.asList(((DeepLearningModel.DeepLearningModelOutput)cp._output).weights)) {
                        keep.add(k);
                        Vec[] vecArray = ((Frame)DKV.getGet((Key)k)).vecs();
                        int n = vecArray.length;
                        for (int i = 0; i < n; ++i) {
                            Vec vk = vecArray[i];
                            keep.add(vk._key);
                        }
                    }
                    for (Key k : Arrays.asList(((DeepLearningModel.DeepLearningModelOutput)cp._output).biases)) {
                        keep.add(k);
                        for (Vec vk : ((Frame)DKV.getGet((Key)k)).vecs()) {
                            keep.add(vk._key);
                        }
                    }
                }
            }
            finally {
                Scope.exit((Key[])keep.toArray(new Key[keep.size()]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final DeepLearningModel trainModel(DeepLearningModel model) {
            block42: {
                Frame validScoreFrame = null;
                try {
                    DeepLearningModel best_model;
                    Frame trainScoreFrame;
                    block41: {
                        long now;
                        if (model == null) {
                            model = (DeepLearningModel)DKV.get((Key)DeepLearning.this.dest()).get();
                        }
                        Log.info((Object[])new Object[]{"Model category: " + (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder ? "Auto-Encoder" : (DeepLearning.this.isClassifier() ? "Classification" : "Regression"))});
                        long model_size = model.model_info().size();
                        Log.info((Object[])new Object[]{"Number of model parameters (weights/biases): " + String.format("%,d", model_size)});
                        model.write_lock(DeepLearning.this._job);
                        DeepLearning.this._job.update(0L, "Setting up training data...");
                        DeepLearningModel.DeepLearningParameters mp = model.model_info().get_params();
                        Frame tra_fr = new Frame(mp._train, DeepLearning.this._train.names(), DeepLearning.this._train.vecs());
                        Frame val_fr = DeepLearning.this._valid != null ? new Frame(mp._valid, DeepLearning.this._valid.names(), DeepLearning.this._valid.vecs()) : null;
                        Frame train = tra_fr;
                        if (((DeepLearningModel.DeepLearningModelOutput)model._output).isClassifier() && mp._balance_classes) {
                            DeepLearning.this._job.update(0L, "Balancing class distribution of training data...");
                            float[] trainSamplingFactors = new float[train.lastVec().domain().length];
                            if (mp._class_sampling_factors != null) {
                                if (mp._class_sampling_factors.length != train.lastVec().domain().length) {
                                    throw new IllegalArgumentException("class_sampling_factors must have " + train.lastVec().domain().length + " elements");
                                }
                                trainSamplingFactors = (float[])mp._class_sampling_factors.clone();
                            }
                            train = MRUtils.sampleFrameStratified((Frame)train, (Vec)train.lastVec(), (Vec)train.vec(((DeepLearningModel.DeepLearningModelOutput)model._output).weightsName()), (float[])trainSamplingFactors, (long)((long)(mp._max_after_balance_size * (float)train.numRows())), (long)mp._seed, (boolean)true, (boolean)false);
                            Vec l = train.lastVec();
                            Vec w = train.vec(((DeepLearningModel.DeepLearningModelOutput)model._output).weightsName());
                            MRUtils.ClassDist cd = new MRUtils.ClassDist(l);
                            ((DeepLearningModel.DeepLearningModelOutput)model._output)._modelClassDist = DeepLearning.this._weights != null ? ((MRUtils.ClassDist)cd.doAll(new Vec[]{l, w})).relDist() : ((MRUtils.ClassDist)cd.doAll(new Vec[]{l})).relDist();
                        }
                        model.training_rows = train.numRows();
                        if (DeepLearning.this._weights != null && DeepLearning.this._weights.min() == 0.0 && DeepLearning.this._weights.max() == 1.0 && DeepLearning.this._weights.isInt()) {
                            model.training_rows = Math.round((double)train.numRows() * DeepLearning.this._weights.mean());
                            Log.warn((Object[])new Object[]{"Not counting " + (train.numRows() - model.training_rows) + " rows with weight=0 towards an epoch."});
                        }
                        Log.info((Object[])new Object[]{"One epoch corresponds to " + model.training_rows + " training data rows."});
                        trainScoreFrame = MRUtils.sampleFrame((Frame)train, (long)mp._score_training_samples, (long)mp._seed);
                        if (trainScoreFrame != train) {
                            Scope.track((Frame[])new Frame[]{trainScoreFrame});
                        }
                        if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                            Log.info((Object[])new Object[]{"Number of chunks of the training data: " + train.anyVec().nChunks()});
                        }
                        if (val_fr != null) {
                            model.validation_rows = val_fr.numRows();
                            if (((DeepLearningModel.DeepLearningModelOutput)model._output).isClassifier() && mp._balance_classes && mp._score_validation_sampling == DeepLearningModel.DeepLearningParameters.ClassSamplingMethod.Stratified) {
                                DeepLearning.this._job.update(0L, "Sampling validation data (stratified)...");
                                validScoreFrame = MRUtils.sampleFrameStratified((Frame)val_fr, (Vec)val_fr.lastVec(), (Vec)val_fr.vec(((DeepLearningModel.DeepLearningModelOutput)model._output).weightsName()), null, (long)(mp._score_validation_samples > 0L ? mp._score_validation_samples : val_fr.numRows()), (long)(mp._seed + 1L), (boolean)false, (boolean)false);
                            } else {
                                DeepLearning.this._job.update(0L, "Sampling validation data...");
                                validScoreFrame = MRUtils.sampleFrame((Frame)val_fr, (long)mp._score_validation_samples, (long)(mp._seed + 1L));
                                if (validScoreFrame != val_fr) {
                                    Scope.track((Frame[])new Frame[]{validScoreFrame});
                                }
                            }
                            if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                                Log.info((Object[])new Object[]{"Number of chunks of the validation data: " + validScoreFrame.anyVec().nChunks()});
                            }
                        }
                        model.actual_train_samples_per_iteration = DeepLearning.computeTrainSamplesPerIteration(mp, model.training_rows, model);
                        if (mp._replicate_training_data && model.actual_train_samples_per_iteration == model.training_rows * (long)(mp._single_node_mode ? 1 : H2O.CLOUD.size()) && !mp._shuffle_training_data && H2O.CLOUD.size() > 1 && !mp._reproducible) {
                            if (!mp._quiet_mode) {
                                Log.info((Object[])new Object[]{"Enabling training data shuffling, because all nodes train on the full dataset (replicated training data)."});
                            }
                            mp._shuffle_training_data = true;
                        }
                        if (!mp._shuffle_training_data && model.actual_train_samples_per_iteration == model.training_rows && train.anyVec().nChunks() == 1) {
                            if (!mp._quiet_mode) {
                                Log.info((Object[])new Object[]{"Enabling training data shuffling to avoid training rows in the same order over and over (no Hogwild since there's only 1 chunk)."});
                            }
                            mp._shuffle_training_data = true;
                        }
                        model._timeLastIterationEnter = now = System.currentTimeMillis();
                        if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._autoencoder) {
                            DeepLearning.this._job.update(0L, "Scoring null model of autoencoder...");
                            if (!mp._quiet_mode) {
                                Log.info((Object[])new Object[]{"Scoring the null model of the autoencoder."});
                            }
                            model.doScoring(trainScoreFrame, validScoreFrame, (Key<Job>)DeepLearning.this._job._key, 0, false);
                        }
                        model.update(DeepLearning.this._job);
                        model.total_setup_time_ms += now - DeepLearning.this._job.start_time();
                        Log.info((Object[])new Object[]{"Total setup time: " + PrettyPrint.msecs((long)model.total_setup_time_ms, (boolean)true)});
                        Log.info((Object[])new Object[]{"Starting to train the Deep Learning model."});
                        DeepLearning.this._job.update(0L, "Training...");
                        do {
                            ++model.iterations;
                            model.set_model_info(mp._epochs == 0.0 ? model.model_info() : (H2O.CLOUD.size() > 1 && mp._replicate_training_data ? (mp._single_node_mode ? ((DeepLearningTask2)new DeepLearningTask2(DeepLearning.this._job._key, train, model.model_info(), this.rowFraction(train, mp, model), model.iterations).doAll(new Key[]{Key.make((H2ONode)H2O.SELF)})).model_info() : ((DeepLearningTask2)new DeepLearningTask2(DeepLearning.this._job._key, train, model.model_info(), this.rowFraction(train, mp, model), model.iterations).doAllNodes()).model_info()) : ((DeepLearningTask)new DeepLearningTask(DeepLearning.this._job._key, model.model_info(), this.rowFraction(train, mp, model), model.iterations).doAll(train)).model_info()));
                            if (DeepLearning.this.stop_requested() && !DeepLearning.this.timeout()) {
                                throw new Job.JobCancelledException();
                            }
                            if (!model.doScoring(trainScoreFrame, validScoreFrame, (Key<Job>)DeepLearning.this._job._key, model.iterations, false)) break block41;
                        } while (!DeepLearning.this.timeout());
                        DeepLearning.this._job.update((long)(mp._epochs * (double)train.numRows()));
                    }
                    if (!DeepLearning.this.stop_requested() && ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._overwrite_with_best_model && model.actual_best_model_key != null && ((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._nfolds == 0 && (best_model = (DeepLearningModel)DKV.getGet((Key)model.actual_best_model_key)) != null && best_model.loss() < model.loss() && Arrays.equals(best_model.model_info().units, model.model_info().units)) {
                        if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                            Log.info((Object[])new Object[]{"Setting the model to be the best model so far (based on scoring history)."});
                            Log.info((Object[])new Object[]{"Best model's loss: " + best_model.loss() + " vs this model's loss (before overwriting it with the best model): " + model.loss()});
                        }
                        DeepLearningModelInfo mi = (DeepLearningModelInfo)IcedUtils.deepCopy((Iced)best_model.model_info());
                        mi.set_processed_global(model.model_info().get_processed_global());
                        mi.set_processed_local(model.model_info().get_processed_local());
                        DeepLearningModel.DeepLearningParameters parms = model.model_info().get_params();
                        model.set_model_info(mi);
                        model.model_info().parameters = parms;
                        model.update(DeepLearning.this._job);
                        model.doScoring(trainScoreFrame, validScoreFrame, (Key<Job>)DeepLearning.this._job._key, model.iterations, true);
                        if (best_model.loss() != model.loss()) {
                            if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                                Log.info((Object[])new Object[]{"Best model's loss: " + best_model.loss() + " vs this model's loss (after overwriting it with the best model) : " + model.loss()});
                            }
                            Log.warn((Object[])new Object[]{"Even though the model was reset to the previous best model, we observe different scoring results. Most likely, the data set has changed during a checkpoint restart. If so, please compare the metrics to observe your data shift."});
                        }
                    }
                    model.model_info().data_info().coefNames();
                    if (((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) break block42;
                }
                catch (Throwable throwable) {
                    if (!((DeepLearningModel.DeepLearningParameters)DeepLearning.this._parms)._quiet_mode) {
                        Log.info((Object[])new Object[]{"=============================================================================================================================================================================="});
                        if (DeepLearning.this.stop_requested()) {
                            if (DeepLearning.this.timeout()) {
                                DeepLearning.this.warn("_max_runtime_secs", "Deep Learning model training was interrupted due to timeout.  Increase _max_runtime_secs or set it to 0 to disable it.");
                            }
                            Log.info((Object[])new Object[]{"Deep Learning model training was interrupted."});
                        } else {
                            Log.info((Object[])new Object[]{"Finished training the Deep Learning model."});
                            if (model != null) {
                                Log.info((Object[])new Object[]{model});
                            }
                        }
                        Log.info((Object[])new Object[]{"=============================================================================================================================================================================="});
                    }
                    if (model != null) {
                        model.deleteElasticAverageModels();
                        model.unlock(DeepLearning.this._job);
                        if (model.actual_best_model_key != null) {
                            assert (model.actual_best_model_key != model._key);
                            DKV.remove((Key)model.actual_best_model_key);
                        }
                    }
                    throw throwable;
                }
                Log.info((Object[])new Object[]{"=============================================================================================================================================================================="});
                if (DeepLearning.this.stop_requested()) {
                    if (DeepLearning.this.timeout()) {
                        DeepLearning.this.warn("_max_runtime_secs", "Deep Learning model training was interrupted due to timeout.  Increase _max_runtime_secs or set it to 0 to disable it.");
                    }
                    Log.info((Object[])new Object[]{"Deep Learning model training was interrupted."});
                } else {
                    Log.info((Object[])new Object[]{"Finished training the Deep Learning model."});
                    if (model != null) {
                        Log.info((Object[])new Object[]{model});
                    }
                }
                Log.info((Object[])new Object[]{"=============================================================================================================================================================================="});
            }
            if (model != null) {
                model.deleteElasticAverageModels();
                model.unlock(DeepLearning.this._job);
                if (model.actual_best_model_key != null) {
                    assert (model.actual_best_model_key != model._key);
                    DKV.remove((Key)model.actual_best_model_key);
                }
            }
            return model;
        }

        public void initActualParamValues() {
            EffectiveParametersUtils.initStoppingMetric(DeepLearning.this._parms, DeepLearning.this.isClassifier());
            EffectiveParametersUtils.initCategoricalEncoding(DeepLearning.this._parms, Model.Parameters.CategoricalEncodingScheme.OneHotInternal);
        }

        private float computeRowUsageFraction(long numRows, long train_samples_per_iteration, boolean replicate_training_data) {
            float rowUsageFraction = (float)train_samples_per_iteration / (float)numRows;
            if (replicate_training_data) {
                rowUsageFraction /= (float)H2O.CLOUD.size();
            }
            assert (rowUsageFraction > 0.0f);
            return rowUsageFraction;
        }

        private float rowFraction(Frame train, DeepLearningModel.DeepLearningParameters p, DeepLearningModel m) {
            return this.computeRowUsageFraction(train.numRows(), m.actual_train_samples_per_iteration, p._replicate_training_data);
        }
    }
}

