/*
 * Decompiled with CFR 0.152.
 */
package hex.gam;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.VarImp;
import hex.gam.GAMModel;
import hex.gam.MatrixFrameUtils.GamUtils;
import hex.gam.MatrixFrameUtils.GenerateGamMatrixOneColumn;
import hex.genmodel.utils.ArrayUtils;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import water.DKV;
import water.Freezable;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.Scope;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.IcedHashSet;
import water.util.Log;

public class GAM
extends ModelBuilder<GAMModel, GAMModel.GAMParameters, GAMModel.GAMModelOutput> {
    private double[][] _knots;
    private double[] _cv_alpha = null;
    private double[] _cv_lambda = null;

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression};
    }

    public boolean isSupervised() {
        return true;
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public boolean havePojo() {
        return false;
    }

    public boolean haveMojo() {
        return true;
    }

    public GAM(boolean startup_once) {
        super((Model.Parameters)new GAMModel.GAMParameters(), startup_once);
    }

    public GAM(GAMModel.GAMParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public GAM(GAMModel.GAMParameters parms, Key<GAMModel> key) {
        super((Model.Parameters)parms, key);
        this.init(false);
    }

    public void computeCrossValidation() {
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
        }
        super.computeCrossValidation();
    }

    public void cv_computeAndSetOptimalParameters(ModelBuilder[] cvModelBuilders) {
        double deviance_valid = Double.POSITIVE_INFINITY;
        double best_alpha = 0.0;
        double best_lambda = 0.0;
        for (int i = 0; i < cvModelBuilders.length; ++i) {
            GAMModel g = (GAMModel)cvModelBuilders[i].dest().get();
            if (!(((GAMModel.GAMModelOutput)g._output)._devianceValid < deviance_valid)) continue;
            best_alpha = ((GAMModel.GAMModelOutput)g._output)._best_alpha;
            best_lambda = ((GAMModel.GAMModelOutput)g._output)._best_lambda;
        }
        this._cv_alpha = new double[]{best_alpha};
        this._cv_lambda = new double[]{best_lambda};
    }

    public double[][] generateKnotsFromKeys() {
        int numGamCols = ((GAMModel.GAMParameters)this._parms)._gam_columns.length;
        double[][] knots = new double[numGamCols][];
        boolean allNull = ((GAMModel.GAMParameters)this._parms)._knot_ids == null;
        for (int index = 0; index < numGamCols; ++index) {
            String tempKey;
            Frame predictVec = new Frame(new String[]{((GAMModel.GAMParameters)this._parms)._gam_columns[index]}, new Vec[]{((GAMModel.GAMParameters)this._parms).train().vec(((GAMModel.GAMParameters)this._parms)._gam_columns[index])});
            String string = tempKey = allNull ? null : ((GAMModel.GAMParameters)this._parms)._knot_ids[index];
            if (tempKey != null && tempKey.length() > 0) {
                Frame knotFrame = Scope.track((Frame[])new Frame[]{(Frame)DKV.getGet((Key)Key.make((String)tempKey))});
                double[][] knotContent = new double[(int)knotFrame.numRows()][1];
                ArrayUtils.FrameToArray f2a = new ArrayUtils.FrameToArray(0, 0, knotFrame.numRows(), knotContent);
                knotContent = ((ArrayUtils.FrameToArray)f2a.doAll(knotFrame)).getArray();
                knots[index] = new double[knotContent.length];
                double[][] knotCTranspose = water.util.ArrayUtils.transpose((double[][])knotContent);
                System.arraycopy(knotCTranspose[0], 0, knots[index], 0, knots[index].length);
                this.failVerifyKnots(knots[index], index);
                continue;
            }
            knots[index] = this.generateKnotsOneColumn(predictVec, ((GAMModel.GAMParameters)this._parms)._num_knots[index]);
            this.failVerifyKnots(knots[index], index);
        }
        return knots;
    }

    public void failVerifyKnots(double[] knots, int gam_column_index) {
        for (int index = 0; index < knots.length; ++index) {
            if (Double.isNaN(knots[index])) {
                this.error("gam_columns/knots_id", String.format("Knots generated by default or specified in knots_id ended up containing a NaN value for gam_column %s.   Please specify alternate knots_id or choose other columns.", ((GAMModel.GAMParameters)this._parms)._gam_columns[gam_column_index]));
                return;
            }
            if (index > 0 && knots[index - 1] > knots[index]) {
                this.error("knots_id", String.format("knots not sorted in ascending order for gam_column %s. Knots at index %d: %f.  Knots at index %d: %f", ((GAMModel.GAMParameters)this._parms)._gam_columns[gam_column_index], index - 1, knots[index - 1], index, knots[index]));
                return;
            }
            if (index <= 0 || knots[index - 1] != knots[index]) continue;
            this.error("gam_columns/knots_id", String.format("chosen gam_column %s does have not enough values to generate well-defined knots. Please choose other columns or reduce the number of knots.  If knots are specified in knots_id, choose alternate knots_id as the knots are not in ascending order.  Knots at index %d: %f.  Knots at index %d: %f", ((GAMModel.GAMParameters)this._parms)._gam_columns[gam_column_index], index - 1, knots[index - 1], index, knots[index]));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] generateKnotsOneColumn(Frame gamFrame, int knotNum) {
        double[] knots = MemoryManager.malloc8d((int)knotNum);
        try {
            Scope.enter();
            Frame tempFrame = new Frame(gamFrame);
            DKV.put((Keyed)tempFrame);
            double[] prob = MemoryManager.malloc8d((int)knotNum);
            assert (knotNum > 1);
            double stepProb = 1.0 / (double)(knotNum - 1);
            for (int knotInd = 0; knotInd < knotNum; ++knotInd) {
                prob[knotInd] = (double)knotInd * stepProb;
            }
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = tempFrame._key;
            parms._probs = prob;
            QuantileModel qModel = (QuantileModel)new Quantile(parms).trainModel().get();
            DKV.remove((Key)tempFrame._key);
            Scope.track_generic((Keyed)qModel);
            System.arraycopy(((QuantileModel.QuantileOutput)qModel._output)._quantiles[0], 0, knots, 0, knotNum);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
        return knots;
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (expensive) {
            this.validateGamParameters();
        }
    }

    private void validateGamParameters() {
        if (((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.AUTO) {
            if (this.nclasses() == 1 & ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default && ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.identity && ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.log && ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.inverse && ((GAMModel.GAMParameters)this._parms)._link != null) {
                this.error("_family", H2O.technote((int)2, (String)"AUTO for undelying response requires the link to be family_default, identity, log or inverse."));
            } else if (this.nclasses() == 2 & ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default && ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.logit && ((GAMModel.GAMParameters)this._parms)._link != null) {
                this.error("_family", H2O.technote((int)2, (String)"AUTO for undelying response requires the link to be family_default or logit."));
            } else if (this.nclasses() > 2 & ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default & ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.multinomial && ((GAMModel.GAMParameters)this._parms)._link != null) {
                this.error("_family", H2O.technote((int)2, (String)"AUTO for undelying response requires the link to be family_default or multinomial."));
            }
        }
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
        }
        if (((GAMModel.GAMParameters)this._parms)._gam_columns == null) {
            this.error("_gam_columns", "must specify columns names to apply GAM to.  If you don't have any, use GLM.");
        } else {
            Frame dataset = ((GAMModel.GAMParameters)this._parms).train();
            List<String> cNames = Arrays.asList(dataset.names());
            for (int index = 0; index < ((GAMModel.GAMParameters)this._parms)._gam_columns.length; ++index) {
                String cname = ((GAMModel.GAMParameters)this._parms)._gam_columns[index];
                if (!cNames.contains(cname)) {
                    this.error("gam_columns", "column name: " + cname + " does not exist in your dataset.");
                }
                if (dataset.vec(cname).isCategorical()) {
                    this.error("gam_columns", "column " + cname + " is categorical and cannot be used as a gam column.");
                }
                if (dataset.vec(cname).isBad() || dataset.vec(cname).isTime() || dataset.vec(cname).isUUID() || dataset.vec(cname).isConst()) {
                    this.error("gam_columns", String.format("Column '%s' of type '%s' cannot be used as GAM column. Column types BAD, TIME, CONSTANT and UUID cannot be used.", cname, dataset.vec(cname).get_type_str()));
                }
                if (dataset.vec(cname).isNumeric()) continue;
                this.error("gam_columns", "column " + cname + " is not numerical and cannot be used as a gam column.");
            }
        }
        if (((GAMModel.GAMParameters)this._parms)._bs != null && ((GAMModel.GAMParameters)this._parms)._gam_columns.length != ((GAMModel.GAMParameters)this._parms)._bs.length) {
            this.error("gam colum number", "Number of gam columns implied from _bs and _gam_columns do not match.");
        }
        if (((GAMModel.GAMParameters)this._parms)._bs == null) {
            ((GAMModel.GAMParameters)this._parms)._bs = new int[((GAMModel.GAMParameters)this._parms)._gam_columns.length];
        }
        if (((GAMModel.GAMParameters)this._parms)._num_knots == null) {
            ((GAMModel.GAMParameters)this._parms)._num_knots = new int[((GAMModel.GAMParameters)this._parms)._gam_columns.length];
            for (int index = 0; index < ((GAMModel.GAMParameters)this._parms)._gam_columns.length; ++index) {
                if (((GAMModel.GAMParameters)this._parms)._num_knots[index] != 0) continue;
                long numRowMinusNACnt = this._train.numRows() - ((GAMModel.GAMParameters)this._parms).train().vec(((GAMModel.GAMParameters)this._parms)._gam_columns[index]).naCnt();
                ((GAMModel.GAMParameters)this._parms)._num_knots[index] = numRowMinusNACnt < 10L ? (int)numRowMinusNACnt : 10;
            }
        }
        int cindex = 0;
        for (int numKnots : ((GAMModel.GAMParameters)this._parms)._num_knots) {
            long eligibleRows = this._train.numRows() - ((GAMModel.GAMParameters)this._parms).train().vec(((GAMModel.GAMParameters)this._parms)._gam_columns[cindex]).naCnt();
            if ((long)numKnots > eligibleRows) {
                this.error("_num_knots", " number of knots specified in _num_knots: " + ((GAMModel.GAMParameters)this._parms)._num_knots[cindex] + " exceed number of rows in training frame minus NA rows: " + eligibleRows + ".  Reduce _num_knots.");
            }
            ++cindex;
        }
        if (((GAMModel.GAMParameters)this._parms)._num_knots != null && ((GAMModel.GAMParameters)this._parms)._num_knots.length != ((GAMModel.GAMParameters)this._parms)._gam_columns.length) {
            this.error("gam colum number", "Number of gam columns implied from _num_knots and _gam_columns do not match.");
        }
        if (((GAMModel.GAMParameters)this._parms)._knot_ids != null && ((GAMModel.GAMParameters)this._parms)._knot_ids.length != ((GAMModel.GAMParameters)this._parms)._gam_columns.length) {
            this.error("gam colum number", "Number of gam columns implied from _num_knots and _knot_ids do not match.");
        }
        this._knots = this.generateKnotsFromKeys();
        if (((GAMModel.GAMParameters)this._parms)._saveZMatrix && this._train.numCols() - 1 + ((GAMModel.GAMParameters)this._parms)._num_knots.length < 2) {
            this.error("_saveZMatrix", "can only be enabled if we number of predictors plus Gam columns in gam_columns exceeds 2");
        }
        if (((GAMModel.GAMParameters)this._parms)._lambda_search || !((GAMModel.GAMParameters)this._parms)._intercept || ((GAMModel.GAMParameters)this._parms)._lambda == null || ((GAMModel.GAMParameters)this._parms)._lambda[0] > 0.0) {
            ((GAMModel.GAMParameters)this._parms)._use_all_factor_levels = true;
        }
        if (((GAMModel.GAMParameters)this._parms)._link == null) {
            ((GAMModel.GAMParameters)this._parms)._link = GLMModel.GLMParameters.Link.family_default;
        }
        if (((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.AUTO) {
            ((GAMModel.GAMParameters)this._parms)._family = this._nclass == 1 ? GLMModel.GLMParameters.Family.gaussian : (this._nclass == 2 ? GLMModel.GLMParameters.Family.binomial : GLMModel.GLMParameters.Family.multinomial);
        }
        if (((GAMModel.GAMParameters)this._parms)._link == null || ((GAMModel.GAMParameters)this._parms)._link.equals((Object)GLMModel.GLMParameters.Link.family_default)) {
            ((GAMModel.GAMParameters)this._parms)._link = ((GAMModel.GAMParameters)this._parms)._family.defaultLink;
        }
        if ((((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal || ((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.binomial) && this.response().get_type() != 4) {
            this.error("_response_column", String.format("For given response family '%s', please provide a categorical response column. Current response column type is '%s'.", new Object[]{((GAMModel.GAMParameters)this._parms)._family, this.response().get_type_str()}));
        }
    }

    protected boolean computePriorClassDistribution() {
        return ((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal;
    }

    protected GAMDriver trainModelImpl() {
        return new GAMDriver();
    }

    protected int nModelsInParallel(int folds) {
        return this.nModelsInParallel(folds, 2);
    }

    private class GAMDriver
    extends ModelBuilder.Driver {
        double[][][] _zTranspose;
        double[][][] _penalty_mat_center;
        double[][][] _penalty_mat;
        public double[][][] _binvD;
        public int[] _numKnots;
        String[][] _gamColNames;
        String[][] _gamColNamesCenter;
        Key<Frame>[] _gamFrameKeys;
        Key<Frame>[] _gamFrameKeysCenter;
        double[][] _gamColMeans;

        private GAMDriver() {
            super((ModelBuilder)GAM.this);
        }

        Frame adaptTrain() {
            int numGamFrame = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            this._zTranspose = GamUtils.allocate3DArray(numGamFrame, (GAMModel.GAMParameters)GAM.this._parms, GamUtils.AllocateType.firstOneLess);
            this._penalty_mat = ((GAMModel.GAMParameters)GAM.this._parms)._savePenaltyMat ? GamUtils.allocate3DArray(numGamFrame, (GAMModel.GAMParameters)GAM.this._parms, GamUtils.AllocateType.sameOrig) : (double[][][])null;
            this._penalty_mat_center = GamUtils.allocate3DArray(numGamFrame, (GAMModel.GAMParameters)GAM.this._parms, GamUtils.AllocateType.bothOneLess);
            this._binvD = GamUtils.allocate3DArray(numGamFrame, (GAMModel.GAMParameters)GAM.this._parms, GamUtils.AllocateType.firstTwoLess);
            this._numKnots = MemoryManager.malloc4((int)numGamFrame);
            this._gamColNames = new String[numGamFrame][];
            this._gamColNamesCenter = new String[numGamFrame][];
            this._gamFrameKeys = new Key[numGamFrame];
            this._gamFrameKeysCenter = new Key[numGamFrame];
            this._gamColMeans = new double[numGamFrame][];
            this.addGAM2Train();
            return this.buildGamFrame();
        }

        public Frame buildGamFrame() {
            Vec responseVec = GAM.this._train.remove(((GAMModel.GAMParameters)GAM.this._parms)._response_column);
            Vec weightsVec = null;
            if (((GAMModel.GAMParameters)GAM.this._parms)._weights_column != null) {
                weightsVec = GAM.this._train.remove(((GAMModel.GAMParameters)GAM.this._parms)._weights_column);
            }
            for (int colIdx = 0; colIdx < ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length; ++colIdx) {
                Frame gamFrame = Scope.track((Frame[])new Frame[]{(Frame)this._gamFrameKeysCenter[colIdx].get()});
                GAM.this._train.add(gamFrame.names(), gamFrame.removeAll());
                GAM.this._train.remove(((GAMModel.GAMParameters)GAM.this._parms)._gam_columns[colIdx]);
            }
            if (weightsVec != null) {
                GAM.this._train.add(((GAMModel.GAMParameters)GAM.this._parms)._weights_column, weightsVec);
            }
            if (responseVec != null) {
                GAM.this._train.add(((GAMModel.GAMParameters)GAM.this._parms)._response_column, responseVec);
            }
            return GAM.this._train;
        }

        void addGAM2Train() {
            int numGamFrame = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            RecursiveAction[] generateGamColumn = new RecursiveAction[numGamFrame];
            for (int index = 0; index < numGamFrame; ++index) {
                Vec weights_column = ((GAMModel.GAMParameters)GAM.this._parms)._weights_column == null ? Vec.makeOne((long)((GAMModel.GAMParameters)GAM.this._parms).train().numRows()) : ((GAMModel.GAMParameters)GAM.this._parms).train().vec(((GAMModel.GAMParameters)GAM.this._parms)._weights_column);
                final Frame predictVec = new Frame(new Vec[0]);
                predictVec.add(((GAMModel.GAMParameters)GAM.this._parms)._gam_columns[index], ((Frame)((GAMModel.GAMParameters)GAM.this._parms)._train.get()).vec(((GAMModel.GAMParameters)GAM.this._parms)._gam_columns[index]));
                predictVec.add("weights_column", weights_column);
                final int numKnots = ((GAMModel.GAMParameters)GAM.this._parms)._num_knots[index];
                final int numKnotsM1 = numKnots - 1;
                final int splineType = ((GAMModel.GAMParameters)GAM.this._parms)._bs[index];
                final int frameIndex = index;
                final String[] newColNames = new String[numKnots];
                for (int colIndex = 0; colIndex < numKnots; ++colIndex) {
                    newColNames[colIndex] = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns[index] + "_" + splineType + "_" + colIndex;
                }
                this._gamColNames[frameIndex] = new String[numKnots];
                this._gamColNamesCenter[frameIndex] = new String[numKnotsM1];
                this._gamColMeans[frameIndex] = new double[numKnots];
                System.arraycopy(newColNames, 0, this._gamColNames[frameIndex], 0, numKnots);
                generateGamColumn[frameIndex] = new RecursiveAction(){

                    protected void compute() {
                        GenerateGamMatrixOneColumn genOneGamCol = (GenerateGamMatrixOneColumn)new GenerateGamMatrixOneColumn(splineType, numKnots, GAM.this._knots[frameIndex], predictVec).doAll(numKnots, (byte)3, predictVec);
                        if (((GAMModel.GAMParameters)GAM.this._parms)._savePenaltyMat) {
                            GamUtils.copy2DArray(genOneGamCol._penaltyMat, GAMDriver.this._penalty_mat[frameIndex]);
                        }
                        Frame oneAugmentedColumnCenter = genOneGamCol.outputFrame(Key.make(), newColNames, null);
                        for (int cind = 0; cind < numKnots; ++cind) {
                            GAMDriver.this._gamColMeans[frameIndex][cind] = oneAugmentedColumnCenter.vec(cind).mean();
                        }
                        oneAugmentedColumnCenter = genOneGamCol.centralizeFrame(oneAugmentedColumnCenter, predictVec.name(0) + "_" + splineType + "_center_", (GAMModel.GAMParameters)GAM.this._parms);
                        GamUtils.copy2DArray(genOneGamCol._ZTransp, GAMDriver.this._zTranspose[frameIndex]);
                        double[][] transformedPenalty = water.util.ArrayUtils.multArrArr((double[][])water.util.ArrayUtils.multArrArr((double[][])genOneGamCol._ZTransp, (double[][])genOneGamCol._penaltyMat), (double[][])water.util.ArrayUtils.transpose((double[][])genOneGamCol._ZTransp));
                        GamUtils.copy2DArray(transformedPenalty, GAMDriver.this._penalty_mat_center[frameIndex]);
                        GAMDriver.this._gamFrameKeysCenter[frameIndex] = oneAugmentedColumnCenter._key;
                        DKV.put((Keyed)oneAugmentedColumnCenter);
                        System.arraycopy(oneAugmentedColumnCenter.names(), 0, GAMDriver.this._gamColNamesCenter[frameIndex], 0, numKnotsM1);
                        GamUtils.copy2DArray(genOneGamCol._bInvD, GAMDriver.this._binvD[frameIndex]);
                        GAMDriver.this._numKnots[frameIndex] = genOneGamCol._numKnots;
                    }
                };
            }
            ForkJoinTask.invokeAll((ForkJoinTask[])generateGamColumn);
        }

        void verifyGamTransformedFrame(Frame gamTransformed) {
            int numGamCols = this._gamColNamesCenter.length;
            int numGamFrame = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            for (int findex = 0; findex < numGamFrame; ++findex) {
                for (int index = 0; index < numGamCols; ++index) {
                    if (!gamTransformed.vec(this._gamColNamesCenter[findex][index]).isConst()) continue;
                    GAM.this.error(this._gamColNamesCenter[findex][index], "gam column transformation generated constant columns for " + ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns[findex]);
                }
            }
        }

        public void computeImpl() {
            Frame newValidFrame;
            GAM.this.init(true);
            if (GAM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)GAM.this);
            }
            Frame newTFrame = new Frame(GAM.this.rebalance(this.adaptTrain(), false, GAM.this._result + ".temporary.train"));
            this.verifyGamTransformedFrame(newTFrame);
            if (GAM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)GAM.this);
            }
            if (GAM.this.valid() != null) {
                GAM.this._valid = GAM.this.rebalance(GAMModel.cleanUpInputFrame((Frame)((GAMModel.GAMParameters)GAM.this._parms).valid().clone(), (GAMModel.GAMParameters)GAM.this._parms, this._gamColNamesCenter, this._binvD, this._zTranspose, GAM.this._knots, this._numKnots), false, GAM.this._result + ".temporary.valid");
            }
            DKV.put((Keyed)newTFrame);
            Frame frame = newValidFrame = GAM.this._valid == null ? null : new Frame(GAM.this._valid);
            if (newValidFrame != null) {
                DKV.put((Keyed)newValidFrame);
            }
            GAM.this._job.update(0L, "Initializing model training");
            this.buildModel(newTFrame, newValidFrame);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void buildModel(Frame newTFrame, Frame newValidFrame) {
            IcedHashSet validKeys;
            DataInfo dinfo;
            GAMModel model;
            block20: {
                model = null;
                dinfo = null;
                validKeys = new IcedHashSet();
                try {
                    GAM.this._job.update(0L, "Adding GAM columns to training dataset...");
                    dinfo = new DataInfo((Frame)GAM.this._train.clone(), GAM.this._valid, 1, ((GAMModel.GAMParameters)GAM.this._parms)._use_all_factor_levels || ((GAMModel.GAMParameters)GAM.this._parms)._lambda_search, ((GAMModel.GAMParameters)GAM.this._parms)._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, ((GAMModel.GAMParameters)GAM.this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.Skip, ((GAMModel.GAMParameters)GAM.this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.MeanImputation || ((GAMModel.GAMParameters)GAM.this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.PlugValues, ((GAMModel.GAMParameters)GAM.this._parms).makeImputer(), false, GAM.this.hasWeightCol(), GAM.this.hasOffsetCol(), GAM.this.hasFoldCol(), ((GAMModel.GAMParameters)GAM.this._parms).interactionSpec());
                    DKV.put((Key)dinfo._key, (Iced)dinfo);
                    model = new GAMModel((Key<GAMModel>)GAM.this.dest(), (GAMModel.GAMParameters)GAM.this._parms, new GAMModel.GAMModelOutput(GAM.this, dinfo));
                    model.write_lock(GAM.this._job);
                    if (((GAMModel.GAMParameters)GAM.this._parms)._keep_gam_cols) {
                        ((GAMModel.GAMModelOutput)model._output)._gamTransformedTrainCenter = newTFrame._key;
                    }
                    GAM.this._job.update(1L, "calling GLM to build GAM model...");
                    GLMModel glmModel = this.buildGLMModel((GAMModel.GAMParameters)GAM.this._parms, newTFrame, newValidFrame);
                    if (model.evalAutoParamsEnabled) {
                        model.initActualParamValuesAfterGlmCreation();
                    }
                    Scope.track_generic((Keyed)glmModel);
                    GAM.this._job.update(0L, "Building out GAM model...");
                    this.fillOutGAMModel(glmModel, model, dinfo);
                    model.update(GAM.this._job);
                    GAM.this._job.update(0L, "Scoring training frame");
                    this.scoreGenModelMetrics(model, GAM.this.train(), true);
                    if (GAM.this.valid() == null) break block20;
                    this.scoreGenModelMetrics(model, GAM.this.valid(), false);
                }
                catch (Throwable throwable) {
                    try {
                        ArrayList<Key<Vec>> keep = new ArrayList<Key<Vec>>();
                        if (model != null) {
                            if (((GAMModel.GAMParameters)GAM.this._parms)._keep_gam_cols) {
                                GamUtils.keepFrameKeys(keep, newTFrame._key);
                            } else {
                                DKV.remove((Key)newTFrame._key);
                            }
                        }
                        if (dinfo != null) {
                            dinfo.remove();
                        }
                        if (newValidFrame != null && validKeys != null) {
                            GamUtils.keepFrameKeys(keep, newValidFrame._key);
                            validKeys.addIfAbsent((Freezable)newValidFrame._key);
                            model._validKeys = validKeys;
                        }
                        Scope.exit((Key[])keep.toArray(new Key[keep.size()]));
                    }
                    finally {
                        model.update(GAM.this._job);
                        model.unlock(GAM.this._job);
                    }
                    throw throwable;
                }
            }
            try {
                ArrayList<Key<Vec>> keep = new ArrayList<Key<Vec>>();
                if (model != null) {
                    if (((GAMModel.GAMParameters)GAM.this._parms)._keep_gam_cols) {
                        GamUtils.keepFrameKeys(keep, newTFrame._key);
                    } else {
                        DKV.remove((Key)newTFrame._key);
                    }
                }
                if (dinfo != null) {
                    dinfo.remove();
                }
                if (newValidFrame != null && validKeys != null) {
                    GamUtils.keepFrameKeys(keep, newValidFrame._key);
                    validKeys.addIfAbsent((Freezable)newValidFrame._key);
                    model._validKeys = validKeys;
                }
                Scope.exit((Key[])keep.toArray(new Key[keep.size()]));
            }
            finally {
                model.update(GAM.this._job);
                model.unlock(GAM.this._job);
            }
        }

        private void scoreGenModelMetrics(GAMModel model, Frame scoreFrame, boolean forTraining) {
            Frame scoringTrain = new Frame(scoreFrame);
            model.adaptTestForTrain(scoringTrain, true, true);
            Frame scoredResult = model.score(scoringTrain);
            scoredResult.delete();
            ModelMetrics mtrain = ModelMetrics.getFromDKV((Model)model, (Frame)scoringTrain);
            if (mtrain != null) {
                if (forTraining) {
                    ((GAMModel.GAMModelOutput)model._output)._training_metrics = mtrain;
                } else {
                    ((GAMModel.GAMModelOutput)model._output)._validation_metrics = mtrain;
                }
                Log.info((Object[])new Object[]{"GAM[dest=" + GAM.this.dest() + "]" + mtrain.toString()});
            } else {
                Log.info((Object[])new Object[]{"Model metrics is empty!"});
            }
        }

        GLMModel buildGLMModel(GAMModel.GAMParameters parms, Frame trainData, Frame validFrame) {
            GLMModel.GLMParameters glmParam = GamUtils.copyGAMParams2GLMParams(parms, trainData, validFrame);
            if (GAM.this._cv_lambda != null) {
                glmParam._lambda = GAM.this._cv_lambda;
                glmParam._alpha = GAM.this._cv_alpha;
                glmParam._lambda_search = false;
            }
            int numGamCols = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            for (int find = 0; find < numGamCols; ++find) {
                if (((GAMModel.GAMParameters)GAM.this._parms)._scale == null || ((GAMModel.GAMParameters)GAM.this._parms)._scale[find] == 1.0) continue;
                this._penalty_mat_center[find] = water.util.ArrayUtils.mult((double[][])this._penalty_mat_center[find], (double)((GAMModel.GAMParameters)GAM.this._parms)._scale[find]);
            }
            return (GLMModel)new GLM(glmParam, this._penalty_mat_center, this._gamColNamesCenter).trainModel().get();
        }

        void fillOutGAMModel(GLMModel glm, GAMModel model, DataInfo dinfo) {
            model._gamColNamesNoCentering = this._gamColNames;
            model._gamColNames = this._gamColNamesCenter;
            ((GAMModel.GAMModelOutput)model._output)._gamColNames = this._gamColNamesCenter;
            ((GAMModel.GAMModelOutput)model._output)._zTranspose = this._zTranspose;
            model._gamFrameKeysCenter = this._gamFrameKeysCenter;
            model._nclass = GAM.this._nclass;
            ((GAMModel.GAMModelOutput)model._output)._binvD = this._binvD;
            ((GAMModel.GAMModelOutput)model._output)._knots = GAM.this._knots;
            ((GAMModel.GAMModelOutput)model._output)._numKnots = this._numKnots;
            ((GAMModel.GAMModelOutput)model._output)._best_alpha = ((GLMModel.GLMOutput)glm._output).getSubmodel((int)((GLMModel.GLMOutput)glm._output)._selected_submodel_idx).alpha_value;
            ((GAMModel.GAMModelOutput)model._output)._best_lambda = ((GLMModel.GLMOutput)glm._output).getSubmodel((int)((GLMModel.GLMOutput)glm._output)._selected_submodel_idx).lambda_value;
            ((GAMModel.GAMModelOutput)model._output)._devianceTrain = ((GLMModel.GLMOutput)glm._output).getSubmodel((int)((GLMModel.GLMOutput)glm._output)._selected_submodel_idx).devianceTrain;
            ((GAMModel.GAMModelOutput)model._output)._devianceValid = ((GLMModel.GLMOutput)glm._output).getSubmodel((int)((GLMModel.GLMOutput)glm._output)._selected_submodel_idx).devianceValid;
            model._gamColMeans = ArrayUtils.flat((double[][])this._gamColMeans);
            if (((GAMModel.GAMParameters)GAM.this._parms)._lambda == null) {
                ((GAMModel.GAMParameters)GAM.this._parms)._lambda = (double[])((GLMModel.GLMParameters)glm._parms)._lambda.clone();
            }
            if (((GAMModel.GAMParameters)GAM.this._parms)._keep_gam_cols) {
                ((GAMModel.GAMModelOutput)model._output)._gam_transformed_center_key = ((GAMModel.GAMModelOutput)model._output)._gamTransformedTrainCenter.toString();
            }
            if (((GAMModel.GAMParameters)GAM.this._parms)._savePenaltyMat) {
                ((GAMModel.GAMModelOutput)model._output)._penaltyMatrices_center = this._penalty_mat_center;
                ((GAMModel.GAMModelOutput)model._output)._penaltyMatrices = this._penalty_mat;
            }
            this.copyGLMCoeffs(glm, model);
            this.copyGLMtoGAMModel(model, glm);
        }

        private void copyGLMtoGAMModel(GAMModel model, GLMModel glmModel) {
            ((GAMModel.GAMModelOutput)model._output)._glm_best_lamda_value = ((GLMModel.GLMOutput)glmModel._output).bestSubmodel().lambda_value;
            ((GAMModel.GAMModelOutput)model._output)._glm_training_metrics = ((GLMModel.GLMOutput)glmModel._output)._training_metrics;
            if (GAM.this.valid() != null) {
                ((GAMModel.GAMModelOutput)model._output)._glm_validation_metrics = ((GLMModel.GLMOutput)glmModel._output)._validation_metrics;
            }
            ((GAMModel.GAMModelOutput)model._output)._glm_model_summary = model.copyTwoDimTable(((GLMModel.GLMOutput)glmModel._output)._model_summary);
            ((GAMModel.GAMModelOutput)model._output)._glm_scoring_history = model.copyTwoDimTable(((GLMModel.GLMOutput)glmModel._output)._scoring_history);
            if (((GAMModel.GAMParameters)GAM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GAMModel.GAMParameters)GAM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
                ((GAMModel.GAMModelOutput)model._output)._coefficients_table = model.genCoefficientTableMultinomial(new String[]{"Coefficients", "Standardized Coefficients"}, ((GAMModel.GAMModelOutput)model._output)._model_beta_multinomial, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial, ((GAMModel.GAMModelOutput)model._output)._coefficient_names, "GAM Coefficients");
                ((GAMModel.GAMModelOutput)model._output)._coefficients_table_no_centering = model.genCoefficientTableMultinomial(new String[]{"coefficients no centering", "standardized coefficients no centering"}, ((GAMModel.GAMModelOutput)model._output)._model_beta_multinomial_no_centering, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial_no_centering, ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering, "GAM Coefficients No Centering");
                ((GAMModel.GAMModelOutput)model._output)._standardized_coefficient_magnitudes = model.genCoefficientMagTableMultinomial(new String[]{"coefficients", "signs"}, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial, ((GAMModel.GAMModelOutput)model._output)._coefficient_names, "standardized coefficients magnitude");
            } else {
                ((GAMModel.GAMModelOutput)model._output)._coefficients_table = model.genCoefficientTable(new String[]{"coefficients", "standardized coefficients"}, ((GAMModel.GAMModelOutput)model._output)._model_beta, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta, ((GAMModel.GAMModelOutput)model._output)._coefficient_names, "GAM Coefficients");
                ((GAMModel.GAMModelOutput)model._output)._coefficients_table_no_centering = model.genCoefficientTable(new String[]{"coefficients no centering", "standardized coefficients no centering"}, ((GAMModel.GAMModelOutput)model._output)._model_beta_no_centering, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_no_centering, ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering, "GAM Coefficients No Centering");
                ((GAMModel.GAMModelOutput)model._output)._standardized_coefficient_magnitudes = model.genCoefficientMagTable(new String[]{"coefficients", "signs"}, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta, ((GAMModel.GAMModelOutput)model._output)._coefficient_names, "standardized coefficients magnitude");
            }
            if (((GAMModel.GAMParameters)GAM.this._parms)._compute_p_values) {
                ((GAMModel.GAMModelOutput)model._output)._glm_zvalues = (double[])((GLMModel.GLMOutput)glmModel._output).zValues().clone();
                ((GAMModel.GAMModelOutput)model._output)._glm_pvalues = (double[])((GLMModel.GLMOutput)glmModel._output).pValues().clone();
                ((GAMModel.GAMModelOutput)model._output)._glm_stdErr = (double[])((GLMModel.GLMOutput)glmModel._output).stdErr().clone();
                ((GAMModel.GAMModelOutput)model._output)._glm_vcov = (double[][])((GLMModel.GLMOutput)glmModel._output).vcov().clone();
            }
            ((GAMModel.GAMModelOutput)model._output)._glm_dispersion = ((GLMModel.GLMOutput)glmModel._output).dispersion();
            model._nobs = glmModel._nobs;
            model._nullDOF = glmModel._nullDOF;
            model._ymu = new double[glmModel._ymu.length];
            model._rank = ((GLMModel.GLMOutput)glmModel._output).bestSubmodel().rank();
            model._ymu = new double[glmModel._ymu.length];
            System.arraycopy(glmModel._ymu, 0, model._ymu, 0, glmModel._ymu.length);
            if (model.evalAutoParamsEnabled && ((GAMModel.GAMParameters)model._parms)._solver == GLMModel.GLMParameters.Solver.AUTO) {
                ((GAMModel.GAMParameters)model._parms)._solver = ((GLMModel.GLMParameters)glmModel._parms)._solver;
            }
            ((GAMModel.GAMModelOutput)model._output)._varimp = new VarImp(((GLMModel.GLMOutput)glmModel._output)._varimp._varimp, ((GLMModel.GLMOutput)glmModel._output)._varimp._names);
            ((GAMModel.GAMModelOutput)model._output)._variable_importances = ModelMetrics.calcVarImp((VarImp)((GAMModel.GAMModelOutput)model._output)._varimp);
        }

        void copyGLMCoeffs(GLMModel glm, GAMModel model) {
            boolean multiClass = ((GAMModel.GAMParameters)GAM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GAMModel.GAMParameters)GAM.this._parms)._family == GLMModel.GLMParameters.Family.ordinal;
            int totCoefNumsNoCenter = (multiClass ? glm.coefficients().size() / GAM.this.nclasses() : glm.coefficients().size()) + ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering = new String[totCoefNumsNoCenter];
            int gamNumStart = GamUtils.copyGLMCoeffNames2GAMCoeffNames(model, glm);
            GamUtils.copyGLMCoeffs2GAMCoeffs(model, glm, ((GAMModel.GAMParameters)GAM.this._parms)._family, gamNumStart, GAM.this._nclass);
            int glmCoeffLen = ((GLMModel.GLMOutput)glm._output)._coefficient_names.length;
            ((GAMModel.GAMModelOutput)model._output)._coefficient_names = new String[glmCoeffLen];
            System.arraycopy(((GLMModel.GLMOutput)glm._output)._coefficient_names, 0, ((GAMModel.GAMModelOutput)model._output)._coefficient_names, 0, glmCoeffLen);
            if (multiClass) {
                double[][] model_beta_multinomial = ((GLMModel.GLMOutput)glm._output).get_global_beta_multinomial();
                double[][] standardized_model_beta_multinomial = ((GLMModel.GLMOutput)glm._output).getNormBetaMultinomial();
                ((GAMModel.GAMModelOutput)model._output)._model_beta_multinomial = new double[GAM.this._nclass][glmCoeffLen];
                ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial = new double[GAM.this._nclass][glmCoeffLen];
                for (int classInd = 0; classInd < GAM.this._nclass; ++classInd) {
                    System.arraycopy(model_beta_multinomial[classInd], 0, ((GAMModel.GAMModelOutput)model._output)._model_beta_multinomial[classInd], 0, glmCoeffLen);
                    System.arraycopy(standardized_model_beta_multinomial[classInd], 0, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial[classInd], 0, glmCoeffLen);
                }
            } else {
                ((GAMModel.GAMModelOutput)model._output)._model_beta = new double[glmCoeffLen];
                ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta = new double[glmCoeffLen];
                System.arraycopy(((GLMModel.GLMOutput)glm._output).beta(), 0, ((GAMModel.GAMModelOutput)model._output)._model_beta, 0, glmCoeffLen);
                System.arraycopy(((GLMModel.GLMOutput)glm._output).getNormBeta(), 0, ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta, 0, glmCoeffLen);
            }
        }
    }
}

