/*
 * Decompiled with CFR 0.152.
 */
package hex.gam;

import hex.Model;
import hex.ModelMojoWriter;
import hex.gam.GAMModel;
import hex.glm.GLMModel;
import java.io.IOException;

public class GAMMojoWriter
extends ModelMojoWriter<GAMModel, GAMModel.GAMParameters, GAMModel.GAMModelOutput> {
    public String mojoVersion() {
        return "1.00";
    }

    public GAMMojoWriter() {
    }

    public GAMMojoWriter(GAMModel model) {
        super((Model)model);
    }

    protected void writeModelData() throws IOException {
        int numGamCols = ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._gam_columns.length;
        this.writekv("use_all_factor_levels", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._use_all_factor_levels);
        this.writekv("cats", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo._cats);
        this.writekv("cat_offsets", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo._catOffsets);
        this.writekv("numsCenter", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo._nums);
        this.writekv("num", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo._nums + numGamCols);
        boolean imputeMeans = ((GAMModel.GAMParameters)((GAMModel)this.model)._parms).missingValuesHandling().equals((Object)GLMModel.GLMParameters.MissingValuesHandling.MeanImputation);
        this.writekv("mean_imputation", imputeMeans);
        if (imputeMeans) {
            this.writekv("numNAFillsCenter", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo.numNAFill());
            double[] numNAFills = new double[((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo.numNAFill().length + numGamCols];
            System.arraycopy(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo.numNAFill(), 0, numNAFills, 0, ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo.numNAFill().length);
            int startind = numNAFills.length - ((GAMModel)this.model)._gamColMeans.length;
            System.arraycopy(((GAMModel)this.model)._gamColMeans, 0, numNAFills, startind, ((GAMModel)this.model)._gamColMeans.length);
            this.writekv("numNAFills", numNAFills);
            this.writekv("catNAFills", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo.catNAFill());
        }
        if (((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._family.equals((Object)GLMModel.GLMParameters.Family.binomial)) {
            this.writekv("family", "bernoulli");
        } else {
            this.writekv("family", (Object)((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._family);
        }
        this.writekv("link", (Object)((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._link);
        if (((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._family.equals((Object)GLMModel.GLMParameters.Family.tweedie)) {
            this.writekv("tweedie_link_power", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._tweedie_link_power);
        }
        this.writekv("num_knots", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._num_knots);
        this.writeStringArrays(((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._gam_columns, "gam_columns");
        int numGamLength = 0;
        int numGamCLength = 0;
        for (int cInd = 0; cInd < numGamCols; ++cInd) {
            this.writeStringArrays(((GAMModel)this.model)._gamColNames[cInd], "gamColNamesCenter_" + ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._gam_columns[cInd]);
            this.writeStringArrays(((GAMModel)this.model)._gamColNamesNoCentering[cInd], "gamColNames_" + ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._gam_columns[cInd]);
            numGamLength += ((GAMModel)this.model)._gamColNamesNoCentering[cInd].length;
            numGamCLength += ((GAMModel)this.model)._gamColNames[cInd].length;
        }
        String[] trainColGamColNoCenter = this.genTrainColGamCols(numGamLength, numGamCLength);
        this.writekv("num_expanded_gam_columns", numGamLength);
        this.writeStringArrays(trainColGamColNoCenter, "_names_no_centering");
        this.writekv("total feature size", trainColGamColNoCenter.length);
        if (((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
            this.writeDoubleArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta_multinomial_no_centering, "beta_multinomial");
            this.writekv("beta length per class", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta_multinomial_no_centering[0].length);
            this.writeDoubleArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta_multinomial, "beta_multinomial_centering");
            this.writekv("beta center length per class", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta_multinomial[0].length);
        } else {
            this.writekv("beta", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta_no_centering);
            this.writekv("beta length per class", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta_no_centering.length);
            this.writekv("beta_center", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta);
            this.writekv("beta center length per class", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta.length);
        }
        this.writekv("bs", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._bs);
        this.writeDoubleArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._knots, "knots");
        int countGamCols = 0;
        for (String gamCol : ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._gam_columns) {
            this.writeDoubleArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._zTranspose[countGamCols], gamCol + "_zTranspose");
            this.writeDoubleArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._binvD[countGamCols++], gamCol + "_binvD");
        }
    }

    public String[] genTrainColGamCols(int gamColLength, int gamCColLength) {
        int colLength = ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._names.length - gamCColLength + gamColLength - 1;
        int normalColLength = ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._names.length - gamCColLength - 1;
        String[] trainNamesNGamNames = new String[colLength];
        System.arraycopy(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._names, 0, trainNamesNGamNames, 0, normalColLength);
        int startInd = normalColLength;
        for (int gind = 0; gind < ((GAMModel)this.model)._gamColNamesNoCentering.length; ++gind) {
            int copyLen = ((GAMModel)this.model)._gamColNamesNoCentering[gind].length;
            System.arraycopy(((GAMModel)this.model)._gamColNamesNoCentering[gind], 0, trainNamesNGamNames, startInd, copyLen);
            startInd += copyLen;
        }
        return trainNamesNGamNames;
    }
}

