/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.MatrixFrameUtils;

import hex.Model;
import hex.gam.GAMModel;
import hex.glm.GLMModel;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import water.DKV;
import water.Key;
import water.MemoryManager;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class GamUtils {
    public static double[][][] allocate3DArray(int num2DArrays, GAMModel.GAMParameters parms, AllocateType fileMode) {
        double[][][] array3D = new double[num2DArrays][][];
        block6: for (int frameIdx = 0; frameIdx < num2DArrays; ++frameIdx) {
            int numKnots = parms._num_knots[frameIdx];
            switch (fileMode) {
                case firstOneLess: {
                    array3D[frameIdx] = MemoryManager.malloc8d((int)(numKnots - 1), (int)numKnots);
                    continue block6;
                }
                case sameOrig: {
                    array3D[frameIdx] = MemoryManager.malloc8d((int)numKnots, (int)numKnots);
                    continue block6;
                }
                case bothOneLess: {
                    array3D[frameIdx] = MemoryManager.malloc8d((int)(numKnots - 1), (int)(numKnots - 1));
                    continue block6;
                }
                case firstTwoLess: {
                    array3D[frameIdx] = MemoryManager.malloc8d((int)(numKnots - 2), (int)numKnots);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("fileMode can only be firstOneLess, sameOrig, bothOneLess or firstTwoLess.");
                }
            }
        }
        return array3D;
    }

    public static Integer[] sortCoeffMags(int arrayLength, final double[] coeffMags) {
        Integer[] indices = new Integer[arrayLength];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        Arrays.sort(indices, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (coeffMags[o1] < coeffMags[o2]) {
                    return 1;
                }
                if (coeffMags[o1] > coeffMags[o2]) {
                    return -1;
                }
                return 0;
            }
        });
        return indices;
    }

    public static boolean equalColNames(String[] name1, String[] standardN, String response_column) {
        boolean equalNames;
        boolean name1ContainsResp = ArrayUtils.contains((Object[])name1, (Object)response_column);
        boolean standarNContainsResp = ArrayUtils.contains((Object[])standardN, (Object)response_column);
        boolean bl = equalNames = name1.length == standardN.length;
        if (name1ContainsResp && !standarNContainsResp) {
            equalNames = name1.length == standardN.length + 1;
        } else if (!name1ContainsResp && standarNContainsResp) {
            boolean bl2 = equalNames = name1.length + 1 == standardN.length;
        }
        if (equalNames) {
            for (String name : name1) {
                if (name == response_column || ArrayUtils.contains((Object[])standardN, (Object)name)) continue;
                return false;
            }
            return true;
        }
        return equalNames;
    }

    public static void copy2DArray(double[][] src_array, double[][] dest_array) {
        int numRows = src_array.length;
        for (int colIdx = 0; colIdx < numRows; ++colIdx) {
            System.arraycopy(src_array[colIdx], 0, dest_array[colIdx], 0, src_array[colIdx].length);
        }
    }

    public static GLMModel.GLMParameters copyGAMParams2GLMParams(GAMModel.GAMParameters parms, Frame trainData, Frame valid) {
        GLMModel.GLMParameters glmParam = new GLMModel.GLMParameters();
        Field[] field1 = GAMModel.GAMParameters.class.getDeclaredFields();
        GamUtils.setParamField(parms, glmParam, false, field1);
        Field[] field2 = Model.Parameters.class.getDeclaredFields();
        GamUtils.setParamField(parms, glmParam, true, field2);
        glmParam._train = trainData._key;
        glmParam._valid = valid == null ? null : valid._key;
        glmParam._nfolds = 0;
        glmParam._fold_assignment = Model.Parameters.FoldAssignmentScheme.AUTO;
        glmParam._keep_cross_validation_fold_assignment = false;
        glmParam._keep_cross_validation_models = false;
        glmParam._keep_cross_validation_predictions = false;
        glmParam._is_cv_model = false;
        return glmParam;
    }

    public static void setParamField(GAMModel.GAMParameters parms, GLMModel.GLMParameters glmParam, boolean superClassParams, Field[] gamFields) {
        List<String> gamOnlyList = Arrays.asList("_num_knots", "_gam_columns", "_bs", "_scale", "_train", "_saveZMatrix", "_saveGamCols", "_savePenaltyMat");
        for (Field oneField : gamFields) {
            try {
                if (gamOnlyList.contains(oneField.getName())) continue;
                Field glmField = superClassParams ? ((Object)((Object)glmParam)).getClass().getSuperclass().getDeclaredField(oneField.getName()) : ((Object)((Object)glmParam)).getClass().getDeclaredField(oneField.getName());
                glmField.set((Object)glmParam, oneField.get((Object)parms));
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public static void copyGLMCoeffs2GAMCoeffs(GAMModel model, GLMModel glm, GLMModel.GLMParameters.Family family, int gamNumStart, int nclass) {
        int numCoeffPerClass = ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering.length;
        if (family.equals((Object)GLMModel.GLMParameters.Family.multinomial) || family.equals((Object)GLMModel.GLMParameters.Family.ordinal)) {
            double[][] model_beta_multinomial = ((GLMModel.GLMOutput)glm._output).get_global_beta_multinomial();
            double[][] standardized_model_beta_multinomial = ((GLMModel.GLMOutput)glm._output).getNormBetaMultinomial();
            ((GAMModel.GAMModelOutput)model._output)._model_beta_multinomial_no_centering = new double[nclass][];
            ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial_no_centering = new double[nclass][];
            for (int classInd = 0; classInd < nclass; ++classInd) {
                ((GAMModel.GAMModelOutput)model._output)._model_beta_multinomial_no_centering[classInd] = GamUtils.convertCenterBeta2Beta(((GAMModel.GAMModelOutput)model._output)._zTranspose, gamNumStart, model_beta_multinomial[classInd], numCoeffPerClass);
                ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_multinomial_no_centering[classInd] = GamUtils.convertCenterBeta2Beta(((GAMModel.GAMModelOutput)model._output)._zTranspose, gamNumStart, standardized_model_beta_multinomial[classInd], numCoeffPerClass);
            }
        } else {
            ((GAMModel.GAMModelOutput)model._output)._model_beta_no_centering = GamUtils.convertCenterBeta2Beta(((GAMModel.GAMModelOutput)model._output)._zTranspose, gamNumStart, glm.beta(), numCoeffPerClass);
            ((GAMModel.GAMModelOutput)model._output)._standardized_model_beta_no_centering = GamUtils.convertCenterBeta2Beta(((GAMModel.GAMModelOutput)model._output)._zTranspose, gamNumStart, ((GLMModel.GLMOutput)glm._output).getNormBeta(), numCoeffPerClass);
        }
    }

    public static double[] convertCenterBeta2Beta(double[][][] ztranspose, int gamNumStart, double[] centerBeta, int betaSize) {
        double[] originalBeta = new double[betaSize];
        if (ztranspose != null) {
            int numGamCols = ztranspose.length;
            int gamColStart = gamNumStart;
            int origGamColStart = gamNumStart;
            System.arraycopy(centerBeta, 0, originalBeta, 0, gamColStart);
            for (int colInd = 0; colInd < numGamCols; ++colInd) {
                double[] tempCbeta = new double[ztranspose[colInd].length];
                System.arraycopy(centerBeta, gamColStart, tempCbeta, 0, tempCbeta.length);
                double[] tempBeta = ArrayUtils.multVecArr((double[])tempCbeta, (double[][])ztranspose[colInd]);
                System.arraycopy(tempBeta, 0, originalBeta, origGamColStart, tempBeta.length);
                gamColStart += tempCbeta.length;
                origGamColStart += tempBeta.length;
            }
            originalBeta[betaSize - 1] = centerBeta[centerBeta.length - 1];
        } else {
            System.arraycopy(centerBeta, 0, originalBeta, 0, betaSize);
        }
        return originalBeta;
    }

    public static int copyGLMCoeffNames2GAMCoeffNames(GAMModel model, GLMModel glm) {
        int gamNumColStart;
        int numGamCols = model._gamColNamesNoCentering.length;
        Object[] glmColNames = ((GLMModel.GLMOutput)glm._output).coefficientNames();
        int lastGLMCoeffIndex = glmColNames.length - 1;
        int lastGAMCoeffIndex = lastGLMCoeffIndex + numGamCols;
        int gamLengthCopied = gamNumColStart = ArrayUtils.find((Object[])glmColNames, (Object)model._gamColNames[0][0]);
        System.arraycopy(glmColNames, 0, ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering, 0, gamLengthCopied);
        for (int gamColInd = 0; gamColInd < numGamCols; ++gamColInd) {
            System.arraycopy(model._gamColNamesNoCentering[gamColInd], 0, ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering, gamLengthCopied, model._gamColNamesNoCentering[gamColInd].length);
            gamLengthCopied += model._gamColNamesNoCentering[gamColInd].length;
        }
        ((GAMModel.GAMModelOutput)model._output)._coefficient_names_no_centering[lastGAMCoeffIndex] = new String((String)glmColNames[lastGLMCoeffIndex]);
        return gamNumColStart;
    }

    public static void keepFrameKeys(List<Key<Vec>> keep, Key<Frame> ... keyNames) {
        for (Key<Frame> keyName : keyNames) {
            Frame loadingFrm = (Frame)DKV.getGet(keyName);
            if (loadingFrm == null) continue;
            for (Vec vec : loadingFrm.vecs()) {
                keep.add((Key<Vec>)vec._key);
            }
        }
    }

    public static enum AllocateType {
        firstOneLess,
        sameOrig,
        bothOneLess,
        firstTwoLess;

    }
}

