/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.kmeans.SpanningTree;
import water.MRTask;
import water.fvec.Chunk;

class FindMinimalWeightTask
extends MRTask<FindMinimalWeightTask> {
    private SpanningTree _tree;
    private boolean _hasWeightsColumn;
    private int _constraintsLength;
    double minimalWeight = Double.MAX_VALUE;
    long minimalIndex = -1L;

    FindMinimalWeightTask(SpanningTree tree, boolean hasWeightsColumn, int constraintsLength) {
        this._tree = tree;
        this._hasWeightsColumn = hasWeightsColumn;
        this._constraintsLength = constraintsLength;
    }

    public void map(Chunk[] cs) {
        int startDistancesIndex = cs.length - 2 * this._constraintsLength - 3;
        int startEdgeIndex = cs.length - 3 - this._constraintsLength;
        for (int i = 0; i < cs[0]._len; ++i) {
            for (int j = 0; j < this._constraintsLength; ++j) {
                boolean countValue;
                double weight = cs[startDistancesIndex + j].atd(i);
                long edgeIndex = cs[startEdgeIndex + j].at8(i);
                double tmpWeight = this._tree.reduceWeight(edgeIndex, weight);
                boolean bl = countValue = !this._hasWeightsColumn || cs[startDistancesIndex - 1].at8(i) == 1L;
                if (!countValue || !(tmpWeight < this.minimalWeight)) continue;
                this.minimalWeight = tmpWeight;
                this.minimalIndex = edgeIndex;
            }
        }
    }

    public void reduce(FindMinimalWeightTask mrt) {
        if (mrt.minimalWeight < this.minimalWeight) {
            this.minimalIndex = mrt.minimalIndex;
            this.minimalWeight = mrt.minimalWeight;
        }
    }
}

