/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm;

import hex.genmodel.algos.psvm.KernelParameters;
import hex.genmodel.utils.ByteBufferWrapper;
import hex.psvm.BulkSupportVectorScorer;
import org.apache.commons.math3.util.FastMath;
import water.fvec.Chunk;

class GaussianScorerRawBytes
implements BulkSupportVectorScorer {
    private final double _gamma;
    private final byte[] _svs;

    GaussianScorerRawBytes(KernelParameters parms, byte[] svs) {
        this(parms._gamma, svs);
    }

    private GaussianScorerRawBytes(double gamma, byte[] svs) {
        this._gamma = gamma;
        this._svs = svs;
    }

    @Override
    public double[] bulkScore0(Chunk[] cs) {
        double[] result = new double[cs[0]._len];
        double[] norms = new double[cs[0]._len];
        ByteBufferWrapper bb = new ByteBufferWrapper(this._svs);
        while (bb.hasRemaining()) {
            double alpha = bb.get8d();
            int cats = bb.get4();
            for (int i = 0; i < cats; ++i) {
                int svCat = bb.get4();
                for (int j = 0; j < norms.length; ++j) {
                    int n = j;
                    norms[n] = norms[n] + ((int)cs[i].at8(j) == svCat ? 0.0 : 2.0);
                }
            }
            int nums = bb.get4();
            for (int i = 0; i < nums; ++i) {
                double svNum = bb.get8d();
                int j = 0;
                while (j < norms.length) {
                    double v = cs[i + cats].atd(j) - svNum;
                    int n = j++;
                    norms[n] = norms[n] + v * v;
                }
            }
            for (int j = 0; j < result.length; ++j) {
                int n = j;
                result[n] = result[n] + alpha * FastMath.exp((double)(-this._gamma * norms[j]));
                norms[j] = 0.0;
            }
        }
        return result;
    }
}

