/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm.psvm;

import hex.DataInfo;
import hex.genmodel.algos.psvm.KernelParameters;
import hex.psvm.psvm.Kernel;
import water.Iced;

final class GaussianKernel
extends Iced
implements Kernel {
    private final double _rbf_gamma;

    GaussianKernel(KernelParameters parms) {
        this(parms._gamma);
    }

    GaussianKernel(double rbf_gamma) {
        this._rbf_gamma = rbf_gamma;
    }

    @Override
    public double calcKernel(DataInfo.Row a, DataInfo.Row b) {
        double norm_a_b_sq = a.response[1] + b.response[1] - 2.0 * a.innerProduct(b);
        return Math.exp(-this._rbf_gamma * norm_a_b_sq);
    }

    @Override
    public double calcKernelWithLabel(DataInfo.Row a, DataInfo.Row b) {
        if ((int)a.response[0] != (int)b.response[0]) {
            return -this.calcKernel(a, b);
        }
        return this.calcKernel(a, b);
    }
}

