/*
 * Decompiled with CFR 0.152.
 */
package hex.rulefit;

import hex.rulefit.Rule;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import water.Iced;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;

public class RuleEnsemble
extends Iced {
    Rule[] rules;

    public RuleEnsemble(Rule[] rules) {
        this.rules = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame createGLMTrainFrame(Frame frame, int depth, int ntrees) {
        Frame glmTrainFrame = new Frame(new Vec[0]);
        for (int i = 0; i < depth; ++i) {
            for (int j = 0; j < ntrees; ++j) {
                String regex = "M" + i + "T" + j + "N\\d+";
                List<Rule> filteredRules = Arrays.asList(this.rules).stream().filter(rule -> rule.varName.matches(regex)).collect(Collectors.toList());
                RuleEnsemble ruleEnsemble = new RuleEnsemble(filteredRules.toArray(new Rule[0]));
                Frame frameToMakeCategorical = ruleEnsemble.transform(frame);
                try {
                    Decoder mrtask = new Decoder();
                    Vec catCol = ((Decoder)mrtask.doAll(1, (byte)4, frameToMakeCategorical)).outputFrame(null, null, new String[][]{frameToMakeCategorical.names()}).vec(0);
                    glmTrainFrame.add("M" + i + "T" + j, catCol);
                    continue;
                }
                finally {
                    frameToMakeCategorical.remove();
                }
            }
        }
        return glmTrainFrame;
    }

    public Frame transform(Frame frame) {
        RuleEnsembleConverter rc = new RuleEnsembleConverter(new String[this.rules.length]);
        Frame transformedFrame = ((RuleEnsembleConverter)rc.doAll(this.rules.length, (byte)3, frame)).outputFrame();
        transformedFrame.setNames(rc._names);
        return transformedFrame;
    }

    public Rule getRuleByVarName(String code) {
        List filteredRule = Arrays.stream(this.rules).filter(rule -> code.equals(String.valueOf(rule.varName))).collect(Collectors.toList());
        if (filteredRule.size() == 1) {
            return (Rule)((Object)filteredRule.get(0));
        }
        if (filteredRule.size() > 1) {
            throw new RuntimeException("Multiple rules with the same varName in RuleEnsemble!");
        }
        throw new RuntimeException("No rule with varName " + code + " found!");
    }

    static class Decoder
    extends MRTask<Decoder> {
        Decoder() {
        }

        public void map(Chunk[] cs, NewChunk[] ncs) {
            int newValue = -1;
            for (int iRow = 0; iRow < cs[0].len(); ++iRow) {
                for (int iCol = 0; iCol < cs.length; ++iCol) {
                    if (cs[iCol].at8(iRow) != 1L) continue;
                    newValue = iCol;
                }
                if (newValue >= 0) {
                    ncs[0].addNum((double)newValue);
                    continue;
                }
                ncs[0].addNA();
            }
        }
    }

    class RuleEnsembleConverter
    extends MRTask<RuleEnsembleConverter> {
        String[] _names;

        RuleEnsembleConverter(String[] names) {
            this._names = names;
        }

        public void map(Chunk[] cs, NewChunk[] nc) {
            byte[] out = MemoryManager.malloc1((int)cs[0].len());
            for (int i = 0; i < RuleEnsemble.this.rules.length; ++i) {
                Arrays.fill(out, (byte)1);
                RuleEnsemble.this.rules[i].map(cs, out);
                this._names[i] = RuleEnsemble.this.rules[i].varName;
                for (byte b : out) {
                    nc[i].addNum((double)b);
                }
            }
        }
    }
}

