/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.CompressedTree;
import water.DKV;
import water.Iced;
import water.Key;

public class CompressedForest
extends Iced<CompressedTree> {
    public final Key<CompressedTree>[][] _treeKeys;
    public final String[][] _domains;

    CompressedForest(Key<CompressedTree>[][] treeKeys, String[][] domains) {
        this._treeKeys = treeKeys;
        this._domains = domains;
    }

    public final int ntrees() {
        return this._treeKeys.length;
    }

    public final LocalCompressedForest fetch() {
        int ntrees = this._treeKeys.length;
        CompressedTree[][] trees = new CompressedTree[ntrees][];
        for (int t = 0; t < ntrees; ++t) {
            Key<CompressedTree>[] treek = this._treeKeys[t];
            trees[t] = new CompressedTree[treek.length];
            for (int i = 0; i < treek.length; ++i) {
                if (treek[i] == null) continue;
                trees[t][i] = (CompressedTree)DKV.get(treek[i]).get();
            }
        }
        return new LocalCompressedForest(trees, this._domains);
    }

    public static class LocalCompressedForest {
        public CompressedTree[][] _trees;
        public String[][] _domains;

        private LocalCompressedForest(CompressedTree[][] trees, String[][] domains) {
            this._trees = trees;
            this._domains = domains;
        }

        public final void scoreTree(double[] data, double[] preds, int tidx) {
            CompressedTree[] ts = this._trees[tidx];
            for (int c = 0; c < ts.length; ++c) {
                if (ts[c] == null) continue;
                int n = ts.length == 1 ? 0 : c + 1;
                preds[n] = preds[n] + ts[c].score(data, this._domains);
            }
        }
    }
}

