/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.genmodel.utils.DistributionFamily;
import hex.tree.DHistogram;
import hex.tree.DTree;
import hex.tree.ScoreBuildHistogram;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.CountedCompleter;
import water.H2O;
import water.Iced;
import water.LocalMR;
import water.MemoryManager;
import water.MrFun;
import water.fvec.C4VolatileChunk;
import water.fvec.C8DVolatileChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.IcedBitSet;
import water.util.VecUtils;

public class ScoreBuildHistogram2
extends ScoreBuildHistogram {
    transient int[] _cids;
    transient Chunk[][] _chks;
    transient double[][] _ys;
    transient double[][] _ws;
    transient int[][] _nhs;
    transient int[][] _rss;
    Frame _fr2;
    final int _numLeafs;
    final IcedBitSet _activeCols;
    final int _respIdx;
    final int _predsIdx;

    public ScoreBuildHistogram2(H2O.H2OCountedCompleter cc, int k, int ncols, int nbins, int nbins_cats, DTree tree, int leaf, DHistogram[][] hcs, DistributionFamily family, int respIdx, int weightIdx, int predsIdx, int workIdx, int nidIdxs) {
        super(cc, k, ncols, nbins, nbins_cats, tree, leaf, hcs, family, weightIdx, workIdx, nidIdxs);
        this._numLeafs = this._hcs.length;
        this._respIdx = respIdx;
        this._predsIdx = predsIdx;
        int hcslen = this._hcs.length;
        IcedBitSet activeCols = new IcedBitSet(ncols);
        for (int n = 0; n < hcslen; ++n) {
            int[] acs = this._tree.undecided((int)(n + this._leaf))._scoreCols;
            if (acs != null) {
                for (int c : acs) {
                    activeCols.set(c);
                }
                continue;
            }
            activeCols = null;
            break;
        }
        this._activeCols = activeCols;
        this._hcs = (DHistogram[][])ArrayUtils.transpose((Object[][])this._hcs);
    }

    @Override
    public ScoreBuildHistogram dfork2(byte[] types, Frame fr, boolean run_local) {
        this._fr2 = fr;
        this.dfork(null);
        return this;
    }

    @Override
    public void map(Chunk[] chks) {
        throw H2O.unimpl();
    }

    protected int[] score_decide(Chunk[] chks, int[] nnids) {
        int[] res = (int[])nnids.clone();
        for (int row = 0; row < nnids.length; ++row) {
            int nid = nnids[row];
            if (ScoreBuildHistogram2.isDecidedRow(nid)) {
                int n = row;
                res[n] = res[n] - this._leaf;
                continue;
            }
            boolean oob = ScoreBuildHistogram2.isOOBRow(nid);
            if (oob) {
                nid = ScoreBuildHistogram2.oob2Nid(nid);
            }
            DTree.DecidedNode dn = this._tree.decided(nid);
            if (dn._split == null) {
                int xnid;
                if (DTree.isRootNode(dn)) {
                    res[row] = nid - this._leaf;
                    continue;
                }
                nid = dn._pid;
                nnids[row] = xnid = oob ? ScoreBuildHistogram2.nid2Oob(nid) : nid;
                res[row] = xnid - this._leaf;
                dn = this._tree.decided(nid);
            }
            assert (!ScoreBuildHistogram2.isDecidedRow(nid));
            nid = dn.getChildNodeID(chks, row);
            if (!ScoreBuildHistogram2.isDecidedRow(nid)) {
                if (oob) {
                    nid = ScoreBuildHistogram2.nid2Oob(nid);
                }
                nnids[row] = nid;
            }
            res[row] = nid - this._leaf;
        }
        return res;
    }

    @Override
    public void setupLocal() {
        this.addToPendingCount(1);
        this._tree.init_tree();
        Vec v = this._fr2.anyVec();
        assert (v != null);
        this._cids = VecUtils.getLocalChunkIds((Vec)v);
        this._chks = new Chunk[this._cids.length][this._fr2.numCols()];
        this._ys = new double[this._cids.length][];
        this._ws = new double[this._cids.length][];
        this._nhs = new int[this._cids.length][];
        this._rss = new int[this._cids.length][];
        long[] espc = v.espc();
        int largestChunkSz = 0;
        for (int i = 1; i < espc.length; ++i) {
            int sz = (int)(espc[i] - espc[i - 1]);
            if (sz <= largestChunkSz) continue;
            largestChunkSz = sz;
        }
        final int fLargestChunkSz = largestChunkSz;
        if (this._weightIdx == -1) {
            double[] ws = new double[largestChunkSz];
            Arrays.fill(ws, 1.0);
            Arrays.fill((Object[])this._ws, ws);
        }
        final AtomicInteger cidx = new AtomicInteger(0);
        new LocalMR(new MrFun(){

            private void map(int id, Chunk[] chks) {
                int[] nnids;
                C4VolatileChunk nids = (C4VolatileChunk)chks[ScoreBuildHistogram2.this._nidIdx];
                if (ScoreBuildHistogram2.this._leaf > 0) {
                    nnids = ScoreBuildHistogram2.this.score_decide(chks, nids.getValues());
                } else {
                    nnids = new int[nids._len];
                    int[] is = nids.getValues();
                    for (int row = 0; row < nids._len; ++row) {
                        if (!ScoreBuildHistogram.isDecidedRow(is[row])) continue;
                        nnids[row] = -1;
                    }
                }
                ScoreBuildHistogram2.this._nhs[id] = new int[ScoreBuildHistogram2.this._numLeafs + 1];
                int[] nh = ScoreBuildHistogram2.this._nhs[id];
                for (int i : nnids) {
                    if (i < 0) continue;
                    int n = i + 1;
                    nh[n] = nh[n] + 1;
                }
                for (int i = 0; i < ScoreBuildHistogram2.this._numLeafs; ++i) {
                    int n = i + 1;
                    nh[n] = nh[n] + nh[i];
                }
                ScoreBuildHistogram2.this._rss[id] = new int[nnids.length];
                int[] rows = ScoreBuildHistogram2.this._rss[id];
                for (int row = 0; row < nnids.length; ++row) {
                    if (nnids[row] < 0) continue;
                    int n = nnids[row];
                    int n2 = nh[n];
                    nh[n] = n2 + 1;
                    rows[n2] = row;
                }
            }

            protected void map(int id) {
                Vec[] vecs = ScoreBuildHistogram2.this._fr2.vecs();
                id = cidx.getAndIncrement();
                while (id < ScoreBuildHistogram2.this._cids.length) {
                    int cidx2 = ScoreBuildHistogram2.this._cids[id];
                    Chunk[] chks = ScoreBuildHistogram2.this._chks[id];
                    for (int i = 0; i < chks.length; ++i) {
                        chks[i] = vecs[i].chunkForChunkIdx(cidx2);
                    }
                    this.map(id, chks);
                    chks[ScoreBuildHistogram2.this._nidIdx].close(cidx2, ScoreBuildHistogram2.this._fs);
                    Chunk resChk = chks[ScoreBuildHistogram2.this._workIdx];
                    int len = resChk.len();
                    ScoreBuildHistogram2.this._ys[id] = resChk instanceof C8DVolatileChunk ? ((C8DVolatileChunk)resChk).getValues() : resChk.getDoubles(MemoryManager.malloc8d((int)len), 0, len);
                    if (ScoreBuildHistogram2.this._weightIdx != -1) {
                        ScoreBuildHistogram2.this._ws[id] = chks[ScoreBuildHistogram2.this._weightIdx].getDoubles(MemoryManager.malloc8d((int)len), 0, len);
                    }
                    id = cidx.getAndIncrement();
                }
            }
        }, new H2O.H2OCountedCompleter((H2O.H2OCountedCompleter)this){

            public void onCompletion(CountedCompleter cc) {
                int ncols = ScoreBuildHistogram2.this._ncols;
                final int[] active_cols = ScoreBuildHistogram2.this._activeCols == null ? null : new int[Math.max(1, ScoreBuildHistogram2.this._activeCols.cardinality())];
                int nactive_cols = active_cols == null ? ncols : active_cols.length;
                final int numWrks = ScoreBuildHistogram2.this._hcs.length * nactive_cols < 16384 ? H2O.NUMCPUS : Math.min(H2O.NUMCPUS, Math.max(4 * H2O.NUMCPUS / nactive_cols, 1));
                final int rem = H2O.NUMCPUS - numWrks * ncols;
                ScoreBuildHistogram2.this.addToPendingCount(1 + nactive_cols);
                if (active_cols != null) {
                    int j = 0;
                    for (int i = 0; i < ncols; ++i) {
                        if (!ScoreBuildHistogram2.this._activeCols.contains(i)) continue;
                        active_cols[j++] = i;
                    }
                }
                new LocalMR(new MrFun(){

                    protected void map(int c) {
                        c = active_cols == null ? c : active_cols[c];
                        new LocalMR((MrFun)new ComputeHistoThread(ScoreBuildHistogram2.this._hcs.length == 0 ? new DHistogram[]{} : ScoreBuildHistogram2.this._hcs[c], c, fLargestChunkSz, new AtomicInteger()), numWrks + (c < rem ? 1 : 0), (H2O.H2OCountedCompleter)ScoreBuildHistogram2.this).fork();
                    }
                }, nactive_cols, (H2O.H2OCountedCompleter)ScoreBuildHistogram2.this).fork();
            }
        }).fork();
    }

    private static void mergeHistos(DHistogram[] hcs, DHistogram[] hcs2) {
        for (int i = 0; i < hcs.length; ++i) {
            DHistogram hs1 = hcs[i];
            DHistogram hs2 = hcs2[i];
            if (hs1 == null) {
                hcs[i] = hs2;
                continue;
            }
            if (hs2 == null) continue;
            hs1.add(hs2);
        }
    }

    public void postGlobal() {
        DHistogram[][] dHistogramArray = this._hcs = (DHistogram[][])ArrayUtils.transpose((Object[][])this._hcs);
        int n = dHistogramArray.length;
        for (int i = 0; i < n; ++i) {
            DHistogram[] ary;
            for (DHistogram dh : ary = dHistogramArray[i]) {
                if (dh == null) continue;
                dh.reducePrecision();
            }
        }
    }

    private class ComputeHistoThread
    extends MrFun<ComputeHistoThread> {
        final int _maxChunkSz;
        final int _col;
        final DHistogram[] _lh;
        AtomicInteger _cidx;
        private boolean _done;

        public boolean isDone() {
            return this._done || (this._done = this._cidx.get() >= ScoreBuildHistogram2.this._cids.length);
        }

        ComputeHistoThread(DHistogram[] hcs, int col, int maxChunkSz, AtomicInteger cidx) {
            this._lh = hcs;
            this._col = col;
            this._maxChunkSz = maxChunkSz;
            this._cidx = cidx;
        }

        public ComputeHistoThread makeCopy() {
            return new ComputeHistoThread((DHistogram[])ArrayUtils.deepClone((Iced[])this._lh), this._col, this._maxChunkSz, this._cidx);
        }

        protected void map(int id) {
            double[] cs = null;
            double[] resp = null;
            double[] preds = null;
            int i = this._cidx.getAndIncrement();
            while (i < ScoreBuildHistogram2.this._cids.length) {
                if (cs == null) {
                    cs = MemoryManager.malloc8d((int)this._maxChunkSz);
                    if (ScoreBuildHistogram2.this._respIdx >= 0) {
                        resp = MemoryManager.malloc8d((int)this._maxChunkSz);
                    }
                    if (ScoreBuildHistogram2.this._predsIdx >= 0) {
                        preds = MemoryManager.malloc8d((int)this._maxChunkSz);
                    }
                }
                this.computeChunk(i, cs, ScoreBuildHistogram2.this._ws[i], resp, preds);
                i = this._cidx.getAndIncrement();
            }
        }

        private void computeChunk(int id, double[] cs, double[] ws, double[] resp, double[] preds) {
            int[] nh = ScoreBuildHistogram2.this._nhs[id];
            int[] rs = ScoreBuildHistogram2.this._rss[id];
            Chunk resChk = ScoreBuildHistogram2.this._chks[id][ScoreBuildHistogram2.this._workIdx];
            int len = resChk._len;
            double[] ys = ScoreBuildHistogram2.this._ys[id];
            if (ScoreBuildHistogram2.this._weightIdx != -1) {
                ScoreBuildHistogram2.this._chks[id][ScoreBuildHistogram2.this._weightIdx].getDoubles(ws, 0, len);
            }
            int hcslen = this._lh.length;
            boolean extracted = false;
            for (int n = 0; n < hcslen; ++n) {
                int lo;
                int[] sCols = ScoreBuildHistogram2.this._tree.undecided((int)(n + ScoreBuildHistogram2.this._leaf))._scoreCols;
                if (sCols != null && ArrayUtils.find((int[])sCols, (int)this._col) < 0) continue;
                DHistogram h = this._lh[n];
                int hi = nh[n];
                int n2 = lo = n == 0 ? 0 : nh[n - 1];
                if (hi == lo || h == null) continue;
                if (h._vals == null) {
                    h.init();
                }
                if (!extracted) {
                    ScoreBuildHistogram2.this._chks[id][this._col].getDoubles(cs, 0, len);
                    if (h._vals_dim >= 6) {
                        ScoreBuildHistogram2.this._chks[id][ScoreBuildHistogram2.this._respIdx].getDoubles(resp, 0, len);
                        if (h._vals_dim == 7) {
                            ScoreBuildHistogram2.this._chks[id][ScoreBuildHistogram2.this._predsIdx].getDoubles(preds, 0, len);
                        }
                    }
                    extracted = true;
                }
                h.updateHisto(ws, resp, cs, ys, preds, rs, hi, lo);
            }
        }

        protected void reduce(ComputeHistoThread cc) {
            assert (this._lh != cc._lh);
            ScoreBuildHistogram2.mergeHistos(this._lh, cc._lh);
        }
    }
}

