/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.KeyValue;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.tree.SharedTreeModel;
import java.util.HashSet;
import water.fvec.Frame;
import water.fvec.Vec;

public class TreeUtils {
    public static void checkMonotoneConstraints(ModelBuilder<?, ?, ?> mb, Frame train, KeyValue[] constraints) {
        HashSet<String> constrained = new HashSet<String>();
        for (KeyValue constraint : constraints) {
            if (constrained.contains(constraint.getKey())) {
                mb.error("_monotone_constraints", "Feature '" + constraint.getKey() + "' has multiple constraints.");
                continue;
            }
            constrained.add(constraint.getKey());
            Vec v = train.vec(constraint.getKey());
            if (v == null) {
                mb.error("_monotone_constraints", "Invalid constraint - there is no column '" + constraint.getKey() + "' in the training frame.");
                continue;
            }
            if (v.get_type() == 3) continue;
            mb.error("_monotone_constraints", "Invalid constraint - column '" + constraint.getKey() + "' has type " + v.get_type_str() + ". Only numeric columns can have monotonic constraints.");
        }
    }

    public static int getResponseLevelIndex(String categorical, SharedTreeModel.SharedTreeOutput sharedTreeOutput) {
        String trimmedCategorical;
        String string = trimmedCategorical = categorical != null ? categorical.trim() : "";
        if (!sharedTreeOutput.isClassifier()) {
            if (!trimmedCategorical.isEmpty()) {
                throw new IllegalArgumentException("There are no tree classes for " + sharedTreeOutput.getModelCategory() + ".");
            }
            return 0;
        }
        String[] responseColumnDomain = sharedTreeOutput._domains[sharedTreeOutput.responseIdx()];
        if (sharedTreeOutput.getModelCategory() == ModelCategory.Binomial) {
            if (!trimmedCategorical.isEmpty() && !trimmedCategorical.equals(responseColumnDomain[0])) {
                throw new IllegalArgumentException("For binomial, only one tree class has been built per each iteration: " + responseColumnDomain[0]);
            }
            return 0;
        }
        for (int i = 0; i < responseColumnDomain.length; ++i) {
            if (!trimmedCategorical.equals(responseColumnDomain[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("There is no such tree class. Given categorical level does not exist in response column: " + trimmedCategorical);
    }
}

