/*
 * Decompiled with CFR 0.152.
 */
package hex.gam;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.gam.GAMModel;
import hex.gam.GamSplines.ThinPlateDistanceWithKnots;
import hex.gam.GamSplines.ThinPlatePolynomialWithKnots;
import hex.gam.GamSplines.ThinPlateRegressionUtils;
import hex.gam.MatrixFrameUtils.GAMModelUtils;
import hex.gam.MatrixFrameUtils.GamUtils;
import hex.gam.MatrixFrameUtils.GenerateGamMatrixOneColumn;
import hex.genmodel.utils.ArrayUtils;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.gram.Gram;
import hex.util.LinearAlgebraUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import water.DKV;
import water.Freezable;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.Scope;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.IcedHashSet;
import water.util.Log;

public class GAM
extends ModelBuilder<GAMModel, GAMModel.GAMParameters, GAMModel.GAMModelOutput> {
    private double[][][] _knots;
    private double[] _cv_alpha = null;
    private double[] _cv_lambda = null;
    private int _thinPlateSmoothersWithKnotsNum = 0;
    private int _cubicSplineNum = 0;
    double[][] _gamColMeansRaw;
    public double[][] _oneOGamColStd;
    public double[] _penaltyScale;
    private boolean _cvOn = false;
    private Frame _origTrain = null;

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression};
    }

    public boolean isSupervised() {
        return true;
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public boolean havePojo() {
        return false;
    }

    public boolean haveMojo() {
        return true;
    }

    public GAM(boolean startup_once) {
        super((Model.Parameters)new GAMModel.GAMParameters(), startup_once);
    }

    public GAM(GAMModel.GAMParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
    }

    public GAM(GAMModel.GAMParameters parms, Key<GAMModel> key) {
        super((Model.Parameters)parms, key);
        this.init(false);
    }

    public void computeCrossValidation() {
        this._cvOn = true;
        this._origTrain = ((GAMModel.GAMParameters)this._parms).train();
        this.validateGamParameters();
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
        }
        super.computeCrossValidation();
    }

    public void cv_computeAndSetOptimalParameters(ModelBuilder[] cvModelBuilders) {
        double deviance_valid = Double.POSITIVE_INFINITY;
        double best_alpha = 0.0;
        double best_lambda = 0.0;
        for (int i = 0; i < cvModelBuilders.length; ++i) {
            GAMModel g = (GAMModel)cvModelBuilders[i].dest().get();
            if (!(((GAMModel.GAMModelOutput)g._output)._devianceValid < deviance_valid)) continue;
            best_alpha = ((GAMModel.GAMModelOutput)g._output)._best_alpha;
            best_lambda = ((GAMModel.GAMModelOutput)g._output)._best_lambda;
        }
        this._cv_alpha = new double[]{best_alpha};
        this._cv_lambda = new double[]{best_lambda};
    }

    public double[][][] generateKnotsFromKeys() {
        int numGamCols = ((GAMModel.GAMParameters)this._parms)._gam_columns.length;
        double[][][] knots = new double[numGamCols][][];
        boolean allNull = ((GAMModel.GAMParameters)this._parms)._knot_ids == null;
        int csInd = 0;
        int tpInd = this._cubicSplineNum;
        for (int outIndex = 0; outIndex < ((GAMModel.GAMParameters)this._parms)._gam_columns.length; ++outIndex) {
            String tempKey = allNull ? null : ((GAMModel.GAMParameters)this._parms)._knot_ids[outIndex];
            int gamIndex = ((GAMModel.GAMParameters)this._parms)._bs[outIndex] == 1 ? tpInd++ : csInd++;
            knots[gamIndex] = new double[((GAMModel.GAMParameters)this._parms)._gam_columns[outIndex].length][];
            if (tempKey != null && tempKey.length() > 0) {
                Frame knotFrame = (Frame)DKV.getGet((Key)Key.make((String)tempKey));
                double[][] knotContent = new double[(int)knotFrame.numRows()][((GAMModel.GAMParameters)this._parms)._gam_columns[outIndex].length];
                ArrayUtils.FrameToArray f2a = new ArrayUtils.FrameToArray(0, ((GAMModel.GAMParameters)this._parms)._gam_columns[outIndex].length - 1, knotFrame.numRows(), knotContent);
                knotContent = ((ArrayUtils.FrameToArray)f2a.doAll(knotFrame)).getArray();
                double[][] knotCTranspose = water.util.ArrayUtils.transpose((double[][])knotContent);
                for (int innerIndex = 0; innerIndex < knotCTranspose.length; ++innerIndex) {
                    knots[gamIndex][innerIndex] = new double[knotContent.length];
                    System.arraycopy(knotCTranspose[innerIndex], 0, knots[gamIndex][innerIndex], 0, knots[gamIndex][innerIndex].length);
                    if (knotCTranspose.length != 1 || ((GAMModel.GAMParameters)this._parms)._bs[outIndex] != 0) continue;
                    this.failVerifyKnots(knots[gamIndex][innerIndex], outIndex);
                }
                ((GAMModel.GAMParameters)this._parms)._num_knots[outIndex] = knotContent.length;
                continue;
            }
            Frame predictVec = new Frame(((GAMModel.GAMParameters)this._parms)._gam_columns[outIndex], ((GAMModel.GAMParameters)this._parms).train().vecs(((GAMModel.GAMParameters)this._parms)._gam_columns[outIndex]));
            if (((GAMModel.GAMParameters)this._parms)._bs[outIndex] == 0) {
                knots[gamIndex][0] = GamUtils.generateKnotsOneColumn(predictVec, ((GAMModel.GAMParameters)this._parms)._num_knots[outIndex]);
                this.failVerifyKnots(knots[gamIndex][0], outIndex);
                continue;
            }
            knots[gamIndex] = ThinPlateRegressionUtils.genKnotsMultiplePreds(predictVec, (GAMModel.GAMParameters)this._parms, outIndex);
            this.failVerifyKnots(knots[gamIndex][0], outIndex);
        }
        return knots;
    }

    public void failVerifyKnots(double[] knots, int gam_column_index) {
        for (int index = 0; index < knots.length; ++index) {
            if (Double.isNaN(knots[index])) {
                this.error("gam_columns/knots_id", String.format("Knots generated by default or specified in knots_id ended up containing a NaN value for gam_column %s.   Please specify alternate knots_id or choose other columns.", ((GAMModel.GAMParameters)this._parms)._gam_columns[gam_column_index][0]));
                return;
            }
            if (index > 0 && knots[index - 1] > knots[index]) {
                this.error("knots_id", String.format("knots not sorted in ascending order for gam_column %s. Knots at index %d: %f.  Knots at index %d: %f", ((GAMModel.GAMParameters)this._parms)._gam_columns[gam_column_index][0], index - 1, knots[index - 1], index, knots[index]));
                return;
            }
            if (index <= 0 || knots[index - 1] != knots[index]) continue;
            this.error("gam_columns/knots_id", String.format("chosen gam_column %s does have not enough values to generate well-defined knots. Please choose other columns or reduce the number of knots.  If knots are specified in knots_id, choose alternate knots_id as the knots are not in ascending order.  Knots at index %d: %f.  Knots at index %d: %f", ((GAMModel.GAMParameters)this._parms)._gam_columns[gam_column_index][0], index - 1, knots[index - 1], index, knots[index]));
            return;
        }
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (expensive && this._knots == null) {
            this.validateGamParameters();
        }
    }

    private void validateGamParameters() {
        if (((GAMModel.GAMParameters)this._parms)._max_iterations == 0) {
            this.error("_max_iterations", H2O.technote((int)2, (String)"if specified, must be >= 1."));
        }
        if (((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.AUTO) {
            if (this.nclasses() == 1 & ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default && ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.identity && ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.log && ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.inverse && ((GAMModel.GAMParameters)this._parms)._link != null) {
                this.error("_family", H2O.technote((int)2, (String)"AUTO for undelying response requires the link to be family_default, identity, log or inverse."));
            } else if (this.nclasses() == 2 & ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default && ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.logit && ((GAMModel.GAMParameters)this._parms)._link != null) {
                this.error("_family", H2O.technote((int)2, (String)"AUTO for undelying response requires the link to be family_default or logit."));
            } else if (this.nclasses() > 2 & ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default & ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.multinomial && ((GAMModel.GAMParameters)this._parms)._link != null) {
                this.error("_family", H2O.technote((int)2, (String)"AUTO for undelying response requires the link to be family_default or multinomial."));
            }
        }
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)this);
        }
        if (((GAMModel.GAMParameters)this._parms)._gam_columns == null) {
            this.error("_gam_columns", "must specify columns names to apply GAM to.  If you don't have any, use GLM.");
        } else {
            if (((GAMModel.GAMParameters)this._parms)._bs == null) {
                GamUtils.setDefaultBSType((GAMModel.GAMParameters)this._parms);
            }
            if (((GAMModel.GAMParameters)this._parms)._bs != null && ((GAMModel.GAMParameters)this._parms)._gam_columns.length != ((GAMModel.GAMParameters)this._parms)._bs.length) {
                this.error("gam colum number", "Number of gam columns implied from _bs and _gam_columns do not match.");
            }
            this.assertLegalGamColumnsNBSTypes();
        }
        if (((GAMModel.GAMParameters)this._parms)._scale == null) {
            GamUtils.setDefaultScale((GAMModel.GAMParameters)this._parms);
        }
        GamUtils.setGamPredSize((GAMModel.GAMParameters)this._parms, this._cubicSplineNum);
        if (this._thinPlateSmoothersWithKnotsNum > 0) {
            GamUtils.setThinPlateParameters((GAMModel.GAMParameters)this._parms, this._thinPlateSmoothersWithKnotsNum);
        }
        this.checkOrChooseNumKnots();
        for (int index = 0; index < ((GAMModel.GAMParameters)this._parms)._gam_columns.length; ++index) {
            String cname;
            Frame dataset = ((GAMModel.GAMParameters)this._parms).train();
            if (!dataset.vec(cname = ((GAMModel.GAMParameters)this._parms)._gam_columns[index][0]).isInt() || !(dataset.vec(cname).max() - dataset.vec(cname).min() + 1.0 < (double)((GAMModel.GAMParameters)this._parms)._num_knots[index])) continue;
            this.error("gam_columns", "column " + cname + " has cardinality lower than the number of knots and cannot be used as a gam column.");
        }
        if (((GAMModel.GAMParameters)this._parms)._num_knots.length != ((GAMModel.GAMParameters)this._parms)._gam_columns.length) {
            this.error("gam colum number", "Number of gam columns implied from _num_knots and _gam_columns do not match.");
        }
        if (((GAMModel.GAMParameters)this._parms)._knot_ids != null && ((GAMModel.GAMParameters)this._parms)._knot_ids.length != ((GAMModel.GAMParameters)this._parms)._gam_columns.length) {
            this.error("gam colum number", "Number of gam columns implied from _num_knots and _knot_ids do not match.");
        }
        this._knots = this.generateKnotsFromKeys();
        GamUtils.sortGAMParameters((GAMModel.GAMParameters)this._parms, this._cubicSplineNum, this._thinPlateSmoothersWithKnotsNum);
        this.checkThinPlateParams();
        if (((GAMModel.GAMParameters)this._parms)._saveZMatrix && this._train.numCols() - 1 + ((GAMModel.GAMParameters)this._parms)._num_knots.length < 2) {
            this.error("_saveZMatrix", "can only be enabled if the number of predictors plus Gam columns in gam_columns exceeds 2");
        }
        if (((GAMModel.GAMParameters)this._parms)._lambda_search || !((GAMModel.GAMParameters)this._parms)._intercept || ((GAMModel.GAMParameters)this._parms)._lambda == null || ((GAMModel.GAMParameters)this._parms)._lambda[0] > 0.0) {
            ((GAMModel.GAMParameters)this._parms)._use_all_factor_levels = true;
        }
        if (((GAMModel.GAMParameters)this._parms)._link == null) {
            ((GAMModel.GAMParameters)this._parms)._link = GLMModel.GLMParameters.Link.family_default;
        }
        if (((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.AUTO) {
            ((GAMModel.GAMParameters)this._parms)._family = this._nclass == 1 ? GLMModel.GLMParameters.Family.gaussian : (this._nclass == 2 ? GLMModel.GLMParameters.Family.binomial : GLMModel.GLMParameters.Family.multinomial);
        }
        if (((GAMModel.GAMParameters)this._parms)._link == null || ((GAMModel.GAMParameters)this._parms)._link.equals((Object)GLMModel.GLMParameters.Link.family_default)) {
            ((GAMModel.GAMParameters)this._parms)._link = ((GAMModel.GAMParameters)this._parms)._family.defaultLink;
        }
        if ((((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal || ((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.binomial) && this.response().get_type() != 4) {
            this.error("_response_column", String.format("For given response family '%s', please provide a categorical response column. Current response column type is '%s'.", new Object[]{((GAMModel.GAMParameters)this._parms)._family, this.response().get_type_str()}));
        }
    }

    public void checkThinPlateParams() {
        if (this._thinPlateSmoothersWithKnotsNum == 0) {
            return;
        }
        ((GAMModel.GAMParameters)this._parms)._num_knots_tp = new int[this._thinPlateSmoothersWithKnotsNum];
        System.arraycopy(((GAMModel.GAMParameters)this._parms)._num_knots_sorted, this._cubicSplineNum, ((GAMModel.GAMParameters)this._parms)._num_knots_tp, 0, this._thinPlateSmoothersWithKnotsNum);
        int tpIndex = 0;
        for (int index = 0; index < ((GAMModel.GAMParameters)this._parms)._gam_columns.length; ++index) {
            if (((GAMModel.GAMParameters)this._parms)._bs_sorted[index] != 1) continue;
            if (((GAMModel.GAMParameters)this._parms)._num_knots_sorted[index] < ((GAMModel.GAMParameters)this._parms)._M[tpIndex] + 1) {
                this.error("num_knots", "num_knots for gam column start with  " + ((GAMModel.GAMParameters)this._parms)._gam_columns_sorted[index][0] + " did not specify enough num_knots.  It should be equal or greater than " + (((GAMModel.GAMParameters)this._parms)._M[tpIndex] + 1) + ".");
            }
            ++tpIndex;
        }
    }

    public void checkOrChooseNumKnots() {
        if (((GAMModel.GAMParameters)this._parms)._num_knots == null) {
            ((GAMModel.GAMParameters)this._parms)._num_knots = new int[((GAMModel.GAMParameters)this._parms)._gam_columns.length];
        }
        int tpCount = 0;
        for (int index = 0; index < ((GAMModel.GAMParameters)this._parms)._num_knots.length; ++index) {
            if (((GAMModel.GAMParameters)this._parms)._knot_ids != null && (((GAMModel.GAMParameters)this._parms)._knot_ids == null || ((GAMModel.GAMParameters)this._parms)._knot_ids[index] != null)) continue;
            int numKnots = ((GAMModel.GAMParameters)this._parms)._num_knots[index];
            int naSum = 0;
            for (int innerIndex = 0; innerIndex < ((GAMModel.GAMParameters)this._parms)._gam_columns[index].length; ++innerIndex) {
                naSum = (int)((long)naSum + ((GAMModel.GAMParameters)this._parms).train().vec(((GAMModel.GAMParameters)this._parms)._gam_columns[index][innerIndex]).naCnt());
            }
            long eligibleRows = this._train.numRows() - (long)naSum;
            if (((GAMModel.GAMParameters)this._parms)._num_knots[index] == 0) {
                int defaultRows = 10;
                if (((GAMModel.GAMParameters)this._parms)._bs[index] == 1) {
                    defaultRows = Math.max(defaultRows, ((GAMModel.GAMParameters)this._parms)._M[tpCount] + 2);
                    ++tpCount;
                }
                ((GAMModel.GAMParameters)this._parms)._num_knots[index] = eligibleRows < (long)defaultRows ? (int)eligibleRows : defaultRows;
                continue;
            }
            if ((long)numKnots <= eligibleRows) continue;
            this.error("_num_knots", " number of knots specified in _num_knots: " + numKnots + " for smoother with first predictor " + ((GAMModel.GAMParameters)this._parms)._gam_columns[index][0] + ".  Reduce _num_knots.");
        }
    }

    public void assertLegalGamColumnsNBSTypes() {
        Frame dataset = ((GAMModel.GAMParameters)this._parms).train();
        List<String> cNames = Arrays.asList(dataset.names());
        for (int index = 0; index < ((GAMModel.GAMParameters)this._parms)._gam_columns.length; ++index) {
            if (((GAMModel.GAMParameters)this._parms)._bs == null) continue;
            if (((GAMModel.GAMParameters)this._parms)._gam_columns[index].length > 1 && ((GAMModel.GAMParameters)this._parms)._bs[index] != 1) {
                this.error("bs", "Smother with multiple predictors can only use bs = 1");
            }
            if (((GAMModel.GAMParameters)this._parms)._bs[index] == 1) {
                ++this._thinPlateSmoothersWithKnotsNum;
            }
            if (((GAMModel.GAMParameters)this._parms)._bs[index] == 0) {
                ++this._cubicSplineNum;
            }
            for (int innerIndex = 0; innerIndex < ((GAMModel.GAMParameters)this._parms)._gam_columns[index].length; ++innerIndex) {
                String cname = ((GAMModel.GAMParameters)this._parms)._gam_columns[index][innerIndex];
                if (!cNames.contains(cname)) {
                    this.error("gam_columns", "column name: " + cname + " does not exist in your dataset.");
                }
                if (dataset.vec(cname).isCategorical()) {
                    this.error("gam_columns", "column " + cname + " is categorical and cannot be used as a gam column.");
                }
                if (dataset.vec(cname).isBad() || dataset.vec(cname).isTime() || dataset.vec(cname).isUUID() || dataset.vec(cname).isConst()) {
                    this.error("gam_columns", String.format("Column '%s' of type '%s' cannot be used as GAM column. Column types BAD, TIME, CONSTANT and UUID cannot be used.", cname, dataset.vec(cname).get_type_str()));
                }
                if (dataset.vec(cname).isNumeric()) continue;
                this.error("gam_columns", "column " + cname + " is not numerical and cannot be used as a gam column.");
            }
        }
    }

    protected boolean computePriorClassDistribution() {
        return ((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal;
    }

    protected GAMDriver trainModelImpl() {
        return new GAMDriver();
    }

    protected int nModelsInParallel(int folds) {
        return this.nModelsInParallel(folds, 2);
    }

    private class GAMDriver
    extends ModelBuilder.Driver {
        double[][][] _zTranspose;
        double[][][] _zTransposeCS;
        double[][][] _penaltyMatCenter;
        double[][][] _penaltyMat;
        double[][][] _penaltyMatCS;
        double[][][] _starT;
        public double[][][] _binvD;
        public int[] _numKnots;
        String[][] _gamColNames;
        String[][] _gamColNamesCenter;
        Key<Frame>[] _gamFrameKeys;
        Key<Frame>[] _gamFrameKeysCenter;
        double[][] _gamColMeans;
        int[][][] _allPolyBasisList;

        private GAMDriver() {
            super((ModelBuilder)GAM.this);
        }

        Frame adaptTrain() {
            int numGamFrame = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            this._zTranspose = GamUtils.allocate3DArray(numGamFrame, (GAMModel.GAMParameters)GAM.this._parms, GamUtils.AllocateType.firstOneLess);
            this._penaltyMat = ((GAMModel.GAMParameters)GAM.this._parms)._savePenaltyMat ? GamUtils.allocate3DArray(numGamFrame, (GAMModel.GAMParameters)GAM.this._parms, GamUtils.AllocateType.sameOrig) : (double[][][])null;
            this._penaltyMatCenter = GamUtils.allocate3DArray(numGamFrame, (GAMModel.GAMParameters)GAM.this._parms, GamUtils.AllocateType.bothOneLess);
            if (GAM.this._cubicSplineNum > 0) {
                this._binvD = GamUtils.allocate3DArrayCS(GAM.this._cubicSplineNum, (GAMModel.GAMParameters)GAM.this._parms, GamUtils.AllocateType.firstTwoLess);
            }
            this._numKnots = MemoryManager.malloc4((int)numGamFrame);
            this._gamColNames = new String[numGamFrame][];
            this._gamColNamesCenter = new String[numGamFrame][];
            this._gamFrameKeys = new Key[numGamFrame];
            this._gamFrameKeysCenter = new Key[numGamFrame];
            this._gamColMeans = new double[numGamFrame][];
            GAM.this._penaltyScale = new double[numGamFrame];
            if (GAM.this._thinPlateSmoothersWithKnotsNum > 0) {
                int[] kMinusM = water.util.ArrayUtils.subtract((int[])((GAMModel.GAMParameters)GAM.this._parms)._num_knots_tp, (int[])((GAMModel.GAMParameters)GAM.this._parms)._M);
                this._zTransposeCS = GamUtils.allocate3DArrayTP(GAM.this._thinPlateSmoothersWithKnotsNum, (GAMModel.GAMParameters)GAM.this._parms, kMinusM, ((GAMModel.GAMParameters)GAM.this._parms)._num_knots_tp);
                this._penaltyMatCS = GamUtils.allocate3DArrayTP(GAM.this._thinPlateSmoothersWithKnotsNum, (GAMModel.GAMParameters)GAM.this._parms, kMinusM, kMinusM);
                this._allPolyBasisList = new int[GAM.this._thinPlateSmoothersWithKnotsNum][][];
                GAM.this._gamColMeansRaw = new double[GAM.this._thinPlateSmoothersWithKnotsNum][];
                GAM.this._oneOGamColStd = new double[GAM.this._thinPlateSmoothersWithKnotsNum][];
                if (((GAMModel.GAMParameters)GAM.this._parms)._savePenaltyMat) {
                    this._starT = GamUtils.allocate3DArrayTP(GAM.this._thinPlateSmoothersWithKnotsNum, (GAMModel.GAMParameters)GAM.this._parms, ((GAMModel.GAMParameters)GAM.this._parms)._num_knots_tp, ((GAMModel.GAMParameters)GAM.this._parms)._M);
                }
            }
            this.addGAM2Train();
            return GamUtils.buildGamFrame((GAMModel.GAMParameters)GAM.this._parms, GAM.this._train, this._gamFrameKeysCenter);
        }

        public Frame getTrainFrame(Frame trainFrame) {
            if (GAM.this._cvOn && trainFrame.numRows() == GAM.this._origTrain.numRows()) {
                if (Arrays.asList(trainFrame.names()).contains("__internal_cv_weights__")) {
                    Frame origTrain = (Frame)GAM.this._origTrain.clone();
                    origTrain.add("__internal_cv_weights__", trainFrame.vec("__internal_cv_weights__"));
                    return origTrain;
                }
                return GAM.this._origTrain;
            }
            return trainFrame;
        }

        void addGAM2Train() {
            int numGamFrame = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            RecursiveAction[] generateGamColumn = new RecursiveAction[numGamFrame];
            int thinPlateInd = 0;
            int csInd = 0;
            Frame trainFrame = this.getTrainFrame(((GAMModel.GAMParameters)GAM.this._parms).train());
            for (int index = 0; index < numGamFrame; ++index) {
                Frame predictVec = GamUtils.prepareGamVec(index, (GAMModel.GAMParameters)GAM.this._parms, trainFrame);
                int numKnots = ((GAMModel.GAMParameters)GAM.this._parms)._num_knots_sorted[index];
                int numKnotsM1 = numKnots - 1;
                if (((GAMModel.GAMParameters)GAM.this._parms)._bs_sorted[index] == 0) {
                    this._gamColNames[index] = GamUtils.generateGamColNames(index, (GAMModel.GAMParameters)GAM.this._parms);
                    this._gamColNamesCenter[index] = new String[numKnotsM1];
                    this._gamColMeans[index] = new double[numKnots];
                    generateGamColumn[index] = new CubicSplineSmoother(predictVec, (GAMModel.GAMParameters)GAM.this._parms, index, this._gamColNames[index], GAM.this._knots[index][0], GamUtils.AllocateType.firstTwoLess, csInd++);
                    continue;
                }
                int kPlusM = ((GAMModel.GAMParameters)GAM.this._parms)._num_knots_sorted[index] + ((GAMModel.GAMParameters)GAM.this._parms)._M[thinPlateInd];
                this._gamColNames[index] = new String[kPlusM];
                this._gamColNamesCenter[index] = new String[numKnotsM1];
                this._gamColMeans[index] = new double[kPlusM];
                this._allPolyBasisList[thinPlateInd] = new int[((GAMModel.GAMParameters)GAM.this._parms)._M[thinPlateInd]][((GAMModel.GAMParameters)GAM.this._parms)._gamPredSize[index]];
                GAM.this._gamColMeansRaw[thinPlateInd] = new double[((GAMModel.GAMParameters)GAM.this._parms)._gamPredSize[index]];
                GAM.this._oneOGamColStd[thinPlateInd] = new double[((GAMModel.GAMParameters)GAM.this._parms)._gamPredSize[index]];
                generateGamColumn[index] = new ThinPlateRegressionSmootherWithKnots(predictVec, (GAMModel.GAMParameters)GAM.this._parms, index, GAM.this._knots[index], thinPlateInd++);
            }
            ForkJoinTask.invokeAll((ForkJoinTask[])generateGamColumn);
        }

        void verifyGamTransformedFrame(Frame gamTransformed) {
            int numGamFrame = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            for (int findex = 0; findex < numGamFrame; ++findex) {
                int numGamCols = this._gamColNamesCenter[findex].length;
                for (int index = 0; index < numGamCols; ++index) {
                    if (!gamTransformed.vec(this._gamColNamesCenter[findex][index]).isConst()) continue;
                    GAM.this.error(this._gamColNamesCenter[findex][index], "gam column transformation generated constant columns for " + ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns[findex]);
                }
            }
        }

        public void computeImpl() {
            Frame newValidFrame;
            GAM.this.init(true);
            if (GAM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)GAM.this);
            }
            Frame newTFrame = new Frame(GAM.this.rebalance(this.adaptTrain(), false, GAM.this._result + ".temporary.train"));
            this.verifyGamTransformedFrame(newTFrame);
            if (GAM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder((ModelBuilder)GAM.this);
            }
            if (GAM.this.valid() != null) {
                GAM.this._valid = GAM.this.rebalance(GAMModel.adaptValidFrame(this.getTrainFrame(((GAMModel.GAMParameters)GAM.this._parms).valid()), GAM.this._valid, (GAMModel.GAMParameters)GAM.this._parms, this._gamColNamesCenter, this._binvD, this._zTranspose, GAM.this._knots, this._zTransposeCS, this._allPolyBasisList, GAM.this._gamColMeansRaw, GAM.this._oneOGamColStd), false, GAM.this._result + ".temporary.valid");
            }
            DKV.put((Keyed)newTFrame);
            Frame frame = newValidFrame = GAM.this._valid == null ? null : new Frame(GAM.this._valid);
            if (newValidFrame != null) {
                DKV.put((Keyed)newValidFrame);
            }
            GAM.this._job.update(0L, "Initializing model training");
            this.buildModel(newTFrame, newValidFrame);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void buildModel(Frame newTFrame, Frame newValidFrame) {
            GAMModel model = null;
            DataInfo dinfo = null;
            IcedHashSet validKeys = new IcedHashSet();
            try {
                GAM.this._job.update(0L, "Adding GAM columns to training dataset...");
                dinfo = new DataInfo((Frame)GAM.this._train.clone(), GAM.this._valid, 1, ((GAMModel.GAMParameters)GAM.this._parms)._use_all_factor_levels || ((GAMModel.GAMParameters)GAM.this._parms)._lambda_search, ((GAMModel.GAMParameters)GAM.this._parms)._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, ((GAMModel.GAMParameters)GAM.this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.Skip, ((GAMModel.GAMParameters)GAM.this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.MeanImputation || ((GAMModel.GAMParameters)GAM.this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.PlugValues, ((GAMModel.GAMParameters)GAM.this._parms).makeImputer(), false, GAM.this.hasWeightCol(), GAM.this.hasOffsetCol(), GAM.this.hasFoldCol(), ((GAMModel.GAMParameters)GAM.this._parms).interactionSpec());
                DKV.put((Key)dinfo._key, (Iced)dinfo);
                model = new GAMModel((Key<GAMModel>)GAM.this.dest(), (GAMModel.GAMParameters)GAM.this._parms, new GAMModel.GAMModelOutput(GAM.this, dinfo));
                model.write_lock(GAM.this._job);
                if (((GAMModel.GAMParameters)GAM.this._parms)._keep_gam_cols) {
                    ((GAMModel.GAMModelOutput)model._output)._gamTransformedTrainCenter = newTFrame._key;
                }
                GAM.this._job.update(1L, "calling GLM to build GAM model...");
                GLMModel glmModel = this.buildGLMModel((GAMModel.GAMParameters)GAM.this._parms, newTFrame, newValidFrame);
                if (model.evalAutoParamsEnabled) {
                    model.initActualParamValuesAfterGlmCreation();
                }
                Scope.track_generic((Keyed)glmModel);
                GAM.this._job.update(0L, "Building out GAM model...");
                this.fillOutGAMModel(glmModel, model);
                model.update(GAM.this._job);
                GAM.this._job.update(0L, "Scoring training frame");
                this.scoreGenModelMetrics(model, GAM.this.train(), true);
                if (GAM.this.valid() != null) {
                    this.scoreGenModelMetrics(model, GAM.this.valid(), false);
                }
            }
            catch (Gram.NonSPDMatrixException exception) {
                try {
                    throw new Gram.NonSPDMatrixException("Consider enable lambda_search, decrease scale parameter value for TP smoothers, \ndisable scaling for TP penalty matrics, or not use thin plate regression smoothers at all.");
                }
                catch (Throwable throwable) {
                    try {
                        ArrayList<Key<Vec>> keep = new ArrayList<Key<Vec>>();
                        if (model != null) {
                            if (((GAMModel.GAMParameters)GAM.this._parms)._keep_gam_cols) {
                                GamUtils.keepFrameKeys(keep, newTFrame._key);
                            } else {
                                DKV.remove((Key)newTFrame._key);
                            }
                        }
                        if (dinfo != null) {
                            dinfo.remove();
                        }
                        if (newValidFrame != null && validKeys != null) {
                            GamUtils.keepFrameKeys(keep, newValidFrame._key);
                            validKeys.addIfAbsent((Freezable)newValidFrame._key);
                            model._validKeys = validKeys;
                        }
                        Scope.exit((Key[])keep.toArray(new Key[keep.size()]));
                        throw throwable;
                    }
                    finally {
                        model.update(GAM.this._job);
                        model.unlock(GAM.this._job);
                    }
                }
            }
            try {
                ArrayList<Key<Vec>> keep = new ArrayList<Key<Vec>>();
                if (model != null) {
                    if (((GAMModel.GAMParameters)GAM.this._parms)._keep_gam_cols) {
                        GamUtils.keepFrameKeys(keep, newTFrame._key);
                    } else {
                        DKV.remove((Key)newTFrame._key);
                    }
                }
                if (dinfo != null) {
                    dinfo.remove();
                }
                if (newValidFrame != null && validKeys != null) {
                    GamUtils.keepFrameKeys(keep, newValidFrame._key);
                    validKeys.addIfAbsent((Freezable)newValidFrame._key);
                    model._validKeys = validKeys;
                }
                Scope.exit((Key[])keep.toArray(new Key[keep.size()]));
                return;
            }
            finally {
                model.update(GAM.this._job);
                model.unlock(GAM.this._job);
            }
        }

        private void scoreGenModelMetrics(GAMModel model, Frame scoreFrame, boolean forTraining) {
            Frame scoringTrain = new Frame(scoreFrame);
            model.adaptTestForTrain(scoringTrain, true, true);
            Frame scoredResult = model.score(scoringTrain);
            scoredResult.delete();
            ModelMetrics mtrain = ModelMetrics.getFromDKV((Model)model, (Frame)scoringTrain);
            if (mtrain != null) {
                if (forTraining) {
                    ((GAMModel.GAMModelOutput)model._output)._training_metrics = mtrain;
                } else {
                    ((GAMModel.GAMModelOutput)model._output)._validation_metrics = mtrain;
                }
                Log.info((Object[])new Object[]{"GAM[dest=" + GAM.this.dest() + "]" + mtrain.toString()});
            } else {
                Log.info((Object[])new Object[]{"Model metrics is empty!"});
            }
        }

        GLMModel buildGLMModel(GAMModel.GAMParameters parms, Frame trainData, Frame validFrame) {
            GLMModel.GLMParameters glmParam = GamUtils.copyGAMParams2GLMParams(parms, trainData, validFrame);
            if (GAM.this._cv_lambda != null) {
                glmParam._lambda = GAM.this._cv_lambda;
                glmParam._alpha = GAM.this._cv_alpha;
                glmParam._lambda_search = false;
            }
            int numGamCols = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            for (int find = 0; find < numGamCols; ++find) {
                if (((GAMModel.GAMParameters)GAM.this._parms)._scale == null || ((GAMModel.GAMParameters)GAM.this._parms)._scale[find] == 1.0) continue;
                this._penaltyMatCenter[find] = water.util.ArrayUtils.mult((double[][])this._penaltyMatCenter[find], (double)((GAMModel.GAMParameters)GAM.this._parms)._scale[find]);
            }
            glmParam._glmType = GLMModel.GLMParameters.GLMType.gam;
            return (GLMModel)new GLM(glmParam, this._penaltyMatCenter, this._gamColNamesCenter).trainModel().get();
        }

        void fillOutGAMModel(GLMModel glm, GAMModel model) {
            model._gamColNamesNoCentering = this._gamColNames;
            model._gamColNames = this._gamColNamesCenter;
            ((GAMModel.GAMModelOutput)model._output)._gamColNames = this._gamColNamesCenter;
            ((GAMModel.GAMModelOutput)model._output)._zTranspose = this._zTranspose;
            ((GAMModel.GAMModelOutput)model._output)._zTransposeCS = this._zTransposeCS;
            ((GAMModel.GAMModelOutput)model._output)._allPolyBasisList = this._allPolyBasisList;
            model._gamFrameKeysCenter = this._gamFrameKeysCenter;
            model._nclass = GAM.this._nclass;
            ((GAMModel.GAMModelOutput)model._output)._binvD = this._binvD;
            ((GAMModel.GAMModelOutput)model._output)._knots = GAM.this._knots;
            ((GAMModel.GAMModelOutput)model._output)._numKnots = this._numKnots;
            model._cubicSplineNum = GAM.this._cubicSplineNum;
            model._thinPlateSmoothersWithKnotsNum = GAM.this._thinPlateSmoothersWithKnotsNum;
            ((GAMModel.GAMModelOutput)model._output)._gamColMeansRaw = GAM.this._gamColMeansRaw;
            ((GAMModel.GAMModelOutput)model._output)._oneOGamColStd = GAM.this._oneOGamColStd;
            ((GAMModel.GAMModelOutput)model._output)._best_alpha = ((GLMModel.GLMOutput)glm._output).getSubmodel((int)((GLMModel.GLMOutput)glm._output)._selected_submodel_idx).alpha_value;
            ((GAMModel.GAMModelOutput)model._output)._best_lambda = ((GLMModel.GLMOutput)glm._output).getSubmodel((int)((GLMModel.GLMOutput)glm._output)._selected_submodel_idx).lambda_value;
            ((GAMModel.GAMModelOutput)model._output)._devianceTrain = ((GLMModel.GLMOutput)glm._output).getSubmodel((int)((GLMModel.GLMOutput)glm._output)._selected_submodel_idx).devianceTrain;
            ((GAMModel.GAMModelOutput)model._output)._devianceValid = ((GLMModel.GLMOutput)glm._output).getSubmodel((int)((GLMModel.GLMOutput)glm._output)._selected_submodel_idx).devianceValid;
            model._gamColMeans = ArrayUtils.flat((double[][])this._gamColMeans);
            if (((GAMModel.GAMParameters)GAM.this._parms)._lambda == null) {
                ((GAMModel.GAMParameters)GAM.this._parms)._lambda = (double[])((GLMModel.GLMParameters)glm._parms)._lambda.clone();
            }
            if (((GAMModel.GAMParameters)GAM.this._parms)._keep_gam_cols) {
                ((GAMModel.GAMModelOutput)model._output)._gam_transformed_center_key = ((GAMModel.GAMModelOutput)model._output)._gamTransformedTrainCenter.toString();
            }
            if (((GAMModel.GAMParameters)GAM.this._parms)._savePenaltyMat) {
                ((GAMModel.GAMModelOutput)model._output)._penaltyMatricesCenter = this._penaltyMatCenter;
                ((GAMModel.GAMModelOutput)model._output)._penaltyMatrices = this._penaltyMat;
                ((GAMModel.GAMModelOutput)model._output)._penaltyScale = GAM.this._penaltyScale;
                if (GAM.this._thinPlateSmoothersWithKnotsNum > 0) {
                    ((GAMModel.GAMModelOutput)model._output)._penaltyMatCS = this._penaltyMatCS;
                    ((GAMModel.GAMModelOutput)model._output)._starT = this._starT;
                }
            }
            GAMModelUtils.copyGLMCoeffs(glm, model, (GAMModel.GAMParameters)GAM.this._parms, GAM.this.nclasses());
            GAMModelUtils.copyGLMtoGAMModel(model, glm, (GAMModel.GAMParameters)GAM.this._parms, GAM.this.valid());
        }

        public class CubicSplineSmoother
        extends RecursiveAction {
            final Frame _predictVec;
            final int _numKnots;
            final int _numKnotsM1;
            final int _splineType;
            final boolean _savePenaltyMat;
            final String[] _newColNames;
            final double[] _knots;
            final GAMModel.GAMParameters _parms;
            final GamUtils.AllocateType _fileMode;
            final int _gamColIndex;
            final int _csIndex;

            public CubicSplineSmoother(Frame predV, GAMModel.GAMParameters parms, int gamColIndex, String[] gamColNames, double[] knots, GamUtils.AllocateType fileM, int csInd) {
                this._predictVec = predV;
                this._numKnots = parms._num_knots_sorted[gamColIndex];
                this._numKnotsM1 = this._numKnots - 1;
                this._splineType = parms._bs_sorted[gamColIndex];
                this._savePenaltyMat = parms._savePenaltyMat;
                this._newColNames = gamColNames;
                this._knots = knots;
                this._parms = parms;
                this._gamColIndex = gamColIndex;
                this._fileMode = fileM;
                this._csIndex = csInd;
            }

            protected void compute() {
                GenerateGamMatrixOneColumn genOneGamCol = (GenerateGamMatrixOneColumn)new GenerateGamMatrixOneColumn(this._splineType, this._numKnots, this._knots, this._predictVec).doAll(this._numKnots, (byte)3, this._predictVec);
                if (this._savePenaltyMat) {
                    GamUtils.copy2DArray(genOneGamCol._penaltyMat, GAMDriver.this._penaltyMat[this._gamColIndex]);
                    GAM.this._penaltyScale[this._gamColIndex] = genOneGamCol._s_scale;
                }
                Frame oneAugmentedColumnCenter = genOneGamCol.outputFrame(Key.make(), this._newColNames, null);
                for (int index = 0; index < this._numKnots; ++index) {
                    GAMDriver.this._gamColMeans[this._gamColIndex][index] = oneAugmentedColumnCenter.vec(index).mean();
                }
                oneAugmentedColumnCenter = genOneGamCol.centralizeFrame(oneAugmentedColumnCenter, this._predictVec.name(0) + "_" + this._splineType + "_center_", this._parms);
                GamUtils.copy2DArray(genOneGamCol._ZTransp, GAMDriver.this._zTranspose[this._gamColIndex]);
                double[][] transformedPenalty = water.util.ArrayUtils.multArrArr((double[][])water.util.ArrayUtils.multArrArr((double[][])genOneGamCol._ZTransp, (double[][])genOneGamCol._penaltyMat), (double[][])water.util.ArrayUtils.transpose((double[][])genOneGamCol._ZTransp));
                GamUtils.copy2DArray(transformedPenalty, GAMDriver.this._penaltyMatCenter[this._gamColIndex]);
                GAMDriver.this._gamFrameKeysCenter[this._gamColIndex] = oneAugmentedColumnCenter._key;
                DKV.put((Keyed)oneAugmentedColumnCenter);
                System.arraycopy(oneAugmentedColumnCenter.names(), 0, GAMDriver.this._gamColNamesCenter[this._gamColIndex], 0, this._numKnotsM1);
                GamUtils.copy2DArray(genOneGamCol._bInvD, GAMDriver.this._binvD[this._csIndex]);
            }
        }

        public class ThinPlateRegressionSmootherWithKnots
        extends RecursiveAction {
            final Frame _predictVec;
            final int _numKnots;
            final int _numKnotsM1;
            final int _numKnotsMM;
            final int _splineType;
            final boolean _savePenaltyMat;
            final double[][] _knots;
            final GAMModel.GAMParameters _parms;
            final int _gamColIndex;
            final int _thinPlateGamColIndex;
            final int _numPred;
            final int _M;

            public ThinPlateRegressionSmootherWithKnots(Frame predV, GAMModel.GAMParameters parms, int gamColIndex, double[][] knots, int thinPlateInd) {
                this._predictVec = predV;
                this._knots = knots;
                this._numKnots = parms._num_knots_sorted[gamColIndex];
                this._numKnotsM1 = this._numKnots - 1;
                this._parms = parms;
                this._splineType = this._parms._bs_sorted[gamColIndex];
                this._gamColIndex = gamColIndex;
                this._thinPlateGamColIndex = thinPlateInd;
                this._savePenaltyMat = this._parms._savePenaltyMat;
                this._numPred = parms._gam_columns_sorted[gamColIndex].length;
                this._M = this._parms._M[this._thinPlateGamColIndex];
                this._numKnotsMM = this._numKnots - this._M;
            }

            protected void compute() {
                double[] rawColMeans = new double[this._numPred];
                double[] oneOverColStd = new double[this._numPred];
                for (int colInd = 0; colInd < this._numPred; ++colInd) {
                    rawColMeans[colInd] = this._predictVec.vec(colInd).mean();
                    oneOverColStd[colInd] = 1.0 / this._predictVec.vec(colInd).sigma();
                }
                System.arraycopy(rawColMeans, 0, GAM.this._gamColMeansRaw[this._thinPlateGamColIndex], 0, rawColMeans.length);
                System.arraycopy(oneOverColStd, 0, GAM.this._oneOGamColStd[this._thinPlateGamColIndex], 0, oneOverColStd.length);
                ThinPlateDistanceWithKnots distanceMeasure = (ThinPlateDistanceWithKnots)new ThinPlateDistanceWithKnots(this._knots, this._numPred, oneOverColStd, this._parms._standardize_tp_gam_cols).doAll(this._numKnots, (byte)3, this._predictVec);
                List<Integer[]> polyBasisDegree = ThinPlateRegressionUtils.findPolyBasis(this._numPred, ThinPlateRegressionUtils.calculatem(this._numPred));
                int[][] polyBasisArray = ThinPlateRegressionUtils.convertList2Array(polyBasisDegree, this._M, this._numPred);
                GamUtils.copy2DArray(polyBasisArray, GAMDriver.this._allPolyBasisList[this._thinPlateGamColIndex]);
                String colNameStub = ThinPlateRegressionUtils.genThinPlateNameStart(this._parms, this._gamColIndex);
                String[] gamColNames = GamUtils.generateGamColNamesThinPlateKnots(this._gamColIndex, this._parms, polyBasisArray, colNameStub);
                System.arraycopy(gamColNames, 0, GAMDriver.this._gamColNames[this._gamColIndex], 0, gamColNames.length);
                String[] distanceColNames = ThinPlateRegressionUtils.extractColNames(gamColNames, 0, 0, this._numKnots);
                String[] polyNames = ThinPlateRegressionUtils.extractColNames(gamColNames, this._numKnots, 0, this._M);
                Frame thinPlateFrame = distanceMeasure.outputFrame(Key.make(), distanceColNames, null);
                for (int index = 0; index < this._numKnots; ++index) {
                    GAMDriver.this._gamColMeans[this._gamColIndex][index] = thinPlateFrame.vec(index).mean();
                }
                double[][] starT = ThinPlateRegressionUtils.generateStarT(this._knots, polyBasisDegree, rawColMeans, oneOverColStd, this._parms._standardize_tp_gam_cols);
                double[][] qmat = LinearAlgebraUtils.generateQR(starT);
                double[][] penaltyMat = distanceMeasure.generatePenalty(qmat);
                double[][] zCST = LinearAlgebraUtils.generateOrthogonalComplement(qmat, starT, this._numKnotsMM, this._parms._seed);
                GamUtils.copy2DArray(zCST, GAMDriver.this._zTransposeCS[this._thinPlateGamColIndex]);
                ThinPlatePolynomialWithKnots thinPlatePoly = (ThinPlatePolynomialWithKnots)new ThinPlatePolynomialWithKnots(this._numPred, polyBasisArray, rawColMeans, oneOverColStd, this._parms._standardize_tp_gam_cols).doAll(this._M, (byte)3, this._predictVec);
                Frame thinPlatePolyBasis = thinPlatePoly.outputFrame(null, polyNames, null);
                for (int index = 0; index < this._M; ++index) {
                    GAMDriver.this._gamColMeans[this._gamColIndex][index + this._numKnots] = thinPlatePolyBasis.vec(index).mean();
                }
                thinPlateFrame = ThinPlateDistanceWithKnots.applyTransform(thinPlateFrame, colNameStub + "TPKnots_", this._parms, zCST, this._numKnotsMM);
                thinPlateFrame.add(thinPlatePolyBasis.names(), thinPlatePolyBasis.removeAll());
                double[][] ztranspose = GenerateGamMatrixOneColumn.generateZTransp(thinPlateFrame, this._numKnots);
                GamUtils.copy2DArray(ztranspose, GAMDriver.this._zTranspose[this._gamColIndex]);
                double[][] penaltyMatCS = water.util.ArrayUtils.multArrArr((double[][])water.util.ArrayUtils.multArrArr((double[][])zCST, (double[][])penaltyMat), (double[][])water.util.ArrayUtils.transpose((double[][])zCST));
                if (this._parms._scale_tp_penalty_mat) {
                    ThinPlateRegressionUtils.ScaleTPPenalty scaleTPPenaltyCS = (ThinPlateRegressionUtils.ScaleTPPenalty)new ThinPlateRegressionUtils.ScaleTPPenalty(penaltyMatCS, thinPlateFrame).doAll(thinPlateFrame);
                    GAM.this._penaltyScale[this._gamColIndex] = scaleTPPenaltyCS._s_scale;
                    penaltyMatCS = scaleTPPenaltyCS._penaltyMat;
                }
                double[][] expandPenaltyCS = water.util.ArrayUtils.expandArray((double[][])penaltyMatCS, (int)this._numKnots);
                if (this._savePenaltyMat) {
                    GamUtils.copy2DArray(penaltyMat, GAMDriver.this._penaltyMat[this._gamColIndex]);
                    GamUtils.copy2DArray(starT, GAMDriver.this._starT[this._thinPlateGamColIndex]);
                    GamUtils.copy2DArray(penaltyMatCS, GAMDriver.this._penaltyMatCS[this._thinPlateGamColIndex]);
                }
                double[][] penaltyCenter = water.util.ArrayUtils.multArrArr((double[][])water.util.ArrayUtils.multArrArr((double[][])ztranspose, (double[][])expandPenaltyCS), (double[][])water.util.ArrayUtils.transpose((double[][])ztranspose));
                GamUtils.copy2DArray(penaltyCenter, GAMDriver.this._penaltyMatCenter[this._gamColIndex]);
                thinPlateFrame = ThinPlateDistanceWithKnots.applyTransform(thinPlateFrame, colNameStub + "center_", this._parms, ztranspose, this._numKnotsM1);
                GAMDriver.this._gamFrameKeysCenter[this._gamColIndex] = thinPlateFrame._key;
                DKV.put((Keyed)thinPlateFrame);
                System.arraycopy(thinPlateFrame.names(), 0, GAMDriver.this._gamColNamesCenter[this._gamColIndex], 0, this._numKnotsM1);
            }
        }
    }
}

