/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.MatrixFrameUtils;

import hex.Model;
import hex.gam.GAMModel;
import hex.gam.GamSplines.ThinPlateRegressionUtils;
import hex.glm.GLMModel;
import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import water.DKV;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.Scope;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class GamUtils {
    public static double[][][] allocate3DArrayCS(int num2DArrays, GAMModel.GAMParameters parms, AllocateType fileMode) {
        double[][][] array3D = new double[num2DArrays][][];
        int gamColCount = 0;
        for (int frameIdx = 0; frameIdx < num2DArrays; ++frameIdx) {
            if (parms._gam_columns_sorted[frameIdx].length != 1) continue;
            int numKnots = parms._num_knots_sorted[frameIdx];
            array3D[gamColCount++] = GamUtils.allocate2DArray(fileMode, numKnots);
        }
        return array3D;
    }

    public static double[][][] allocate3DArray(int num2DArrays, GAMModel.GAMParameters parms, AllocateType fileMode) {
        double[][][] array3D = new double[num2DArrays][][];
        for (int frameIdx = 0; frameIdx < num2DArrays; ++frameIdx) {
            array3D[frameIdx] = GamUtils.allocate2DArray(fileMode, parms._num_knots_sorted[frameIdx]);
        }
        return array3D;
    }

    public static double[][][] allocate3DArrayTP(int num2DArrays, GAMModel.GAMParameters parms, int[] secondDim, int[] thirdDim) {
        double[][][] array3D = new double[num2DArrays][][];
        int gamColCount = 0;
        int numGamCols = parms._gam_columns.length;
        for (int frameIdx = 0; frameIdx < numGamCols; ++frameIdx) {
            if (parms._bs_sorted[frameIdx] != 1) continue;
            array3D[gamColCount] = MemoryManager.malloc8d((int)secondDim[gamColCount], (int)thirdDim[gamColCount]);
            ++gamColCount;
        }
        return array3D;
    }

    public static double[][] allocate2DArray(AllocateType fileMode, int numKnots) {
        double[][] array2D;
        switch (fileMode) {
            case firstOneLess: {
                array2D = MemoryManager.malloc8d((int)(numKnots - 1), (int)numKnots);
                break;
            }
            case sameOrig: {
                array2D = MemoryManager.malloc8d((int)numKnots, (int)numKnots);
                break;
            }
            case bothOneLess: {
                array2D = MemoryManager.malloc8d((int)(numKnots - 1), (int)(numKnots - 1));
                break;
            }
            case firstTwoLess: {
                array2D = MemoryManager.malloc8d((int)(numKnots - 2), (int)numKnots);
                break;
            }
            default: {
                throw new IllegalArgumentException("fileMode can only be firstOneLess, sameOrig, bothOneLess or firstTwoLess.");
            }
        }
        return array2D;
    }

    public static Integer[] sortCoeffMags(int arrayLength, final double[] coeffMags) {
        Integer[] indices = new Integer[arrayLength];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        Arrays.sort(indices, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (coeffMags[o1] < coeffMags[o2]) {
                    return 1;
                }
                if (coeffMags[o1] > coeffMags[o2]) {
                    return -1;
                }
                return 0;
            }
        });
        return indices;
    }

    public static boolean equalColNames(String[] name1, String[] standardN, String response_column) {
        boolean equalNames;
        boolean name1ContainsResp = ArrayUtils.contains((Object[])name1, (Object)response_column);
        boolean standarNContainsResp = ArrayUtils.contains((Object[])standardN, (Object)response_column);
        boolean bl = equalNames = name1.length == standardN.length;
        if (name1ContainsResp && !standarNContainsResp) {
            equalNames = name1.length == standardN.length + 1;
        } else if (!name1ContainsResp && standarNContainsResp) {
            boolean bl2 = equalNames = name1.length + 1 == standardN.length;
        }
        if (equalNames) {
            for (String name : name1) {
                if (name == response_column || ArrayUtils.contains((Object[])standardN, (Object)name)) continue;
                return false;
            }
            return true;
        }
        return equalNames;
    }

    public static void copy2DArray(double[][] src_array, double[][] dest_array) {
        int numRows = src_array.length;
        for (int colIdx = 0; colIdx < numRows; ++colIdx) {
            System.arraycopy(src_array[colIdx], 0, dest_array[colIdx], 0, src_array[colIdx].length);
        }
    }

    public static void copy2DArray(int[][] src_array, int[][] dest_array) {
        int numRows = src_array.length;
        for (int colIdx = 0; colIdx < numRows; ++colIdx) {
            System.arraycopy(src_array[colIdx], 0, dest_array[colIdx], 0, src_array[colIdx].length);
        }
    }

    public static GLMModel.GLMParameters copyGAMParams2GLMParams(GAMModel.GAMParameters parms, Frame trainData, Frame valid) {
        GLMModel.GLMParameters glmParam = new GLMModel.GLMParameters();
        Field[] field1 = GAMModel.GAMParameters.class.getDeclaredFields();
        GamUtils.setParamField(parms, glmParam, false, field1);
        Field[] field2 = Model.Parameters.class.getDeclaredFields();
        GamUtils.setParamField(parms, glmParam, true, field2);
        glmParam._train = trainData._key;
        glmParam._valid = valid == null ? null : valid._key;
        glmParam._nfolds = 0;
        glmParam._fold_assignment = Model.Parameters.FoldAssignmentScheme.AUTO;
        glmParam._keep_cross_validation_fold_assignment = false;
        glmParam._keep_cross_validation_models = false;
        glmParam._keep_cross_validation_predictions = false;
        glmParam._is_cv_model = false;
        return glmParam;
    }

    public static void setParamField(GAMModel.GAMParameters parms, GLMModel.GLMParameters glmParam, boolean superClassParams, Field[] gamFields) {
        List<String> gamOnlyList = Arrays.asList("_num_knots", "_gam_columns", "_bs", "_scale", "_train", "_saveZMatrix", "_saveGamCols", "_savePenaltyMat");
        for (Field oneField : gamFields) {
            try {
                if (gamOnlyList.contains(oneField.getName())) continue;
                Field glmField = superClassParams ? ((Object)((Object)glmParam)).getClass().getSuperclass().getDeclaredField(oneField.getName()) : ((Object)((Object)glmParam)).getClass().getDeclaredField(oneField.getName());
                glmField.set((Object)glmParam, oneField.get((Object)parms));
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public static void keepFrameKeys(List<Key<Vec>> keep, Key<Frame> ... keyNames) {
        for (Key<Frame> keyName : keyNames) {
            Frame loadingFrm = (Frame)DKV.getGet(keyName);
            if (loadingFrm == null) continue;
            for (Vec vec : loadingFrm.vecs()) {
                keep.add((Key<Vec>)vec._key);
            }
        }
    }

    public static void setDefaultBSType(GAMModel.GAMParameters parms) {
        parms._bs = new int[parms._gam_columns.length];
        for (int index = 0; index < parms._bs.length; ++index) {
            parms._bs[index] = parms._gam_columns[index].length > 1 ? 1 : 0;
        }
    }

    public static void setThinPlateParameters(GAMModel.GAMParameters parms, int thinPlateNum) {
        int numGamCols = parms._gam_columns.length;
        parms._m = MemoryManager.malloc4((int)thinPlateNum);
        parms._M = MemoryManager.malloc4((int)thinPlateNum);
        int countThinPlate = 0;
        for (int index = 0; index < numGamCols; ++index) {
            if (parms._bs[index] != 1) continue;
            int d = parms._gam_columns[index].length;
            parms._m[countThinPlate] = ThinPlateRegressionUtils.calculatem(d);
            parms._M[countThinPlate] = ThinPlateRegressionUtils.calculateM(d, parms._m[countThinPlate]);
            ++countThinPlate;
        }
    }

    public static void setGamPredSize(GAMModel.GAMParameters parms, int csOffset) {
        int numGamCols = parms._gam_columns.length;
        int tpCount = csOffset;
        int csCount = 0;
        parms._gamPredSize = MemoryManager.malloc4((int)numGamCols);
        for (int index = 0; index < numGamCols; ++index) {
            if (parms._gam_columns[index].length == 1) {
                parms._gamPredSize[csCount++] = 1;
                continue;
            }
            parms._gamPredSize[tpCount++] = parms._gam_columns[index].length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] generateKnotsOneColumn(Frame gamFrame, int knotNum) {
        double[] knots = MemoryManager.malloc8d((int)knotNum);
        try {
            Scope.enter();
            Frame tempFrame = new Frame(gamFrame);
            DKV.put((Keyed)tempFrame);
            double[] prob = MemoryManager.malloc8d((int)knotNum);
            assert (knotNum > 1);
            double stepProb = 1.0 / (double)(knotNum - 1);
            for (int knotInd = 0; knotInd < knotNum; ++knotInd) {
                prob[knotInd] = (double)knotInd * stepProb;
            }
            QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
            parms._train = tempFrame._key;
            parms._probs = prob;
            QuantileModel qModel = (QuantileModel)new Quantile(parms).trainModel().get();
            DKV.remove((Key)tempFrame._key);
            Scope.track_generic((Keyed)qModel);
            System.arraycopy(((QuantileModel.QuantileOutput)qModel._output)._quantiles[0], 0, knots, 0, knotNum);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
        return knots;
    }

    public static Frame prepareGamVec(int gam_column_index, GAMModel.GAMParameters parms, Frame fr) {
        Vec weights_column = parms._weights_column == null ? Scope.track((Vec)Vec.makeOne((long)fr.numRows())) : Scope.track((Vec)fr.vec(parms._weights_column));
        Frame predictVec = new Frame(new Vec[0]);
        int numPredictors = parms._gam_columns_sorted[gam_column_index].length;
        for (int colInd = 0; colInd < numPredictors; ++colInd) {
            predictVec.add(parms._gam_columns_sorted[gam_column_index][colInd], fr.vec(parms._gam_columns_sorted[gam_column_index][colInd]));
        }
        predictVec.add("weights_column", weights_column);
        return predictVec;
    }

    public static String[] generateGamColNames(int gam_col_index, GAMModel.GAMParameters parms) {
        String[] newColNames = new String[parms._num_knots_sorted[gam_col_index]];
        StringBuffer nameStub = new StringBuffer();
        int numPredictors = parms._gam_columns_sorted[gam_col_index].length;
        for (int predInd = 0; predInd < numPredictors; ++predInd) {
            nameStub.append(parms._gam_columns_sorted[gam_col_index][predInd] + "_");
        }
        String stubName = nameStub.toString();
        for (int knotIndex = 0; knotIndex < parms._num_knots_sorted[gam_col_index]; ++knotIndex) {
            newColNames[knotIndex] = stubName + knotIndex;
        }
        return newColNames;
    }

    public static String[] generateGamColNamesThinPlateKnots(int gamColIndex, GAMModel.GAMParameters parms, int[][] polyBasisDegree, String nameStub) {
        int index;
        int num_knots = parms._num_knots_sorted[gamColIndex];
        int polyBasisSize = polyBasisDegree.length;
        String[] gamColNames = new String[num_knots + polyBasisSize];
        for (index = 0; index < num_knots; ++index) {
            gamColNames[index] = nameStub + index;
        }
        for (index = 0; index < polyBasisSize; ++index) {
            gamColNames[index + num_knots] = GamUtils.genPolyBasisNames(parms._gam_columns_sorted[gamColIndex], polyBasisDegree[index]);
        }
        return gamColNames;
    }

    public static String genPolyBasisNames(String[] gam_columns, int[] oneBasis) {
        StringBuffer polyBasisName = new StringBuffer();
        int numGamCols = gam_columns.length;
        int beforeLastIndex = numGamCols - 1;
        for (int index = 0; index < numGamCols; ++index) {
            polyBasisName.append(gam_columns[index]);
            polyBasisName.append("_");
            polyBasisName.append(oneBasis[index]);
            if (index >= beforeLastIndex) continue;
            polyBasisName.append("_");
        }
        return polyBasisName.toString();
    }

    public static Frame buildGamFrame(GAMModel.GAMParameters parms, Frame train, Key<Frame>[] gamFrameKeysCenter) {
        Vec responseVec = train.remove(parms._response_column);
        Vec weightsVec = null;
        if (parms._weights_column != null) {
            weightsVec = Scope.track((Vec)train.remove(parms._weights_column));
        }
        for (int colIdx = 0; colIdx < parms._gam_columns_sorted.length; ++colIdx) {
            Frame gamFrame = Scope.track((Frame[])new Frame[]{(Frame)gamFrameKeysCenter[colIdx].get()});
            train.add(gamFrame.names(), gamFrame.removeAll());
            train.remove(parms._gam_columns_sorted[colIdx]);
        }
        if (weightsVec != null) {
            train.add(parms._weights_column, weightsVec);
        }
        if (responseVec != null) {
            train.add(parms._response_column, responseVec);
        }
        return train;
    }

    public static Frame concateGamVecs(Key<Frame>[] gamFrameKeysCenter) {
        Frame gamVecs = new Frame(Key.make());
        for (int index = 0; index < gamFrameKeysCenter.length; ++index) {
            Frame tempCols = Scope.track((Frame[])new Frame[]{(Frame)gamFrameKeysCenter[index].get()});
            gamVecs.add(tempCols.names(), tempCols.removeAll());
        }
        return gamVecs;
    }

    public static void sortGAMParameters(GAMModel.GAMParameters parms, int csNum, int tpNum) {
        int gamColNum = parms._gam_columns.length;
        int csIndex = 0;
        int tpIndex = csNum;
        parms._gam_columns_sorted = new String[gamColNum][];
        parms._num_knots_sorted = MemoryManager.malloc4((int)gamColNum);
        parms._scale_sorted = MemoryManager.malloc8d((int)gamColNum);
        parms._bs_sorted = MemoryManager.malloc4((int)gamColNum);
        parms._gamPredSize = MemoryManager.malloc4((int)gamColNum);
        for (int index = 0; index < gamColNum; ++index) {
            if (parms._bs[index] == 0) {
                parms._gam_columns_sorted[csIndex] = (String[])parms._gam_columns[index].clone();
                parms._num_knots_sorted[csIndex] = parms._num_knots[index];
                parms._scale_sorted[csIndex] = parms._scale[index];
                parms._gamPredSize[csIndex] = parms._gam_columns_sorted[csIndex].length;
                parms._bs_sorted[csIndex++] = parms._bs[index];
                continue;
            }
            parms._gam_columns_sorted[tpIndex] = (String[])parms._gam_columns[index].clone();
            parms._num_knots_sorted[tpIndex] = parms._num_knots[index];
            parms._scale_sorted[tpIndex] = parms._scale[index];
            parms._gamPredSize[tpIndex] = parms._gam_columns_sorted[tpIndex].length;
            parms._bs_sorted[tpIndex++] = parms._bs[index];
        }
    }

    public static void setDefaultScale(GAMModel.GAMParameters parms) {
        int numGamCol = parms._gam_columns.length;
        parms._scale = new double[numGamCol];
        for (int index = 0; index < numGamCol; ++index) {
            parms._scale[index] = 1.0;
        }
    }

    public static enum AllocateType {
        firstOneLess,
        sameOrig,
        bothOneLess,
        firstTwoLess;

    }
}

