/*
 * Decompiled with CFR 0.152.
 */
package hex.generic;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.generic.GenericModel;
import hex.generic.GenericModelOutput;
import hex.generic.GenericModelParameters;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.MojoReaderBackendFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import water.H2O;
import water.Key;
import water.fvec.ByteVec;
import water.fvec.Frame;
import water.util.Log;

public class Generic
extends ModelBuilder<GenericModel, GenericModelParameters, GenericModelOutput> {
    private static final Set<String> ALLOWED_MOJO_ALGOS;

    public Generic(GenericModelParameters genericParameters) {
        super((Model.Parameters)genericParameters);
        this.init(false);
    }

    public Generic(boolean startup_once) {
        super((Model.Parameters)new GenericModelParameters(), startup_once);
    }

    protected ModelBuilder.Driver trainModelImpl() {
        return new MojoDelegatingModelDriver();
    }

    public ModelCategory[] can_build() {
        return ModelCategory.values();
    }

    public boolean haveMojo() {
        return true;
    }

    public boolean isSupervised() {
        return false;
    }

    private Key<Frame> importFile() {
        ArrayList files = new ArrayList();
        ArrayList keys = new ArrayList();
        ArrayList fails = new ArrayList();
        ArrayList dels = new ArrayList();
        H2O.getPM().importFiles(((GenericModelParameters)this._parms)._path, null, files, keys, fails, dels);
        if (!fails.isEmpty()) {
            throw new RuntimeException("Failed to import file: " + Arrays.toString(fails.toArray()));
        }
        assert (keys.size() == 1);
        return Key.make((String)((String)keys.get(0)));
    }

    private ByteVec getUploadedMojo(Key<Frame> key) throws IllegalArgumentException {
        Objects.requireNonNull(key);
        Frame mojoFrame = (Frame)key.get();
        if (mojoFrame.numCols() > 1) {
            throw new IllegalArgumentException(String.format("Given MOJO frame with key '%s' should contain only 1 column with MOJO bytes. More columns found. Incorrect key provided ?", key));
        }
        ByteVec mojoData = (ByteVec)mojoFrame.anyVec();
        if (mojoData.length() < 1L) {
            throw new IllegalArgumentException(String.format("Given MOJO frame with key '%s' is empty (0 bytes). Please provide a non-empty MOJO file.", key));
        }
        return mojoData;
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    public static GenericModel importMojoModel(String location, boolean disableAlgoCheck) {
        GenericModelParameters p = new GenericModelParameters();
        p._path = location;
        p._disable_algo_check = disableAlgoCheck;
        return (GenericModel)new Generic(p).trainModel().get();
    }

    static {
        HashSet<String> allowedAlgos = new HashSet<String>(6);
        allowedAlgos.add("gbm");
        allowedAlgos.add("glm");
        allowedAlgos.add("xgboost");
        allowedAlgos.add("isolationforest");
        allowedAlgos.add("drf");
        allowedAlgos.add("deeplearning");
        allowedAlgos.add("stackedensemble");
        allowedAlgos.add("coxph");
        ALLOWED_MOJO_ALGOS = Collections.unmodifiableSet(allowedAlgos);
    }

    class MojoDelegatingModelDriver
    extends ModelBuilder.Driver {
        MojoDelegatingModelDriver() {
            super((ModelBuilder)Generic.this);
        }

        public void compute2() {
            if (((GenericModelParameters)Generic.this._parms)._path != null) {
                ((GenericModelParameters)Generic.this._parms)._model_key = Generic.this.importFile();
            }
            super.compute2();
        }

        public void computeImpl() {
            if (((GenericModelParameters)Generic.this._parms)._model_key == null) {
                throw new IllegalArgumentException("Either MOJO zip path or key to the uploaded MOJO frame must be specified");
            }
            Key<Frame> dataKey = ((GenericModelParameters)Generic.this._parms)._model_key;
            ByteVec mojoBytes = Generic.this.getUploadedMojo((Key<Frame>)dataKey);
            try {
                MojoReaderBackend readerBackend = MojoReaderBackendFactory.createReaderBackend((InputStream)mojoBytes.openStream(Generic.this._job._key), (MojoReaderBackendFactory.CachingStrategy)MojoReaderBackendFactory.CachingStrategy.MEMORY);
                MojoModel mojoModel = ModelMojoReader.readFrom((MojoReaderBackend)readerBackend, (boolean)true);
                if (!ALLOWED_MOJO_ALGOS.contains(mojoModel._modelDescriptor.algoName().toLowerCase())) {
                    if (((GenericModelParameters)Generic.this._parms)._disable_algo_check) {
                        Log.warn((Object[])new Object[]{String.format("MOJO model '%s' is not supported but user disabled white-list check. Trying to load anyway.", mojoModel._modelDescriptor.algoName())});
                    } else {
                        throw new IllegalArgumentException(String.format("Unsupported MOJO model '%s'. ", mojoModel._modelDescriptor.algoName()));
                    }
                }
                GenericModelOutput genericModelOutput = new GenericModelOutput(mojoModel._modelDescriptor, mojoModel._modelAttributes, mojoModel._reproducibilityInformation);
                GenericModel genericModel = new GenericModel((Key<GenericModel>)Generic.this._result, (GenericModelParameters)Generic.this._parms, genericModelOutput, mojoModel, dataKey);
                genericModel.write_lock(Generic.this._job);
                genericModel.unlock(Generic.this._job);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unreachable MOJO file: " + dataKey, e);
            }
        }
    }
}

