/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.glm.GLM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import water.MemoryManager;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.TwoDimTable;

public class GLMUtils {
    public static int[][] extractAdaptedFrameIndices(Frame adaptFrame, String[][] gamColnames, int numOffset) {
        String[] frameNames = adaptFrame.names();
        ArrayList<String> allColNames = new ArrayList<String>();
        for (String name : frameNames) {
            allColNames.add(name);
        }
        int[][] gamColIndices = new int[gamColnames.length][];
        int numFrame = gamColnames.length;
        for (int frameNum = 0; frameNum < numFrame; ++frameNum) {
            int numCols = gamColnames[frameNum].length;
            gamColIndices[frameNum] = MemoryManager.malloc4((int)numCols);
            for (int index = 0; index < numCols; ++index) {
                gamColIndices[frameNum][index] = numOffset + allColNames.indexOf(gamColnames[frameNum][index]);
            }
        }
        return gamColIndices;
    }

    public static GLM.GLMGradientInfo copyGInfo(GLM.GLMGradientInfo ginfo) {
        double[] gradient = (double[])ginfo._gradient.clone();
        GLM.GLMGradientInfo tempGinfo = new GLM.GLMGradientInfo(ginfo._likelihood, ginfo._objVal, gradient);
        return tempGinfo;
    }

    public static TwoDimTable combineScoringHistory(TwoDimTable glmSc1, TwoDimTable earlyStopSc2) {
        String[] esColTypes = earlyStopSc2.getColTypes();
        String[] esColFormats = earlyStopSc2.getColFormats();
        ArrayList<String> finalColHeaders = new ArrayList<String>(Arrays.asList(glmSc1.getColHeaders()));
        ArrayList<String> earlyStopScHeaders = new ArrayList<String>(Arrays.asList(earlyStopSc2.getColHeaders()));
        int overlapSize = 3;
        int earlyStopSCIterIndex = earlyStopScHeaders.indexOf("Iterations");
        int indexOfIter = finalColHeaders.indexOf("iteration");
        if (indexOfIter < 0) {
            indexOfIter = finalColHeaders.indexOf("iterations");
        }
        ArrayList<String> finalColTypes = new ArrayList<String>(Arrays.asList(glmSc1.getColTypes()));
        ArrayList<String> finalColFormats = new ArrayList<String>(Arrays.asList(glmSc1.getColFormats()));
        ArrayList<Integer> earlyStopColIndices = new ArrayList<Integer>();
        int colCounter = 0;
        for (String colName : earlyStopSc2.getColHeaders()) {
            if (!finalColHeaders.contains(colName.toLowerCase())) {
                finalColHeaders.add(colName);
                finalColTypes.add(esColTypes[colCounter]);
                finalColFormats.add(esColFormats[colCounter]);
                earlyStopColIndices.add(colCounter);
            }
            ++colCounter;
        }
        int tableSize = finalColHeaders.size();
        String[] rowHeaders = GLMUtils.generateRowHeaders(glmSc1, earlyStopSc2, indexOfIter, earlyStopSCIterIndex);
        TwoDimTable res = new TwoDimTable("Scoring History", "", rowHeaders, finalColHeaders.toArray(new String[tableSize]), finalColTypes.toArray(new String[tableSize]), finalColFormats.toArray(new String[tableSize]), "");
        res = GLMUtils.combineTableContents(glmSc1, earlyStopSc2, res, earlyStopColIndices, indexOfIter, earlyStopSCIterIndex, 3);
        return res;
    }

    public static String[] generateRowHeaders(TwoDimTable glmSc1, TwoDimTable earlyStopSc2, int glmIterIndex, int earlyStopIterIndex) {
        int index;
        int glmRowSize = glmSc1.getRowDim();
        int earlyStopRowSize = earlyStopSc2.getRowDim();
        ArrayList<Integer> iterList = new ArrayList<Integer>();
        for (index = 0; index < glmRowSize; ++index) {
            iterList.add((Integer)glmSc1.get(index, glmIterIndex));
        }
        for (index = 0; index < earlyStopRowSize; ++index) {
            Integer iter = (Integer)earlyStopSc2.get(index, earlyStopIterIndex);
            if (iterList.contains(iter)) continue;
            iterList.add(iter);
        }
        String[] rowHeader = new String[iterList.size()];
        for (int index2 = 0; index2 < rowHeader.length; ++index2) {
            rowHeader[index2] = "";
        }
        return rowHeader;
    }

    public static TwoDimTable combineTableContents(TwoDimTable glmSc1, TwoDimTable earlyStopSc2, TwoDimTable combined, List<Integer> earlyStopColIndices, int indexOfIter, int indexOfIterEarlyStop, int overlapSize) {
        int iter;
        int index;
        int rowSize = glmSc1.getRowDim();
        int rowSize2 = earlyStopSc2.getRowDim();
        int glmColSize = glmSc1.getColDim();
        int earlyStopColSize = earlyStopColIndices.size();
        int sc2RowIndex = 0;
        int glmRowIndex = 0;
        int rowIndex = 0;
        ArrayList<Integer> iterRecorded = new ArrayList<Integer>();
        while (sc2RowIndex < rowSize2 && glmRowIndex < rowSize) {
            int earlyStopScIter;
            int glmScIter = (Integer)glmSc1.get(glmRowIndex, indexOfIter);
            if (glmScIter == (earlyStopScIter = ((Integer)earlyStopSc2.get(sc2RowIndex, indexOfIterEarlyStop)).intValue())) {
                if (!iterRecorded.contains(glmScIter)) {
                    GLMUtils.addOneRow2ScoringHistory(glmSc1, earlyStopSc2, glmColSize, earlyStopColSize, glmRowIndex, sc2RowIndex, rowIndex, true, true, earlyStopColIndices, combined, overlapSize);
                    iterRecorded.add(glmScIter);
                }
                ++sc2RowIndex;
                ++glmRowIndex;
            } else if (glmScIter < earlyStopScIter) {
                if (!iterRecorded.contains(glmScIter)) {
                    GLMUtils.addOneRow2ScoringHistory(glmSc1, earlyStopSc2, glmColSize, earlyStopColSize, glmRowIndex, sc2RowIndex, rowIndex, true, false, earlyStopColIndices, combined, overlapSize);
                    iterRecorded.add(glmScIter);
                }
                ++glmRowIndex;
            } else if (glmScIter > earlyStopScIter) {
                if (!iterRecorded.contains(earlyStopScIter)) {
                    GLMUtils.addOneRow2ScoringHistory(glmSc1, earlyStopSc2, glmColSize, earlyStopColSize, glmRowIndex, sc2RowIndex, rowIndex, false, true, earlyStopColIndices, combined, overlapSize);
                    iterRecorded.add(earlyStopScIter);
                }
                ++sc2RowIndex;
            }
            ++rowIndex;
        }
        for (index = glmRowIndex; index < rowSize; ++index) {
            iter = (Integer)glmSc1.get(index, indexOfIter);
            if (iterRecorded.contains(iter) || (Integer)iterRecorded.get(iterRecorded.size() - 1) >= iter) continue;
            GLMUtils.addOneRow2ScoringHistory(glmSc1, earlyStopSc2, glmColSize, earlyStopColSize, index, -1, rowIndex++, true, false, earlyStopColIndices, combined, overlapSize);
            iterRecorded.add(iter);
        }
        for (index = sc2RowIndex; index < rowSize2; ++index) {
            iter = (Integer)earlyStopSc2.get(index, indexOfIterEarlyStop);
            if (iterRecorded.contains(iter) || (Integer)iterRecorded.get(iterRecorded.size() - 1) >= iter) continue;
            GLMUtils.addOneRow2ScoringHistory(glmSc1, earlyStopSc2, glmColSize, earlyStopColSize, -1, index, rowIndex++, false, true, earlyStopColIndices, combined, overlapSize);
            iterRecorded.add(iter);
        }
        return combined;
    }

    public static void addOneRow2ScoringHistory(TwoDimTable glmSc1, TwoDimTable earlyStopSc2, int glmColSize, int earlyStopColSize, int glmRowIndex, int earlyStopRowIndex, int rowIndex, boolean addGlmSC, boolean addEarlyStopSC, List<Integer> earlyStopColIndices, TwoDimTable combined, int overlapSize) {
        if (addGlmSC) {
            for (int glmIndex = 0; glmIndex < glmColSize; ++glmIndex) {
                combined.set(rowIndex, glmIndex, glmSc1.get(glmRowIndex, glmIndex));
            }
        }
        if (addEarlyStopSC) {
            for (int earlyStopIndex = 0; earlyStopIndex < earlyStopColSize; ++earlyStopIndex) {
                if (!addGlmSC && earlyStopIndex < overlapSize) {
                    combined.set(rowIndex, earlyStopIndex, earlyStopSc2.get(earlyStopRowIndex, earlyStopIndex));
                }
                combined.set(rowIndex, earlyStopIndex + glmColSize, earlyStopSc2.get(earlyStopRowIndex, earlyStopColIndices.get(earlyStopIndex).intValue()));
            }
        }
    }

    public static void updateGradGam(double[] gradient, double[][][] penalty_mat, int[][] gamBetaIndices, double[] beta, int[] activeCols) {
        int numGamCol = gamBetaIndices.length;
        for (int gamColInd = 0; gamColInd < numGamCol; ++gamColInd) {
            int penaltyMatSize = penalty_mat[gamColInd].length;
            for (int betaInd = 0; betaInd < penaltyMatSize; ++betaInd) {
                int currentBetaIndex = gamBetaIndices[gamColInd][betaInd];
                if (activeCols != null) {
                    currentBetaIndex = ArrayUtils.find((int[])activeCols, (int)currentBetaIndex);
                }
                if (currentBetaIndex < 0) continue;
                double tempGrad = 2.0 * beta[currentBetaIndex] * penalty_mat[gamColInd][betaInd][betaInd];
                for (int rowInd = 0; rowInd < penaltyMatSize; ++rowInd) {
                    if (rowInd == betaInd) continue;
                    int currBetaInd = gamBetaIndices[gamColInd][rowInd];
                    if (activeCols != null) {
                        currBetaInd = ArrayUtils.find((int[])activeCols, (int)currBetaInd);
                    }
                    if (currBetaInd < 0) continue;
                    tempGrad += beta[currBetaInd] * penalty_mat[gamColInd][betaInd][rowInd];
                }
                int n = currentBetaIndex;
                gradient[n] = gradient[n] + tempGrad;
            }
        }
    }

    public static void updateGradGamMultinomial(double[][] gradient, double[][][] penaltyMat, int[][] gamBetaIndices, double[][] beta) {
        int numClass = beta[0].length;
        int numGamCol = gamBetaIndices.length;
        for (int classInd = 0; classInd < numClass; ++classInd) {
            for (int gamInd = 0; gamInd < numGamCol; ++gamInd) {
                int numKnots = gamBetaIndices[gamInd].length;
                for (int rowInd = 0; rowInd < numKnots; ++rowInd) {
                    double temp = 0.0;
                    int betaIndR = gamBetaIndices[gamInd][rowInd];
                    for (int colInd = 0; colInd < numKnots; ++colInd) {
                        int betaIndC = gamBetaIndices[gamInd][colInd];
                        temp += betaIndC == betaIndR ? 2.0 * penaltyMat[gamInd][rowInd][colInd] * beta[betaIndC][classInd] : penaltyMat[gamInd][rowInd][colInd] * beta[betaIndC][classInd];
                    }
                    double[] dArray = gradient[betaIndR];
                    int n = classInd;
                    dArray[n] = dArray[n] + temp;
                }
            }
        }
    }

    public static double calSmoothNess(double[] beta, double[][][] penaltyMatrix, int[][] gamColIndices) {
        int numGamCols = gamColIndices.length;
        double smoothval = 0.0;
        for (int gamCol = 0; gamCol < numGamCols; ++gamCol) {
            smoothval += ArrayUtils.innerProductPartial((double[])beta, (int[])gamColIndices[gamCol], (double[])ArrayUtils.multArrVecPartial((double[][])penaltyMatrix[gamCol], (double[])beta, (int[])gamColIndices[gamCol]));
        }
        return smoothval;
    }

    public static double calSmoothNess(double[][] beta, double[][][] penaltyMatrix, int[][] gamColIndices) {
        int numClass = beta.length;
        double smoothval = 0.0;
        for (int classInd = 0; classInd < numClass; ++classInd) {
            smoothval += GLMUtils.calSmoothNess(beta[classInd], penaltyMatrix, gamColIndices);
        }
        return smoothval;
    }
}

