/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.kmeans.AssignClusterTask;
import hex.kmeans.Edge;
import hex.kmeans.FindMinimalWeightTask;
import hex.kmeans.NodesEdgesObject;
import hex.kmeans.SpanningTree;
import water.fvec.Frame;
import water.fvec.Vec;

class KMeansSimplexSolver {
    public Frame _weights;
    public double _sumWeights;
    public boolean _hasWeightsColumn;
    public long _numberOfNonZeroWeightPoints;
    public int _constraintsLength;
    public long _numberOfPoints;
    public long _edgeSize;
    public long _nodeSize;
    public long _resultSize;
    public Vec.Reader _demandsReader;
    public Vec.Reader _capacitiesReader;
    public double _maxAbsDemand;
    public SpanningTree tree;

    public KMeansSimplexSolver(int[] constrains, Frame weights, double sumDistances, boolean hasWeights, long numberOfNonZeroWeightPoints) {
        this._numberOfPoints = weights.numRows();
        this._nodeSize = this._numberOfPoints + (long)constrains.length + 1L;
        this._edgeSize = this._numberOfPoints * (long)constrains.length + (long)constrains.length;
        this._constraintsLength = constrains.length;
        Vec demands = Vec.makeCon((double)0.0, (long)this._nodeSize, (byte)3);
        Vec capacities = Vec.makeCon((double)0.0, (long)(this._edgeSize + this._nodeSize), (byte)3);
        this._resultSize = this._numberOfPoints * (long)this._constraintsLength;
        this._hasWeightsColumn = hasWeights;
        this._numberOfNonZeroWeightPoints = numberOfNonZeroWeightPoints;
        this._weights = weights;
        this._sumWeights = sumDistances;
        long constraintsSum = 0L;
        this._maxAbsDemand = Double.MIN_VALUE;
        Vec.Writer demandWriter = demands.open();
        for (long i = 0L; i < this._nodeSize; ++i) {
            long tmpDemand;
            if (i < this._numberOfPoints) {
                demandWriter.set(i, -1L);
                continue;
            }
            if (i < this._nodeSize - 1L) {
                tmpDemand = constrains[(int)(i - this._numberOfPoints)];
                constraintsSum += (long)constrains[(int)(i - this._numberOfPoints)];
            } else {
                tmpDemand = this._numberOfNonZeroWeightPoints - constraintsSum;
            }
            demandWriter.set(i, tmpDemand);
            if (!((double)Math.abs(tmpDemand) > this._maxAbsDemand)) continue;
            this._maxAbsDemand = Math.abs(tmpDemand);
        }
        demandWriter.close();
        int edgeIndexStart = this._weights.numCols() - 3 - this._constraintsLength;
        long edgeIndex = 0L;
        for (long i = 0L; i < this._weights.numRows(); ++i) {
            for (int j = 0; j < this._constraintsLength; ++j) {
                this._weights.vec(edgeIndexStart + j).set(i, edgeIndex++);
            }
        }
        Vec.Writer capacitiesWriter = capacities.open();
        for (long i = 0L; i < this._edgeSize; ++i) {
            capacitiesWriter.set(i, Long.MAX_VALUE);
        }
        double maxCapacity = 3.0 * (this._sumWeights > this._maxAbsDemand ? this._sumWeights : this._maxAbsDemand);
        for (long i = 0L; i < this._nodeSize; ++i) {
            capacitiesWriter.set(i + this._edgeSize, maxCapacity);
        }
        capacitiesWriter.close();
        this._capacitiesReader = new Vec.Reader(capacities);
        this._demandsReader = new Vec.Reader(demands);
        this.tree = new SpanningTree(this._nodeSize, this._edgeSize, this._constraintsLength);
        this.tree.init(this._numberOfPoints, maxCapacity, demands);
    }

    public double getWeight(long edgeIndex) {
        long numberOfFrameWeights = this._numberOfPoints * (long)this._constraintsLength;
        if (edgeIndex < numberOfFrameWeights) {
            int i = this._weights.numCols() - 2 * this._constraintsLength - 3 + (int)(edgeIndex % (long)this._constraintsLength);
            long j = Math.round(edgeIndex / (long)this._constraintsLength);
            return this._weights.vec(i).at(j);
        }
        return 0.0;
    }

    public boolean isNonZeroWeight(long edgeIndex) {
        long numberOfFrameWeights;
        if (this._hasWeightsColumn && edgeIndex < (numberOfFrameWeights = this._numberOfPoints * (long)this._constraintsLength)) {
            long i = Math.round(edgeIndex / (long)this._constraintsLength);
            int j = this._weights.numCols() - 1 - 2 * this._constraintsLength - 3;
            return this._weights.vec(j).at8(i) == 1L;
        }
        return true;
    }

    public long findMinimalReducedWeight() {
        long additiveEdgesIndexStart;
        FindMinimalWeightTask t = (FindMinimalWeightTask)new FindMinimalWeightTask(this.tree, this._hasWeightsColumn, this._constraintsLength).doAll(this._weights);
        double minimalWeight = t.minimalWeight;
        long minimalIndex = t.minimalIndex;
        for (long i = additiveEdgesIndexStart = this._weights.vec(0).length() * (long)this._constraintsLength; i < this._edgeSize; ++i) {
            boolean countValue;
            double tmpWeight = this.tree.reduceWeight(i, this.getWeight(i));
            boolean bl = countValue = !this._hasWeightsColumn || this.isNonZeroWeight(i);
            if (!countValue || !(tmpWeight < minimalWeight)) continue;
            minimalWeight = tmpWeight;
            minimalIndex = i;
        }
        return minimalIndex;
    }

    public Edge findNextEnteringEdge() {
        if (!this.tree.areConstraintsSatisfied()) {
            long minimalIndex = this.findMinimalReducedWeight();
            if (this.tree.getFlowByEdgeIndex(minimalIndex) == 0L) {
                return new Edge(minimalIndex, this.tree._sources.at8(minimalIndex), this.tree._targets.at8(minimalIndex));
            }
            return new Edge(minimalIndex, this.tree._targets.at8(minimalIndex), this.tree._sources.at8(minimalIndex));
        }
        return null;
    }

    public NodesEdgesObject getCycle(long edgeIndex, long sourceIndex, long targetIndex) {
        long ancestor = this.tree.findAncestor(sourceIndex, targetIndex);
        NodesEdgesObject resultPath = this.tree.getPath(sourceIndex, ancestor);
        resultPath.reverseNodes();
        resultPath.reverseEdges();
        if (resultPath.edgeSize() != 1 || resultPath.getEdge(0) != edgeIndex) {
            resultPath.addEdge(edgeIndex);
        }
        NodesEdgesObject resultPathBack = this.tree.getPath(targetIndex, ancestor);
        resultPathBack.removeLastNode();
        resultPath.addAllNodes(resultPathBack.getNodes());
        resultPath.addAllEdges(resultPathBack.getEdges());
        return resultPath;
    }

    public Edge getLeavingEdge(NodesEdgesObject cycle) {
        long nodeIndex;
        long edgeIndex;
        cycle.reverseNodes();
        cycle.reverseEdges();
        double minResidualCapacity = Double.MAX_VALUE;
        int minIndex = -1;
        for (int i = 0; i < cycle.edgeSize(); ++i) {
            boolean countValue;
            double tmpResidualCapacity = this.tree.getResidualCapacity(cycle.getEdge(i), cycle.getNode(i), this._capacitiesReader.at(cycle.getEdge(i)));
            boolean bl = countValue = !this._hasWeightsColumn || this.isNonZeroWeight(cycle.getEdge(i));
            if (!countValue || !(tmpResidualCapacity < minResidualCapacity)) continue;
            minResidualCapacity = tmpResidualCapacity;
            minIndex = i;
        }
        assert (minIndex != -1);
        return new Edge(edgeIndex, nodeIndex, (nodeIndex = cycle.getNode(minIndex)) == this.tree._sources.at8(edgeIndex = cycle.getEdge(minIndex)) ? this.tree._targets.at8(edgeIndex) : this.tree._sources.at8(edgeIndex));
    }

    public void calculateMinimalCostFlow() {
        Edge edge = this.findNextEnteringEdge();
        while (edge != null) {
            long enteringEdgeIndex = edge.getEdgeIndex();
            long enteringEdgeSourceIndex = edge.getSourceIndex();
            long enteringEdgeTargetIndex = edge.getTargetIndex();
            NodesEdgesObject cycle = this.getCycle(enteringEdgeIndex, enteringEdgeSourceIndex, enteringEdgeTargetIndex);
            Edge leavingEdge = this.getLeavingEdge(cycle);
            long leavingEdgeIndex = leavingEdge.getEdgeIndex();
            long leavingEdgeSourceIndex = leavingEdge.getSourceIndex();
            long leavingEdgeTargetIndex = leavingEdge.getTargetIndex();
            double residualCap = this.tree.getResidualCapacity(leavingEdgeIndex, leavingEdgeSourceIndex, this._capacitiesReader.at(leavingEdgeIndex));
            if (residualCap != 0.0) {
                this.tree.augmentFlow(cycle, residualCap);
            }
            if (enteringEdgeIndex != leavingEdgeIndex) {
                if (leavingEdgeSourceIndex != this.tree._parents.at8(leavingEdgeTargetIndex)) {
                    long tmpS = leavingEdgeSourceIndex;
                    leavingEdgeSourceIndex = leavingEdgeTargetIndex;
                    leavingEdgeTargetIndex = tmpS;
                }
                if (cycle.indexOfEdge(enteringEdgeIndex) < cycle.indexOfEdge(leavingEdgeIndex)) {
                    long tmpP = enteringEdgeSourceIndex;
                    enteringEdgeSourceIndex = enteringEdgeTargetIndex;
                    enteringEdgeTargetIndex = tmpP;
                }
                this.tree.removeParentEdge(leavingEdgeSourceIndex, leavingEdgeTargetIndex);
                this.tree.makeRoot(enteringEdgeTargetIndex);
                this.tree.addEdge(enteringEdgeIndex, enteringEdgeSourceIndex, enteringEdgeTargetIndex);
                this.tree.updatePotentials(enteringEdgeIndex, enteringEdgeSourceIndex, enteringEdgeTargetIndex, this.getWeight(enteringEdgeIndex));
            }
            edge = this.findNextEnteringEdge();
        }
    }

    public void checkConstraintsCondition(int[] numberOfPointsInCluster) {
        for (int i = 0; i < this._constraintsLength; ++i) {
            assert ((long)numberOfPointsInCluster[i] >= this._demandsReader.at8(this._numberOfPoints + (long)i)) : String.format("Cluster %d has %d assigned points however should has assigned at least %d points.", i + 1, numberOfPointsInCluster[i], this._demandsReader.at8(this._numberOfPoints + (long)i));
        }
    }

    public Frame assignClusters() {
        int i;
        this.calculateMinimalCostFlow();
        this._weights = this._weights.add(new Frame(this.tree._edgeFlowDataPoints));
        int dataStopLength = this._weights.numCols() - (this._hasWeightsColumn ? 1 : 0) - 3 * this._constraintsLength - 3;
        AssignClusterTask task = new AssignClusterTask(this._constraintsLength, this._hasWeightsColumn, this._weights.numCols());
        task.doAll(this._weights);
        this.checkConstraintsCondition(task._numberOfPointsInCluster);
        for (i = 0; i < 2 * this._constraintsLength; ++i) {
            this._weights.remove(dataStopLength + (this._hasWeightsColumn ? 1 : 0));
        }
        for (i = 0; i < this._constraintsLength; ++i) {
            this._weights.remove(this._weights.numCols() - 1);
        }
        return this._weights;
    }
}

