/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsSupervised;
import hex.genmodel.algos.psvm.KernelParameters;
import hex.genmodel.algos.psvm.KernelType;
import hex.genmodel.algos.psvm.ScorerFactory;
import hex.genmodel.algos.psvm.SupportVectorScorer;
import hex.psvm.BulkScorerFactory;
import hex.psvm.BulkSupportVectorScorer;
import hex.psvm.MetricBuilderPSVM;
import hex.psvm.PSVM;
import hex.psvm.psvm.Kernel;
import hex.psvm.psvm.KernelFactory;
import hex.psvm.psvm.PrimalDualIPM;
import java.util.Arrays;
import water.Futures;
import water.Key;
import water.Keyed;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.util.Log;

public class PSVMModel
extends Model<PSVMModel, PSVMParameters, PSVMModelOutput> {
    private transient SupportVectorScorer _scorer;

    public PSVMModel(Key<PSVMModel> selfKey, PSVMParameters params, PSVMModelOutput output) {
        super(selfKey, (Model.Parameters)params, (Model.Output)output);
        assert (Arrays.equals(this._key._kb, selfKey._kb));
    }

    ModelMetricsSupervised makeModelMetrics(Frame origFr, Frame adaptFr, String description) {
        Log.info((Object[])new Object[]{"Making metrics: " + description});
        ModelMetrics.MetricBuilder mb = this.scoreMetrics(adaptFr);
        ModelMetricsSupervised mm = (ModelMetricsSupervised)mb.makeModelMetrics((Model)this, origFr, adaptFr, null);
        mm._description = description;
        return mm;
    }

    protected double[] score0(double[] data, double[] preds) {
        double svScore = this.getScorer().score0(data);
        return this.makePreds(svScore, preds);
    }

    private double[] makePreds(double svScore, double[] preds) {
        double pred = svScore + ((PSVMModelOutput)this._output)._rho;
        int label = pred < 0.0 ? 0 : 1;
        preds[0] = label;
        preds[1 + label] = 1.0;
        preds[2 - label] = 0.0;
        return preds;
    }

    protected Model.BigScorePredict setupBigScorePredict(Model.BigScore bs) {
        BulkSupportVectorScorer bulkScorer = BulkScorerFactory.makeScorer(((PSVMParameters)this._parms)._kernel_type, ((PSVMParameters)this._parms).kernelParms(), ((PSVMModelOutput)this._output)._compressed_svs, (int)((PSVMModelOutput)this._output)._svs_count, true);
        return new SVMBigScorePredict(bulkScorer);
    }

    private SupportVectorScorer getScorer() {
        SupportVectorScorer svs = this._scorer;
        if (svs == null) {
            this._scorer = svs = ScorerFactory.makeScorer((KernelType)((PSVMParameters)this._parms)._kernel_type, (KernelParameters)((PSVMParameters)this._parms).kernelParms(), (byte[])((PSVMModelOutput)this._output)._compressed_svs);
        }
        return svs;
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new MetricBuilderPSVM(domain);
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        Keyed.remove(((PSVMModelOutput)this._output)._alpha_key, (Futures)fs, (boolean)true);
        return super.remove_impl(fs, cascade);
    }

    public static class PSVMModelOutput
    extends Model.Output {
        public long _svs_count;
        public long _bsv_count;
        public double _rho;
        public Key<Frame> _alpha_key;
        public byte[] _compressed_svs;

        PSVMModelOutput(PSVM b, Frame f, String[] respDomain) {
            super((ModelBuilder)b, f);
            String[] stringArray;
            int n = this._domains.length - 1;
            if (respDomain != null) {
                stringArray = respDomain;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "-1";
                stringArray = stringArray2;
                stringArray2[1] = "+1";
            }
            this._domains[n] = stringArray;
        }

        public ModelCategory getModelCategory() {
            return ModelCategory.Binomial;
        }
    }

    public static class PSVMParameters
    extends Model.Parameters {
        private static final PrimalDualIPM.Parms IPM_DEFAULTS = new PrimalDualIPM.Parms();
        public long _seed = -1L;
        public double _hyper_param = 1.0;
        public double _positive_weight = 1.0;
        public double _negative_weight = 1.0;
        public double _sv_threshold = 1.0E-4;
        public double _zero_threshold = 1.0E-9;
        public boolean _disable_training_metrics = true;
        public KernelType _kernel_type = KernelType.gaussian;
        public double _gamma = -1.0;
        public double _rank_ratio = -1.0;
        public double _fact_threshold = 1.0E-5;
        public int _max_iterations;
        public double _feasible_threshold;
        public double _surrogate_gap_threshold;
        public double _mu_factor;

        public PSVMParameters() {
            this._max_iterations = PSVMParameters.IPM_DEFAULTS._max_iter;
            this._feasible_threshold = PSVMParameters.IPM_DEFAULTS._feasible_threshold;
            this._surrogate_gap_threshold = PSVMParameters.IPM_DEFAULTS._feasible_threshold;
            this._mu_factor = PSVMParameters.IPM_DEFAULTS._mu_factor;
        }

        public String algoName() {
            return "PSVM";
        }

        public String fullName() {
            return "PSVM";
        }

        public String javaName() {
            return PSVMModel.class.getName();
        }

        public long progressUnits() {
            return 1L;
        }

        public Kernel kernel() {
            return KernelFactory.make(this._kernel_type, this.kernelParms());
        }

        KernelParameters kernelParms() {
            KernelParameters kp = new KernelParameters();
            kp._gamma = this._gamma;
            return kp;
        }

        PrimalDualIPM.Parms ipmParms() {
            PrimalDualIPM.Parms p = new PrimalDualIPM.Parms();
            p._max_iter = this._max_iterations;
            p._mu_factor = this._mu_factor;
            p._feasible_threshold = this._feasible_threshold;
            p._sgap_threshold = this._surrogate_gap_threshold;
            p._x_epsilon = this._zero_threshold;
            p._c_pos = this._hyper_param * this._positive_weight;
            p._c_neg = this._hyper_param * this._negative_weight;
            return p;
        }

        double c_pos() {
            return this._hyper_param * this._positive_weight;
        }

        double c_neg() {
            return this._hyper_param * this._negative_weight;
        }
    }

    private class SVMBigScoreChunkPredict
    implements Model.BigScoreChunkPredict {
        private final double[] _scores;

        private SVMBigScoreChunkPredict(double[] scores) {
            this._scores = scores;
        }

        public double[] score0(Chunk[] chks, double offset, int row_in_chunk, double[] tmp, double[] preds) {
            return PSVMModel.this.makePreds(this._scores[row_in_chunk], preds);
        }

        public void close() {
        }
    }

    private class SVMBigScorePredict
    implements Model.BigScorePredict {
        private BulkSupportVectorScorer _bulkScorer;

        SVMBigScorePredict(BulkSupportVectorScorer bulkScorer) {
            this._bulkScorer = bulkScorer;
        }

        public Model.BigScoreChunkPredict initMap(Frame fr, Chunk[] chks) {
            double[] scores = this._bulkScorer.bulkScore0(chks);
            return new SVMBigScoreChunkPredict(scores);
        }
    }
}

