/*
 * Decompiled with CFR 0.152.
 */
package hex.rulefit;

import water.Iced;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.parser.BufferedString;
import water.util.ArrayUtils;

public class Condition
extends Iced {
    int featureIndex;
    Type type;
    public Operator operator;
    public String featureName;
    public boolean NAsIncluded;
    public String languageCondition;
    public double numTreshold;
    public String[] languageCatTreshold;
    public int[] catTreshold;

    public Condition(int featureIndex, Type type, Operator operator, double numTreshold, String[] languageCatTreshold, int[] catTreshold, String featureName, boolean NAsIncluded) {
        this.featureIndex = featureIndex;
        this.type = type;
        this.operator = operator;
        this.featureName = featureName;
        this.NAsIncluded = NAsIncluded;
        this.numTreshold = numTreshold;
        this.languageCatTreshold = languageCatTreshold;
        this.catTreshold = catTreshold;
        this.languageCondition = this.constructLanguageCondition();
    }

    String constructLanguageCondition() {
        StringBuilder description = new StringBuilder();
        description.append("(").append(this.featureName);
        if (Operator.LessThan.equals((Object)this.operator)) {
            description.append(" < ").append(this.numTreshold);
        } else if (Operator.GreaterThanOrEqual.equals((Object)this.operator)) {
            description.append(" >= ").append(this.numTreshold);
        } else if (Operator.In.equals((Object)this.operator)) {
            description.append(" in {");
            for (int i = 0; i < this.languageCatTreshold.length; ++i) {
                if (i != 0) {
                    description.append(", ");
                }
                description.append(this.languageCatTreshold[i]);
            }
            description.append("}");
        }
        if (this.NAsIncluded) {
            description.append(" or ").append(this.featureName).append(" is NA");
        }
        description.append(")");
        return description.toString();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.languageCondition.hashCode();
    }

    public void map(Chunk[] cs, byte[] out) {
        Chunk col = cs[this.featureIndex];
        for (int iRow = 0; iRow < col._len; ++iRow) {
            byte newVal;
            block6: {
                block7: {
                    block8: {
                        boolean isNA;
                        block5: {
                            if (out[iRow] == 0) continue;
                            newVal = 0;
                            isNA = col.isNA(iRow);
                            if (!this.NAsIncluded || !isNA) break block5;
                            newVal = 1;
                            break block6;
                        }
                        if (isNA) break block6;
                        if (!Type.Numerical.equals((Object)this.type)) break block7;
                        if (!Operator.LessThan.equals((Object)this.operator)) break block8;
                        if (col.atd(iRow) < this.numTreshold) {
                            newVal = 1;
                        }
                        break block6;
                    }
                    if (!Operator.GreaterThanOrEqual.equals((Object)this.operator) || !(col.atd(iRow) >= this.numTreshold)) break block6;
                    newVal = 1;
                    break block6;
                }
                if (Type.Categorical.equals((Object)this.type)) {
                    BufferedString tmpStr = new BufferedString();
                    for (int i = 0; i < this.catTreshold.length; ++i) {
                        if (col instanceof CStrChunk) {
                            if (!ArrayUtils.contains((Object[])this.languageCatTreshold, (Object)col.atStr(tmpStr, iRow))) continue;
                            newVal = 1;
                            continue;
                        }
                        if ((double)this.catTreshold[i] != col.atd(iRow)) continue;
                        newVal = 1;
                    }
                }
            }
            out[iRow] = newVal;
        }
    }

    public static enum Operator {
        LessThan,
        GreaterThanOrEqual,
        In;

    }

    public static enum Type {
        Categorical,
        Numerical;

    }
}

