/*
 * Decompiled with CFR 0.152.
 */
package hex.rulefit;

import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.rulefit.Condition;
import hex.tree.SharedTreeModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import water.Iced;
import water.fvec.Chunk;

public class Rule
extends Iced {
    Condition[] conditions;
    double predictionValue;
    String languageRule;
    double coefficient;
    String varName;

    public Rule(Condition[] conditions, double predictionValue, String varName) {
        this.conditions = conditions;
        this.predictionValue = predictionValue;
        this.varName = varName;
        this.languageRule = this.generateLanguageRule();
    }

    public void setCoefficient(double coefficient) {
        this.coefficient = coefficient;
    }

    String generateLanguageRule() {
        StringBuilder languageRule = new StringBuilder();
        if (!this.varName.startsWith("linear.")) {
            for (int i = 0; i < this.conditions.length; ++i) {
                if (i != 0) {
                    languageRule.append(" & ");
                }
                languageRule.append(this.conditions[i].languageCondition);
            }
        }
        return languageRule.toString();
    }

    public void map(Chunk[] cs, byte[] out) {
        for (Condition c : this.conditions) {
            c.map(cs, out);
        }
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.conditions.length; ++i) {
            hashCode += this.conditions[i].hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public static List<Rule> extractRulesListFromModel(SharedTreeModel model, int modelId, int nclasses) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        nclasses = nclasses > 2 ? nclasses : 1;
        for (int i = 0; i < ((SharedTreeModel.SharedTreeParameters)model._parms)._ntrees; ++i) {
            for (int treeClass = 0; treeClass < nclasses; ++treeClass) {
                SharedTreeSubgraph sharedTreeSubgraph = model.getSharedTreeSubgraph(i, treeClass);
                rules.addAll(Rule.extractRulesFromTree(sharedTreeSubgraph, modelId));
            }
        }
        return rules;
    }

    public static Set<Rule> extractRulesFromTree(SharedTreeSubgraph tree, int modelId) {
        HashSet<Rule> rules = new HashSet<Rule>();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Rule.traverseNodes(tree.rootNode, conditions, rules, null, modelId);
        return rules;
    }

    private static void traverseNodes(SharedTreeNode node, List<Condition> conditions, Set<Rule> rules, Condition conditionToAdd, int modelId) {
        if (conditionToAdd != null) {
            conditions.add(conditionToAdd);
        }
        if (node.isLeaf()) {
            rules.add(new Rule(conditions.toArray(new Condition[0]), node.getPredValue(), "M" + modelId + "T" + node.getSubgraphNumber() + "N" + node.getNodeNumber()));
        } else {
            int colId = node.getColId();
            String colName = node.getColName();
            if (node.getDomainValues() == null) {
                float splitValue = node.getSplitValue();
                Rule.traverseNodes(node.getRightChild(), new ArrayList<Condition>(conditions), rules, new Condition(colId, Condition.Type.Numerical, Condition.Operator.GreaterThanOrEqual, splitValue, null, null, colName, node.getRightChild().isInclusiveNa()), modelId);
                Rule.traverseNodes(node.getLeftChild(), new ArrayList<Condition>(conditions), rules, new Condition(colId, Condition.Type.Numerical, Condition.Operator.LessThan, splitValue, null, null, colName, node.getLeftChild().isInclusiveNa()), modelId);
            } else {
                String[] domainValues = node.getDomainValues();
                CategoricalThreshold rightCategoricalThreshold = Rule.extractCategoricalThreshold(node.getRightChild().getInclusiveLevels(), domainValues);
                Rule.traverseNodes(node.getRightChild(), new ArrayList<Condition>(conditions), rules, new Condition(colId, Condition.Type.Categorical, Condition.Operator.In, -1.0, rightCategoricalThreshold.catThreshold, rightCategoricalThreshold.catThresholdNum, colName, node.getRightChild().isInclusiveNa()), modelId);
                CategoricalThreshold leftCategoricalThreshold = Rule.extractCategoricalThreshold(node.getLeftChild().getInclusiveLevels(), domainValues);
                Rule.traverseNodes(node.getLeftChild(), new ArrayList<Condition>(conditions), rules, new Condition(colId, Condition.Type.Categorical, Condition.Operator.In, -1.0, leftCategoricalThreshold.catThreshold, leftCategoricalThreshold.catThresholdNum, colName, node.getLeftChild().isInclusiveNa()), modelId);
            }
        }
    }

    static CategoricalThreshold extractCategoricalThreshold(BitSet inclusiveLevels, String[] domainValues) {
        ArrayList<Integer> matchedDomainValues = new ArrayList<Integer>();
        String[] catThreshold = new String[inclusiveLevels.cardinality()];
        int[] catThresholdNum = new int[inclusiveLevels.cardinality()];
        int i = inclusiveLevels.nextSetBit(0);
        while (i >= 0) {
            matchedDomainValues.add(i);
            i = inclusiveLevels.nextSetBit(i + 1);
        }
        for (i = 0; i < catThreshold.length; ++i) {
            catThreshold[i] = domainValues[(Integer)matchedDomainValues.get(i)];
            catThresholdNum[i] = (Integer)matchedDomainValues.get(i);
        }
        return new CategoricalThreshold(catThreshold, catThresholdNum);
    }

    double getAbsCoefficient() {
        return Math.abs(this.coefficient);
    }

    static class CategoricalThreshold {
        String[] catThreshold;
        int[] catThresholdNum;

        public CategoricalThreshold(String[] catThreshold, int[] catThresholdNum) {
            this.catThreshold = catThreshold;
            this.catThresholdNum = catThresholdNum;
        }
    }
}

