/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Distribution;
import hex.genmodel.utils.DistributionFamily;
import hex.tree.Constraints;
import hex.tree.ScoreBuildHistogram;
import hex.tree.SharedTreeModel;
import java.util.Arrays;
import java.util.Random;
import org.apache.log4j.Logger;
import sun.misc.Unsafe;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.fvec.Frame;
import water.fvec.Vec;
import water.nbhm.UtilUnsafe;
import water.util.ArrayUtils;
import water.util.AtomicUtils;
import water.util.RandomUtils;

public final class DHistogram
extends Iced {
    private static final Logger LOG = Logger.getLogger(DHistogram.class);
    public final transient String _name;
    public final double _minSplitImprovement;
    public final byte _isInt;
    public char _nbin;
    public double _step;
    public final double _min;
    public final double _maxEx;
    public final boolean _initNA;
    public final double _pred1;
    public final double _pred2;
    protected double[] _vals;
    protected final int _vals_dim;
    private final Distribution _dist;
    protected double _min2;
    protected double _maxIn;
    private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
    private static final long _min2Offset;
    private static final long _max2Offset;
    public SharedTreeModel.SharedTreeParameters.HistogramType _histoType;
    transient double[] _splitPts;
    transient int _zeroSplitPntPos;
    public final boolean _checkFloatSplits;
    transient float[] _splitPtsFloat;
    public final long _seed;
    public transient boolean _hasQuantiles;
    public Key _globalQuantilesKey;

    public double w(int i) {
        return this._vals[this._vals_dim * i + 0];
    }

    public double wY(int i) {
        return this._vals[this._vals_dim * i + 1];
    }

    public double wYY(int i) {
        return this._vals[this._vals_dim * i + 2];
    }

    public void addWAtomic(int i, double wDelta) {
        AtomicUtils.DoubleArray.add((double[])this._vals, (int)(this._vals_dim * i + 0), (double)wDelta);
    }

    public void addNasAtomic(double y, double wy, double wyy) {
        AtomicUtils.DoubleArray.add((double[])this._vals, (int)(this._vals_dim * this._nbin + 0), (double)y);
        AtomicUtils.DoubleArray.add((double[])this._vals, (int)(this._vals_dim * this._nbin + 1), (double)wy);
        AtomicUtils.DoubleArray.add((double[])this._vals, (int)(this._vals_dim * this._nbin + 2), (double)wyy);
    }

    public double wNA() {
        return this._vals[this._vals_dim * this._nbin + 0];
    }

    public double wYNA() {
        return this._vals[this._vals_dim * this._nbin + 1];
    }

    public double wYYNA() {
        return this._vals[this._vals_dim * this._nbin + 2];
    }

    public double seP1NA() {
        return this._vals[this._vals_dim * this._nbin + 3];
    }

    public double seP2NA() {
        return this._vals[this._vals_dim * this._nbin + 4];
    }

    public double denNA() {
        return this._vals[this._vals_dim * this._nbin + 5];
    }

    public double nomNA() {
        return this._vals[this._vals_dim * this._nbin + 6];
    }

    final boolean hasPreds() {
        return this._vals_dim >= 5;
    }

    final boolean hasDenominator() {
        return this._vals_dim >= 6;
    }

    final boolean hasNominator() {
        return this._vals_dim == 7;
    }

    public void setMin(double min) {
        long imin = Double.doubleToRawLongBits(min);
        double old = this._min2;
        while (min < old && !_unsafe.compareAndSwapLong((Object)this, _min2Offset, Double.doubleToRawLongBits(old), imin)) {
            old = this._min2;
        }
    }

    public void setMaxIn(double max) {
        long imax = Double.doubleToRawLongBits(max);
        double old = this._maxIn;
        while (max > old && !_unsafe.compareAndSwapLong((Object)this, _max2Offset, Double.doubleToRawLongBits(old), imax)) {
            old = this._maxIn;
        }
    }

    DHistogram(String name, int nbins, int nbins_cats, byte isInt, double min, double maxEx, boolean initNA, double minSplitImprovement, SharedTreeModel.SharedTreeParameters.HistogramType histogramType, long seed, Key globalQuantilesKey, Constraints cs, boolean checkFloatSplits) {
        int xbins;
        assert (nbins >= 1);
        assert (nbins_cats >= 1);
        assert (maxEx > min) : "Caller ensures " + maxEx + ">" + min + ", since if max==min== the column " + name + " is all constants";
        if (cs != null) {
            this._pred1 = cs._min;
            this._pred2 = cs._max;
            if (!cs.needsGammaDenom() && !cs.needsGammaNom()) {
                this._vals_dim = Double.isNaN(this._pred1) && Double.isNaN(this._pred2) ? 3 : 5;
                this._dist = cs._dist;
            } else if (!cs.needsGammaNom()) {
                this._vals_dim = 6;
                this._dist = cs._dist;
            } else {
                this._vals_dim = 7;
                this._dist = cs._dist;
            }
        } else {
            this._pred1 = Double.NaN;
            this._pred2 = Double.NaN;
            this._vals_dim = 3;
            this._dist = null;
        }
        this._isInt = isInt;
        this._name = name;
        this._min = min;
        this._maxEx = maxEx;
        this._min2 = Double.MAX_VALUE;
        this._maxIn = -1.7976931348623157E308;
        this._initNA = initNA;
        this._minSplitImprovement = minSplitImprovement;
        this._histoType = histogramType;
        this._seed = seed;
        while (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.RoundRobin) {
            SharedTreeModel.SharedTreeParameters.HistogramType[] h = SharedTreeModel.SharedTreeParameters.HistogramType.values();
            this._histoType = h[(int)Math.abs(seed++ % (long)h.length)];
        }
        if (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.AUTO) {
            this._histoType = SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive;
        }
        assert (this._histoType != SharedTreeModel.SharedTreeParameters.HistogramType.RoundRobin);
        this._globalQuantilesKey = globalQuantilesKey;
        int n = xbins = isInt == 2 ? nbins_cats : nbins;
        if (isInt > 0 && maxEx - min <= (double)xbins) {
            assert ((double)((long)min) == min) : "Overflow for integer/categorical histogram: minimum value cannot be cast to long without loss: (long)" + min + " != " + min + "!";
            xbins = (char)((long)maxEx - (long)min);
            this._step = 1.0;
        } else {
            this._step = (double)xbins / (maxEx - min);
            if (this._step <= 0.0 || Double.isInfinite(this._step) || Double.isNaN(this._step)) {
                throw new StepOutOfRangeException(name, this._step, xbins, maxEx, min);
            }
        }
        this._nbin = (char)xbins;
        assert (this._nbin > '\u0000');
        assert (this._vals == null);
        this._checkFloatSplits = checkFloatSplits;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Histogram: " + (Object)((Object)this)));
        }
    }

    public int bin(double col_data) {
        int idx1;
        double pos;
        if (Double.isNaN(col_data)) {
            return this._nbin;
        }
        if (Double.isInfinite(col_data)) {
            if (col_data < 0.0) {
                return 0;
            }
            return this._nbin - '\u0001';
        }
        assert (this._min <= col_data && col_data < this._maxEx) : "Coldata " + col_data + " out of range " + (Object)((Object)this);
        double d = pos = this._hasQuantiles ? col_data : (col_data - this._min) * this._step;
        if (this._splitPts != null) {
            int n = idx1 = pos == 0.0 ? this._zeroSplitPntPos : Arrays.binarySearch(this._splitPts, pos);
            if (idx1 < 0) {
                idx1 = -idx1 - 2;
            }
        } else {
            idx1 = (int)pos;
        }
        if (this._splitPtsFloat != null && idx1 + 1 < this._splitPtsFloat.length) {
            float splitAt = this._splitPtsFloat[idx1 + 1];
            if (col_data >= (double)splitAt) {
                ++idx1;
            }
            if (idx1 > 0 && !(col_data >= (double)this._splitPtsFloat[idx1])) {
                --idx1;
            }
        }
        if (idx1 == this._nbin) {
            --idx1;
        }
        assert (0 <= idx1 && idx1 < this._nbin) : idx1 + " " + this._nbin;
        return idx1;
    }

    public double binAt(int b) {
        if (this._hasQuantiles) {
            return this._splitPts[b];
        }
        return this._min + (this._splitPts == null ? (double)b : this._splitPts[b]) / this._step;
    }

    public int nbins() {
        return this._nbin;
    }

    public int actNBins() {
        return this.nbins() + (this.hasNABin() ? 1 : 0);
    }

    public double bins(int b) {
        return this.w(b);
    }

    public boolean hasNABin() {
        if (this._vals == null) {
            return this._initNA;
        }
        return this.wNA() > 0.0;
    }

    public void init() {
        this.init(null);
    }

    public void init(double[] vals) {
        assert (this._vals == null);
        if (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.Random) {
            Random rng = RandomUtils.getRNG((long[])new long[]{Double.doubleToRawLongBits((this._step + 0.324) * this._min + 8.3425 + 89.342 * this._maxEx) + (long)(912559 * this._nbin) + (long)(12648430 * this._isInt) + this._seed});
            assert (this._nbin > '\u0001');
            this._splitPts = DHistogram.makeRandomSplitPoints(this._nbin, rng);
        } else if (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.QuantilesGlobal) {
            HistoQuantiles hq;
            assert (this._splitPts == null);
            if (this._globalQuantilesKey != null && (hq = (HistoQuantiles)DKV.getGet((Key)this._globalQuantilesKey)) != null) {
                this._splitPts = ((HistoQuantiles)DKV.getGet((Key)this._globalQuantilesKey)).splitPts;
                if (this._splitPts != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Obtaining global splitPoints: " + Arrays.toString(this._splitPts)));
                    }
                    this._splitPts = ArrayUtils.limitToRange((double[])this._splitPts, (double)this._min, (double)this._maxEx);
                    if (this._splitPts.length > 1 && this._splitPts.length < this._nbin) {
                        this._splitPts = ArrayUtils.padUniformly((double[])this._splitPts, (int)this._nbin);
                    }
                    if (this._splitPts.length <= 1) {
                        this._splitPts = null;
                        this._histoType = SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive;
                    } else {
                        this._hasQuantiles = true;
                        this._nbin = (char)this._splitPts.length;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Refined splitPoints: " + Arrays.toString(this._splitPts)));
                        }
                    }
                }
            }
        } else assert (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive);
        if (this._splitPts != null) {
            int nzPos;
            this._zeroSplitPntPos = Arrays.binarySearch(this._splitPts, 0.0);
            if (this._zeroSplitPntPos < 0 && (nzPos = Arrays.binarySearch(this._splitPts, -0.0)) >= 0) {
                this._splitPts[nzPos] = 0.0;
                this._zeroSplitPntPos = nzPos;
            }
        }
        double[] dArray = this._vals = vals == null ? MemoryManager.malloc8d((int)(this._vals_dim * this._nbin + this._vals_dim)) : vals;
        assert (this._nbin > '\u0000');
        if (this._checkFloatSplits) {
            this._splitPtsFloat = new float[this._nbin];
            for (int i = 0; i < this._nbin; ++i) {
                this._splitPtsFloat[i] = (float)this.binAt(i);
            }
        }
    }

    void incr(double col_data, double y, double w) {
        if (Double.isNaN(col_data)) {
            this.addNasAtomic(w, w * y, w * y * y);
            return;
        }
        assert (Double.isInfinite(col_data) || this._min <= col_data && col_data < this._maxEx) : "col_data " + col_data + " out of range " + (Object)((Object)this);
        int b = this.bin(col_data);
        AtomicUtils.DoubleArray.add((double[])this._vals, (int)(this._vals_dim * b), (double)w);
        if (!Double.isInfinite(col_data)) {
            this.setMin(col_data);
            this.setMaxIn(col_data);
        }
        if (y != 0.0 && w != 0.0) {
            this.incr0(b, y, w);
        }
    }

    public void add(DHistogram dsh) {
        assert (this._vals == null || dsh._vals == null || this._isInt == dsh._isInt && this._nbin == dsh._nbin && this._step == dsh._step && this._min == dsh._min && this._maxEx == dsh._maxEx);
        if (dsh._vals == null) {
            return;
        }
        if (this._vals == null) {
            this.init(dsh._vals);
        } else {
            ArrayUtils.add((double[])this._vals, (double[])dsh._vals);
        }
        if (this._min2 > dsh._min2) {
            this._min2 = dsh._min2;
        }
        if (this._maxIn < dsh._maxIn) {
            this._maxIn = dsh._maxIn;
        }
    }

    public double find_min() {
        return this._min2;
    }

    public double find_maxIn() {
        return this._maxIn;
    }

    public double find_maxEx() {
        return DHistogram.find_maxEx(this._maxIn, this._isInt);
    }

    public static double find_maxEx(double maxIn, int isInt) {
        double res;
        double ulp = Math.ulp(maxIn);
        if (isInt > 0 && 1.0 > ulp) {
            ulp = 1.0;
        }
        return Double.isInfinite(res = maxIn + ulp) ? maxIn : res;
    }

    public static DHistogram[] initialHist(Frame fr, int ncols, int nbins, DHistogram[] hs, long seed, SharedTreeModel.SharedTreeParameters parms, Key[] globalQuantilesKey, Constraints cs, boolean checkFloatSplits) {
        Vec[] vecs = fr.vecs();
        for (int c = 0; c < ncols; ++c) {
            double maxIn;
            Vec v = vecs[c];
            double minIn = v.isCategorical() ? 0.0 : Math.max(v.min(), -1.7976931348623157E308);
            double d = maxIn = v.isCategorical() ? (double)(v.domain().length - 1) : Math.min(v.max(), Double.MAX_VALUE);
            double maxEx = v.isCategorical() ? (double)v.domain().length : DHistogram.find_maxEx(maxIn, v.isInt() ? 1 : 0);
            long vlen = v.length();
            long nacnt = v.naCnt();
            try {
                byte type = (byte)(v.isCategorical() ? 2 : (v.isInt() ? 1 : 0));
                hs[c] = nacnt == vlen || v.isConst(true) ? null : DHistogram.make(fr._names[c], nbins, type, minIn, maxEx, nacnt > 0L, seed, parms, globalQuantilesKey[c], cs, checkFloatSplits);
            }
            catch (StepOutOfRangeException e) {
                hs[c] = null;
                LOG.warn((Object)("Column " + fr._names[c] + " with min = " + v.min() + ", max = " + v.max() + " has step out of range (" + e.getMessage() + ") and is ignored."));
            }
            assert (hs[c] == null || vlen > 0L);
        }
        return hs;
    }

    public static DHistogram make(String name, int nbins, byte isInt, double min, double maxEx, boolean hasNAs, long seed, SharedTreeModel.SharedTreeParameters parms, Key globalQuantilesKey, Constraints cs, boolean checkFloatSplits) {
        return new DHistogram(name, nbins, parms._nbins_cats, isInt, min, maxEx, hasNAs, parms._min_split_improvement, parms._histogram_type, seed, globalQuantilesKey, cs, checkFloatSplits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._name).append(":").append(this._min).append("-").append(this._maxEx).append(" step=" + 1.0 / this._step + " nbins=" + this.nbins() + " actNBins=" + this.actNBins() + " isInt=" + this._isInt);
        if (this._vals != null) {
            for (int b = 0; b < this._nbin; ++b) {
                sb.append(String.format("\ncnt=%f, [%f - %f], mean/var=", this.w(b), this._min + (double)b / this._step, this._min + (double)(b + '\u0001') / this._step));
                sb.append(String.format("%6.2f/%6.2f,", this.mean(b), this.var(b)));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    double mean(int b) {
        double n = this.w(b);
        return n > 0.0 ? this.wY(b) / n : 0.0;
    }

    public double var(int b) {
        double n = this.w(b);
        if (n <= 1.0) {
            return 0.0;
        }
        return Math.max(0.0, (this.wYY(b) - this.wY(b) * this.wY(b) / n) / (n - 1.0));
    }

    public void incr0(int b, double y, double w) {
        AtomicUtils.DoubleArray.add((double[])this._vals, (int)(this._vals_dim * b + 1), (double)((float)(w * y)));
        AtomicUtils.DoubleArray.add((double[])this._vals, (int)(this._vals_dim * b + 2), (double)((float)(w * y * y)));
    }

    void updateHisto(double[] ws, double[] resp, double[] cs, double[] ys, double[] preds, int[] rows, int hi, int lo) {
        for (int r = lo; r < hi; ++r) {
            int k = rows[r];
            double weight = ws[k];
            if (weight == 0.0) continue;
            double col_data = cs[k];
            if (col_data < this._min2) {
                this._min2 = col_data;
            }
            if (col_data > this._maxIn) {
                this._maxIn = col_data;
            }
            double y = ys[k];
            double wy = weight * y;
            double wyy = wy * y;
            int b = this.bin(col_data);
            int binDimStart = this._vals_dim * b;
            int n = binDimStart + 0;
            this._vals[n] = this._vals[n] + weight;
            int n2 = binDimStart + 1;
            this._vals[n2] = this._vals[n2] + wy;
            int n3 = binDimStart + 2;
            this._vals[n3] = this._vals[n3] + wyy;
            if (this._vals_dim < 5 || Double.isNaN(resp[k])) continue;
            if (this._dist._family.equals((Object)DistributionFamily.quantile)) {
                int n4 = binDimStart + 3;
                this._vals[n4] = this._vals[n4] + this._dist.deviance(weight, y, this._pred1);
                int n5 = binDimStart + 4;
                this._vals[n5] = this._vals[n5] + this._dist.deviance(weight, y, this._pred2);
            } else {
                int n6 = binDimStart + 3;
                this._vals[n6] = this._vals[n6] + weight * (this._pred1 - y) * (this._pred1 - y);
                int n7 = binDimStart + 4;
                this._vals[n7] = this._vals[n7] + weight * (this._pred2 - y) * (this._pred2 - y);
            }
            if (this._vals_dim < 6) continue;
            int n8 = binDimStart + 5;
            this._vals[n8] = this._vals[n8] + this._dist.gammaDenom(weight, resp[k], y, preds[k]);
            if (this._vals_dim != 7) continue;
            int n9 = binDimStart + 6;
            this._vals[n9] = this._vals[n9] + this._dist.gammaNum(weight, resp[k], y, preds[k]);
        }
    }

    public void reducePrecision() {
        if (this._vals == null) {
            return;
        }
        for (int i = 0; i < this._vals.length; i += this._vals_dim) {
            this._vals[i + 1] = (float)this._vals[i + 1];
            this._vals[i + 2] = (float)this._vals[i + 2];
        }
    }

    public void updateSharedHistosAndReset(ScoreBuildHistogram.LocalHisto lh, double[] ws, double[] cs, double[] ys, int[] rows, int hi, int lo) {
        double[] minmax = new double[]{this._min2, this._maxIn};
        for (int r = lo; r < hi; ++r) {
            int k = rows[r];
            double weight = ws[k];
            if (weight == 0.0) continue;
            double col_data = cs[k];
            if (col_data < minmax[0]) {
                minmax[0] = col_data;
            }
            if (col_data > minmax[1]) {
                minmax[1] = col_data;
            }
            double y = ys[k];
            assert (!Double.isNaN(y));
            double wy = weight * y;
            double wyy = wy * y;
            if (Double.isNaN(col_data)) {
                this.addNasAtomic(weight, wy, wyy);
                continue;
            }
            int b = this.bin(col_data);
            lh.wAdd(b, weight);
            lh.wYAdd(b, wy);
            lh.wYYAdd(b, wyy);
        }
        this.setMin(minmax[0]);
        this.setMaxIn(minmax[1]);
        int len = this._nbin;
        for (int b = 0; b < len; ++b) {
            int binDimStart = this._vals_dim * b;
            if (lh.w(b) != 0.0) {
                AtomicUtils.DoubleArray.add((double[])this._vals, (int)binDimStart, (double)lh.w(b));
                lh.wClear(b);
            }
            if (lh.wY(b) != 0.0) {
                AtomicUtils.DoubleArray.add((double[])this._vals, (int)(binDimStart + 1), (double)((float)lh.wY(b)));
                lh.wYClear(b);
            }
            if (lh.wYY(b) == 0.0) continue;
            AtomicUtils.DoubleArray.add((double[])this._vals, (int)(binDimStart + 2), (double)((float)lh.wYY(b)));
            lh.wYYClear(b);
        }
    }

    static double[] makeRandomSplitPoints(int nbin, Random rng) {
        double[] splitPts = new double[nbin];
        splitPts[0] = 0.0;
        for (int i = 1; i < nbin; ++i) {
            splitPts[i] = rng.nextFloat() * (float)nbin;
        }
        Arrays.sort(splitPts);
        return splitPts;
    }

    static {
        try {
            _min2Offset = _unsafe.objectFieldOffset(DHistogram.class.getDeclaredField("_min2"));
            _max2Offset = _unsafe.objectFieldOffset(DHistogram.class.getDeclaredField("_maxIn"));
        }
        catch (Exception e) {
            throw H2O.fail();
        }
    }

    static class StepOutOfRangeException
    extends RuntimeException {
        public StepOutOfRangeException(String name, double step, int xbins, double maxEx, double min) {
            super("column=" + name + " leads to invalid histogram(check numeric range) -> [max=" + maxEx + ", min = " + min + "], step= " + step + ", xbin= " + xbins);
        }
    }

    static class HistoQuantiles
    extends Keyed<HistoQuantiles> {
        double[] splitPts;

        public HistoQuantiles(Key<HistoQuantiles> key, double[] splitPts) {
            super(key);
            this.splitPts = splitPts;
        }
    }

    public static enum NASplitDir {
        None(0),
        NAvsREST(1),
        NALeft(2),
        NARight(3),
        Left(4),
        Right(5);

        private int value;

        private NASplitDir(int v) {
            this.value = v;
        }

        public int value() {
            return this.value;
        }
    }
}

