/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import water.DKV;
import water.Iced;
import water.Job;
import water.Key;
import water.fvec.Frame;
import water.util.ArrayUtils;

class GlobalQuantilesCalc {
    GlobalQuantilesCalc() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static double[][] splitPoints(Frame fr, String weightsColumn, int N, int nbins_top_level) {
        Key rndKey = Key.make();
        DKV.put((Key)rndKey, (Iced)fr);
        QuantileModel qm = null;
        try {
            QuantileModel.QuantileParameters p = new QuantileModel.QuantileParameters();
            p._train = rndKey;
            p._weights_column = weightsColumn;
            p._combine_method = QuantileModel.CombineMethod.INTERPOLATE;
            p._probs = new double[N];
            for (int i = 0; i < N; ++i) {
                p._probs[i] = (double)i * 1.0 / (double)N;
            }
            Job job = new Quantile(p).trainModel();
            qm = (QuantileModel)job.get();
            job.remove();
            double[][] origQuantiles = ((QuantileModel.QuantileOutput)qm._output)._quantiles;
            double[][] splitPoints = new double[origQuantiles.length][];
            for (int i = 0; i < origQuantiles.length; ++i) {
                if (!fr.vec(i).isNumeric() || fr.vec(i).isCategorical() || fr.vec(i).isBinary() || origQuantiles[i].length <= 1) continue;
                splitPoints[i] = ArrayUtils.makeUniqueAndLimitToRange((double[])origQuantiles[i], (double)fr.vec(i).min(), (double)fr.vec(i).max());
                splitPoints[i] = (double[])(splitPoints[i].length <= 1 ? null : ArrayUtils.padUniformly((double[])splitPoints[i], (int)nbins_top_level));
                assert (splitPoints[i] == null || splitPoints[i].length > 1);
            }
            double[][] dArrayArray = splitPoints;
            return dArrayArray;
        }
        finally {
            DKV.remove((Key)rndKey);
            if (qm != null) {
                qm.delete();
            }
        }
    }
}

