/*
 * Decompiled with CFR 0.152.
 */
package hex.ensemble;

import hex.Model;
import hex.ModelBuilder;
import hex.ensemble.Metalearner;
import hex.ensemble.MetalearnerProvider;
import hex.ensemble.StackedEnsembleModel;
import hex.genmodel.utils.DistributionFamily;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.schemas.DRFV3;
import hex.schemas.DeepLearningV3;
import hex.schemas.GBMV3;
import hex.schemas.GLMV3;
import hex.schemas.NaiveBayesV3;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import water.Job;
import water.Key;
import water.api.Schema;
import water.exceptions.H2OIllegalArgumentException;
import water.nbhm.NonBlockingHashMap;
import water.util.ArrayUtils;
import water.util.Log;

public class Metalearners {
    static final NonBlockingHashMap<String, MetalearnerProvider> providersByName;

    static Metalearner.Algorithm getActualMetalearnerAlgo(Metalearner.Algorithm algo) {
        Metalearners.assertAvailable(algo.name());
        return algo == Metalearner.Algorithm.AUTO ? Metalearner.Algorithm.glm : algo;
    }

    public static Model.Parameters createParameters(String name) {
        Metalearners.assertAvailable(name);
        return ((ModelBuilder)Metalearners.createInstance((String)name).createBuilder())._parms;
    }

    public static Schema createParametersSchema(String name) {
        Metalearners.assertAvailable(name);
        return ((MetalearnerProvider)providersByName.get((Object)name)).newParametersSchemaInstance();
    }

    static Metalearner createInstance(String name) {
        Metalearners.assertAvailable(name);
        return ((MetalearnerProvider)providersByName.get((Object)name)).newInstance();
    }

    private static void assertAvailable(String algo) {
        if (!providersByName.containsKey((Object)algo)) {
            throw new H2OIllegalArgumentException("'" + algo + "' metalearner is not supported or available.");
        }
    }

    static {
        LocalProvider[] localProviders;
        providersByName = new NonBlockingHashMap();
        for (LocalProvider provider : localProviders = new LocalProvider[]{new LocalProvider<AUTOMetalearner>(Metalearner.Algorithm.AUTO, AUTOMetalearner::new, GLMV3.GLMParametersV3::new), new LocalProvider<DLMetalearner>(Metalearner.Algorithm.deeplearning, DLMetalearner::new, DeepLearningV3.DeepLearningParametersV3::new), new LocalProvider<DRFMetalearner>(Metalearner.Algorithm.drf, DRFMetalearner::new, DRFV3.DRFParametersV3::new), new LocalProvider<GBMMetalearner>(Metalearner.Algorithm.gbm, GBMMetalearner::new, GBMV3.GBMParametersV3::new), new LocalProvider<GLMMetalearner>(Metalearner.Algorithm.glm, GLMMetalearner::new, GLMV3.GLMParametersV3::new), new LocalProvider<NaiveBayesMetalearner>(Metalearner.Algorithm.naivebayes, NaiveBayesMetalearner::new, NaiveBayesV3.NaiveBayesParametersV3::new)}) {
            providersByName.put((Object)provider.getName(), (Object)provider);
        }
        ServiceLoader<MetalearnerProvider> extensionProviders = ServiceLoader.load(MetalearnerProvider.class);
        for (MetalearnerProvider provider : extensionProviders) {
            providersByName.put((Object)provider.getName(), (Object)provider);
        }
    }

    static class AUTOMetalearner
    extends GLMMetalearner {
        AUTOMetalearner() {
        }

        @Override
        protected void setCustomParams(GLMModel.GLMParameters parms) {
            super.setCustomParams(parms);
            parms._generate_scoring_history = true;
            parms._score_iteration_interval = parms._valid == null ? 5 : -1;
            parms._non_negative = true;
            parms._standardize = false;
            if (parms._valid != null) {
                parms._lambda_search = true;
                parms._early_stopping = false;
            }
        }
    }

    static class NaiveBayesMetalearner
    extends SimpleMetalearner {
        public NaiveBayesMetalearner() {
            super(Metalearner.Algorithm.naivebayes.name());
        }
    }

    static class GLMMetalearner
    extends Metalearner<GLM, GLMModel, GLMModel.GLMParameters> {
        GLMMetalearner() {
        }

        @Override
        GLM createBuilder() {
            return (GLM)ModelBuilder.make((String)"GLM", (Job)this._metalearnerJob, (Key)this._metalearnerKey);
        }
    }

    static class GBMMetalearner
    extends MetalearnerWithDistribution {
        public GBMMetalearner() {
            super(Metalearner.Algorithm.gbm.name());
            this._supportedDistributionFamilies = new DistributionFamily[]{DistributionFamily.AUTO, DistributionFamily.bernoulli, DistributionFamily.quasibinomial, DistributionFamily.multinomial, DistributionFamily.gaussian, DistributionFamily.poisson, DistributionFamily.gamma, DistributionFamily.laplace, DistributionFamily.quantile, DistributionFamily.huber, DistributionFamily.tweedie, DistributionFamily.custom};
        }
    }

    static class DRFMetalearner
    extends MetalearnerWithDistribution {
        public DRFMetalearner() {
            super(Metalearner.Algorithm.drf.name());
            this._supportedDistributionFamilies = new DistributionFamily[]{DistributionFamily.AUTO, DistributionFamily.bernoulli, DistributionFamily.multinomial, DistributionFamily.gaussian};
        }
    }

    static class DLMetalearner
    extends MetalearnerWithDistribution {
        public DLMetalearner() {
            super(Metalearner.Algorithm.deeplearning.name());
            this._supportedDistributionFamilies = new DistributionFamily[]{DistributionFamily.AUTO, DistributionFamily.bernoulli, DistributionFamily.multinomial, DistributionFamily.gaussian, DistributionFamily.poisson, DistributionFamily.gamma, DistributionFamily.laplace, DistributionFamily.quantile, DistributionFamily.huber, DistributionFamily.tweedie};
        }
    }

    static class MetalearnerWithDistribution
    extends SimpleMetalearner {
        protected DistributionFamily[] _supportedDistributionFamilies;

        protected MetalearnerWithDistribution(String algo) {
            super(algo);
        }

        protected void validateParams(Model.Parameters parms) {
            super.validateParams(parms);
            if (!ArrayUtils.contains((Object[])this._supportedDistributionFamilies, (Object)parms._distribution)) {
                DistributionFamily distribution = ((StackedEnsembleModel.StackedEnsembleOutput)this._model._output).nclasses() == 1 ? DistributionFamily.gaussian : (((StackedEnsembleModel.StackedEnsembleOutput)this._model._output).nclasses() == 2 ? DistributionFamily.bernoulli : DistributionFamily.multinomial);
                Log.warn((Object[])new Object[]{"Distribution \"" + parms._distribution + "\" is not supported by metalearner algorithm \"" + this.getAlgo() + "\". Using \"" + distribution + "\" instead."});
                parms._distribution = distribution;
            }
        }
    }

    public static class SimpleMetalearner
    extends Metalearner {
        private String _algo;

        protected SimpleMetalearner(String algo) {
            this._algo = algo;
        }

        ModelBuilder createBuilder() {
            return ModelBuilder.make((String)this._algo, (Job)this._metalearnerJob, (Key)this._metalearnerKey);
        }

        protected String getAlgo() {
            return this._algo;
        }
    }

    static class LocalProvider<M extends Metalearner>
    implements MetalearnerProvider<M> {
        private Metalearner.Algorithm _algorithm;
        private Supplier<M> _instanceFactory;
        private Supplier<Schema> _parameterSchemaInstanceFactory;

        public LocalProvider(Metalearner.Algorithm algorithm, Supplier<M> instanceFactory, Supplier<Schema> parameterSchemaInstanceFactory) {
            this._algorithm = algorithm;
            this._instanceFactory = instanceFactory;
            this._parameterSchemaInstanceFactory = parameterSchemaInstanceFactory;
        }

        @Override
        public String getName() {
            return this._algorithm.name();
        }

        @Override
        public M newInstance() {
            return (M)((Metalearner)this._instanceFactory.get());
        }

        @Override
        public Schema newParametersSchemaInstance() {
            return this._parameterSchemaInstanceFactory.get();
        }
    }
}

