/*
 * Decompiled with CFR 0.152.
 */
package hex.ensemble;

import hex.Distribution;
import hex.LinkFunction;
import hex.LinkFunctionFactory;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ensemble.Metalearner;
import hex.ensemble.Metalearners;
import hex.ensemble.StackedEnsemble;
import hex.ensemble.StackedEnsembleMojoWriter;
import hex.genmodel.utils.DistributionFamily;
import hex.genmodel.utils.LinkFunctionType;
import hex.glm.GLMModel;
import hex.tree.drf.DRFModel;
import hex.util.DistributionUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Stream;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.LocalMR;
import water.MRTask;
import water.MrFun;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.udf.CFuncRef;
import water.util.Log;
import water.util.MRUtils;
import water.util.ReflectionUtils;

public class StackedEnsembleModel
extends Model<StackedEnsembleModel, StackedEnsembleParameters, StackedEnsembleOutput> {
    public ModelCategory modelCategory;
    public long trainingFrameRows = -1L;
    public String responseColumn = null;

    public StackedEnsembleModel(Key selfKey, StackedEnsembleParameters parms, StackedEnsembleOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public void initActualParamValues() {
        super.initActualParamValues();
        if (((StackedEnsembleParameters)this._parms)._metalearner_fold_assignment == Model.Parameters.FoldAssignmentScheme.AUTO) {
            ((StackedEnsembleParameters)this._parms)._metalearner_fold_assignment = Model.Parameters.FoldAssignmentScheme.Random;
        }
    }

    protected Model.PredictScoreResult predictScoreImpl(final Frame fr, Frame adaptFrm, String destination_key, final Job j, boolean computeMetrics, CFuncRef customMetricFunc) {
        StackedEnsembleParameters.MetalearnerTransform transform;
        if (((StackedEnsembleParameters)this._parms)._metalearner_transform != null && ((StackedEnsembleParameters)this._parms)._metalearner_transform != StackedEnsembleParameters.MetalearnerTransform.NONE) {
            if (!((StackedEnsembleOutput)this._output).isBinomialClassifier() && !((StackedEnsembleOutput)this._output).isMultinomialClassifier()) {
                throw new H2OIllegalArgumentException("Metalearner transform is supported only for classification!");
            }
            transform = ((StackedEnsembleParameters)this._parms)._metalearner_transform;
        } else {
            transform = null;
        }
        final String seKey = this._key.toString();
        Key levelOneFrameKey = Key.make((String)("preds_levelone_" + seKey + fr._key));
        Frame levelOneFrame = transform == null ? new Frame(levelOneFrameKey) : new Frame(new Vec[0]);
        final Model[] usefulBaseModels = (Model[])Stream.of(((StackedEnsembleParameters)this._parms)._base_models).filter(this::isUsefulBaseModel).map(Key::get).toArray(Model[]::new);
        if (usefulBaseModels.length > 0) {
            final Frame[] baseModelPredictions = new Frame[usefulBaseModels.length];
            ((LocalMR)H2O.submitTask((H2O.H2OCountedCompleter)new LocalMR(new MrFun(){

                protected void map(int id) {
                    baseModelPredictions[id] = usefulBaseModels[id].score(fr, "preds_base_" + seKey + usefulBaseModels[id]._key + fr._key, j, false);
                }
            }, usefulBaseModels.length))).join();
            for (int i = 0; i < usefulBaseModels.length; ++i) {
                StackedEnsemble.addModelPredictionsToLevelOneFrame(usefulBaseModels[i], baseModelPredictions[i], levelOneFrame);
                DKV.remove((Key)baseModelPredictions[i]._key);
                Frame.deleteTempFrameAndItsNonSharedVecs((Frame)baseModelPredictions[i], (Frame)levelOneFrame);
            }
        }
        if (transform != null) {
            Frame oldLOF = levelOneFrame;
            levelOneFrame = transform.transform(this, levelOneFrame, (Key<Frame>)levelOneFrameKey);
            oldLOF.remove();
        }
        StackedEnsemble.addNonPredictorsToLevelOneFrame((StackedEnsembleParameters)this._parms, adaptFrm, levelOneFrame, false);
        Log.info((Object[])new Object[]{"Finished creating \"level one\" frame for scoring: " + levelOneFrame.toString()});
        Model metalearner = ((StackedEnsembleOutput)this._output)._metalearner;
        Frame predictFr = metalearner.score(levelOneFrame, destination_key, j, computeMetrics, CFuncRef.from((String)((StackedEnsembleParameters)this._parms)._custom_metric_func));
        ModelMetrics mmStackedEnsemble = null;
        if (computeMetrics) {
            Key[] mms = metalearner._output.getModelMetrics();
            ModelMetrics lastComputedMetric = (ModelMetrics)mms[mms.length - 1].get();
            mmStackedEnsemble = lastComputedMetric.deepCloneWithDifferentModelAndFrame((Model)this, fr);
            this.addModelMetrics(mmStackedEnsemble);
            for (Key mm : metalearner._output.clearModelMetrics(true)) {
                DKV.remove((Key)mm);
            }
        }
        Frame.deleteTempFrameAndItsNonSharedVecs((Frame)levelOneFrame, (Frame)adaptFrm);
        return new StackedEnsemblePredictScoreResult(predictFr, mmStackedEnsemble);
    }

    boolean isUsefulBaseModel(Key<Model> baseModelKey) {
        Model metalearner = ((StackedEnsembleOutput)this._output)._metalearner;
        assert (metalearner != null) : "can't use isUsefulBaseModel during training";
        if (this.modelCategory == ModelCategory.Multinomial) {
            for (String feature : metalearner._output._names) {
                if (!feature.startsWith(baseModelKey.toString().concat("/")) || !metalearner.isFeatureUsedInPredict(feature)) continue;
                return true;
            }
            return false;
        }
        return metalearner.isFeatureUsedInPredict(baseModelKey.toString());
    }

    protected double[] score0(double[] data, double[] preds) {
        throw new UnsupportedOperationException("StackedEnsembleModel.score0() should never be called: the code paths that normally go here should call predictScoreImpl().");
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        throw new UnsupportedOperationException("StackedEnsembleModel.makeMetricBuilder should never be called!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelMetrics doScoreTrainingMetrics(Frame frame, Job job) {
        Frame scoredFrame = ((StackedEnsembleParameters)this._parms)._score_training_samples > 0L && ((StackedEnsembleParameters)this._parms)._score_training_samples < frame.numRows() ? MRUtils.sampleFrame((Frame)frame, (long)((StackedEnsembleParameters)this._parms)._score_training_samples, (long)((StackedEnsembleParameters)this._parms)._seed) : frame;
        try {
            Frame adaptedFrame = new Frame(scoredFrame);
            Model.PredictScoreResult result = this.predictScoreImpl(scoredFrame, adaptedFrame, null, job, true, CFuncRef.from((String)((StackedEnsembleParameters)this._parms)._custom_metric_func));
            result.getPredictions().delete();
            ModelMetrics modelMetrics = result.makeModelMetrics(scoredFrame, adaptedFrame);
            return modelMetrics;
        }
        finally {
            if (scoredFrame != frame) {
                scoredFrame.delete();
            }
        }
    }

    void doScoreOrCopyMetrics(Job job) {
        ((StackedEnsembleOutput)this._output)._training_metrics = this.doScoreTrainingMetrics(((StackedEnsembleParameters)this._parms).train(), null);
        ((StackedEnsembleOutput)this._output)._validation_metrics = ((StackedEnsembleOutput)this._output)._metalearner._output._validation_metrics;
        if (null != ((StackedEnsembleOutput)this._output)._metalearner._output._cross_validation_metrics) {
            ((StackedEnsembleOutput)this._output)._cross_validation_metrics = ((StackedEnsembleOutput)this._output)._metalearner._output._cross_validation_metrics.deepCloneWithDifferentModelAndFrame((Model)this, ((StackedEnsembleOutput)this._output)._metalearner._parms.train());
        }
    }

    private DistributionFamily distributionFamily(Model aModel) {
        if (aModel instanceof DRFModel) {
            if (aModel._output.isBinomialClassifier()) {
                return DistributionFamily.bernoulli;
            }
            if (aModel._output.isClassifier()) {
                return DistributionFamily.multinomial;
            }
            return DistributionFamily.gaussian;
        }
        if (aModel instanceof StackedEnsembleModel) {
            StackedEnsembleModel seModel = (StackedEnsembleModel)aModel;
            if (Metalearners.getActualMetalearnerAlgo(((StackedEnsembleParameters)seModel._parms)._metalearner_algorithm) == Metalearner.Algorithm.glm) {
                return DistributionUtils.familyToDistribution(((GLMModel.GLMParameters)((StackedEnsembleParameters)seModel._parms)._metalearner_parameters)._family);
            }
            if (((StackedEnsembleParameters)seModel._parms)._metalearner_parameters._distribution != DistributionFamily.AUTO) {
                return ((StackedEnsembleParameters)seModel._parms)._metalearner_parameters._distribution;
            }
        }
        try {
            Field distributionField;
            Field familyField = ReflectionUtils.findNamedField((Object)aModel._parms, (String)"_family");
            Field field = distributionField = familyField != null ? null : ReflectionUtils.findNamedField((Object)aModel, (String)"_dist");
            if (null != familyField) {
                GLMModel.GLMParameters.Family thisFamily = (GLMModel.GLMParameters.Family)((Object)familyField.get(aModel._parms));
                return DistributionUtils.familyToDistribution(thisFamily);
            }
            if (null != distributionField) {
                Distribution distribution = (Distribution)distributionField.get(aModel);
                DistributionFamily distributionFamily = null != distribution ? distribution._family : aModel._parms._distribution;
                if (distributionFamily == DistributionFamily.AUTO) {
                    distributionFamily = aModel._output.isBinomialClassifier() ? DistributionFamily.bernoulli : (aModel._output.isClassifier() ? DistributionFamily.multinomial : DistributionFamily.gaussian);
                }
                return distributionFamily;
            }
            throw new H2OIllegalArgumentException("Don't know how to stack models that have neither a distribution hyperparameter nor a family hyperparameter.");
        }
        catch (Exception e) {
            throw new H2OIllegalArgumentException(e.toString(), e.toString());
        }
    }

    private void inheritDistributionAndParms(Model.Parameters baseModelParms) {
        if (baseModelParms instanceof GLMModel.GLMParameters) {
            try {
                ((StackedEnsembleParameters)this._parms)._metalearner_parameters._distribution = DistributionUtils.familyToDistribution(((GLMModel.GLMParameters)baseModelParms)._family);
            }
            catch (IllegalArgumentException e) {
                Log.warn((Object[])new Object[]{"Stacked Ensemble is not able to inherit distribution from GLM's family " + (Object)((Object)((GLMModel.GLMParameters)baseModelParms)._family) + "."});
            }
        } else if (baseModelParms instanceof DRFModel.DRFParameters) {
            this.inferBasicDistribution();
        } else {
            ((StackedEnsembleParameters)this._parms)._metalearner_parameters._distribution = baseModelParms._distribution;
        }
        switch (baseModelParms._distribution) {
            case custom: {
                ((StackedEnsembleParameters)this._parms)._metalearner_parameters._custom_distribution_func = baseModelParms._custom_distribution_func;
                break;
            }
            case huber: {
                ((StackedEnsembleParameters)this._parms)._metalearner_parameters._huber_alpha = baseModelParms._huber_alpha;
                break;
            }
            case tweedie: {
                ((StackedEnsembleParameters)this._parms)._metalearner_parameters._tweedie_power = baseModelParms._tweedie_power;
                break;
            }
            case quantile: {
                ((StackedEnsembleParameters)this._parms)._metalearner_parameters._quantile_alpha = baseModelParms._quantile_alpha;
            }
        }
    }

    private void inheritFamilyAndParms(Model.Parameters baseModelParms) {
        GLMModel.GLMParameters metaParams = (GLMModel.GLMParameters)((StackedEnsembleParameters)this._parms)._metalearner_parameters;
        if (baseModelParms instanceof GLMModel.GLMParameters) {
            GLMModel.GLMParameters glmParams = (GLMModel.GLMParameters)baseModelParms;
            metaParams._family = glmParams._family;
            metaParams._link = glmParams._link;
        } else if (baseModelParms instanceof DRFModel.DRFParameters) {
            this.inferBasicDistribution();
        } else {
            try {
                metaParams._family = Enum.valueOf(GLMModel.GLMParameters.Family.class, baseModelParms._distribution.name());
            }
            catch (IllegalArgumentException e) {
                Log.warn((Object[])new Object[]{"Stacked Ensemble is not able to inherit family from a distribution " + baseModelParms._distribution + "."});
                this.inferBasicDistribution();
            }
        }
        if (metaParams._family == GLMModel.GLMParameters.Family.tweedie) {
            ((StackedEnsembleParameters)this._parms)._metalearner_parameters._tweedie_power = baseModelParms._tweedie_power;
        }
    }

    boolean inferDistributionOrFamily(Model aModel) {
        if (Metalearners.getActualMetalearnerAlgo(((StackedEnsembleParameters)this._parms)._metalearner_algorithm) == Metalearner.Algorithm.glm) {
            if (((GLMModel.GLMParameters)((StackedEnsembleParameters)this._parms)._metalearner_parameters)._family != GLMModel.GLMParameters.Family.AUTO) {
                return false;
            }
            this.inheritFamilyAndParms(aModel._parms);
        } else {
            if (((StackedEnsembleParameters)this._parms)._metalearner_parameters._distribution != DistributionFamily.AUTO) {
                return false;
            }
            this.inheritDistributionAndParms(aModel._parms);
        }
        return true;
    }

    void inferBasicDistribution() {
        if (Metalearners.getActualMetalearnerAlgo(((StackedEnsembleParameters)this._parms)._metalearner_algorithm).equals((Object)Metalearner.Algorithm.glm)) {
            GLMModel.GLMParameters parms = (GLMModel.GLMParameters)((StackedEnsembleParameters)this._parms)._metalearner_parameters;
            parms._link = GLMModel.GLMParameters.Link.family_default;
            parms._family = ((StackedEnsembleOutput)this._output).isBinomialClassifier() ? GLMModel.GLMParameters.Family.binomial : (((StackedEnsembleOutput)this._output).isClassifier() ? GLMModel.GLMParameters.Family.multinomial : GLMModel.GLMParameters.Family.gaussian);
        } else {
            ((StackedEnsembleParameters)this._parms)._metalearner_parameters._distribution = ((StackedEnsembleOutput)this._output).isBinomialClassifier() ? DistributionFamily.bernoulli : (((StackedEnsembleOutput)this._output).isClassifier() ? DistributionFamily.multinomial : DistributionFamily.gaussian);
        }
    }

    void checkAndInheritModelProperties() {
        if (null == ((StackedEnsembleParameters)this._parms)._base_models || 0 == ((StackedEnsembleParameters)this._parms)._base_models.length) {
            throw new H2OIllegalArgumentException("When creating a StackedEnsemble you must specify one or more models; found 0.");
        }
        if (null != ((StackedEnsembleParameters)this._parms)._metalearner_fold_column && 0 != ((StackedEnsembleParameters)this._parms)._metalearner_nfolds) {
            throw new H2OIllegalArgumentException("Cannot specify fold_column and nfolds at the same time.");
        }
        Model aModel = null;
        boolean retrievedFirstModelParams = false;
        boolean inferredDistributionFromFirstModel = false;
        GLMModel firstGLM = null;
        boolean blending_mode = ((StackedEnsembleParameters)this._parms)._blending != null;
        boolean cv_required_on_base_model = !blending_mode;
        boolean require_consistent_training_frames = !blending_mode && !((StackedEnsembleParameters)this._parms)._is_cv_model;
        int basemodel_nfolds = -1;
        Model.Parameters.FoldAssignmentScheme basemodel_fold_assignment = null;
        String basemodel_fold_column = null;
        long seed = -1L;
        if (((StackedEnsembleParameters)this._parms)._metalearner_parameters == null) {
            ((StackedEnsembleParameters)this._parms).initMetalearnerParams();
        }
        for (Key<Model> k : ((StackedEnsembleParameters)this._parms)._base_models) {
            aModel = (Model)DKV.getGet(k);
            if (null == aModel) {
                Log.warn((Object[])new Object[]{"Failed to find base model; skipping: " + k});
                continue;
            }
            Log.debug((Object[])new Object[]{"Checking properties for model " + k});
            if (!aModel.isSupervised()) {
                throw new H2OIllegalArgumentException("Base model is not supervised: " + aModel._key.toString());
            }
            if (retrievedFirstModelParams) {
                if (this.modelCategory != aModel._output.getModelCategory()) {
                    throw new H2OIllegalArgumentException("Base models are inconsistent: there is a mix of different categories of models among " + Arrays.toString(((StackedEnsembleParameters)this._parms)._base_models));
                }
                if (!this.responseColumn.equals(aModel._parms._response_column)) {
                    throw new H2OIllegalArgumentException("Base models are inconsistent: they use different response columns. Found: " + this.responseColumn + " (StackedEnsemble) and " + aModel._parms._response_column + " (model " + k + ").");
                }
                if (require_consistent_training_frames) {
                    long numOfRowsUsedToTrain;
                    if (this.trainingFrameRows < 0L) {
                        this.trainingFrameRows = ((StackedEnsembleParameters)this._parms).train().numRows();
                    }
                    long l = numOfRowsUsedToTrain = aModel._parms.train() == null ? ((Frame)aModel._output._cross_validation_holdout_predictions_frame_id.get()).numRows() : aModel._parms.train().numRows();
                    if (this.trainingFrameRows != numOfRowsUsedToTrain) {
                        throw new H2OIllegalArgumentException("Base models are inconsistent: they use different size (number of rows) training frames. Found: " + this.trainingFrameRows + " (StackedEnsemble) and " + numOfRowsUsedToTrain + " (model " + k + ").");
                    }
                }
                if (cv_required_on_base_model) {
                    if (aModel._parms._fold_assignment != basemodel_fold_assignment && (aModel._parms._fold_assignment != Model.Parameters.FoldAssignmentScheme.AUTO || basemodel_fold_assignment != Model.Parameters.FoldAssignmentScheme.Random)) {
                        throw new H2OIllegalArgumentException("Base models are inconsistent: they use different fold_assignments.");
                    }
                    if (aModel._parms._fold_column == null) {
                        if (aModel._parms._nfolds < 2) {
                            throw new H2OIllegalArgumentException("Base model does not use cross-validation: " + aModel._parms._nfolds);
                        }
                        if (basemodel_nfolds != aModel._parms._nfolds) {
                            throw new H2OIllegalArgumentException("Base models are inconsistent: they use different values for nfolds.");
                        }
                        if (basemodel_fold_assignment == Model.Parameters.FoldAssignmentScheme.Random && aModel._parms._seed != seed) {
                            throw new H2OIllegalArgumentException("Base models are inconsistent: they use random-seeded k-fold cross-validation but have different seeds.");
                        }
                    } else if (!aModel._parms._fold_column.equals(basemodel_fold_column)) {
                        throw new H2OIllegalArgumentException("Base models are inconsistent: they use different fold_columns.");
                    }
                    if (!aModel._parms._keep_cross_validation_predictions) {
                        throw new H2OIllegalArgumentException("Base model does not keep cross-validation predictions: " + aModel._parms._nfolds);
                    }
                }
                if (!inferredDistributionFromFirstModel) continue;
                if (!(aModel instanceof DRFModel) && this.distributionFamily(aModel) == this.distributionFamily(this)) {
                    boolean sameParams = true;
                    switch (((StackedEnsembleParameters)this._parms)._metalearner_parameters._distribution) {
                        case custom: {
                            sameParams = ((StackedEnsembleParameters)this._parms)._metalearner_parameters._custom_distribution_func.equals(aModel._parms._custom_distribution_func);
                            break;
                        }
                        case huber: {
                            sameParams = ((StackedEnsembleParameters)this._parms)._metalearner_parameters._huber_alpha == aModel._parms._huber_alpha;
                            break;
                        }
                        case tweedie: {
                            sameParams = ((StackedEnsembleParameters)this._parms)._metalearner_parameters._tweedie_power == aModel._parms._tweedie_power;
                            break;
                        }
                        case quantile: {
                            boolean bl = sameParams = ((StackedEnsembleParameters)this._parms)._metalearner_parameters._quantile_alpha == aModel._parms._quantile_alpha;
                        }
                    }
                    if (aModel instanceof GLMModel && Metalearners.getActualMetalearnerAlgo(((StackedEnsembleParameters)this._parms)._metalearner_algorithm) == Metalearner.Algorithm.glm) {
                        if (firstGLM == null) {
                            firstGLM = (GLMModel)aModel;
                            this.inheritFamilyAndParms(firstGLM._parms);
                        } else {
                            sameParams = ((GLMModel.GLMParameters)((StackedEnsembleParameters)this._parms)._metalearner_parameters)._link.equals((Object)((GLMModel.GLMParameters)((GLMModel)aModel)._parms)._link);
                        }
                    }
                    if (sameParams) continue;
                    Log.warn((Object[])new Object[]{"Base models are inconsistent; they use same distribution but different parameters of the distribution. Reverting to default distribution."});
                    this.inferBasicDistribution();
                    inferredDistributionFromFirstModel = false;
                    continue;
                }
                if (this.distributionFamily(aModel) != this.distributionFamily(this)) {
                    Log.warn((Object[])new Object[]{"Base models are inconsistent; they use different distributions: " + this.distributionFamily(this) + " and: " + this.distributionFamily(aModel) + ". Reverting to default distribution."});
                }
                this.inferBasicDistribution();
                inferredDistributionFromFirstModel = false;
                continue;
            }
            this.modelCategory = aModel._output.getModelCategory();
            inferredDistributionFromFirstModel = this.inferDistributionOrFamily(aModel);
            firstGLM = aModel instanceof GLMModel && inferredDistributionFromFirstModel ? (GLMModel)aModel : null;
            this.responseColumn = aModel._parms._response_column;
            if (!((StackedEnsembleParameters)this._parms)._response_column.equals(this.responseColumn)) {
                throw new H2OIllegalArgumentException("StackedModel response_column must match the response_column of each base model. Found: " + ((StackedEnsembleParameters)this._parms)._response_column + "(StackedEnsemble) and: " + this.responseColumn + " (model " + k + ").");
            }
            basemodel_nfolds = aModel._parms._nfolds;
            basemodel_fold_assignment = aModel._parms._fold_assignment;
            if (basemodel_fold_assignment == Model.Parameters.FoldAssignmentScheme.AUTO) {
                basemodel_fold_assignment = Model.Parameters.FoldAssignmentScheme.Random;
            }
            basemodel_fold_column = aModel._parms._fold_column;
            seed = aModel._parms._seed;
            retrievedFirstModelParams = true;
        }
        if (null == aModel) {
            throw new H2OIllegalArgumentException("When creating a StackedEnsemble you must specify one or more models; " + ((StackedEnsembleParameters)this._parms)._base_models.length + " were specified but none of those were found: " + Arrays.toString(((StackedEnsembleParameters)this._parms)._base_models));
        }
    }

    public void deleteBaseModelPredictions() {
        if (((StackedEnsembleOutput)this._output)._base_model_predictions_keys != null) {
            for (Key<Frame> key : ((StackedEnsembleOutput)this._output)._base_model_predictions_keys) {
                if (((StackedEnsembleOutput)this._output)._levelone_frame_id != null && key.get() != null) {
                    Frame.deleteTempFrameAndItsNonSharedVecs((Frame)((Frame)key.get()), (Frame)((StackedEnsembleOutput)this._output)._levelone_frame_id);
                    continue;
                }
                Keyed.remove(key);
            }
            ((StackedEnsembleOutput)this._output)._base_model_predictions_keys = null;
        }
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        this.deleteBaseModelPredictions();
        if (((StackedEnsembleOutput)this._output)._metalearner != null) {
            ((StackedEnsembleOutput)this._output)._metalearner.remove(fs);
        }
        if (((StackedEnsembleOutput)this._output)._levelone_frame_id != null) {
            ((StackedEnsembleOutput)this._output)._levelone_frame_id.remove(fs);
        }
        return super.remove_impl(fs, cascade);
    }

    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        ab.putKey(((StackedEnsembleOutput)this._output)._metalearner._key);
        for (Key<Model> ks : ((StackedEnsembleParameters)this._parms)._base_models) {
            ab.putKey(ks);
        }
        return super.writeAll_impl(ab);
    }

    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        ab.getKey(((StackedEnsembleOutput)this._output)._metalearner._key, fs);
        for (Key<Model> ks : ((StackedEnsembleParameters)this._parms)._base_models) {
            ab.getKey(ks, fs);
        }
        return super.readAll_impl(ab, fs);
    }

    public StackedEnsembleMojoWriter getMojo() {
        return new StackedEnsembleMojoWriter(this);
    }

    public void deleteCrossValidationModels() {
        if (((StackedEnsembleOutput)this._output)._metalearner != null) {
            ((StackedEnsembleOutput)this._output)._metalearner.deleteCrossValidationModels();
        }
    }

    public void deleteCrossValidationPreds() {
        if (((StackedEnsembleOutput)this._output)._metalearner != null) {
            ((StackedEnsembleOutput)this._output)._metalearner.deleteCrossValidationPreds();
        }
    }

    public void deleteCrossValidationFoldAssignment() {
        if (((StackedEnsembleOutput)this._output)._metalearner != null) {
            ((StackedEnsembleOutput)this._output)._metalearner.deleteCrossValidationFoldAssignment();
        }
    }

    private class StackedEnsemblePredictScoreResult
    extends Model.PredictScoreResult {
        private final ModelMetrics _modelMetrics;

        public StackedEnsemblePredictScoreResult(Frame preds, ModelMetrics modelMetrics) {
            super((Model)StackedEnsembleModel.this, null, preds, preds);
            this._modelMetrics = modelMetrics;
        }

        public ModelMetrics makeModelMetrics(Frame fr, Frame adaptFrm) {
            return this._modelMetrics;
        }

        public ModelMetrics.MetricBuilder<?> getMetricBuilder() {
            throw new UnsupportedOperationException("Stacked Ensemble model doesn't implement MetricBuilder infrastructure code, retrieve your metrics by calling getOrMakeMetrics method.");
        }
    }

    public static class StackedEnsembleOutput
    extends Model.Output {
        public Model _metalearner;
        public Frame _levelone_frame_id;
        public StackingStrategy _stacking_strategy;
        public Key<Frame>[] _base_model_predictions_keys;

        public StackedEnsembleOutput() {
        }

        public StackedEnsembleOutput(StackedEnsemble b) {
            super((ModelBuilder)b);
        }

        public StackedEnsembleOutput(Job job) {
            this._job = job;
        }

        public int nfeatures() {
            return super.nfeatures() - (this._metalearner._parms._fold_column == null ? 0 : 1);
        }
    }

    public static class StackedEnsembleParameters
    extends Model.Parameters {
        public Key<Model>[] _base_models = new Key[0];
        public boolean _keep_levelone_frame = false;
        public boolean _keep_base_model_predictions = false;
        public int _metalearner_nfolds;
        public Model.Parameters.FoldAssignmentScheme _metalearner_fold_assignment;
        public String _metalearner_fold_column;
        public Key<Frame> _blending;
        public MetalearnerTransform _metalearner_transform = MetalearnerTransform.NONE;
        public Metalearner.Algorithm _metalearner_algorithm = Metalearner.Algorithm.AUTO;
        public String _metalearner_params = new String();
        public Model.Parameters _metalearner_parameters;
        public long _score_training_samples = 10000L;

        public String algoName() {
            return "StackedEnsemble";
        }

        public String fullName() {
            return "Stacked Ensemble";
        }

        public String javaName() {
            return StackedEnsembleModel.class.getName();
        }

        public long progressUnits() {
            return 1L;
        }

        public void initMetalearnerParams() {
            this.initMetalearnerParams(this._metalearner_algorithm);
        }

        public void initMetalearnerParams(Metalearner.Algorithm algo) {
            this._metalearner_algorithm = algo;
            this._metalearner_parameters = Metalearners.createParameters(algo.name());
        }

        public final Frame blending() {
            return this._blending == null ? null : (Frame)this._blending.get();
        }

        public String[] getNonPredictors() {
            HashSet<String> nonPredictors = new HashSet<String>();
            nonPredictors.addAll(Arrays.asList(super.getNonPredictors()));
            if (null != this._metalearner_fold_column) {
                nonPredictors.add(this._metalearner_fold_column);
            }
            return nonPredictors.toArray(new String[0]);
        }

        public static enum MetalearnerTransform {
            NONE,
            Logit;


            public Frame transform(StackedEnsembleModel model, Frame frame, Key<Frame> destKey) {
                if (this == Logit) {
                    return new MRTask(){

                        public void map(Chunk[] cs, NewChunk[] ncs) {
                            LinkFunction logitLink = LinkFunctionFactory.getLinkFunction((LinkFunctionType)LinkFunctionType.logit);
                            for (int c = 0; c < cs.length; ++c) {
                                for (int i = 0; i < cs[c]._len; ++i) {
                                    double p = Math.min(0.999999999, Math.max(cs[c].atd(i), 1.0E-9));
                                    ncs[c].addNum(logitLink.link(p));
                                }
                            }
                        }
                    }.doAll(frame.numCols(), (byte)3, frame).outputFrame(destKey, frame._names, (String[][])null);
                }
                throw new RuntimeException();
            }
        }
    }

    public static enum StackingStrategy {
        cross_validation,
        blending;

    }
}

