/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.GamSplines;

import hex.DataInfo;
import hex.gam.GAMModel;
import hex.gam.GamSplines.ThinPlateRegressionUtils;
import hex.genmodel.algos.gam.GamUtilsThinPlateRegression;
import hex.glm.GLMModel;
import hex.util.LinearAlgebraUtils;
import org.apache.commons.math3.util.CombinatoricsUtils;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class ThinPlateDistanceWithKnots
extends MRTask<ThinPlateDistanceWithKnots> {
    final double[][] _knots;
    final int _knotNum;
    final int _d;
    final int _m;
    public final double _constantTerms;
    final int _weightID;
    final boolean _dEven;
    final double[] _oneOverGamColStd;
    final boolean _standardizeGAM;

    public ThinPlateDistanceWithKnots(double[][] knots, int d, double[] oneOGamColStd, boolean standardizeGAM) {
        this._knots = knots;
        this._knotNum = this._knots[0].length;
        this._d = d;
        this._dEven = this._d % 2 == 0;
        this._m = ThinPlateRegressionUtils.calculatem(this._d);
        this._weightID = this._d;
        this._oneOverGamColStd = oneOGamColStd;
        this._standardizeGAM = standardizeGAM;
        this._constantTerms = this._dEven ? Math.pow(-1.0, (double)(this._m + 1) + (double)this._d / 2.0) / (Math.pow(2.0, 2 * this._m - 1) * Math.pow(Math.PI, (double)this._d / 2.0) * (double)CombinatoricsUtils.factorial((int)(this._m - 1)) * (double)CombinatoricsUtils.factorial((int)(this._m - this._d / 2))) : Math.pow(-1.0, this._m) * (double)this._m / ((double)CombinatoricsUtils.factorial((int)(2 * this._m)) * Math.pow(Math.PI, (double)(this._d - 1) / 2.0));
    }

    public void map(Chunk[] chk, NewChunk[] newGamCols) {
        int nrows = chk[0].len();
        double[] rowValues = MemoryManager.malloc8d((int)this._knotNum);
        double[] chkRowValues = MemoryManager.malloc8d((int)this._d);
        for (int rowIndex = 0; rowIndex < nrows; ++rowIndex) {
            if (chk[this._weightID].atd(rowIndex) != 0.0) {
                if (ThinPlateRegressionUtils.checkRowNA(chk, rowIndex)) {
                    ThinPlateRegressionUtils.fillRowOneValue(newGamCols, this._knotNum, Double.NaN);
                    continue;
                }
                ThinPlateDistanceWithKnots.fillRowData(chkRowValues, chk, rowIndex, this._d);
                GamUtilsThinPlateRegression.calculateDistance((double[])rowValues, (double[])chkRowValues, (int)this._knotNum, (double[][])this._knots, (int)this._d, (int)this._m, (boolean)this._dEven, (double)this._constantTerms, (double[])this._oneOverGamColStd, (boolean)this._standardizeGAM);
                ThinPlateRegressionUtils.fillRowArray(newGamCols, this._knotNum, rowValues);
                continue;
            }
            ThinPlateRegressionUtils.fillRowOneValue(newGamCols, this._knotNum, 0.0);
        }
    }

    public static void fillRowData(double[] rowHolder, Chunk[] chk, int rowIndex, int d) {
        for (int colIndex = 0; colIndex < d; ++colIndex) {
            rowHolder[colIndex] = chk[colIndex].atd(rowIndex);
        }
    }

    public static Frame applyTransform(Frame fr, String colNameStart, GAMModel.GAMParameters parms, double[][] zCST, int newColNum) {
        int numCols = fr.numCols();
        DataInfo frInfo = new DataInfo(fr, null, 0, false, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, GLMModel.GLMParameters.MissingValuesHandling.Skip == parms._missing_values_handling, parms._missing_values_handling == GLMModel.GLMParameters.MissingValuesHandling.MeanImputation || parms._missing_values_handling == GLMModel.GLMParameters.MissingValuesHandling.PlugValues, parms.makeImputer(), false, false, false, false, null);
        for (int colInd = 0; colInd < newColNum; ++colInd) {
            fr.add(colNameStart + "_cs_" + colInd, fr.anyVec().makeZero());
        }
        new LinearAlgebraUtils.BMulInPlaceTask(frInfo, zCST, numCols, false).doAll(fr);
        for (int index = 0; index < numCols; ++index) {
            Vec temp = fr.remove(0);
            temp.remove();
        }
        return fr;
    }

    public double[][] generatePenalty(double[][] qmat) {
        double[][] penaltyMat = new double[this._knotNum][this._knotNum];
        double[][] knotsTranspose = ArrayUtils.transpose((double[][])this._knots);
        double[] tempVal = MemoryManager.malloc8d((int)this._knotNum);
        for (int index = 0; index < this._knotNum; ++index) {
            GamUtilsThinPlateRegression.calculateDistance((double[])tempVal, (double[])knotsTranspose[index], (int)this._knotNum, (double[][])this._knots, (int)this._d, (int)this._m, (boolean)this._dEven, (double)this._constantTerms, (double[])this._oneOverGamColStd, (boolean)this._standardizeGAM);
            System.arraycopy(tempVal, 0, penaltyMat[index], 0, this._knotNum);
        }
        return penaltyMat;
    }
}

