/*
 * Decompiled with CFR 0.152.
 */
package hex.generic;

import hex.genmodel.GenModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import water.Key;
import water.fvec.ByteVec;
import water.fvec.Frame;
import water.util.JCodeGen;
import water.util.Log;

class PojoLoader {
    private static final String POJO_EXT = ".java";

    PojoLoader() {
    }

    static GenModel loadPojoFromSourceCode(ByteVec sourceVec, Key<Frame> pojoKey) throws IOException {
        String pojoCode = IOUtils.toString((InputStream)sourceVec.openStream());
        try {
            String path = URI.create(pojoKey.toString()).getPath();
            String fileName = new File(path).getName();
            if (fileName.endsWith(POJO_EXT)) {
                fileName = fileName.substring(0, fileName.length() - POJO_EXT.length());
            }
            return (GenModel)PojoLoader.compileAndInstantiate(fileName, pojoCode);
        }
        catch (Exception e) {
            boolean canCompile = JCodeGen.canCompile();
            boolean selfCheck = PojoLoader.compilationSelfCheck();
            throw new IllegalArgumentException(String.format("POJO compilation failed: Please make sure key '%s' contains a valid POJO source code and you are running a Java JDK (compiler present: '%s', self-check passed: '%s').", pojoKey, canCompile, selfCheck), e);
        }
    }

    static <T> T compileAndInstantiate(String className, String src) throws Exception {
        Class clz = JCodeGen.compile((String)className, (String)src, (boolean)false);
        return clz.newInstance();
    }

    static boolean compilationSelfCheck() {
        String cls = "SelfCheck_" + UUID.randomUUID().toString().replaceAll("-", "_");
        String src = "public class " + cls + " { public double score0() { return Math.E; } }";
        try {
            Object o = PojoLoader.compileAndInstantiate(cls, src);
            Method m = o.getClass().getMethod("score0", new Class[0]);
            Object result = m.invoke(o, new Object[0]);
            return result instanceof Double && (Double)result == Math.E;
        }
        catch (Exception e) {
            Log.err((Object[])new Object[]{"Compilation self-check failed", e});
            return false;
        }
    }
}

