/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import hex.glm.GLMUtils;
import hex.gram.Gram;
import hex.optimization.ADMM;
import hex.optimization.OptimizationUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.IntStream;
import water.Job;
import water.MemoryManager;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MathUtils;

public final class ComputationState {
    final boolean _intercept;
    final int _nclasses;
    private final GLMModel.GLMParameters _parms;
    private GLM.BetaConstraint _bc;
    double _alpha;
    double[] _ymu;
    double[] _u;
    double[] _z;
    boolean _allIn;
    int _iter;
    int _iterHGLM_GLMMME;
    private double _lambda = 0.0;
    private double _lambdaMax = Double.NaN;
    private GLM.GLMGradientInfo _ginfo;
    private double _likelihood;
    private double _gradientErr;
    private boolean _lambdaNull;
    private double _gMax;
    private DataInfo _activeData;
    private GLM.BetaConstraint _activeBC = null;
    private double[] _beta;
    private double[] _ubeta;
    private double[] _psi;
    private double[] _phi;
    private double _tau;
    private double _correction_HL;
    double[] _sumEtaSquareConvergence;
    double[] _likelihoodInfo;
    public String[] _randCoeffNames;
    private Frame _priorw_wpsi;
    final DataInfo _dinfo;
    private GLM.GLMGradientSolver _gslvr;
    private final Job _job;
    private int _activeClass = -1;
    double[][][] _penaltyMatrix;
    int[][] _gamBetaIndices;
    int _totalBetaLength;
    int _betaLengthPerClass;
    public boolean _lsNeeded = false;
    public DataInfo[] _activeDataMultinomial;
    private double _betaDiff;
    private double _relImprovement;
    String convergenceMsg = "";
    GramXY _currGram;
    GLMModel.GLMWeightsFun _glmw;

    public ComputationState(Job job, GLMModel.GLMParameters parms, DataInfo dinfo, GLM.BetaConstraint bc, int nclasses) {
        this._job = job;
        this._parms = parms;
        this._activeBC = this._bc = bc;
        this._activeData = this._dinfo = dinfo;
        this._intercept = this._parms._intercept;
        this._nclasses = GLMModel.GLMParameters.Family.fractionalbinomial == parms._family ? 2 : (GLMModel.GLMParameters.Family.multinomial == parms._family || GLMModel.GLMParameters.Family.ordinal == parms._family ? nclasses : 1);
        this._alpha = this._parms._alpha[0];
        this._totalBetaLength = (dinfo.fullN() + 1) * this._nclasses;
        this._betaLengthPerClass = dinfo.fullN() + 1;
        if (this._parms._HGLM) {
            this._sumEtaSquareConvergence = new double[2];
            if (this._parms._calc_like) {
                this._likelihoodInfo = new double[4];
            }
        }
    }

    public ComputationState(Job job, GLMModel.GLMParameters parms, DataInfo dinfo, GLM.BetaConstraint bc, int nclasses, double[][][] penaltyMat, int[][] gamColInd) {
        this(job, parms, dinfo, bc, nclasses);
        this._penaltyMatrix = penaltyMat;
        this._gamBetaIndices = gamColInd;
        this._lambdaNull = this._parms._lambda == null && !this._parms._lambda_search;
    }

    void copyCheckModel2State(GLMModel model, int[][] _gamColIndices) {
        GLMModel.GLMOutput modelOutput = (GLMModel.GLMOutput)model._output;
        int coefLen = this._nclasses > 2 ? (this._dinfo.fullN() + 1) * this._nclasses : this._dinfo.fullN() + 1;
        int submodelInd = modelOutput._submodels.length > 1 ? modelOutput._submodels.length - 1 : 0;
        this.setIter(modelOutput._submodels[submodelInd].iteration);
        this.setAlpha(modelOutput._submodels[submodelInd].alpha_value);
        if (submodelInd > 0) {
            int preCurrSubmodelInd = GLMModel.GLMParameters.Family.gaussian.equals((Object)this._parms._family) ? submodelInd : submodelInd - 1;
            this._activeData._activeCols = modelOutput._submodels[preCurrSubmodelInd].idxs;
            double[] betaExpand = GLMModel.GLMParameters.Family.multinomial.equals((Object)this._parms._family) ? ArrayUtils.expandAndScatter((double[])modelOutput._submodels[preCurrSubmodelInd].beta, (int)coefLen, (int[])this._activeData._activeCols) : this.expandBeta(modelOutput._submodels[preCurrSubmodelInd].beta);
            GLM.GLMGradientInfo ginfo = new GLM.GLMGradientSolver(this._job, this._parms, this._dinfo, 0.0, this.activeBC(), this._penaltyMatrix, _gamColIndices).getGradient(betaExpand);
            this._activeData._activeCols = null;
            this.updateState(betaExpand, ginfo);
            this.setLambdaSimple(this._parms._lambda[preCurrSubmodelInd]);
        }
        if (!GLMModel.GLMParameters.Family.gaussian.equals((Object)this._parms._family)) {
            this.setLambda(modelOutput._submodels[submodelInd].lambda_value);
        }
        double[] expandedBeta = modelOutput._submodels[submodelInd].idxs == null ? modelOutput._submodels[submodelInd].beta : ArrayUtils.expandAndScatter((double[])modelOutput._submodels[submodelInd].beta, (int)coefLen, (int[])modelOutput._submodels[submodelInd].idxs);
        GLM.GLMGradientInfo ginfo = new GLM.GLMGradientSolver(this._job, this._parms, this._dinfo, 0.0, this.activeBC(), this._penaltyMatrix, _gamColIndices).getGradient(expandedBeta);
        this.updateState(expandedBeta, ginfo);
        if (model._betaCndCheckpoint != null && (this._activeData._activeCols == null || this._activeData._activeCols.length != model._betaCndCheckpoint.length)) {
            double[] betaCndCheckpoint = ArrayUtils.expandAndScatter((double[])model._betaCndCheckpoint, (int)coefLen, (int[])modelOutput._submodels[submodelInd].idxs);
            if (this._activeData._activeCols != null) {
                betaCndCheckpoint = ComputationState.extractSubRange(betaCndCheckpoint.length, 0, this.activeData()._activeCols, betaCndCheckpoint);
            }
            model._betaCndCheckpoint = betaCndCheckpoint;
        }
    }

    public void set_sumEtaSquareConvergence(double[] sumInfo) {
        this._sumEtaSquareConvergence = sumInfo;
    }

    public void set_beta_HGLM(double[] beta, int startIdx, int len, boolean interceptFirst) {
        if (this._beta == null) {
            this._beta = new double[len];
        }
        if (interceptFirst) {
            int lastIndex = len - 1;
            System.arraycopy(beta, startIdx + 1, this._beta, 0, lastIndex);
            this._beta[lastIndex] = beta[startIdx];
        } else {
            System.arraycopy(beta, startIdx, this._beta, 0, len);
        }
    }

    public void set_likelihoodInfo(double hlik, double pvh, double pbvh, double cAIC) {
        this._likelihoodInfo[0] = hlik;
        this._likelihoodInfo[1] = pvh;
        this._likelihoodInfo[2] = pbvh;
        this._likelihoodInfo[3] = cAIC;
    }

    public void set_ubeta_HGLM(double[] ubeta, int startIdx, int len) {
        if (this._ubeta == null) {
            this._ubeta = new double[len];
        }
        System.arraycopy(ubeta, startIdx, this._ubeta, 0, len);
    }

    public double[] get_psi() {
        return this._psi;
    }

    public double get_correction_HL() {
        return this._correction_HL;
    }

    public double[] get_phi() {
        return this._phi;
    }

    public Frame get_priorw_wpsi() {
        return this._priorw_wpsi;
    }

    public double get_tau() {
        return this._tau;
    }

    public boolean getLambdaNull() {
        return this._lambdaNull;
    }

    public void set_tau(double tau) {
        this._tau = tau;
    }

    public void set_psi(double[] psi) {
        assert (this._psi.length == psi.length) : "Length of _psi and psi should be the same.";
        System.arraycopy(psi, 0, this._psi, 0, psi.length);
    }

    public void set_phi(double[] phi) {
        assert (this._phi.length == phi.length) : "Length of _phi and phi should be the same.";
        System.arraycopy(phi, 0, this._phi, 0, phi.length);
    }

    public GLM.GLMGradientSolver gslvr() {
        return this._gslvr;
    }

    public double lambda() {
        return this._lambda;
    }

    public double alpha() {
        return this._alpha;
    }

    public void setLambdaMax(double lmax) {
        this._lambdaMax = lmax;
    }

    public void setgMax(double gmax) {
        this._gMax = gmax;
    }

    public void setAlpha(double alpha) {
        this._alpha = alpha;
        this.setLambdaMax(this._gMax / Math.max(0.01, alpha));
    }

    public void setLambda(double lambda) {
        this.adjustToNewLambda(0.0, this._lambda);
        this.applyStrongRules(lambda, this._lambda);
        this._lambda = lambda;
        this._gslvr = this._penaltyMatrix == null ? new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, this.l2pen(), this._activeBC) : new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, this.l2pen(), this._activeBC, this._penaltyMatrix, this._gamBetaIndices);
        this.adjustToNewLambda(lambda, 0.0);
    }

    public double[] beta() {
        if (this._activeClass != -1) {
            return this.betaMultinomial(this._activeClass, this._beta);
        }
        return this._beta;
    }

    public double[] ubeta() {
        return this._ubeta;
    }

    public GLM.GLMGradientInfo ginfo() {
        return this._ginfo == null ? (this._ginfo = this.gslvr().getGradient(this.beta())) : this._ginfo;
    }

    public GLM.BetaConstraint activeBC() {
        return this._activeBC;
    }

    public double likelihood() {
        return this._likelihood;
    }

    public boolean ginfoNull() {
        return this._ginfo == null;
    }

    public DataInfo activeData() {
        if (this._activeClass != -1) {
            return this.activeDataMultinomial(this._activeClass);
        }
        return this._activeData;
    }

    public DataInfo activeDataMultinomial() {
        return this._activeData;
    }

    public void dropActiveData() {
        this._activeData = null;
    }

    public String toString() {
        return "iter=" + this._iter + " lmb=" + GLM.lambdaFormatter.format(this._lambda) + " alpha=" + GLM.lambdaFormatter.format(this._alpha) + " obj=" + MathUtils.roundToNDigits((double)this.objective(), (int)4) + " imp=" + GLM.lambdaFormatter.format(this._relImprovement) + " bdf=" + GLM.lambdaFormatter.format(this._betaDiff);
    }

    private void adjustToNewLambda(double lambdaNew, double lambdaOld) {
        double ldiff = lambdaNew - lambdaOld;
        if (ldiff == 0.0 || this.l2pen() == 0.0) {
            return;
        }
        double l2pen = 0.5 * ArrayUtils.l2norm2((double[])this._beta, (boolean)true);
        if (this._parms._family == GLMModel.GLMParameters.Family.ordinal) {
            l2pen /= (double)this._nclasses;
        }
        if (l2pen > 0.0) {
            if (this._ginfo == null) {
                this._ginfo = this.ginfo();
            }
            if (this._parms._family == GLMModel.GLMParameters.Family.multinomial || this._parms._family == GLMModel.GLMParameters.Family.ordinal) {
                l2pen = 0.0;
                int off = 0;
                for (int c = 0; c < this._nclasses; ++c) {
                    DataInfo activeData = this.activeDataMultinomial(c);
                    for (int i = 0; i < activeData.fullN(); ++i) {
                        double b = this._beta[off + i];
                        int n = off + i;
                        this._ginfo._gradient[n] = this._ginfo._gradient[n] + ldiff * b;
                        l2pen += b * b;
                    }
                    if (this._parms._family == GLMModel.GLMParameters.Family.ordinal) break;
                    off += activeData.fullN() + 1;
                }
                l2pen *= 0.5;
            } else {
                for (int i = 0; i < this._activeData.fullN(); ++i) {
                    int n = i;
                    this._ginfo._gradient[n] = this._ginfo._gradient[n] + ldiff * this._beta[i];
                }
            }
        }
        this._ginfo = new GLM.GLMGradientInfo(this._ginfo._likelihood, this._ginfo._objVal + ldiff * l2pen, this._ginfo._gradient);
    }

    public double l1pen() {
        return this._alpha * this._lambda;
    }

    public double l2pen() {
        return (1.0 - this._alpha) * this._lambda;
    }

    protected void applyStrongRules(double lambdaNew, double lambdaOld) {
        lambdaNew = Math.min(this._lambdaMax, lambdaNew);
        lambdaOld = Math.min(this._lambdaMax, lambdaOld);
        if (this._parms._family == GLMModel.GLMParameters.Family.multinomial || this._parms._family == GLMModel.GLMParameters.Family.ordinal) {
            this.applyStrongRulesMultinomial(lambdaNew, lambdaOld);
            return;
        }
        int P = this._dinfo.fullN();
        this._activeBC = this._bc;
        this._activeData = this._activeData != null ? this._activeData : this._dinfo;
        boolean bl = this._allIn = this._allIn || this._alpha * lambdaNew == 0.0 || this._activeBC.hasBounds();
        if (!this._allIn) {
            int[] nArray;
            int newlySelected = 0;
            double rhs = Math.max(0.0, this._alpha * (2.0 * lambdaNew - lambdaOld));
            int[] newCols = MemoryManager.malloc4((int)P);
            int j = 0;
            if (this._activeData._activeCols == null) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = P;
            } else {
                nArray = this._activeData.activeCols();
            }
            int[] oldActiveCols = nArray;
            for (int i = 0; i < P; ++i) {
                if (j < oldActiveCols.length && oldActiveCols[j] == i) {
                    ++j;
                    continue;
                }
                if (!(this._ginfo._gradient[i] > rhs) && !(-this._ginfo._gradient[i] > rhs)) continue;
                newCols[newlySelected++] = i;
            }
            if (this._parms._max_active_predictors != -1 && oldActiveCols.length + newlySelected - 1 > this._parms._max_active_predictors) {
                Integer[] bigInts = ArrayUtils.toIntegers((int[])newCols, (int)0, (int)newlySelected);
                Arrays.sort(bigInts, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return (int)Math.signum(((ComputationState)ComputationState.this)._ginfo._gradient[o2] * ((ComputationState)ComputationState.this)._ginfo._gradient[o2] - ((ComputationState)ComputationState.this)._ginfo._gradient[o1] * ((ComputationState)ComputationState.this)._ginfo._gradient[o1]);
                    }
                });
                newCols = ArrayUtils.toInt((Integer[])bigInts, (int)0, (int)(this._parms._max_active_predictors - oldActiveCols.length + 1));
                Arrays.sort(newCols);
            } else {
                newCols = Arrays.copyOf(newCols, newlySelected);
            }
            newCols = ArrayUtils.sortedMerge((int[])oldActiveCols, (int[])newCols);
            int active = newCols.length;
            boolean bl2 = this._allIn = active == P;
            if (!this._allIn) {
                int[] cols = newCols;
                assert (cols[active - 1] == P);
                this._beta = ArrayUtils.select((double[])this._beta, (int[])cols);
                if (this._u != null) {
                    this._u = ArrayUtils.select((double[])this._u, (int[])cols);
                }
                this._activeData = this._dinfo.filterExpandedColumns(cols);
                assert (this._activeData.activeCols().length == this._beta.length);
                assert (this._u == null || this._activeData.activeCols().length == this._u.length);
                this._ginfo = new GLM.GLMGradientInfo(this._ginfo._likelihood, this._ginfo._objVal, ArrayUtils.select((double[])this._ginfo._gradient, (int[])cols));
                this._activeBC = this._bc.filterExpandedColumns(this._activeData.activeCols());
                GLM.GLMGradientSolver gLMGradientSolver = this._gslvr = this._penaltyMatrix == null ? new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, (1.0 - this._alpha) * this._lambda, this._bc) : new GLM.GLMGradientSolver(this._job, this._parms, this._dinfo, (1.0 - this._alpha) * this._lambda, this._bc, this._penaltyMatrix, this._gamBetaIndices);
                assert (this._beta.length == cols.length);
                return;
            }
        }
        this._activeData = this._dinfo;
    }

    public DataInfo activeDataMultinomial(int c) {
        return this._activeDataMultinomial != null ? this._activeDataMultinomial[c] : this._dinfo;
    }

    public static double[] extractSubRange(int N, int c, int[] ids, double[] src) {
        if (ids == null) {
            return Arrays.copyOfRange(src, c * N, c * N + N);
        }
        double[] res = MemoryManager.malloc8d((int)ids.length);
        int j = 0;
        int off = c * N;
        for (int i : ids) {
            res[j++] = src[off + i];
        }
        return res;
    }

    static void fillSubRange(int N, int c, int[] ids, double[] src, double[] dst) {
        if (ids == null) {
            System.arraycopy(src, 0, dst, c * N, N);
        } else {
            int j = 0;
            int off = c * N;
            for (int i : ids) {
                dst[off + i] = src[j++];
            }
        }
    }

    public double[] betaMultinomial() {
        return this._beta;
    }

    public double[] betaMultinomial(int c, double[] beta) {
        return ComputationState.extractSubRange(this._activeData.fullN() + 1, c, this._activeDataMultinomial[c].activeCols(), beta);
    }

    public double[] betaMultinomialFull(int c, double[] beta) {
        if (this._parms._remove_collinear_columns) {
            return ComputationState.extractSubRange(this._betaLengthPerClass, c, this._activeDataMultinomial[c].activeCols(), beta);
        }
        return ComputationState.extractSubRange(this._activeData.fullN() + 1, c, this._activeDataMultinomial[c].activeCols(), beta);
    }

    public double[] shrinkFullArray(double[] fullArray) {
        if (this._activeData.activeCols() == null) {
            return fullArray;
        }
        int[] activeColsAllClass = ComputationState.genActiveColsAllClass(this._activeData.activeCols().length * this._nclasses, this._betaLengthPerClass, this._activeData.activeCols(), this._nclasses);
        return ArrayUtils.select((double[])fullArray, (int[])activeColsAllClass);
    }

    public static double[] expandToFullArray(double[] shortenArr, int[] activeCols, int _totalBetaLength, int nclasses, int betaLengthPerClass) {
        if (activeCols == null) {
            return shortenArr;
        }
        int[] activeColsAllClass = ComputationState.genActiveColsAllClass(activeCols.length * nclasses, betaLengthPerClass, activeCols, nclasses);
        double[] fullArray = new double[_totalBetaLength];
        ComputationState.fillSubRange(_totalBetaLength, 0, activeColsAllClass, shortenArr, fullArray);
        return fullArray;
    }

    public static int[] genActiveColsAllClass(int activeColsLen, int numBetaPerClass, int[] activeColsOrig, int nclasses) {
        int[] activeCols = new int[activeColsLen];
        int offset = 0;
        int[] activeColsOneClass = activeColsOrig;
        for (int classIndex = 0; classIndex < nclasses; ++classIndex) {
            int finalOffset = numBetaPerClass * classIndex;
            int[] activeCols1Class = IntStream.of(activeColsOneClass).map(i -> i + finalOffset).toArray();
            int num2Copy = activeColsOneClass.length;
            System.arraycopy(activeCols1Class, 0, activeCols, offset, num2Copy);
            offset += num2Copy;
        }
        return activeCols;
    }

    public int[] genActiveColsIndClass(int activeColsLen, int numBetaPerClass, int[] activeColsOrig, int activeClass, int nclasses) {
        int finalOffset;
        int[] activeCols = new int[activeColsLen];
        int offset = 0;
        int[] activeColsOneClass = activeColsOrig;
        for (int classIndex = 0; classIndex < activeClass; ++classIndex) {
            finalOffset = numBetaPerClass * classIndex;
            int num2Copy = activeColsOneClass.length;
            int[] activeCols1Class = IntStream.of(activeColsOneClass).map(i -> i + finalOffset).toArray();
            System.arraycopy(activeCols1Class, 0, activeCols, offset, num2Copy);
            offset += num2Copy;
        }
        for (int classInd = activeClass; classInd < nclasses; ++classInd) {
            finalOffset = numBetaPerClass * classInd;
            int[] activeCols1Class = IntStream.range(0, numBetaPerClass).map(i -> i + finalOffset).toArray();
            System.arraycopy(activeCols1Class, 0, activeCols, offset, numBetaPerClass);
            offset += numBetaPerClass;
        }
        return activeCols;
    }

    public GLMSubsetGinfo ginfoMultinomial(int c) {
        return new GLMSubsetGinfo(this._ginfo, this._activeData.fullN() + 1, c, this._activeDataMultinomial[c].activeCols());
    }

    public GLMSubsetGinfo ginfoMultinomialRCC(int c) {
        if (this._activeData.fullN() + 1 == this._activeData.activeCols().length) {
            return new GLMSubsetGinfo(this._ginfo, this._activeData.fullN() + 1, c, IntStream.range(0, this._activeData.activeCols().length).toArray());
        }
        return new GLMSubsetGinfo(this._ginfo, this._activeData.fullN() + 1, c, this._activeData.activeCols());
    }

    public void setBC(GLM.BetaConstraint bc) {
        this._activeBC = this._bc = bc;
    }

    public void setActiveClass(int activeClass) {
        this._activeClass = activeClass;
    }

    public double deviance() {
        switch (this._parms._family) {
            case gaussian: 
            case binomial: 
            case quasibinomial: 
            case ordinal: 
            case multinomial: 
            case fractionalbinomial: {
                return 2.0 * this.likelihood();
            }
            case poisson: 
            case gamma: 
            case negativebinomial: 
            case tweedie: {
                return this.likelihood();
            }
        }
        throw new RuntimeException("unknown family " + (Object)((Object)this._parms._family));
    }

    public OptimizationUtils.GradientSolver gslvrMultinomial(final int c) {
        double[] betaCopy = new double[this._totalBetaLength];
        if (this._beta.length < this._totalBetaLength) {
            int[] activeCols;
            if (this._beta.length == this._activeData.activeCols().length * this._nclasses) {
                activeCols = ComputationState.genActiveColsAllClass(this._beta.length, this._betaLengthPerClass, this._activeData.activeCols(), this._nclasses);
                ComputationState.fillSubRange(this._totalBetaLength, 0, activeCols, this._beta, betaCopy);
            } else {
                activeCols = this.genActiveColsIndClass(this._beta.length, this._betaLengthPerClass, this._activeData.activeCols(), c, this._nclasses);
                ComputationState.fillSubRange(this._totalBetaLength, 0, activeCols, this._beta, betaCopy);
            }
        } else {
            System.arraycopy(this._beta, 0, betaCopy, 0, this._totalBetaLength);
        }
        final double[] fullbeta = betaCopy;
        return new OptimizationUtils.GradientSolver(){

            @Override
            public OptimizationUtils.GradientInfo getGradient(double[] beta) {
                ComputationState.fillSubRange(ComputationState.this._dinfo.fullN() + 1, c, ComputationState.this._activeDataMultinomial[c].activeCols(), beta, fullbeta);
                GLM.GLMGradientInfo fullGinfo = ComputationState.this._gslvr.getGradient(fullbeta);
                if (fullbeta.length > fullGinfo._gradient.length) {
                    double[] fullGinfoGradient = ComputationState.expandToFullArray(fullGinfo._gradient, ComputationState.this._activeData.activeCols(), ComputationState.this._totalBetaLength, ComputationState.this._nclasses, ComputationState.this._betaLengthPerClass);
                    fullGinfo._gradient = fullGinfoGradient;
                }
                return new GLMSubsetGinfo(fullGinfo, ComputationState.this._betaLengthPerClass, c, ComputationState.this._activeData.activeCols());
            }

            @Override
            public OptimizationUtils.GradientInfo getObjective(double[] beta) {
                return this.getGradient(beta);
            }
        };
    }

    public void setBetaMultinomial(int c, double[] beta, double[] bc) {
        if (this._u != null) {
            Arrays.fill(this._u, 0.0);
        }
        if (this._parms._remove_collinear_columns) {
            ComputationState.fillSubRange(this._betaLengthPerClass, c, this._activeDataMultinomial[c].activeCols(), bc, beta);
        } else {
            ComputationState.fillSubRange(this._activeData.fullN() + 1, c, this._activeDataMultinomial[c].activeCols(), bc, beta);
        }
    }

    protected int applyStrongRulesMultinomial_old(double lambdaNew, double lambdaOld) {
        int P = this._dinfo.fullN();
        int N = P + 1;
        int selected = 0;
        this._activeBC = this._bc;
        this._activeData = this._dinfo;
        if (!this._allIn) {
            if (this._activeDataMultinomial == null) {
                this._activeDataMultinomial = new DataInfo[this._nclasses];
            }
            double rhs = this._alpha * (2.0 * lambdaNew - lambdaOld);
            int[] oldActiveCols = this._activeData._activeCols == null ? new int[]{} : this._activeData.activeCols();
            int[] cols = MemoryManager.malloc4((int)(N * this._nclasses));
            int j = 0;
            for (int c = 0; c < this._nclasses; ++c) {
                int i;
                int start = selected;
                for (i = 0; i < P; ++i) {
                    if (j < oldActiveCols.length && i == oldActiveCols[j]) {
                        cols[selected++] = i;
                        ++j;
                        continue;
                    }
                    if (!(this._ginfo._gradient[c * N + i] > rhs) && !(this._ginfo._gradient[c * N + i] < -rhs)) continue;
                    cols[selected++] = i;
                }
                cols[selected++] = P;
                this._activeDataMultinomial[c] = this._dinfo.filterExpandedColumns(Arrays.copyOfRange(cols, start, selected));
                i = start;
                while (i < selected) {
                    int n = i++;
                    cols[n] = cols[n] + c * N;
                }
            }
            this._allIn = selected == cols.length;
        }
        return selected;
    }

    protected void applyStrongRulesMultinomial(double lambdaNew, double lambdaOld) {
        int P = this._dinfo.fullN();
        int N = P + 1;
        int selected = 0;
        this._activeBC = this._bc;
        this._activeData = this._dinfo;
        if (!this._allIn) {
            if (this._activeDataMultinomial == null) {
                this._activeDataMultinomial = new DataInfo[this._nclasses];
            }
            double rhs = this._alpha * (2.0 * lambdaNew - lambdaOld);
            int[] cols = MemoryManager.malloc4((int)(N * this._nclasses));
            int oldActiveColsTotal = 0;
            for (int c = 0; c < this._nclasses; ++c) {
                int[] nArray;
                int j = 0;
                if (this._activeDataMultinomial[c] == null) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = P;
                } else {
                    nArray = this._activeDataMultinomial[c]._activeCols;
                }
                int[] oldActiveCols = nArray;
                oldActiveColsTotal += oldActiveCols.length;
                for (int i = 0; i < P; ++i) {
                    if (j < oldActiveCols.length && i == oldActiveCols[j]) {
                        ++j;
                        continue;
                    }
                    if (this._ginfo == null) {
                        this._ginfo = this.ginfo();
                    }
                    if (!(this._ginfo._gradient[c * N + i] > rhs) && !(this._ginfo._gradient[c * N + i] < -rhs)) continue;
                    cols[selected++] = c * N + i;
                }
            }
            if (this._parms._max_active_predictors != -1 && this._parms._max_active_predictors - oldActiveColsTotal + this._nclasses < selected) {
                Integer[] bigInts = ArrayUtils.toIntegers((int[])cols, (int)0, (int)selected);
                Arrays.sort(bigInts, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return (int)Math.signum(((ComputationState)ComputationState.this)._ginfo._gradient[o2] * ((ComputationState)ComputationState.this)._ginfo._gradient[o2] - ((ComputationState)ComputationState.this)._ginfo._gradient[o1] * ((ComputationState)ComputationState.this)._ginfo._gradient[o1]);
                    }
                });
                cols = ArrayUtils.toInt((Integer[])bigInts, (int)0, (int)(this._parms._max_active_predictors - oldActiveColsTotal + this._nclasses));
                Arrays.sort(cols);
                selected = cols.length;
            }
            int i = 0;
            int[] cs = new int[P + 1];
            int sum = 0;
            for (int c = 0; c < this._nclasses; ++c) {
                int[] nArray;
                int[] classcols = cs;
                if (this._activeDataMultinomial[c] == null) {
                    int[] nArray3 = new int[1];
                    nArray = nArray3;
                    nArray3[0] = P;
                } else {
                    nArray = this._activeDataMultinomial[c]._activeCols;
                }
                int[] oldActiveCols = nArray;
                int k = 0;
                while (i < selected && cols[i] < (c + 1) * N) {
                    classcols[k++] = cols[i++] - c * N;
                }
                classcols = ArrayUtils.sortedMerge((int[])oldActiveCols, (int[])Arrays.copyOf(classcols, k));
                sum += classcols.length;
                this._activeDataMultinomial[c] = this._dinfo.filterExpandedColumns(classcols);
            }
            assert (this._parms._max_active_predictors == -1 || sum <= this._parms._max_active_predictors + this._nclasses) : "sum = " + sum + " max_active_preds = " + this._parms._max_active_predictors + ", nclasses = " + this._nclasses;
            this._allIn = sum == N * this._nclasses;
        }
    }

    protected boolean checkKKTsMultinomial() {
        return true;
    }

    protected boolean checkKKTs() {
        if (this._parms._family == GLMModel.GLMParameters.Family.multinomial || this._parms._family == GLMModel.GLMParameters.Family.ordinal) {
            return this.checkKKTsMultinomial();
        }
        double[] beta = this._beta;
        double[] u = this._u;
        if (this._activeData._activeCols != null) {
            beta = ArrayUtils.expandAndScatter((double[])beta, (int)(this._dinfo.fullN() + 1), (int[])this._activeData._activeCols);
            if (this._u != null) {
                u = ArrayUtils.expandAndScatter((double[])this._u, (int)(this._dinfo.fullN() + 1), (int[])this._activeData._activeCols);
            }
        }
        int[] activeCols = this._activeData.activeCols();
        if (beta != this._beta || this._ginfo == null) {
            this._gslvr = this._penaltyMatrix == null ? new GLM.GLMGradientSolver(this._job, this._parms, this._dinfo, (1.0 - this._alpha) * this._lambda, this._bc) : new GLM.GLMGradientSolver(this._job, this._parms, this._dinfo, (1.0 - this._alpha) * this._lambda, this._bc, this._penaltyMatrix, this._gamBetaIndices);
            this._ginfo = this._gslvr.getGradient(beta);
        }
        double[] grad = (double[])this._ginfo._gradient.clone();
        double err = 1.0E-4;
        if (u != null && u != this._u) {
            int k = 0;
            for (int i = 0; i < u.length; ++i) {
                if (this._activeData._activeCols[k] == i) {
                    ++k;
                    continue;
                }
                assert (u[i] == 0.0);
                u[i] = -grad[i];
            }
        }
        ADMM.subgrad(this._alpha * this._lambda, beta, grad);
        for (int c : activeCols) {
            if (grad[c] > err) {
                err = grad[c];
                continue;
            }
            if (!(grad[c] < -err)) continue;
            err = -grad[c];
        }
        this._gradientErr = err;
        this._beta = beta;
        this._u = u;
        this._activeBC = null;
        if (this._parms._max_active_predictors == this._activeData.fullN()) {
            Log.info((Object[])new Object[]{"skipping KKT check, reached maximum number of active predictors (" + this._parms._max_active_predictors + ")"});
        } else if (!this._allIn) {
            int[] failedCols = new int[64];
            int fcnt = 0;
            for (int i = 0; i < grad.length - 1; ++i) {
                if (Arrays.binarySearch(activeCols, i) >= 0 || !(grad[i] > err) && !(-grad[i] > err)) continue;
                if (fcnt == failedCols.length) {
                    failedCols = Arrays.copyOf(failedCols, failedCols.length << 1);
                }
                failedCols[fcnt++] = i;
            }
            if (fcnt > 0) {
                Log.info((Object[])new Object[]{fcnt + " variables failed KKT conditions, adding them to the model and recomputing."});
                int n = activeCols.length;
                int[] newCols = Arrays.copyOf(activeCols, activeCols.length + fcnt);
                for (int i = 0; i < fcnt; ++i) {
                    newCols[n + i] = failedCols[i];
                }
                Arrays.sort(newCols);
                this._beta = ArrayUtils.select((double[])beta, (int[])newCols);
                if (this._u != null) {
                    this._u = ArrayUtils.select((double[])this._u, (int[])newCols);
                }
                this._ginfo = new GLM.GLMGradientInfo(this._ginfo._likelihood, this._ginfo._objVal, ArrayUtils.select((double[])this._ginfo._gradient, (int[])newCols));
                this._activeData = this._dinfo.filterExpandedColumns(newCols);
                this._activeBC = this._bc.filterExpandedColumns(this._activeData.activeCols());
                this._gslvr = this._penaltyMatrix == null ? new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, (1.0 - this._alpha) * this._lambda, this._activeBC) : new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, (1.0 - this._alpha) * this._lambda, this._activeBC, this._penaltyMatrix, this._gamBetaIndices);
                return false;
            }
        }
        return true;
    }

    public void addOffset2Cols(int[] cols) {
        int offset = this._activeClass * this._activeData.activeCols().length;
        int colsLen = cols.length;
        for (int index = 0; index < colsLen; ++index) {
            cols[index] = cols[index] + offset;
        }
    }

    public int[] removeCols(int[] cols) {
        int[] activeCols;
        int[] colsWOffset = (int[])cols.clone();
        if (this._nclasses > 2 && this._parms._remove_collinear_columns) {
            activeCols = ArrayUtils.removeIds((int[])this._activeDataMultinomial[this._activeClass].activeCols(), (int[])cols);
            this.addOffset2Cols(colsWOffset);
        } else {
            activeCols = ArrayUtils.removeIds((int[])this._activeData.activeCols(), (int[])cols);
        }
        if (this._beta != null) {
            this._beta = ArrayUtils.removeIds((double[])this._beta, (int[])colsWOffset);
        }
        if (this._u != null) {
            this._u = ArrayUtils.removeIds((double[])this._u, (int[])colsWOffset);
        }
        if (this._ginfo != null && this._ginfo._gradient != null) {
            this._ginfo._gradient = ArrayUtils.removeIds((double[])this._ginfo._gradient, (int[])colsWOffset);
        }
        this._activeData = this._dinfo.filterExpandedColumns(activeCols);
        this._activeBC = this._bc.filterExpandedColumns(activeCols);
        this._gslvr = this._penaltyMatrix == null ? new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, (1.0 - this._alpha) * this._lambda, this._activeBC) : new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, (1.0 - this._alpha) * this._lambda, this._activeBC, this._penaltyMatrix, this._gamBetaIndices);
        this._currGram = null;
        return activeCols;
    }

    private double penalty(double[] beta) {
        if (this._lambda == 0.0) {
            return 0.0;
        }
        double l1norm = 0.0;
        double l2norm = 0.0;
        if (this._parms._family == GLMModel.GLMParameters.Family.multinomial || this._parms._family == GLMModel.GLMParameters.Family.ordinal) {
            int len = beta.length / this._nclasses;
            assert (len * this._nclasses == beta.length);
            for (int c = 0; c < this._nclasses; ++c) {
                for (int i = c * len; i < (c + 1) * len - 1; ++i) {
                    double d = beta[i];
                    l1norm += d >= 0.0 ? d : -d;
                    l2norm += d * d;
                }
                if (this._parms._family != GLMModel.GLMParameters.Family.ordinal) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < beta.length - 1; ++i) {
                double d = beta[i];
                l1norm += d >= 0.0 ? d : -d;
                l2norm += d * d;
            }
        }
        return this.l1pen() * l1norm + 0.5 * this.l2pen() * l2norm;
    }

    public double objective() {
        return this._beta == null ? Double.MAX_VALUE : this.objective(this._beta, this._likelihood);
    }

    public double objective(double[] beta, double likelihood) {
        double gamVal = 0.0;
        if (this._parms._glmType == GLMModel.GLMParameters.GLMType.gam) {
            gamVal = beta.length == this._totalBetaLength ? GLMUtils.calSmoothNess(beta, this._penaltyMatrix, this._gamBetaIndices) : GLMUtils.calSmoothNess(this.expandBeta(beta), this._penaltyMatrix, this._gamBetaIndices);
        }
        return likelihood * this._parms._obj_reg + gamVal + this.penalty(beta) + (this._activeBC == null ? 0.0 : this._activeBC.proxPen(beta));
    }

    protected double updateState(double[] beta, double likelihood) {
        this._betaDiff = ArrayUtils.linfnorm((double[])(this._beta == null ? beta : ArrayUtils.subtract((double[])this._beta, (double[])beta)), (boolean)false);
        double objOld = this.objective();
        this._beta = beta;
        this._ginfo = null;
        this._likelihood = likelihood;
        this._relImprovement = (objOld - this.objective()) / Math.abs(objOld);
        return this._relImprovement;
    }

    public boolean converged() {
        boolean converged = false;
        if (this._betaDiff < this._parms._beta_epsilon) {
            this.convergenceMsg = "betaDiff < eps; betaDiff = " + this._betaDiff + ", eps = " + this._parms._beta_epsilon;
            converged = true;
        } else if (this._relImprovement < this._parms._objective_epsilon) {
            this.convergenceMsg = "relImprovement < eps; relImprovement = " + this._relImprovement + ", eps = " + this._parms._objective_epsilon;
            converged = true;
        } else {
            this.convergenceMsg = "not converged, betaDiff = " + this._betaDiff + ", relImprovement = " + this._relImprovement;
        }
        return converged;
    }

    protected double updateState(double[] beta, GLM.GLMGradientInfo ginfo) {
        double objOld;
        if (this._beta != null && beta.length > this._beta.length) {
            double[] shortBeta = this.shrinkFullArray(beta);
            this._betaDiff = ArrayUtils.linfnorm((double[])(this._beta == null ? beta : ArrayUtils.subtract((double[])this._beta, (double[])shortBeta)), (boolean)false);
            objOld = this.objective();
            if (this._beta == null) {
                this._beta = (double[])shortBeta.clone();
            } else {
                System.arraycopy(shortBeta, 0, this._beta, 0, shortBeta.length);
            }
        } else {
            this._betaDiff = ArrayUtils.linfnorm((double[])(this._beta == null ? beta : ArrayUtils.subtract((double[])this._beta, (double[])beta)), (boolean)false);
            objOld = this.objective();
            if (this._beta == null) {
                this._beta = (double[])beta.clone();
            } else {
                System.arraycopy(beta, 0, this._beta, 0, beta.length);
            }
        }
        this._ginfo = ginfo;
        this._likelihood = ginfo._likelihood;
        this._relImprovement = (objOld - this.objective()) / Math.abs(objOld);
        return this._relImprovement;
    }

    double getBetaDiff() {
        return this._betaDiff;
    }

    double getGradientErr() {
        return this._gradientErr;
    }

    protected void setBetaDiff(double betaDiff) {
        this._betaDiff = betaDiff;
    }

    protected void setGradientErr(double gErr) {
        this._gradientErr = gErr;
    }

    protected void setGinfo(GLM.GLMGradientInfo ginfo) {
        this._ginfo = GLMUtils.copyGInfo(ginfo);
    }

    protected void setBeta(double[] beta) {
        if (this._beta == null) {
            this._beta = (double[])beta.clone();
        } else {
            System.arraycopy(beta, 0, this._beta, 0, beta.length);
        }
    }

    protected void setIter(int iteration) {
        this._iter = iteration;
    }

    protected void setLikelihood(double llk) {
        this._likelihood = llk;
    }

    protected void setAllIn(boolean val) {
        this._allIn = val;
    }

    protected void setGslvrNull() {
        this._gslvr = null;
    }

    protected void setActiveDataMultinomialNull() {
        this._activeDataMultinomial = null;
    }

    protected void setActiveDataNull() {
        this._activeData = null;
    }

    protected void setLambdaSimple(double lambda) {
        this._lambda = lambda;
    }

    protected void setHGLMComputationState(double[] beta, double[] ubeta, double[] psi, double[] phi, double hlcorrection, double tau, Frame wpsi, String[] randCoeffNames) {
        this._beta = Arrays.copyOf(beta, beta.length);
        this._ubeta = Arrays.copyOf(ubeta, ubeta.length);
        this._randCoeffNames = Arrays.copyOf(randCoeffNames, randCoeffNames.length);
        this._psi = Arrays.copyOf(psi, psi.length);
        this._phi = Arrays.copyOf(phi, phi.length);
        this._correction_HL = hlcorrection;
        this._tau = tau;
        this._priorw_wpsi = wpsi;
        this._iterHGLM_GLMMME = 0;
    }

    public double[] expandBeta(double[] beta) {
        int fullCoefLen = (this._dinfo.fullN() + 1) * this._nclasses;
        if (this._activeData._activeCols == null || beta.length == fullCoefLen) {
            return beta;
        }
        if (this._nclasses <= 2 || !this._parms._remove_collinear_columns) {
            return ArrayUtils.expandAndScatter((double[])beta, (int)((this._dinfo.fullN() + 1) * this._nclasses), (int[])this._activeData._activeCols);
        }
        return ComputationState.expandToFullArray(beta, this._activeData.activeCols(), this._totalBetaLength, this._nclasses, this._betaLengthPerClass);
    }

    protected GramXY computeNewGram(DataInfo activeData, double[] beta, GLMModel.GLMParameters.Solver s) {
        GramXY res;
        Object[] activeCols;
        double obj_reg = this._parms._obj_reg;
        if (this._glmw == null) {
            this._glmw = new GLMModel.GLMWeightsFun(this._parms);
        }
        GLMTask.GLMIterationTask gt = (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(this._job._key, activeData, this._glmw, beta, this._activeClass).doAll(activeData._adaptedFrame);
        gt._gram.mul(obj_reg);
        if (this._parms._glmType.equals((Object)GLMModel.GLMParameters.GLMType.gam)) {
            activeCols = null;
            int[] activeColumns = activeData.activeCols();
            if (activeColumns.length < this._dinfo.fullN()) {
                activeCols = ArrayUtils.toIntegers((int[])activeColumns, (int)0, (int)activeColumns.length);
            }
            gt._gram.addGAMPenalty((Integer[])activeCols, this._penaltyMatrix, this._gamBetaIndices);
        }
        ArrayUtils.mult((double[])gt._xy, (double)obj_reg);
        activeCols = activeData.activeCols();
        int[] zeros = gt._gram.findZeroCols();
        if (this._parms._family != GLMModel.GLMParameters.Family.multinomial && zeros.length > 0) {
            gt._gram.dropCols(zeros);
            this.removeCols(zeros);
            res = new GramXY(gt._gram, ArrayUtils.removeIds((double[])gt._xy, (int[])zeros), null, gt._beta == null ? null : ArrayUtils.removeIds((double[])gt._beta, (int[])zeros), this.activeData().activeCols(), null, gt._yy, gt._likelihood);
        } else {
            res = new GramXY(gt._gram, gt._xy, null, beta == null ? null : beta, (int[])activeCols, null, gt._yy, gt._likelihood);
        }
        return res;
    }

    public GramXY computeGramRCC(double[] beta, GLMModel.GLMParameters.Solver s) {
        return this.computeNewGram(this._activeData, ArrayUtils.select((double[])beta, (int[])this._activeData.activeCols()), s);
    }

    public GramXY computeGram(double[] beta, GLMModel.GLMParameters.Solver s) {
        boolean weighted;
        double obj_reg = this._parms._obj_reg;
        boolean bl = weighted = this._parms._family != GLMModel.GLMParameters.Family.gaussian || this._parms._link != GLMModel.GLMParameters.Link.identity;
        if (this._parms._family == GLMModel.GLMParameters.Family.multinomial) {
            return this.computeNewGram(this.activeDataMultinomial(this._activeClass), beta, s);
        }
        if (s != GLMModel.GLMParameters.Solver.COORDINATE_DESCENT) {
            return this.computeNewGram(this.activeData(), beta, s);
        }
        if (this._currGram == null) {
            this._currGram = this.computeNewGram(this.activeData(), beta, s);
            return this._currGram;
        }
        DataInfo activeData = this.activeData();
        assert (beta == null || beta.length == activeData.fullN() + 1);
        int[] activeCols = activeData.activeCols();
        if (Arrays.equals(this._currGram.activeCols, activeCols)) {
            return !weighted || Arrays.equals(this._currGram.beta, beta) ? this._currGram : (this._currGram = this.computeNewGram(activeData, beta, s));
        }
        if (this._glmw == null) {
            this._glmw = new GLMModel.GLMWeightsFun(this._parms);
        }
        if (this._currGram != null) {
            int[] newCols = ArrayUtils.sorted_set_diff((int[])activeCols, (int[])this._currGram.activeCols);
            int[] newColsIds = (int[])newCols.clone();
            int jj = 0;
            boolean matches = true;
            int k = 0;
            for (int i = 0; i < activeCols.length; ++i) {
                if (jj < newCols.length && activeCols[i] == newCols[jj]) {
                    newColsIds[jj++] = i;
                    matches = matches && (beta == null || beta[i] == 0.0);
                    continue;
                }
                matches = matches && (beta == null || beta[i] == this._currGram.beta[k++]);
            }
            if (!weighted || matches) {
                GLMTask.GLMIncrementalGramTask gt = (GLMTask.GLMIncrementalGramTask)new GLMTask.GLMIncrementalGramTask(newColsIds, activeData, this._glmw, beta).doAll(activeData._adaptedFrame);
                for (double[] d : gt._gram) {
                    ArrayUtils.mult((double[])d, (double)obj_reg);
                }
                ArrayUtils.mult((double[])gt._xy, (double)obj_reg);
                this._currGram = GramXY.addCols(beta, activeCols, newColsIds, this._currGram, gt._gram, gt._xy);
                return this._currGram;
            }
        }
        this._currGram = this.computeNewGram(activeData, beta, s);
        return this._currGram;
    }

    public static final class GramXY {
        public final Gram gram;
        final double[] beta;
        final int[] activeCols;
        int[] newCols;
        public final double[] xy;
        private double[] grads;
        public double yy;
        public final double likelihood;

        public GramXY(Gram gram, double[] xy, double[] grads, double[] beta, int[] activeCols, int[] newActiveCols, double yy, double likelihood) {
            this.gram = gram;
            this.xy = xy;
            this.grads = grads;
            this.beta = beta == null ? null : (double[])beta.clone();
            this.activeCols = activeCols == null ? null : (int[])activeCols.clone();
            this.newCols = newActiveCols;
            this.yy = yy;
            this.likelihood = likelihood;
        }

        public final double[] getCODGradients() {
            double[][] xx;
            if (this.grads == null) {
                xx = this.gram.getXX();
                this.grads = new double[this.xy.length];
                for (int i = 0; i < this.grads.length; ++i) {
                    this.grads[i] = this.xy[i] - ArrayUtils.innerProduct((double[])xx[i], (double[])this.beta) + xx[i][i] * this.beta[i];
                }
            }
            if (this.newCols != null) {
                xx = this.gram.getXX();
                for (int i : this.newCols) {
                    this.grads[i] = this.xy[i] - ArrayUtils.innerProduct((double[])xx[i], (double[])this.beta) + xx[i][i] * this.beta[i];
                }
            }
            return this.grads;
        }

        public boolean match(double[] beta, int[] activeCols) {
            return Arrays.equals(this.beta, beta) && Arrays.equals(this.activeCols, activeCols);
        }

        static double[] mergeRow(int k, double[] xrowOld, double[] xrow, int[] newColsIds, double[][] xxUpdate) {
            int j;
            for (int i = 0; i < newColsIds.length; ++i) {
                int l;
                j = newColsIds[i];
                xrow[j] = xxUpdate[i][k];
                int n = l = i == 0 ? 0 : newColsIds[i - 1] + 1;
                while (l < j) {
                    xrow[l] = xrowOld[l - i];
                    ++l;
                }
            }
            int l = newColsIds.length;
            for (j = newColsIds[newColsIds.length - 1] + 1; j < xrow.length; ++j) {
                xrow[j] = xrowOld[j - l];
            }
            return xrow;
        }

        public static GramXY addCols(double[] beta, int[] newActiveCols, int[] newColsIds, GramXY oldGram, double[][] xxUpdate, double[] xyUpdate) {
            int k;
            double[][] xxCacheNew = new double[newActiveCols.length][];
            double[] xyNew = new double[xxCacheNew.length];
            double[] gradsNew = oldGram.grads == null ? null : new double[xxCacheNew.length];
            double[][] xx = oldGram.gram.getXX();
            for (k = 0; k < newColsIds.length; ++k) {
                int i;
                int j = newColsIds[k];
                xxCacheNew[j] = xxUpdate[k];
                xyNew[j] = xyUpdate[k];
                int n = i = k == 0 ? 0 : newColsIds[k - 1] + 1;
                while (i < j) {
                    xxCacheNew[i] = GramXY.mergeRow(i, xx[i - k], new double[newActiveCols.length], newColsIds, xxUpdate);
                    xyNew[i] = oldGram.xy[i - k];
                    if (oldGram.grads != null) {
                        gradsNew[i] = oldGram.grads[i - k];
                    }
                    ++i;
                }
            }
            k = newColsIds.length;
            for (int i = newColsIds[newColsIds.length - 1] + 1; i < xyNew.length; ++i) {
                xxCacheNew[i] = GramXY.mergeRow(i, xx[i - k], new double[newActiveCols.length], newColsIds, xxUpdate);
                xyNew[i] = oldGram.xy[i - k];
                if (oldGram.grads == null) continue;
                gradsNew[i] = oldGram.grads[i - k];
            }
            return new GramXY(new Gram(xxCacheNew), xyNew, gradsNew, beta, newActiveCols, newColsIds, oldGram.yy, oldGram.likelihood);
        }
    }

    public static class GLMSubsetGinfo
    extends GLM.GLMGradientInfo {
        public final GLM.GLMGradientInfo _fullInfo;

        public GLMSubsetGinfo(GLM.GLMGradientInfo fullInfo, int N, int c, int[] ids) {
            super(fullInfo._likelihood, fullInfo._objVal, ComputationState.extractSubRange(N, c, ids, fullInfo._gradient));
            this._fullInfo = fullInfo;
        }
    }
}

