/*
 * Decompiled with CFR 0.152.
 */
package hex.rulefit;

import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.rulefit.Condition;
import hex.tree.SharedTreeModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import water.Iced;
import water.fvec.Chunk;

public class Rule
extends Iced {
    Condition[] conditions;
    double predictionValue;
    String languageRule;
    double coefficient;
    String varName;
    double support;

    public Rule(Condition[] conditions, double predictionValue, String varName) {
        this.conditions = conditions;
        this.predictionValue = predictionValue;
        this.varName = varName;
        this.languageRule = this.generateLanguageRule();
    }

    public Rule(Condition[] conditions, double predictionValue, String varName, double coefficient, double support) {
        this.conditions = conditions;
        this.predictionValue = predictionValue;
        this.varName = varName;
        this.coefficient = coefficient;
        this.languageRule = this.generateLanguageRule();
        this.support = support;
    }

    public void setCoefficient(double coefficient) {
        this.coefficient = coefficient;
    }

    String generateLanguageRule() {
        StringBuilder languageRule = new StringBuilder();
        if (!this.varName.startsWith("linear.")) {
            for (int i = 0; i < this.conditions.length; ++i) {
                if (i != 0) {
                    languageRule.append(" & ");
                }
                languageRule.append(this.conditions[i].languageCondition);
            }
        }
        return languageRule.toString();
    }

    public void map(Chunk[] cs, byte[] out) {
        for (Condition c : this.conditions) {
            c.map(cs, out);
        }
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.conditions.length; ++i) {
            hashCode += this.conditions[i].hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public static List<Rule> extractRulesListFromModel(SharedTreeModel model, int modelId, int nclasses) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        nclasses = nclasses > 2 ? nclasses : 1;
        for (int i = 0; i < ((SharedTreeModel.SharedTreeParameters)model._parms)._ntrees; ++i) {
            for (int treeClass = 0; treeClass < nclasses; ++treeClass) {
                SharedTreeSubgraph sharedTreeSubgraph = model.getSharedTreeSubgraph(i, treeClass);
                if (sharedTreeSubgraph == null) continue;
                String classString = nclasses > 2 ? "_" + model._output.classNames()[treeClass] : null;
                rules.addAll(Rule.extractRulesFromTree(sharedTreeSubgraph, modelId, classString));
            }
        }
        return rules;
    }

    public static Set<Rule> extractRulesFromTree(SharedTreeSubgraph tree, int modelId, String classString) {
        HashSet<Rule> rules = new HashSet<Rule>();
        List leaves = tree.nodesArray.stream().filter(sharedTreeNode -> sharedTreeNode.isLeaf()).collect(Collectors.toList());
        for (SharedTreeNode leaf : leaves) {
            String varName = "M" + modelId + "T" + leaf.getSubgraphNumber() + "N" + leaf.getNodeNumber();
            if (classString != null) {
                varName = varName + classString;
            }
            Rule.traversePath(leaf, rules, varName);
        }
        return rules;
    }

    private static void traversePath(SharedTreeNode node, List<Condition> conditions, Set<Rule> rules, String varName) {
        SharedTreeNode parent = node.getParent();
        if (parent == null) {
            conditions = conditions.stream().sorted(Comparator.comparing(condition -> condition.featureName)).collect(Collectors.toList());
            rules.add(new Rule(conditions.toArray(new Condition[0]), node.getPredValue(), varName));
        } else {
            Condition newCondition;
            Condition actualCondition;
            String featureName = parent.getColName();
            int colId = parent.getColId();
            if (node.getInclusiveLevels() != null && parent.getDomainValues() != null) {
                actualCondition = Rule.getConditionByFeatureNameAndOperator(conditions, parent.getColName(), Condition.Operator.In);
                CategoricalThreshold categoricalThreshold = Rule.extractCategoricalThreshold(node.getInclusiveLevels(), parent.getDomainValues());
                newCondition = new Condition(colId, Condition.Type.Categorical, Condition.Operator.In, -1.0, categoricalThreshold.catThreshold, categoricalThreshold.catThresholdNum, featureName, node.isInclusiveNa());
            } else {
                float splitValue = parent.getSplitValue();
                Condition.Operator operator = parent.getLeftChild().equals((Object)node) ? Condition.Operator.LessThan : Condition.Operator.GreaterThanOrEqual;
                actualCondition = Rule.getConditionByFeatureNameAndOperator(conditions, parent.getColName(), operator);
                newCondition = new Condition(colId, Condition.Type.Numerical, operator, splitValue, null, null, featureName, node.isInclusiveNa());
            }
            if (actualCondition == null) {
                conditions.add(newCondition);
            } else {
                actualCondition = actualCondition.expandBy(newCondition);
            }
            Rule.traversePath(node.getParent(), conditions, rules, varName);
        }
    }

    private static void traversePath(SharedTreeNode node, Set<Rule> rules, String varName) {
        Rule.traversePath(node, new ArrayList<Condition>(), rules, varName);
    }

    private static Condition getConditionByFeatureNameAndOperator(List<Condition> conditions, String featureName, Condition.Operator operator) {
        List filteredConditions = conditions.stream().filter(condition -> condition.featureName.equals(featureName) && condition.operator.equals((Object)operator)).collect(Collectors.toList());
        if (filteredConditions.size() != 0) {
            return (Condition)((Object)filteredConditions.get(0));
        }
        return null;
    }

    static CategoricalThreshold extractCategoricalThreshold(BitSet inclusiveLevels, String[] domainValues) {
        ArrayList<Integer> matchedDomainValues = new ArrayList<Integer>();
        String[] catThreshold = new String[inclusiveLevels.cardinality()];
        int[] catThresholdNum = new int[inclusiveLevels.cardinality()];
        int i = inclusiveLevels.nextSetBit(0);
        while (i >= 0) {
            matchedDomainValues.add(i);
            i = inclusiveLevels.nextSetBit(i + 1);
        }
        for (i = 0; i < catThreshold.length; ++i) {
            catThreshold[i] = domainValues[(Integer)matchedDomainValues.get(i)];
            catThresholdNum[i] = (Integer)matchedDomainValues.get(i);
        }
        return new CategoricalThreshold(catThreshold, catThresholdNum);
    }

    double getAbsCoefficient() {
        return Math.abs(this.coefficient);
    }

    static class CategoricalThreshold {
        String[] catThreshold;
        int[] catThresholdNum;

        public CategoricalThreshold(String[] catThreshold, int[] catThresholdNum) {
            this.catThreshold = catThreshold;
            this.catThresholdNum = catThresholdNum;
        }
    }
}

