/*
 * Decompiled with CFR 0.152.
 */
package hex.svd;

import Jama.Matrix;
import Jama.QRDecomposition;
import Jama.SingularValueDecomposition;
import hex.DataInfo;
import hex.FrameTask;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.glrm.GLRMModel;
import hex.gram.Gram;
import hex.svd.SVDModel;
import hex.util.DimensionReductionUtils;
import hex.util.LinearAlgebraUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import water.DKV;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.Scope;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Rapids;
import water.util.ArrayUtils;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class SVD
extends ModelBuilder<SVDModel, SVDModel.SVDParameters, SVDModel.SVDOutput> {
    private final double TOLERANCE = 1.0E-16;
    private final double EPS = 1.0E-16;
    private final int MAX_COLS_EXPANDED = 5000;
    private boolean _callFromGLRM;
    private GLRMModel _glrmModel;
    private transient int _ncolExp;
    boolean _wideDataset = false;
    private double[] _estimatedSingularValues;
    private boolean _matrixRankReached = false;
    private boolean _failedConvergence = false;

    protected SVDDriver trainModelImpl() {
        return new SVDDriver();
    }

    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.DimReduction};
    }

    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    public boolean isSupervised() {
        return false;
    }

    public boolean havePojo() {
        return true;
    }

    public boolean haveMojo() {
        return false;
    }

    public SVD(SVDModel.SVDParameters parms) {
        super((Model.Parameters)parms);
        this.init(false);
        this._glrmModel = null;
        this._callFromGLRM = false;
    }

    public SVD(SVDModel.SVDParameters parms, Job job) {
        super((Model.Parameters)parms, job);
        this.init(false);
        this._glrmModel = null;
        this._callFromGLRM = false;
    }

    public SVD(SVDModel.SVDParameters parms, Job job, boolean callFromGlrm, GLRMModel gmodel) {
        super((Model.Parameters)parms, job);
        this.init(false);
        this._callFromGLRM = callFromGlrm;
        if (gmodel == null) {
            this.error("_train SVD for GLRM", "Your GLRM model parameter is null.");
        }
        this._glrmModel = gmodel;
    }

    public SVD(boolean startup_once) {
        super((Model.Parameters)new SVDModel.SVDParameters(), startup_once);
    }

    protected void checkMemoryFootPrint_impl() {
        HeartBeat hb = H2O.SELF._heartbeat;
        double p = LinearAlgebraUtils.numColsExp(this._train, true);
        double r = this._train.numRows();
        boolean useGramSVD = ((SVDModel.SVDParameters)this._parms)._svd_method == SVDModel.SVDParameters.Method.GramSVD;
        boolean usePower = ((SVDModel.SVDParameters)this._parms)._svd_method == SVDModel.SVDParameters.Method.Power;
        boolean useRandomized = ((SVDModel.SVDParameters)this._parms)._svd_method == SVDModel.SVDParameters.Method.Randomized;
        double gramSize = this._train.lastVec().nChunks() == 1 ? 1.0 : Math.log(this._train.lastVec().nChunks()) / Math.log(2.0);
        long mem_usage = useGramSVD || usePower || useRandomized ? (long)((double)hb._cpus_allowed * p * p * 8.0 * gramSize) : 1L;
        long mem_usage_w = useGramSVD || usePower || useRandomized ? (long)((double)hb._cpus_allowed * r * r * 8.0 * gramSize) : 1L;
        long max_mem = hb.get_free_mem();
        if (mem_usage > max_mem && mem_usage_w > max_mem) {
            String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes((long)mem_usage) + " > " + PrettyPrint.bytes((long)max_mem) + ") - try reducing the number of columns and/or the number of categorical factors.";
            this.error("_train", msg);
        }
        if (mem_usage > max_mem) {
            this._wideDataset = true;
        } else if (p > 5000.0 && r < 5000.0) {
            this._wideDataset = true;
        }
    }

    public void setWideDataset(boolean isWide) {
        this._wideDataset = isWide;
    }

    public void init(boolean expensive) {
        super.init(expensive);
        if (((SVDModel.SVDParameters)this._parms)._max_iterations < 1) {
            this.error("_max_iterations", "max_iterations must be at least 1");
        }
        if (this._train == null) {
            return;
        }
        this._ncolExp = this._callFromGLRM ? ((GLRMModel.GLRMOutput)this._glrmModel._output)._catOffsets[((GLRMModel.GLRMOutput)this._glrmModel._output)._catOffsets.length - 1] + ((GLRMModel.GLRMOutput)this._glrmModel._output)._nnums : LinearAlgebraUtils.numColsExp(this._train, ((SVDModel.SVDParameters)this._parms)._use_all_factor_levels);
        if (this._ncolExp > 5000) {
            this.warn("_train", "_train has " + this._ncolExp + " columns when categoricals are expanded. Algorithm may be slow.");
        }
        if (((SVDModel.SVDParameters)this._parms)._nv < 1 || ((SVDModel.SVDParameters)this._parms)._nv > this._ncolExp) {
            this.error("_nv", "Number of right singular values must be between 1 and " + this._ncolExp);
        }
        if (expensive && this.error_count() == 0 && (!this._train.hasNAs() || ((SVDModel.SVDParameters)this._parms)._impute_missing)) {
            this.checkMemoryFootPrint();
        }
    }

    public static double[][] updateIVVSum(double[][] ivv_sum, double[] vec) {
        for (int i = 0; i < vec.length; ++i) {
            for (int j = 0; j < i; ++j) {
                double diff;
                double d = diff = ivv_sum[i][j] - vec[i] * vec[j];
                ivv_sum[j][i] = d;
                ivv_sum[i][j] = d;
            }
            double[] dArray = ivv_sum[i];
            int n = i;
            dArray[n] = dArray[n] - vec[i] * vec[i];
        }
        return ivv_sum;
    }

    private void updateGram(double[][] ivv_sum, double[][] gramToArray, double[][] resultGram, Gram gram, Gram gramUpdate) {
        int col_index;
        int row_index;
        int numRows = gram.fullN();
        for (row_index = 0; row_index < numRows; ++row_index) {
            for (col_index = 0; col_index < numRows; ++col_index) {
                gramToArray[row_index][col_index] = col_index <= row_index ? gram._xx[row_index][col_index] : gram._xx[col_index][row_index];
            }
        }
        resultGram = ArrayUtils.multArrArr((double[][])ivv_sum, (double[][])gramToArray);
        gramToArray = ArrayUtils.multArrArr((double[][])resultGram, (double[][])ivv_sum);
        for (row_index = 0; row_index < numRows; ++row_index) {
            for (col_index = 0; col_index <= row_index; ++col_index) {
                gramUpdate._xx[row_index][col_index] = gramToArray[row_index][col_index];
            }
        }
    }

    private void setSVDModel(SVDModel model, DataInfo dinfo) {
        if (this._callFromGLRM) {
            dinfo._normSub = Arrays.copyOf(((GLRMModel.GLRMOutput)this._glrmModel._output)._normSub, ((GLRMModel.GLRMOutput)this._glrmModel._output)._normSub.length);
            dinfo._normMul = Arrays.copyOf(((GLRMModel.GLRMOutput)this._glrmModel._output)._normMul, ((GLRMModel.GLRMOutput)this._glrmModel._output)._normMul.length);
            dinfo._permutation = Arrays.copyOf(((GLRMModel.GLRMOutput)this._glrmModel._output)._permutation, ((GLRMModel.GLRMOutput)this._glrmModel._output)._permutation.length);
            dinfo._numMeans = Arrays.copyOf(dinfo._normSub, dinfo._normSub.length);
            dinfo._numNAFill = dinfo._numMeans;
            dinfo._nums = ((GLRMModel.GLRMOutput)this._glrmModel._output)._nnums;
            dinfo._cats = ((GLRMModel.GLRMOutput)this._glrmModel._output)._ncats;
            dinfo._catOffsets = Arrays.copyOf(((GLRMModel.GLRMOutput)this._glrmModel._output)._catOffsets, ((GLRMModel.GLRMOutput)this._glrmModel._output)._catOffsets.length);
            ((SVDModel.SVDOutput)model._output)._names_expanded = Arrays.copyOf(((GLRMModel.GLRMOutput)this._glrmModel._output)._names_expanded, ((GLRMModel.GLRMOutput)this._glrmModel._output)._names_expanded.length);
        } else {
            ((SVDModel.SVDOutput)model._output)._names_expanded = dinfo.coefNames();
        }
        double[] dArray = ((SVDModel.SVDOutput)model._output)._normSub = dinfo._normSub == null ? new double[dinfo._nums] : dinfo._normSub;
        if (dinfo._normMul == null) {
            ((SVDModel.SVDOutput)model._output)._normMul = new double[dinfo._nums];
            Arrays.fill(((SVDModel.SVDOutput)model._output)._normMul, 1.0);
        } else {
            ((SVDModel.SVDOutput)model._output)._normMul = dinfo._normMul;
        }
        ((SVDModel.SVDOutput)model._output)._permutation = dinfo._permutation;
        ((SVDModel.SVDOutput)model._output)._nnums = dinfo._nums;
        ((SVDModel.SVDOutput)model._output)._ncats = dinfo._cats;
        ((SVDModel.SVDOutput)model._output)._catOffsets = dinfo._catOffsets;
    }

    private TwoDimTable createModelSummaryTable(SVDModel.SVDOutput output) {
        if (null == output._d) {
            return null;
        }
        Object[] colTypes = new String[((SVDModel.SVDParameters)this._parms)._nv];
        Object[] colFormats = new String[((SVDModel.SVDParameters)this._parms)._nv];
        String[] colHeaders = new String[((SVDModel.SVDParameters)this._parms)._nv];
        Arrays.fill(colTypes, "double");
        Arrays.fill(colFormats, "%5f");
        for (int i = 0; i < colHeaders.length; ++i) {
            colHeaders[i] = "sval" + String.valueOf(i + 1);
        }
        return new TwoDimTable("Singular values", null, new String[1], colHeaders, (String[])colTypes, (String[])colFormats, "", (String[][])new String[1][], (double[][])new double[][]{output._d});
    }

    static /* synthetic */ double[] access$302(SVD x0, double[] x1) {
        x0._estimatedSingularValues = x1;
        return x1;
    }

    private static class RandSubInit
    extends FrameTask<RandSubInit> {
        final double[][] _gaus;

        public RandSubInit(Key<Job> jobKey, DataInfo dinfo, double[][] gaus) {
            super(jobKey, dinfo);
            this._gaus = gaus;
        }

        @Override
        protected void processRow(long gid, DataInfo.Row row, NewChunk[] outputs) {
            for (int k = 0; k < this._gaus.length; ++k) {
                double y = row.innerProduct(this._gaus[k]);
                outputs[k].addNum(y);
            }
        }
    }

    private static class DivideU
    extends MRTask<DivideU> {
        final double[] _sigma;

        public DivideU(double[] sigma) {
            this._sigma = sigma;
        }

        public void map(Chunk[] cs) {
            assert (this._sigma.length == cs.length);
            for (int col = 0; col < cs.length; ++col) {
                for (int row = 0; row < cs[0].len(); ++row) {
                    double x = cs[col].atd(row);
                    cs[col].set(row, x / this._sigma[col]);
                }
            }
        }
    }

    private static class GramUpdate
    extends FrameTask<GramUpdate> {
        final double[][] _ivv;
        public Gram _gram;
        public long _nobs;
        private transient DataInfo.Row _numRow;

        public GramUpdate(Key<Job> jobKey, DataInfo dinfo, double[][] ivv) {
            super(jobKey, dinfo);
            assert (null != ivv && ivv.length == ivv[0].length);
            this._ivv = ivv;
        }

        @Override
        protected boolean chunkInit() {
            this._gram = new Gram(this._dinfo.fullN(), 0, this._ivv.length, 0, false);
            this._numRow = this._dinfo.newDenseRow(MemoryManager.malloc8d((int)this._ivv.length), 0L);
            return true;
        }

        @Override
        protected void processRow(long gid, DataInfo.Row r) {
            double w = 1.0;
            double[] nums = this._numRow.numVals;
            for (int row = 0; row < this._ivv.length; ++row) {
                nums[row] = r.innerProduct(this._ivv[row]);
            }
            this._gram.addRow(this._numRow, w);
            ++this._nobs;
        }

        @Override
        protected void chunkDone(long n) {
            double r = 1.0 / (double)this._nobs;
            this._gram.mul(r);
        }

        public void reduce(GramUpdate gt) {
            double r1 = (double)this._nobs / (double)(this._nobs + gt._nobs);
            this._gram.mul(r1);
            double r2 = (double)gt._nobs / (double)(this._nobs + gt._nobs);
            gt._gram.mul(r2);
            this._gram.add(gt._gram);
            this._nobs += gt._nobs;
        }
    }

    private static class CalcSigmaU
    extends FrameTask<CalcSigmaU> {
        final double[] _svec;
        public double _sval;
        public long _nobs;

        public CalcSigmaU(Key<Job> jobKey, DataInfo dinfo, double[] svec) {
            super(jobKey, dinfo);
            this._svec = svec;
            this._sval = 0.0;
        }

        @Override
        protected void processRow(long gid, DataInfo.Row r, NewChunk[] outputs) {
            double num = r.innerProduct(this._svec);
            outputs[0].addNum(num);
            this._sval += num * num;
            ++this._nobs;
        }

        public void reduce(CalcSigmaU other) {
            this._nobs += other._nobs;
            this._sval += other._sval;
        }

        protected void postGlobal() {
            this._sval = Math.sqrt(this._sval);
        }
    }

    class SVDDriver
    extends ModelBuilder.Driver {
        SVDModel _model;

        SVDDriver() {
            super((ModelBuilder)SVD.this);
        }

        private double[] powerLoop(Gram gram, long seed, SVDModel model, double[] randomInitialV, double[] finalV, int k) {
            randomInitialV = ArrayUtils.gaussianVector((long)(seed + (long)k), (double[])randomInitialV);
            ArrayUtils.div((double[])randomInitialV, (double)ArrayUtils.l2norm((double[])randomInitialV));
            return this.powerLoop(gram, randomInitialV, model, finalV, k);
        }

        private double[] powerLoop(Gram gram, double[] v, SVDModel model, double[] vnew, int k) {
            assert (v.length == gram.fullN());
            double err = 2.0E-16;
            double lambda1_calc = 0.0;
            double lambda_est = 0.0;
            int eigIndex = ((SVDModel.SVDOutput)model._output)._iterations + 1;
            for (int iters = 0; iters < ((SVDModel.SVDParameters)SVD.this._parms)._max_iterations && err > 1.0E-16 && !SVD.this.stop_requested(); ++iters) {
                gram.mul(v, vnew);
                lambda1_calc = ArrayUtils.innerProduct((double[])vnew, (double[])v);
                lambda_est = ArrayUtils.innerProduct((double[])vnew, (double[])vnew);
                double norm = ArrayUtils.l2norm((double[])vnew);
                double invnorm = 0.0;
                err = 0.0;
                if (norm > 1.0E-16) {
                    invnorm = 1.0 / norm;
                    for (int i = 0; i < v.length; ++i) {
                        int n = i;
                        vnew[n] = vnew[n] * invnorm;
                        v[i] = vnew[i];
                    }
                    err = Math.sqrt(lambda_est - lambda1_calc * lambda1_calc);
                    ((SVDModel.SVDOutput)model._output)._training_time_ms.add(System.currentTimeMillis());
                    ((SVDModel.SVDOutput)model._output)._history_err.add(err);
                    ((SVDModel.SVDOutput)model._output)._history_eigenVectorIndex.add(Double.valueOf(eigIndex));
                    continue;
                }
                SVD.this._job.warn("_train SVD: Dataset is rank deficient.  User specified " + ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                SVD.this._matrixRankReached = true;
                break;
            }
            if (err > 1.0E-16) {
                SVD.this._failedConvergence = true;
                SVD.this._job.warn("_train: PCA Power method failed to converge within TOLERANCE.  Increase max_iterations or reduce TOLERANCE to mitigate this problem.");
            }
            ((SVD)SVD.this)._estimatedSingularValues[k] = lambda1_calc;
            return v;
        }

        private double computeSigmaU(DataInfo dinfo, SVDModel model, int k, double[][] ivv_sum, Vec[] uvecs, double[] vresult) {
            double[] ivv_vk = ArrayUtils.multArrVec((double[][])ivv_sum, (double[])((SVDModel.SVDOutput)model._output)._v[k], (double[])vresult);
            CalcSigmaU ctsk = (CalcSigmaU)new CalcSigmaU((Key<Job>)SVD.this._job._key, dinfo, ivv_vk).doAll((byte)3, dinfo._adaptedFrame);
            ((SVDModel.SVDOutput)model._output)._d[k] = ctsk._sval;
            assert (ctsk._nobs == ((SVDModel.SVDOutput)model._output)._nobs) : "Processed " + ctsk._nobs + " rows but expected " + ((SVDModel.SVDOutput)model._output)._nobs;
            Frame tmp = ctsk.outputFrame();
            uvecs[k] = tmp.vec(0);
            tmp.unlock(SVD.this._job);
            return ((SVDModel.SVDOutput)model._output)._d[k];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Frame randSubIter(DataInfo dinfo, SVDModel model) {
            DataInfo yinfo = null;
            Frame ybig = null;
            Frame qfrm = null;
            Frame ysmallF = null;
            Frame ysmallqfrm = null;
            int ncolA = dinfo._adaptedFrame.numCols();
            double[][] xx = null;
            double[][] ysmall_q = null;
            DataInfo ysmallInfo = null;
            try {
                SVD.this._job.update(1L, "Initializing random subspace of training data Y");
                double[][] gt = ArrayUtils.gaussianArray((int)((SVDModel.SVDParameters)SVD.this._parms)._nv, (int)SVD.this._ncolExp, (long)((SVDModel.SVDParameters)SVD.this._parms)._seed);
                RandSubInit rtsk = new RandSubInit((Key<Job>)SVD.this._job._key, dinfo, gt);
                rtsk.doAll(((SVDModel.SVDParameters)SVD.this._parms)._nv, (byte)3, dinfo._adaptedFrame);
                ybig = rtsk.outputFrame(Key.make(), null, null);
                Frame yqfrm = new Frame(ybig);
                for (int i = 0; i < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++i) {
                    yqfrm.add("qcol_" + i, yqfrm.anyVec().makeZero());
                }
                SVD.this._job.update(1L, "Computing QR factorization of Y");
                yinfo = new DataInfo(ybig, null, true, DataInfo.TransformType.NONE, true, false, false);
                DKV.put((Key)yinfo._key, (Iced)yinfo);
                LinearAlgebraUtils.computeQ((Key<Job>)SVD.this._job._key, yinfo, yqfrm, xx);
                if (yqfrm.hasInfs()) {
                    SVD.this._matrixRankReached = true;
                    String warnMessage = "_train SVD: Dataset is rank deficient.  _parms._nv was " + ((SVDModel.SVDParameters)SVD.this._parms)._nv;
                    for (int colIndex = ybig.numCols(); colIndex < yqfrm.numCols(); ++colIndex) {
                        if (yqfrm.vec(colIndex).pinfs() <= 0L) continue;
                        ((SVDModel.SVDParameters)SVD.this._parms)._nv = colIndex - ybig.numCols();
                        break;
                    }
                    SVD.this._job.warn(warnMessage + " and is now set to " + ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                    gt = ArrayUtils.gaussianArray((int)((SVDModel.SVDParameters)SVD.this._parms)._nv, (int)SVD.this._ncolExp, (long)((SVDModel.SVDParameters)SVD.this._parms)._seed);
                    rtsk = new RandSubInit((Key<Job>)SVD.this._job._key, dinfo, gt);
                    rtsk.doAll(((SVDModel.SVDParameters)SVD.this._parms)._nv, (byte)3, dinfo._adaptedFrame);
                    ybig.remove();
                    yinfo.remove();
                    ybig = rtsk.outputFrame(Key.make(), null, null);
                    yinfo = new DataInfo(ybig, null, true, DataInfo.TransformType.NONE, true, false, false);
                    DKV.put((Key)yinfo._key, (Iced)yinfo);
                }
                Frame ayqfrm = new Frame(dinfo._adaptedFrame);
                ayqfrm.add(ybig);
                for (int i = 0; i < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++i) {
                    ayqfrm.add("qcol_" + i, ayqfrm.anyVec().makeZero());
                }
                Frame ayfrm = ayqfrm.subframe(0, ncolA + ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                Frame aqfrm = ayqfrm.subframe(0, ncolA);
                aqfrm.add(ayqfrm.subframe(ncolA + ((SVDModel.SVDParameters)SVD.this._parms)._nv, ayqfrm.numCols()));
                yqfrm = ayqfrm.subframe(ncolA, ayqfrm.numCols());
                xx = MemoryManager.malloc8d((int)((SVDModel.SVDParameters)SVD.this._parms)._nv, (int)((SVDModel.SVDParameters)SVD.this._parms)._nv);
                LinearAlgebraUtils.computeQ((Key<Job>)SVD.this._job._key, yinfo, yqfrm, xx);
                ((SVDModel.SVDOutput)model._output)._iterations = 0;
                long qobs = dinfo._adaptedFrame.numRows() * (long)((SVDModel.SVDParameters)SVD.this._parms)._nv;
                double qerr = 2.0E-16 * (double)qobs;
                double average_SEE = qerr / (double)qobs;
                int wEndCol = 2 * ((SVDModel.SVDParameters)SVD.this._parms)._nv - 1;
                int wEndColR = ((SVDModel.SVDParameters)SVD.this._parms)._nv - 1;
                while ((((SVDModel.SVDOutput)model._output)._iterations < 10 || average_SEE > 1.0E-16) && ((SVDModel.SVDOutput)model._output)._iterations < ((SVDModel.SVDParameters)SVD.this._parms)._max_iterations) {
                    if (SVD.this.stop_requested()) {
                        if (!SVD.this.timeout()) break;
                        SVD.this._job.warn("_train SVD: max_runtime_secs is reached.  Not all iterations are computed.");
                        break;
                    }
                    SVD.this._job.update(1L, "Iteration " + String.valueOf(((SVDModel.SVDOutput)model._output)._iterations + 1) + " of randomized subspace iteration");
                    LinearAlgebraUtils.SMulTask stsk = new LinearAlgebraUtils.SMulTask(dinfo, ((SVDModel.SVDParameters)SVD.this._parms)._nv, SVD.this._ncolExp);
                    stsk.doAll(aqfrm);
                    if (SVD.this._wideDataset) {
                        if (((SVDModel.SVDOutput)model._output)._iterations == 0) {
                            new ArrayUtils();
                            ysmallF = ArrayUtils.frame((double[][])stsk._atq);
                            ysmallInfo = new DataInfo(ysmallF, null, true, DataInfo.TransformType.NONE, true, false, false);
                            DKV.put((Key)ysmallInfo._key, (Iced)ysmallInfo);
                            ysmall_q = MemoryManager.malloc8d((int)SVD.this._ncolExp, (int)((SVDModel.SVDParameters)SVD.this._parms)._nv);
                            ysmallqfrm = new Frame(ysmallF);
                            for (int i = 0; i < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++i) {
                                ysmallqfrm.add("qcol_" + i, ysmallqfrm.anyVec().makeZero());
                            }
                        } else {
                            new ArrayUtils.CopyArrayToFrame(0, wEndColR, (long)SVD.this._ncolExp, stsk._atq).doAll(ysmallqfrm);
                        }
                        LinearAlgebraUtils.computeQ((Key<Job>)SVD.this._job._key, ysmallInfo, ysmallqfrm, xx);
                        ysmall_q = ((ArrayUtils.FrameToArray)new ArrayUtils.FrameToArray(((SVDModel.SVDParameters)SVD.this._parms)._nv, wEndCol, (long)SVD.this._ncolExp, ysmall_q).doAll(ysmallqfrm)).getArray();
                    } else {
                        Matrix ysmall = new Matrix(stsk._atq);
                        QRDecomposition ysmall_qr = new QRDecomposition(ysmall);
                        ysmall_q = ysmall_qr.getQ().getArray();
                    }
                    LinearAlgebraUtils.BMulInPlaceTask tsk = new LinearAlgebraUtils.BMulInPlaceTask(dinfo, ArrayUtils.transpose((double[][])ysmall_q), SVD.this._ncolExp);
                    tsk.doAll(ayfrm);
                    qerr = LinearAlgebraUtils.computeQ((Key<Job>)SVD.this._job._key, yinfo, yqfrm, xx);
                    average_SEE = qerr / (double)qobs;
                    ++((SVDModel.SVDOutput)model._output)._iterations;
                    ((SVDModel.SVDOutput)model._output)._training_time_ms.add(System.currentTimeMillis());
                    ((SVDModel.SVDOutput)model._output)._history_average_SEE.add(average_SEE);
                    model.update(SVD.this._job);
                }
                ((SVDModel.SVDOutput)model._output)._nobs = ybig.numRows();
                model.update(SVD.this._job);
                qfrm = ayqfrm.extractFrame(ncolA + ((SVDModel.SVDParameters)SVD.this._parms)._nv, ayqfrm.numCols());
                qfrm = new Frame(Key.make(), qfrm.names(), qfrm.vecs());
                DKV.put((Keyed)qfrm);
            }
            finally {
                if (yinfo != null) {
                    yinfo.remove();
                }
                if (ybig != null) {
                    ybig.delete();
                }
                if (ysmallInfo != null) {
                    ysmallInfo.remove();
                }
                if (ysmallF != null) {
                    ysmallF.delete();
                }
                if (ysmallqfrm != null) {
                    ysmallqfrm.delete();
                }
            }
            return qfrm;
        }

        private Frame directSVD(DataInfo dinfo, Frame qfrm, SVDModel model) {
            String u_name = ((SVDModel.SVDParameters)SVD.this._parms)._u_name == null || ((SVDModel.SVDParameters)SVD.this._parms)._u_name.length() == 0 ? "SVDUMatrix_" + Key.rand() : ((SVDModel.SVDParameters)SVD.this._parms)._u_name;
            return this.directSVD(dinfo, qfrm, model, u_name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Frame directSVD(DataInfo dinfo, Frame qfrm, SVDModel model, String u_name) {
            Object qinfo = null;
            Frame u = null;
            int ncolA = dinfo._adaptedFrame.numCols();
            try {
                int i;
                Vec[] vecs = new Vec[ncolA + ((SVDModel.SVDParameters)SVD.this._parms)._nv];
                for (i = 0; i < ncolA; ++i) {
                    vecs[i] = dinfo._adaptedFrame.vec(i);
                }
                for (i = 0; i < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++i) {
                    vecs[ncolA + i] = qfrm.vec(i);
                }
                Frame aqfrm = new Frame(vecs);
                SVD.this._job.update(1L, "Forming small matrix B = Q'A for direct SVD");
                LinearAlgebraUtils.SMulTask stsk = new LinearAlgebraUtils.SMulTask(dinfo, ((SVDModel.SVDParameters)SVD.this._parms)._nv, SVD.this._ncolExp);
                stsk.doAll(aqfrm);
                if (SVD.this._wideDataset) {
                    new ArrayUtils();
                    Frame tB = ArrayUtils.frame((double[][])stsk._atq);
                    DataInfo tbInfo = new DataInfo(tB, null, true, DataInfo.TransformType.NONE, false, false, false);
                    Gram.GramTask gtsk = (Gram.GramTask)new Gram.GramTask((Key<Job>)SVD.this._job._key, tbInfo).doAll(tB);
                    Matrix gramJ = new Matrix(gtsk._gram.getXX());
                    SingularValueDecomposition svdJ = gramJ.svd();
                    SVD.this._job.update(1L, "Forming distributed orthonormal matrix U");
                    u = this.makeUVec(model, u_name, u, qfrm, new Matrix(stsk._atq), svdJ);
                    ((SVDModel.SVDOutput)model._output)._d = ArrayUtils.mult((double[])Arrays.copyOfRange(ArrayUtils.sqrtArr((double[])svdJ.getSingularValues()), 0, ((SVDModel.SVDParameters)SVD.this._parms)._nv), (double)StrictMath.sqrt(tB.numRows()));
                    Vec[] tvecs = new Vec[ncolA];
                    for (int i2 = 0; i2 < ncolA; ++i2) {
                        tvecs[i2] = dinfo._adaptedFrame.vec(i2);
                    }
                    Frame avfrm = new Frame(tvecs);
                    Object fromSVD = null;
                    avfrm.add(u);
                    ((SVDModel.SVDOutput)model._output)._v = ((LinearAlgebraUtils.SMulTask)new LinearAlgebraUtils.SMulTask((DataInfo)dinfo, (int)((SVDModel.SVDParameters)SVD.this._parms)._nv, (int)((SVD)SVD.this)._ncolExp).doAll((Frame)avfrm))._atq;
                    ((SVDModel.SVDOutput)model._output)._v = ArrayUtils.mult((double[][])ArrayUtils.transpose((double[][])ArrayUtils.div((double[][])ArrayUtils.transpose((double[][])((SVDModel.SVDOutput)model._output)._v), (double[])((SVDModel.SVDOutput)model._output)._d)), (double)1.0);
                    if (fromSVD != null) {
                        fromSVD.delete();
                    }
                    if (tB != null) {
                        tB.delete();
                    }
                } else {
                    SVD.this._job.update(1L, "Calculating SVD of small matrix locally");
                    Matrix atqJ = new Matrix(stsk._atq);
                    SingularValueDecomposition svdJ = atqJ.svd();
                    SVD.this._job.update(1L, "Forming distributed orthonormal matrix U");
                    if (((SVDModel.SVDParameters)SVD.this._parms)._keep_u) {
                        u = this.makeUVec(model, u_name, u, qfrm, atqJ, svdJ);
                    }
                    ((SVDModel.SVDOutput)model._output)._d = Arrays.copyOfRange(svdJ.getSingularValues(), 0, ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                    ((SVDModel.SVDOutput)model._output)._v = svdJ.getU().getMatrix(0, atqJ.getRowDimension() - 1, 0, ((SVDModel.SVDParameters)SVD.this._parms)._nv - 1).getArray();
                }
            }
            finally {
                if (qinfo != null) {
                    qinfo.remove();
                }
            }
            return u;
        }

        public Frame makeUVec(SVDModel model, String u_name, Frame u, Frame qfrm, Matrix atqJ, SingularValueDecomposition svdJ) {
            ((SVDModel.SVDOutput)model._output)._u_key = Key.make((String)u_name);
            double[][] svdJ_u = svdJ.getV().getMatrix(0, atqJ.getColumnDimension() - 1, 0, ((SVDModel.SVDParameters)SVD.this._parms)._nv - 1).getArray();
            DataInfo qinfo = new DataInfo(qfrm, null, true, DataInfo.TransformType.NONE, false, false, false);
            DKV.put((Key)qinfo._key, (Iced)qinfo);
            LinearAlgebraUtils.BMulTask btsk = new LinearAlgebraUtils.BMulTask((Key<Job>)SVD.this._job._key, qinfo, ArrayUtils.transpose((double[][])svdJ_u));
            btsk.doAll(((SVDModel.SVDParameters)SVD.this._parms)._nv, (byte)3, qinfo._adaptedFrame);
            qinfo.remove();
            return btsk.outputFrame(((SVDModel.SVDOutput)model._output)._u_key, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeImpl() {
            Frame qfrm;
            Frame u;
            DataInfo tinfo;
            DataInfo dinfo;
            SVDModel model;
            block64: {
                model = null;
                dinfo = null;
                tinfo = null;
                u = null;
                qfrm = null;
                Vec[] uvecs = null;
                try {
                    Gram.GramTask gtsk;
                    String v_name;
                    SVD.this.init(true);
                    if (SVD.this.error_count() > 0) {
                        throw new IllegalArgumentException("Found validation errors: " + SVD.this.validationErrors());
                    }
                    model = new SVDModel((Key<SVDModel>)SVD.this.dest(), (SVDModel.SVDParameters)SVD.this._parms, new SVDModel.SVDOutput(SVD.this));
                    model.delete_and_lock(SVD.this._job);
                    Frame tranRebalanced = new Frame(SVD.this._train);
                    boolean frameHasNas = tranRebalanced.hasNAs();
                    if (!((SVDModel.SVDParameters)SVD.this._parms)._impute_missing && frameHasNas) {
                        tinfo = new DataInfo(SVD.this._train, SVD.this._valid, 0, ((SVDModel.SVDParameters)SVD.this._parms)._use_all_factor_levels, ((SVDModel.SVDParameters)SVD.this._parms)._transform, DataInfo.TransformType.NONE, !((SVDModel.SVDParameters)SVD.this._parms)._impute_missing, ((SVDModel.SVDParameters)SVD.this._parms)._impute_missing, false, false, false, false, false);
                        DKV.put((Key)tinfo._key, (Iced)tinfo);
                        DKV.put((Key)tranRebalanced._key, (Iced)tranRebalanced);
                        SVD.this._train = Rapids.exec((String)String.format("(na.omit %s)", tranRebalanced._key)).getFrame();
                        DKV.remove((Key)tranRebalanced._key);
                        SVD.this.checkMemoryFootPrint();
                    }
                    dinfo = new DataInfo(SVD.this._train, SVD.this._valid, 0, ((SVDModel.SVDParameters)SVD.this._parms)._use_all_factor_levels, ((SVDModel.SVDParameters)SVD.this._parms)._transform, DataInfo.TransformType.NONE, !((SVDModel.SVDParameters)SVD.this._parms)._impute_missing, ((SVDModel.SVDParameters)SVD.this._parms)._impute_missing, false, false, false, false, false);
                    DKV.put((Key)dinfo._key, (Iced)dinfo);
                    if (!((SVDModel.SVDParameters)SVD.this._parms)._impute_missing && frameHasNas) {
                        dinfo._normMul = tinfo._normMul;
                        dinfo._numMeans = tinfo._numMeans;
                        dinfo._numNAFill = dinfo._numMeans;
                        dinfo._normSub = tinfo._normSub;
                    }
                    SVD.this.setSVDModel(model, dinfo);
                    String u_name = ((SVDModel.SVDParameters)SVD.this._parms)._u_name == null || ((SVDModel.SVDParameters)SVD.this._parms)._u_name.length() == 0 ? "SVDUMatrix_" + Key.rand() : ((SVDModel.SVDParameters)SVD.this._parms)._u_name;
                    String string = v_name = ((SVDModel.SVDParameters)SVD.this._parms)._v_name == null || ((SVDModel.SVDParameters)SVD.this._parms)._v_name.length() == 0 ? "SVDVMatrix_" + Key.rand() : ((SVDModel.SVDParameters)SVD.this._parms)._v_name;
                    if (((SVDModel.SVDParameters)SVD.this._parms)._svd_method == SVDModel.SVDParameters.Method.GramSVD) {
                        SVD.this._job.update(1L, "Begin distributed calculation of Gram matrix");
                        gtsk = (Gram.GramTask)new Gram.GramTask((Key<Job>)SVD.this._job._key, dinfo).doAll(dinfo._adaptedFrame);
                        Gram gram = gtsk._gram;
                        assert (gram.fullN() == SVD.this._ncolExp);
                        ((SVDModel.SVDOutput)model._output)._nobs = gtsk._nobs;
                        ((SVDModel.SVDOutput)model._output)._total_variance = gram.diagSum() * (double)gtsk._nobs / (double)(gtsk._nobs - 1L);
                        model.update(SVD.this._job);
                        if (gtsk._nobs == 0L) {
                            SVD.this.error("_train", "Every row in _train contains at least one missing value. Consider setting impute_missing = TRUE.");
                        }
                        if (SVD.this.error_count() > 0) {
                            throw new IllegalArgumentException("Found validation errors: " + SVD.this.validationErrors());
                        }
                        SVD.this._job.update(1L, "Calculating SVD of Gram matrix locally");
                        Matrix gramJ = new Matrix(gtsk._gram.getXX());
                        SingularValueDecomposition svdJ = gramJ.svd();
                        SVD.this._job.update(1L, "Computing stats from SVD");
                        double[] sval = svdJ.getSingularValues();
                        ((SVDModel.SVDOutput)model._output)._d = MemoryManager.malloc8d((int)((SVDModel.SVDParameters)SVD.this._parms)._nv);
                        for (int k = 0; k < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++k) {
                            ((SVDModel.SVDOutput)model._output)._d[k] = Math.sqrt(sval[k] * (double)((SVDModel.SVDOutput)model._output)._nobs);
                        }
                        double[][] v = svdJ.getV().getArray();
                        assert (v.length == SVD.this._ncolExp && LinearAlgebraUtils.numColsExp(dinfo._adaptedFrame, ((SVDModel.SVDParameters)SVD.this._parms)._use_all_factor_levels) == SVD.this._ncolExp);
                        ((SVDModel.SVDOutput)model._output)._v = MemoryManager.malloc8d((int)SVD.this._ncolExp, (int)((SVDModel.SVDParameters)SVD.this._parms)._nv);
                        for (int i = 0; i < v.length; ++i) {
                            System.arraycopy(v[i], 0, ((SVDModel.SVDOutput)model._output)._v[i], 0, ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                        }
                        if (((SVDModel.SVDParameters)SVD.this._parms)._keep_u) {
                            ((SVDModel.SVDOutput)model._output)._u_key = Key.make((String)u_name);
                            double[][] vt = ArrayUtils.transpose((double[][])((SVDModel.SVDOutput)model._output)._v);
                            for (int k = 0; k < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++k) {
                                ArrayUtils.div((double[])vt[k], (double)((SVDModel.SVDOutput)model._output)._d[k]);
                            }
                            LinearAlgebraUtils.BMulTask tsk = (LinearAlgebraUtils.BMulTask)new LinearAlgebraUtils.BMulTask((Key<Job>)SVD.this._job._key, dinfo, vt).doAll(((SVDModel.SVDParameters)SVD.this._parms)._nv, (byte)3, dinfo._adaptedFrame);
                            u = tsk.outputFrame(((SVDModel.SVDOutput)model._output)._u_key, null, null);
                        }
                    } else if (((SVDModel.SVDParameters)SVD.this._parms)._svd_method == SVDModel.SVDParameters.Method.Power) {
                        SVD.this._job.update(1L, "Begin distributed calculation of Gram matrix");
                        gtsk = null;
                        Gram.OuterGramTask ogtsk = null;
                        Gram gram = null;
                        Gram gram_update = null;
                        double[] randomInitialV = null;
                        double[] finalV = null;
                        int eigVecLen = SVD.this._ncolExp;
                        GramUpdate guptsk = null;
                        double[][] gramArrays = null;
                        double[][] gramUpdatesW = null;
                        SVD.access$302(SVD.this, MemoryManager.malloc8d((int)((SVDModel.SVDParameters)SVD.this._parms)._nv));
                        if (SVD.this._wideDataset) {
                            ogtsk = (Gram.OuterGramTask)new Gram.OuterGramTask((Key<Job>)SVD.this._job._key, dinfo).doAll(dinfo._adaptedFrame);
                            gram = ogtsk._gram;
                            ((SVDModel.SVDOutput)model._output)._nobs = ogtsk._nobs;
                            eigVecLen = gram.fullN();
                        } else {
                            gtsk = (Gram.GramTask)new Gram.GramTask((Key<Job>)SVD.this._job._key, dinfo).doAll(dinfo._adaptedFrame);
                            gram = gtsk._gram;
                            assert (gram.fullN() == SVD.this._ncolExp);
                            ((SVDModel.SVDOutput)model._output)._nobs = gtsk._nobs;
                        }
                        ((SVDModel.SVDOutput)model._output)._total_variance = gram.diagSum() * (double)((SVDModel.SVDOutput)model._output)._nobs / (double)(((SVDModel.SVDOutput)model._output)._nobs - 1L);
                        model.update(SVD.this._job);
                        SVD.this._job.update(1L, "Iteration 1 of power method");
                        ((SVDModel.SVDOutput)model._output)._v = MemoryManager.malloc8d((int)((SVDModel.SVDParameters)SVD.this._parms)._nv, (int)eigVecLen);
                        randomInitialV = MemoryManager.malloc8d((int)eigVecLen);
                        finalV = MemoryManager.malloc8d((int)eigVecLen);
                        ((SVDModel.SVDOutput)model._output)._v[0] = Arrays.copyOf(this.powerLoop(gram, ((SVDModel.SVDParameters)SVD.this._parms)._seed, model, randomInitialV, finalV, 0), eigVecLen);
                        double[][] ivv_sum = new double[eigVecLen][eigVecLen];
                        for (int i = 0; i < eigVecLen; ++i) {
                            ivv_sum[i][i] = 1.0;
                        }
                        if (!((SVDModel.SVDParameters)SVD.this._parms)._only_v) {
                            ((SVDModel.SVDOutput)model._output)._d = new double[((SVDModel.SVDParameters)SVD.this._parms)._nv];
                            if (!SVD.this._wideDataset) {
                                ((SVDModel.SVDOutput)model._output)._u_key = Key.make((String)u_name);
                                uvecs = new Vec[((SVDModel.SVDParameters)SVD.this._parms)._nv];
                                this.computeSigmaU(dinfo, model, 0, ivv_sum, uvecs, finalV);
                            }
                        }
                        ((SVDModel.SVDOutput)model._output)._iterations = 1;
                        model.update(SVD.this._job);
                        SVD.updateIVVSum(ivv_sum, ((SVDModel.SVDOutput)model._output)._v[0]);
                        if (SVD.this._wideDataset) {
                            gramArrays = new double[eigVecLen][eigVecLen];
                            gramUpdatesW = new double[eigVecLen][eigVecLen];
                            gram_update = new Gram(eigVecLen, 0, dinfo.numNums(), dinfo._cats, false);
                            SVD.this.updateGram(ivv_sum, gramArrays, gramUpdatesW, gram, gram_update);
                        } else {
                            guptsk = (GramUpdate)new GramUpdate((Key<Job>)SVD.this._job._key, dinfo, ivv_sum).doAll(dinfo._adaptedFrame);
                            gram_update = guptsk._gram;
                        }
                        for (int k = 1; k < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++k) {
                            if (SVD.this._matrixRankReached || SVD.this.stop_requested()) {
                                if (SVD.this.timeout()) {
                                    SVD.this._job.warn("_train SVD: max_runtime_secs is reached.  Not all eigenvalues/eigenvectors are computed.");
                                }
                                int newk = k;
                                SVD.this._job.warn("_train SVD: Dataset is rank deficient.  _parms._nv was " + ((SVDModel.SVDParameters)SVD.this._parms)._nv + " and is now set to " + newk);
                                ((SVDModel.SVDParameters)SVD.this._parms)._nv = newk;
                                break;
                            }
                            SVD.this._job.update(1L, "Iteration " + String.valueOf(k + 1) + " of power method");
                            ((SVDModel.SVDOutput)model._output)._v[k] = Arrays.copyOf(this.powerLoop(gram_update, ((SVDModel.SVDParameters)SVD.this._parms)._seed, model, randomInitialV, finalV, k), eigVecLen);
                            if (!((SVDModel.SVDParameters)SVD.this._parms)._only_v && !SVD.this._wideDataset) {
                                this.computeSigmaU(dinfo, model, k, ivv_sum, uvecs, finalV);
                            }
                            SVD.updateIVVSum(ivv_sum, ((SVDModel.SVDOutput)model._output)._v[k]);
                            if (SVD.this._wideDataset) {
                                SVD.this.updateGram(ivv_sum, gramArrays, gramUpdatesW, gram, gram_update);
                            } else {
                                guptsk = (GramUpdate)new GramUpdate((Key<Job>)SVD.this._job._key, dinfo, ivv_sum).doAll(dinfo._adaptedFrame);
                                gram_update = guptsk._gram;
                            }
                            ++((SVDModel.SVDOutput)model._output)._iterations;
                            model.update(SVD.this._job);
                        }
                        if (!((SVDModel.SVDParameters)SVD.this._parms)._only_v && !((SVDModel.SVDParameters)SVD.this._parms)._keep_u && SVD.this._wideDataset) {
                            for (int vecIndex = 0; vecIndex < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++vecIndex) {
                                ((SVDModel.SVDOutput)model._output)._d[vecIndex] = Math.sqrt((double)((SVDModel.SVDOutput)model._output)._nobs * SVD.this._estimatedSingularValues[vecIndex]);
                            }
                            ((SVDModel.SVDOutput)model._output)._v = DimensionReductionUtils.getTransformedEigenvectors(dinfo, ArrayUtils.transpose((double[][])((SVDModel.SVDOutput)model._output)._v));
                        }
                        if (!SVD.this._wideDataset) {
                            ((SVDModel.SVDOutput)model._output)._v = ArrayUtils.transpose((double[][])((SVDModel.SVDOutput)model._output)._v);
                            if (!((SVDModel.SVDParameters)SVD.this._parms)._only_v && !((SVDModel.SVDParameters)SVD.this._parms)._keep_u) {
                                for (int index = 0; index < ((SVDModel.SVDParameters)SVD.this._parms)._nv; ++index) {
                                    uvecs[index].remove();
                                }
                                ((SVDModel.SVDOutput)model._output)._u_key = null;
                            } else if (!((SVDModel.SVDParameters)SVD.this._parms)._only_v && ((SVDModel.SVDParameters)SVD.this._parms)._keep_u) {
                                u = new Frame(((SVDModel.SVDOutput)model._output)._u_key, null, uvecs);
                                DKV.put((Key)u._key, (Iced)u);
                                DivideU utsk = new DivideU(((SVDModel.SVDOutput)model._output)._d);
                                utsk.doAll(u);
                            }
                        }
                        if (SVD.this._failedConvergence) {
                            SVD.this._job.warn("_train: PCA Power method failed to converge within TOLERANCE.  Increase max_iterations or reduce TOLERANCE to mitigate this problem.");
                        }
                        LinkedHashMap<String, ArrayList> scoreTable = new LinkedHashMap<String, ArrayList>();
                        scoreTable.put("Timestamp", ((SVDModel.SVDOutput)model._output)._training_time_ms);
                        scoreTable.put("err", ((SVDModel.SVDOutput)model._output)._history_err);
                        scoreTable.put("Principal Component #", ((SVDModel.SVDOutput)model._output)._history_eigenVectorIndex);
                        ((SVDModel.SVDOutput)model._output)._scoring_history = DimensionReductionUtils.createScoringHistoryTableDR(scoreTable, "Scoring History from Power SVD", SVD.this._job.start_time());
                    } else if (((SVDModel.SVDParameters)SVD.this._parms)._svd_method == SVDModel.SVDParameters.Method.Randomized) {
                        qfrm = this.randSubIter(dinfo, model);
                        u = this.directSVD(dinfo, qfrm, model, u_name);
                        ((SVDModel.SVDOutput)model._output)._training_time_ms.add(System.currentTimeMillis());
                        if (SVD.this.stop_requested() && ((SVDModel.SVDOutput)model._output)._history_average_SEE.size() == 0) {
                            ((SVDModel.SVDOutput)model._output)._history_average_SEE.add(Double.POSITIVE_INFINITY);
                        }
                        ((SVDModel.SVDOutput)model._output)._history_average_SEE.add(((SVDModel.SVDOutput)model._output)._history_average_SEE.get(((SVDModel.SVDOutput)model._output)._history_average_SEE.size() - 1));
                        LinkedHashMap<String, ArrayList> scoreTable = new LinkedHashMap<String, ArrayList>();
                        scoreTable.put("Timestamp", ((SVDModel.SVDOutput)model._output)._training_time_ms);
                        scoreTable.put("average SEE", ((SVDModel.SVDOutput)model._output)._history_average_SEE);
                        ((SVDModel.SVDOutput)model._output)._scoring_history = DimensionReductionUtils.createScoringHistoryTableDR(scoreTable, "Scoring History from Randomized SVD", SVD.this._job.start_time());
                    } else {
                        SVD.this.error("_svd_method", "Unrecognized SVD method " + (Object)((Object)((SVDModel.SVDParameters)SVD.this._parms)._svd_method));
                    }
                    if (((SVDModel.SVDParameters)SVD.this._parms)._save_v_frame) {
                        ((SVDModel.SVDOutput)model._output)._v_key = Key.make((String)v_name);
                        ArrayUtils.frame(((SVDModel.SVDOutput)model._output)._v_key, null, (double[][])((SVDModel.SVDOutput)model._output)._v);
                    }
                    if (((SVDModel.SVDOutput)model._output)._d != null && ((SVDModel.SVDParameters)SVD.this._parms)._nv < ((SVDModel.SVDOutput)model._output)._d.length) {
                        ((SVDModel.SVDOutput)model._output)._d = Arrays.copyOf(((SVDModel.SVDOutput)model._output)._d, ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                        for (int index = 0; index < ((SVDModel.SVDOutput)model._output)._v.length; ++index) {
                            ((SVDModel.SVDOutput)model._output)._v[index] = Arrays.copyOf(((SVDModel.SVDOutput)model._output)._v[index], ((SVDModel.SVDParameters)SVD.this._parms)._nv);
                        }
                    }
                    ((SVDModel.SVDOutput)model._output)._model_summary = SVD.this.createModelSummaryTable((SVDModel.SVDOutput)model._output);
                    model.update(SVD.this._job);
                    if (model == null) break block64;
                }
                catch (Throwable throwable) {
                    if (model != null) {
                        model.unlock(SVD.this._job);
                    }
                    if (dinfo != null) {
                        dinfo.remove();
                    }
                    if (tinfo != null) {
                        tinfo.remove();
                    }
                    if (u != null & !((SVDModel.SVDParameters)SVD.this._parms)._keep_u) {
                        u.delete();
                    }
                    if (qfrm != null) {
                        qfrm.delete();
                    }
                    ArrayList<Key> keep = new ArrayList<Key>();
                    if (model._output != null) {
                        Frame vFrm;
                        Frame uFrm;
                        if (((SVDModel.SVDOutput)model._output)._u_key != null && (uFrm = (Frame)DKV.getGet(((SVDModel.SVDOutput)model._output)._u_key)) != null) {
                            for (Vec vec : uFrm.vecs()) {
                                keep.add(vec._key);
                            }
                        }
                        if ((vFrm = (Frame)DKV.getGet(((SVDModel.SVDOutput)model._output)._v_key)) != null) {
                            for (Vec vec : vFrm.vecs()) {
                                keep.add(vec._key);
                            }
                        }
                    }
                    Scope.untrack(keep);
                    throw throwable;
                }
                model.unlock(SVD.this._job);
            }
            if (dinfo != null) {
                dinfo.remove();
            }
            if (tinfo != null) {
                tinfo.remove();
            }
            if (u != null & !((SVDModel.SVDParameters)SVD.this._parms)._keep_u) {
                u.delete();
            }
            if (qfrm != null) {
                qfrm.delete();
            }
            ArrayList<Key> keep = new ArrayList<Key>();
            if (model._output != null) {
                Frame vFrm;
                Frame uFrm;
                if (((SVDModel.SVDOutput)model._output)._u_key != null && (uFrm = (Frame)DKV.getGet(((SVDModel.SVDOutput)model._output)._u_key)) != null) {
                    for (Vec vec : uFrm.vecs()) {
                        keep.add(vec._key);
                    }
                }
                if ((vFrm = (Frame)DKV.getGet(((SVDModel.SVDOutput)model._output)._v_key)) != null) {
                    for (Vec vec : vFrm.vecs()) {
                        keep.add(vec._key);
                    }
                }
            }
            Scope.untrack(keep);
        }
    }
}

