/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isoforextended.isolationtree;

import hex.tree.isoforextended.isolationtree.AbstractCompressedNode;
import hex.tree.isoforextended.isolationtree.CompressedLeaf;
import hex.tree.isoforextended.isolationtree.CompressedNode;
import water.Key;
import water.Keyed;
import water.util.ArrayUtils;
import water.util.MathUtils;

public class CompressedIsolationTree
extends Keyed<CompressedIsolationTree> {
    private final AbstractCompressedNode[] _nodes;

    public CompressedIsolationTree(int heightLimit) {
        this._key = Key.make((String)("CompressedIsolationTree" + Key.rand()));
        this._nodes = new AbstractCompressedNode[(int)Math.pow(2.0, heightLimit + 1) - 1];
    }

    public AbstractCompressedNode[] getNodes() {
        return this._nodes;
    }

    private int leftChildIndex(int i) {
        return 2 * i + 1;
    }

    private int rightChildIndex(int i) {
        return 2 * i + 2;
    }

    private CompressedNode compressedNode(AbstractCompressedNode node) {
        assert (node instanceof CompressedNode) : "AbstractCompressedNode cannot be cast to CompressedNode";
        return (CompressedNode)node;
    }

    private CompressedLeaf compressedLeaf(AbstractCompressedNode node) {
        assert (node instanceof CompressedLeaf) : "AbstractCompressedNode cannot be cast to CompressedLeaf";
        return (CompressedLeaf)node;
    }

    private boolean isLeaf(AbstractCompressedNode node) {
        return node instanceof CompressedLeaf;
    }

    public double computePathLength(double[] row) {
        CompressedNode compressedNode;
        double mul;
        int position = 0;
        AbstractCompressedNode node = this._nodes[0];
        while (!this.isLeaf(node) && (position = (mul = ArrayUtils.subAndMul((double[])row, (double[])(compressedNode = this.compressedNode(node)).getP(), (double[])compressedNode.getN())) <= 0.0 ? this.leftChildIndex(position) : this.rightChildIndex(position)) < this._nodes.length) {
            node = this._nodes[position];
        }
        return (double)node.getHeight() + CompressedIsolationTree.averagePathLengthOfUnsuccessfulSearch(this.compressedLeaf(node).getNumRows());
    }

    public static double averagePathLengthOfUnsuccessfulSearch(long n) {
        if (n < 2L) {
            return 0.0;
        }
        if (n == 2L) {
            return 1.0;
        }
        return 2.0 * MathUtils.harmonicNumberEstimation((long)(n - 1L)) - 2.0 * ((double)n - 1.0) / (double)n;
    }
}

