/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import hex.Model;
import hex.ModelMojoWriter;
import hex.coxph.CoxPHModel;
import java.io.IOException;
import water.rapids.ast.prims.mungers.AstGroup;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.IcedInt;

public class CoxPHMojoWriter
extends ModelMojoWriter<CoxPHModel, CoxPHModel.CoxPHParameters, CoxPHModel.CoxPHOutput> {
    public CoxPHMojoWriter() {
    }

    public CoxPHMojoWriter(CoxPHModel model) {
        super((Model)model);
    }

    public String mojoVersion() {
        return "1.00";
    }

    protected void writeModelData() throws IOException {
        this.writeRectangularDoubleArray(((CoxPHModel.CoxPHOutput)((CoxPHModel)this.model)._output)._x_mean_cat, "x_mean_cat");
        this.writeRectangularDoubleArray(((CoxPHModel.CoxPHOutput)((CoxPHModel)this.model)._output)._x_mean_num, "x_mean_num");
        this.writekv("coef", ((CoxPHModel.CoxPHOutput)((CoxPHModel)this.model)._output)._coef);
        this.writekv("cats", ((CoxPHModel.CoxPHOutput)((CoxPHModel)this.model)._output).data_info._cats);
        this.writekv("cat_offsets", ((CoxPHModel.CoxPHOutput)((CoxPHModel)this.model)._output).data_info._catOffsets);
        this.writekv("use_all_factor_levels", ((CoxPHModel.CoxPHOutput)((CoxPHModel)this.model)._output).data_info._useAllFactorLevels);
        this.writeStrata();
        this.writeInteractions();
    }

    private void writeStrata() throws IOException {
        IcedHashMap<AstGroup.G, IcedInt> strataMap = ((CoxPHModel.CoxPHOutput)((CoxPHModel)this.model)._output)._strataMap;
        this.writekv("strata_count", strataMap.size());
        int strataNum = 0;
        for (AstGroup.G g : strataMap.keySet()) {
            this.writekv("strata_" + strataNum, g._gs);
            ++strataNum;
        }
    }

    private void writeInteractions() throws IOException {
        Model.InteractionPair[] interactions = ((CoxPHModel.CoxPHOutput)((CoxPHModel)this.model)._output).data_info._interactions;
        if (interactions == null || interactions.length == 0) {
            return;
        }
        Object[] columnNames = ((CoxPHModel)this.model).modelDescriptor().columnNames();
        int[] interaction_1 = new int[interactions.length];
        int[] interaction_2 = new int[interactions.length];
        for (int i = 0; i < interactions.length; ++i) {
            interaction_1[i] = ArrayUtils.find((Object[])columnNames, (Object)interactions[i]._name1);
            interaction_2[i] = ArrayUtils.find((Object[])columnNames, (Object)interactions[i]._name2);
        }
        this.writekv("interactions_1", interaction_1);
        this.writekv("interactions_2", interaction_2);
        int[] targets = new int[((CoxPHModel.CoxPHOutput)((CoxPHModel)this.model)._output).data_info._interactionVecs.length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = ArrayUtils.find((Object[])columnNames, (Object)((CoxPHModel.CoxPHOutput)((CoxPHModel)this.model)._output).data_info._adaptedFrame.name(((CoxPHModel.CoxPHOutput)((CoxPHModel)this.model)._output).data_info._interactionVecs[i]));
        }
        this.writekv("interaction_targets", targets);
    }
}

