/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.GamSplines;

import hex.gam.GamSplines.NBSplinesUtils;
import hex.genmodel.algos.gam.GamUtilsISplines;

public class NBSplinesTypeI {
    private static final double EPS = 1.0E-12;
    public final int _order;
    public double[][] _nodeCoeffs;
    private double[] _coeffLeft;
    private double[] _coeffRight;
    private double[] _knots;
    private double _commonConst;
    private NBSplinesTypeI _left;
    private NBSplinesTypeI _right;

    public NBSplinesTypeI(double[] knots, int order, int basisIndex, int offset, int numKnotInt) {
        this._order = order;
        this._knots = GamUtilsISplines.extractKnots((int)offset, (int)order, (double[])knots);
        this._nodeCoeffs = new double[numKnotInt][];
        this.setConstNChildCoeffs(knots, offset);
        this._left = null;
        this._right = null;
    }

    public void setConstNChildCoeffs(double[] knots, int offset) {
        if (this._order == 1) {
            double[] dArray;
            this._commonConst = 0.0;
            if (Math.abs(this._knots[1] - this._knots[0]) < 1.0E-12) {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = 0.0;
            } else {
                double[] dArray3 = new double[1];
                dArray = dArray3;
                dArray3[0] = 1.0 / (this._knots[1] - this._knots[0]);
            }
            this._coeffLeft = dArray;
            this._coeffRight = (double[])this._coeffLeft.clone();
        } else {
            this._commonConst = Math.abs(knots[offset] - knots[offset + this._order]) < 1.0E-12 ? 0.0 : (double)this._order / ((knots[offset + this._order] - knots[offset]) * (double)(this._order - 1));
            this._coeffLeft = new double[]{-knots[offset], 1.0};
            this._coeffRight = new double[]{knots[this._order + offset], -1.0};
        }
    }

    public static void extractNBSplineCoeffs(NBSplinesTypeI root, int order, double[] coeffParent, double constParent, int basisIndex) {
        if (order == 1) {
            if (Math.abs(root._knots[1] - root._knots[0]) > 1.0E-12) {
                root._nodeCoeffs[basisIndex] = NBSplinesUtils.polynomialProduct(new double[]{constParent / (root._knots[1] - root._knots[0])}, coeffParent);
            }
        } else {
            NBSplinesTypeI.extractNBSplineCoeffs(root._left, order - 1, root._coeffLeft, root._commonConst, basisIndex);
            NBSplinesTypeI.extractNBSplineCoeffs(root._right, order - 1, root._coeffRight, root._commonConst, basisIndex + 1);
            NBSplinesUtils.sumCoeffs(root._left._nodeCoeffs, root._right._nodeCoeffs, root._nodeCoeffs);
            NBSplinesUtils.combineParentCoef(coeffParent, constParent, root._nodeCoeffs);
        }
    }

    public static double[][] extractCoeffs(NBSplinesTypeI root, int basisIndex, double parentConst) {
        if (root._order == 1) {
            if (Math.abs(root._knots[1] - root._knots[0]) > 1.0E-12) {
                double temp = parentConst / (root._knots[1] - root._knots[0]);
                root._nodeCoeffs[basisIndex] = new double[]{temp};
            }
            return root._nodeCoeffs;
        }
        NBSplinesTypeI.extractNBSplineCoeffs(root, root._order, new double[]{1.0}, parentConst, basisIndex);
        return root._nodeCoeffs;
    }

    public static NBSplinesTypeI formBasis(double[] knots, int order, int basisIndex, int offset, int numKnotInt) {
        if (order == 1) {
            return new NBSplinesTypeI(knots, order, basisIndex, offset, numKnotInt);
        }
        NBSplinesTypeI nbsplines = new NBSplinesTypeI(knots, order, basisIndex, offset, numKnotInt);
        nbsplines._left = NBSplinesTypeI.formBasis(nbsplines._knots, order - 1, basisIndex, 0, numKnotInt);
        nbsplines._right = NBSplinesTypeI.formBasis(nbsplines._knots, order - 1, basisIndex, 1, numKnotInt);
        return nbsplines;
    }
}

