/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm.psvm;

import water.Iced;
import water.MemoryManager;

class LLMatrix
extends Iced<LLMatrix> {
    private final int _dim;
    private final double[][] _data;

    LLMatrix(int dim) {
        this._dim = dim;
        this._data = new double[dim][];
        for (int i = 0; i < dim; ++i) {
            this._data[i] = new double[dim - i];
        }
    }

    private int dim() {
        return this._dim;
    }

    final double get(int x, int y) {
        return this._data[y][x - y];
    }

    final void set(int x, int y, double value) {
        this._data[y][x - y] = value;
    }

    final void addUnitMat() {
        for (double[] col : this._data) {
            col[0] = col[0] + 1.0;
        }
    }

    double[] cholSolve(double[] b) {
        double[] x = MemoryManager.malloc8d((int)b.length);
        this.cholForwardSub(b, x);
        this.cholBackwardSub(x, b);
        return b;
    }

    private void cholBackwardSub(double[] b, double[] x) {
        int dim = this.dim();
        for (int k = dim - 1; k >= 0; --k) {
            double tmp = b[k];
            for (int i = k + 1; i < dim; ++i) {
                tmp -= x[i] * this.get(i, k);
            }
            x[k] = tmp / this.get(k, k);
        }
    }

    private void cholForwardSub(double[] b, double[] x) {
        int dim = this.dim();
        for (int k = 0; k < dim; ++k) {
            double tmp = b[k];
            for (int i = 0; i < k; ++i) {
                tmp -= x[i] * this.get(k, i);
            }
            x[k] = tmp / this.get(k, k);
        }
    }

    LLMatrix cf() {
        int dim = this.dim();
        LLMatrix m = new LLMatrix(dim);
        for (int i = 0; i < dim; ++i) {
            for (int j = i; j < dim; ++j) {
                double sum = this.get(j, i);
                for (int k = i - 1; k >= 0; --k) {
                    sum -= m.get(i, k) * m.get(j, k);
                }
                if (i == j) {
                    if (sum <= 0.0) {
                        throw new IllegalStateException("Only symmetric positive definite matrix can perform Cholesky factorization.");
                    }
                    m.set(i, i, Math.sqrt(sum));
                    continue;
                }
                m.set(j, i, sum / m.get(i, i));
            }
        }
        return m;
    }
}

