/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.drf;

import hex.Model;
import hex.tree.CompressedForest;
import hex.tree.SharedTreeModel;
import hex.tree.SharedTreeModelWithContributions;
import hex.tree.SharedTreePojoWriter;
import hex.tree.drf.DRF;
import hex.tree.drf.DrfMojoWriter;
import hex.tree.drf.DrfPojoWriter;
import hex.util.EffectiveParametersUtils;
import water.Key;
import water.fvec.NewChunk;
import water.util.MathUtils;

public class DRFModel
extends SharedTreeModelWithContributions<DRFModel, DRFParameters, DRFOutput> {
    public DRFModel(Key<DRFModel> selfKey, DRFParameters parms, DRFOutput output) {
        super(selfKey, parms, output);
    }

    public void initActualParamValues() {
        super.initActualParamValues();
        EffectiveParametersUtils.initFoldAssignment(this._parms);
        EffectiveParametersUtils.initHistogramType((SharedTreeModel.SharedTreeParameters)this._parms);
        EffectiveParametersUtils.initCategoricalEncoding(this._parms, Model.Parameters.CategoricalEncodingScheme.Enum);
    }

    public void initActualParamValuesAfterOutputSetup(boolean isClassifier) {
        EffectiveParametersUtils.initStoppingMetric(this._parms, isClassifier);
    }

    @Override
    protected SharedTreeModelWithContributions.ScoreContributionsTask getScoreContributionsTask(SharedTreeModel model) {
        return new ScoreContributionsTaskDRF((SharedTreeModel)this);
    }

    @Override
    protected SharedTreeModelWithContributions.ScoreContributionsTask getScoreContributionsSoringTask(SharedTreeModel model, Model.Contributions.ContributionsOptions options) {
        return new ScoreContributionsSoringTaskDRF((SharedTreeModel)this, options);
    }

    @Override
    public boolean binomialOpt() {
        return !((DRFParameters)this._parms)._binomial_double_trees;
    }

    @Override
    protected double[] score0(double[] data, double[] preds, double offset, int ntrees) {
        super.score0(data, preds, offset, ntrees);
        int N = ((DRFOutput)this._output)._ntrees;
        if (((DRFOutput)this._output).nclasses() == 1) {
            if (N >= 1) {
                preds[0] = preds[0] / (double)N;
            }
        } else if (((DRFOutput)this._output).nclasses() == 2 && this.binomialOpt()) {
            if (N >= 1) {
                preds[1] = preds[1] / (double)N;
            }
            preds[2] = 1.0 - preds[1];
        } else {
            double sum = MathUtils.sum((double[])preds);
            if (sum > 0.0) {
                MathUtils.div((double[])preds, (double)sum);
            }
        }
        return preds;
    }

    @Override
    protected SharedTreePojoWriter makeTreePojoWriter() {
        CompressedForest compressedForest = new CompressedForest(((DRFOutput)this._output)._treeKeys, ((DRFOutput)this._output)._domains);
        CompressedForest.LocalCompressedForest localCompressedForest = compressedForest.fetch();
        return new DrfPojoWriter(this, localCompressedForest._trees);
    }

    public DrfMojoWriter getMojo() {
        return new DrfMojoWriter(this);
    }

    public class ScoreContributionsSoringTaskDRF
    extends SharedTreeModelWithContributions.ScoreContributionsSortingTask {
        public ScoreContributionsSoringTaskDRF(SharedTreeModel model, Model.Contributions.ContributionsOptions options) {
            super(DRFModel.this, model, options);
        }

        @Override
        public void doModelSpecificComputation(float[] contribs) {
            for (int i = 0; i < contribs.length; ++i) {
                if (this._output.nclasses() == 1) {
                    contribs[i] = contribs[i] / (float)this._output._ntrees;
                    continue;
                }
                float featurePlusBiasRatio = 1.0f / (float)(this._output.nfeatures() + 1);
                contribs[i] = featurePlusBiasRatio - contribs[i] / (float)this._output._ntrees;
            }
        }
    }

    public class ScoreContributionsTaskDRF
    extends SharedTreeModelWithContributions.ScoreContributionsTask {
        public ScoreContributionsTaskDRF(SharedTreeModel model) {
            super(DRFModel.this, model);
        }

        @Override
        public void addContribToNewChunk(float[] contribs, NewChunk[] nc) {
            for (int i = 0; i < nc.length; ++i) {
                if (this._output.nclasses() == 1) {
                    nc[i].addNum((double)(contribs[i] / (float)this._output._ntrees));
                    continue;
                }
                float featurePlusBiasRatio = 1.0f / (float)(this._output.nfeatures() + 1);
                nc[i].addNum((double)(featurePlusBiasRatio - contribs[i] / (float)this._output._ntrees));
            }
        }
    }

    public static class DRFOutput
    extends SharedTreeModel.SharedTreeOutput {
        public DRFOutput(DRF b) {
            super(b);
        }
    }

    public static class DRFParameters
    extends SharedTreeModel.SharedTreeParameters {
        public boolean _binomial_double_trees = false;
        public int _mtries = -1;

        public String algoName() {
            return "DRF";
        }

        public String fullName() {
            return "Distributed Random Forest";
        }

        public String javaName() {
            return DRFModel.class.getName();
        }

        public DRFParameters() {
            this._max_depth = 20;
            this._min_rows = 1.0;
        }
    }
}

