/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.GLMMetrics;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelBuilderHelper;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.MultinomialAucType;
import hex.ScoreKeeper;
import hex.ScoringInfo;
import hex.StringPair;
import hex.VarImp;
import hex.api.MakeGLMModelHandler;
import hex.deeplearning.DeepLearningModel;
import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.DistributionFamily;
import hex.glm.ComputationState;
import hex.glm.GLM;
import hex.glm.GLMMetricBuilder;
import hex.glm.GLMMojoWriter;
import hex.glm.GLMScore;
import hex.glm.GLMScoringInfo;
import hex.glm.GLMTask;
import hex.glm.GLMUtils;
import hex.modelselection.ModelSelectionUtils;
import hex.schemas.GLMModelV3;
import hex.util.DistributionUtils;
import hex.util.EffectiveParametersUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.IcedUtils;
import water.Job;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.codegen.CodeGenerator;
import water.codegen.CodeGeneratorPipeline;
import water.exceptions.JCodeSB;
import water.fvec.Frame;
import water.fvec.Vec;
import water.udf.CFuncRef;
import water.util.JCodeGen;
import water.util.Log;
import water.util.MathUtils;
import water.util.SBPrintStream;
import water.util.TwoDimTable;

public class GLMModel
extends Model<GLMModel, GLMParameters, GLMOutput> {
    public static final double _EPS = 1.0E-6;
    public static final double _OneOEPS = 1000000.0;
    public final double _lambda_max;
    public final double[] _ymu;
    public final long _nullDOF;
    public final double _ySigma;
    public final long _nobs;
    public double[] _betaCndCheckpoint;
    private static String[] binomialClassNames = new String[]{"0", "1"};
    private static ThreadLocal<double[]> _eta = new ThreadLocal();

    public GLMModel(Key selfKey, GLMParameters parms, GLM job, double[] ymu, double ySigma, double lambda_max, long nobs) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)(job == null ? new GLMOutput() : new GLMOutput(job)));
        this._ymu = ymu;
        this._ySigma = ySigma;
        this._lambda_max = lambda_max;
        this._nobs = nobs;
        this._nullDOF = nobs - (long)(parms._intercept ? 1 : 0);
    }

    public Frame getRIDFrame() {
        if (((GLMOutput)this._output)._regression_influence_diagnostics != null) {
            return (Frame)DKV.getGet(((GLMOutput)this._output)._regression_influence_diagnostics);
        }
        return null;
    }

    public void initActualParamValues() {
        super.initActualParamValues();
        EffectiveParametersUtils.initFoldAssignment(this._parms);
    }

    public ScoreKeeper[] scoreKeepers() {
        int size = this.scoringInfo == null ? 0 : this.scoringInfo.length;
        ScoreKeeper[] sk = new ScoreKeeper[size];
        for (int i = 0; i < size; ++i) {
            sk[i] = this.scoringInfo[i].cross_validation ? this.scoringInfo[i].scored_xval : (this.scoringInfo[i].validation ? this.scoringInfo[i].scored_valid : this.scoringInfo[i].scored_train);
        }
        return sk;
    }

    public ScoringInfo[] getScoringInfo() {
        return this.scoringInfo;
    }

    public void addScoringInfo(GLMParameters parms, int nclasses, long currTime, int iter) {
        if (this.scoringInfo != null && ((GLMScoringInfo)this.scoringInfo[this.scoringInfo.length - 1]).iterations() >= iter) {
            return;
        }
        GLMScoringInfo currInfo = new GLMScoringInfo();
        currInfo.is_classification = nclasses > 1;
        currInfo.validation = parms.valid() != null;
        currInfo.cross_validation = parms._nfolds > 1;
        currInfo.iterations = iter;
        currInfo.time_stamp_ms = this.scoringInfo == null ? ((GLMOutput)this._output)._start_time : currTime;
        currInfo.total_training_time_ms = ((GLMOutput)this._output)._training_time_ms;
        if (((GLMOutput)this._output)._training_metrics != null) {
            currInfo.scored_train = new ScoreKeeper(Double.NaN);
            currInfo.scored_train.fillFrom(((GLMOutput)this._output)._training_metrics);
        }
        if (((GLMOutput)this._output)._validation_metrics != null) {
            currInfo.scored_valid = new ScoreKeeper(Double.NaN);
            currInfo.scored_valid.fillFrom(((GLMOutput)this._output)._validation_metrics);
        }
        this.scoringInfo = ScoringInfo.prependScoringInfo((ScoringInfo)currInfo, (ScoringInfo[])this.scoringInfo);
    }

    public void setVcov(double[][] inv) {
        ((GLMOutput)this._output)._vcov = inv;
    }

    public String[] buildVariableInflationFactors(Frame train, DataInfo dinfo) {
        String[] predictorNames = ModelSelectionUtils.extractPredictorNames(this._parms, dinfo, ((GLMParameters)this._parms)._fold_column);
        String[] vifPredictors = GLMModel.getVifPredictors(train, (GLMParameters)this._parms, dinfo);
        return this.buildVariableInflationFactors((GLMParameters)this._parms, vifPredictors, predictorNames);
    }

    static String[] getVifPredictors(Frame train, GLMParameters parms, DataInfo dinfo) {
        String[] predictorNames = ModelSelectionUtils.extractPredictorNames(parms, dinfo, parms._fold_column);
        return (String[])Stream.of(predictorNames).filter(x -> train.find(x) >= 0 && train.vec(x).isNumeric()).toArray(String[]::new);
    }

    public String[] buildVariableInflationFactors(GLMParameters parms, String[] validPredictors, String[] predictorNames) {
        ((GLMOutput)this._output)._variable_inflation_factors = IntStream.range(0, validPredictors.length).mapToDouble(x -> Double.NaN).boxed().collect(Collectors.toList()).stream().mapToDouble(Double::doubleValue).toArray();
        GLMParameters[] allParams = GLMUtils.genGLMParameters(parms, validPredictors, predictorNames);
        ModelBuilder[] glmBuilder = (GLM[])Stream.of(allParams).map(x -> new GLM((GLMParameters)((Object)x))).collect(Collectors.toList()).stream().toArray(GLM[]::new);
        int parallelization = GLMModel.nVIFModelsInParallel(parms);
        GLM[] glmResults = (GLM[])ModelBuilderHelper.trainModelsParallel((ModelBuilder[])glmBuilder, (int)parallelization);
        Double[] r2 = (Double[])Arrays.stream(glmResults).mapToDouble(x -> ((GLMModel)x.get()).r2()).boxed().collect(Collectors.toList()).stream().toArray(Double[]::new);
        for (GLM glm : glmResults) {
            ((GLMModel)glm.get()).remove();
        }
        ((GLMOutput)this._output)._variable_inflation_factors = IntStream.range(0, validPredictors.length).mapToDouble(x -> 1.0 / (1.0 - r2[x])).boxed().collect(Collectors.toList()).stream().mapToDouble(Double::doubleValue).toArray();
        return validPredictors;
    }

    static int nVIFModelsInParallel(GLMParameters parms) {
        Frame train;
        if (parms._is_cv_model) {
            return 1;
        }
        String userSpec = H2O.getSysProperty((String)("glm.vif." + parms._train + ".nparallelism"), null);
        if (userSpec != null) {
            try {
                int vifParallelization = Integer.parseInt(userSpec);
                if (vifParallelization <= 0 || vifParallelization > H2O.ARGS.nthreads) {
                    Log.warn((Object[])new Object[]{"Ignoring user-specified parallelization level for VIF calculation. Value '" + userSpec + "' is out of range (0, nthreads]."});
                }
                return vifParallelization;
            }
            catch (Exception e) {
                Log.err((Object[])new Object[]{"Invalid user-specified parallelization level. Cannot parse value '" + userSpec + "' as a number.", e});
            }
        }
        if ((train = parms.train()) != null && (double)train.byteSize() < 1000000.0) {
            return H2O.ARGS.nthreads;
        }
        return 2;
    }

    public RegularizationPath getRegularizationPath() {
        RegularizationPath rp = new RegularizationPath();
        rp._coefficient_names = ((GLMOutput)this._output)._coefficient_names;
        int N = ((GLMOutput)this._output)._submodels.length;
        int P = ((GLMOutput)this._output)._dinfo.fullN() + 1;
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.multinomial || ((GLMParameters)this._parms)._family == GLMParameters.Family.ordinal) {
            String[] classNames = ((GLMOutput)this._output)._domains[((GLMOutput)this._output)._domains.length - 1];
            String[] coefNames = new String[P * ((GLMOutput)this._output).nclasses()];
            for (int c = 0; c < ((GLMOutput)this._output).nclasses(); ++c) {
                for (int i = 0; i < P; ++i) {
                    coefNames[c * P + i] = ((GLMOutput)this._output)._coefficient_names[i] + "_" + classNames[c];
                }
            }
            rp._coefficient_names = coefNames;
            P *= ((GLMOutput)this._output).nclasses();
        }
        rp._lambdas = new double[N];
        rp._alphas = new double[N];
        rp._coefficients = new double[N][];
        rp._explained_deviance_train = new double[N];
        if (((GLMParameters)this._parms)._valid != null) {
            rp._explained_deviance_valid = new double[N];
        }
        if (((GLMParameters)this._parms)._standardize) {
            rp._coefficients_std = new double[N][];
        }
        if (((GLMParameters)this._parms)._compute_p_values) {
            rp._z_values = new double[N][];
            rp._p_values = new double[N][];
            rp._std_errs = new double[N][];
        }
        for (int i = 0; i < N; ++i) {
            Submodel sm = ((GLMOutput)this._output)._submodels[i];
            rp._lambdas[i] = sm.lambda_value;
            rp._alphas[i] = sm.alpha_value;
            rp._coefficients[i] = sm.getBeta(MemoryManager.malloc8d((int)P));
            if (((GLMParameters)this._parms)._standardize) {
                rp._coefficients_std[i] = rp._coefficients[i];
                rp._coefficients[i] = ((GLMOutput)this._output)._dinfo.denormalizeBeta(rp._coefficients_std[i]);
            }
            if (((GLMParameters)this._parms)._compute_p_values) {
                rp._z_values[i] = sm.getZValues(MemoryManager.malloc8d((int)P));
                rp._p_values[i] = sm.pValues(rp._z_values[i], ((GLMOutput)this._output)._training_metrics.residual_degrees_of_freedom());
                rp._std_errs[i] = sm.stdErr(rp._z_values[i], rp._coefficients[i]);
            }
            rp._explained_deviance_train[i] = 1.0 - (double)((GLMOutput)this._output)._training_metrics._nobs * sm.devianceTrain / ((GLMMetrics)((GLMOutput)this._output)._training_metrics).null_deviance();
            if (rp._explained_deviance_valid == null) continue;
            rp._explained_deviance_valid[i] = 1.0 - (double)((GLMOutput)this._output)._validation_metrics._nobs * sm.devianceValid / ((GLMMetrics)((GLMOutput)this._output)._validation_metrics).null_deviance();
        }
        return rp;
    }

    protected boolean toJavaCheckTooBig() {
        if (this.beta() != null && this.beta().length > 10000) {
            Log.warn((Object[])new Object[]{"toJavaCheckTooBig must be overridden for this model type to render it in the browser"});
            return true;
        }
        return false;
    }

    public DataInfo dinfo() {
        return ((GLMOutput)this._output)._dinfo;
    }

    private int rank(double[] ds) {
        int res = 0;
        for (double d : ds) {
            if (d == 0.0) continue;
            ++res;
        }
        return res;
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        if (domain == null && (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial || ((GLMParameters)this._parms)._family == GLMParameters.Family.quasibinomial || ((GLMParameters)this._parms)._family == GLMParameters.Family.fractionalbinomial)) {
            domain = binomialClassNames;
        }
        if (((GLMParameters)this._parms)._HGLM) {
            String[] domaint = new String[]{"HGLM_" + ((GLMParameters)this._parms)._family.toString() + "_" + ((GLMParameters)this._parms)._rand_family[0].toString()};
            return new GLMMetricBuilder(domaint, null, null, 0, true, false, MultinomialAucType.NONE);
        }
        return new GLMMetricBuilder(domain, this._ymu, new GLMWeightsFun((GLMParameters)this._parms), ((GLMOutput)this._output).bestSubmodel().rank(), true, ((GLMParameters)this._parms)._intercept, ((GLMParameters)this._parms)._auc_type);
    }

    protected double[] beta_internal() {
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.multinomial || ((GLMParameters)this._parms)._family == GLMParameters.Family.ordinal) {
            return ArrayUtils.flat((double[][])((GLMOutput)this._output)._global_beta_multinomial);
        }
        return ((GLMOutput)this._output)._global_beta;
    }

    public double[] beta() {
        return this.beta_internal();
    }

    public double[] beta(double lambda) {
        for (int i = 0; i < ((GLMOutput)this._output)._submodels.length; ++i) {
            if (((GLMOutput)this._output)._submodels[i].lambda_value != lambda) continue;
            return ((GLMOutput)this._output)._dinfo.denormalizeBeta(((GLMOutput)this._output)._submodels[i].getBeta(MemoryManager.malloc8d((int)(((GLMOutput)this._output)._dinfo.fullN() + 1))));
        }
        throw new RuntimeException("no such lambda value, lambda = " + lambda);
    }

    public double[] beta_std(double lambda) {
        for (int i = 0; i < ((GLMOutput)this._output)._submodels.length; ++i) {
            if (((GLMOutput)this._output)._submodels[i].lambda_value != lambda) continue;
            return ((GLMOutput)this._output)._submodels[i].getBeta(MemoryManager.malloc8d((int)(((GLMOutput)this._output)._dinfo.fullN() + 1)));
        }
        throw new RuntimeException("no such lambda value, lambda = " + lambda);
    }

    public String[] names() {
        return ((GLMOutput)this._output)._names;
    }

    public double deviance(double w, double y, double f) {
        if (w == 0.0) {
            return 0.0;
        }
        return w * ((GLMParameters)this._parms).deviance(y, f);
    }

    public double likelihood(double w, double y, double f) {
        if (w == 0.0) {
            return 0.0;
        }
        return w * ((GLMParameters)this._parms).likelihood(y, f);
    }

    public GLMModel addSubmodel(int idx, Submodel sm) {
        if (((GLMOutput)this._output)._submodels != null && ((GLMOutput)this._output)._submodels.length > idx) {
            ((GLMOutput)this._output)._submodels[idx] = sm;
        } else {
            assert (((GLMOutput)this._output)._submodels == null || idx == ((GLMOutput)this._output)._submodels.length);
            ((GLMOutput)this._output)._submodels = (Submodel[])water.util.ArrayUtils.append((Object[])((GLMOutput)this._output)._submodels, (Object[])new Submodel[]{sm});
        }
        ((GLMOutput)this._output).setSubmodelIdx(idx, (GLMParameters)this._parms);
        return this;
    }

    public GLMModel updateSubmodel(int idx, Submodel sm) {
        assert (sm.lambda_value == ((GLMOutput)this._output)._submodels[idx].lambda_value && sm.alpha_value == ((GLMOutput)this._output)._submodels[idx].alpha_value);
        ((GLMOutput)this._output)._submodels[idx] = sm;
        return this;
    }

    public void update(double[] beta, double devianceTrain, double devianceTest, int iter) {
        int id = ((GLMOutput)this._output)._submodels.length - 1;
        ((GLMOutput)this._output)._submodels[id] = new Submodel(((GLMOutput)this._output)._submodels[id].lambda_value, ((GLMOutput)this._output)._submodels[id].alpha_value, beta, iter, devianceTrain, devianceTest, ((GLMOutput)this._output)._totalBetaLength, ((GLMOutput)this._output)._submodels[id].zValues, ((GLMOutput)this._output)._submodels[id].dispersionEstimated);
        ((GLMOutput)this._output).setSubmodelIdx(id, (GLMParameters)this._parms);
    }

    public void update(double[] beta, double[] ubeta, double devianceTrain, double devianceTest, int iter) {
        int id = ((GLMOutput)this._output)._submodels.length - 1;
        Submodel sm = new Submodel(((GLMOutput)this._output)._submodels[id].lambda_value, ((GLMOutput)this._output)._submodels[id].alpha_value, beta, iter, devianceTrain, devianceTest, ((GLMOutput)this._output)._totalBetaLength, ((GLMOutput)this._output)._submodels[id].zValues, ((GLMOutput)this._output)._submodels[id].dispersionEstimated);
        sm.ubeta = Arrays.copyOf(ubeta, ubeta.length);
        ((GLMOutput)this._output)._submodels[id] = sm;
        ((GLMOutput)this._output).setSubmodelIdx(id, (GLMParameters)this._parms);
    }

    protected GLMModel deepClone(Key<GLMModel> result) {
        GLMModel newModel = (GLMModel)IcedUtils.deepCopy((Iced)this);
        newModel._key = result;
        ((GLMOutput)newModel._output).clearModelMetrics(false);
        ((GLMOutput)newModel._output)._training_metrics = null;
        ((GLMOutput)newModel._output)._validation_metrics = null;
        return newModel;
    }

    protected String[][] scoringDomains() {
        String[][] domains = ((GLMOutput)this._output)._domains;
        if ((((GLMParameters)this._parms)._family == GLMParameters.Family.binomial || ((GLMParameters)this._parms)._family == GLMParameters.Family.quasibinomial || ((GLMParameters)this._parms)._family == GLMParameters.Family.fractionalbinomial) && ((GLMOutput)this._output)._domains[((GLMOutput)this._output)._dinfo.responseChunkId(0)] == null) {
            domains = (String[][])domains.clone();
            domains[((GLMOutput)this._output)._dinfo.responseChunkId((int)0)] = binomialClassNames;
        }
        return domains;
    }

    public void setZValues(double[] zValues, double dispersion, boolean dispersionEstimated) {
        GLMOutput.access$002((GLMOutput)this._output, zValues);
        ((GLMOutput)this._output)._dispersion = dispersion;
        ((GLMOutput)this._output)._dispersionEstimated = dispersionEstimated;
    }

    public HashMap<String, Double> coefficients() {
        HashMap<String, Double> res = new HashMap<String, Double>();
        double[] b = this.beta();
        if (b == null) {
            return res;
        }
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.multinomial || ((GLMParameters)this._parms)._family == GLMParameters.Family.ordinal) {
            String[] responseDomain = ((GLMOutput)this._output)._domains[((GLMOutput)this._output)._domains.length - 1];
            int len = b.length / ((GLMOutput)this._output).nclasses();
            assert (b.length == len * ((GLMOutput)this._output).nclasses());
            for (int c = 0; c < ((GLMOutput)this._output).nclasses(); ++c) {
                String postfix = "_" + responseDomain[c];
                for (int i = 0; i < len; ++i) {
                    res.put(((GLMOutput)this._output)._coefficient_names[i] + postfix, b[c * len + i]);
                }
            }
        } else {
            for (int i = 0; i < b.length; ++i) {
                res.put(((GLMOutput)this._output)._coefficient_names[i], b[i]);
            }
        }
        return res;
    }

    public HashMap<String, Double> coefficients(boolean standardized) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        double[] b = this.beta();
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.multinomial || ((GLMParameters)this._parms)._family == GLMParameters.Family.ordinal) {
            if (standardized) {
                b = ArrayUtils.flat((double[][])((GLMOutput)this._output).getNormBetaMultinomial());
            }
            if (b == null) {
                return res;
            }
            String[] responseDomain = ((GLMOutput)this._output)._domains[((GLMOutput)this._output)._domains.length - 1];
            int len = b.length / ((GLMOutput)this._output).nclasses();
            assert (b.length == len * ((GLMOutput)this._output).nclasses());
            for (int c = 0; c < ((GLMOutput)this._output).nclasses(); ++c) {
                String postfix = "_" + responseDomain[c];
                for (int i = 0; i < len; ++i) {
                    res.put(((GLMOutput)this._output)._coefficient_names[i] + postfix, b[c * len + i]);
                }
            }
        } else {
            if (standardized) {
                b = ((GLMOutput)this._output).getNormBeta();
            }
            for (int i = 0; i < b.length; ++i) {
                res.put(((GLMOutput)this._output)._coefficient_names[i], b[i]);
            }
        }
        return res;
    }

    public TwoDimTable generateSummary(Key train, int iter) {
        int intercept;
        String[] names = new String[]{"Family", "Link", "Regularization", "Number of Predictors Total", "Number of Active Predictors", "Number of Iterations", "Training Frame"};
        String[] types = new String[]{"string", "string", "string", "int", "int", "int", "string"};
        String[] formats = new String[]{"%s", "%s", "%s", "%d", "%d", "%d", "%s"};
        if (((GLMParameters)this._parms)._lambda_search) {
            names = new String[]{"Family", "Link", "Regularization", "Lambda Search", "Number of Predictors Total", "Number of Active Predictors", "Number of Iterations", "Training Frame"};
            types = new String[]{"string", "string", "string", "string", "int", "int", "int", "string"};
            formats = new String[]{"%s", "%s", "%s", "%s", "%d", "%d", "%d", "%s"};
        }
        ((GLMOutput)this._output)._model_summary = new TwoDimTable("GLM Model", "summary", new String[]{""}, names, types, formats, "");
        ((GLMOutput)this._output)._model_summary.set(0, 0, (Object)((GLMParameters)this._parms)._family.toString());
        ((GLMOutput)this._output)._model_summary.set(0, 1, (Object)((GLMParameters)this._parms)._link.toString());
        String regularization = "None";
        if (((GLMParameters)this._parms)._lambda != null && (((GLMParameters)this._parms)._lambda.length != 1 || ((GLMParameters)this._parms)._lambda[0] != 0.0)) {
            regularization = ((GLMOutput)this._output).bestSubmodel().alpha_value == 0.0 ? "Ridge ( lambda = " : (((GLMOutput)this._output).bestSubmodel().alpha_value == 1.0 ? "Lasso (lambda = " : "Elastic Net (alpha = " + MathUtils.roundToNDigits((double)((GLMOutput)this._output).bestSubmodel().alpha_value, (int)4) + ", lambda = ");
            regularization = regularization + MathUtils.roundToNDigits((double)((GLMOutput)this._output).bestSubmodel().lambda_value, (int)4) + " )";
        }
        ((GLMOutput)this._output)._model_summary.set(0, 2, (Object)regularization);
        int lambdaSearch = 0;
        if (((GLMParameters)this._parms)._lambda_search) {
            lambdaSearch = 1;
            iter = ((GLMOutput)this._output)._submodels[((GLMOutput)this._output)._selected_submodel_idx].iteration;
            ((GLMOutput)this._output)._model_summary.set(0, 3, (Object)("nlambda = " + ((GLMParameters)this._parms)._nlambdas + ", lambda.max = " + MathUtils.roundToNDigits((double)this._lambda_max, (int)4) + ", lambda.min = " + MathUtils.roundToNDigits((double)((GLMOutput)this._output).lambda_best(), (int)4) + ", lambda.1se = " + MathUtils.roundToNDigits((double)((GLMOutput)this._output).lambda_1se(), (int)4)));
        }
        int n = intercept = ((GLMParameters)this._parms)._intercept ? 1 : 0;
        if (((GLMOutput)this._output).nclasses() > 2) {
            ((GLMOutput)this._output)._model_summary.set(0, 3 + lambdaSearch, (Object)(((GLMOutput)this._output).nclasses() * ((GLMOutput)this._output)._coefficient_names.length));
            ((GLMOutput)this._output)._model_summary.set(0, 4 + lambdaSearch, (Object)Integer.toString(((GLMOutput)this._output).rank() - ((GLMOutput)this._output).nclasses() * intercept));
        } else {
            ((GLMOutput)this._output)._model_summary.set(0, 3 + lambdaSearch, (Object)(this.beta().length - 1));
            ((GLMOutput)this._output)._model_summary.set(0, 4 + lambdaSearch, (Object)Integer.toString(((GLMOutput)this._output).rank() - intercept));
        }
        ((GLMOutput)this._output)._model_summary.set(0, 5 + lambdaSearch, (Object)iter);
        ((GLMOutput)this._output)._model_summary.set(0, 6 + lambdaSearch, (Object)train.toString());
        return ((GLMOutput)this._output)._model_summary;
    }

    public TwoDimTable generateSummaryHGLM(Key train, int iter) {
        String[] names = new String[]{"Family", "Link", "Number of Predictors Total", "Number of Active Predictors", "Number of Iterations", "Training Frame"};
        String[] types = new String[]{"string", "string", "int", "int", "int", "string"};
        String[] formats = new String[]{"%s", "%s", "%d", "%d", "%d", "%s"};
        int numRand = ((GLMParameters)this._parms)._rand_family.length;
        String[] rand_family_links = new String[numRand * 2];
        for (int index = 0; index < numRand; ++index) {
            int tindex = index * 2;
            rand_family_links[tindex] = "rand_family_for_column_" + index;
            rand_family_links[tindex + 1] = "rand_link_for_column_" + index;
        }
        int totListLen = ((GLMParameters)this._parms)._rand_family.length * 2 + names.length;
        String[] tnames = new String[totListLen];
        String[] ttypes = new String[totListLen];
        String[] tformats = new String[totListLen];
        System.arraycopy(names, 0, tnames, 0, 2);
        System.arraycopy(types, 0, ttypes, 0, 2);
        System.arraycopy(formats, 0, tformats, 0, 2);
        int numCopy = 2 * numRand;
        for (int index = 0; index < numCopy; ++index) {
            tnames[index + 2] = rand_family_links[index];
            ttypes[index + 2] = "string";
            tformats[index + 2] = "%s";
        }
        int offset = 2 + numCopy;
        int copyLength = names.length - 2;
        System.arraycopy(names, 2, tnames, offset, copyLength);
        System.arraycopy(types, 2, ttypes, offset, copyLength);
        System.arraycopy(formats, 2, tformats, offset, copyLength);
        ((GLMOutput)this._output)._model_summary = new TwoDimTable("HGLM Model", "summary", new String[]{""}, tnames, ttypes, tformats, "");
        int tableColIndex = 0;
        ((GLMOutput)this._output)._model_summary.set(0, tableColIndex++, (Object)((GLMParameters)this._parms)._family.toString());
        ((GLMOutput)this._output)._model_summary.set(0, tableColIndex++, (Object)((GLMParameters)this._parms)._link.toString());
        int numFamily = ((GLMParameters)this._parms)._rand_family.length;
        for (int index = 0; index < numFamily; ++index) {
            ((GLMOutput)this._output)._model_summary.set(0, tableColIndex++, (Object)((GLMParameters)this._parms)._rand_family[index].name());
            if (((GLMParameters)this._parms)._rand_link == null) {
                ((GLMOutput)this._output)._model_summary.set(0, tableColIndex++, (Object)((GLMParameters)this._parms)._rand_family[index].defaultLink.name());
                continue;
            }
            ((GLMOutput)this._output)._model_summary.set(0, tableColIndex++, (Object)((GLMParameters)this._parms)._rand_link[index].name());
        }
        int intercept = ((GLMParameters)this._parms)._intercept ? 1 : 0;
        ((GLMOutput)this._output)._model_summary.set(0, tableColIndex++, (Object)(this.beta().length - 1));
        ((GLMOutput)this._output)._model_summary.set(0, tableColIndex++, (Object)Integer.toString(((GLMOutput)this._output).rank() - intercept));
        ((GLMOutput)this._output)._model_summary.set(0, tableColIndex++, (Object)iter);
        ((GLMOutput)this._output)._model_summary.set(0, tableColIndex, (Object)train.toString());
        return ((GLMOutput)this._output)._model_summary;
    }

    public long checksum_impl() {
        if (((GLMParameters)this._parms)._train == null) {
            return 0L;
        }
        return super.checksum_impl();
    }

    protected double[] score0(double[] data, double[] preds) {
        return this.score0(data, preds, 0.0);
    }

    protected double[] score0(double[] data, double[] preds, double o) {
        if (((GLMParameters)this._parms)._family == GLMParameters.Family.multinomial || ((GLMParameters)this._parms)._family == GLMParameters.Family.ordinal) {
            int c;
            if (o != 0.0) {
                throw H2O.unimpl((String)"Offset is not implemented for multinomial/ordinal.");
            }
            double[] eta = _eta.get();
            Arrays.fill(preds, 0.0);
            if (eta == null || eta.length != ((GLMOutput)this._output).nclasses()) {
                eta = MemoryManager.malloc8d((int)((GLMOutput)this._output).nclasses());
                _eta.set(eta);
            }
            double[][] bm = ((GLMOutput)this._output)._global_beta_multinomial;
            double sumExp = 0.0;
            double maxRow = 0.0;
            int classInd = bm.length;
            int icptInd = bm[0].length - 1;
            if (((GLMParameters)this._parms)._family == GLMParameters.Family.ordinal) {
                --classInd;
            }
            for (c = 0; c < classInd; ++c) {
                double e = bm[c][icptInd];
                double[] b = bm[c];
                for (int i = 0; i < ((GLMOutput)this._output)._dinfo._cats; ++i) {
                    int l = ((GLMOutput)this._output)._dinfo.getCategoricalId(i, data[i]);
                    if (l < 0) continue;
                    e += b[l];
                }
                int coff = ((GLMOutput)this._output)._dinfo._cats;
                int boff = ((GLMOutput)this._output)._dinfo.numStart();
                for (int i = 0; i < ((GLMOutput)this._output)._dinfo._nums; ++i) {
                    double d = data[coff + i];
                    if (!((GLMOutput)this._output)._dinfo._skipMissing && Double.isNaN(d)) {
                        d = ((GLMOutput)this._output)._dinfo._numNAFill[i];
                    }
                    e += d * b[boff + i];
                }
                if (e > maxRow) {
                    maxRow = e;
                }
                eta[c] = e;
            }
            if (((GLMParameters)this._parms)._family == GLMParameters.Family.multinomial) {
                for (c = 0; c < bm.length; ++c) {
                    eta[c] = Math.exp(eta[c] - maxRow);
                    sumExp += eta[c];
                }
                sumExp = 1.0 / sumExp;
                for (c = 0; c < bm.length; ++c) {
                    preds[c + 1] = eta[c] * sumExp;
                }
                preds[0] = water.util.ArrayUtils.maxIndex((double[])eta);
            } else {
                int cInd;
                int nclasses = ((GLMOutput)this._output)._nclasses;
                int lastClass = nclasses - 1;
                Arrays.fill(preds, 1.0E-10);
                preds[0] = lastClass;
                double previousCDF = 0.0;
                for (cInd = 0; cInd < lastClass; ++cInd) {
                    double currEta = eta[cInd];
                    double currCDF = 1.0 / (1.0 + Math.exp(-currEta));
                    preds[cInd + 1] = currCDF - previousCDF;
                    previousCDF = currCDF;
                    if (!(currEta > 0.0)) continue;
                    preds[0] = cInd;
                    break;
                }
                for (cInd = (int)preds[0] + 1; cInd < lastClass; ++cInd) {
                    double currCDF = 1.0 / (1.0 + Math.exp(-eta[cInd]));
                    preds[cInd + 1] = currCDF - previousCDF;
                    previousCDF = currCDF;
                }
                preds[nclasses] = 1.0 - previousCDF;
            }
        } else {
            double[] b = this.beta();
            double eta = b[b.length - 1] + o;
            for (int i = 0; i < ((GLMOutput)this._output)._dinfo._cats && !Double.isNaN(eta); ++i) {
                int l = ((GLMOutput)this._output)._dinfo.getCategoricalId(i, data[i]);
                if (l < 0) continue;
                eta += b[l];
            }
            int numStart = ((GLMOutput)this._output)._dinfo.numStart();
            int ncats = ((GLMOutput)this._output)._dinfo._cats;
            for (int i = 0; i < ((GLMOutput)this._output)._dinfo._nums && !Double.isNaN(eta); ++i) {
                double d = data[ncats + i];
                if (!((GLMOutput)this._output)._dinfo._skipMissing && Double.isNaN(d)) {
                    d = ((GLMOutput)this._output)._dinfo._numNAFill[i];
                }
                eta += b[numStart + i] * d;
            }
            double mu = ((GLMParameters)this._parms).linkInv(eta);
            if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial) {
                preds[0] = mu >= this.defaultThreshold() ? 1.0 : 0.0;
                preds[1] = 1.0 - mu;
                preds[2] = mu;
            } else {
                preds[0] = mu;
            }
        }
        return preds;
    }

    protected boolean needsPostProcess() {
        return false;
    }

    protected void toJavaPredictBody(SBPrintStream body, CodeGeneratorPipeline classCtx, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        classCtx.add((Object)new CodeGenerator(){

            public void generate(JCodeSB out) {
                JCodeGen.toClassWithArray((JCodeSB)out, (String)"public static", (String)"BETA", (double[])GLMModel.this.beta_internal());
                JCodeGen.toClassWithArray((JCodeSB)out, (String)"static", (String)"NUM_MEANS", (double[])((GLMOutput)GLMModel.this._output)._dinfo._numNAFill, (String)"Imputed numeric values");
                JCodeGen.toClassWithArray((JCodeSB)out, (String)"static", (String)"CAT_MODES", (int[])((GLMOutput)GLMModel.this._output)._dinfo.catNAFill(), (String)"Imputed categorical values.");
                JCodeGen.toStaticVar((JCodeSB)out, (String)"CATOFFS", (int[])GLMModel.this.dinfo()._catOffsets, (String)"Categorical Offsets");
            }
        });
        body.ip("final double [] b = BETA.VALUES;").nl();
        if (((GLMParameters)this._parms).imputeMissing()) {
            body.ip("for(int i = 0; i < " + ((GLMOutput)this._output)._dinfo._cats + "; ++i) if(Double.isNaN(data[i])) data[i] = CAT_MODES.VALUES[i];").nl();
            body.ip("for(int i = 0; i < " + ((GLMOutput)this._output)._dinfo._nums + "; ++i) if(Double.isNaN(data[i + " + ((GLMOutput)this._output)._dinfo._cats + "])) data[i+" + ((GLMOutput)this._output)._dinfo._cats + "] = NUM_MEANS.VALUES[i];").nl();
        }
        if (((GLMParameters)this._parms)._family != GLMParameters.Family.multinomial && ((GLMParameters)this._parms)._family != GLMParameters.Family.ordinal) {
            body.ip("double eta = 0.0;").nl();
            if (!((GLMParameters)this._parms)._use_all_factor_levels) {
                body.ip("for(int i = 0; i < CATOFFS.length-1; ++i) if(data[i] != 0) {").nl();
                body.ip("  int ival = (int)data[i] - 1;").nl();
                body.ip("  if(ival != data[i] - 1) throw new IllegalArgumentException(\"categorical value out of range\");").nl();
                body.ip("  ival += CATOFFS[i];").nl();
                body.ip("  if(ival < CATOFFS[i + 1])").nl();
                body.ip("    eta += b[ival];").nl();
            } else {
                body.ip("for(int i = 0; i < CATOFFS.length-1; ++i) {").nl();
                body.ip("  int ival = (int)data[i];").nl();
                body.ip("  if(ival != data[i]) throw new IllegalArgumentException(\"categorical value out of range\");").nl();
                body.ip("  ival += CATOFFS[i];").nl();
                body.ip("  if(ival < CATOFFS[i + 1])").nl();
                body.ip("    eta += b[ival];").nl();
            }
            body.ip("}").nl();
            int noff = this.dinfo().numStart() - this.dinfo()._cats;
            body.ip("for(int i = ").p(this.dinfo()._cats).p("; i < b.length-1-").p(noff).p("; ++i)").nl();
            body.ip("eta += b[").p(noff).p("+i]*data[i];").nl();
            body.ip("eta += b[b.length-1]; // reduce intercept").nl();
            if (((GLMParameters)this._parms)._family != GLMParameters.Family.tweedie) {
                body.ip("double mu = hex.genmodel.GenModel.GLM_").p(((GLMParameters)this._parms)._link.toString()).p("Inv(eta");
            } else {
                body.ip("double mu = hex.genmodel.GenModel.GLM_tweedieInv(eta," + ((GLMParameters)this._parms)._tweedie_link_power);
            }
            body.p(");").nl();
            if (((GLMParameters)this._parms)._family == GLMParameters.Family.binomial || ((GLMParameters)this._parms)._family == GLMParameters.Family.fractionalbinomial) {
                body.ip("preds[0] = (mu >= ").p(this.defaultThreshold()).p(") ? 1 : 0").p("; // threshold given by ROC").nl();
                body.ip("preds[1] = 1.0 - mu; // class 0").nl();
                body.ip("preds[2] =       mu; // class 1").nl();
            } else {
                body.ip("preds[0] = mu;").nl();
            }
        } else {
            int P = ((GLMOutput)this._output)._global_beta_multinomial[0].length;
            body.ip("preds[0] = 0;").nl();
            body.ip("for(int c = 0; c < " + ((GLMOutput)this._output)._nclasses + "; ++c){").nl();
            body.ip("  preds[c+1] = 0;").nl();
            if (this.dinfo()._cats > 0) {
                if (!((GLMParameters)this._parms)._use_all_factor_levels) {
                    body.ip("  for(int i = 0; i < CATOFFS.length-1; ++i) if(data[i] != 0) {").nl();
                    body.ip("    int ival = (int)data[i] - 1;").nl();
                    body.ip("    if(ival != data[i] - 1) throw new IllegalArgumentException(\"categorical value out of range\");").nl();
                    body.ip("    ival += CATOFFS[i];").nl();
                    body.ip("    if(ival < CATOFFS[i + 1])").nl();
                    body.ip("      preds[c+1] += b[ival+c*" + P + "];").nl();
                } else {
                    body.ip("  for(int i = 0; i < CATOFFS.length-1; ++i) {").nl();
                    body.ip("    int ival = (int)data[i];").nl();
                    body.ip("    if(ival != data[i]) throw new IllegalArgumentException(\"categorical value out of range\");").nl();
                    body.ip("    ival += CATOFFS[i];").nl();
                    body.ip("    if(ival < CATOFFS[i + 1])").nl();
                    body.ip("      preds[c+1] += b[ival+c*" + P + "];").nl();
                }
                body.ip("  }").nl();
            }
            int noff = this.dinfo().numStart();
            body.ip("  for(int i = 0; i < " + this.dinfo()._nums + "; ++i)").nl();
            body.ip("    preds[c+1] += b[" + noff + "+i + c*" + P + "]*data[i+" + this.dinfo()._cats + "];").nl();
            body.ip("  preds[c+1] += b[" + (P - 1) + " + c*" + P + "]; // reduce intercept").nl();
            body.ip("}").nl();
            if (((GLMParameters)this._parms)._family == GLMParameters.Family.multinomial) {
                body.ip("double max_row = 0;").nl();
                body.ip("for(int c = 1; c < preds.length; ++c) if(preds[c] > max_row) max_row = preds[c];").nl();
                body.ip("double sum_exp = 0;").nl();
                body.ip("for(int c = 1; c < preds.length; ++c) { sum_exp += (preds[c] = Math.exp(preds[c]-max_row));}").nl();
                body.ip("sum_exp = 1/sum_exp;").nl();
                body.ip("double max_p = 0;").nl();
                body.ip("for(int c = 1; c < preds.length; ++c) if((preds[c] *= sum_exp) > max_p){ max_p = preds[c]; preds[0] = c-1;};").nl();
            } else {
                int lastClass = ((GLMOutput)this._output)._nclasses - 1;
                body.ip("int lastClass = " + lastClass + ";").nl();
                body.ip("preds[0]=0;").nl();
                body.ip("double previousCDF = 0.0;").nl();
                body.ip("for (int cInd = 0; cInd < lastClass; cInd++) { // classify row and calculate PDF of each class").nl();
                body.ip("  double eta = preds[cInd+1];").nl();
                body.ip("  double currCDF = 1.0/(1+Math.exp(-eta));").nl();
                body.ip("  preds[cInd+1] = currCDF-previousCDF;").nl();
                body.ip("  previousCDF = currCDF;").nl();
                body.ip("}").nl();
                body.ip("preds[nclasses()] = 1-previousCDF;").nl();
                body.ip("double max_p = 0;").nl();
                body.ip("for(int c = 1; c < preds.length; ++c) if(preds[c] > max_p){ max_p = preds[c]; preds[0] = c-1;};").nl();
            }
        }
    }

    protected SBPrintStream toJavaInit(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        sb.nl();
        sb.ip("public boolean isSupervised() { return true; }").nl();
        sb.ip("public int nfeatures() { return " + ((GLMOutput)this._output).nfeatures() + "; }").nl();
        sb.ip("public int nclasses() { return " + ((GLMOutput)this._output).nclasses() + "; }").nl();
        return sb;
    }

    private GLMScore makeScoringTask(Frame adaptFrm, boolean generatePredictions, Job j, boolean computeMetrics) {
        boolean detectedComputeMetrics;
        int responseId = adaptFrm.find(((GLMOutput)this._output).responseName());
        if (responseId > -1 && adaptFrm.vec(responseId).isBad()) {
            adaptFrm = new Frame(adaptFrm.names(), adaptFrm.vecs());
            adaptFrm.remove(responseId);
        }
        boolean bl = detectedComputeMetrics = computeMetrics && adaptFrm.vec(((GLMOutput)this._output).responseName()) != null && !adaptFrm.vec(((GLMOutput)this._output).responseName()).isBad();
        String[] domain = ((GLMOutput)this._output).nclasses() <= 1 ? null : (!detectedComputeMetrics ? ((GLMOutput)this._output)._domains[((GLMOutput)this._output)._domains.length - 1] : adaptFrm.lastVec().domain());
        return new GLMScore(j, this, ((GLMOutput)this._output)._dinfo.scoringInfo(((GLMOutput)this._output)._names, adaptFrm), domain, detectedComputeMetrics, generatePredictions);
    }

    protected Model.PredictScoreResult predictScoreImpl(Frame fr, Frame adaptFrm, String destination_key, Job j, boolean computeMetrics, CFuncRef customMetricFunc) {
        String[] names = this.makeScoringNames();
        String[][] domains = new String[names.length][];
        GLMScore gs = this.makeScoringTask(adaptFrm, true, j, computeMetrics);
        assert (gs._dinfo._valid) : "_valid flag should be set on data info when doing scoring";
        gs.doAll(names.length, (byte)3, gs._dinfo._adaptedFrame);
        ModelMetrics.MetricBuilder mb = null;
        Frame rawFrame = null;
        if (gs._computeMetrics) {
            mb = gs._mb;
            rawFrame = gs.outputFrame();
        }
        domains[0] = gs._domain;
        Frame outputFrame = gs.outputFrame(Key.make((String)destination_key), names, domains);
        return new Model.PredictScoreResult((Model)this, mb, rawFrame, outputFrame);
    }

    public String[] makeScoringNames() {
        Object[] res = super.makeScoringNames();
        if (((GLMOutput)this._output)._vcov != null) {
            res = (String[])water.util.ArrayUtils.append((Object[])res, (Object[])new String[]{"StdErr"});
        }
        return res;
    }

    protected ModelMetrics.MetricBuilder scoreMetrics(Frame adaptFrm) {
        GLMScore gs = this.makeScoringTask(adaptFrm, false, null, true);
        assert (gs._dinfo._valid) : "_valid flag should be set on data info when doing scoring";
        return ((GLMScore)gs.doAll((Frame)gs._dinfo._adaptedFrame))._mb;
    }

    public boolean haveMojo() {
        if (!((GLMParameters)this._parms)._HGLM && ((GLMParameters)this._parms).interactionSpec() == null) {
            return super.haveMojo();
        }
        return false;
    }

    public boolean havePojo() {
        if (!((GLMParameters)this._parms)._HGLM && ((GLMParameters)this._parms).interactionSpec() == null && ((GLMParameters)this._parms)._offset_column == null) {
            return super.havePojo();
        }
        return false;
    }

    public GLMMojoWriter getMojo() {
        return new GLMMojoWriter(this);
    }

    private boolean isFeatureUsedInPredict(int featureIdx, double[] beta) {
        if (featureIdx < ((GLMOutput)this._output)._dinfo._catOffsets.length - 1 && ((GLMOutput)this._output)._column_types[featureIdx].equals("Enum")) {
            for (int i = ((GLMOutput)this._output)._dinfo._catOffsets[featureIdx]; i < ((GLMOutput)this._output)._dinfo._catOffsets[featureIdx + 1]; ++i) {
                if (beta[i] == 0.0) continue;
                return true;
            }
            return false;
        }
        return beta[featureIdx += ((GLMOutput)this._output)._dinfo._numOffsets[0] - ((GLMOutput)this._output)._dinfo._catOffsets.length + 1] != 0.0;
    }

    protected boolean isFeatureUsedInPredict(int featureIdx) {
        if (((GLMParameters)this._parms)._interactions != null) {
            return true;
        }
        if (((GLMOutput)this._output).isMultinomialClassifier()) {
            for (double[] classBeta : ((GLMOutput)this._output)._global_beta_multinomial) {
                if (!this.isFeatureUsedInPredict(featureIdx, classBeta)) continue;
                return true;
            }
            return false;
        }
        return this.isFeatureUsedInPredict(featureIdx, ((GLMOutput)this._output)._global_beta);
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        super.remove_impl(fs, cascade);
        Keyed.remove(((GLMOutput)this._output)._regression_influence_diagnostics, (Futures)fs, (boolean)cascade);
        return fs;
    }

    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        if (((GLMOutput)this._output)._regression_influence_diagnostics != null) {
            ab.putKey(((GLMOutput)this._output)._regression_influence_diagnostics);
        }
        return super.writeAll_impl(ab);
    }

    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        if (((GLMOutput)this._output)._regression_influence_diagnostics != null) {
            ab.getKey(((GLMOutput)this._output)._regression_influence_diagnostics, fs);
        }
        return super.readAll_impl(ab, fs);
    }

    static /* synthetic */ String[] access$402(String[] x0) {
        binomialClassNames = x0;
        return x0;
    }

    public static class GLMOutput
    extends Model.Output {
        Submodel[] _submodels = new Submodel[0];
        DataInfo _dinfo;
        double[] _ymu;
        public String[] _coefficient_names;
        String[] _random_coefficient_names;
        String[] _random_column_names;
        public long _training_time_ms;
        public TwoDimTable _variable_importances;
        public VarImp _varimp;
        int _lambda_array_size;
        public double _lambda_1se = -1.0;
        public double _lambda_min = -1.0;
        public double _lambda_max = -1.0;
        public int _selected_lambda_idx;
        public int _selected_alpha_idx;
        public int _selected_submodel_idx;
        public int _best_submodel_idx;
        public int _best_lambda_idx;
        public Key<Frame> _regression_influence_diagnostics;
        public Key<Frame> _betadiff_var;
        final int _totalBetaLength;
        double[] _global_beta;
        double[] _ubeta;
        private double[] _zvalues;
        double[] _variable_inflation_factors;
        String[] _vif_predictor_names;
        double[][] _vcov;
        private double _dispersion;
        private boolean _dispersionEstimated;
        public int[] _activeColsPerClass;
        double[][] _global_beta_multinomial;
        final int _nclasses;
        public boolean _binomial;
        public boolean _multinomial;
        public boolean _ordinal;

        public double lambda_best() {
            return this._submodels.length == 0 ? -1.0 : this._submodels[this._best_submodel_idx].lambda_value;
        }

        public double dispersion() {
            return this._dispersion;
        }

        public boolean dispersionEstimated() {
            return this._dispersionEstimated;
        }

        public double alpha_best() {
            return this._submodels.length == 0 ? -1.0 : this._submodels[this._selected_submodel_idx].alpha_value;
        }

        public double lambda_1se() {
            return this._lambda_1se;
        }

        public DataInfo getDinfo() {
            return this._dinfo;
        }

        public int bestSubmodelIndex() {
            return this._selected_submodel_idx;
        }

        public double lambda_selected() {
            return this._submodels[this._selected_submodel_idx].lambda_value;
        }

        public boolean hasPValues() {
            return this._zvalues != null;
        }

        public boolean hasVIF() {
            return this._vif_predictor_names != null;
        }

        public double[] stdErr() {
            return GLMOutput.calculateStdErrFromZValues(this._zvalues, this._global_beta);
        }

        public static double[] calculateStdErrFromZValues(double[] zValues, double[] beta) {
            double[] res = (double[])zValues.clone();
            for (int i = 0; i < res.length; ++i) {
                res[i] = beta[i] == 0.0 ? Double.NaN : beta[i] / zValues[i];
            }
            return res;
        }

        public double[] getZValues() {
            return this._zvalues;
        }

        public double[] getVariableInflationFactors() {
            return this._variable_inflation_factors;
        }

        public String[] getVIFPredictorNames() {
            return this._vif_predictor_names;
        }

        public Map<String, Double> getVIFAndNames() {
            if (this._variable_inflation_factors != null) {
                return IntStream.range(0, this._vif_predictor_names.length).boxed().collect(Collectors.toMap(s -> this._vif_predictor_names[s], s -> this._variable_inflation_factors[s]));
            }
            return null;
        }

        public TwoDimTable getVariableImportances() {
            return this._variable_importances;
        }

        public ModelCategory getModelCategory() {
            return this._binomial ? ModelCategory.Binomial : (this._multinomial ? ModelCategory.Multinomial : (this._ordinal ? ModelCategory.Ordinal : ModelCategory.Regression));
        }

        protected long checksum_impl() {
            long d = this._global_beta == null ? 1L : (long)Arrays.hashCode(this._global_beta);
            return d * super.checksum_impl();
        }

        public double[] zValues() {
            return (double[])this._zvalues.clone();
        }

        public static double[] calculatePValuesFromZValues(double[] zValues, boolean dispersionEstimated, long residualDegreesOfFreedom) {
            double[] res = (double[])zValues.clone();
            TDistribution rd = dispersionEstimated ? new TDistribution((double)residualDegreesOfFreedom) : new NormalDistribution();
            for (int i = 0; i < res.length; ++i) {
                if (Double.isNaN(zValues[i])) continue;
                res[i] = 2.0 * rd.cumulativeProbability(-Math.abs(res[i]));
            }
            return res;
        }

        public double[] pValues() {
            return GLMOutput.calculatePValuesFromZValues(this._zvalues, this._dispersionEstimated, this._training_metrics.residual_degrees_of_freedom());
        }

        public double[] variableInflationFactors() {
            return this._variable_inflation_factors;
        }

        public void setLambdas(GLMParameters parms) {
            if (parms._lambda_search) {
                this._lambda_max = parms._lambda[0];
                this._lambda_min = parms._lambda[parms._lambda.length - 1];
            }
        }

        public int rank() {
            return this._submodels[this._selected_submodel_idx].rank();
        }

        public double[] ymu() {
            return this._ymu;
        }

        public boolean isStandardized() {
            return this._dinfo._predictor_transform == DataInfo.TransformType.STANDARDIZE;
        }

        public String[] coefficientNames() {
            return this._coefficient_names;
        }

        public String[] multiClassCoeffNames() {
            String[] responseDomain = this._domains[this._domains.length - 1];
            String[] multinomialNames = new String[this._coefficient_names.length * responseDomain.length];
            int coeffLen = this._coefficient_names.length;
            int responseLen = responseDomain.length;
            int counter = 0;
            for (int respInd = 0; respInd < responseLen; ++respInd) {
                for (int coeffInd = 0; coeffInd < coeffLen; ++coeffInd) {
                    multinomialNames[counter++] = this._coefficient_names[coeffInd] + "_" + responseDomain[respInd];
                }
            }
            return multinomialNames;
        }

        public String[] randomcoefficientNames() {
            return this._random_coefficient_names;
        }

        public double[] ubeta() {
            return this._ubeta;
        }

        public boolean isSupervised() {
            return true;
        }

        public Model.InteractionBuilder interactionBuilder() {
            return this._dinfo._interactionSpec != null ? new GLMInteractionBuilder() : null;
        }

        public static Frame expand(Frame fr, Model.InteractionSpec interactions, boolean useAll, boolean standardize, boolean skipMissing) {
            return MakeGLMModelHandler.oneHot(fr, interactions, useAll, standardize, false, skipMissing);
        }

        public GLMOutput(DataInfo dinfo, String[] column_names, String[] column_types, String[][] domains, String[] coefficient_names, double[] beta, boolean binomial, boolean multinomial, boolean ordinal) {
            super(dinfo._weights, dinfo._offset, dinfo._fold);
            this._dinfo = (DataInfo)dinfo.clone();
            this.setNames(column_names, column_types);
            this._domains = domains;
            this._coefficient_names = coefficient_names;
            this._binomial = binomial;
            this._multinomial = multinomial;
            this._ordinal = ordinal;
            this._nclasses = this._binomial ? 2 : (this._multinomial || this._ordinal ? beta.length / coefficient_names.length : 1);
            this._totalBetaLength = beta.length;
            if (this._binomial && domains[domains.length - 1] != null) {
                assert (domains[domains.length - 1].length == 2) : "Unexpected domains " + Arrays.toString((Object[])domains);
                GLMModel.access$402(domains[domains.length - 1]);
            }
            assert (!water.util.ArrayUtils.hasNaNsOrInfs((double[])beta)) : "Coefficients contain NA or Infs.";
            if (this._ordinal || this._multinomial) {
                this._global_beta_multinomial = water.util.ArrayUtils.convertTo2DMatrix((double[])beta, (int)coefficient_names.length);
            } else {
                this._global_beta = beta;
            }
            this._submodels = new Submodel[]{new Submodel(0.0, 0.0, beta, -1, Double.NaN, Double.NaN, this._totalBetaLength, null, false)};
        }

        public GLMOutput() {
            this._isSupervised = true;
            this._nclasses = -1;
            this._totalBetaLength = -1;
        }

        public GLMOutput(GLM glm) {
            super((ModelBuilder)glm);
            int id;
            this._dinfo = (DataInfo)glm._dinfo.clone();
            this._dinfo._adaptedFrame = null;
            String[] cnames = glm._dinfo.coefNames();
            Object[] names = glm._dinfo._adaptedFrame._names;
            String[][] domains = glm._dinfo._adaptedFrame.domains();
            if (((GLMParameters)glm._parms)._family == GLMParameters.Family.quasibinomial) {
                double[] maxs;
                double u;
                double[] mins = glm._dinfo._adaptedFrame.lastVec().mins();
                double l = mins[0];
                if (!(l < (u = (maxs = glm._dinfo._adaptedFrame.lastVec().maxs())[0]))) {
                    throw new IllegalArgumentException("quasibinomial family expects response to have two distinct values");
                }
                for (int i = 0; i < mins.length; ++i) {
                    if ((mins[i] - l) * (mins[i] - u) != 0.0) {
                        throw new IllegalArgumentException("quasibinomial family expects response to have two distinct values, got mins = " + Arrays.toString(mins) + ", maxs = " + Arrays.toString(maxs));
                    }
                    if ((maxs[i] - l) * (maxs[i] - u) == 0.0) continue;
                    throw new IllegalArgumentException("quasibinomial family expects response to have two distinct values, got mins = " + Arrays.toString(mins) + ", maxs = " + Arrays.toString(maxs));
                }
                domains[domains.length - 1] = new String[]{Double.toString(l), Double.toString(u)};
            }
            int n = id = glm._generatedWeights == null ? -1 : water.util.ArrayUtils.find((Object[])names, (Object)glm._generatedWeights);
            if (id >= 0) {
                this._dinfo._weights = false;
                String[] ns = new String[names.length - 1];
                String[][] ds = new String[domains.length - 1][];
                System.arraycopy(names, 0, ns, 0, id);
                System.arraycopy(domains, 0, ds, 0, id);
                System.arraycopy(names, id + 1, ns, id, ns.length - id);
                System.arraycopy(domains, id + 1, ds, id, ds.length - id);
                names = ns;
                domains = ds;
            }
            this.setNames((String[])names, glm._dinfo._adaptedFrame.typesStr());
            this._domains = domains;
            this._coefficient_names = Arrays.copyOf(cnames, cnames.length + 1);
            if (((GLMParameters)glm._parms)._HGLM) {
                this._random_coefficient_names = Arrays.copyOf(glm._randCoeffNames, glm._randCoeffNames.length);
                this._random_column_names = Arrays.copyOf(glm._randomColNames, glm._randomColNames.length);
            }
            this._coefficient_names[this._coefficient_names.length - 1] = "Intercept";
            this._nclasses = glm.nclasses();
            this._totalBetaLength = glm._betaInfo.totalBetaLength();
            this._binomial = ((GLMParameters)glm._parms)._family == GLMParameters.Family.binomial || ((GLMParameters)glm._parms)._family == GLMParameters.Family.quasibinomial || GLMParameters.Family.fractionalbinomial == ((GLMParameters)glm._parms)._family;
            this._multinomial = ((GLMParameters)glm._parms)._family == GLMParameters.Family.multinomial;
            this._ordinal = ((GLMParameters)glm._parms)._family == GLMParameters.Family.ordinal;
        }

        public double[][] vcov() {
            return this._vcov;
        }

        public int nclasses() {
            return this._nclasses;
        }

        public String[] classNames() {
            String[] res = super.classNames();
            if (res == null && this._binomial) {
                return binomialClassNames;
            }
            return res;
        }

        public Submodel pickBestModel(GLMParameters parms) {
            int bestId = 0;
            Submodel best = this._submodels[0];
            for (int i = 1; i < this._submodels.length; ++i) {
                Submodel sm = this._submodels[i];
                if (sm.devianceValid > best.devianceValid || !(sm.devianceTrain < best.devianceTrain)) continue;
                bestId = i;
                best = sm;
            }
            this._best_submodel_idx = bestId;
            this.setSubmodelIdx(this._best_submodel_idx, parms);
            return best;
        }

        public double[] getNormBeta() {
            if (this.isStandardized()) {
                return this._submodels[this._selected_submodel_idx].getBeta(MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1)));
            }
            return this._dinfo.normalizeBeta(this._submodels[this._selected_submodel_idx].getBeta(MemoryManager.malloc8d((int)(this._dinfo.fullN() + 1))), this.isStandardized());
        }

        public double[][] getNormBetaMultinomial() {
            return this.getNormBetaMultinomial(this._selected_submodel_idx, this.isStandardized());
        }

        public double[][] getNormBetaMultinomial(int idx) {
            if (this._submodels == null || this._submodels.length == 0) {
                return null;
            }
            double[][] res = new double[this.nclasses()][];
            Submodel sm = this._submodels[idx];
            int N = this._dinfo.fullN() + 1;
            double[] beta = sm.beta;
            if (sm.idxs != null) {
                beta = water.util.ArrayUtils.expandAndScatter((double[])beta, (int)(this.nclasses() * (this._dinfo.fullN() + 1)), (int[])sm.idxs);
            } else if (beta.length < this._totalBetaLength && sm.idxs == null) {
                beta = ComputationState.expandToFullArray(beta, this._activeColsPerClass, this._totalBetaLength, this.nclasses(), this._totalBetaLength / this.nclasses());
            }
            for (int i = 0; i < res.length; ++i) {
                res[i] = Arrays.copyOfRange(beta, i * N, (i + 1) * N);
            }
            return res;
        }

        public double[][] getNormBetaMultinomial(int idx, boolean standardized) {
            if (this._submodels == null || this._submodels.length == 0) {
                return null;
            }
            double[][] res = new double[this.nclasses()][];
            Submodel sm = this._submodels[idx];
            int N = this._dinfo.fullN() + 1;
            double[] beta = sm.beta;
            if (sm.idxs != null) {
                beta = water.util.ArrayUtils.expandAndScatter((double[])beta, (int)(this.nclasses() * (this._dinfo.fullN() + 1)), (int[])sm.idxs);
            } else if (beta.length < this._totalBetaLength) {
                beta = ComputationState.expandToFullArray(beta, this._activeColsPerClass, this._totalBetaLength, this.nclasses(), this._totalBetaLength / this.nclasses());
            }
            for (int i = 0; i < res.length; ++i) {
                res[i] = standardized ? Arrays.copyOfRange(beta, i * N, (i + 1) * N) : this._dinfo.normalizeBeta(Arrays.copyOfRange(beta, i * N, (i + 1) * N), standardized);
            }
            return res;
        }

        public double[][] get_global_beta_multinomial() {
            return this._global_beta_multinomial;
        }

        private int indexOf(double needle, double[] haystack) {
            for (int i = 0; i < haystack.length; ++i) {
                if (needle != haystack[i]) continue;
                return i;
            }
            return -1;
        }

        public void setSubmodelIdx(int l, GLMParameters parms) {
            this._selected_submodel_idx = l;
            this._best_lambda_idx = l;
            this._selected_alpha_idx = this.indexOf(this._submodels[l].alpha_value, parms._alpha);
            this._selected_lambda_idx = this.indexOf(this._submodels[l].lambda_value, parms._lambda);
            if (this._random_coefficient_names != null) {
                this._ubeta = Arrays.copyOf(this._submodels[l].ubeta, this._submodels[l].ubeta.length);
            }
            if (this._multinomial || this._ordinal) {
                this._global_beta_multinomial = this.getNormBetaMultinomial(l);
                for (int i = 0; i < this._global_beta_multinomial.length; ++i) {
                    this._global_beta_multinomial[i] = this._dinfo.denormalizeBeta(this._global_beta_multinomial[i]);
                }
            } else {
                if (this._global_beta == null) {
                    this._global_beta = MemoryManager.malloc8d((int)this._coefficient_names.length);
                } else {
                    Arrays.fill(this._global_beta, 0.0);
                }
                this._submodels[l].getBeta(this._global_beta);
                this._global_beta = this._dinfo.denormalizeBeta(this._global_beta);
            }
        }

        public double[] beta() {
            return this._global_beta;
        }

        public Submodel bestSubmodel() {
            return this._submodels[this._selected_submodel_idx];
        }

        public Submodel getSubmodel(double lambdaCVEstimate) {
            for (int i = 0; i < this._submodels.length; ++i) {
                if (this._submodels[i] == null || this._submodels[i].lambda_value != lambdaCVEstimate) continue;
                return this._submodels[i];
            }
            return null;
        }

        public Submodel getSubmodel(int submodel_index) {
            assert (submodel_index < this._submodels.length) : "submodel_index specified exceeds the submodels length.";
            return this._submodels[submodel_index];
        }

        public VarImp calculateVarimp() {
            String[] names = this.coefficientNames();
            double[] magnitudes = new double[names.length];
            int len = magnitudes.length - 1;
            if (len == 0) {
                return null;
            }
            int[] indices = new int[len];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
            float[] magnitudesSort = new float[len];
            String[] namesSort = new String[len];
            if (this._nclasses > 2) {
                GLMModelV3.GLMModelOutputV3.calculateVarimpMultinomial(magnitudes, indices, this.getNormBetaMultinomial());
            } else {
                GLMModelV3.calculateVarimpBase(magnitudes, indices, this.getNormBeta());
            }
            for (int index = 0; index < len; ++index) {
                magnitudesSort[index] = (float)magnitudes[indices[index]];
                namesSort[index] = names[indices[index]];
            }
            return new VarImp(magnitudesSort, namesSort);
        }

        static /* synthetic */ double[] access$002(GLMOutput x0, double[] x1) {
            x0._zvalues = x1;
            return x1;
        }

        private class GLMInteractionBuilder
        implements Model.InteractionBuilder {
            private GLMInteractionBuilder() {
            }

            public Frame makeInteractions(Frame f) {
                Model.InteractionPair[] interactionPairs = GLMOutput.this._dinfo._interactionSpec.makeInteractionPairs(f);
                f.add(Model.makeInteractions((Frame)f, (boolean)false, (Model.InteractionPair[])interactionPairs, (boolean)true, (boolean)true, (boolean)false));
                return f;
            }
        }
    }

    public static class Submodel
    extends Iced {
        public final double lambda_value;
        public final double alpha_value;
        public final int iteration;
        public final double devianceTrain;
        public final double devianceValid;
        public final int[] idxs;
        public final double[] beta;
        public double[] ubeta;
        public double _trainTheta;
        public double[] zValues;
        public boolean dispersionEstimated;

        public double[] getBeta(double[] beta) {
            if (this.idxs != null) {
                for (int i = 0; i < this.idxs.length; ++i) {
                    beta[this.idxs[i]] = this.beta[i];
                }
            } else {
                System.arraycopy(this.beta, 0, beta, 0, beta.length);
            }
            return beta;
        }

        public double[] getZValues(double[] zValues) {
            Arrays.fill(zValues, Double.NaN);
            if (this.idxs != null) {
                for (int i = 0; i < this.idxs.length; ++i) {
                    zValues[this.idxs[i]] = this.zValues[i];
                }
            } else {
                System.arraycopy(this.zValues, 0, zValues, 0, zValues.length);
            }
            return zValues;
        }

        public int rank() {
            return this.idxs != null ? this.idxs.length : water.util.ArrayUtils.countNonzeros((double[])this.beta);
        }

        public double[] zValues() {
            return (double[])this.zValues.clone();
        }

        public double[] pValues(long residualDegreesOfFreedom) {
            return GLMOutput.calculatePValuesFromZValues(this.zValues, this.dispersionEstimated, residualDegreesOfFreedom);
        }

        public double[] pValues(double[] zValues, long residualDegreesOfFreedom) {
            return GLMOutput.calculatePValuesFromZValues(zValues, this.dispersionEstimated, residualDegreesOfFreedom);
        }

        public double[] stdErr() {
            return GLMOutput.calculateStdErrFromZValues(this.zValues, this.beta);
        }

        public double[] stdErr(double[] zValues, double[] beta) {
            return GLMOutput.calculateStdErrFromZValues(zValues, beta);
        }

        public Submodel(double lambda, double alpha, double[] beta, int iteration, double devTrain, double devValid, int totBetaLen, double[] zValues, boolean dispersionEstimated) {
            this.lambda_value = lambda;
            this.alpha_value = alpha;
            this.iteration = iteration;
            this.devianceTrain = devTrain;
            this.devianceValid = devValid;
            this.zValues = zValues == null ? null : (double[])zValues.clone();
            this.dispersionEstimated = dispersionEstimated;
            int r = 0;
            if (beta != null) {
                for (int i = 0; i < beta.length; ++i) {
                    if (beta[i] == 0.0) continue;
                    ++r;
                }
                if (r < beta.length && beta.length == totBetaLen) {
                    this.idxs = MemoryManager.malloc4((int)r);
                    int j = 0;
                    for (int i = 0; i < beta.length; ++i) {
                        if (beta[i] == 0.0) continue;
                        this.idxs[j++] = i;
                    }
                    this.beta = water.util.ArrayUtils.select((double[])beta, (int[])this.idxs);
                    if (zValues != null && zValues.length > this.beta.length) {
                        this.zValues = water.util.ArrayUtils.select((double[])zValues, (int[])this.idxs);
                    }
                } else {
                    this.beta = (double[])beta.clone();
                    this.idxs = null;
                }
            } else {
                this.beta = null;
                this.idxs = null;
            }
        }
    }

    public static class GLMWeightsFun
    extends Iced {
        public final GLMParameters.Family _family;
        final GLMParameters.Link _link;
        final double _var_power;
        final double _link_power;
        final double _oneOoneMinusVarPower;
        final double _oneOtwoMinusVarPower;
        final double _oneMinusVarPower;
        final double _twoMinusVarPower;
        final double _oneOLinkPower;
        final double _oneOLinkPowerSquare;
        double _theta;
        double _invTheta;
        double _oneOeta;
        double _oneOetaSquare;
        final NormalDistribution _dprobit = new NormalDistribution(0.0, 1.0);

        public GLMWeightsFun(GLMParameters parms) {
            this(parms._family, parms._link, parms._tweedie_variance_power, parms._tweedie_link_power, parms._theta);
        }

        public GLMWeightsFun(GLMParameters.Family fam, GLMParameters.Link link, double var_power, double link_power, double theta) {
            this._family = fam;
            this._link = link;
            this._var_power = var_power;
            this._link_power = link_power;
            this._oneMinusVarPower = 1.0 - this._var_power;
            this._twoMinusVarPower = 2.0 - this._var_power;
            this._oneOoneMinusVarPower = this._var_power == 1.0 ? 1.0 : 1.0 / (1.0 - this._var_power);
            this._oneOtwoMinusVarPower = this._var_power == 2.0 ? 1.0 : 1.0 / (2.0 - this._var_power);
            this._oneOLinkPower = 1.0 / this._link_power;
            this._oneOLinkPowerSquare = this._oneOLinkPower * this._oneOLinkPower;
            this._theta = theta;
            this._invTheta = 1.0 / theta;
        }

        public final double link(double x) {
            switch (this._link) {
                case identity: {
                    return x;
                }
                case ologit: 
                case logit: {
                    assert (0.0 <= x && x <= 1.0) : "x out of bounds, expected <0,1> range, got " + x;
                    return Math.log(x / (1.0 - x));
                }
                case ologlog: {
                    return Math.log(-1.0 * Math.log(1.0 - x));
                }
                case oprobit: {
                    return this._dprobit.inverseCumulativeProbability(x);
                }
                case log: 
                case multinomial: {
                    return Math.log(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
                case tweedie: {
                    return this._link_power == 0.0 ? Math.log(x) : Math.pow(x, this._link_power);
                }
            }
            throw new RuntimeException("unknown link function " + (Object)((Object)this));
        }

        public final double linkInvDeriv(double x) {
            switch (this._link) {
                case identity: {
                    return 1.0;
                }
                case logit: {
                    double g = Math.exp(-x);
                    double gg = (g + 1.0) * (g + 1.0);
                    return g / gg;
                }
                case ologit: {
                    return x - x * x;
                }
                case log: {
                    return Math.max(x, Double.MIN_NORMAL);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return -1.0 / (xx * xx);
                }
                case tweedie: {
                    return this._link_power == 0.0 ? Math.max(x, Double.MIN_NORMAL) : x * this._oneOLinkPower * this._oneOeta;
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this));
        }

        public final double linkInvDeriv2(double x) {
            switch (this._link) {
                case identity: {
                    return 0.0;
                }
                case log: {
                    return Math.max(x, Double.MIN_NORMAL);
                }
                case tweedie: {
                    return this._link_power == 0.0 ? Math.max(x, Double.MIN_NORMAL) : x * this._oneOLinkPower * (this._oneOLinkPower - 1.0) * this._oneOetaSquare;
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this));
        }

        public final double linkDeriv(double x) {
            switch (this._link) {
                case ologit: 
                case logit: {
                    double div = x * (1.0 - x);
                    if (div < 1.0E-6) {
                        return 1000000.0;
                    }
                    return 1.0 / div;
                }
                case ologlog: {
                    double oneMx = 1.0 - x;
                    double divsor = -1.0 * oneMx * Math.log(oneMx);
                    return divsor < 1.0E-6 ? 1000000.0 : 1.0 / divsor;
                }
                case identity: {
                    return 1.0;
                }
                case log: {
                    return 1.0 / x;
                }
                case inverse: {
                    return -1.0 / (x * x);
                }
                case tweedie: {
                    return this._link_power == 0.0 ? 1.0 / Math.max(2.0E-16, x) : this._link_power * Math.pow(x, this._link_power - 1.0);
                }
            }
            throw H2O.unimpl();
        }

        public final double linkInv(double x) {
            switch (this._link) {
                case ologlog: {
                    return 1.0 - Math.exp(-1.0 * Math.exp(x));
                }
                case oprobit: {
                    return this._dprobit.cumulativeProbability(x);
                }
                case identity: {
                    return x;
                }
                case ologit: 
                case logit: {
                    return 1.0 / (Math.exp(-x) + 1.0);
                }
                case log: {
                    return Math.exp(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
                case tweedie: {
                    return this._link_power == 0.0 ? Math.max(2.0E-16, Math.exp(x)) : Math.pow(x, this._oneOLinkPower);
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this._link));
        }

        public final double variance(double mu) {
            switch (this._family) {
                case gaussian: {
                    return 1.0;
                }
                case quasibinomial: 
                case binomial: 
                case fractionalbinomial: {
                    double res = mu * (1.0 - mu);
                    return res < 1.0E-6 ? 1.0E-6 : res;
                }
                case poisson: {
                    return mu;
                }
                case negativebinomial: {
                    return mu + mu * mu * this._theta;
                }
                case gamma: {
                    return mu * mu;
                }
                case tweedie: {
                    return Math.pow(mu, this._var_power);
                }
            }
            throw new RuntimeException("unknown family Id " + (Object)((Object)this._family));
        }

        public final double deviance(double yr, double ym) {
            double y1 = yr == 0.0 ? 0.1 : yr;
            switch (this._family) {
                case gaussian: {
                    return (yr - ym) * (yr - ym);
                }
                case quasibinomial: {
                    if (yr == ym) {
                        return 0.0;
                    }
                    if (ym > 1.0) {
                        return -2.0 * (yr * Math.log(ym));
                    }
                    double res = -2.0 * (yr * Math.log(ym) + (1.0 - yr) * Math.log(1.0 - ym));
                    return res;
                }
                case binomial: 
                case fractionalbinomial: {
                    return 2.0 * (MathUtils.y_log_y((double)yr, (double)ym) + MathUtils.y_log_y((double)(1.0 - yr), (double)(1.0 - ym)));
                }
                case poisson: {
                    if (yr == 0.0) {
                        return 2.0 * ym;
                    }
                    return 2.0 * (yr * Math.log(yr / ym) - (yr - ym));
                }
                case negativebinomial: {
                    return yr == 0.0 || ym <= 0.0 ? 0.0 : 2.0 * ((this._invTheta + yr) * Math.log((1.0 + this._theta * ym) / (1.0 + this._theta * yr)) + yr * Math.log(yr / ym));
                }
                case gamma: {
                    if (yr == 0.0) {
                        return -2.0;
                    }
                    return -2.0 * (Math.log(yr / ym) - (yr - ym) / ym);
                }
                case tweedie: {
                    double val = this._var_power == 1.0 ? yr * Math.log(y1 / ym) - (yr - ym) : (this._var_power == 2.0 ? yr * (1.0 / ym - 1.0 / y1) - Math.log(y1 / ym) : (yr == 0.0 ? 0.0 : yr * this._oneOoneMinusVarPower * (Math.pow(yr, this._oneMinusVarPower) - Math.pow(ym, this._oneMinusVarPower))) - (Math.pow(yr, this._twoMinusVarPower) - Math.pow(ym, this._twoMinusVarPower)) * this._oneOtwoMinusVarPower);
                    return 2.0 * val;
                }
            }
            throw new RuntimeException("unknown family " + (Object)((Object)this._family));
        }

        public final double deviance(float yr, float ym) {
            return this.deviance((double)yr, (double)ym);
        }

        public final void likelihoodAndDeviance(double yr, GLMWeights x, double w) {
            double ym = x.mu;
            switch (this._family) {
                case gaussian: {
                    x.dev = w * (yr - ym) * (yr - ym);
                    x.l = 0.5 * x.dev;
                    break;
                }
                case quasibinomial: {
                    x.l = yr == ym ? 0.0 : (ym > 1.0 ? -(yr * Math.log(ym)) : -(yr * Math.log(ym) + (1.0 - yr) * Math.log(1.0 - ym)));
                    x.dev = 2.0 * x.l;
                    break;
                }
                case binomial: 
                case fractionalbinomial: {
                    x.l = ym == yr ? 0.0 : w * (MathUtils.y_log_y((double)yr, (double)ym) + MathUtils.y_log_y((double)(1.0 - yr), (double)(1.0 - ym)));
                    x.dev = 2.0 * x.l;
                    break;
                }
                case poisson: 
                case gamma: 
                case tweedie: {
                    x.dev = w * this.deviance(yr, ym);
                    x.l = this.likelihood(w, yr, ym);
                    break;
                }
                case negativebinomial: {
                    x.dev = w * this.deviance(yr, ym);
                    x.l = w * this.likelihood(yr, ym);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown family " + (Object)((Object)this._family));
                }
            }
        }

        public final double likelihood(double w, double yr, double ym) {
            if (w == 0.0) {
                return 0.0;
            }
            return w * this.likelihood(yr, ym);
        }

        public final double likelihood(double yr, double ym) {
            switch (this._family) {
                case gaussian: {
                    return 0.5 * (yr - ym) * (yr - ym);
                }
                case quasibinomial: 
                case binomial: 
                case fractionalbinomial: {
                    if (yr == ym) {
                        return 0.0;
                    }
                    return 0.5 * this.deviance(yr, ym);
                }
                case poisson: {
                    if (yr == 0.0) {
                        return 2.0 * ym;
                    }
                    return 2.0 * (yr * Math.log(yr / ym) - (yr - ym));
                }
                case negativebinomial: {
                    return yr > 0.0 && ym > 0.0 ? -GLMTask.sumOper(yr, this._invTheta, 0) + this._invTheta * Math.log(1.0 + this._theta * ym) - yr * Math.log(ym) - yr * Math.log(this._theta) + yr * Math.log(1.0 + this._theta * ym) : (yr == 0.0 && ym > 0.0 ? this._invTheta * Math.log(1.0 + this._theta * ym) : 0.0);
                }
                case gamma: {
                    if (yr == 0.0) {
                        return -2.0;
                    }
                    return -2.0 * (Math.log(yr / ym) - (yr - ym) / ym);
                }
                case tweedie: {
                    double temp = 0.0;
                    temp = this._var_power == 1.0 ? Math.pow(ym, this._twoMinusVarPower) * this._oneOtwoMinusVarPower - yr * Math.log(ym) : (this._var_power == 2.0 ? Math.log(ym) - yr * Math.pow(ym, this._oneMinusVarPower) * this._oneOoneMinusVarPower : Math.pow(ym, this._twoMinusVarPower) * this._oneOtwoMinusVarPower - yr * Math.pow(ym, this._oneMinusVarPower) * this._oneOoneMinusVarPower);
                    return temp;
                }
            }
            throw new RuntimeException("unknown family " + (Object)((Object)this._family));
        }

        public GLMWeights computeWeights(double y, double eta, double off, double w, GLMWeights x) {
            double etaOff = eta + off;
            x.mu = this.linkInv(etaOff);
            double var = this.variance(x.mu);
            double d = this.linkDeriv(x.mu);
            if (this._family.equals((Object)GLMParameters.Family.negativebinomial)) {
                double invSum = 1.0 / (1.0 + this._theta * x.mu);
                double d2 = this.linkInvDeriv(x.mu);
                if (y > 0.0 && x.mu > 0.0) {
                    double sumr = 1.0 + this._theta * y;
                    d = (y / (x.mu * x.mu) - this._theta * sumr * invSum * invSum) * d2 * d2 + (sumr * invSum - y / x.mu) * this.linkInvDeriv2(x.mu);
                    x.w = w * d;
                    x.z = eta + (y - x.mu) * invSum * d2 / (d * x.mu);
                } else if (y == 0.0 && x.mu > 0.0) {
                    d = this.linkInvDeriv2(x.mu) * invSum - this._theta * invSum * invSum * d2 * d2;
                    x.w = w * d;
                    x.z = eta - invSum * d2 / d;
                } else {
                    x.w = 0.0;
                    x.z = 0.0;
                }
            } else if (this._family.equals((Object)GLMParameters.Family.tweedie)) {
                double oneOxmu = x.mu == 0.0 ? 1000000.0 : 1.0 / x.mu;
                double oneOxmuSquare = oneOxmu * oneOxmu;
                this._oneOeta = etaOff == 0.0 ? 1000000.0 : 1.0 / etaOff;
                this._oneOetaSquare = this._oneOeta * this._oneOeta;
                double diffOneSquare = this.linkInvDeriv(x.mu) * this.linkInvDeriv(x.mu);
                double xmuPowMP = Math.pow(x.mu, -this._var_power);
                if (this._var_power == 1.0) {
                    x.w = y * oneOxmuSquare * diffOneSquare - (y * oneOxmu - 1.0) * this.linkInvDeriv2(x.mu);
                    x.z = (x.w * eta + (y * oneOxmu - 1.0) * this.linkInvDeriv(x.mu)) * w;
                } else if (this._var_power == 2.0) {
                    x.w = (oneOxmu - y * xmuPowMP) * this.linkInvDeriv2(x.mu) + (y * 2.0 * Math.pow(x.mu, -3.0) - oneOxmuSquare) * diffOneSquare;
                    x.z = (x.w * eta + (y * oneOxmuSquare - oneOxmu) * this.linkInvDeriv(x.mu)) * w;
                } else {
                    x.w = (this._var_power * y * Math.pow(x.mu, -this._var_power - 1.0) + this._oneMinusVarPower * xmuPowMP) * diffOneSquare - (y * xmuPowMP - Math.pow(x.mu, this._oneMinusVarPower)) * this.linkInvDeriv2(x.mu);
                    x.z = (x.w * eta + (y * Math.pow(x.mu, -this._var_power) - Math.pow(x.mu, this._oneMinusVarPower)) * this.linkInvDeriv(x.mu)) * w;
                }
                x.w *= w;
            } else {
                x.w = w / (var * d * d);
                x.z = eta + (y - x.mu) * d;
            }
            this.likelihoodAndDeviance(y, x, w);
            return x;
        }
    }

    public static class GLMWeights {
        public double mu = 0.0;
        public double w = 1.0;
        public double z = 0.0;
        public double l = 0.0;
        public double dev = Double.NaN;
    }

    public static class GLMParameters
    extends Model.Parameters {
        static final String[] CHECKPOINT_NON_MODIFIABLE_FIELDS = new String[]{"_response_column", "_family", "_solver"};
        public boolean _standardize = true;
        public boolean _useDispersion1 = false;
        public Family _family;
        public Family[] _rand_family;
        public Link _link;
        public Link[] _rand_link;
        public Solver _solver = Solver.AUTO;
        public double _tweedie_variance_power;
        public double _tweedie_link_power;
        public double _theta;
        public double _invTheta;
        public double[] _alpha;
        public double[] _lambda;
        public double[] _startval;
        public boolean _calc_like;
        public int[] _random_columns;
        public int _score_iteration_interval = -1;
        public Serializable _missing_values_handling = MissingValuesHandling.MeanImputation;
        public double _prior = -1.0;
        public boolean _lambda_search = false;
        public boolean _HGLM = false;
        public boolean _cold_start = false;
        public int _nlambdas = -1;
        public boolean _non_negative = false;
        public double _lambda_min_ratio = -1.0;
        public boolean _use_all_factor_levels = false;
        public int _max_iterations = -1;
        public boolean _intercept = true;
        public double _beta_epsilon = 1.0E-4;
        public double _dispersion_epsilon = 1.0E-4;
        public int _max_iterations_dispersion = 3000;
        public double _objective_epsilon = -1.0;
        public double _gradient_epsilon = -1.0;
        public double _obj_reg = -1.0;
        public boolean _compute_p_values = false;
        public boolean _remove_collinear_columns = false;
        public String[] _interactions = null;
        public StringPair[] _interaction_pairs = null;
        public boolean _early_stopping = true;
        public Key<Frame> _beta_constraints = null;
        public Key<Frame> _plug_values = null;
        public int _max_active_predictors = -1;
        public boolean _stdOverride;
        static final NormalDistribution _dprobit = new NormalDistribution(0.0, 1.0);
        public GLMType _glmType = GLMType.glm;
        public boolean _generate_scoring_history = false;
        public DispersionMethod _dispersion_parameter_method = DispersionMethod.pearson;
        public double _init_dispersion_parameter = 1.0;
        public boolean _fix_dispersion_parameter = false;
        public boolean _build_null_model = false;
        public boolean _generate_variable_inflation_factors = false;
        public double _tweedie_epsilon = 8.0E-17;
        public boolean _fix_tweedie_variance_power = true;
        public int _max_series_index = 5000;
        public boolean _debugTDispersionOnly = false;
        public double _dispersion_learning_rate = 0.5;
        public Influence _influence;
        public boolean _keepBetaDiffVar = false;

        public String algoName() {
            return "GLM";
        }

        public String fullName() {
            return "Generalized Linear Modeling";
        }

        public String javaName() {
            return GLMModel.class.getName();
        }

        public long progressUnits() {
            return 1000000L;
        }

        public void validate(GLM glm) {
            if (this._remove_collinear_columns) {
                if (!Solver.IRLSM.equals((Object)this._solver) && !Solver.AUTO.equals((Object)this._solver)) {
                    glm.warn("remove_collinear_columns", "remove_collinear_columns only works when IRLSM (or AUTO which will default to IRLSM when remove_collinear_columns=true) is chosen as the solver.  Otherwise, remove_collinear_columns is not enabled.");
                }
                if (this._lambda_search) {
                    glm.warn("remove_collinear_columns", "remove_collinear_columns should only be used with no regularization, i.e. lambda=0.0.  It is used improperly here with lambda_search.  Please disable lambda_search and set lambda=0.");
                } else if (this._lambda != null) {
                    boolean nonZeroLambda;
                    boolean bl = nonZeroLambda = Arrays.stream(this._lambda).sum() > 0.0;
                    if (nonZeroLambda) {
                        glm.warn("remove_collinear_columns", "remove_collinear_columns should only be used with no regularization, i.e. lambda=0.0.  It is used improperly here.  Please set lambda=0.");
                    }
                }
            }
            if (this._solver.equals((Object)Solver.COORDINATE_DESCENT_NAIVE) && this._family.equals((Object)Family.multinomial)) {
                throw H2O.unimpl((String)"Naive coordinate descent is not supported for multinomial.");
            }
            if (this._lambda != null && this._lambda_search) {
                glm.warn("lambda_search", "disabled when user specified any lambda value(s).");
            }
            if (this._alpha != null && (1.0 < this._alpha[0] || this._alpha[0] < 0.0)) {
                glm.error("_alpha", "alpha parameter must from (inclusive) [0,1] range");
            }
            if (this._compute_p_values && this._solver != Solver.AUTO && this._solver != Solver.IRLSM) {
                glm.error("_compute_p_values", "P values can only be computed with IRLSM solver, go solver = " + (Object)((Object)this._solver));
            }
            if (this._compute_p_values && (this._family == Family.multinomial || this._family == Family.ordinal)) {
                glm.error("_compute_p_values", "P values are currently not supported for family=multinomial or ordinal");
            }
            if (this._compute_p_values && this._non_negative) {
                glm.error("_compute_p_values", "P values are currently not supported for family=multinomial or ordinal");
            }
            if (this._weights_column != null && this._offset_column != null && this._weights_column.equals(this._offset_column)) {
                glm.error("_offset_column", "Offset must be different from weights");
            }
            if (this._alpha != null && (this._alpha[0] < 0.0 || this._alpha[0] > 1.0)) {
                glm.error("_alpha", "Alpha value must be between 0 and 1");
            }
            if (this._lambda != null && this._lambda[0] < 0.0) {
                glm.error("_lambda", "Lambda value must be >= 0");
            }
            if (this._obj_reg != -1.0 && this._obj_reg <= 0.0) {
                glm.error("obj_reg", "Must be positive or -1 for default");
            }
            if (this._prior != -1.0 && this._prior <= 0.0 || this._prior >= 1.0) {
                glm.error("_prior", "Prior must be in (exclusive) range (0,1)");
            }
            if (this._prior != -1.0 && this._family != Family.binomial) {
                glm.error("_prior", "Prior is only allowed with family = binomial.");
            }
            if (this._family != Family.tweedie) {
                glm.hide("_tweedie_variance_power", "Only applicable with Tweedie family");
                glm.hide("_tweedie_link_power", "Only applicable with Tweedie family");
            }
            if (this._family != Family.negativebinomial) {
                glm.hide("_theta", "Only applicable with Negative Binomial family");
            }
            if (this._remove_collinear_columns && !this._intercept) {
                glm.error("_intercept", "Remove colinear columns option is currently not supported without intercept");
            }
            if (this._beta_constraints != null) {
                Vec v;
                Frame f;
                if (this._family == Family.multinomial || this._family == Family.ordinal) {
                    glm.error("beta_constraints", "beta constraints are not supported for family = multionomial or ordinal");
                }
                if ((f = (Frame)this._beta_constraints.get()) == null) {
                    glm.error("beta_constraints", "Missing frame for beta constraints");
                }
                if ((v = f.vec("names")) == null) {
                    glm.error("beta_constraints", "Beta constraints parameter must have names column with valid coefficient names");
                }
                if ((v = f.vec("upper_bounds")) != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "upper_bounds must be numeric if present");
                }
                v = f.vec("upper_bounds");
                v = f.vec("lower_bounds");
                if (v != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "lower_bounds must be numeric if present");
                }
                if ((v = f.vec("beta_given")) != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "beta_given must be numeric if present");
                }
                v = f.vec("upper_bounds");
                v = f.vec("beta_start");
                if (v != null && !v.isNumeric()) {
                    glm.error("beta_constraints", "beta_start must be numeric if present");
                }
            }
            if (!this._lambda_search) {
                glm.hide("_lambda_min_ratio", "only applies if lambda search is on.");
                glm.hide("_nlambdas", "only applies if lambda search is on.");
                glm.hide("_early_stopping", "only applies if lambda search is on.");
            }
            if (this._family == Family.ordinal) {
                if (!this._intercept) {
                    glm.error("Ordinal regression", "must have intercepts.  set _intercept to true.");
                }
                if (!(this._solver.equals((Object)Solver.AUTO) || this._solver.equals((Object)Solver.GRADIENT_DESCENT_SQERR) || this._solver.equals((Object)Solver.GRADIENT_DESCENT_LH))) {
                    glm.error("Ordinal regression", "Ordinal regression only supports gradient descend.  Do not set Solver or set Solver to auto, GRADIENT_DESCENT_LH or GRADIENT_DESCENT_SQERR.");
                }
                if (this._lambda_search) {
                    glm.error("ordinal regression", "Ordinal regression do not support lambda search.");
                }
            }
            if (this._HGLM) {
                if (this._random_columns == null) {
                    throw new IllegalArgumentException("Need to specify the random component columns for HGLM.");
                }
                if (this._random_columns.length != 1) {
                    throw new IllegalArgumentException("HGLM only supports ONE random component for now.");
                }
                if (this._rand_family != null && this._rand_family.length != this._random_columns.length) {
                    throw new IllegalArgumentException("HGLM _rand_family: must have the same length as random_columns.");
                }
                if (this._rand_link != null && this._rand_link.length != this._random_columns.length) {
                    throw new IllegalArgumentException("HGLM _rand_link: must have the same length as random_columns.");
                }
                if (!this._family.equals((Object)Family.gaussian)) {
                    throw new IllegalArgumentException("HGLM only supports Gaussian distributions for now.");
                }
                if (this._rand_family != null) {
                    Family[] familyArray = this._rand_family;
                    int n = familyArray.length;
                    for (int i = 0; i < n; ++i) {
                        Family fam = familyArray[i];
                        if (fam.equals((Object)Family.gaussian)) continue;
                        throw new IllegalArgumentException("HGLM only supports Gaussian distributions for now.");
                    }
                }
                if (this._rand_link != null) {
                    for (Link lin : this._rand_link) {
                        if (lin.equals((Object)Link.identity) || lin.equals((Object)Link.family_default)) continue;
                        throw new IllegalArgumentException("HGLM only supports identity link functions for now.");
                    }
                }
                if (!this._link.equals((Object)Link.family_default) && !this._link.equals((Object)Link.identity)) {
                    throw new IllegalArgumentException("HGLM only supports identity link functions for now.");
                }
                if (this._lambda_search) {
                    throw new IllegalArgumentException("HGLM does not allow lambda search.  Set it to False/FALSE/false to disable it.");
                }
                if (this._nfolds > 1) {
                    throw new IllegalArgumentException("HGLM does not allow cross-validation.");
                }
                if (this._valid != null) {
                    throw new IllegalArgumentException("HGLM does not allow validation.");
                }
                this._glmType = GLMType.hglm;
            }
            if (this._link != Link.family_default) {
                switch (this._family) {
                    case AUTO: {
                        if (!(this._link != Link.family_default & this._link != Link.identity & this._link != Link.log & this._link != Link.inverse & this._link != Link.logit & this._link != Link.multinomial)) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only family_default, identity, log, inverse, logit and multinomial are allowed for family=AUTO");
                    }
                    case gaussian: {
                        if (this._link == Link.identity || this._link == Link.log || this._link == Link.inverse) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only identity, log and inverse links are allowed for family=gaussian.");
                    }
                    case quasibinomial: 
                    case binomial: 
                    case fractionalbinomial: {
                        if (this._link == Link.logit) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only logit is allowed for family=" + (Object)((Object)this._family) + ". Got " + (Object)((Object)this._link));
                    }
                    case poisson: 
                    case negativebinomial: {
                        if (this._link == Link.log || this._link == Link.identity) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only log and identity links are allowed for family=poisson and family=negbinomimal.");
                    }
                    case gamma: {
                        if (this._link == Link.inverse || this._link == Link.log || this._link == Link.identity) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only inverse, log and identity links are allowed for family=gamma.");
                    }
                    case tweedie: {
                        if (this._link == Link.tweedie) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only tweedie link allowed for family=tweedie.");
                    }
                    case multinomial: {
                        if (this._link == Link.multinomial) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only multinomial link allowed for family=multinomial.");
                    }
                    case ordinal: {
                        if (this._link == Link.ologit || this._link == Link.oprobit || this._link == Link.ologlog) break;
                        throw new IllegalArgumentException("Incompatible link function for selected family. Only ologit, oprobit or ologlog links allowed for family=ordinal.");
                    }
                    default: {
                        H2O.fail();
                    }
                }
            }
            if (this._missing_values_handling != null && !(this._missing_values_handling instanceof DeepLearningModel.DeepLearningParameters.MissingValuesHandling) && !(this._missing_values_handling instanceof MissingValuesHandling)) {
                throw new IllegalArgumentException("Missing values handling should be specified as an instance of " + MissingValuesHandling.class.getName());
            }
        }

        public GLMParameters() {
            this(Family.AUTO, Link.family_default);
            assert (this._link == Link.family_default);
            this._stopping_rounds = 0;
        }

        public GLMParameters(Family f) {
            this(f, f.defaultLink);
        }

        public GLMParameters(Family f, Link l) {
            this(f, l, null, null, 0.0, 1.0);
        }

        public GLMParameters(Family f, Link l, double[] lambda, double[] alpha, double twVar, double twLnk) {
            this(f, l, lambda, alpha, twVar, twLnk, null);
        }

        public GLMParameters(Family f, Link l, double[] lambda, double[] alpha, double twVar, double twLnk, String[] interactions) {
            this(f, l, lambda, alpha, twVar, twLnk, interactions, 1.0E-10);
        }

        public GLMParameters(Family f, Link l, double[] lambda, double[] alpha, double twVar, double twLnk, String[] interactions, double theta) {
            this._lambda = lambda;
            this._alpha = alpha;
            this._tweedie_variance_power = twVar;
            this._tweedie_link_power = twLnk;
            this._interactions = interactions;
            this._family = f;
            this._link = l;
            this._theta = theta;
            this._invTheta = 1.0 / theta;
        }

        public final double variance(double mu) {
            switch (this._family) {
                case gaussian: {
                    return 1.0;
                }
                case quasibinomial: 
                case binomial: 
                case fractionalbinomial: 
                case multinomial: 
                case ordinal: {
                    return mu * (1.0 - mu);
                }
                case poisson: {
                    return mu;
                }
                case gamma: {
                    return mu * mu;
                }
                case tweedie: {
                    return Math.pow(mu, this._tweedie_variance_power);
                }
            }
            throw new RuntimeException("unknown family Id " + (Object)((Object)this._family));
        }

        public final boolean canonical() {
            switch (this._family) {
                case gaussian: {
                    return this._link == Link.identity;
                }
                case quasibinomial: 
                case binomial: 
                case fractionalbinomial: {
                    return this._link == Link.logit;
                }
                case poisson: {
                    return this._link == Link.log;
                }
                case gamma: {
                    return this._link == Link.inverse;
                }
            }
            throw H2O.unimpl();
        }

        public final double deviance(double yr, double ym) {
            double y1 = yr == 0.0 ? 0.1 : yr;
            switch (this._family) {
                case gaussian: {
                    return (yr - ym) * (yr - ym);
                }
                case quasibinomial: 
                case binomial: 
                case fractionalbinomial: {
                    return 2.0 * (GLMParameters.y_log_y(yr, ym) + GLMParameters.y_log_y(1.0 - yr, 1.0 - ym));
                }
                case poisson: {
                    if (yr == 0.0) {
                        return 2.0 * ym;
                    }
                    return 2.0 * (yr * Math.log(yr / ym) - (yr - ym));
                }
                case negativebinomial: {
                    return yr == 0.0 || ym == 0.0 ? 0.0 : 2.0 * ((this._invTheta + yr) * Math.log((1.0 + this._theta * ym) / (1.0 + this._theta * yr)) + yr * Math.log(yr / ym));
                }
                case gamma: {
                    if (yr == 0.0) {
                        return -2.0;
                    }
                    return -2.0 * (Math.log(yr / ym) - (yr - ym) / ym);
                }
                case tweedie: {
                    double theta = this._tweedie_variance_power == 1.0 ? Math.log(y1 / ym) : (Math.pow(y1, 1.0 - this._tweedie_variance_power) - Math.pow(ym, 1.0 - this._tweedie_variance_power)) / (1.0 - this._tweedie_variance_power);
                    double kappa = this._tweedie_variance_power == 2.0 ? Math.log(y1 / ym) : (Math.pow(yr, 2.0 - this._tweedie_variance_power) - Math.pow(ym, 2.0 - this._tweedie_variance_power)) / (2.0 - this._tweedie_variance_power);
                    return 2.0 * (yr * theta - kappa);
                }
            }
            throw new RuntimeException("unknown family " + (Object)((Object)this._family));
        }

        public final double deviance(float yr, float ym) {
            return this.deviance((double)yr, (double)ym);
        }

        public final double likelihood(double yr, double ym) {
            if (this._family.equals((Object)Family.negativebinomial)) {
                return yr > 0.0 && ym > 0.0 ? -GLMTask.sumOper(yr, this._invTheta, 0) + this._invTheta * Math.log(1.0 + this._theta * ym) - yr * Math.log(ym) - yr * Math.log(this._theta) + yr * Math.log(1.0 + this._theta * ym) : (yr == 0.0 && ym > 0.0 ? this._invTheta * Math.log(1.0 + this._theta * ym) : 0.0);
            }
            return 0.5 * this.deviance(yr, ym);
        }

        public final double linkDeriv(double x) {
            switch (this._link) {
                case ologit: 
                case logit: {
                    double div = x * (1.0 - x);
                    if (div < 1.0E-6) {
                        return 1000000.0;
                    }
                    return 1.0 / div;
                }
                case identity: {
                    return 1.0;
                }
                case log: {
                    return 1.0 / x;
                }
                case inverse: {
                    return -1.0 / (x * x);
                }
                case ologlog: {
                    double oneMx = 1.0 - x;
                    double divsor = -1.0 * oneMx * Math.log(oneMx);
                    return divsor < 1.0E-6 ? 1000000.0 : 1.0 / divsor;
                }
                case tweedie: {
                    return this._tweedie_link_power == 0.0 ? 1.0 / Math.max(2.0E-16, x) : this._tweedie_link_power * Math.pow(x, this._tweedie_link_power - 1.0);
                }
            }
            throw H2O.unimpl();
        }

        public final double randLinkInv(double x, int index) {
            switch (this._rand_link[index]) {
                case identity: {
                    return x;
                }
                case ologlog: {
                    return 1.0 - Math.exp(-1.0 * Math.exp(x));
                }
                case oprobit: {
                    return _dprobit.cumulativeProbability(x);
                }
                case ologit: 
                case logit: {
                    return 1.0 / (Math.exp(-x) + 1.0);
                }
                case log: {
                    return Math.exp(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
                case tweedie: {
                    return this._tweedie_link_power == 0.0 ? Math.max(2.0E-16, Math.exp(x)) : Math.pow(x, 1.0 / this._tweedie_link_power);
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this));
        }

        public final double linkInv(double x) {
            switch (this._link) {
                case identity: {
                    return x;
                }
                case ologlog: {
                    return 1.0 - Math.exp(-1.0 * Math.exp(x));
                }
                case oprobit: {
                    return _dprobit.cumulativeProbability(x);
                }
                case ologit: 
                case logit: {
                    return 1.0 / (Math.exp(-x) + 1.0);
                }
                case log: {
                    return Math.exp(x);
                }
                case inverse: {
                    double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
                    return 1.0 / xx;
                }
                case tweedie: {
                    return this._tweedie_link_power == 0.0 ? Math.max(2.0E-16, Math.exp(x)) : Math.pow(x, 1.0 / this._tweedie_link_power);
                }
            }
            throw new RuntimeException("unexpected link function id  " + (Object)((Object)this));
        }

        static final double y_log_y(double y, double mu) {
            if (y == 0.0) {
                return 0.0;
            }
            if (mu < Double.MIN_NORMAL) {
                mu = Double.MIN_NORMAL;
            }
            return y * Math.log(y / mu);
        }

        public Model.InteractionSpec interactionSpec() {
            return Model.InteractionSpec.create((String[])this._interactions, (StringPair[])this._interaction_pairs);
        }

        public MissingValuesHandling missingValuesHandling() {
            if (this._missing_values_handling instanceof MissingValuesHandling) {
                return (MissingValuesHandling)((Object)this._missing_values_handling);
            }
            assert (this._missing_values_handling instanceof DeepLearningModel.DeepLearningParameters.MissingValuesHandling);
            switch ((DeepLearningModel.DeepLearningParameters.MissingValuesHandling)((Object)this._missing_values_handling)) {
                case MeanImputation: {
                    return MissingValuesHandling.MeanImputation;
                }
                case Skip: {
                    return MissingValuesHandling.Skip;
                }
            }
            throw new IllegalStateException("Unsupported missing values handling value: " + this._missing_values_handling);
        }

        public boolean imputeMissing() {
            return this.missingValuesHandling() == MissingValuesHandling.MeanImputation || this.missingValuesHandling() == MissingValuesHandling.PlugValues;
        }

        public DataInfo.Imputer makeImputer() {
            if (this.missingValuesHandling() == MissingValuesHandling.PlugValues) {
                if (this._plug_values == null || this._plug_values.get() == null) {
                    throw new IllegalStateException("Plug values frame needs to be specified when Missing Value Handling = PlugValues.");
                }
                return new GLM.PlugValuesImputer((Frame)this._plug_values.get());
            }
            return new DataInfo.MeanImputer();
        }

        public void setDistributionFamily(DistributionFamily distributionFamily) {
            this._family = DistributionUtils.distributionToFamily(distributionFamily);
            this._link = Link.family_default;
        }

        public DistributionFamily getDistributionFamily() {
            return DistributionUtils.familyToDistribution(this._family);
        }

        public static enum Solver {
            AUTO,
            IRLSM,
            L_BFGS,
            COORDINATE_DESCENT_NAIVE,
            COORDINATE_DESCENT,
            GRADIENT_DESCENT_LH,
            GRADIENT_DESCENT_SQERR;

        }

        public static enum Influence {
            dfbetas;

        }

        public static enum Link {
            family_default,
            identity,
            logit,
            log,
            inverse,
            tweedie,
            multinomial,
            ologit,
            oprobit,
            ologlog;

        }

        public static enum GLMType {
            glm,
            gam,
            hglm;

        }

        public static enum DispersionMethod {
            pearson,
            ml,
            deviance;

        }

        public static enum Family {
            AUTO(Link.family_default),
            gaussian(Link.identity),
            binomial(Link.logit),
            fractionalbinomial(Link.logit),
            quasibinomial(Link.logit),
            poisson(Link.log),
            gamma(Link.inverse),
            multinomial(Link.multinomial),
            tweedie(Link.tweedie),
            ordinal(Link.ologit),
            negativebinomial(Link.log);

            public final Link defaultLink;

            private Family(Link link) {
                this.defaultLink = link;
            }
        }

        public static enum MissingValuesHandling {
            MeanImputation,
            PlugValues,
            Skip;

        }
    }

    public static class RegularizationPath
    extends Iced {
        public double[] _lambdas;
        public double[] _alphas;
        public double[] _explained_deviance_train;
        public double[] _explained_deviance_valid;
        public double[][] _coefficients;
        public double[][] _coefficients_std;
        public String[] _coefficient_names;
        public double[][] _z_values;
        public double[][] _p_values;
        public double[][] _std_errs;
    }
}

