/*
 * Decompiled with CFR 0.152.
 */
package hex.isotonic;

import water.fvec.NewChunk;
import water.util.ArrayUtils;

class PoolAdjacentViolators {
    private final double[] _ws;
    private final double[] _wYs;
    private final int[] _blocks;

    PoolAdjacentViolators(double[] ys) {
        this(ys, null);
    }

    public PoolAdjacentViolators(double[] ys, double[] ws) {
        this._ws = ws != null ? (double[])ws.clone() : ArrayUtils.constAry((int)ys.length, (double)1.0);
        this._wYs = new double[this._ws.length];
        for (int i = 0; i < this._ws.length; ++i) {
            this._wYs[i] = this._ws[i] * ys[i];
        }
        this._blocks = ArrayUtils.seq((int)0, (int)ys.length);
    }

    void findThresholds(double[] xs, NewChunk[] ncs) {
        this.findThresholds(xs, ncs[0], ncs[1], ncs[2]);
    }

    void findThresholds(double[] xs, NewChunk outYs, NewChunk outXs, NewChunk outWs) {
        this.mergeViolators();
        this.outputThresholds(xs, outYs, outXs, outWs);
    }

    void mergeViolators() {
        int block = 0;
        while (this.next(block) < this._blocks.length) {
            if (this.meanY(block) >= this.meanY(this.next(block))) {
                this.mergeWithNext(block);
                while (block > 0 && this.meanY(this.prev(block)) >= this.meanY(block)) {
                    block = this.prev(block);
                    this.mergeWithNext(block);
                }
                continue;
            }
            block = this.next(block);
        }
    }

    void outputThresholds(double[] xs, NewChunk outYs, NewChunk outXs, NewChunk outWs) {
        int i = 0;
        while (i < xs.length) {
            if (xs[this._blocks[i]] > xs[i]) {
                outYs.addNum(this.meanY(i));
                outXs.addNum(xs[i]);
                outWs.addNum(this._ws[i] / 2.0);
                outYs.addNum(this.meanY(i));
                outXs.addNum(xs[this._blocks[i]]);
                outWs.addNum(this._ws[i] / 2.0);
            } else {
                outYs.addNum(this.meanY(i));
                outXs.addNum(xs[i]);
                outWs.addNum(this._ws[i]);
            }
            i = this.next(i);
        }
    }

    int next(int b) {
        return this._blocks[b] + 1;
    }

    int prev(int b) {
        if (this._blocks[b - 1] == b - 1) {
            return b - 1;
        }
        int ref = this._blocks[b - 1];
        if (ref >= 0) {
            throw new IllegalStateException("Block representation is broken, expected a negative encoded block reference, instead got: " + ref + " for block " + b + ".");
        }
        return -ref - 1;
    }

    void mergeWithNext(int b1) {
        int b2 = this._blocks[b1] + 1;
        this._blocks[b1] = this._blocks[b2];
        this._blocks[this._blocks[b2]] = -b1 - 1;
        int n = b1;
        this._ws[n] = this._ws[n] + this._ws[b2];
        int n2 = b1;
        this._wYs[n2] = this._wYs[n2] + this._wYs[b2];
    }

    double meanY(int b) {
        return this._wYs[b] / this._ws[b];
    }
}

