/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import java.util.Collection;
import water.Freezable;
import water.Iced;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.IcedHashSet;
import water.util.IcedInt;

public class GlobalInteractionConstraints
extends Iced<GlobalInteractionConstraints> {
    private IcedHashMap<IcedInt, IcedHashSet<IcedInt>> allowedInteractionMap = new IcedHashMap();

    public GlobalInteractionConstraints(String[][] userFeatureInteractions, String[] treeFeatureNames) {
        this.parseInteractionsIndices(userFeatureInteractions, treeFeatureNames);
        assert (this.allowedInteractionMap != null);
        assert (this.allowedInteractionMap.size() != 0);
    }

    private void parseInteractionsIndices(String[][] userInteractionConstraints, String[] columnNames) {
        for (String[] list : userInteractionConstraints) {
            IcedHashSet interactions = new IcedHashSet();
            for (int i = 0; i < list.length; ++i) {
                String item = list[i];
                int start = ArrayUtils.findWithPrefix((String[])columnNames, (String)item);
                assert (start != -1) : "Column name should be in defined column names.";
                if (start > -1) {
                    interactions.add((Freezable)new IcedInt(start));
                    continue;
                }
                start = -start - 2;
                assert (columnNames[start].startsWith(item)) : "The column name should be find correctly.";
                for (int end = start; end < columnNames.length && columnNames[end].startsWith(item); ++end) {
                    interactions.add((Freezable)new IcedInt(end));
                }
            }
            this.addInteractionsSetToMap((IcedHashSet<IcedInt>)interactions);
        }
    }

    private void addInteractionsSetToMap(IcedHashSet<IcedInt> interactions) {
        for (IcedInt index : interactions) {
            if (!this.allowedInteractionMap.containsKey((Object)index)) {
                this.allowedInteractionMap.put((Object)index, interactions);
                continue;
            }
            IcedHashSet set = new IcedHashSet();
            set.addAll((Collection)this.allowedInteractionMap.get((Object)index));
            set.addAll(interactions);
            this.allowedInteractionMap.put((Object)index, (Object)set);
        }
    }

    public IcedHashSet<IcedInt> getAllowedInteractionForIndex(int columnIndex) {
        return (IcedHashSet)this.allowedInteractionMap.get((Object)new IcedInt(columnIndex));
    }

    public boolean allowedInteractionContainsColumn(int columnIndex) {
        return this.allowedInteractionMap.containsKey((Object)new IcedInt(columnIndex));
    }

    public IcedHashSet<IcedInt> getAllAllowedColumnIndices() {
        IcedHashSet indices = new IcedHashSet();
        indices.addAll((Collection)this.allowedInteractionMap.keySet());
        return indices;
    }
}

