/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.PojoWriter;
import hex.ScoreKeeper;
import hex.ToEigenVec;
import hex.VarImp;
import hex.genmodel.CategoricalEncoding;
import hex.genmodel.GenModel;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.tree.CalibrationHelper;
import hex.tree.CompressedTree;
import hex.tree.DTree;
import hex.tree.Score;
import hex.tree.SharedTree;
import hex.tree.SharedTreePojoWriter;
import hex.tree.TreeStats;
import hex.util.LinearAlgebraUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.IcedUtils;
import water.Job;
import water.Key;
import water.Keyed;
import water.LocalMR;
import water.MRTask;
import water.MrFun;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.TwoDimTable;
import water.util.VecUtils;

public abstract class SharedTreeModel<M extends SharedTreeModel<M, P, O>, P extends SharedTreeParameters, O extends SharedTreeOutput>
extends Model<M, P, O>
implements Model.LeafNodeAssignment,
Model.GetMostImportantFeatures,
Model.FeatureFrequencies,
Model.UpdateAuxTreeWeights {
    private static final Logger LOG = Logger.getLogger(SharedTreeModel.class);

    public String[] getMostImportantFeatures(int n) {
        if (this._output == null) {
            return null;
        }
        TwoDimTable vi = ((SharedTreeOutput)this._output)._variable_importances;
        if (vi == null) {
            return null;
        }
        n = Math.min(n, vi.getRowHeaders().length);
        String[] res = new String[n];
        System.arraycopy(vi.getRowHeaders(), 0, res, 0, n);
        return res;
    }

    public ToEigenVec getToEigenVec() {
        return LinearAlgebraUtils.toEigen;
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        switch (((SharedTreeOutput)this._output).getModelCategory()) {
            case Binomial: {
                return new ModelMetricsBinomial.MetricBuilderBinomial(domain);
            }
            case Multinomial: {
                return new ModelMetricsMultinomial.MetricBuilderMultinomial(((SharedTreeOutput)this._output).nclasses(), domain, ((SharedTreeParameters)this._parms)._auc_type);
            }
            case Regression: {
                return new ModelMetricsRegression.MetricBuilderRegression();
            }
        }
        throw H2O.unimpl();
    }

    public SharedTreeModel(Key<M> selfKey, P parms, O output) {
        super(selfKey, parms, output);
    }

    protected String[] makeAllTreeColumnNames() {
        int classTrees = 0;
        for (int i = 0; i < ((SharedTreeOutput)this._output)._treeKeys[0].length; ++i) {
            if (((SharedTreeOutput)this._output)._treeKeys[0][i] == null) continue;
            ++classTrees;
        }
        int outputcols = ((SharedTreeOutput)this._output)._treeKeys.length * classTrees;
        String[] names = new String[outputcols];
        int col = 0;
        for (int tidx = 0; tidx < ((SharedTreeOutput)this._output)._treeKeys.length; ++tidx) {
            Key<CompressedTree>[] keys = ((SharedTreeOutput)this._output)._treeKeys[tidx];
            for (int c = 0; c < keys.length; ++c) {
                if (keys[c] == null) continue;
                names[col++] = "T" + (tidx + 1) + (keys.length == 1 ? "" : ".C" + (c + 1));
            }
        }
        return names;
    }

    public Frame scoreLeafNodeAssignment(Frame frame, Model.LeafNodeAssignment.LeafNodeAssignmentType type, Key<Frame> destination_key) {
        Frame adaptFrm = new Frame(frame);
        this.adaptTestForTrain(adaptFrm, true, false);
        String[] names = this.makeAllTreeColumnNames();
        AssignLeafNodeTaskBase task = AssignLeafNodeTaskBase.make((SharedTreeOutput)this._output, type);
        return task.execute(adaptFrm, names, destination_key);
    }

    public Model.UpdateAuxTreeWeights.UpdateAuxTreeWeightsReport updateAuxTreeWeights(Frame frame, String weightsColumn) {
        if (weightsColumn == null) {
            throw new IllegalArgumentException("Weights column name is not defined");
        }
        Frame adaptFrm = new Frame(frame);
        Vec weights = adaptFrm.remove(weightsColumn);
        if (weights == null) {
            throw new IllegalArgumentException("Input frame doesn't contain weights column `" + weightsColumn + "`");
        }
        this.adaptTestForTrain(adaptFrm, true, false);
        Frame featureFrm = new Frame(((SharedTreeOutput)this._output).features(), frame.vecs(((SharedTreeOutput)this._output).features()));
        featureFrm.add(weightsColumn, weights);
        UpdateAuxTreeWeightsTask t = (UpdateAuxTreeWeightsTask)new UpdateAuxTreeWeightsTask((SharedTreeOutput)this._output).doAll(featureFrm);
        Model.UpdateAuxTreeWeights.UpdateAuxTreeWeightsReport report = new Model.UpdateAuxTreeWeights.UpdateAuxTreeWeightsReport();
        report._warn_trees = t._warnTrees;
        report._warn_classes = t._warnClasses;
        return report;
    }

    public Frame scoreFeatureFrequencies(Frame frame, Key<Frame> destination_key) {
        Frame adaptFrm = new Frame(frame);
        this.adaptTestForTrain(adaptFrm, true, false);
        adaptFrm.remove(((SharedTreeParameters)this._parms)._response_column);
        adaptFrm.remove(((SharedTreeParameters)this._parms)._fold_column);
        adaptFrm.remove(((SharedTreeParameters)this._parms)._weights_column);
        adaptFrm.remove(((SharedTreeParameters)this._parms)._offset_column);
        if (((SharedTreeParameters)this._parms)._treatment_column != null) {
            adaptFrm.remove(((SharedTreeParameters)this._parms)._treatment_column);
        }
        assert (adaptFrm.numCols() == ((SharedTreeOutput)this._output).nfeatures());
        return ((ScoreFeatureFrequenciesTask)new ScoreFeatureFrequenciesTask((SharedTreeOutput)this._output).doAll(adaptFrm.numCols(), (byte)3, adaptFrm)).outputFrame(destination_key, adaptFrm.names(), null);
    }

    protected Frame postProcessPredictions(Frame adaptedFrame, Frame predictFr, Job j) {
        return CalibrationHelper.postProcessPredictions(predictFr, j, (CalibrationHelper.OutputWithCalibration)this._output);
    }

    protected double[] score0Incremental(Score.ScoreIncInfo sii, Chunk[] chks, double offset, int row_in_chunk, double[] tmp, double[] preds) {
        return this.score0(chks, offset, row_in_chunk, tmp, preds);
    }

    protected double[] score0(double[] data, double[] preds, double offset) {
        return this.score0(data, preds, offset, ((SharedTreeOutput)this._output)._treeKeys.length);
    }

    protected double[] score0(double[] data, double[] preds) {
        return this.score0(data, preds, 0.0);
    }

    protected double[] score0(double[] data, double[] preds, double offset, int ntrees) {
        Arrays.fill(preds, 0.0);
        return this.score0(data, preds, offset, 0, ntrees);
    }

    protected double[] score0(double[] data, double[] preds, double offset, int startTree, int ntrees) {
        for (int tidx = startTree; tidx < ntrees; ++tidx) {
            this.score0(data, preds, tidx);
        }
        return preds;
    }

    private void score0(double[] data, double[] preds, int treeIdx) {
        Key<CompressedTree>[] keys = ((SharedTreeOutput)this._output)._treeKeys[treeIdx];
        for (int c = 0; c < keys.length; ++c) {
            if (keys[c] == null) continue;
            double pred = ((CompressedTree)DKV.get(keys[c]).get()).score(data, ((SharedTreeOutput)this._output)._domains);
            assert (!Double.isInfinite(pred));
            int n = keys.length == 1 ? 0 : c + 1;
            preds[n] = preds[n] + pred;
        }
    }

    protected M deepClone(Key<M> result) {
        SharedTreeModel newModel = (SharedTreeModel)IcedUtils.deepCopy(this.self());
        newModel._key = result;
        ((SharedTreeOutput)newModel._output).clearModelMetrics(false);
        ((SharedTreeOutput)newModel._output)._training_metrics = null;
        ((SharedTreeOutput)newModel._output)._validation_metrics = null;
        Key<CompressedTree>[][] treeKeys = ((SharedTreeOutput)newModel._output)._treeKeys;
        for (int i = 0; i < treeKeys.length; ++i) {
            for (int j = 0; j < treeKeys[i].length; ++j) {
                if (treeKeys[i][j] == null) continue;
                CompressedTree ct = (CompressedTree)DKV.get(treeKeys[i][j]).get();
                CompressedTree newCt = (CompressedTree)IcedUtils.deepCopy((Iced)ct);
                newCt._key = CompressedTree.makeTreeKey(i, j);
                Key key = newCt._key;
                treeKeys[i][j] = key;
                DKV.put((Key)key, (Iced)newCt);
            }
        }
        Key<CompressedTree>[][] treeKeysAux = ((SharedTreeOutput)newModel._output)._treeKeysAux;
        if (treeKeysAux != null) {
            for (int i = 0; i < treeKeysAux.length; ++i) {
                for (int j = 0; j < treeKeysAux[i].length; ++j) {
                    if (treeKeysAux[i][j] == null) continue;
                    CompressedTree ct = (CompressedTree)DKV.get(treeKeysAux[i][j]).get();
                    CompressedTree newCt = (CompressedTree)IcedUtils.deepCopy((Iced)ct);
                    Key key = newCt._key = Key.make((String)GenModel.createAuxKey((String)treeKeys[i][j].toString()));
                    treeKeysAux[i][j] = key;
                    DKV.put((Key)key, (Iced)newCt);
                }
            }
        }
        return (M)((Object)newModel);
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        Key<CompressedTree>[] ks;
        int n;
        Key<CompressedTree>[][] keyArray = ((SharedTreeOutput)this._output)._treeKeys;
        int n2 = keyArray.length;
        for (n = 0; n < n2; ++n) {
            for (Key<CompressedTree> k : ks = keyArray[n]) {
                Keyed.remove(k, (Futures)fs, (boolean)true);
            }
        }
        keyArray = ((SharedTreeOutput)this._output)._treeKeysAux;
        n2 = keyArray.length;
        for (n = 0; n < n2; ++n) {
            for (Key<CompressedTree> k : ks = keyArray[n]) {
                Keyed.remove(k, (Futures)fs, (boolean)true);
            }
        }
        if (((SharedTreeOutput)this._output)._calib_model != null) {
            ((SharedTreeOutput)this._output)._calib_model.remove(fs);
        }
        return super.remove_impl(fs, cascade);
    }

    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        Key<CompressedTree>[] ks;
        int n;
        Key<CompressedTree>[][] keyArray = ((SharedTreeOutput)this._output)._treeKeys;
        int n2 = keyArray.length;
        for (n = 0; n < n2; ++n) {
            for (Key<CompressedTree> k : ks = keyArray[n]) {
                ab.putKey(k);
            }
        }
        keyArray = ((SharedTreeOutput)this._output)._treeKeysAux;
        n2 = keyArray.length;
        for (n = 0; n < n2; ++n) {
            for (Key<CompressedTree> k : ks = keyArray[n]) {
                ab.putKey(k);
            }
        }
        return super.writeAll_impl(ab);
    }

    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        Key<CompressedTree>[] ks;
        int n;
        Key<CompressedTree>[][] keyArray = ((SharedTreeOutput)this._output)._treeKeys;
        int n2 = keyArray.length;
        for (n = 0; n < n2; ++n) {
            for (Key<CompressedTree> k : ks = keyArray[n]) {
                ab.getKey(k, fs);
            }
        }
        keyArray = ((SharedTreeOutput)this._output)._treeKeysAux;
        n2 = keyArray.length;
        for (n = 0; n < n2; ++n) {
            for (Key<CompressedTree> k : ks = keyArray[n]) {
                ab.getKey(k, fs);
            }
        }
        return super.readAll_impl(ab, fs);
    }

    private M self() {
        return (M)((Object)this);
    }

    public SharedTreeSubgraph getSharedTreeSubgraph(int tidx, int cls) {
        if (tidx < 0 || tidx >= ((SharedTreeOutput)this._output)._ntrees) {
            throw new IllegalArgumentException("Invalid tree index: " + tidx + ". Tree index must be in range [0, " + (((SharedTreeOutput)this._output)._ntrees - 1) + "].");
        }
        Key<CompressedTree> treeKey = ((SharedTreeOutput)this._output)._treeKeysAux[tidx][cls];
        if (treeKey == null) {
            return null;
        }
        CompressedTree auxCompressedTree = (CompressedTree)treeKey.get();
        return ((CompressedTree)((SharedTreeOutput)this._output)._treeKeys[tidx][cls].get()).toSharedTreeSubgraph(auxCompressedTree, ((SharedTreeOutput)this._output)._names, ((SharedTreeOutput)this._output)._domains);
    }

    public boolean isFeatureUsedInPredict(String featureName) {
        if (featureName.equals(((SharedTreeOutput)this._output).responseName())) {
            return false;
        }
        int featureIdx = ArrayUtils.find((Object[])((SharedTreeOutput)this._output)._varimp._names, (Object)featureName);
        return featureIdx != -1 && (double)((SharedTreeOutput)this._output)._varimp._varimp[featureIdx] != 0.0;
    }

    public boolean binomialOpt() {
        return true;
    }

    public CategoricalEncoding getGenModelEncoding() {
        switch (((SharedTreeParameters)this._parms)._categorical_encoding) {
            case AUTO: 
            case Enum: 
            case SortByResponse: {
                return CategoricalEncoding.AUTO;
            }
            case OneHotExplicit: {
                return CategoricalEncoding.OneHotExplicit;
            }
            case Binary: {
                return CategoricalEncoding.Binary;
            }
            case EnumLimited: {
                return CategoricalEncoding.EnumLimited;
            }
            case Eigen: {
                return CategoricalEncoding.Eigen;
            }
            case LabelEncoder: {
                return CategoricalEncoding.LabelEncoder;
            }
        }
        return null;
    }

    protected SharedTreePojoWriter makeTreePojoWriter() {
        throw new UnsupportedOperationException("POJO is not supported for model " + ((SharedTreeParameters)this._parms).algoName() + ".");
    }

    protected final PojoWriter makePojoWriter() {
        CategoricalEncoding encoding = this.getGenModelEncoding();
        if (encoding == null) {
            throw new IllegalArgumentException("Only default, SortByResponse, EnumLimited and 1-hot explicit scheme is supported for POJO/MOJO");
        }
        return this.makeTreePojoWriter();
    }

    private static class ScoreFeatureFrequenciesTask
    extends MRTask<ScoreFeatureFrequenciesTask> {
        final Key<CompressedTree>[][] _treeKeys;
        final Key<CompressedTree>[][] _auxTreeKeys;
        final String[][] _domains;
        transient SharedTreeSubgraph[][] _trees;

        ScoreFeatureFrequenciesTask(SharedTreeOutput output) {
            this._treeKeys = output._treeKeys;
            this._auxTreeKeys = output._treeKeysAux;
            this._domains = output._domains;
        }

        protected void setupLocal() {
            this._trees = new SharedTreeSubgraph[this._treeKeys.length][];
            for (int t = 0; t < this._treeKeys.length; ++t) {
                this._trees[t] = new SharedTreeSubgraph[this._treeKeys[t].length];
            }
            ComputeSharedTreesFun getSharedTreesFun = new ComputeSharedTreesFun(this._trees, this._treeKeys, this._auxTreeKeys, this._fr.names(), this._domains);
            ((LocalMR)H2O.submitTask((H2O.H2OCountedCompleter)new LocalMR((MrFun)getSharedTreesFun, this._trees.length))).join();
        }

        public void map(Chunk[] cs, NewChunk[] ncs) {
            double[] input = new double[cs.length];
            int[] output = new int[ncs.length];
            for (int r = 0; r < cs[0]._len; ++r) {
                int i;
                for (i = 0; i < cs.length; ++i) {
                    input[i] = cs[i].atd(r);
                }
                Arrays.fill(output, 0);
                for (int t = 0; t < this._treeKeys.length; ++t) {
                    for (int c = 0; c < this._treeKeys[t].length; ++c) {
                        if (this._treeKeys[t][c] == null) continue;
                        double d = SharedTreeMojoModel.scoreTree((byte[])((CompressedTree)this._treeKeys[t][c].get())._bits, (double[])input, (boolean)true, (String[][])this._domains);
                        String decisionPath = SharedTreeMojoModel.getDecisionPath((double)d);
                        SharedTreeNode n = this._trees[t][c].walkNodes(decisionPath);
                        this.updateStats(n, output);
                    }
                }
                for (i = 0; i < ncs.length; ++i) {
                    ncs[i].addNum((double)output[i]);
                }
            }
        }

        private void updateStats(SharedTreeNode leaf, int[] stats) {
            for (SharedTreeNode n = leaf.getParent(); n != null; n = n.getParent()) {
                int n2 = n.getColId();
                stats[n2] = stats[n2] + 1;
            }
        }
    }

    private static class ComputeSharedTreesFun
    extends MrFun<ComputeSharedTreesFun> {
        final Key<CompressedTree>[][] _treeKeys;
        final Key<CompressedTree>[][] _auxTreeKeys;
        final String[] _names;
        final String[][] _domains;
        transient SharedTreeSubgraph[][] _trees;

        ComputeSharedTreesFun(SharedTreeSubgraph[][] trees, Key<CompressedTree>[][] treeKeys, Key<CompressedTree>[][] auxTreeKeys, String[] names, String[][] domains) {
            this._trees = trees;
            this._treeKeys = treeKeys;
            this._auxTreeKeys = auxTreeKeys;
            this._names = names;
            this._domains = domains;
        }

        protected void map(int t) {
            for (int c = 0; c < this._treeKeys[t].length; ++c) {
                if (this._treeKeys[t][c] == null) continue;
                this._trees[t][c] = SharedTreeMojoModel.computeTreeGraph((int)0, (String)"T", (byte[])((CompressedTree)this._treeKeys[t][c].get())._bits, (byte[])((CompressedTree)this._auxTreeKeys[t][c].get())._bits, (String[])this._names, (String[][])this._domains);
            }
        }
    }

    private static class UpdateAuxTreeWeightsTask
    extends MRTask<UpdateAuxTreeWeightsTask> {
        private final Key<CompressedTree>[][] _treeKeys;
        private final Key<CompressedTree>[][] _auxTreeKeys;
        private final String[][] _domains;
        private transient int[][] _maxNodeIds;
        private double[][][] _leafNodeWeights;
        private int[] _warnTrees;
        private int[] _warnClasses;

        private UpdateAuxTreeWeightsTask(SharedTreeOutput output) {
            this._treeKeys = output._treeKeys;
            this._auxTreeKeys = output._treeKeysAux;
            this._domains = output._domains;
        }

        protected void setupLocal() {
            this._maxNodeIds = new int[this._auxTreeKeys.length][];
            for (int treeId = 0; treeId < this._auxTreeKeys.length; ++treeId) {
                Key<CompressedTree>[] classAuxTreeKeys = this._auxTreeKeys[treeId];
                this._maxNodeIds[treeId] = new int[classAuxTreeKeys.length];
                for (int classId = 0; classId < classAuxTreeKeys.length; ++classId) {
                    if (classAuxTreeKeys[classId] == null) {
                        this._maxNodeIds[treeId][classId] = -1;
                        continue;
                    }
                    CompressedTree tree = (CompressedTree)classAuxTreeKeys[classId].get();
                    assert (tree != null);
                    this._maxNodeIds[treeId][classId] = tree.findMaxNodeId();
                }
            }
        }

        protected void initMap() {
            this._leafNodeWeights = new double[this._maxNodeIds.length][][];
            for (int treeId = 0; treeId < this._maxNodeIds.length; ++treeId) {
                int[] classMaxNodeIds = this._maxNodeIds[treeId];
                this._leafNodeWeights[treeId] = new double[classMaxNodeIds.length][];
                for (int classId = 0; classId < classMaxNodeIds.length; ++classId) {
                    if (classMaxNodeIds[classId] < 0) continue;
                    this._leafNodeWeights[treeId][classId] = new double[classMaxNodeIds[classId] + 1];
                }
            }
        }

        public void map(Chunk[] chks) {
            double[] input = new double[chks.length - 1];
            this.initMap();
            for (int row = 0; row < chks[0]._len; ++row) {
                double weight = chks[input.length].atd(row);
                if (weight == 0.0 || Double.isNaN(weight)) continue;
                for (int i = 0; i < input.length; ++i) {
                    input[i] = chks[i].atd(row);
                }
                for (int tidx = 0; tidx < this._treeKeys.length; ++tidx) {
                    Key<CompressedTree>[] keys = this._treeKeys[tidx];
                    for (int cls = 0; cls < keys.length; ++cls) {
                        Key<CompressedTree> key = keys[cls];
                        if (key == null) continue;
                        CompressedTree tree = (CompressedTree)DKV.get(key).get();
                        CompressedTree auxTree = (CompressedTree)this._auxTreeKeys[tidx][cls].get();
                        assert (auxTree != null);
                        double d = SharedTreeMojoModel.scoreTree((byte[])tree._bits, (double[])input, (boolean)true, (String[][])this._domains);
                        int nodeId = SharedTreeMojoModel.getLeafNodeId((double)d, (byte[])auxTree._bits);
                        double[] dArray = this._leafNodeWeights[tidx][cls];
                        int n = nodeId;
                        dArray[n] = dArray[n] + weight;
                    }
                }
            }
        }

        public void reduce(UpdateAuxTreeWeightsTask mrt) {
            ArrayUtils.add((double[][][])this._leafNodeWeights, (double[][][])mrt._leafNodeWeights);
        }

        protected void postGlobal() {
            this._warnTrees = new int[0];
            this._warnClasses = new int[0];
            Futures fs = new Futures();
            for (int treeId = 0; treeId < this._leafNodeWeights.length; ++treeId) {
                double[][] classWeights = this._leafNodeWeights[treeId];
                for (int classId = 0; classId < classWeights.length; ++classId) {
                    double[] nodeWeights = classWeights[classId];
                    if (nodeWeights == null) continue;
                    CompressedTree auxTree = (CompressedTree)this._auxTreeKeys[treeId][classId].get();
                    assert (auxTree != null);
                    CompressedTree updatedTree = auxTree.updateLeafNodeWeights(nodeWeights);
                    assert (auxTree._key.equals((Object)updatedTree._key));
                    DKV.put((Keyed)updatedTree, (Futures)fs);
                    if (!updatedTree.hasZeroWeight()) continue;
                    this._warnTrees = ArrayUtils.append((int[])this._warnTrees, (int)treeId);
                    this._warnClasses = ArrayUtils.append((int[])this._warnClasses, (int)classId);
                }
            }
            fs.blockForPending();
            assert (this._warnTrees.length == this._warnClasses.length);
        }
    }

    private static class AssignLeafNodeIdTask
    extends AssignLeafNodeTaskBase {
        final Key<CompressedTree>[][] _auxTreeKeys;

        private AssignLeafNodeIdTask(SharedTreeOutput output) {
            super(output);
            this._auxTreeKeys = output._treeKeysAux;
        }

        @Override
        protected void initMap() {
        }

        @Override
        protected void assignNode(int tidx, int cls, CompressedTree tree, double[] input, NewChunk nc) {
            CompressedTree auxTree = (CompressedTree)this._auxTreeKeys[tidx][cls].get();
            assert (auxTree != null);
            double d = SharedTreeMojoModel.scoreTree((byte[])tree._bits, (double[])input, (boolean)true, (String[][])this._domains);
            int nodeId = SharedTreeMojoModel.getLeafNodeId((double)d, (byte[])auxTree._bits);
            nc.addNum((long)nodeId, 0);
        }

        @Override
        protected Frame execute(Frame adaptFrm, String[] names, Key<Frame> destKey) {
            Frame result = ((AssignLeafNodeTaskBase)this.doAll(names.length, (byte)3, adaptFrm)).outputFrame(destKey, names, null);
            if (result.vec(0).min() < 0.0) {
                LOG.warn((Object)"Some of the observations were not assigned a Leaf Node ID (-1), only tree-paths up to length 64 are supported.");
            }
            return result;
        }
    }

    private static class AssignTreePathTask
    extends AssignLeafNodeTaskBase {
        private transient BufStringDecisionPathTracker _tr;

        private AssignTreePathTask(SharedTreeOutput output) {
            super(output);
        }

        @Override
        protected void initMap() {
            this._tr = new BufStringDecisionPathTracker();
        }

        @Override
        protected void assignNode(int tidx, int cls, CompressedTree tree, double[] input, NewChunk nc) {
            BufferedString pred = tree.getDecisionPath(input, this._domains, this._tr);
            nc.addStr((Object)pred);
        }

        @Override
        protected Frame execute(Frame adaptFrm, String[] names, Key<Frame> destKey) {
            Frame res = ((AssignLeafNodeTaskBase)this.doAll(names.length, (byte)2, adaptFrm)).outputFrame(destKey, names, null);
            Vec[] nvecs = new Vec[res.vecs().length];
            boolean hasInvalidPaths = false;
            for (int c = 0; c < res.vecs().length; ++c) {
                Vec vv = res.vec(c);
                try {
                    hasInvalidPaths = hasInvalidPaths || vv.naCnt() > 0L;
                    nvecs[c] = vv.toCategoricalVec();
                    continue;
                }
                catch (Exception e) {
                    VecUtils.deleteVecs((Vec[])nvecs, (int)c);
                    throw e;
                }
            }
            res.delete();
            res = new Frame(destKey, names, nvecs);
            if (destKey != null) {
                DKV.put((Keyed)res);
            }
            if (hasInvalidPaths) {
                LOG.warn((Object)"Some of the leaf node assignments were skipped (NA), only tree-paths up to length 64 are supported.");
            }
            return res;
        }
    }

    private static abstract class AssignLeafNodeTaskBase
    extends MRTask<AssignLeafNodeTaskBase> {
        final Key<CompressedTree>[][] _treeKeys;
        final String[][] _domains;

        AssignLeafNodeTaskBase(SharedTreeOutput output) {
            this._treeKeys = output._treeKeys;
            this._domains = output._domains;
        }

        protected abstract void initMap();

        protected abstract void assignNode(int var1, int var2, CompressedTree var3, double[] var4, NewChunk var5);

        public void map(Chunk[] chks, NewChunk[] ncs) {
            double[] input = new double[chks.length];
            this.initMap();
            for (int row = 0; row < chks[0]._len; ++row) {
                for (int i = 0; i < chks.length; ++i) {
                    input[i] = chks[i].atd(row);
                }
                int col = 0;
                for (int tidx = 0; tidx < this._treeKeys.length; ++tidx) {
                    Key<CompressedTree>[] keys = this._treeKeys[tidx];
                    for (int cls = 0; cls < keys.length; ++cls) {
                        Key<CompressedTree> key = keys[cls];
                        if (key == null) continue;
                        CompressedTree tree = (CompressedTree)DKV.get(key).get();
                        this.assignNode(tidx, cls, tree, input, ncs[col++]);
                    }
                }
                assert (col == ncs.length);
            }
        }

        protected abstract Frame execute(Frame var1, String[] var2, Key<Frame> var3);

        private static AssignLeafNodeTaskBase make(SharedTreeOutput modelOutput, Model.LeafNodeAssignment.LeafNodeAssignmentType type) {
            switch (type) {
                case Path: {
                    return new AssignTreePathTask(modelOutput);
                }
                case Node_ID: {
                    return new AssignLeafNodeIdTask(modelOutput);
                }
            }
            throw new UnsupportedOperationException("Unknown leaf node assignment type: " + type);
        }
    }

    public static class BufStringDecisionPathTracker
    implements SharedTreeMojoModel.DecisionPathTracker<BufferedString> {
        private final byte[] _buf = new byte[64];
        private final BufferedString _bs = new BufferedString(this._buf, 0, 0);
        private int _pos = 0;

        public boolean go(int depth, boolean right) {
            int n = this._buf[depth] = right ? 82 : 76;
            if (right) {
                this._pos = depth;
            }
            return true;
        }

        public BufferedString terminate() {
            this._bs.setLen(this._pos);
            this._pos = 0;
            return this._bs;
        }

        public BufferedString invalidPath() {
            return null;
        }
    }

    public static abstract class SharedTreeOutput
    extends Model.Output
    implements Model.GetNTrees,
    CalibrationHelper.OutputWithCalibration {
        public double _init_f;
        public int _ntrees = 0;
        public final TreeStats _treeStats;
        public Key<CompressedTree>[][] _treeKeys;
        public Key<CompressedTree>[][] _treeKeysAux;
        public ScoreKeeper[] _scored_train;
        public ScoreKeeper[] _scored_valid;
        public long[] _training_time_ms = new long[]{System.currentTimeMillis()};
        public TwoDimTable _variable_importances;
        public VarImp _varimp;
        public Model<?, ?, ?> _calib_model;

        public ScoreKeeper[] scoreKeepers() {
            ScoreKeeper[] ska;
            ArrayList<ScoreKeeper> skl = new ArrayList<ScoreKeeper>();
            for (ScoreKeeper sk : ska = this._validation_metrics != null ? this._scored_valid : this._scored_train) {
                if (sk.isEmpty()) continue;
                skl.add(sk);
            }
            return skl.toArray(new ScoreKeeper[skl.size()]);
        }

        public TwoDimTable getVariableImportances() {
            return this._variable_importances;
        }

        public SharedTreeOutput(SharedTree b) {
            super((ModelBuilder)b);
            this._treeKeys = new Key[this._ntrees][];
            this._treeKeysAux = new Key[this._ntrees][];
            this._treeStats = new TreeStats();
            this._scored_train = new ScoreKeeper[]{new ScoreKeeper(Double.NaN)};
            this._scored_valid = new ScoreKeeper[]{new ScoreKeeper(Double.NaN)};
            this._modelClassDist = this._priorClassDist;
        }

        public TwoDimTable createInputFramesInformationTable(ModelBuilder modelBuilder) {
            SharedTreeParameters params = (SharedTreeParameters)modelBuilder._parms;
            TwoDimTable table = super.createInputFramesInformationTable(modelBuilder);
            table.set(2, 0, (Object)"calibration_frame");
            table.set(2, 1, (Object)(params.getCalibrationFrame() != null ? params.getCalibrationFrame().checksum() : -1L));
            table.set(2, 2, params.getCalibrationFrame() != null ? Arrays.toString(params.getCalibrationFrame().anyVec().espc()) : Integer.valueOf(-1));
            return table;
        }

        public int getInformationTableNumRows() {
            return super.getInformationTableNumRows() + 1;
        }

        public void addKTrees(DTree[] trees) {
            assert (this.nclasses() == trees.length);
            this._treeKeys = (Key[][])Arrays.copyOf(this._treeKeys, this._ntrees + 1);
            this._treeKeysAux = (Key[][])Arrays.copyOf(this._treeKeysAux, this._ntrees + 1);
            this._treeKeys[this._ntrees] = new Key[trees.length];
            Key[] keys = this._treeKeys[this._ntrees];
            this._treeKeysAux[this._ntrees] = new Key[trees.length];
            Key[] keysAux = this._treeKeysAux[this._ntrees];
            Futures fs = new Futures();
            for (int i = 0; i < this.nclasses(); ++i) {
                if (trees[i] == null) continue;
                CompressedTree ct = trees[i].compress(this._ntrees, i, this._domains);
                keys[i] = ct._key;
                DKV.put((Key)keys[i], (Iced)ct, (Futures)fs);
                this._treeStats.updateBy(trees[i]);
                CompressedTree ctAux = new CompressedTree(trees[i]._abAux.buf(), -1L, -1, -1);
                keysAux[i] = ctAux._key = Key.make((String)GenModel.createAuxKey((String)ct._key.toString()));
                DKV.put((Keyed)ctAux, (Futures)fs);
            }
            ++this._ntrees;
            this._scored_train = (ScoreKeeper[])ArrayUtils.copyAndFillOf((Object[])this._scored_train, (int)(this._ntrees + 1), (Object)new ScoreKeeper());
            this._scored_valid = this._scored_valid != null ? (ScoreKeeper[])ArrayUtils.copyAndFillOf((Object[])this._scored_valid, (int)(this._ntrees + 1), (Object)new ScoreKeeper()) : null;
            this._training_time_ms = ArrayUtils.copyAndFillOf((long[])this._training_time_ms, (int)(this._ntrees + 1), (long)System.currentTimeMillis());
            fs.blockForPending();
        }

        public void trimTo(int ntrees) {
            Futures fs = new Futures();
            for (int i = ntrees; i < this._treeKeys.length; ++i) {
                for (int tc = 0; tc < this._treeKeys[i].length; ++tc) {
                    if (this._treeKeys[i][tc] == null) continue;
                    DKV.remove(this._treeKeys[i][tc], (Futures)fs);
                    DKV.remove(this._treeKeysAux[i][tc], (Futures)fs);
                }
            }
            this._ntrees = ntrees;
            this._treeKeys = (Key[][])Arrays.copyOf(this._treeKeys, this._ntrees);
            this._treeKeysAux = (Key[][])Arrays.copyOf(this._treeKeysAux, this._ntrees);
            this._scored_train = Arrays.copyOf(this._scored_train, this._ntrees + 1);
            this._scored_valid = this._scored_valid != null ? Arrays.copyOf(this._scored_valid, this._ntrees + 1) : null;
            this._training_time_ms = Arrays.copyOf(this._training_time_ms, this._ntrees + 1);
            this._model_summary = SharedTree.createModelSummaryTable(this._ntrees, this._treeStats);
            fs.blockForPending();
        }

        public int getNTrees() {
            return this._ntrees;
        }

        @Override
        public Model<?, ?, ?> calibrationModel() {
            return this._calib_model;
        }

        @Override
        public void setCalibrationModel(Model<?, ?, ?> model) {
            this._calib_model = model;
        }

        public CompressedTree ctree(int tnum, int knum) {
            return (CompressedTree)this._treeKeys[tnum][knum].get();
        }

        public String toStringTree(int tnum, int knum) {
            return this.ctree(tnum, knum).toString(this);
        }
    }

    public static abstract class SharedTreeParameters
    extends Model.Parameters
    implements Model.GetNTrees,
    CalibrationHelper.ParamsWithCalibration {
        public int _ntrees = 50;
        public int _max_depth = 5;
        public double _min_rows = 10.0;
        public int _nbins = 20;
        public int _nbins_cats = 1024;
        public double _min_split_improvement = 1.0E-5;
        public HistogramType _histogram_type = HistogramType.AUTO;
        public double _r2_stopping = Double.MAX_VALUE;
        public int _nbins_top_level = 1024;
        public boolean _build_tree_one_node = false;
        public int _score_tree_interval = 0;
        public int _initial_score_interval = 4000;
        public int _score_interval = 4000;
        public double _sample_rate = 0.632;
        public double[] _sample_rate_per_class;
        public boolean _calibrate_model;
        public Key<Frame> _calibration_frame;
        public CalibrationHelper.CalibrationMethod _calibration_method = CalibrationHelper.CalibrationMethod.AUTO;
        public double _col_sample_rate_change_per_level = 1.0;
        public double _col_sample_rate_per_tree = 1.0;
        public boolean _parallel_main_model_building = false;
        public boolean _use_best_cv_iteration = true;
        public String _in_training_checkpoints_dir;
        public int _in_training_checkpoints_tree_interval = 1;
        static final String[] CHECKPOINT_NON_MODIFIABLE_FIELDS = new String[]{"_build_tree_one_node", "_sample_rate", "_max_depth", "_min_rows", "_nbins", "_nbins_cats", "_nbins_top_level"};

        public boolean useRowSampling() {
            return this._sample_rate < 1.0 || this._sample_rate_per_class != null;
        }

        public long progressUnits() {
            return this._ntrees + (this._histogram_type == HistogramType.QuantilesGlobal || this._histogram_type == HistogramType.RoundRobin ? 1 : 0);
        }

        public boolean useColSampling() {
            return this._col_sample_rate_change_per_level != 1.0 || this._col_sample_rate_per_tree != 1.0;
        }

        public boolean isStochastic() {
            return this.useRowSampling() || this.useColSampling();
        }

        public int getNTrees() {
            return this._ntrees;
        }

        @Override
        public Frame getCalibrationFrame() {
            return this._calibration_frame == null ? null : (Frame)this._calibration_frame.get();
        }

        @Override
        public boolean calibrateModel() {
            return this._calibrate_model;
        }

        @Override
        public CalibrationHelper.CalibrationMethod getCalibrationMethod() {
            return this._calibration_method;
        }

        @Override
        public void setCalibrationMethod(CalibrationHelper.CalibrationMethod calibrationMethod) {
            this._calibration_method = calibrationMethod;
        }

        @Override
        public Model.Parameters getParams() {
            return this;
        }

        public boolean forceStrictlyReproducibleHistograms() {
            return false;
        }

        public static enum HistogramType {
            AUTO,
            UniformAdaptive,
            Random,
            QuantilesGlobal,
            RoundRobin,
            UniformRobust;

            public static HistogramType[] ROUND_ROBIN_CANDIDATES;

            static {
                ROUND_ROBIN_CANDIDATES = new HistogramType[]{AUTO, UniformAdaptive, Random, QuantilesGlobal};
            }
        }
    }
}

