/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isoforextended.isolationtree;

import hex.tree.isoforextended.isolationtree.AbstractCompressedNode;
import hex.tree.isoforextended.isolationtree.IsolationTree;
import java.util.Arrays;
import water.AutoBuffer;

public class CompressedNode
extends AbstractCompressedNode {
    private final double[] _n;
    private final double[] _p;

    public CompressedNode(IsolationTree.Node node) {
        this(node.getN(), node.getP(), node.getHeight());
    }

    public CompressedNode(double[] n, double[] p, int currentHeight) {
        super(currentHeight);
        this._n = n == null ? null : Arrays.copyOf(n, n.length);
        this._p = p == null ? null : Arrays.copyOf(p, p.length);
    }

    public double[] getN() {
        return this._n;
    }

    public double[] getP() {
        return this._p;
    }

    @Override
    public void toBytes(AutoBuffer ab) {
        ab.put1(78);
        for (double v : this._n) {
            ab.put8d(v);
        }
        for (double v : this._p) {
            ab.put8d(v);
        }
    }
}

