/*
 * Decompiled with CFR 0.152.
 */
package hex.adaboost;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.adaboost.AdaBoost;
import org.apache.log4j.Logger;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Key;
import water.Keyed;

public class AdaBoostModel
extends Model<AdaBoostModel, AdaBoostParameters, AdaBoostOutput> {
    private static final Logger LOG = Logger.getLogger(AdaBoostModel.class);

    public AdaBoostModel(Key<AdaBoostModel> selfKey, AdaBoostParameters parms, AdaBoostOutput output) {
        super(selfKey, (Model.Parameters)parms, (Model.Output)output);
    }

    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        if (((AdaBoostOutput)this._output).getModelCategory() == ModelCategory.Binomial) {
            return new ModelMetricsBinomial.MetricBuilderBinomial(domain);
        }
        throw H2O.unimpl((String)"AdaBoost currently support only binary classification");
    }

    protected String[] makeScoringNames() {
        return new String[]{"predict", "p0", "p1"};
    }

    protected double[] score0(double[] data, double[] preds) {
        double alphas0 = 0.0;
        double alphas1 = 0.0;
        double linearCombination = 0.0;
        for (int i = 0; i < ((AdaBoostOutput)this._output).alphas.length; ++i) {
            Model model = (Model)DKV.getGet(((AdaBoostOutput)this._output).models[i]);
            if (model.score(data) == 0.0) {
                linearCombination += ((AdaBoostOutput)this._output).alphas[i] * -1.0;
                alphas0 += ((AdaBoostOutput)this._output).alphas[i];
                continue;
            }
            linearCombination += ((AdaBoostOutput)this._output).alphas[i];
            alphas1 += ((AdaBoostOutput)this._output).alphas[i];
        }
        preds[0] = alphas0 > alphas1 ? 0.0 : 1.0;
        preds[2] = 1.0 / (1.0 + Math.exp(-2.0 * linearCombination));
        preds[1] = 1.0 - preds[2];
        return preds;
    }

    protected boolean needsPostProcess() {
        return false;
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        for (Key<Model> iTreeKey : ((AdaBoostOutput)this._output).models) {
            Keyed.remove(iTreeKey, (Futures)fs, (boolean)true);
        }
        return super.remove_impl(fs, cascade);
    }

    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        for (Key<Model> iTreeKey : ((AdaBoostOutput)this._output).models) {
            ab.putKey(iTreeKey);
        }
        return super.writeAll_impl(ab);
    }

    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        for (Key<Model> iTreeKey : ((AdaBoostOutput)this._output).models) {
            ab.getKey(iTreeKey, fs);
        }
        return super.readAll_impl(ab, fs);
    }

    public static class AdaBoostParameters
    extends Model.Parameters {
        public int _nlearners = 50;
        public Algorithm _weak_learner = Algorithm.AUTO;
        public double _learn_rate = 0.5;

        public String algoName() {
            return "AdaBoost";
        }

        public String fullName() {
            return "AdaBoost";
        }

        public String javaName() {
            return AdaBoostModel.class.getName();
        }

        public long progressUnits() {
            return this._nlearners;
        }
    }

    public static class AdaBoostOutput
    extends Model.Output {
        public double[] alphas;
        public Key<Model>[] models;

        public AdaBoostOutput(AdaBoost adaBoostModel) {
            super((ModelBuilder)adaBoostModel);
        }
    }

    public static enum Algorithm {
        DRF,
        GLM,
        GBM,
        AUTO;

    }
}

