/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.dt.binning;

import hex.tree.dt.AbstractSplittingRule;
import org.apache.commons.math3.util.Precision;

public class SplitStatistics {
    public AbstractSplittingRule _splittingRule;
    public int _leftCount = 0;
    public int _leftCount0 = 0;
    public int _rightCount = 0;
    public int _rightCount0 = 0;

    public void accumulateLeftStatistics(int leftCount, int leftCount0) {
        this._leftCount += leftCount;
        this._leftCount0 += leftCount0;
    }

    public void accumulateRightStatistics(int rightCount, int rightCount0) {
        this._rightCount += rightCount;
        this._rightCount0 += rightCount0;
    }

    public void copyLeftValues(SplitStatistics toCopy) {
        this._leftCount = toCopy._leftCount;
        this._leftCount0 = toCopy._leftCount0;
    }

    public void copyRightValues(SplitStatistics toCopy) {
        this._rightCount = toCopy._rightCount;
        this._rightCount0 = toCopy._rightCount0;
    }

    public SplitStatistics setCriterionValue(double criterionOfSplit) {
        this._splittingRule.setCriterionValue(criterionOfSplit);
        return this;
    }

    public SplitStatistics setFeatureIndex(int featureIndex) {
        this._splittingRule.setFeatureIndex(featureIndex);
        return this;
    }

    public static double entropyBinarySplit(double oneClassFrequency) {
        return -1.0 * ((oneClassFrequency < Precision.EPSILON ? 0.0 : oneClassFrequency * Math.log(oneClassFrequency)) + (1.0 - oneClassFrequency < Precision.EPSILON ? 0.0 : (1.0 - oneClassFrequency) * Math.log(1.0 - oneClassFrequency)));
    }

    public Double binaryEntropy() {
        double a1 = SplitStatistics.entropyBinarySplit((double)this._leftCount0 * 1.0 / (double)this._leftCount) * (double)this._leftCount / (double)(this._leftCount + this._rightCount);
        double a2 = SplitStatistics.entropyBinarySplit((double)this._rightCount0 * 1.0 / (double)this._rightCount) * (double)this._rightCount / (double)(this._leftCount + this._rightCount);
        return a1 + a2;
    }
}

