/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.MatrixFrameUtils;

import hex.genmodel.algos.gam.ISplines;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;

public class AddISGamColumns
extends MRTask<AddISGamColumns> {
    double[][][] _knotsMat;
    int[] _numKnots;
    int[] _numBasis;
    public int _numGAMCols;
    int[] _gamColsOffsets;
    Frame _gamFrame;
    int[] _bs;
    int[] _splineOrder;
    int _totGamifiedCols = 0;
    public int _totGamifiedColCentered = 0;

    public AddISGamColumns(double[][][] knotsMat, int[] numKnot, int[] bs, int[] splineOrder, Frame gamColFrames) {
        this._gamFrame = gamColFrames;
        this._numGAMCols = gamColFrames.numCols();
        this._gamColsOffsets = MemoryManager.malloc4((int)this._numGAMCols);
        this._knotsMat = new double[this._numGAMCols][][];
        this._bs = new int[this._numGAMCols];
        this._splineOrder = new int[this._numGAMCols];
        this._numKnots = new int[this._numGAMCols];
        this._numBasis = new int[this._numGAMCols];
        int totGamCols = bs.length;
        int countIS = 0;
        int offset = 0;
        for (int index = 0; index < totGamCols; ++index) {
            if (bs[index] != 2) continue;
            int numBasis = numKnot[index] + splineOrder[index] - 2;
            this._totGamifiedCols += numBasis;
            this._totGamifiedColCentered += numBasis;
            this._knotsMat[countIS] = knotsMat[index];
            this._bs[countIS] = bs[index];
            this._numKnots[countIS] = numKnot[index];
            this._numBasis[countIS] = numBasis;
            this._splineOrder[countIS] = splineOrder[index];
            this._gamColsOffsets[countIS++] = offset;
            offset += numBasis;
        }
    }

    public void map(Chunk[] chk, NewChunk[] newChunks) {
        ISplines[] isBasis = new ISplines[this._numGAMCols];
        double[][] basisVals = new double[this._numGAMCols][];
        for (int index = 0; index < this._numGAMCols; ++index) {
            isBasis[index] = new ISplines(this._splineOrder[index], this._knotsMat[index][0]);
            basisVals[index] = MemoryManager.malloc8d((int)this._numBasis[index]);
        }
        int chkLen = chk[0].len();
        for (int rInd = 0; rInd < chkLen; ++rInd) {
            for (int cInd = 0; cInd < this._numGAMCols; ++cInd) {
                this.generateOneISGAMCols(cInd, this._gamColsOffsets[cInd], basisVals[cInd], isBasis[cInd], chk[cInd].atd(rInd), newChunks);
            }
        }
    }

    public void generateOneISGAMCols(int colInd, int colOffset, double[] basisVals, ISplines isBasis, double xval, NewChunk[] newChunks) {
        int numVals = this._numBasis[colInd];
        if (!Double.isNaN(xval)) {
            isBasis.gamifyVal(basisVals, xval);
            for (int colIndex = 0; colIndex < numVals; ++colIndex) {
                newChunks[colIndex + colOffset].addNum(basisVals[colIndex]);
            }
        } else {
            for (int colIndex = 0; colIndex < numVals; ++colIndex) {
                newChunks[colIndex + colOffset].addNum(Double.NaN);
            }
        }
    }
}

