/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.MatrixFrameUtils;

import hex.genmodel.algos.gam.MSplines;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.util.ArrayUtils;

public class AddMSGamColumns
extends MRTask<AddMSGamColumns> {
    double[][][] _knotsMat;
    int[] _numKnots;
    int[] _numBasis;
    public int _numGAMCols;
    int[] _gamColsOffsets;
    Frame _gamFrame;
    int[] _bs;
    int[] _splineOrder;
    int _totGamifiedCols = 0;
    public int _totGamifiedColCentered = 0;
    final double[][][] _ztransp;

    public AddMSGamColumns(double[][][] knotsMat, double[][][] ztransp, int[] numKnot, int[] bs, int[] splineOrder, Frame gamColFrames) {
        this._gamFrame = gamColFrames;
        this._numGAMCols = gamColFrames.numCols();
        this._gamColsOffsets = MemoryManager.malloc4((int)this._numGAMCols);
        this._knotsMat = new double[this._numGAMCols][][];
        this._bs = new int[this._numGAMCols];
        this._splineOrder = new int[this._numGAMCols];
        this._numKnots = new int[this._numGAMCols];
        this._numBasis = new int[this._numGAMCols];
        this._ztransp = new double[this._numGAMCols][][];
        int totGamCols = bs.length;
        int countMS = 0;
        int offset = 0;
        for (int index = 0; index < totGamCols; ++index) {
            if (bs[index] != 3) continue;
            int numBasis = numKnot[index] + splineOrder[index] - 2;
            int numBasisM1 = numBasis - 1;
            this._totGamifiedCols += numBasis;
            this._totGamifiedColCentered += numBasisM1;
            this._knotsMat[countMS] = knotsMat[index];
            this._bs[countMS] = bs[index];
            this._numKnots[countMS] = numKnot[index];
            this._numBasis[countMS] = numBasis;
            this._splineOrder[countMS] = splineOrder[index];
            this._ztransp[countMS] = ztransp[index];
            this._gamColsOffsets[countMS++] = offset;
            offset += numBasisM1;
        }
    }

    public void map(Chunk[] chk, NewChunk[] newChunks) {
        MSplines[] msBasis = new MSplines[this._numGAMCols];
        double[][] basisVals = new double[this._numGAMCols][];
        double[][] basisValsCenter = new double[this._numGAMCols][];
        for (int index = 0; index < this._numGAMCols; ++index) {
            msBasis[index] = new MSplines(this._splineOrder[index], this._knotsMat[index][0]);
            basisVals[index] = MemoryManager.malloc8d((int)this._numBasis[index]);
            basisValsCenter[index] = MemoryManager.malloc8d((int)(this._numBasis[index] - 1));
        }
        int chkLen = chk[0].len();
        for (int rInd = 0; rInd < chkLen; ++rInd) {
            for (int cInd = 0; cInd < this._numGAMCols; ++cInd) {
                this.generateOneMSGAMCols(cInd, this._gamColsOffsets[cInd], basisVals[cInd], basisValsCenter[cInd], msBasis[cInd], chk[cInd].atd(rInd), newChunks);
            }
        }
    }

    public void generateOneMSGAMCols(int colInd, int colOffset, double[] basisVals, double[] basisValsCenter, MSplines msBasis, double xval, NewChunk[] newChunks) {
        int numVals = this._numBasis[colInd] - 1;
        if (!Double.isNaN(xval)) {
            msBasis.gamifyVal(basisVals, xval);
            basisValsCenter = ArrayUtils.multArrVec((double[][])this._ztransp[colInd], (double[])basisVals, (double[])basisValsCenter);
            for (int colIndex = 0; colIndex < numVals; ++colIndex) {
                newChunks[colIndex + colOffset].addNum(basisValsCenter[colIndex]);
            }
        } else {
            for (int colIndex = 0; colIndex < numVals; ++colIndex) {
                newChunks[colIndex + colOffset].addNum(Double.NaN);
            }
        }
    }
}

